<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessInstanceNode StructType
 * @subpackage Structs
 */
class ProcessInstanceNode extends SObject
{
    /**
     * The CompletedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompletedDate;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The ElapsedTimeInDays
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ElapsedTimeInDays;
    /**
     * The ElapsedTimeInHours
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ElapsedTimeInHours;
    /**
     * The ElapsedTimeInMinutes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ElapsedTimeInMinutes;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The LastActor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastActor;
    /**
     * The LastActorId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastActorId;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The NodeStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NodeStatus;
    /**
     * The ProcessInstance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public $ProcessInstance;
    /**
     * The ProcessInstanceId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ProcessInstanceId;
    /**
     * The ProcessNode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ProcessNode
     */
    public $ProcessNode;
    /**
     * The ProcessNodeId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ProcessNodeId;
    /**
     * The ProcessNodeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProcessNodeName;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The UserRecordAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public $UserRecordAccess;
    /**
     * Constructor method for ProcessInstanceNode
     * @uses ProcessInstanceNode::setCompletedDate()
     * @uses ProcessInstanceNode::setCreatedBy()
     * @uses ProcessInstanceNode::setCreatedById()
     * @uses ProcessInstanceNode::setCreatedDate()
     * @uses ProcessInstanceNode::setElapsedTimeInDays()
     * @uses ProcessInstanceNode::setElapsedTimeInHours()
     * @uses ProcessInstanceNode::setElapsedTimeInMinutes()
     * @uses ProcessInstanceNode::setIsDeleted()
     * @uses ProcessInstanceNode::setLastActor()
     * @uses ProcessInstanceNode::setLastActorId()
     * @uses ProcessInstanceNode::setLastModifiedBy()
     * @uses ProcessInstanceNode::setLastModifiedById()
     * @uses ProcessInstanceNode::setLastModifiedDate()
     * @uses ProcessInstanceNode::setNodeStatus()
     * @uses ProcessInstanceNode::setProcessInstance()
     * @uses ProcessInstanceNode::setProcessInstanceId()
     * @uses ProcessInstanceNode::setProcessNode()
     * @uses ProcessInstanceNode::setProcessNodeId()
     * @uses ProcessInstanceNode::setProcessNodeName()
     * @uses ProcessInstanceNode::setSystemModstamp()
     * @uses ProcessInstanceNode::setUserRecordAccess()
     * @param string $completedDate
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param float $elapsedTimeInDays
     * @param float $elapsedTimeInHours
     * @param float $elapsedTimeInMinutes
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\User $lastActor
     * @param string $lastActorId
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $nodeStatus
     * @param \NexusDigital/MiratelForce\StructType\ProcessInstance $processInstance
     * @param string $processInstanceId
     * @param \NexusDigital/MiratelForce\StructType\ProcessNode $processNode
     * @param string $processNodeId
     * @param string $processNodeName
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     */
    public function __construct($completedDate = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $elapsedTimeInDays = null, $elapsedTimeInHours = null, $elapsedTimeInMinutes = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\User $lastActor = null, $lastActorId = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $nodeStatus = null, \NexusDigital/MiratelForce\StructType\ProcessInstance $processInstance = null, $processInstanceId = null, \NexusDigital/MiratelForce\StructType\ProcessNode $processNode = null, $processNodeId = null, $processNodeName = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        $this
            ->setCompletedDate($completedDate)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setElapsedTimeInDays($elapsedTimeInDays)
            ->setElapsedTimeInHours($elapsedTimeInHours)
            ->setElapsedTimeInMinutes($elapsedTimeInMinutes)
            ->setIsDeleted($isDeleted)
            ->setLastActor($lastActor)
            ->setLastActorId($lastActorId)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setNodeStatus($nodeStatus)
            ->setProcessInstance($processInstance)
            ->setProcessInstanceId($processInstanceId)
            ->setProcessNode($processNode)
            ->setProcessNodeId($processNodeId)
            ->setProcessNodeName($processNodeName)
            ->setSystemModstamp($systemModstamp)
            ->setUserRecordAccess($userRecordAccess);
    }
    /**
     * Get CompletedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompletedDate()
    {
        return isset($this->CompletedDate) ? $this->CompletedDate : null;
    }
    /**
     * Set CompletedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $completedDate
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setCompletedDate($completedDate = null)
    {
        // validation for constraint: string
        if (!is_null($completedDate) && !is_string($completedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($completedDate, true), gettype($completedDate)), __LINE__);
        }
        if (is_null($completedDate) || (is_array($completedDate) && empty($completedDate))) {
            unset($this->CompletedDate);
        } else {
            $this->CompletedDate = $completedDate;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get ElapsedTimeInDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getElapsedTimeInDays()
    {
        return isset($this->ElapsedTimeInDays) ? $this->ElapsedTimeInDays : null;
    }
    /**
     * Set ElapsedTimeInDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $elapsedTimeInDays
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setElapsedTimeInDays($elapsedTimeInDays = null)
    {
        // validation for constraint: float
        if (!is_null($elapsedTimeInDays) && !(is_float($elapsedTimeInDays) || is_numeric($elapsedTimeInDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($elapsedTimeInDays, true), gettype($elapsedTimeInDays)), __LINE__);
        }
        if (is_null($elapsedTimeInDays) || (is_array($elapsedTimeInDays) && empty($elapsedTimeInDays))) {
            unset($this->ElapsedTimeInDays);
        } else {
            $this->ElapsedTimeInDays = $elapsedTimeInDays;
        }
        return $this;
    }
    /**
     * Get ElapsedTimeInHours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getElapsedTimeInHours()
    {
        return isset($this->ElapsedTimeInHours) ? $this->ElapsedTimeInHours : null;
    }
    /**
     * Set ElapsedTimeInHours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $elapsedTimeInHours
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setElapsedTimeInHours($elapsedTimeInHours = null)
    {
        // validation for constraint: float
        if (!is_null($elapsedTimeInHours) && !(is_float($elapsedTimeInHours) || is_numeric($elapsedTimeInHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($elapsedTimeInHours, true), gettype($elapsedTimeInHours)), __LINE__);
        }
        if (is_null($elapsedTimeInHours) || (is_array($elapsedTimeInHours) && empty($elapsedTimeInHours))) {
            unset($this->ElapsedTimeInHours);
        } else {
            $this->ElapsedTimeInHours = $elapsedTimeInHours;
        }
        return $this;
    }
    /**
     * Get ElapsedTimeInMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getElapsedTimeInMinutes()
    {
        return isset($this->ElapsedTimeInMinutes) ? $this->ElapsedTimeInMinutes : null;
    }
    /**
     * Set ElapsedTimeInMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $elapsedTimeInMinutes
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setElapsedTimeInMinutes($elapsedTimeInMinutes = null)
    {
        // validation for constraint: float
        if (!is_null($elapsedTimeInMinutes) && !(is_float($elapsedTimeInMinutes) || is_numeric($elapsedTimeInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($elapsedTimeInMinutes, true), gettype($elapsedTimeInMinutes)), __LINE__);
        }
        if (is_null($elapsedTimeInMinutes) || (is_array($elapsedTimeInMinutes) && empty($elapsedTimeInMinutes))) {
            unset($this->ElapsedTimeInMinutes);
        } else {
            $this->ElapsedTimeInMinutes = $elapsedTimeInMinutes;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get LastActor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastActor()
    {
        return isset($this->LastActor) ? $this->LastActor : null;
    }
    /**
     * Set LastActor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastActor
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setLastActor(\NexusDigital/MiratelForce\StructType\User $lastActor = null)
    {
        if (is_null($lastActor) || (is_array($lastActor) && empty($lastActor))) {
            unset($this->LastActor);
        } else {
            $this->LastActor = $lastActor;
        }
        return $this;
    }
    /**
     * Get LastActorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastActorId()
    {
        return isset($this->LastActorId) ? $this->LastActorId : null;
    }
    /**
     * Set LastActorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastActorId
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setLastActorId($lastActorId = null)
    {
        // validation for constraint: string
        if (!is_null($lastActorId) && !is_string($lastActorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastActorId, true), gettype($lastActorId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastActorId) && mb_strlen($lastActorId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastActorId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastActorId) && !preg_match('/[a-zA-Z0-9]{18}/', $lastActorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastActorId, true)), __LINE__);
        }
        if (is_null($lastActorId) || (is_array($lastActorId) && empty($lastActorId))) {
            unset($this->LastActorId);
        } else {
            $this->LastActorId = $lastActorId;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get NodeStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNodeStatus()
    {
        return isset($this->NodeStatus) ? $this->NodeStatus : null;
    }
    /**
     * Set NodeStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nodeStatus
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setNodeStatus($nodeStatus = null)
    {
        // validation for constraint: string
        if (!is_null($nodeStatus) && !is_string($nodeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nodeStatus, true), gettype($nodeStatus)), __LINE__);
        }
        if (is_null($nodeStatus) || (is_array($nodeStatus) && empty($nodeStatus))) {
            unset($this->NodeStatus);
        } else {
            $this->NodeStatus = $nodeStatus;
        }
        return $this;
    }
    /**
     * Get ProcessInstance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance|null
     */
    public function getProcessInstance()
    {
        return isset($this->ProcessInstance) ? $this->ProcessInstance : null;
    }
    /**
     * Set ProcessInstance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ProcessInstance $processInstance
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setProcessInstance(\NexusDigital/MiratelForce\StructType\ProcessInstance $processInstance = null)
    {
        if (is_null($processInstance) || (is_array($processInstance) && empty($processInstance))) {
            unset($this->ProcessInstance);
        } else {
            $this->ProcessInstance = $processInstance;
        }
        return $this;
    }
    /**
     * Get ProcessInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessInstanceId()
    {
        return isset($this->ProcessInstanceId) ? $this->ProcessInstanceId : null;
    }
    /**
     * Set ProcessInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processInstanceId
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setProcessInstanceId($processInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($processInstanceId) && !is_string($processInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processInstanceId, true), gettype($processInstanceId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($processInstanceId) && mb_strlen($processInstanceId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($processInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($processInstanceId) && !preg_match('/[a-zA-Z0-9]{18}/', $processInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($processInstanceId, true)), __LINE__);
        }
        if (is_null($processInstanceId) || (is_array($processInstanceId) && empty($processInstanceId))) {
            unset($this->ProcessInstanceId);
        } else {
            $this->ProcessInstanceId = $processInstanceId;
        }
        return $this;
    }
    /**
     * Get ProcessNode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ProcessNode|null
     */
    public function getProcessNode()
    {
        return isset($this->ProcessNode) ? $this->ProcessNode : null;
    }
    /**
     * Set ProcessNode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ProcessNode $processNode
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setProcessNode(\NexusDigital/MiratelForce\StructType\ProcessNode $processNode = null)
    {
        if (is_null($processNode) || (is_array($processNode) && empty($processNode))) {
            unset($this->ProcessNode);
        } else {
            $this->ProcessNode = $processNode;
        }
        return $this;
    }
    /**
     * Get ProcessNodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessNodeId()
    {
        return isset($this->ProcessNodeId) ? $this->ProcessNodeId : null;
    }
    /**
     * Set ProcessNodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processNodeId
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setProcessNodeId($processNodeId = null)
    {
        // validation for constraint: string
        if (!is_null($processNodeId) && !is_string($processNodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processNodeId, true), gettype($processNodeId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($processNodeId) && mb_strlen($processNodeId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($processNodeId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($processNodeId) && !preg_match('/[a-zA-Z0-9]{18}/', $processNodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($processNodeId, true)), __LINE__);
        }
        if (is_null($processNodeId) || (is_array($processNodeId) && empty($processNodeId))) {
            unset($this->ProcessNodeId);
        } else {
            $this->ProcessNodeId = $processNodeId;
        }
        return $this;
    }
    /**
     * Get ProcessNodeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessNodeName()
    {
        return isset($this->ProcessNodeName) ? $this->ProcessNodeName : null;
    }
    /**
     * Set ProcessNodeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processNodeName
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setProcessNodeName($processNodeName = null)
    {
        // validation for constraint: string
        if (!is_null($processNodeName) && !is_string($processNodeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processNodeName, true), gettype($processNodeName)), __LINE__);
        }
        if (is_null($processNodeName) || (is_array($processNodeName) && empty($processNodeName))) {
            unset($this->ProcessNodeName);
        } else {
            $this->ProcessNodeName = $processNodeName;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get UserRecordAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess|null
     */
    public function getUserRecordAccess()
    {
        return isset($this->UserRecordAccess) ? $this->UserRecordAccess : null;
    }
    /**
     * Set UserRecordAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public function setUserRecordAccess(\NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        if (is_null($userRecordAccess) || (is_array($userRecordAccess) && empty($userRecordAccess))) {
            unset($this->UserRecordAccess);
        } else {
            $this->UserRecordAccess = $userRecordAccess;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceNode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
