<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlatformStatusAlertEvent StructType
 * @subpackage Structs
 */
class PlatformStatusAlertEvent extends SObject
{
    /**
     * The ApiErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApiErrorCode;
    /**
     * The ComponentName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ComponentName;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The EventDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventIdentifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventIdentifier;
    /**
     * The ExtendedErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedErrorCode;
    /**
     * The RelatedEventIdentifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedEventIdentifier;
    /**
     * The ReplayId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReplayId;
    /**
     * The RequestId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestId;
    /**
     * The ServiceJobId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceJobId;
    /**
     * The ServiceName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceName;
    /**
     * The StatusType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusType;
    /**
     * The SubComponentName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubComponentName;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Subject;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $User;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserId;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Username;
    /**
     * Constructor method for PlatformStatusAlertEvent
     * @uses PlatformStatusAlertEvent::setApiErrorCode()
     * @uses PlatformStatusAlertEvent::setComponentName()
     * @uses PlatformStatusAlertEvent::setCreatedBy()
     * @uses PlatformStatusAlertEvent::setCreatedById()
     * @uses PlatformStatusAlertEvent::setCreatedDate()
     * @uses PlatformStatusAlertEvent::setEventDate()
     * @uses PlatformStatusAlertEvent::setEventIdentifier()
     * @uses PlatformStatusAlertEvent::setExtendedErrorCode()
     * @uses PlatformStatusAlertEvent::setRelatedEventIdentifier()
     * @uses PlatformStatusAlertEvent::setReplayId()
     * @uses PlatformStatusAlertEvent::setRequestId()
     * @uses PlatformStatusAlertEvent::setServiceJobId()
     * @uses PlatformStatusAlertEvent::setServiceName()
     * @uses PlatformStatusAlertEvent::setStatusType()
     * @uses PlatformStatusAlertEvent::setSubComponentName()
     * @uses PlatformStatusAlertEvent::setSubject()
     * @uses PlatformStatusAlertEvent::setUser()
     * @uses PlatformStatusAlertEvent::setUserId()
     * @uses PlatformStatusAlertEvent::setUsername()
     * @param string $apiErrorCode
     * @param string $componentName
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $eventDate
     * @param string $eventIdentifier
     * @param string $extendedErrorCode
     * @param string $relatedEventIdentifier
     * @param string $replayId
     * @param string $requestId
     * @param string $serviceJobId
     * @param string $serviceName
     * @param string $statusType
     * @param string $subComponentName
     * @param string $subject
     * @param \NexusDigital/MiratelForce\StructType\SObject $user
     * @param string $userId
     * @param string $username
     */
    public function __construct($apiErrorCode = null, $componentName = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $eventDate = null, $eventIdentifier = null, $extendedErrorCode = null, $relatedEventIdentifier = null, $replayId = null, $requestId = null, $serviceJobId = null, $serviceName = null, $statusType = null, $subComponentName = null, $subject = null, \NexusDigital/MiratelForce\StructType\SObject $user = null, $userId = null, $username = null)
    {
        $this
            ->setApiErrorCode($apiErrorCode)
            ->setComponentName($componentName)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setEventDate($eventDate)
            ->setEventIdentifier($eventIdentifier)
            ->setExtendedErrorCode($extendedErrorCode)
            ->setRelatedEventIdentifier($relatedEventIdentifier)
            ->setReplayId($replayId)
            ->setRequestId($requestId)
            ->setServiceJobId($serviceJobId)
            ->setServiceName($serviceName)
            ->setStatusType($statusType)
            ->setSubComponentName($subComponentName)
            ->setSubject($subject)
            ->setUser($user)
            ->setUserId($userId)
            ->setUsername($username);
    }
    /**
     * Get ApiErrorCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApiErrorCode()
    {
        return isset($this->ApiErrorCode) ? $this->ApiErrorCode : null;
    }
    /**
     * Set ApiErrorCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apiErrorCode
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setApiErrorCode($apiErrorCode = null)
    {
        // validation for constraint: string
        if (!is_null($apiErrorCode) && !is_string($apiErrorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiErrorCode, true), gettype($apiErrorCode)), __LINE__);
        }
        if (is_null($apiErrorCode) || (is_array($apiErrorCode) && empty($apiErrorCode))) {
            unset($this->ApiErrorCode);
        } else {
            $this->ApiErrorCode = $apiErrorCode;
        }
        return $this;
    }
    /**
     * Get ComponentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComponentName()
    {
        return isset($this->ComponentName) ? $this->ComponentName : null;
    }
    /**
     * Set ComponentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $componentName
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setComponentName($componentName = null)
    {
        // validation for constraint: string
        if (!is_null($componentName) && !is_string($componentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($componentName, true), gettype($componentName)), __LINE__);
        }
        if (is_null($componentName) || (is_array($componentName) && empty($componentName))) {
            unset($this->ComponentName);
        } else {
            $this->ComponentName = $componentName;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventIdentifier()
    {
        return isset($this->EventIdentifier) ? $this->EventIdentifier : null;
    }
    /**
     * Set EventIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventIdentifier
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setEventIdentifier($eventIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($eventIdentifier) && !is_string($eventIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventIdentifier, true), gettype($eventIdentifier)), __LINE__);
        }
        if (is_null($eventIdentifier) || (is_array($eventIdentifier) && empty($eventIdentifier))) {
            unset($this->EventIdentifier);
        } else {
            $this->EventIdentifier = $eventIdentifier;
        }
        return $this;
    }
    /**
     * Get ExtendedErrorCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedErrorCode()
    {
        return isset($this->ExtendedErrorCode) ? $this->ExtendedErrorCode : null;
    }
    /**
     * Set ExtendedErrorCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedErrorCode
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setExtendedErrorCode($extendedErrorCode = null)
    {
        // validation for constraint: string
        if (!is_null($extendedErrorCode) && !is_string($extendedErrorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedErrorCode, true), gettype($extendedErrorCode)), __LINE__);
        }
        if (is_null($extendedErrorCode) || (is_array($extendedErrorCode) && empty($extendedErrorCode))) {
            unset($this->ExtendedErrorCode);
        } else {
            $this->ExtendedErrorCode = $extendedErrorCode;
        }
        return $this;
    }
    /**
     * Get RelatedEventIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedEventIdentifier()
    {
        return isset($this->RelatedEventIdentifier) ? $this->RelatedEventIdentifier : null;
    }
    /**
     * Set RelatedEventIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedEventIdentifier
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setRelatedEventIdentifier($relatedEventIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($relatedEventIdentifier) && !is_string($relatedEventIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedEventIdentifier, true), gettype($relatedEventIdentifier)), __LINE__);
        }
        if (is_null($relatedEventIdentifier) || (is_array($relatedEventIdentifier) && empty($relatedEventIdentifier))) {
            unset($this->RelatedEventIdentifier);
        } else {
            $this->RelatedEventIdentifier = $relatedEventIdentifier;
        }
        return $this;
    }
    /**
     * Get ReplayId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReplayId()
    {
        return isset($this->ReplayId) ? $this->ReplayId : null;
    }
    /**
     * Set ReplayId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $replayId
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setReplayId($replayId = null)
    {
        // validation for constraint: string
        if (!is_null($replayId) && !is_string($replayId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replayId, true), gettype($replayId)), __LINE__);
        }
        if (is_null($replayId) || (is_array($replayId) && empty($replayId))) {
            unset($this->ReplayId);
        } else {
            $this->ReplayId = $replayId;
        }
        return $this;
    }
    /**
     * Get RequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestId()
    {
        return isset($this->RequestId) ? $this->RequestId : null;
    }
    /**
     * Set RequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestId
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        if (is_null($requestId) || (is_array($requestId) && empty($requestId))) {
            unset($this->RequestId);
        } else {
            $this->RequestId = $requestId;
        }
        return $this;
    }
    /**
     * Get ServiceJobId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceJobId()
    {
        return isset($this->ServiceJobId) ? $this->ServiceJobId : null;
    }
    /**
     * Set ServiceJobId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceJobId
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setServiceJobId($serviceJobId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceJobId) && !is_string($serviceJobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceJobId, true), gettype($serviceJobId)), __LINE__);
        }
        if (is_null($serviceJobId) || (is_array($serviceJobId) && empty($serviceJobId))) {
            unset($this->ServiceJobId);
        } else {
            $this->ServiceJobId = $serviceJobId;
        }
        return $this;
    }
    /**
     * Get ServiceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceName()
    {
        return isset($this->ServiceName) ? $this->ServiceName : null;
    }
    /**
     * Set ServiceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceName
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceName, true), gettype($serviceName)), __LINE__);
        }
        if (is_null($serviceName) || (is_array($serviceName) && empty($serviceName))) {
            unset($this->ServiceName);
        } else {
            $this->ServiceName = $serviceName;
        }
        return $this;
    }
    /**
     * Get StatusType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusType()
    {
        return isset($this->StatusType) ? $this->StatusType : null;
    }
    /**
     * Set StatusType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusType
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setStatusType($statusType = null)
    {
        // validation for constraint: string
        if (!is_null($statusType) && !is_string($statusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusType, true), gettype($statusType)), __LINE__);
        }
        if (is_null($statusType) || (is_array($statusType) && empty($statusType))) {
            unset($this->StatusType);
        } else {
            $this->StatusType = $statusType;
        }
        return $this;
    }
    /**
     * Get SubComponentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubComponentName()
    {
        return isset($this->SubComponentName) ? $this->SubComponentName : null;
    }
    /**
     * Set SubComponentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subComponentName
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setSubComponentName($subComponentName = null)
    {
        // validation for constraint: string
        if (!is_null($subComponentName) && !is_string($subComponentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subComponentName, true), gettype($subComponentName)), __LINE__);
        }
        if (is_null($subComponentName) || (is_array($subComponentName) && empty($subComponentName))) {
            unset($this->SubComponentName);
        } else {
            $this->SubComponentName = $subComponentName;
        }
        return $this;
    }
    /**
     * Get Subject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubject()
    {
        return isset($this->Subject) ? $this->Subject : null;
    }
    /**
     * Set Subject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subject
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        if (is_null($subject) || (is_array($subject) && empty($subject))) {
            unset($this->Subject);
        } else {
            $this->Subject = $subject;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $user
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setUser(\NexusDigital/MiratelForce\StructType\SObject $user = null)
    {
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userId) && mb_strlen($userId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userId) && !preg_match('/[a-zA-Z0-9]{18}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get Username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->Username) ? $this->Username : null;
    }
    /**
     * Set Username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->Username);
        } else {
            $this->Username = $username;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\PlatformStatusAlertEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
