<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PendingServiceRouting StructType
 * @subpackage Structs
 */
class PendingServiceRouting extends SObject
{
    /**
     * The CapacityPercentage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CapacityPercentage;
    /**
     * The CapacityWeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CapacityWeight;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The CustomRequestedDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomRequestedDateTime;
    /**
     * The DropAdditionalSkillsTimeout
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DropAdditionalSkillsTimeout;
    /**
     * The Group
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Group
     */
    public $Group;
    /**
     * The GroupId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $GroupId;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsPushAttempted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPushAttempted;
    /**
     * The IsPushed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPushed;
    /**
     * The IsReadyForRouting
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReadyForRouting;
    /**
     * The IsTransfer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTransfer;
    /**
     * The LastDeclinedAgentSession
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastDeclinedAgentSession;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $Owner;
    /**
     * The OwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OwnerId;
    /**
     * The PreferredUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $PreferredUser;
    /**
     * The PreferredUserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PreferredUserId;
    /**
     * The ProcessInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessInstances;
    /**
     * The ProcessSteps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessSteps;
    /**
     * The PushTimeout
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PushTimeout;
    /**
     * The Queue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Group
     */
    public $Queue;
    /**
     * The QueueId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $QueueId;
    /**
     * The RoutingModel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoutingModel;
    /**
     * The RoutingPriority
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RoutingPriority;
    /**
     * The RoutingType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoutingType;
    /**
     * The Serial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Serial;
    /**
     * The ServiceChannel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ServiceChannel
     */
    public $ServiceChannel;
    /**
     * The ServiceChannelId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ServiceChannelId;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The UserRecordAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public $UserRecordAccess;
    /**
     * The WorkItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\_Case
     */
    public $WorkItem;
    /**
     * The WorkItemId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $WorkItemId;
    /**
     * Constructor method for PendingServiceRouting
     * @uses PendingServiceRouting::setCapacityPercentage()
     * @uses PendingServiceRouting::setCapacityWeight()
     * @uses PendingServiceRouting::setCreatedBy()
     * @uses PendingServiceRouting::setCreatedById()
     * @uses PendingServiceRouting::setCreatedDate()
     * @uses PendingServiceRouting::setCustomRequestedDateTime()
     * @uses PendingServiceRouting::setDropAdditionalSkillsTimeout()
     * @uses PendingServiceRouting::setGroup()
     * @uses PendingServiceRouting::setGroupId()
     * @uses PendingServiceRouting::setIsDeleted()
     * @uses PendingServiceRouting::setIsPushAttempted()
     * @uses PendingServiceRouting::setIsPushed()
     * @uses PendingServiceRouting::setIsReadyForRouting()
     * @uses PendingServiceRouting::setIsTransfer()
     * @uses PendingServiceRouting::setLastDeclinedAgentSession()
     * @uses PendingServiceRouting::setLastModifiedBy()
     * @uses PendingServiceRouting::setLastModifiedById()
     * @uses PendingServiceRouting::setLastModifiedDate()
     * @uses PendingServiceRouting::setName()
     * @uses PendingServiceRouting::setOwner()
     * @uses PendingServiceRouting::setOwnerId()
     * @uses PendingServiceRouting::setPreferredUser()
     * @uses PendingServiceRouting::setPreferredUserId()
     * @uses PendingServiceRouting::setProcessInstances()
     * @uses PendingServiceRouting::setProcessSteps()
     * @uses PendingServiceRouting::setPushTimeout()
     * @uses PendingServiceRouting::setQueue()
     * @uses PendingServiceRouting::setQueueId()
     * @uses PendingServiceRouting::setRoutingModel()
     * @uses PendingServiceRouting::setRoutingPriority()
     * @uses PendingServiceRouting::setRoutingType()
     * @uses PendingServiceRouting::setSerial()
     * @uses PendingServiceRouting::setServiceChannel()
     * @uses PendingServiceRouting::setServiceChannelId()
     * @uses PendingServiceRouting::setSystemModstamp()
     * @uses PendingServiceRouting::setUserRecordAccess()
     * @uses PendingServiceRouting::setWorkItem()
     * @uses PendingServiceRouting::setWorkItemId()
     * @param float $capacityPercentage
     * @param float $capacityWeight
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $customRequestedDateTime
     * @param int $dropAdditionalSkillsTimeout
     * @param \NexusDigital/MiratelForce\StructType\Group $group
     * @param string $groupId
     * @param bool $isDeleted
     * @param bool $isPushAttempted
     * @param bool $isPushed
     * @param bool $isReadyForRouting
     * @param bool $isTransfer
     * @param string $lastDeclinedAgentSession
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $name
     * @param \NexusDigital/MiratelForce\StructType\SObject $owner
     * @param string $ownerId
     * @param \NexusDigital/MiratelForce\StructType\User $preferredUser
     * @param string $preferredUserId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @param int $pushTimeout
     * @param \NexusDigital/MiratelForce\StructType\Group $queue
     * @param string $queueId
     * @param string $routingModel
     * @param int $routingPriority
     * @param string $routingType
     * @param int $serial
     * @param \NexusDigital/MiratelForce\StructType\ServiceChannel $serviceChannel
     * @param string $serviceChannelId
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @param \NexusDigital/MiratelForce\StructType\_Case $workItem
     * @param string $workItemId
     */
    public function __construct($capacityPercentage = null, $capacityWeight = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $customRequestedDateTime = null, $dropAdditionalSkillsTimeout = null, \NexusDigital/MiratelForce\StructType\Group $group = null, $groupId = null, $isDeleted = null, $isPushAttempted = null, $isPushed = null, $isReadyForRouting = null, $isTransfer = null, $lastDeclinedAgentSession = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $name = null, \NexusDigital/MiratelForce\StructType\SObject $owner = null, $ownerId = null, \NexusDigital/MiratelForce\StructType\User $preferredUser = null, $preferredUserId = null, \NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null, \NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null, $pushTimeout = null, \NexusDigital/MiratelForce\StructType\Group $queue = null, $queueId = null, $routingModel = null, $routingPriority = null, $routingType = null, $serial = null, \NexusDigital/MiratelForce\StructType\ServiceChannel $serviceChannel = null, $serviceChannelId = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null, \NexusDigital/MiratelForce\StructType\_Case $workItem = null, $workItemId = null)
    {
        $this
            ->setCapacityPercentage($capacityPercentage)
            ->setCapacityWeight($capacityWeight)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setCustomRequestedDateTime($customRequestedDateTime)
            ->setDropAdditionalSkillsTimeout($dropAdditionalSkillsTimeout)
            ->setGroup($group)
            ->setGroupId($groupId)
            ->setIsDeleted($isDeleted)
            ->setIsPushAttempted($isPushAttempted)
            ->setIsPushed($isPushed)
            ->setIsReadyForRouting($isReadyForRouting)
            ->setIsTransfer($isTransfer)
            ->setLastDeclinedAgentSession($lastDeclinedAgentSession)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setName($name)
            ->setOwner($owner)
            ->setOwnerId($ownerId)
            ->setPreferredUser($preferredUser)
            ->setPreferredUserId($preferredUserId)
            ->setProcessInstances($processInstances)
            ->setProcessSteps($processSteps)
            ->setPushTimeout($pushTimeout)
            ->setQueue($queue)
            ->setQueueId($queueId)
            ->setRoutingModel($routingModel)
            ->setRoutingPriority($routingPriority)
            ->setRoutingType($routingType)
            ->setSerial($serial)
            ->setServiceChannel($serviceChannel)
            ->setServiceChannelId($serviceChannelId)
            ->setSystemModstamp($systemModstamp)
            ->setUserRecordAccess($userRecordAccess)
            ->setWorkItem($workItem)
            ->setWorkItemId($workItemId);
    }
    /**
     * Get CapacityPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCapacityPercentage()
    {
        return isset($this->CapacityPercentage) ? $this->CapacityPercentage : null;
    }
    /**
     * Set CapacityPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $capacityPercentage
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setCapacityPercentage($capacityPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($capacityPercentage) && !(is_float($capacityPercentage) || is_numeric($capacityPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($capacityPercentage, true), gettype($capacityPercentage)), __LINE__);
        }
        if (is_null($capacityPercentage) || (is_array($capacityPercentage) && empty($capacityPercentage))) {
            unset($this->CapacityPercentage);
        } else {
            $this->CapacityPercentage = $capacityPercentage;
        }
        return $this;
    }
    /**
     * Get CapacityWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCapacityWeight()
    {
        return isset($this->CapacityWeight) ? $this->CapacityWeight : null;
    }
    /**
     * Set CapacityWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $capacityWeight
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setCapacityWeight($capacityWeight = null)
    {
        // validation for constraint: float
        if (!is_null($capacityWeight) && !(is_float($capacityWeight) || is_numeric($capacityWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($capacityWeight, true), gettype($capacityWeight)), __LINE__);
        }
        if (is_null($capacityWeight) || (is_array($capacityWeight) && empty($capacityWeight))) {
            unset($this->CapacityWeight);
        } else {
            $this->CapacityWeight = $capacityWeight;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get CustomRequestedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomRequestedDateTime()
    {
        return isset($this->CustomRequestedDateTime) ? $this->CustomRequestedDateTime : null;
    }
    /**
     * Set CustomRequestedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customRequestedDateTime
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setCustomRequestedDateTime($customRequestedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($customRequestedDateTime) && !is_string($customRequestedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customRequestedDateTime, true), gettype($customRequestedDateTime)), __LINE__);
        }
        if (is_null($customRequestedDateTime) || (is_array($customRequestedDateTime) && empty($customRequestedDateTime))) {
            unset($this->CustomRequestedDateTime);
        } else {
            $this->CustomRequestedDateTime = $customRequestedDateTime;
        }
        return $this;
    }
    /**
     * Get DropAdditionalSkillsTimeout value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDropAdditionalSkillsTimeout()
    {
        return isset($this->DropAdditionalSkillsTimeout) ? $this->DropAdditionalSkillsTimeout : null;
    }
    /**
     * Set DropAdditionalSkillsTimeout value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dropAdditionalSkillsTimeout
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setDropAdditionalSkillsTimeout($dropAdditionalSkillsTimeout = null)
    {
        // validation for constraint: int
        if (!is_null($dropAdditionalSkillsTimeout) && !(is_int($dropAdditionalSkillsTimeout) || ctype_digit($dropAdditionalSkillsTimeout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dropAdditionalSkillsTimeout, true), gettype($dropAdditionalSkillsTimeout)), __LINE__);
        }
        if (is_null($dropAdditionalSkillsTimeout) || (is_array($dropAdditionalSkillsTimeout) && empty($dropAdditionalSkillsTimeout))) {
            unset($this->DropAdditionalSkillsTimeout);
        } else {
            $this->DropAdditionalSkillsTimeout = $dropAdditionalSkillsTimeout;
        }
        return $this;
    }
    /**
     * Get Group value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Group|null
     */
    public function getGroup()
    {
        return isset($this->Group) ? $this->Group : null;
    }
    /**
     * Set Group value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Group $group
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setGroup(\NexusDigital/MiratelForce\StructType\Group $group = null)
    {
        if (is_null($group) || (is_array($group) && empty($group))) {
            unset($this->Group);
        } else {
            $this->Group = $group;
        }
        return $this;
    }
    /**
     * Get GroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupId()
    {
        return isset($this->GroupId) ? $this->GroupId : null;
    }
    /**
     * Set GroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupId
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($groupId) && mb_strlen($groupId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($groupId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($groupId) && !preg_match('/[a-zA-Z0-9]{18}/', $groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($groupId, true)), __LINE__);
        }
        if (is_null($groupId) || (is_array($groupId) && empty($groupId))) {
            unset($this->GroupId);
        } else {
            $this->GroupId = $groupId;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsPushAttempted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPushAttempted()
    {
        return isset($this->IsPushAttempted) ? $this->IsPushAttempted : null;
    }
    /**
     * Set IsPushAttempted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPushAttempted
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setIsPushAttempted($isPushAttempted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPushAttempted) && !is_bool($isPushAttempted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPushAttempted, true), gettype($isPushAttempted)), __LINE__);
        }
        if (is_null($isPushAttempted) || (is_array($isPushAttempted) && empty($isPushAttempted))) {
            unset($this->IsPushAttempted);
        } else {
            $this->IsPushAttempted = $isPushAttempted;
        }
        return $this;
    }
    /**
     * Get IsPushed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPushed()
    {
        return isset($this->IsPushed) ? $this->IsPushed : null;
    }
    /**
     * Set IsPushed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPushed
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setIsPushed($isPushed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPushed) && !is_bool($isPushed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPushed, true), gettype($isPushed)), __LINE__);
        }
        if (is_null($isPushed) || (is_array($isPushed) && empty($isPushed))) {
            unset($this->IsPushed);
        } else {
            $this->IsPushed = $isPushed;
        }
        return $this;
    }
    /**
     * Get IsReadyForRouting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReadyForRouting()
    {
        return isset($this->IsReadyForRouting) ? $this->IsReadyForRouting : null;
    }
    /**
     * Set IsReadyForRouting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReadyForRouting
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setIsReadyForRouting($isReadyForRouting = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReadyForRouting) && !is_bool($isReadyForRouting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReadyForRouting, true), gettype($isReadyForRouting)), __LINE__);
        }
        if (is_null($isReadyForRouting) || (is_array($isReadyForRouting) && empty($isReadyForRouting))) {
            unset($this->IsReadyForRouting);
        } else {
            $this->IsReadyForRouting = $isReadyForRouting;
        }
        return $this;
    }
    /**
     * Get IsTransfer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTransfer()
    {
        return isset($this->IsTransfer) ? $this->IsTransfer : null;
    }
    /**
     * Set IsTransfer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTransfer
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setIsTransfer($isTransfer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTransfer) && !is_bool($isTransfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTransfer, true), gettype($isTransfer)), __LINE__);
        }
        if (is_null($isTransfer) || (is_array($isTransfer) && empty($isTransfer))) {
            unset($this->IsTransfer);
        } else {
            $this->IsTransfer = $isTransfer;
        }
        return $this;
    }
    /**
     * Get LastDeclinedAgentSession value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastDeclinedAgentSession()
    {
        return isset($this->LastDeclinedAgentSession) ? $this->LastDeclinedAgentSession : null;
    }
    /**
     * Set LastDeclinedAgentSession value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastDeclinedAgentSession
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setLastDeclinedAgentSession($lastDeclinedAgentSession = null)
    {
        // validation for constraint: string
        if (!is_null($lastDeclinedAgentSession) && !is_string($lastDeclinedAgentSession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastDeclinedAgentSession, true), gettype($lastDeclinedAgentSession)), __LINE__);
        }
        if (is_null($lastDeclinedAgentSession) || (is_array($lastDeclinedAgentSession) && empty($lastDeclinedAgentSession))) {
            unset($this->LastDeclinedAgentSession);
        } else {
            $this->LastDeclinedAgentSession = $lastDeclinedAgentSession;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $owner
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setOwner(\NexusDigital/MiratelForce\StructType\SObject $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ownerId) && mb_strlen($ownerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ownerId) && !preg_match('/[a-zA-Z0-9]{18}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get PreferredUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getPreferredUser()
    {
        return isset($this->PreferredUser) ? $this->PreferredUser : null;
    }
    /**
     * Set PreferredUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $preferredUser
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setPreferredUser(\NexusDigital/MiratelForce\StructType\User $preferredUser = null)
    {
        if (is_null($preferredUser) || (is_array($preferredUser) && empty($preferredUser))) {
            unset($this->PreferredUser);
        } else {
            $this->PreferredUser = $preferredUser;
        }
        return $this;
    }
    /**
     * Get PreferredUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredUserId()
    {
        return isset($this->PreferredUserId) ? $this->PreferredUserId : null;
    }
    /**
     * Set PreferredUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredUserId
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setPreferredUserId($preferredUserId = null)
    {
        // validation for constraint: string
        if (!is_null($preferredUserId) && !is_string($preferredUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredUserId, true), gettype($preferredUserId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($preferredUserId) && mb_strlen($preferredUserId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($preferredUserId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($preferredUserId) && !preg_match('/[a-zA-Z0-9]{18}/', $preferredUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($preferredUserId, true)), __LINE__);
        }
        if (is_null($preferredUserId) || (is_array($preferredUserId) && empty($preferredUserId))) {
            unset($this->PreferredUserId);
        } else {
            $this->PreferredUserId = $preferredUserId;
        }
        return $this;
    }
    /**
     * Get ProcessInstances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessInstances()
    {
        return isset($this->ProcessInstances) ? $this->ProcessInstances : null;
    }
    /**
     * Set ProcessInstances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setProcessInstances(\NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null)
    {
        if (is_null($processInstances) || (is_array($processInstances) && empty($processInstances))) {
            unset($this->ProcessInstances);
        } else {
            $this->ProcessInstances = $processInstances;
        }
        return $this;
    }
    /**
     * Get ProcessSteps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessSteps()
    {
        return isset($this->ProcessSteps) ? $this->ProcessSteps : null;
    }
    /**
     * Set ProcessSteps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setProcessSteps(\NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null)
    {
        if (is_null($processSteps) || (is_array($processSteps) && empty($processSteps))) {
            unset($this->ProcessSteps);
        } else {
            $this->ProcessSteps = $processSteps;
        }
        return $this;
    }
    /**
     * Get PushTimeout value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPushTimeout()
    {
        return isset($this->PushTimeout) ? $this->PushTimeout : null;
    }
    /**
     * Set PushTimeout value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pushTimeout
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setPushTimeout($pushTimeout = null)
    {
        // validation for constraint: int
        if (!is_null($pushTimeout) && !(is_int($pushTimeout) || ctype_digit($pushTimeout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pushTimeout, true), gettype($pushTimeout)), __LINE__);
        }
        if (is_null($pushTimeout) || (is_array($pushTimeout) && empty($pushTimeout))) {
            unset($this->PushTimeout);
        } else {
            $this->PushTimeout = $pushTimeout;
        }
        return $this;
    }
    /**
     * Get Queue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Group|null
     */
    public function getQueue()
    {
        return isset($this->Queue) ? $this->Queue : null;
    }
    /**
     * Set Queue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Group $queue
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setQueue(\NexusDigital/MiratelForce\StructType\Group $queue = null)
    {
        if (is_null($queue) || (is_array($queue) && empty($queue))) {
            unset($this->Queue);
        } else {
            $this->Queue = $queue;
        }
        return $this;
    }
    /**
     * Get QueueId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueueId()
    {
        return isset($this->QueueId) ? $this->QueueId : null;
    }
    /**
     * Set QueueId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queueId
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setQueueId($queueId = null)
    {
        // validation for constraint: string
        if (!is_null($queueId) && !is_string($queueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queueId, true), gettype($queueId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($queueId) && mb_strlen($queueId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($queueId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($queueId) && !preg_match('/[a-zA-Z0-9]{18}/', $queueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($queueId, true)), __LINE__);
        }
        if (is_null($queueId) || (is_array($queueId) && empty($queueId))) {
            unset($this->QueueId);
        } else {
            $this->QueueId = $queueId;
        }
        return $this;
    }
    /**
     * Get RoutingModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoutingModel()
    {
        return isset($this->RoutingModel) ? $this->RoutingModel : null;
    }
    /**
     * Set RoutingModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routingModel
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setRoutingModel($routingModel = null)
    {
        // validation for constraint: string
        if (!is_null($routingModel) && !is_string($routingModel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routingModel, true), gettype($routingModel)), __LINE__);
        }
        if (is_null($routingModel) || (is_array($routingModel) && empty($routingModel))) {
            unset($this->RoutingModel);
        } else {
            $this->RoutingModel = $routingModel;
        }
        return $this;
    }
    /**
     * Get RoutingPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRoutingPriority()
    {
        return isset($this->RoutingPriority) ? $this->RoutingPriority : null;
    }
    /**
     * Set RoutingPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $routingPriority
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setRoutingPriority($routingPriority = null)
    {
        // validation for constraint: int
        if (!is_null($routingPriority) && !(is_int($routingPriority) || ctype_digit($routingPriority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($routingPriority, true), gettype($routingPriority)), __LINE__);
        }
        if (is_null($routingPriority) || (is_array($routingPriority) && empty($routingPriority))) {
            unset($this->RoutingPriority);
        } else {
            $this->RoutingPriority = $routingPriority;
        }
        return $this;
    }
    /**
     * Get RoutingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoutingType()
    {
        return isset($this->RoutingType) ? $this->RoutingType : null;
    }
    /**
     * Set RoutingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routingType
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setRoutingType($routingType = null)
    {
        // validation for constraint: string
        if (!is_null($routingType) && !is_string($routingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routingType, true), gettype($routingType)), __LINE__);
        }
        if (is_null($routingType) || (is_array($routingType) && empty($routingType))) {
            unset($this->RoutingType);
        } else {
            $this->RoutingType = $routingType;
        }
        return $this;
    }
    /**
     * Get Serial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSerial()
    {
        return isset($this->Serial) ? $this->Serial : null;
    }
    /**
     * Set Serial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $serial
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setSerial($serial = null)
    {
        // validation for constraint: int
        if (!is_null($serial) && !(is_int($serial) || ctype_digit($serial))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serial, true), gettype($serial)), __LINE__);
        }
        if (is_null($serial) || (is_array($serial) && empty($serial))) {
            unset($this->Serial);
        } else {
            $this->Serial = $serial;
        }
        return $this;
    }
    /**
     * Get ServiceChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ServiceChannel|null
     */
    public function getServiceChannel()
    {
        return isset($this->ServiceChannel) ? $this->ServiceChannel : null;
    }
    /**
     * Set ServiceChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ServiceChannel $serviceChannel
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setServiceChannel(\NexusDigital/MiratelForce\StructType\ServiceChannel $serviceChannel = null)
    {
        if (is_null($serviceChannel) || (is_array($serviceChannel) && empty($serviceChannel))) {
            unset($this->ServiceChannel);
        } else {
            $this->ServiceChannel = $serviceChannel;
        }
        return $this;
    }
    /**
     * Get ServiceChannelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceChannelId()
    {
        return isset($this->ServiceChannelId) ? $this->ServiceChannelId : null;
    }
    /**
     * Set ServiceChannelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceChannelId
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setServiceChannelId($serviceChannelId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceChannelId) && !is_string($serviceChannelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceChannelId, true), gettype($serviceChannelId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($serviceChannelId) && mb_strlen($serviceChannelId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($serviceChannelId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($serviceChannelId) && !preg_match('/[a-zA-Z0-9]{18}/', $serviceChannelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($serviceChannelId, true)), __LINE__);
        }
        if (is_null($serviceChannelId) || (is_array($serviceChannelId) && empty($serviceChannelId))) {
            unset($this->ServiceChannelId);
        } else {
            $this->ServiceChannelId = $serviceChannelId;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get UserRecordAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess|null
     */
    public function getUserRecordAccess()
    {
        return isset($this->UserRecordAccess) ? $this->UserRecordAccess : null;
    }
    /**
     * Set UserRecordAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setUserRecordAccess(\NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        if (is_null($userRecordAccess) || (is_array($userRecordAccess) && empty($userRecordAccess))) {
            unset($this->UserRecordAccess);
        } else {
            $this->UserRecordAccess = $userRecordAccess;
        }
        return $this;
    }
    /**
     * Get WorkItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\_Case|null
     */
    public function getWorkItem()
    {
        return isset($this->WorkItem) ? $this->WorkItem : null;
    }
    /**
     * Set WorkItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\_Case $workItem
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setWorkItem(\NexusDigital/MiratelForce\StructType\_Case $workItem = null)
    {
        if (is_null($workItem) || (is_array($workItem) && empty($workItem))) {
            unset($this->WorkItem);
        } else {
            $this->WorkItem = $workItem;
        }
        return $this;
    }
    /**
     * Get WorkItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkItemId()
    {
        return isset($this->WorkItemId) ? $this->WorkItemId : null;
    }
    /**
     * Set WorkItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $workItemId
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public function setWorkItemId($workItemId = null)
    {
        // validation for constraint: string
        if (!is_null($workItemId) && !is_string($workItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workItemId, true), gettype($workItemId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($workItemId) && mb_strlen($workItemId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($workItemId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($workItemId) && !preg_match('/[a-zA-Z0-9]{18}/', $workItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($workItemId, true)), __LINE__);
        }
        if (is_null($workItemId) || (is_array($workItemId) && empty($workItemId))) {
            unset($this->WorkItemId);
        } else {
            $this->WorkItemId = $workItemId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
