<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Organization StructType
 * @subpackage Structs
 */
class Organization extends SObject
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Address
     */
    public $Address;
    /**
     * The AttachedContentDocuments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentDocuments;
    /**
     * The AttachedContentNotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentNotes;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The CombinedAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CombinedAttachments;
    /**
     * The ComplianceBccEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ComplianceBccEmail;
    /**
     * The ContentDocumentLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContentDocumentLinks;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The CustomBrands
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CustomBrands;
    /**
     * The DefaultAccountAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultAccountAccess;
    /**
     * The DefaultCalendarAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultCalendarAccess;
    /**
     * The DefaultCampaignAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultCampaignAccess;
    /**
     * The DefaultCaseAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultCaseAccess;
    /**
     * The DefaultContactAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultContactAccess;
    /**
     * The DefaultLeadAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultLeadAccess;
    /**
     * The DefaultLocaleSidKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultLocaleSidKey;
    /**
     * The DefaultOpportunityAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultOpportunityAccess;
    /**
     * The DefaultPricebookAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultPricebookAccess;
    /**
     * The Division
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Division;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax;
    /**
     * The FiscalYearStartMonth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FiscalYearStartMonth;
    /**
     * The GeocodeAccuracy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeocodeAccuracy;
    /**
     * The InstanceName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstanceName;
    /**
     * The IsReadOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReadOnly;
    /**
     * The IsSandbox
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSandbox;
    /**
     * The LanguageLocaleKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LanguageLocaleKey;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Longitude;
    /**
     * The MonthlyPageViewsEntitlement
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MonthlyPageViewsEntitlement;
    /**
     * The MonthlyPageViewsUsed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MonthlyPageViewsUsed;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NamespacePrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NamespacePrefix;
    /**
     * The NumKnowledgeService
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumKnowledgeService;
    /**
     * The OrganizationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrganizationType;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostalCode;
    /**
     * The PreferencesAutoSelectIndividualOnMerge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesAutoSelectIndividualOnMerge;
    /**
     * The PreferencesConsentManagementEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesConsentManagementEnabled;
    /**
     * The PreferencesIndividualAutoCreateEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesIndividualAutoCreateEnabled;
    /**
     * The PreferencesLightningLoginEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesLightningLoginEnabled;
    /**
     * The PreferencesOnlyLLPermUserAllowed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesOnlyLLPermUserAllowed;
    /**
     * The PreferencesRequireOpportunityProducts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesRequireOpportunityProducts;
    /**
     * The PrimaryContact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrimaryContact;
    /**
     * The ReceivesAdminInfoEmails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReceivesAdminInfoEmails;
    /**
     * The ReceivesInfoEmails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReceivesInfoEmails;
    /**
     * The SignupCountryIsoCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SignupCountryIsoCode;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The Street
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Street;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TimeZoneSidKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeZoneSidKey;
    /**
     * The TrialExpirationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrialExpirationDate;
    /**
     * The UiSkin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UiSkin;
    /**
     * The UsesStartDateAsFiscalYearName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsesStartDateAsFiscalYearName;
    /**
     * The WebToCaseDefaultOrigin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebToCaseDefaultOrigin;
    /**
     * Constructor method for Organization
     * @uses Organization::setAddress()
     * @uses Organization::setAttachedContentDocuments()
     * @uses Organization::setAttachedContentNotes()
     * @uses Organization::setCity()
     * @uses Organization::setCombinedAttachments()
     * @uses Organization::setComplianceBccEmail()
     * @uses Organization::setContentDocumentLinks()
     * @uses Organization::setCountry()
     * @uses Organization::setCreatedBy()
     * @uses Organization::setCreatedById()
     * @uses Organization::setCreatedDate()
     * @uses Organization::setCustomBrands()
     * @uses Organization::setDefaultAccountAccess()
     * @uses Organization::setDefaultCalendarAccess()
     * @uses Organization::setDefaultCampaignAccess()
     * @uses Organization::setDefaultCaseAccess()
     * @uses Organization::setDefaultContactAccess()
     * @uses Organization::setDefaultLeadAccess()
     * @uses Organization::setDefaultLocaleSidKey()
     * @uses Organization::setDefaultOpportunityAccess()
     * @uses Organization::setDefaultPricebookAccess()
     * @uses Organization::setDivision()
     * @uses Organization::setFax()
     * @uses Organization::setFiscalYearStartMonth()
     * @uses Organization::setGeocodeAccuracy()
     * @uses Organization::setInstanceName()
     * @uses Organization::setIsReadOnly()
     * @uses Organization::setIsSandbox()
     * @uses Organization::setLanguageLocaleKey()
     * @uses Organization::setLastModifiedBy()
     * @uses Organization::setLastModifiedById()
     * @uses Organization::setLastModifiedDate()
     * @uses Organization::setLatitude()
     * @uses Organization::setLongitude()
     * @uses Organization::setMonthlyPageViewsEntitlement()
     * @uses Organization::setMonthlyPageViewsUsed()
     * @uses Organization::setName()
     * @uses Organization::setNamespacePrefix()
     * @uses Organization::setNumKnowledgeService()
     * @uses Organization::setOrganizationType()
     * @uses Organization::setPhone()
     * @uses Organization::setPostalCode()
     * @uses Organization::setPreferencesAutoSelectIndividualOnMerge()
     * @uses Organization::setPreferencesConsentManagementEnabled()
     * @uses Organization::setPreferencesIndividualAutoCreateEnabled()
     * @uses Organization::setPreferencesLightningLoginEnabled()
     * @uses Organization::setPreferencesOnlyLLPermUserAllowed()
     * @uses Organization::setPreferencesRequireOpportunityProducts()
     * @uses Organization::setPrimaryContact()
     * @uses Organization::setReceivesAdminInfoEmails()
     * @uses Organization::setReceivesInfoEmails()
     * @uses Organization::setSignupCountryIsoCode()
     * @uses Organization::setState()
     * @uses Organization::setStreet()
     * @uses Organization::setSystemModstamp()
     * @uses Organization::setTimeZoneSidKey()
     * @uses Organization::setTrialExpirationDate()
     * @uses Organization::setUiSkin()
     * @uses Organization::setUsesStartDateAsFiscalYearName()
     * @uses Organization::setWebToCaseDefaultOrigin()
     * @param \NexusDigital/MiratelForce\StructType\Address $address
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @param string $city
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @param string $complianceBccEmail
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @param string $country
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $customBrands
     * @param string $defaultAccountAccess
     * @param string $defaultCalendarAccess
     * @param string $defaultCampaignAccess
     * @param string $defaultCaseAccess
     * @param string $defaultContactAccess
     * @param string $defaultLeadAccess
     * @param string $defaultLocaleSidKey
     * @param string $defaultOpportunityAccess
     * @param string $defaultPricebookAccess
     * @param string $division
     * @param string $fax
     * @param int $fiscalYearStartMonth
     * @param string $geocodeAccuracy
     * @param string $instanceName
     * @param bool $isReadOnly
     * @param bool $isSandbox
     * @param string $languageLocaleKey
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param float $latitude
     * @param float $longitude
     * @param int $monthlyPageViewsEntitlement
     * @param int $monthlyPageViewsUsed
     * @param string $name
     * @param string $namespacePrefix
     * @param int $numKnowledgeService
     * @param string $organizationType
     * @param string $phone
     * @param string $postalCode
     * @param bool $preferencesAutoSelectIndividualOnMerge
     * @param bool $preferencesConsentManagementEnabled
     * @param bool $preferencesIndividualAutoCreateEnabled
     * @param bool $preferencesLightningLoginEnabled
     * @param bool $preferencesOnlyLLPermUserAllowed
     * @param bool $preferencesRequireOpportunityProducts
     * @param string $primaryContact
     * @param bool $receivesAdminInfoEmails
     * @param bool $receivesInfoEmails
     * @param string $signupCountryIsoCode
     * @param string $state
     * @param string $street
     * @param string $systemModstamp
     * @param string $timeZoneSidKey
     * @param string $trialExpirationDate
     * @param string $uiSkin
     * @param bool $usesStartDateAsFiscalYearName
     * @param string $webToCaseDefaultOrigin
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\Address $address = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null, $city = null, \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null, $complianceBccEmail = null, \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null, $country = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $customBrands = null, $defaultAccountAccess = null, $defaultCalendarAccess = null, $defaultCampaignAccess = null, $defaultCaseAccess = null, $defaultContactAccess = null, $defaultLeadAccess = null, $defaultLocaleSidKey = null, $defaultOpportunityAccess = null, $defaultPricebookAccess = null, $division = null, $fax = null, $fiscalYearStartMonth = null, $geocodeAccuracy = null, $instanceName = null, $isReadOnly = null, $isSandbox = null, $languageLocaleKey = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $latitude = null, $longitude = null, $monthlyPageViewsEntitlement = null, $monthlyPageViewsUsed = null, $name = null, $namespacePrefix = null, $numKnowledgeService = null, $organizationType = null, $phone = null, $postalCode = null, $preferencesAutoSelectIndividualOnMerge = null, $preferencesConsentManagementEnabled = null, $preferencesIndividualAutoCreateEnabled = null, $preferencesLightningLoginEnabled = null, $preferencesOnlyLLPermUserAllowed = null, $preferencesRequireOpportunityProducts = null, $primaryContact = null, $receivesAdminInfoEmails = null, $receivesInfoEmails = null, $signupCountryIsoCode = null, $state = null, $street = null, $systemModstamp = null, $timeZoneSidKey = null, $trialExpirationDate = null, $uiSkin = null, $usesStartDateAsFiscalYearName = null, $webToCaseDefaultOrigin = null)
    {
        $this
            ->setAddress($address)
            ->setAttachedContentDocuments($attachedContentDocuments)
            ->setAttachedContentNotes($attachedContentNotes)
            ->setCity($city)
            ->setCombinedAttachments($combinedAttachments)
            ->setComplianceBccEmail($complianceBccEmail)
            ->setContentDocumentLinks($contentDocumentLinks)
            ->setCountry($country)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setCustomBrands($customBrands)
            ->setDefaultAccountAccess($defaultAccountAccess)
            ->setDefaultCalendarAccess($defaultCalendarAccess)
            ->setDefaultCampaignAccess($defaultCampaignAccess)
            ->setDefaultCaseAccess($defaultCaseAccess)
            ->setDefaultContactAccess($defaultContactAccess)
            ->setDefaultLeadAccess($defaultLeadAccess)
            ->setDefaultLocaleSidKey($defaultLocaleSidKey)
            ->setDefaultOpportunityAccess($defaultOpportunityAccess)
            ->setDefaultPricebookAccess($defaultPricebookAccess)
            ->setDivision($division)
            ->setFax($fax)
            ->setFiscalYearStartMonth($fiscalYearStartMonth)
            ->setGeocodeAccuracy($geocodeAccuracy)
            ->setInstanceName($instanceName)
            ->setIsReadOnly($isReadOnly)
            ->setIsSandbox($isSandbox)
            ->setLanguageLocaleKey($languageLocaleKey)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setMonthlyPageViewsEntitlement($monthlyPageViewsEntitlement)
            ->setMonthlyPageViewsUsed($monthlyPageViewsUsed)
            ->setName($name)
            ->setNamespacePrefix($namespacePrefix)
            ->setNumKnowledgeService($numKnowledgeService)
            ->setOrganizationType($organizationType)
            ->setPhone($phone)
            ->setPostalCode($postalCode)
            ->setPreferencesAutoSelectIndividualOnMerge($preferencesAutoSelectIndividualOnMerge)
            ->setPreferencesConsentManagementEnabled($preferencesConsentManagementEnabled)
            ->setPreferencesIndividualAutoCreateEnabled($preferencesIndividualAutoCreateEnabled)
            ->setPreferencesLightningLoginEnabled($preferencesLightningLoginEnabled)
            ->setPreferencesOnlyLLPermUserAllowed($preferencesOnlyLLPermUserAllowed)
            ->setPreferencesRequireOpportunityProducts($preferencesRequireOpportunityProducts)
            ->setPrimaryContact($primaryContact)
            ->setReceivesAdminInfoEmails($receivesAdminInfoEmails)
            ->setReceivesInfoEmails($receivesInfoEmails)
            ->setSignupCountryIsoCode($signupCountryIsoCode)
            ->setState($state)
            ->setStreet($street)
            ->setSystemModstamp($systemModstamp)
            ->setTimeZoneSidKey($timeZoneSidKey)
            ->setTrialExpirationDate($trialExpirationDate)
            ->setUiSkin($uiSkin)
            ->setUsesStartDateAsFiscalYearName($usesStartDateAsFiscalYearName)
            ->setWebToCaseDefaultOrigin($webToCaseDefaultOrigin);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Address|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Address $address
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setAddress(\NexusDigital/MiratelForce\StructType\Address $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get AttachedContentDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentDocuments()
    {
        return isset($this->AttachedContentDocuments) ? $this->AttachedContentDocuments : null;
    }
    /**
     * Set AttachedContentDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setAttachedContentDocuments(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null)
    {
        if (is_null($attachedContentDocuments) || (is_array($attachedContentDocuments) && empty($attachedContentDocuments))) {
            unset($this->AttachedContentDocuments);
        } else {
            $this->AttachedContentDocuments = $attachedContentDocuments;
        }
        return $this;
    }
    /**
     * Get AttachedContentNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentNotes()
    {
        return isset($this->AttachedContentNotes) ? $this->AttachedContentNotes : null;
    }
    /**
     * Set AttachedContentNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setAttachedContentNotes(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null)
    {
        if (is_null($attachedContentNotes) || (is_array($attachedContentNotes) && empty($attachedContentNotes))) {
            unset($this->AttachedContentNotes);
        } else {
            $this->AttachedContentNotes = $attachedContentNotes;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get CombinedAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCombinedAttachments()
    {
        return isset($this->CombinedAttachments) ? $this->CombinedAttachments : null;
    }
    /**
     * Set CombinedAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setCombinedAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null)
    {
        if (is_null($combinedAttachments) || (is_array($combinedAttachments) && empty($combinedAttachments))) {
            unset($this->CombinedAttachments);
        } else {
            $this->CombinedAttachments = $combinedAttachments;
        }
        return $this;
    }
    /**
     * Get ComplianceBccEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComplianceBccEmail()
    {
        return isset($this->ComplianceBccEmail) ? $this->ComplianceBccEmail : null;
    }
    /**
     * Set ComplianceBccEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $complianceBccEmail
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setComplianceBccEmail($complianceBccEmail = null)
    {
        // validation for constraint: string
        if (!is_null($complianceBccEmail) && !is_string($complianceBccEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($complianceBccEmail, true), gettype($complianceBccEmail)), __LINE__);
        }
        if (is_null($complianceBccEmail) || (is_array($complianceBccEmail) && empty($complianceBccEmail))) {
            unset($this->ComplianceBccEmail);
        } else {
            $this->ComplianceBccEmail = $complianceBccEmail;
        }
        return $this;
    }
    /**
     * Get ContentDocumentLinks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContentDocumentLinks()
    {
        return isset($this->ContentDocumentLinks) ? $this->ContentDocumentLinks : null;
    }
    /**
     * Set ContentDocumentLinks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setContentDocumentLinks(\NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null)
    {
        if (is_null($contentDocumentLinks) || (is_array($contentDocumentLinks) && empty($contentDocumentLinks))) {
            unset($this->ContentDocumentLinks);
        } else {
            $this->ContentDocumentLinks = $contentDocumentLinks;
        }
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get CustomBrands value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCustomBrands()
    {
        return isset($this->CustomBrands) ? $this->CustomBrands : null;
    }
    /**
     * Set CustomBrands value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $customBrands
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setCustomBrands(\NexusDigital/MiratelForce\StructType\QueryResult $customBrands = null)
    {
        if (is_null($customBrands) || (is_array($customBrands) && empty($customBrands))) {
            unset($this->CustomBrands);
        } else {
            $this->CustomBrands = $customBrands;
        }
        return $this;
    }
    /**
     * Get DefaultAccountAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultAccountAccess()
    {
        return isset($this->DefaultAccountAccess) ? $this->DefaultAccountAccess : null;
    }
    /**
     * Set DefaultAccountAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultAccountAccess
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setDefaultAccountAccess($defaultAccountAccess = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAccountAccess) && !is_string($defaultAccountAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAccountAccess, true), gettype($defaultAccountAccess)), __LINE__);
        }
        if (is_null($defaultAccountAccess) || (is_array($defaultAccountAccess) && empty($defaultAccountAccess))) {
            unset($this->DefaultAccountAccess);
        } else {
            $this->DefaultAccountAccess = $defaultAccountAccess;
        }
        return $this;
    }
    /**
     * Get DefaultCalendarAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultCalendarAccess()
    {
        return isset($this->DefaultCalendarAccess) ? $this->DefaultCalendarAccess : null;
    }
    /**
     * Set DefaultCalendarAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultCalendarAccess
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setDefaultCalendarAccess($defaultCalendarAccess = null)
    {
        // validation for constraint: string
        if (!is_null($defaultCalendarAccess) && !is_string($defaultCalendarAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultCalendarAccess, true), gettype($defaultCalendarAccess)), __LINE__);
        }
        if (is_null($defaultCalendarAccess) || (is_array($defaultCalendarAccess) && empty($defaultCalendarAccess))) {
            unset($this->DefaultCalendarAccess);
        } else {
            $this->DefaultCalendarAccess = $defaultCalendarAccess;
        }
        return $this;
    }
    /**
     * Get DefaultCampaignAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultCampaignAccess()
    {
        return isset($this->DefaultCampaignAccess) ? $this->DefaultCampaignAccess : null;
    }
    /**
     * Set DefaultCampaignAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultCampaignAccess
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setDefaultCampaignAccess($defaultCampaignAccess = null)
    {
        // validation for constraint: string
        if (!is_null($defaultCampaignAccess) && !is_string($defaultCampaignAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultCampaignAccess, true), gettype($defaultCampaignAccess)), __LINE__);
        }
        if (is_null($defaultCampaignAccess) || (is_array($defaultCampaignAccess) && empty($defaultCampaignAccess))) {
            unset($this->DefaultCampaignAccess);
        } else {
            $this->DefaultCampaignAccess = $defaultCampaignAccess;
        }
        return $this;
    }
    /**
     * Get DefaultCaseAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultCaseAccess()
    {
        return isset($this->DefaultCaseAccess) ? $this->DefaultCaseAccess : null;
    }
    /**
     * Set DefaultCaseAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultCaseAccess
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setDefaultCaseAccess($defaultCaseAccess = null)
    {
        // validation for constraint: string
        if (!is_null($defaultCaseAccess) && !is_string($defaultCaseAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultCaseAccess, true), gettype($defaultCaseAccess)), __LINE__);
        }
        if (is_null($defaultCaseAccess) || (is_array($defaultCaseAccess) && empty($defaultCaseAccess))) {
            unset($this->DefaultCaseAccess);
        } else {
            $this->DefaultCaseAccess = $defaultCaseAccess;
        }
        return $this;
    }
    /**
     * Get DefaultContactAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultContactAccess()
    {
        return isset($this->DefaultContactAccess) ? $this->DefaultContactAccess : null;
    }
    /**
     * Set DefaultContactAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultContactAccess
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setDefaultContactAccess($defaultContactAccess = null)
    {
        // validation for constraint: string
        if (!is_null($defaultContactAccess) && !is_string($defaultContactAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultContactAccess, true), gettype($defaultContactAccess)), __LINE__);
        }
        if (is_null($defaultContactAccess) || (is_array($defaultContactAccess) && empty($defaultContactAccess))) {
            unset($this->DefaultContactAccess);
        } else {
            $this->DefaultContactAccess = $defaultContactAccess;
        }
        return $this;
    }
    /**
     * Get DefaultLeadAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultLeadAccess()
    {
        return isset($this->DefaultLeadAccess) ? $this->DefaultLeadAccess : null;
    }
    /**
     * Set DefaultLeadAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultLeadAccess
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setDefaultLeadAccess($defaultLeadAccess = null)
    {
        // validation for constraint: string
        if (!is_null($defaultLeadAccess) && !is_string($defaultLeadAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultLeadAccess, true), gettype($defaultLeadAccess)), __LINE__);
        }
        if (is_null($defaultLeadAccess) || (is_array($defaultLeadAccess) && empty($defaultLeadAccess))) {
            unset($this->DefaultLeadAccess);
        } else {
            $this->DefaultLeadAccess = $defaultLeadAccess;
        }
        return $this;
    }
    /**
     * Get DefaultLocaleSidKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultLocaleSidKey()
    {
        return isset($this->DefaultLocaleSidKey) ? $this->DefaultLocaleSidKey : null;
    }
    /**
     * Set DefaultLocaleSidKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultLocaleSidKey
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setDefaultLocaleSidKey($defaultLocaleSidKey = null)
    {
        // validation for constraint: string
        if (!is_null($defaultLocaleSidKey) && !is_string($defaultLocaleSidKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultLocaleSidKey, true), gettype($defaultLocaleSidKey)), __LINE__);
        }
        if (is_null($defaultLocaleSidKey) || (is_array($defaultLocaleSidKey) && empty($defaultLocaleSidKey))) {
            unset($this->DefaultLocaleSidKey);
        } else {
            $this->DefaultLocaleSidKey = $defaultLocaleSidKey;
        }
        return $this;
    }
    /**
     * Get DefaultOpportunityAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultOpportunityAccess()
    {
        return isset($this->DefaultOpportunityAccess) ? $this->DefaultOpportunityAccess : null;
    }
    /**
     * Set DefaultOpportunityAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultOpportunityAccess
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setDefaultOpportunityAccess($defaultOpportunityAccess = null)
    {
        // validation for constraint: string
        if (!is_null($defaultOpportunityAccess) && !is_string($defaultOpportunityAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultOpportunityAccess, true), gettype($defaultOpportunityAccess)), __LINE__);
        }
        if (is_null($defaultOpportunityAccess) || (is_array($defaultOpportunityAccess) && empty($defaultOpportunityAccess))) {
            unset($this->DefaultOpportunityAccess);
        } else {
            $this->DefaultOpportunityAccess = $defaultOpportunityAccess;
        }
        return $this;
    }
    /**
     * Get DefaultPricebookAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultPricebookAccess()
    {
        return isset($this->DefaultPricebookAccess) ? $this->DefaultPricebookAccess : null;
    }
    /**
     * Set DefaultPricebookAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultPricebookAccess
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setDefaultPricebookAccess($defaultPricebookAccess = null)
    {
        // validation for constraint: string
        if (!is_null($defaultPricebookAccess) && !is_string($defaultPricebookAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultPricebookAccess, true), gettype($defaultPricebookAccess)), __LINE__);
        }
        if (is_null($defaultPricebookAccess) || (is_array($defaultPricebookAccess) && empty($defaultPricebookAccess))) {
            unset($this->DefaultPricebookAccess);
        } else {
            $this->DefaultPricebookAccess = $defaultPricebookAccess;
        }
        return $this;
    }
    /**
     * Get Division value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDivision()
    {
        return isset($this->Division) ? $this->Division : null;
    }
    /**
     * Set Division value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $division
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setDivision($division = null)
    {
        // validation for constraint: string
        if (!is_null($division) && !is_string($division)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($division, true), gettype($division)), __LINE__);
        }
        if (is_null($division) || (is_array($division) && empty($division))) {
            unset($this->Division);
        } else {
            $this->Division = $division;
        }
        return $this;
    }
    /**
     * Get Fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax()
    {
        return isset($this->Fax) ? $this->Fax : null;
    }
    /**
     * Set Fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        if (is_null($fax) || (is_array($fax) && empty($fax))) {
            unset($this->Fax);
        } else {
            $this->Fax = $fax;
        }
        return $this;
    }
    /**
     * Get FiscalYearStartMonth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFiscalYearStartMonth()
    {
        return isset($this->FiscalYearStartMonth) ? $this->FiscalYearStartMonth : null;
    }
    /**
     * Set FiscalYearStartMonth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fiscalYearStartMonth
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setFiscalYearStartMonth($fiscalYearStartMonth = null)
    {
        // validation for constraint: int
        if (!is_null($fiscalYearStartMonth) && !(is_int($fiscalYearStartMonth) || ctype_digit($fiscalYearStartMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fiscalYearStartMonth, true), gettype($fiscalYearStartMonth)), __LINE__);
        }
        if (is_null($fiscalYearStartMonth) || (is_array($fiscalYearStartMonth) && empty($fiscalYearStartMonth))) {
            unset($this->FiscalYearStartMonth);
        } else {
            $this->FiscalYearStartMonth = $fiscalYearStartMonth;
        }
        return $this;
    }
    /**
     * Get GeocodeAccuracy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeocodeAccuracy()
    {
        return isset($this->GeocodeAccuracy) ? $this->GeocodeAccuracy : null;
    }
    /**
     * Set GeocodeAccuracy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geocodeAccuracy
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setGeocodeAccuracy($geocodeAccuracy = null)
    {
        // validation for constraint: string
        if (!is_null($geocodeAccuracy) && !is_string($geocodeAccuracy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geocodeAccuracy, true), gettype($geocodeAccuracy)), __LINE__);
        }
        if (is_null($geocodeAccuracy) || (is_array($geocodeAccuracy) && empty($geocodeAccuracy))) {
            unset($this->GeocodeAccuracy);
        } else {
            $this->GeocodeAccuracy = $geocodeAccuracy;
        }
        return $this;
    }
    /**
     * Get InstanceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstanceName()
    {
        return isset($this->InstanceName) ? $this->InstanceName : null;
    }
    /**
     * Set InstanceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $instanceName
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setInstanceName($instanceName = null)
    {
        // validation for constraint: string
        if (!is_null($instanceName) && !is_string($instanceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instanceName, true), gettype($instanceName)), __LINE__);
        }
        if (is_null($instanceName) || (is_array($instanceName) && empty($instanceName))) {
            unset($this->InstanceName);
        } else {
            $this->InstanceName = $instanceName;
        }
        return $this;
    }
    /**
     * Get IsReadOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReadOnly()
    {
        return isset($this->IsReadOnly) ? $this->IsReadOnly : null;
    }
    /**
     * Set IsReadOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReadOnly
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setIsReadOnly($isReadOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReadOnly) && !is_bool($isReadOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReadOnly, true), gettype($isReadOnly)), __LINE__);
        }
        if (is_null($isReadOnly) || (is_array($isReadOnly) && empty($isReadOnly))) {
            unset($this->IsReadOnly);
        } else {
            $this->IsReadOnly = $isReadOnly;
        }
        return $this;
    }
    /**
     * Get IsSandbox value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSandbox()
    {
        return isset($this->IsSandbox) ? $this->IsSandbox : null;
    }
    /**
     * Set IsSandbox value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSandbox
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setIsSandbox($isSandbox = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSandbox) && !is_bool($isSandbox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSandbox, true), gettype($isSandbox)), __LINE__);
        }
        if (is_null($isSandbox) || (is_array($isSandbox) && empty($isSandbox))) {
            unset($this->IsSandbox);
        } else {
            $this->IsSandbox = $isSandbox;
        }
        return $this;
    }
    /**
     * Get LanguageLocaleKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguageLocaleKey()
    {
        return isset($this->LanguageLocaleKey) ? $this->LanguageLocaleKey : null;
    }
    /**
     * Set LanguageLocaleKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $languageLocaleKey
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setLanguageLocaleKey($languageLocaleKey = null)
    {
        // validation for constraint: string
        if (!is_null($languageLocaleKey) && !is_string($languageLocaleKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageLocaleKey, true), gettype($languageLocaleKey)), __LINE__);
        }
        if (is_null($languageLocaleKey) || (is_array($languageLocaleKey) && empty($languageLocaleKey))) {
            unset($this->LanguageLocaleKey);
        } else {
            $this->LanguageLocaleKey = $languageLocaleKey;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get Latitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLatitude()
    {
        return isset($this->Latitude) ? $this->Latitude : null;
    }
    /**
     * Set Latitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $latitude
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        if (is_null($latitude) || (is_array($latitude) && empty($latitude))) {
            unset($this->Latitude);
        } else {
            $this->Latitude = $latitude;
        }
        return $this;
    }
    /**
     * Get Longitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLongitude()
    {
        return isset($this->Longitude) ? $this->Longitude : null;
    }
    /**
     * Set Longitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $longitude
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        if (is_null($longitude) || (is_array($longitude) && empty($longitude))) {
            unset($this->Longitude);
        } else {
            $this->Longitude = $longitude;
        }
        return $this;
    }
    /**
     * Get MonthlyPageViewsEntitlement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMonthlyPageViewsEntitlement()
    {
        return isset($this->MonthlyPageViewsEntitlement) ? $this->MonthlyPageViewsEntitlement : null;
    }
    /**
     * Set MonthlyPageViewsEntitlement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $monthlyPageViewsEntitlement
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setMonthlyPageViewsEntitlement($monthlyPageViewsEntitlement = null)
    {
        // validation for constraint: int
        if (!is_null($monthlyPageViewsEntitlement) && !(is_int($monthlyPageViewsEntitlement) || ctype_digit($monthlyPageViewsEntitlement))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($monthlyPageViewsEntitlement, true), gettype($monthlyPageViewsEntitlement)), __LINE__);
        }
        if (is_null($monthlyPageViewsEntitlement) || (is_array($monthlyPageViewsEntitlement) && empty($monthlyPageViewsEntitlement))) {
            unset($this->MonthlyPageViewsEntitlement);
        } else {
            $this->MonthlyPageViewsEntitlement = $monthlyPageViewsEntitlement;
        }
        return $this;
    }
    /**
     * Get MonthlyPageViewsUsed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMonthlyPageViewsUsed()
    {
        return isset($this->MonthlyPageViewsUsed) ? $this->MonthlyPageViewsUsed : null;
    }
    /**
     * Set MonthlyPageViewsUsed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $monthlyPageViewsUsed
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setMonthlyPageViewsUsed($monthlyPageViewsUsed = null)
    {
        // validation for constraint: int
        if (!is_null($monthlyPageViewsUsed) && !(is_int($monthlyPageViewsUsed) || ctype_digit($monthlyPageViewsUsed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($monthlyPageViewsUsed, true), gettype($monthlyPageViewsUsed)), __LINE__);
        }
        if (is_null($monthlyPageViewsUsed) || (is_array($monthlyPageViewsUsed) && empty($monthlyPageViewsUsed))) {
            unset($this->MonthlyPageViewsUsed);
        } else {
            $this->MonthlyPageViewsUsed = $monthlyPageViewsUsed;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NamespacePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNamespacePrefix()
    {
        return isset($this->NamespacePrefix) ? $this->NamespacePrefix : null;
    }
    /**
     * Set NamespacePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $namespacePrefix
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setNamespacePrefix($namespacePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($namespacePrefix) && !is_string($namespacePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namespacePrefix, true), gettype($namespacePrefix)), __LINE__);
        }
        if (is_null($namespacePrefix) || (is_array($namespacePrefix) && empty($namespacePrefix))) {
            unset($this->NamespacePrefix);
        } else {
            $this->NamespacePrefix = $namespacePrefix;
        }
        return $this;
    }
    /**
     * Get NumKnowledgeService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumKnowledgeService()
    {
        return isset($this->NumKnowledgeService) ? $this->NumKnowledgeService : null;
    }
    /**
     * Set NumKnowledgeService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numKnowledgeService
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setNumKnowledgeService($numKnowledgeService = null)
    {
        // validation for constraint: int
        if (!is_null($numKnowledgeService) && !(is_int($numKnowledgeService) || ctype_digit($numKnowledgeService))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numKnowledgeService, true), gettype($numKnowledgeService)), __LINE__);
        }
        if (is_null($numKnowledgeService) || (is_array($numKnowledgeService) && empty($numKnowledgeService))) {
            unset($this->NumKnowledgeService);
        } else {
            $this->NumKnowledgeService = $numKnowledgeService;
        }
        return $this;
    }
    /**
     * Get OrganizationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationType()
    {
        return isset($this->OrganizationType) ? $this->OrganizationType : null;
    }
    /**
     * Set OrganizationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationType
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setOrganizationType($organizationType = null)
    {
        // validation for constraint: string
        if (!is_null($organizationType) && !is_string($organizationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationType, true), gettype($organizationType)), __LINE__);
        }
        if (is_null($organizationType) || (is_array($organizationType) && empty($organizationType))) {
            unset($this->OrganizationType);
        } else {
            $this->OrganizationType = $organizationType;
        }
        return $this;
    }
    /**
     * Get Phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->Phone) ? $this->Phone : null;
    }
    /**
     * Set Phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->Phone);
        } else {
            $this->Phone = $phone;
        }
        return $this;
    }
    /**
     * Get PostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostalCode()
    {
        return isset($this->PostalCode) ? $this->PostalCode : null;
    }
    /**
     * Set PostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postalCode
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        if (is_null($postalCode) || (is_array($postalCode) && empty($postalCode))) {
            unset($this->PostalCode);
        } else {
            $this->PostalCode = $postalCode;
        }
        return $this;
    }
    /**
     * Get PreferencesAutoSelectIndividualOnMerge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesAutoSelectIndividualOnMerge()
    {
        return isset($this->PreferencesAutoSelectIndividualOnMerge) ? $this->PreferencesAutoSelectIndividualOnMerge : null;
    }
    /**
     * Set PreferencesAutoSelectIndividualOnMerge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesAutoSelectIndividualOnMerge
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setPreferencesAutoSelectIndividualOnMerge($preferencesAutoSelectIndividualOnMerge = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesAutoSelectIndividualOnMerge) && !is_bool($preferencesAutoSelectIndividualOnMerge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesAutoSelectIndividualOnMerge, true), gettype($preferencesAutoSelectIndividualOnMerge)), __LINE__);
        }
        if (is_null($preferencesAutoSelectIndividualOnMerge) || (is_array($preferencesAutoSelectIndividualOnMerge) && empty($preferencesAutoSelectIndividualOnMerge))) {
            unset($this->PreferencesAutoSelectIndividualOnMerge);
        } else {
            $this->PreferencesAutoSelectIndividualOnMerge = $preferencesAutoSelectIndividualOnMerge;
        }
        return $this;
    }
    /**
     * Get PreferencesConsentManagementEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesConsentManagementEnabled()
    {
        return isset($this->PreferencesConsentManagementEnabled) ? $this->PreferencesConsentManagementEnabled : null;
    }
    /**
     * Set PreferencesConsentManagementEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesConsentManagementEnabled
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setPreferencesConsentManagementEnabled($preferencesConsentManagementEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesConsentManagementEnabled) && !is_bool($preferencesConsentManagementEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesConsentManagementEnabled, true), gettype($preferencesConsentManagementEnabled)), __LINE__);
        }
        if (is_null($preferencesConsentManagementEnabled) || (is_array($preferencesConsentManagementEnabled) && empty($preferencesConsentManagementEnabled))) {
            unset($this->PreferencesConsentManagementEnabled);
        } else {
            $this->PreferencesConsentManagementEnabled = $preferencesConsentManagementEnabled;
        }
        return $this;
    }
    /**
     * Get PreferencesIndividualAutoCreateEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesIndividualAutoCreateEnabled()
    {
        return isset($this->PreferencesIndividualAutoCreateEnabled) ? $this->PreferencesIndividualAutoCreateEnabled : null;
    }
    /**
     * Set PreferencesIndividualAutoCreateEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesIndividualAutoCreateEnabled
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setPreferencesIndividualAutoCreateEnabled($preferencesIndividualAutoCreateEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesIndividualAutoCreateEnabled) && !is_bool($preferencesIndividualAutoCreateEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesIndividualAutoCreateEnabled, true), gettype($preferencesIndividualAutoCreateEnabled)), __LINE__);
        }
        if (is_null($preferencesIndividualAutoCreateEnabled) || (is_array($preferencesIndividualAutoCreateEnabled) && empty($preferencesIndividualAutoCreateEnabled))) {
            unset($this->PreferencesIndividualAutoCreateEnabled);
        } else {
            $this->PreferencesIndividualAutoCreateEnabled = $preferencesIndividualAutoCreateEnabled;
        }
        return $this;
    }
    /**
     * Get PreferencesLightningLoginEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesLightningLoginEnabled()
    {
        return isset($this->PreferencesLightningLoginEnabled) ? $this->PreferencesLightningLoginEnabled : null;
    }
    /**
     * Set PreferencesLightningLoginEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesLightningLoginEnabled
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setPreferencesLightningLoginEnabled($preferencesLightningLoginEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesLightningLoginEnabled) && !is_bool($preferencesLightningLoginEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesLightningLoginEnabled, true), gettype($preferencesLightningLoginEnabled)), __LINE__);
        }
        if (is_null($preferencesLightningLoginEnabled) || (is_array($preferencesLightningLoginEnabled) && empty($preferencesLightningLoginEnabled))) {
            unset($this->PreferencesLightningLoginEnabled);
        } else {
            $this->PreferencesLightningLoginEnabled = $preferencesLightningLoginEnabled;
        }
        return $this;
    }
    /**
     * Get PreferencesOnlyLLPermUserAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesOnlyLLPermUserAllowed()
    {
        return isset($this->PreferencesOnlyLLPermUserAllowed) ? $this->PreferencesOnlyLLPermUserAllowed : null;
    }
    /**
     * Set PreferencesOnlyLLPermUserAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesOnlyLLPermUserAllowed
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setPreferencesOnlyLLPermUserAllowed($preferencesOnlyLLPermUserAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesOnlyLLPermUserAllowed) && !is_bool($preferencesOnlyLLPermUserAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesOnlyLLPermUserAllowed, true), gettype($preferencesOnlyLLPermUserAllowed)), __LINE__);
        }
        if (is_null($preferencesOnlyLLPermUserAllowed) || (is_array($preferencesOnlyLLPermUserAllowed) && empty($preferencesOnlyLLPermUserAllowed))) {
            unset($this->PreferencesOnlyLLPermUserAllowed);
        } else {
            $this->PreferencesOnlyLLPermUserAllowed = $preferencesOnlyLLPermUserAllowed;
        }
        return $this;
    }
    /**
     * Get PreferencesRequireOpportunityProducts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesRequireOpportunityProducts()
    {
        return isset($this->PreferencesRequireOpportunityProducts) ? $this->PreferencesRequireOpportunityProducts : null;
    }
    /**
     * Set PreferencesRequireOpportunityProducts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesRequireOpportunityProducts
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setPreferencesRequireOpportunityProducts($preferencesRequireOpportunityProducts = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesRequireOpportunityProducts) && !is_bool($preferencesRequireOpportunityProducts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesRequireOpportunityProducts, true), gettype($preferencesRequireOpportunityProducts)), __LINE__);
        }
        if (is_null($preferencesRequireOpportunityProducts) || (is_array($preferencesRequireOpportunityProducts) && empty($preferencesRequireOpportunityProducts))) {
            unset($this->PreferencesRequireOpportunityProducts);
        } else {
            $this->PreferencesRequireOpportunityProducts = $preferencesRequireOpportunityProducts;
        }
        return $this;
    }
    /**
     * Get PrimaryContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryContact()
    {
        return isset($this->PrimaryContact) ? $this->PrimaryContact : null;
    }
    /**
     * Set PrimaryContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryContact
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setPrimaryContact($primaryContact = null)
    {
        // validation for constraint: string
        if (!is_null($primaryContact) && !is_string($primaryContact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryContact, true), gettype($primaryContact)), __LINE__);
        }
        if (is_null($primaryContact) || (is_array($primaryContact) && empty($primaryContact))) {
            unset($this->PrimaryContact);
        } else {
            $this->PrimaryContact = $primaryContact;
        }
        return $this;
    }
    /**
     * Get ReceivesAdminInfoEmails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReceivesAdminInfoEmails()
    {
        return isset($this->ReceivesAdminInfoEmails) ? $this->ReceivesAdminInfoEmails : null;
    }
    /**
     * Set ReceivesAdminInfoEmails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $receivesAdminInfoEmails
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setReceivesAdminInfoEmails($receivesAdminInfoEmails = null)
    {
        // validation for constraint: boolean
        if (!is_null($receivesAdminInfoEmails) && !is_bool($receivesAdminInfoEmails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($receivesAdminInfoEmails, true), gettype($receivesAdminInfoEmails)), __LINE__);
        }
        if (is_null($receivesAdminInfoEmails) || (is_array($receivesAdminInfoEmails) && empty($receivesAdminInfoEmails))) {
            unset($this->ReceivesAdminInfoEmails);
        } else {
            $this->ReceivesAdminInfoEmails = $receivesAdminInfoEmails;
        }
        return $this;
    }
    /**
     * Get ReceivesInfoEmails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReceivesInfoEmails()
    {
        return isset($this->ReceivesInfoEmails) ? $this->ReceivesInfoEmails : null;
    }
    /**
     * Set ReceivesInfoEmails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $receivesInfoEmails
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setReceivesInfoEmails($receivesInfoEmails = null)
    {
        // validation for constraint: boolean
        if (!is_null($receivesInfoEmails) && !is_bool($receivesInfoEmails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($receivesInfoEmails, true), gettype($receivesInfoEmails)), __LINE__);
        }
        if (is_null($receivesInfoEmails) || (is_array($receivesInfoEmails) && empty($receivesInfoEmails))) {
            unset($this->ReceivesInfoEmails);
        } else {
            $this->ReceivesInfoEmails = $receivesInfoEmails;
        }
        return $this;
    }
    /**
     * Get SignupCountryIsoCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSignupCountryIsoCode()
    {
        return isset($this->SignupCountryIsoCode) ? $this->SignupCountryIsoCode : null;
    }
    /**
     * Set SignupCountryIsoCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $signupCountryIsoCode
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setSignupCountryIsoCode($signupCountryIsoCode = null)
    {
        // validation for constraint: string
        if (!is_null($signupCountryIsoCode) && !is_string($signupCountryIsoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signupCountryIsoCode, true), gettype($signupCountryIsoCode)), __LINE__);
        }
        if (is_null($signupCountryIsoCode) || (is_array($signupCountryIsoCode) && empty($signupCountryIsoCode))) {
            unset($this->SignupCountryIsoCode);
        } else {
            $this->SignupCountryIsoCode = $signupCountryIsoCode;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get Street value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreet()
    {
        return isset($this->Street) ? $this->Street : null;
    }
    /**
     * Set Street value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $street
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        if (is_null($street) || (is_array($street) && empty($street))) {
            unset($this->Street);
        } else {
            $this->Street = $street;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TimeZoneSidKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeZoneSidKey()
    {
        return isset($this->TimeZoneSidKey) ? $this->TimeZoneSidKey : null;
    }
    /**
     * Set TimeZoneSidKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeZoneSidKey
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setTimeZoneSidKey($timeZoneSidKey = null)
    {
        // validation for constraint: string
        if (!is_null($timeZoneSidKey) && !is_string($timeZoneSidKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZoneSidKey, true), gettype($timeZoneSidKey)), __LINE__);
        }
        if (is_null($timeZoneSidKey) || (is_array($timeZoneSidKey) && empty($timeZoneSidKey))) {
            unset($this->TimeZoneSidKey);
        } else {
            $this->TimeZoneSidKey = $timeZoneSidKey;
        }
        return $this;
    }
    /**
     * Get TrialExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrialExpirationDate()
    {
        return isset($this->TrialExpirationDate) ? $this->TrialExpirationDate : null;
    }
    /**
     * Set TrialExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trialExpirationDate
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setTrialExpirationDate($trialExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($trialExpirationDate) && !is_string($trialExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trialExpirationDate, true), gettype($trialExpirationDate)), __LINE__);
        }
        if (is_null($trialExpirationDate) || (is_array($trialExpirationDate) && empty($trialExpirationDate))) {
            unset($this->TrialExpirationDate);
        } else {
            $this->TrialExpirationDate = $trialExpirationDate;
        }
        return $this;
    }
    /**
     * Get UiSkin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUiSkin()
    {
        return isset($this->UiSkin) ? $this->UiSkin : null;
    }
    /**
     * Set UiSkin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uiSkin
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setUiSkin($uiSkin = null)
    {
        // validation for constraint: string
        if (!is_null($uiSkin) && !is_string($uiSkin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uiSkin, true), gettype($uiSkin)), __LINE__);
        }
        if (is_null($uiSkin) || (is_array($uiSkin) && empty($uiSkin))) {
            unset($this->UiSkin);
        } else {
            $this->UiSkin = $uiSkin;
        }
        return $this;
    }
    /**
     * Get UsesStartDateAsFiscalYearName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsesStartDateAsFiscalYearName()
    {
        return isset($this->UsesStartDateAsFiscalYearName) ? $this->UsesStartDateAsFiscalYearName : null;
    }
    /**
     * Set UsesStartDateAsFiscalYearName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usesStartDateAsFiscalYearName
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setUsesStartDateAsFiscalYearName($usesStartDateAsFiscalYearName = null)
    {
        // validation for constraint: boolean
        if (!is_null($usesStartDateAsFiscalYearName) && !is_bool($usesStartDateAsFiscalYearName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usesStartDateAsFiscalYearName, true), gettype($usesStartDateAsFiscalYearName)), __LINE__);
        }
        if (is_null($usesStartDateAsFiscalYearName) || (is_array($usesStartDateAsFiscalYearName) && empty($usesStartDateAsFiscalYearName))) {
            unset($this->UsesStartDateAsFiscalYearName);
        } else {
            $this->UsesStartDateAsFiscalYearName = $usesStartDateAsFiscalYearName;
        }
        return $this;
    }
    /**
     * Get WebToCaseDefaultOrigin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebToCaseDefaultOrigin()
    {
        return isset($this->WebToCaseDefaultOrigin) ? $this->WebToCaseDefaultOrigin : null;
    }
    /**
     * Set WebToCaseDefaultOrigin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webToCaseDefaultOrigin
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public function setWebToCaseDefaultOrigin($webToCaseDefaultOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($webToCaseDefaultOrigin) && !is_string($webToCaseDefaultOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webToCaseDefaultOrigin, true), gettype($webToCaseDefaultOrigin)), __LINE__);
        }
        if (is_null($webToCaseDefaultOrigin) || (is_array($webToCaseDefaultOrigin) && empty($webToCaseDefaultOrigin))) {
            unset($this->WebToCaseDefaultOrigin);
        } else {
            $this->WebToCaseDefaultOrigin = $webToCaseDefaultOrigin;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\Organization
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
