<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpportunityHistory StructType
 * @subpackage Structs
 */
class OpportunityHistory extends SObject
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The CloseDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CloseDate;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The ExpectedRevenue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ExpectedRevenue;
    /**
     * The ForecastCategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForecastCategory;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The Opportunity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Opportunity
     */
    public $Opportunity;
    /**
     * The OpportunityId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OpportunityId;
    /**
     * The Probability
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Probability;
    /**
     * The StageName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StageName;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for OpportunityHistory
     * @uses OpportunityHistory::setAmount()
     * @uses OpportunityHistory::setCloseDate()
     * @uses OpportunityHistory::setCreatedBy()
     * @uses OpportunityHistory::setCreatedById()
     * @uses OpportunityHistory::setCreatedDate()
     * @uses OpportunityHistory::setExpectedRevenue()
     * @uses OpportunityHistory::setForecastCategory()
     * @uses OpportunityHistory::setIsDeleted()
     * @uses OpportunityHistory::setOpportunity()
     * @uses OpportunityHistory::setOpportunityId()
     * @uses OpportunityHistory::setProbability()
     * @uses OpportunityHistory::setStageName()
     * @uses OpportunityHistory::setSystemModstamp()
     * @param float $amount
     * @param string $closeDate
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param float $expectedRevenue
     * @param string $forecastCategory
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\Opportunity $opportunity
     * @param string $opportunityId
     * @param float $probability
     * @param string $stageName
     * @param string $systemModstamp
     */
    public function __construct($amount = null, $closeDate = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $expectedRevenue = null, $forecastCategory = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\Opportunity $opportunity = null, $opportunityId = null, $probability = null, $stageName = null, $systemModstamp = null)
    {
        $this
            ->setAmount($amount)
            ->setCloseDate($closeDate)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setExpectedRevenue($expectedRevenue)
            ->setForecastCategory($forecastCategory)
            ->setIsDeleted($isDeleted)
            ->setOpportunity($opportunity)
            ->setOpportunityId($opportunityId)
            ->setProbability($probability)
            ->setStageName($stageName)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amount
     * @return \NexusDigital/MiratelForce\StructType\OpportunityHistory
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get CloseDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCloseDate()
    {
        return isset($this->CloseDate) ? $this->CloseDate : null;
    }
    /**
     * Set CloseDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $closeDate
     * @return \NexusDigital/MiratelForce\StructType\OpportunityHistory
     */
    public function setCloseDate($closeDate = null)
    {
        // validation for constraint: string
        if (!is_null($closeDate) && !is_string($closeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closeDate, true), gettype($closeDate)), __LINE__);
        }
        if (is_null($closeDate) || (is_array($closeDate) && empty($closeDate))) {
            unset($this->CloseDate);
        } else {
            $this->CloseDate = $closeDate;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\OpportunityHistory
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\OpportunityHistory
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\OpportunityHistory
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get ExpectedRevenue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getExpectedRevenue()
    {
        return isset($this->ExpectedRevenue) ? $this->ExpectedRevenue : null;
    }
    /**
     * Set ExpectedRevenue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $expectedRevenue
     * @return \NexusDigital/MiratelForce\StructType\OpportunityHistory
     */
    public function setExpectedRevenue($expectedRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($expectedRevenue) && !(is_float($expectedRevenue) || is_numeric($expectedRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expectedRevenue, true), gettype($expectedRevenue)), __LINE__);
        }
        if (is_null($expectedRevenue) || (is_array($expectedRevenue) && empty($expectedRevenue))) {
            unset($this->ExpectedRevenue);
        } else {
            $this->ExpectedRevenue = $expectedRevenue;
        }
        return $this;
    }
    /**
     * Get ForecastCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastCategory()
    {
        return isset($this->ForecastCategory) ? $this->ForecastCategory : null;
    }
    /**
     * Set ForecastCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastCategory
     * @return \NexusDigital/MiratelForce\StructType\OpportunityHistory
     */
    public function setForecastCategory($forecastCategory = null)
    {
        // validation for constraint: string
        if (!is_null($forecastCategory) && !is_string($forecastCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastCategory, true), gettype($forecastCategory)), __LINE__);
        }
        if (is_null($forecastCategory) || (is_array($forecastCategory) && empty($forecastCategory))) {
            unset($this->ForecastCategory);
        } else {
            $this->ForecastCategory = $forecastCategory;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\OpportunityHistory
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get Opportunity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Opportunity|null
     */
    public function getOpportunity()
    {
        return isset($this->Opportunity) ? $this->Opportunity : null;
    }
    /**
     * Set Opportunity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Opportunity $opportunity
     * @return \NexusDigital/MiratelForce\StructType\OpportunityHistory
     */
    public function setOpportunity(\NexusDigital/MiratelForce\StructType\Opportunity $opportunity = null)
    {
        if (is_null($opportunity) || (is_array($opportunity) && empty($opportunity))) {
            unset($this->Opportunity);
        } else {
            $this->Opportunity = $opportunity;
        }
        return $this;
    }
    /**
     * Get OpportunityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpportunityId()
    {
        return isset($this->OpportunityId) ? $this->OpportunityId : null;
    }
    /**
     * Set OpportunityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opportunityId
     * @return \NexusDigital/MiratelForce\StructType\OpportunityHistory
     */
    public function setOpportunityId($opportunityId = null)
    {
        // validation for constraint: string
        if (!is_null($opportunityId) && !is_string($opportunityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opportunityId, true), gettype($opportunityId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($opportunityId) && mb_strlen($opportunityId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($opportunityId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($opportunityId) && !preg_match('/[a-zA-Z0-9]{18}/', $opportunityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($opportunityId, true)), __LINE__);
        }
        if (is_null($opportunityId) || (is_array($opportunityId) && empty($opportunityId))) {
            unset($this->OpportunityId);
        } else {
            $this->OpportunityId = $opportunityId;
        }
        return $this;
    }
    /**
     * Get Probability value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getProbability()
    {
        return isset($this->Probability) ? $this->Probability : null;
    }
    /**
     * Set Probability value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $probability
     * @return \NexusDigital/MiratelForce\StructType\OpportunityHistory
     */
    public function setProbability($probability = null)
    {
        // validation for constraint: float
        if (!is_null($probability) && !(is_float($probability) || is_numeric($probability))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($probability, true), gettype($probability)), __LINE__);
        }
        if (is_null($probability) || (is_array($probability) && empty($probability))) {
            unset($this->Probability);
        } else {
            $this->Probability = $probability;
        }
        return $this;
    }
    /**
     * Get StageName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStageName()
    {
        return isset($this->StageName) ? $this->StageName : null;
    }
    /**
     * Set StageName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stageName
     * @return \NexusDigital/MiratelForce\StructType\OpportunityHistory
     */
    public function setStageName($stageName = null)
    {
        // validation for constraint: string
        if (!is_null($stageName) && !is_string($stageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stageName, true), gettype($stageName)), __LINE__);
        }
        if (is_null($stageName) || (is_array($stageName) && empty($stageName))) {
            unset($this->StageName);
        } else {
            $this->StageName = $stageName;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\OpportunityHistory
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\OpportunityHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
