<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectPermissions StructType
 * @subpackage Structs
 */
class ObjectPermissions extends SObject
{
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The Parent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\PermissionSet
     */
    public $Parent;
    /**
     * The ParentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentId;
    /**
     * The PermissionsCreate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PermissionsCreate;
    /**
     * The PermissionsDelete
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PermissionsDelete;
    /**
     * The PermissionsEdit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PermissionsEdit;
    /**
     * The PermissionsModifyAllRecords
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PermissionsModifyAllRecords;
    /**
     * The PermissionsRead
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PermissionsRead;
    /**
     * The PermissionsViewAllRecords
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PermissionsViewAllRecords;
    /**
     * The SobjectType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SobjectType;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for ObjectPermissions
     * @uses ObjectPermissions::setCreatedBy()
     * @uses ObjectPermissions::setCreatedById()
     * @uses ObjectPermissions::setCreatedDate()
     * @uses ObjectPermissions::setLastModifiedBy()
     * @uses ObjectPermissions::setLastModifiedById()
     * @uses ObjectPermissions::setLastModifiedDate()
     * @uses ObjectPermissions::setParent()
     * @uses ObjectPermissions::setParentId()
     * @uses ObjectPermissions::setPermissionsCreate()
     * @uses ObjectPermissions::setPermissionsDelete()
     * @uses ObjectPermissions::setPermissionsEdit()
     * @uses ObjectPermissions::setPermissionsModifyAllRecords()
     * @uses ObjectPermissions::setPermissionsRead()
     * @uses ObjectPermissions::setPermissionsViewAllRecords()
     * @uses ObjectPermissions::setSobjectType()
     * @uses ObjectPermissions::setSystemModstamp()
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param \NexusDigital/MiratelForce\StructType\PermissionSet $parent
     * @param string $parentId
     * @param bool $permissionsCreate
     * @param bool $permissionsDelete
     * @param bool $permissionsEdit
     * @param bool $permissionsModifyAllRecords
     * @param bool $permissionsRead
     * @param bool $permissionsViewAllRecords
     * @param string $sobjectType
     * @param string $systemModstamp
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, \NexusDigital/MiratelForce\StructType\PermissionSet $parent = null, $parentId = null, $permissionsCreate = null, $permissionsDelete = null, $permissionsEdit = null, $permissionsModifyAllRecords = null, $permissionsRead = null, $permissionsViewAllRecords = null, $sobjectType = null, $systemModstamp = null)
    {
        $this
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setParent($parent)
            ->setParentId($parentId)
            ->setPermissionsCreate($permissionsCreate)
            ->setPermissionsDelete($permissionsDelete)
            ->setPermissionsEdit($permissionsEdit)
            ->setPermissionsModifyAllRecords($permissionsModifyAllRecords)
            ->setPermissionsRead($permissionsRead)
            ->setPermissionsViewAllRecords($permissionsViewAllRecords)
            ->setSobjectType($sobjectType)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get Parent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\PermissionSet|null
     */
    public function getParent()
    {
        return isset($this->Parent) ? $this->Parent : null;
    }
    /**
     * Set Parent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\PermissionSet $parent
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public function setParent(\NexusDigital/MiratelForce\StructType\PermissionSet $parent = null)
    {
        if (is_null($parent) || (is_array($parent) && empty($parent))) {
            unset($this->Parent);
        } else {
            $this->Parent = $parent;
        }
        return $this;
    }
    /**
     * Get ParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->ParentId) ? $this->ParentId : null;
    }
    /**
     * Set ParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentId) && mb_strlen($parentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentId, true)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->ParentId);
        } else {
            $this->ParentId = $parentId;
        }
        return $this;
    }
    /**
     * Get PermissionsCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPermissionsCreate()
    {
        return isset($this->PermissionsCreate) ? $this->PermissionsCreate : null;
    }
    /**
     * Set PermissionsCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $permissionsCreate
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public function setPermissionsCreate($permissionsCreate = null)
    {
        // validation for constraint: boolean
        if (!is_null($permissionsCreate) && !is_bool($permissionsCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($permissionsCreate, true), gettype($permissionsCreate)), __LINE__);
        }
        if (is_null($permissionsCreate) || (is_array($permissionsCreate) && empty($permissionsCreate))) {
            unset($this->PermissionsCreate);
        } else {
            $this->PermissionsCreate = $permissionsCreate;
        }
        return $this;
    }
    /**
     * Get PermissionsDelete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPermissionsDelete()
    {
        return isset($this->PermissionsDelete) ? $this->PermissionsDelete : null;
    }
    /**
     * Set PermissionsDelete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $permissionsDelete
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public function setPermissionsDelete($permissionsDelete = null)
    {
        // validation for constraint: boolean
        if (!is_null($permissionsDelete) && !is_bool($permissionsDelete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($permissionsDelete, true), gettype($permissionsDelete)), __LINE__);
        }
        if (is_null($permissionsDelete) || (is_array($permissionsDelete) && empty($permissionsDelete))) {
            unset($this->PermissionsDelete);
        } else {
            $this->PermissionsDelete = $permissionsDelete;
        }
        return $this;
    }
    /**
     * Get PermissionsEdit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPermissionsEdit()
    {
        return isset($this->PermissionsEdit) ? $this->PermissionsEdit : null;
    }
    /**
     * Set PermissionsEdit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $permissionsEdit
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public function setPermissionsEdit($permissionsEdit = null)
    {
        // validation for constraint: boolean
        if (!is_null($permissionsEdit) && !is_bool($permissionsEdit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($permissionsEdit, true), gettype($permissionsEdit)), __LINE__);
        }
        if (is_null($permissionsEdit) || (is_array($permissionsEdit) && empty($permissionsEdit))) {
            unset($this->PermissionsEdit);
        } else {
            $this->PermissionsEdit = $permissionsEdit;
        }
        return $this;
    }
    /**
     * Get PermissionsModifyAllRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPermissionsModifyAllRecords()
    {
        return isset($this->PermissionsModifyAllRecords) ? $this->PermissionsModifyAllRecords : null;
    }
    /**
     * Set PermissionsModifyAllRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $permissionsModifyAllRecords
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public function setPermissionsModifyAllRecords($permissionsModifyAllRecords = null)
    {
        // validation for constraint: boolean
        if (!is_null($permissionsModifyAllRecords) && !is_bool($permissionsModifyAllRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($permissionsModifyAllRecords, true), gettype($permissionsModifyAllRecords)), __LINE__);
        }
        if (is_null($permissionsModifyAllRecords) || (is_array($permissionsModifyAllRecords) && empty($permissionsModifyAllRecords))) {
            unset($this->PermissionsModifyAllRecords);
        } else {
            $this->PermissionsModifyAllRecords = $permissionsModifyAllRecords;
        }
        return $this;
    }
    /**
     * Get PermissionsRead value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPermissionsRead()
    {
        return isset($this->PermissionsRead) ? $this->PermissionsRead : null;
    }
    /**
     * Set PermissionsRead value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $permissionsRead
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public function setPermissionsRead($permissionsRead = null)
    {
        // validation for constraint: boolean
        if (!is_null($permissionsRead) && !is_bool($permissionsRead)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($permissionsRead, true), gettype($permissionsRead)), __LINE__);
        }
        if (is_null($permissionsRead) || (is_array($permissionsRead) && empty($permissionsRead))) {
            unset($this->PermissionsRead);
        } else {
            $this->PermissionsRead = $permissionsRead;
        }
        return $this;
    }
    /**
     * Get PermissionsViewAllRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPermissionsViewAllRecords()
    {
        return isset($this->PermissionsViewAllRecords) ? $this->PermissionsViewAllRecords : null;
    }
    /**
     * Set PermissionsViewAllRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $permissionsViewAllRecords
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public function setPermissionsViewAllRecords($permissionsViewAllRecords = null)
    {
        // validation for constraint: boolean
        if (!is_null($permissionsViewAllRecords) && !is_bool($permissionsViewAllRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($permissionsViewAllRecords, true), gettype($permissionsViewAllRecords)), __LINE__);
        }
        if (is_null($permissionsViewAllRecords) || (is_array($permissionsViewAllRecords) && empty($permissionsViewAllRecords))) {
            unset($this->PermissionsViewAllRecords);
        } else {
            $this->PermissionsViewAllRecords = $permissionsViewAllRecords;
        }
        return $this;
    }
    /**
     * Get SobjectType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSobjectType()
    {
        return isset($this->SobjectType) ? $this->SobjectType : null;
    }
    /**
     * Set SobjectType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sobjectType
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public function setSobjectType($sobjectType = null)
    {
        // validation for constraint: string
        if (!is_null($sobjectType) && !is_string($sobjectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sobjectType, true), gettype($sobjectType)), __LINE__);
        }
        if (is_null($sobjectType) || (is_array($sobjectType) && empty($sobjectType))) {
            unset($this->SobjectType);
        } else {
            $this->SobjectType = $sobjectType;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ObjectPermissions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
