<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NetworkSelfRegistration StructType
 * @subpackage Structs
 */
class NetworkSelfRegistration extends SObject
{
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Account
     */
    public $Account;
    /**
     * The AccountId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AccountId;
    /**
     * The ApexHandler
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ApexClass
     */
    public $ApexHandler;
    /**
     * The ApexHandlerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ApexHandlerId;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The ExecuteApexHandlerAs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $ExecuteApexHandlerAs;
    /**
     * The ExecuteApexHandlerAsId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ExecuteApexHandlerAsId;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The Network
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Network
     */
    public $Network;
    /**
     * The NetworkId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $NetworkId;
    /**
     * The OptionsIncludePassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsIncludePassword;
    /**
     * The OptionsShowEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsShowEmail;
    /**
     * The OptionsShowFirstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsShowFirstName;
    /**
     * The OptionsShowLastName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsShowLastName;
    /**
     * The OptionsShowMobilePhone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsShowMobilePhone;
    /**
     * The OptionsShowNickname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsShowNickname;
    /**
     * The OptionsShowUsername
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsShowUsername;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The UserRecordAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public $UserRecordAccess;
    /**
     * The VerificationMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VerificationMethod;
    /**
     * Constructor method for NetworkSelfRegistration
     * @uses NetworkSelfRegistration::setAccount()
     * @uses NetworkSelfRegistration::setAccountId()
     * @uses NetworkSelfRegistration::setApexHandler()
     * @uses NetworkSelfRegistration::setApexHandlerId()
     * @uses NetworkSelfRegistration::setCreatedBy()
     * @uses NetworkSelfRegistration::setCreatedById()
     * @uses NetworkSelfRegistration::setCreatedDate()
     * @uses NetworkSelfRegistration::setExecuteApexHandlerAs()
     * @uses NetworkSelfRegistration::setExecuteApexHandlerAsId()
     * @uses NetworkSelfRegistration::setIsDeleted()
     * @uses NetworkSelfRegistration::setLastModifiedBy()
     * @uses NetworkSelfRegistration::setLastModifiedById()
     * @uses NetworkSelfRegistration::setLastModifiedDate()
     * @uses NetworkSelfRegistration::setNetwork()
     * @uses NetworkSelfRegistration::setNetworkId()
     * @uses NetworkSelfRegistration::setOptionsIncludePassword()
     * @uses NetworkSelfRegistration::setOptionsShowEmail()
     * @uses NetworkSelfRegistration::setOptionsShowFirstName()
     * @uses NetworkSelfRegistration::setOptionsShowLastName()
     * @uses NetworkSelfRegistration::setOptionsShowMobilePhone()
     * @uses NetworkSelfRegistration::setOptionsShowNickname()
     * @uses NetworkSelfRegistration::setOptionsShowUsername()
     * @uses NetworkSelfRegistration::setSystemModstamp()
     * @uses NetworkSelfRegistration::setUserRecordAccess()
     * @uses NetworkSelfRegistration::setVerificationMethod()
     * @param \NexusDigital/MiratelForce\StructType\Account $account
     * @param string $accountId
     * @param \NexusDigital/MiratelForce\StructType\ApexClass $apexHandler
     * @param string $apexHandlerId
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\User $executeApexHandlerAs
     * @param string $executeApexHandlerAsId
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param \NexusDigital/MiratelForce\StructType\Network $network
     * @param string $networkId
     * @param bool $optionsIncludePassword
     * @param bool $optionsShowEmail
     * @param bool $optionsShowFirstName
     * @param bool $optionsShowLastName
     * @param bool $optionsShowMobilePhone
     * @param bool $optionsShowNickname
     * @param bool $optionsShowUsername
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @param string $verificationMethod
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\Account $account = null, $accountId = null, \NexusDigital/MiratelForce\StructType\ApexClass $apexHandler = null, $apexHandlerId = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\User $executeApexHandlerAs = null, $executeApexHandlerAsId = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, \NexusDigital/MiratelForce\StructType\Network $network = null, $networkId = null, $optionsIncludePassword = null, $optionsShowEmail = null, $optionsShowFirstName = null, $optionsShowLastName = null, $optionsShowMobilePhone = null, $optionsShowNickname = null, $optionsShowUsername = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null, $verificationMethod = null)
    {
        $this
            ->setAccount($account)
            ->setAccountId($accountId)
            ->setApexHandler($apexHandler)
            ->setApexHandlerId($apexHandlerId)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setExecuteApexHandlerAs($executeApexHandlerAs)
            ->setExecuteApexHandlerAsId($executeApexHandlerAsId)
            ->setIsDeleted($isDeleted)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setNetwork($network)
            ->setNetworkId($networkId)
            ->setOptionsIncludePassword($optionsIncludePassword)
            ->setOptionsShowEmail($optionsShowEmail)
            ->setOptionsShowFirstName($optionsShowFirstName)
            ->setOptionsShowLastName($optionsShowLastName)
            ->setOptionsShowMobilePhone($optionsShowMobilePhone)
            ->setOptionsShowNickname($optionsShowNickname)
            ->setOptionsShowUsername($optionsShowUsername)
            ->setSystemModstamp($systemModstamp)
            ->setUserRecordAccess($userRecordAccess)
            ->setVerificationMethod($verificationMethod);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Account|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Account $account
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setAccount(\NexusDigital/MiratelForce\StructType\Account $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get AccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountId()
    {
        return isset($this->AccountId) ? $this->AccountId : null;
    }
    /**
     * Set AccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountId
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($accountId) && mb_strlen($accountId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($accountId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($accountId) && !preg_match('/[a-zA-Z0-9]{18}/', $accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($accountId, true)), __LINE__);
        }
        if (is_null($accountId) || (is_array($accountId) && empty($accountId))) {
            unset($this->AccountId);
        } else {
            $this->AccountId = $accountId;
        }
        return $this;
    }
    /**
     * Get ApexHandler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ApexClass|null
     */
    public function getApexHandler()
    {
        return isset($this->ApexHandler) ? $this->ApexHandler : null;
    }
    /**
     * Set ApexHandler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ApexClass $apexHandler
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setApexHandler(\NexusDigital/MiratelForce\StructType\ApexClass $apexHandler = null)
    {
        if (is_null($apexHandler) || (is_array($apexHandler) && empty($apexHandler))) {
            unset($this->ApexHandler);
        } else {
            $this->ApexHandler = $apexHandler;
        }
        return $this;
    }
    /**
     * Get ApexHandlerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApexHandlerId()
    {
        return isset($this->ApexHandlerId) ? $this->ApexHandlerId : null;
    }
    /**
     * Set ApexHandlerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apexHandlerId
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setApexHandlerId($apexHandlerId = null)
    {
        // validation for constraint: string
        if (!is_null($apexHandlerId) && !is_string($apexHandlerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apexHandlerId, true), gettype($apexHandlerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($apexHandlerId) && mb_strlen($apexHandlerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($apexHandlerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($apexHandlerId) && !preg_match('/[a-zA-Z0-9]{18}/', $apexHandlerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($apexHandlerId, true)), __LINE__);
        }
        if (is_null($apexHandlerId) || (is_array($apexHandlerId) && empty($apexHandlerId))) {
            unset($this->ApexHandlerId);
        } else {
            $this->ApexHandlerId = $apexHandlerId;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get ExecuteApexHandlerAs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getExecuteApexHandlerAs()
    {
        return isset($this->ExecuteApexHandlerAs) ? $this->ExecuteApexHandlerAs : null;
    }
    /**
     * Set ExecuteApexHandlerAs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $executeApexHandlerAs
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setExecuteApexHandlerAs(\NexusDigital/MiratelForce\StructType\User $executeApexHandlerAs = null)
    {
        if (is_null($executeApexHandlerAs) || (is_array($executeApexHandlerAs) && empty($executeApexHandlerAs))) {
            unset($this->ExecuteApexHandlerAs);
        } else {
            $this->ExecuteApexHandlerAs = $executeApexHandlerAs;
        }
        return $this;
    }
    /**
     * Get ExecuteApexHandlerAsId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecuteApexHandlerAsId()
    {
        return isset($this->ExecuteApexHandlerAsId) ? $this->ExecuteApexHandlerAsId : null;
    }
    /**
     * Set ExecuteApexHandlerAsId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executeApexHandlerAsId
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setExecuteApexHandlerAsId($executeApexHandlerAsId = null)
    {
        // validation for constraint: string
        if (!is_null($executeApexHandlerAsId) && !is_string($executeApexHandlerAsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executeApexHandlerAsId, true), gettype($executeApexHandlerAsId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($executeApexHandlerAsId) && mb_strlen($executeApexHandlerAsId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($executeApexHandlerAsId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($executeApexHandlerAsId) && !preg_match('/[a-zA-Z0-9]{18}/', $executeApexHandlerAsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($executeApexHandlerAsId, true)), __LINE__);
        }
        if (is_null($executeApexHandlerAsId) || (is_array($executeApexHandlerAsId) && empty($executeApexHandlerAsId))) {
            unset($this->ExecuteApexHandlerAsId);
        } else {
            $this->ExecuteApexHandlerAsId = $executeApexHandlerAsId;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get Network value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Network|null
     */
    public function getNetwork()
    {
        return isset($this->Network) ? $this->Network : null;
    }
    /**
     * Set Network value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Network $network
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setNetwork(\NexusDigital/MiratelForce\StructType\Network $network = null)
    {
        if (is_null($network) || (is_array($network) && empty($network))) {
            unset($this->Network);
        } else {
            $this->Network = $network;
        }
        return $this;
    }
    /**
     * Get NetworkId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkId()
    {
        return isset($this->NetworkId) ? $this->NetworkId : null;
    }
    /**
     * Set NetworkId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkId
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setNetworkId($networkId = null)
    {
        // validation for constraint: string
        if (!is_null($networkId) && !is_string($networkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($networkId, true), gettype($networkId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($networkId) && mb_strlen($networkId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($networkId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($networkId) && !preg_match('/[a-zA-Z0-9]{18}/', $networkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($networkId, true)), __LINE__);
        }
        if (is_null($networkId) || (is_array($networkId) && empty($networkId))) {
            unset($this->NetworkId);
        } else {
            $this->NetworkId = $networkId;
        }
        return $this;
    }
    /**
     * Get OptionsIncludePassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsIncludePassword()
    {
        return isset($this->OptionsIncludePassword) ? $this->OptionsIncludePassword : null;
    }
    /**
     * Set OptionsIncludePassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsIncludePassword
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setOptionsIncludePassword($optionsIncludePassword = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsIncludePassword) && !is_bool($optionsIncludePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsIncludePassword, true), gettype($optionsIncludePassword)), __LINE__);
        }
        if (is_null($optionsIncludePassword) || (is_array($optionsIncludePassword) && empty($optionsIncludePassword))) {
            unset($this->OptionsIncludePassword);
        } else {
            $this->OptionsIncludePassword = $optionsIncludePassword;
        }
        return $this;
    }
    /**
     * Get OptionsShowEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsShowEmail()
    {
        return isset($this->OptionsShowEmail) ? $this->OptionsShowEmail : null;
    }
    /**
     * Set OptionsShowEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsShowEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setOptionsShowEmail($optionsShowEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsShowEmail) && !is_bool($optionsShowEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsShowEmail, true), gettype($optionsShowEmail)), __LINE__);
        }
        if (is_null($optionsShowEmail) || (is_array($optionsShowEmail) && empty($optionsShowEmail))) {
            unset($this->OptionsShowEmail);
        } else {
            $this->OptionsShowEmail = $optionsShowEmail;
        }
        return $this;
    }
    /**
     * Get OptionsShowFirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsShowFirstName()
    {
        return isset($this->OptionsShowFirstName) ? $this->OptionsShowFirstName : null;
    }
    /**
     * Set OptionsShowFirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsShowFirstName
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setOptionsShowFirstName($optionsShowFirstName = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsShowFirstName) && !is_bool($optionsShowFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsShowFirstName, true), gettype($optionsShowFirstName)), __LINE__);
        }
        if (is_null($optionsShowFirstName) || (is_array($optionsShowFirstName) && empty($optionsShowFirstName))) {
            unset($this->OptionsShowFirstName);
        } else {
            $this->OptionsShowFirstName = $optionsShowFirstName;
        }
        return $this;
    }
    /**
     * Get OptionsShowLastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsShowLastName()
    {
        return isset($this->OptionsShowLastName) ? $this->OptionsShowLastName : null;
    }
    /**
     * Set OptionsShowLastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsShowLastName
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setOptionsShowLastName($optionsShowLastName = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsShowLastName) && !is_bool($optionsShowLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsShowLastName, true), gettype($optionsShowLastName)), __LINE__);
        }
        if (is_null($optionsShowLastName) || (is_array($optionsShowLastName) && empty($optionsShowLastName))) {
            unset($this->OptionsShowLastName);
        } else {
            $this->OptionsShowLastName = $optionsShowLastName;
        }
        return $this;
    }
    /**
     * Get OptionsShowMobilePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsShowMobilePhone()
    {
        return isset($this->OptionsShowMobilePhone) ? $this->OptionsShowMobilePhone : null;
    }
    /**
     * Set OptionsShowMobilePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsShowMobilePhone
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setOptionsShowMobilePhone($optionsShowMobilePhone = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsShowMobilePhone) && !is_bool($optionsShowMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsShowMobilePhone, true), gettype($optionsShowMobilePhone)), __LINE__);
        }
        if (is_null($optionsShowMobilePhone) || (is_array($optionsShowMobilePhone) && empty($optionsShowMobilePhone))) {
            unset($this->OptionsShowMobilePhone);
        } else {
            $this->OptionsShowMobilePhone = $optionsShowMobilePhone;
        }
        return $this;
    }
    /**
     * Get OptionsShowNickname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsShowNickname()
    {
        return isset($this->OptionsShowNickname) ? $this->OptionsShowNickname : null;
    }
    /**
     * Set OptionsShowNickname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsShowNickname
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setOptionsShowNickname($optionsShowNickname = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsShowNickname) && !is_bool($optionsShowNickname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsShowNickname, true), gettype($optionsShowNickname)), __LINE__);
        }
        if (is_null($optionsShowNickname) || (is_array($optionsShowNickname) && empty($optionsShowNickname))) {
            unset($this->OptionsShowNickname);
        } else {
            $this->OptionsShowNickname = $optionsShowNickname;
        }
        return $this;
    }
    /**
     * Get OptionsShowUsername value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsShowUsername()
    {
        return isset($this->OptionsShowUsername) ? $this->OptionsShowUsername : null;
    }
    /**
     * Set OptionsShowUsername value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsShowUsername
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setOptionsShowUsername($optionsShowUsername = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsShowUsername) && !is_bool($optionsShowUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsShowUsername, true), gettype($optionsShowUsername)), __LINE__);
        }
        if (is_null($optionsShowUsername) || (is_array($optionsShowUsername) && empty($optionsShowUsername))) {
            unset($this->OptionsShowUsername);
        } else {
            $this->OptionsShowUsername = $optionsShowUsername;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get UserRecordAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess|null
     */
    public function getUserRecordAccess()
    {
        return isset($this->UserRecordAccess) ? $this->UserRecordAccess : null;
    }
    /**
     * Set UserRecordAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setUserRecordAccess(\NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        if (is_null($userRecordAccess) || (is_array($userRecordAccess) && empty($userRecordAccess))) {
            unset($this->UserRecordAccess);
        } else {
            $this->UserRecordAccess = $userRecordAccess;
        }
        return $this;
    }
    /**
     * Get VerificationMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVerificationMethod()
    {
        return isset($this->VerificationMethod) ? $this->VerificationMethod : null;
    }
    /**
     * Set VerificationMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $verificationMethod
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public function setVerificationMethod($verificationMethod = null)
    {
        // validation for constraint: string
        if (!is_null($verificationMethod) && !is_string($verificationMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verificationMethod, true), gettype($verificationMethod)), __LINE__);
        }
        if (is_null($verificationMethod) || (is_array($verificationMethod) && empty($verificationMethod))) {
            unset($this->VerificationMethod);
        } else {
            $this->VerificationMethod = $verificationMethod;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\NetworkSelfRegistration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
