<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NetworkMember StructType
 * @subpackage Structs
 */
class NetworkMember extends SObject
{
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DefaultGroupNotificationFrequency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultGroupNotificationFrequency;
    /**
     * The DigestFrequency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DigestFrequency;
    /**
     * The LastChatterActivityDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastChatterActivityDate;
    /**
     * The Member
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $Member;
    /**
     * The MemberId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $MemberId;
    /**
     * The Network
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Network
     */
    public $Network;
    /**
     * The NetworkId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $NetworkId;
    /**
     * The PreferencesDisCommentAfterLikeEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisCommentAfterLikeEmail;
    /**
     * The PreferencesDisMentionsCommentEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisMentionsCommentEmail;
    /**
     * The PreferencesDisProfPostCommentEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisProfPostCommentEmail;
    /**
     * The PreferencesDisableAllFeedsEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisableAllFeedsEmail;
    /**
     * The PreferencesDisableBestAnswerEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisableBestAnswerEmail;
    /**
     * The PreferencesDisableBookmarkEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisableBookmarkEmail;
    /**
     * The PreferencesDisableChangeCommentEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisableChangeCommentEmail;
    /**
     * The PreferencesDisableDirectMessageEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisableDirectMessageEmail;
    /**
     * The PreferencesDisableEndorsementEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisableEndorsementEmail;
    /**
     * The PreferencesDisableFollowersEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisableFollowersEmail;
    /**
     * The PreferencesDisableItemFlaggedEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisableItemFlaggedEmail;
    /**
     * The PreferencesDisableLaterCommentEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisableLaterCommentEmail;
    /**
     * The PreferencesDisableLikeEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisableLikeEmail;
    /**
     * The PreferencesDisableMentionsPostEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisableMentionsPostEmail;
    /**
     * The PreferencesDisableMessageEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisableMessageEmail;
    /**
     * The PreferencesDisablePendingReviewEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisablePendingReviewEmail;
    /**
     * The PreferencesDisableProfilePostEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisableProfilePostEmail;
    /**
     * The PreferencesDisableSharePostEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesDisableSharePostEmail;
    /**
     * The ReputationPoints
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ReputationPoints;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for NetworkMember
     * @uses NetworkMember::setCreatedBy()
     * @uses NetworkMember::setCreatedById()
     * @uses NetworkMember::setCreatedDate()
     * @uses NetworkMember::setDefaultGroupNotificationFrequency()
     * @uses NetworkMember::setDigestFrequency()
     * @uses NetworkMember::setLastChatterActivityDate()
     * @uses NetworkMember::setMember()
     * @uses NetworkMember::setMemberId()
     * @uses NetworkMember::setNetwork()
     * @uses NetworkMember::setNetworkId()
     * @uses NetworkMember::setPreferencesDisCommentAfterLikeEmail()
     * @uses NetworkMember::setPreferencesDisMentionsCommentEmail()
     * @uses NetworkMember::setPreferencesDisProfPostCommentEmail()
     * @uses NetworkMember::setPreferencesDisableAllFeedsEmail()
     * @uses NetworkMember::setPreferencesDisableBestAnswerEmail()
     * @uses NetworkMember::setPreferencesDisableBookmarkEmail()
     * @uses NetworkMember::setPreferencesDisableChangeCommentEmail()
     * @uses NetworkMember::setPreferencesDisableDirectMessageEmail()
     * @uses NetworkMember::setPreferencesDisableEndorsementEmail()
     * @uses NetworkMember::setPreferencesDisableFollowersEmail()
     * @uses NetworkMember::setPreferencesDisableItemFlaggedEmail()
     * @uses NetworkMember::setPreferencesDisableLaterCommentEmail()
     * @uses NetworkMember::setPreferencesDisableLikeEmail()
     * @uses NetworkMember::setPreferencesDisableMentionsPostEmail()
     * @uses NetworkMember::setPreferencesDisableMessageEmail()
     * @uses NetworkMember::setPreferencesDisablePendingReviewEmail()
     * @uses NetworkMember::setPreferencesDisableProfilePostEmail()
     * @uses NetworkMember::setPreferencesDisableSharePostEmail()
     * @uses NetworkMember::setReputationPoints()
     * @uses NetworkMember::setSystemModstamp()
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $defaultGroupNotificationFrequency
     * @param string $digestFrequency
     * @param string $lastChatterActivityDate
     * @param \NexusDigital/MiratelForce\StructType\User $member
     * @param string $memberId
     * @param \NexusDigital/MiratelForce\StructType\Network $network
     * @param string $networkId
     * @param bool $preferencesDisCommentAfterLikeEmail
     * @param bool $preferencesDisMentionsCommentEmail
     * @param bool $preferencesDisProfPostCommentEmail
     * @param bool $preferencesDisableAllFeedsEmail
     * @param bool $preferencesDisableBestAnswerEmail
     * @param bool $preferencesDisableBookmarkEmail
     * @param bool $preferencesDisableChangeCommentEmail
     * @param bool $preferencesDisableDirectMessageEmail
     * @param bool $preferencesDisableEndorsementEmail
     * @param bool $preferencesDisableFollowersEmail
     * @param bool $preferencesDisableItemFlaggedEmail
     * @param bool $preferencesDisableLaterCommentEmail
     * @param bool $preferencesDisableLikeEmail
     * @param bool $preferencesDisableMentionsPostEmail
     * @param bool $preferencesDisableMessageEmail
     * @param bool $preferencesDisablePendingReviewEmail
     * @param bool $preferencesDisableProfilePostEmail
     * @param bool $preferencesDisableSharePostEmail
     * @param float $reputationPoints
     * @param string $systemModstamp
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $defaultGroupNotificationFrequency = null, $digestFrequency = null, $lastChatterActivityDate = null, \NexusDigital/MiratelForce\StructType\User $member = null, $memberId = null, \NexusDigital/MiratelForce\StructType\Network $network = null, $networkId = null, $preferencesDisCommentAfterLikeEmail = null, $preferencesDisMentionsCommentEmail = null, $preferencesDisProfPostCommentEmail = null, $preferencesDisableAllFeedsEmail = null, $preferencesDisableBestAnswerEmail = null, $preferencesDisableBookmarkEmail = null, $preferencesDisableChangeCommentEmail = null, $preferencesDisableDirectMessageEmail = null, $preferencesDisableEndorsementEmail = null, $preferencesDisableFollowersEmail = null, $preferencesDisableItemFlaggedEmail = null, $preferencesDisableLaterCommentEmail = null, $preferencesDisableLikeEmail = null, $preferencesDisableMentionsPostEmail = null, $preferencesDisableMessageEmail = null, $preferencesDisablePendingReviewEmail = null, $preferencesDisableProfilePostEmail = null, $preferencesDisableSharePostEmail = null, $reputationPoints = null, $systemModstamp = null)
    {
        $this
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDefaultGroupNotificationFrequency($defaultGroupNotificationFrequency)
            ->setDigestFrequency($digestFrequency)
            ->setLastChatterActivityDate($lastChatterActivityDate)
            ->setMember($member)
            ->setMemberId($memberId)
            ->setNetwork($network)
            ->setNetworkId($networkId)
            ->setPreferencesDisCommentAfterLikeEmail($preferencesDisCommentAfterLikeEmail)
            ->setPreferencesDisMentionsCommentEmail($preferencesDisMentionsCommentEmail)
            ->setPreferencesDisProfPostCommentEmail($preferencesDisProfPostCommentEmail)
            ->setPreferencesDisableAllFeedsEmail($preferencesDisableAllFeedsEmail)
            ->setPreferencesDisableBestAnswerEmail($preferencesDisableBestAnswerEmail)
            ->setPreferencesDisableBookmarkEmail($preferencesDisableBookmarkEmail)
            ->setPreferencesDisableChangeCommentEmail($preferencesDisableChangeCommentEmail)
            ->setPreferencesDisableDirectMessageEmail($preferencesDisableDirectMessageEmail)
            ->setPreferencesDisableEndorsementEmail($preferencesDisableEndorsementEmail)
            ->setPreferencesDisableFollowersEmail($preferencesDisableFollowersEmail)
            ->setPreferencesDisableItemFlaggedEmail($preferencesDisableItemFlaggedEmail)
            ->setPreferencesDisableLaterCommentEmail($preferencesDisableLaterCommentEmail)
            ->setPreferencesDisableLikeEmail($preferencesDisableLikeEmail)
            ->setPreferencesDisableMentionsPostEmail($preferencesDisableMentionsPostEmail)
            ->setPreferencesDisableMessageEmail($preferencesDisableMessageEmail)
            ->setPreferencesDisablePendingReviewEmail($preferencesDisablePendingReviewEmail)
            ->setPreferencesDisableProfilePostEmail($preferencesDisableProfilePostEmail)
            ->setPreferencesDisableSharePostEmail($preferencesDisableSharePostEmail)
            ->setReputationPoints($reputationPoints)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DefaultGroupNotificationFrequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultGroupNotificationFrequency()
    {
        return isset($this->DefaultGroupNotificationFrequency) ? $this->DefaultGroupNotificationFrequency : null;
    }
    /**
     * Set DefaultGroupNotificationFrequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultGroupNotificationFrequency
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setDefaultGroupNotificationFrequency($defaultGroupNotificationFrequency = null)
    {
        // validation for constraint: string
        if (!is_null($defaultGroupNotificationFrequency) && !is_string($defaultGroupNotificationFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultGroupNotificationFrequency, true), gettype($defaultGroupNotificationFrequency)), __LINE__);
        }
        if (is_null($defaultGroupNotificationFrequency) || (is_array($defaultGroupNotificationFrequency) && empty($defaultGroupNotificationFrequency))) {
            unset($this->DefaultGroupNotificationFrequency);
        } else {
            $this->DefaultGroupNotificationFrequency = $defaultGroupNotificationFrequency;
        }
        return $this;
    }
    /**
     * Get DigestFrequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDigestFrequency()
    {
        return isset($this->DigestFrequency) ? $this->DigestFrequency : null;
    }
    /**
     * Set DigestFrequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $digestFrequency
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setDigestFrequency($digestFrequency = null)
    {
        // validation for constraint: string
        if (!is_null($digestFrequency) && !is_string($digestFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digestFrequency, true), gettype($digestFrequency)), __LINE__);
        }
        if (is_null($digestFrequency) || (is_array($digestFrequency) && empty($digestFrequency))) {
            unset($this->DigestFrequency);
        } else {
            $this->DigestFrequency = $digestFrequency;
        }
        return $this;
    }
    /**
     * Get LastChatterActivityDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastChatterActivityDate()
    {
        return isset($this->LastChatterActivityDate) ? $this->LastChatterActivityDate : null;
    }
    /**
     * Set LastChatterActivityDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastChatterActivityDate
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setLastChatterActivityDate($lastChatterActivityDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastChatterActivityDate) && !is_string($lastChatterActivityDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastChatterActivityDate, true), gettype($lastChatterActivityDate)), __LINE__);
        }
        if (is_null($lastChatterActivityDate) || (is_array($lastChatterActivityDate) && empty($lastChatterActivityDate))) {
            unset($this->LastChatterActivityDate);
        } else {
            $this->LastChatterActivityDate = $lastChatterActivityDate;
        }
        return $this;
    }
    /**
     * Get Member value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getMember()
    {
        return isset($this->Member) ? $this->Member : null;
    }
    /**
     * Set Member value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $member
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setMember(\NexusDigital/MiratelForce\StructType\User $member = null)
    {
        if (is_null($member) || (is_array($member) && empty($member))) {
            unset($this->Member);
        } else {
            $this->Member = $member;
        }
        return $this;
    }
    /**
     * Get MemberId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMemberId()
    {
        return isset($this->MemberId) ? $this->MemberId : null;
    }
    /**
     * Set MemberId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $memberId
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setMemberId($memberId = null)
    {
        // validation for constraint: string
        if (!is_null($memberId) && !is_string($memberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberId, true), gettype($memberId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($memberId) && mb_strlen($memberId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($memberId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($memberId) && !preg_match('/[a-zA-Z0-9]{18}/', $memberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($memberId, true)), __LINE__);
        }
        if (is_null($memberId) || (is_array($memberId) && empty($memberId))) {
            unset($this->MemberId);
        } else {
            $this->MemberId = $memberId;
        }
        return $this;
    }
    /**
     * Get Network value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Network|null
     */
    public function getNetwork()
    {
        return isset($this->Network) ? $this->Network : null;
    }
    /**
     * Set Network value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Network $network
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setNetwork(\NexusDigital/MiratelForce\StructType\Network $network = null)
    {
        if (is_null($network) || (is_array($network) && empty($network))) {
            unset($this->Network);
        } else {
            $this->Network = $network;
        }
        return $this;
    }
    /**
     * Get NetworkId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkId()
    {
        return isset($this->NetworkId) ? $this->NetworkId : null;
    }
    /**
     * Set NetworkId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkId
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setNetworkId($networkId = null)
    {
        // validation for constraint: string
        if (!is_null($networkId) && !is_string($networkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($networkId, true), gettype($networkId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($networkId) && mb_strlen($networkId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($networkId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($networkId) && !preg_match('/[a-zA-Z0-9]{18}/', $networkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($networkId, true)), __LINE__);
        }
        if (is_null($networkId) || (is_array($networkId) && empty($networkId))) {
            unset($this->NetworkId);
        } else {
            $this->NetworkId = $networkId;
        }
        return $this;
    }
    /**
     * Get PreferencesDisCommentAfterLikeEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisCommentAfterLikeEmail()
    {
        return isset($this->PreferencesDisCommentAfterLikeEmail) ? $this->PreferencesDisCommentAfterLikeEmail : null;
    }
    /**
     * Set PreferencesDisCommentAfterLikeEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisCommentAfterLikeEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisCommentAfterLikeEmail($preferencesDisCommentAfterLikeEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisCommentAfterLikeEmail) && !is_bool($preferencesDisCommentAfterLikeEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisCommentAfterLikeEmail, true), gettype($preferencesDisCommentAfterLikeEmail)), __LINE__);
        }
        if (is_null($preferencesDisCommentAfterLikeEmail) || (is_array($preferencesDisCommentAfterLikeEmail) && empty($preferencesDisCommentAfterLikeEmail))) {
            unset($this->PreferencesDisCommentAfterLikeEmail);
        } else {
            $this->PreferencesDisCommentAfterLikeEmail = $preferencesDisCommentAfterLikeEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisMentionsCommentEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisMentionsCommentEmail()
    {
        return isset($this->PreferencesDisMentionsCommentEmail) ? $this->PreferencesDisMentionsCommentEmail : null;
    }
    /**
     * Set PreferencesDisMentionsCommentEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisMentionsCommentEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisMentionsCommentEmail($preferencesDisMentionsCommentEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisMentionsCommentEmail) && !is_bool($preferencesDisMentionsCommentEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisMentionsCommentEmail, true), gettype($preferencesDisMentionsCommentEmail)), __LINE__);
        }
        if (is_null($preferencesDisMentionsCommentEmail) || (is_array($preferencesDisMentionsCommentEmail) && empty($preferencesDisMentionsCommentEmail))) {
            unset($this->PreferencesDisMentionsCommentEmail);
        } else {
            $this->PreferencesDisMentionsCommentEmail = $preferencesDisMentionsCommentEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisProfPostCommentEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisProfPostCommentEmail()
    {
        return isset($this->PreferencesDisProfPostCommentEmail) ? $this->PreferencesDisProfPostCommentEmail : null;
    }
    /**
     * Set PreferencesDisProfPostCommentEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisProfPostCommentEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisProfPostCommentEmail($preferencesDisProfPostCommentEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisProfPostCommentEmail) && !is_bool($preferencesDisProfPostCommentEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisProfPostCommentEmail, true), gettype($preferencesDisProfPostCommentEmail)), __LINE__);
        }
        if (is_null($preferencesDisProfPostCommentEmail) || (is_array($preferencesDisProfPostCommentEmail) && empty($preferencesDisProfPostCommentEmail))) {
            unset($this->PreferencesDisProfPostCommentEmail);
        } else {
            $this->PreferencesDisProfPostCommentEmail = $preferencesDisProfPostCommentEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisableAllFeedsEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisableAllFeedsEmail()
    {
        return isset($this->PreferencesDisableAllFeedsEmail) ? $this->PreferencesDisableAllFeedsEmail : null;
    }
    /**
     * Set PreferencesDisableAllFeedsEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisableAllFeedsEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisableAllFeedsEmail($preferencesDisableAllFeedsEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisableAllFeedsEmail) && !is_bool($preferencesDisableAllFeedsEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisableAllFeedsEmail, true), gettype($preferencesDisableAllFeedsEmail)), __LINE__);
        }
        if (is_null($preferencesDisableAllFeedsEmail) || (is_array($preferencesDisableAllFeedsEmail) && empty($preferencesDisableAllFeedsEmail))) {
            unset($this->PreferencesDisableAllFeedsEmail);
        } else {
            $this->PreferencesDisableAllFeedsEmail = $preferencesDisableAllFeedsEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisableBestAnswerEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisableBestAnswerEmail()
    {
        return isset($this->PreferencesDisableBestAnswerEmail) ? $this->PreferencesDisableBestAnswerEmail : null;
    }
    /**
     * Set PreferencesDisableBestAnswerEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisableBestAnswerEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisableBestAnswerEmail($preferencesDisableBestAnswerEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisableBestAnswerEmail) && !is_bool($preferencesDisableBestAnswerEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisableBestAnswerEmail, true), gettype($preferencesDisableBestAnswerEmail)), __LINE__);
        }
        if (is_null($preferencesDisableBestAnswerEmail) || (is_array($preferencesDisableBestAnswerEmail) && empty($preferencesDisableBestAnswerEmail))) {
            unset($this->PreferencesDisableBestAnswerEmail);
        } else {
            $this->PreferencesDisableBestAnswerEmail = $preferencesDisableBestAnswerEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisableBookmarkEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisableBookmarkEmail()
    {
        return isset($this->PreferencesDisableBookmarkEmail) ? $this->PreferencesDisableBookmarkEmail : null;
    }
    /**
     * Set PreferencesDisableBookmarkEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisableBookmarkEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisableBookmarkEmail($preferencesDisableBookmarkEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisableBookmarkEmail) && !is_bool($preferencesDisableBookmarkEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisableBookmarkEmail, true), gettype($preferencesDisableBookmarkEmail)), __LINE__);
        }
        if (is_null($preferencesDisableBookmarkEmail) || (is_array($preferencesDisableBookmarkEmail) && empty($preferencesDisableBookmarkEmail))) {
            unset($this->PreferencesDisableBookmarkEmail);
        } else {
            $this->PreferencesDisableBookmarkEmail = $preferencesDisableBookmarkEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisableChangeCommentEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisableChangeCommentEmail()
    {
        return isset($this->PreferencesDisableChangeCommentEmail) ? $this->PreferencesDisableChangeCommentEmail : null;
    }
    /**
     * Set PreferencesDisableChangeCommentEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisableChangeCommentEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisableChangeCommentEmail($preferencesDisableChangeCommentEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisableChangeCommentEmail) && !is_bool($preferencesDisableChangeCommentEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisableChangeCommentEmail, true), gettype($preferencesDisableChangeCommentEmail)), __LINE__);
        }
        if (is_null($preferencesDisableChangeCommentEmail) || (is_array($preferencesDisableChangeCommentEmail) && empty($preferencesDisableChangeCommentEmail))) {
            unset($this->PreferencesDisableChangeCommentEmail);
        } else {
            $this->PreferencesDisableChangeCommentEmail = $preferencesDisableChangeCommentEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisableDirectMessageEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisableDirectMessageEmail()
    {
        return isset($this->PreferencesDisableDirectMessageEmail) ? $this->PreferencesDisableDirectMessageEmail : null;
    }
    /**
     * Set PreferencesDisableDirectMessageEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisableDirectMessageEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisableDirectMessageEmail($preferencesDisableDirectMessageEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisableDirectMessageEmail) && !is_bool($preferencesDisableDirectMessageEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisableDirectMessageEmail, true), gettype($preferencesDisableDirectMessageEmail)), __LINE__);
        }
        if (is_null($preferencesDisableDirectMessageEmail) || (is_array($preferencesDisableDirectMessageEmail) && empty($preferencesDisableDirectMessageEmail))) {
            unset($this->PreferencesDisableDirectMessageEmail);
        } else {
            $this->PreferencesDisableDirectMessageEmail = $preferencesDisableDirectMessageEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisableEndorsementEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisableEndorsementEmail()
    {
        return isset($this->PreferencesDisableEndorsementEmail) ? $this->PreferencesDisableEndorsementEmail : null;
    }
    /**
     * Set PreferencesDisableEndorsementEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisableEndorsementEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisableEndorsementEmail($preferencesDisableEndorsementEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisableEndorsementEmail) && !is_bool($preferencesDisableEndorsementEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisableEndorsementEmail, true), gettype($preferencesDisableEndorsementEmail)), __LINE__);
        }
        if (is_null($preferencesDisableEndorsementEmail) || (is_array($preferencesDisableEndorsementEmail) && empty($preferencesDisableEndorsementEmail))) {
            unset($this->PreferencesDisableEndorsementEmail);
        } else {
            $this->PreferencesDisableEndorsementEmail = $preferencesDisableEndorsementEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisableFollowersEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisableFollowersEmail()
    {
        return isset($this->PreferencesDisableFollowersEmail) ? $this->PreferencesDisableFollowersEmail : null;
    }
    /**
     * Set PreferencesDisableFollowersEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisableFollowersEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisableFollowersEmail($preferencesDisableFollowersEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisableFollowersEmail) && !is_bool($preferencesDisableFollowersEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisableFollowersEmail, true), gettype($preferencesDisableFollowersEmail)), __LINE__);
        }
        if (is_null($preferencesDisableFollowersEmail) || (is_array($preferencesDisableFollowersEmail) && empty($preferencesDisableFollowersEmail))) {
            unset($this->PreferencesDisableFollowersEmail);
        } else {
            $this->PreferencesDisableFollowersEmail = $preferencesDisableFollowersEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisableItemFlaggedEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisableItemFlaggedEmail()
    {
        return isset($this->PreferencesDisableItemFlaggedEmail) ? $this->PreferencesDisableItemFlaggedEmail : null;
    }
    /**
     * Set PreferencesDisableItemFlaggedEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisableItemFlaggedEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisableItemFlaggedEmail($preferencesDisableItemFlaggedEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisableItemFlaggedEmail) && !is_bool($preferencesDisableItemFlaggedEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisableItemFlaggedEmail, true), gettype($preferencesDisableItemFlaggedEmail)), __LINE__);
        }
        if (is_null($preferencesDisableItemFlaggedEmail) || (is_array($preferencesDisableItemFlaggedEmail) && empty($preferencesDisableItemFlaggedEmail))) {
            unset($this->PreferencesDisableItemFlaggedEmail);
        } else {
            $this->PreferencesDisableItemFlaggedEmail = $preferencesDisableItemFlaggedEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisableLaterCommentEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisableLaterCommentEmail()
    {
        return isset($this->PreferencesDisableLaterCommentEmail) ? $this->PreferencesDisableLaterCommentEmail : null;
    }
    /**
     * Set PreferencesDisableLaterCommentEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisableLaterCommentEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisableLaterCommentEmail($preferencesDisableLaterCommentEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisableLaterCommentEmail) && !is_bool($preferencesDisableLaterCommentEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisableLaterCommentEmail, true), gettype($preferencesDisableLaterCommentEmail)), __LINE__);
        }
        if (is_null($preferencesDisableLaterCommentEmail) || (is_array($preferencesDisableLaterCommentEmail) && empty($preferencesDisableLaterCommentEmail))) {
            unset($this->PreferencesDisableLaterCommentEmail);
        } else {
            $this->PreferencesDisableLaterCommentEmail = $preferencesDisableLaterCommentEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisableLikeEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisableLikeEmail()
    {
        return isset($this->PreferencesDisableLikeEmail) ? $this->PreferencesDisableLikeEmail : null;
    }
    /**
     * Set PreferencesDisableLikeEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisableLikeEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisableLikeEmail($preferencesDisableLikeEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisableLikeEmail) && !is_bool($preferencesDisableLikeEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisableLikeEmail, true), gettype($preferencesDisableLikeEmail)), __LINE__);
        }
        if (is_null($preferencesDisableLikeEmail) || (is_array($preferencesDisableLikeEmail) && empty($preferencesDisableLikeEmail))) {
            unset($this->PreferencesDisableLikeEmail);
        } else {
            $this->PreferencesDisableLikeEmail = $preferencesDisableLikeEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisableMentionsPostEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisableMentionsPostEmail()
    {
        return isset($this->PreferencesDisableMentionsPostEmail) ? $this->PreferencesDisableMentionsPostEmail : null;
    }
    /**
     * Set PreferencesDisableMentionsPostEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisableMentionsPostEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisableMentionsPostEmail($preferencesDisableMentionsPostEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisableMentionsPostEmail) && !is_bool($preferencesDisableMentionsPostEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisableMentionsPostEmail, true), gettype($preferencesDisableMentionsPostEmail)), __LINE__);
        }
        if (is_null($preferencesDisableMentionsPostEmail) || (is_array($preferencesDisableMentionsPostEmail) && empty($preferencesDisableMentionsPostEmail))) {
            unset($this->PreferencesDisableMentionsPostEmail);
        } else {
            $this->PreferencesDisableMentionsPostEmail = $preferencesDisableMentionsPostEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisableMessageEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisableMessageEmail()
    {
        return isset($this->PreferencesDisableMessageEmail) ? $this->PreferencesDisableMessageEmail : null;
    }
    /**
     * Set PreferencesDisableMessageEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisableMessageEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisableMessageEmail($preferencesDisableMessageEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisableMessageEmail) && !is_bool($preferencesDisableMessageEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisableMessageEmail, true), gettype($preferencesDisableMessageEmail)), __LINE__);
        }
        if (is_null($preferencesDisableMessageEmail) || (is_array($preferencesDisableMessageEmail) && empty($preferencesDisableMessageEmail))) {
            unset($this->PreferencesDisableMessageEmail);
        } else {
            $this->PreferencesDisableMessageEmail = $preferencesDisableMessageEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisablePendingReviewEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisablePendingReviewEmail()
    {
        return isset($this->PreferencesDisablePendingReviewEmail) ? $this->PreferencesDisablePendingReviewEmail : null;
    }
    /**
     * Set PreferencesDisablePendingReviewEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisablePendingReviewEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisablePendingReviewEmail($preferencesDisablePendingReviewEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisablePendingReviewEmail) && !is_bool($preferencesDisablePendingReviewEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisablePendingReviewEmail, true), gettype($preferencesDisablePendingReviewEmail)), __LINE__);
        }
        if (is_null($preferencesDisablePendingReviewEmail) || (is_array($preferencesDisablePendingReviewEmail) && empty($preferencesDisablePendingReviewEmail))) {
            unset($this->PreferencesDisablePendingReviewEmail);
        } else {
            $this->PreferencesDisablePendingReviewEmail = $preferencesDisablePendingReviewEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisableProfilePostEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisableProfilePostEmail()
    {
        return isset($this->PreferencesDisableProfilePostEmail) ? $this->PreferencesDisableProfilePostEmail : null;
    }
    /**
     * Set PreferencesDisableProfilePostEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisableProfilePostEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisableProfilePostEmail($preferencesDisableProfilePostEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisableProfilePostEmail) && !is_bool($preferencesDisableProfilePostEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisableProfilePostEmail, true), gettype($preferencesDisableProfilePostEmail)), __LINE__);
        }
        if (is_null($preferencesDisableProfilePostEmail) || (is_array($preferencesDisableProfilePostEmail) && empty($preferencesDisableProfilePostEmail))) {
            unset($this->PreferencesDisableProfilePostEmail);
        } else {
            $this->PreferencesDisableProfilePostEmail = $preferencesDisableProfilePostEmail;
        }
        return $this;
    }
    /**
     * Get PreferencesDisableSharePostEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesDisableSharePostEmail()
    {
        return isset($this->PreferencesDisableSharePostEmail) ? $this->PreferencesDisableSharePostEmail : null;
    }
    /**
     * Set PreferencesDisableSharePostEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesDisableSharePostEmail
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setPreferencesDisableSharePostEmail($preferencesDisableSharePostEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesDisableSharePostEmail) && !is_bool($preferencesDisableSharePostEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesDisableSharePostEmail, true), gettype($preferencesDisableSharePostEmail)), __LINE__);
        }
        if (is_null($preferencesDisableSharePostEmail) || (is_array($preferencesDisableSharePostEmail) && empty($preferencesDisableSharePostEmail))) {
            unset($this->PreferencesDisableSharePostEmail);
        } else {
            $this->PreferencesDisableSharePostEmail = $preferencesDisableSharePostEmail;
        }
        return $this;
    }
    /**
     * Get ReputationPoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getReputationPoints()
    {
        return isset($this->ReputationPoints) ? $this->ReputationPoints : null;
    }
    /**
     * Set ReputationPoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $reputationPoints
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setReputationPoints($reputationPoints = null)
    {
        // validation for constraint: float
        if (!is_null($reputationPoints) && !(is_float($reputationPoints) || is_numeric($reputationPoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reputationPoints, true), gettype($reputationPoints)), __LINE__);
        }
        if (is_null($reputationPoints) || (is_array($reputationPoints) && empty($reputationPoints))) {
            unset($this->ReputationPoints);
        } else {
            $this->ReputationPoints = $reputationPoints;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\NetworkMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
