<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LogoutEventStream StructType
 * @subpackage Structs
 */
class LogoutEventStream extends SObject
{
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The EventDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventIdentifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventIdentifier;
    /**
     * The LoginKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoginKey;
    /**
     * The RelatedEventIdentifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedEventIdentifier;
    /**
     * The ReplayId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReplayId;
    /**
     * The SessionKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SessionKey;
    /**
     * The SessionLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SessionLevel;
    /**
     * The SourceIp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceIp;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $User;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserId;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Username;
    /**
     * Constructor method for LogoutEventStream
     * @uses LogoutEventStream::setCreatedBy()
     * @uses LogoutEventStream::setCreatedById()
     * @uses LogoutEventStream::setCreatedDate()
     * @uses LogoutEventStream::setEventDate()
     * @uses LogoutEventStream::setEventIdentifier()
     * @uses LogoutEventStream::setLoginKey()
     * @uses LogoutEventStream::setRelatedEventIdentifier()
     * @uses LogoutEventStream::setReplayId()
     * @uses LogoutEventStream::setSessionKey()
     * @uses LogoutEventStream::setSessionLevel()
     * @uses LogoutEventStream::setSourceIp()
     * @uses LogoutEventStream::setUser()
     * @uses LogoutEventStream::setUserId()
     * @uses LogoutEventStream::setUsername()
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $eventDate
     * @param string $eventIdentifier
     * @param string $loginKey
     * @param string $relatedEventIdentifier
     * @param string $replayId
     * @param string $sessionKey
     * @param string $sessionLevel
     * @param string $sourceIp
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @param string $userId
     * @param string $username
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $eventDate = null, $eventIdentifier = null, $loginKey = null, $relatedEventIdentifier = null, $replayId = null, $sessionKey = null, $sessionLevel = null, $sourceIp = null, \NexusDigital/MiratelForce\StructType\User $user = null, $userId = null, $username = null)
    {
        $this
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setEventDate($eventDate)
            ->setEventIdentifier($eventIdentifier)
            ->setLoginKey($loginKey)
            ->setRelatedEventIdentifier($relatedEventIdentifier)
            ->setReplayId($replayId)
            ->setSessionKey($sessionKey)
            ->setSessionLevel($sessionLevel)
            ->setSourceIp($sourceIp)
            ->setUser($user)
            ->setUserId($userId)
            ->setUsername($username);
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\LogoutEventStream
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\LogoutEventStream
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\LogoutEventStream
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \NexusDigital/MiratelForce\StructType\LogoutEventStream
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventIdentifier()
    {
        return isset($this->EventIdentifier) ? $this->EventIdentifier : null;
    }
    /**
     * Set EventIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventIdentifier
     * @return \NexusDigital/MiratelForce\StructType\LogoutEventStream
     */
    public function setEventIdentifier($eventIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($eventIdentifier) && !is_string($eventIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventIdentifier, true), gettype($eventIdentifier)), __LINE__);
        }
        if (is_null($eventIdentifier) || (is_array($eventIdentifier) && empty($eventIdentifier))) {
            unset($this->EventIdentifier);
        } else {
            $this->EventIdentifier = $eventIdentifier;
        }
        return $this;
    }
    /**
     * Get LoginKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginKey()
    {
        return isset($this->LoginKey) ? $this->LoginKey : null;
    }
    /**
     * Set LoginKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginKey
     * @return \NexusDigital/MiratelForce\StructType\LogoutEventStream
     */
    public function setLoginKey($loginKey = null)
    {
        // validation for constraint: string
        if (!is_null($loginKey) && !is_string($loginKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginKey, true), gettype($loginKey)), __LINE__);
        }
        if (is_null($loginKey) || (is_array($loginKey) && empty($loginKey))) {
            unset($this->LoginKey);
        } else {
            $this->LoginKey = $loginKey;
        }
        return $this;
    }
    /**
     * Get RelatedEventIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedEventIdentifier()
    {
        return isset($this->RelatedEventIdentifier) ? $this->RelatedEventIdentifier : null;
    }
    /**
     * Set RelatedEventIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedEventIdentifier
     * @return \NexusDigital/MiratelForce\StructType\LogoutEventStream
     */
    public function setRelatedEventIdentifier($relatedEventIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($relatedEventIdentifier) && !is_string($relatedEventIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedEventIdentifier, true), gettype($relatedEventIdentifier)), __LINE__);
        }
        if (is_null($relatedEventIdentifier) || (is_array($relatedEventIdentifier) && empty($relatedEventIdentifier))) {
            unset($this->RelatedEventIdentifier);
        } else {
            $this->RelatedEventIdentifier = $relatedEventIdentifier;
        }
        return $this;
    }
    /**
     * Get ReplayId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReplayId()
    {
        return isset($this->ReplayId) ? $this->ReplayId : null;
    }
    /**
     * Set ReplayId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $replayId
     * @return \NexusDigital/MiratelForce\StructType\LogoutEventStream
     */
    public function setReplayId($replayId = null)
    {
        // validation for constraint: string
        if (!is_null($replayId) && !is_string($replayId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replayId, true), gettype($replayId)), __LINE__);
        }
        if (is_null($replayId) || (is_array($replayId) && empty($replayId))) {
            unset($this->ReplayId);
        } else {
            $this->ReplayId = $replayId;
        }
        return $this;
    }
    /**
     * Get SessionKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionKey()
    {
        return isset($this->SessionKey) ? $this->SessionKey : null;
    }
    /**
     * Set SessionKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionKey
     * @return \NexusDigital/MiratelForce\StructType\LogoutEventStream
     */
    public function setSessionKey($sessionKey = null)
    {
        // validation for constraint: string
        if (!is_null($sessionKey) && !is_string($sessionKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionKey, true), gettype($sessionKey)), __LINE__);
        }
        if (is_null($sessionKey) || (is_array($sessionKey) && empty($sessionKey))) {
            unset($this->SessionKey);
        } else {
            $this->SessionKey = $sessionKey;
        }
        return $this;
    }
    /**
     * Get SessionLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionLevel()
    {
        return isset($this->SessionLevel) ? $this->SessionLevel : null;
    }
    /**
     * Set SessionLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionLevel
     * @return \NexusDigital/MiratelForce\StructType\LogoutEventStream
     */
    public function setSessionLevel($sessionLevel = null)
    {
        // validation for constraint: string
        if (!is_null($sessionLevel) && !is_string($sessionLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionLevel, true), gettype($sessionLevel)), __LINE__);
        }
        if (is_null($sessionLevel) || (is_array($sessionLevel) && empty($sessionLevel))) {
            unset($this->SessionLevel);
        } else {
            $this->SessionLevel = $sessionLevel;
        }
        return $this;
    }
    /**
     * Get SourceIp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceIp()
    {
        return isset($this->SourceIp) ? $this->SourceIp : null;
    }
    /**
     * Set SourceIp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceIp
     * @return \NexusDigital/MiratelForce\StructType\LogoutEventStream
     */
    public function setSourceIp($sourceIp = null)
    {
        // validation for constraint: string
        if (!is_null($sourceIp) && !is_string($sourceIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceIp, true), gettype($sourceIp)), __LINE__);
        }
        if (is_null($sourceIp) || (is_array($sourceIp) && empty($sourceIp))) {
            unset($this->SourceIp);
        } else {
            $this->SourceIp = $sourceIp;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @return \NexusDigital/MiratelForce\StructType\LogoutEventStream
     */
    public function setUser(\NexusDigital/MiratelForce\StructType\User $user = null)
    {
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \NexusDigital/MiratelForce\StructType\LogoutEventStream
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userId) && mb_strlen($userId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userId) && !preg_match('/[a-zA-Z0-9]{18}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get Username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->Username) ? $this->Username : null;
    }
    /**
     * Set Username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \NexusDigital/MiratelForce\StructType\LogoutEventStream
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->Username);
        } else {
            $this->Username = $username;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\LogoutEventStream
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
