<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginHistory StructType
 * @subpackage Structs
 */
class LoginHistory extends SObject
{
    /**
     * The ApiType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApiType;
    /**
     * The ApiVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApiVersion;
    /**
     * The Application
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Application;
    /**
     * The AuthenticationServiceId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AuthenticationServiceId;
    /**
     * The Browser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Browser;
    /**
     * The CipherSuite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CipherSuite;
    /**
     * The ClientVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientVersion;
    /**
     * The CountryIso
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryIso;
    /**
     * The LoginGeo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\LoginGeo
     */
    public $LoginGeo;
    /**
     * The LoginGeoId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LoginGeoId;
    /**
     * The LoginTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoginTime;
    /**
     * The LoginType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoginType;
    /**
     * The LoginUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoginUrl;
    /**
     * The NetworkId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $NetworkId;
    /**
     * The OptionsIsGet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsIsGet;
    /**
     * The OptionsIsPost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsIsPost;
    /**
     * The Platform
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Platform;
    /**
     * The SourceIp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceIp;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TlsProtocol
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TlsProtocol;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for LoginHistory
     * @uses LoginHistory::setApiType()
     * @uses LoginHistory::setApiVersion()
     * @uses LoginHistory::setApplication()
     * @uses LoginHistory::setAuthenticationServiceId()
     * @uses LoginHistory::setBrowser()
     * @uses LoginHistory::setCipherSuite()
     * @uses LoginHistory::setClientVersion()
     * @uses LoginHistory::setCountryIso()
     * @uses LoginHistory::setLoginGeo()
     * @uses LoginHistory::setLoginGeoId()
     * @uses LoginHistory::setLoginTime()
     * @uses LoginHistory::setLoginType()
     * @uses LoginHistory::setLoginUrl()
     * @uses LoginHistory::setNetworkId()
     * @uses LoginHistory::setOptionsIsGet()
     * @uses LoginHistory::setOptionsIsPost()
     * @uses LoginHistory::setPlatform()
     * @uses LoginHistory::setSourceIp()
     * @uses LoginHistory::setStatus()
     * @uses LoginHistory::setTlsProtocol()
     * @uses LoginHistory::setUserId()
     * @param string $apiType
     * @param string $apiVersion
     * @param string $application
     * @param string $authenticationServiceId
     * @param string $browser
     * @param string $cipherSuite
     * @param string $clientVersion
     * @param string $countryIso
     * @param \NexusDigital/MiratelForce\StructType\LoginGeo $loginGeo
     * @param string $loginGeoId
     * @param string $loginTime
     * @param string $loginType
     * @param string $loginUrl
     * @param string $networkId
     * @param bool $optionsIsGet
     * @param bool $optionsIsPost
     * @param string $platform
     * @param string $sourceIp
     * @param string $status
     * @param string $tlsProtocol
     * @param string $userId
     */
    public function __construct($apiType = null, $apiVersion = null, $application = null, $authenticationServiceId = null, $browser = null, $cipherSuite = null, $clientVersion = null, $countryIso = null, \NexusDigital/MiratelForce\StructType\LoginGeo $loginGeo = null, $loginGeoId = null, $loginTime = null, $loginType = null, $loginUrl = null, $networkId = null, $optionsIsGet = null, $optionsIsPost = null, $platform = null, $sourceIp = null, $status = null, $tlsProtocol = null, $userId = null)
    {
        $this
            ->setApiType($apiType)
            ->setApiVersion($apiVersion)
            ->setApplication($application)
            ->setAuthenticationServiceId($authenticationServiceId)
            ->setBrowser($browser)
            ->setCipherSuite($cipherSuite)
            ->setClientVersion($clientVersion)
            ->setCountryIso($countryIso)
            ->setLoginGeo($loginGeo)
            ->setLoginGeoId($loginGeoId)
            ->setLoginTime($loginTime)
            ->setLoginType($loginType)
            ->setLoginUrl($loginUrl)
            ->setNetworkId($networkId)
            ->setOptionsIsGet($optionsIsGet)
            ->setOptionsIsPost($optionsIsPost)
            ->setPlatform($platform)
            ->setSourceIp($sourceIp)
            ->setStatus($status)
            ->setTlsProtocol($tlsProtocol)
            ->setUserId($userId);
    }
    /**
     * Get ApiType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApiType()
    {
        return isset($this->ApiType) ? $this->ApiType : null;
    }
    /**
     * Set ApiType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apiType
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setApiType($apiType = null)
    {
        // validation for constraint: string
        if (!is_null($apiType) && !is_string($apiType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiType, true), gettype($apiType)), __LINE__);
        }
        if (is_null($apiType) || (is_array($apiType) && empty($apiType))) {
            unset($this->ApiType);
        } else {
            $this->ApiType = $apiType;
        }
        return $this;
    }
    /**
     * Get ApiVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApiVersion()
    {
        return isset($this->ApiVersion) ? $this->ApiVersion : null;
    }
    /**
     * Set ApiVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apiVersion
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setApiVersion($apiVersion = null)
    {
        // validation for constraint: string
        if (!is_null($apiVersion) && !is_string($apiVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiVersion, true), gettype($apiVersion)), __LINE__);
        }
        if (is_null($apiVersion) || (is_array($apiVersion) && empty($apiVersion))) {
            unset($this->ApiVersion);
        } else {
            $this->ApiVersion = $apiVersion;
        }
        return $this;
    }
    /**
     * Get Application value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplication()
    {
        return isset($this->Application) ? $this->Application : null;
    }
    /**
     * Set Application value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $application
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setApplication($application = null)
    {
        // validation for constraint: string
        if (!is_null($application) && !is_string($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($application, true), gettype($application)), __LINE__);
        }
        if (is_null($application) || (is_array($application) && empty($application))) {
            unset($this->Application);
        } else {
            $this->Application = $application;
        }
        return $this;
    }
    /**
     * Get AuthenticationServiceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthenticationServiceId()
    {
        return isset($this->AuthenticationServiceId) ? $this->AuthenticationServiceId : null;
    }
    /**
     * Set AuthenticationServiceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authenticationServiceId
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setAuthenticationServiceId($authenticationServiceId = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationServiceId) && !is_string($authenticationServiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationServiceId, true), gettype($authenticationServiceId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($authenticationServiceId) && mb_strlen($authenticationServiceId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($authenticationServiceId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($authenticationServiceId) && !preg_match('/[a-zA-Z0-9]{18}/', $authenticationServiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($authenticationServiceId, true)), __LINE__);
        }
        if (is_null($authenticationServiceId) || (is_array($authenticationServiceId) && empty($authenticationServiceId))) {
            unset($this->AuthenticationServiceId);
        } else {
            $this->AuthenticationServiceId = $authenticationServiceId;
        }
        return $this;
    }
    /**
     * Get Browser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrowser()
    {
        return isset($this->Browser) ? $this->Browser : null;
    }
    /**
     * Set Browser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $browser
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setBrowser($browser = null)
    {
        // validation for constraint: string
        if (!is_null($browser) && !is_string($browser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($browser, true), gettype($browser)), __LINE__);
        }
        if (is_null($browser) || (is_array($browser) && empty($browser))) {
            unset($this->Browser);
        } else {
            $this->Browser = $browser;
        }
        return $this;
    }
    /**
     * Get CipherSuite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCipherSuite()
    {
        return isset($this->CipherSuite) ? $this->CipherSuite : null;
    }
    /**
     * Set CipherSuite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cipherSuite
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setCipherSuite($cipherSuite = null)
    {
        // validation for constraint: string
        if (!is_null($cipherSuite) && !is_string($cipherSuite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cipherSuite, true), gettype($cipherSuite)), __LINE__);
        }
        if (is_null($cipherSuite) || (is_array($cipherSuite) && empty($cipherSuite))) {
            unset($this->CipherSuite);
        } else {
            $this->CipherSuite = $cipherSuite;
        }
        return $this;
    }
    /**
     * Get ClientVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientVersion()
    {
        return isset($this->ClientVersion) ? $this->ClientVersion : null;
    }
    /**
     * Set ClientVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientVersion
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setClientVersion($clientVersion = null)
    {
        // validation for constraint: string
        if (!is_null($clientVersion) && !is_string($clientVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientVersion, true), gettype($clientVersion)), __LINE__);
        }
        if (is_null($clientVersion) || (is_array($clientVersion) && empty($clientVersion))) {
            unset($this->ClientVersion);
        } else {
            $this->ClientVersion = $clientVersion;
        }
        return $this;
    }
    /**
     * Get CountryIso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryIso()
    {
        return isset($this->CountryIso) ? $this->CountryIso : null;
    }
    /**
     * Set CountryIso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryIso
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setCountryIso($countryIso = null)
    {
        // validation for constraint: string
        if (!is_null($countryIso) && !is_string($countryIso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryIso, true), gettype($countryIso)), __LINE__);
        }
        if (is_null($countryIso) || (is_array($countryIso) && empty($countryIso))) {
            unset($this->CountryIso);
        } else {
            $this->CountryIso = $countryIso;
        }
        return $this;
    }
    /**
     * Get LoginGeo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\LoginGeo|null
     */
    public function getLoginGeo()
    {
        return isset($this->LoginGeo) ? $this->LoginGeo : null;
    }
    /**
     * Set LoginGeo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\LoginGeo $loginGeo
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setLoginGeo(\NexusDigital/MiratelForce\StructType\LoginGeo $loginGeo = null)
    {
        if (is_null($loginGeo) || (is_array($loginGeo) && empty($loginGeo))) {
            unset($this->LoginGeo);
        } else {
            $this->LoginGeo = $loginGeo;
        }
        return $this;
    }
    /**
     * Get LoginGeoId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginGeoId()
    {
        return isset($this->LoginGeoId) ? $this->LoginGeoId : null;
    }
    /**
     * Set LoginGeoId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginGeoId
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setLoginGeoId($loginGeoId = null)
    {
        // validation for constraint: string
        if (!is_null($loginGeoId) && !is_string($loginGeoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginGeoId, true), gettype($loginGeoId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($loginGeoId) && mb_strlen($loginGeoId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($loginGeoId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($loginGeoId) && !preg_match('/[a-zA-Z0-9]{18}/', $loginGeoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($loginGeoId, true)), __LINE__);
        }
        if (is_null($loginGeoId) || (is_array($loginGeoId) && empty($loginGeoId))) {
            unset($this->LoginGeoId);
        } else {
            $this->LoginGeoId = $loginGeoId;
        }
        return $this;
    }
    /**
     * Get LoginTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginTime()
    {
        return isset($this->LoginTime) ? $this->LoginTime : null;
    }
    /**
     * Set LoginTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginTime
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setLoginTime($loginTime = null)
    {
        // validation for constraint: string
        if (!is_null($loginTime) && !is_string($loginTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginTime, true), gettype($loginTime)), __LINE__);
        }
        if (is_null($loginTime) || (is_array($loginTime) && empty($loginTime))) {
            unset($this->LoginTime);
        } else {
            $this->LoginTime = $loginTime;
        }
        return $this;
    }
    /**
     * Get LoginType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginType()
    {
        return isset($this->LoginType) ? $this->LoginType : null;
    }
    /**
     * Set LoginType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginType
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setLoginType($loginType = null)
    {
        // validation for constraint: string
        if (!is_null($loginType) && !is_string($loginType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginType, true), gettype($loginType)), __LINE__);
        }
        if (is_null($loginType) || (is_array($loginType) && empty($loginType))) {
            unset($this->LoginType);
        } else {
            $this->LoginType = $loginType;
        }
        return $this;
    }
    /**
     * Get LoginUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginUrl()
    {
        return isset($this->LoginUrl) ? $this->LoginUrl : null;
    }
    /**
     * Set LoginUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginUrl
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setLoginUrl($loginUrl = null)
    {
        // validation for constraint: string
        if (!is_null($loginUrl) && !is_string($loginUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginUrl, true), gettype($loginUrl)), __LINE__);
        }
        if (is_null($loginUrl) || (is_array($loginUrl) && empty($loginUrl))) {
            unset($this->LoginUrl);
        } else {
            $this->LoginUrl = $loginUrl;
        }
        return $this;
    }
    /**
     * Get NetworkId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkId()
    {
        return isset($this->NetworkId) ? $this->NetworkId : null;
    }
    /**
     * Set NetworkId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkId
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setNetworkId($networkId = null)
    {
        // validation for constraint: string
        if (!is_null($networkId) && !is_string($networkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($networkId, true), gettype($networkId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($networkId) && mb_strlen($networkId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($networkId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($networkId) && !preg_match('/[a-zA-Z0-9]{18}/', $networkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($networkId, true)), __LINE__);
        }
        if (is_null($networkId) || (is_array($networkId) && empty($networkId))) {
            unset($this->NetworkId);
        } else {
            $this->NetworkId = $networkId;
        }
        return $this;
    }
    /**
     * Get OptionsIsGet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsIsGet()
    {
        return isset($this->OptionsIsGet) ? $this->OptionsIsGet : null;
    }
    /**
     * Set OptionsIsGet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsIsGet
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setOptionsIsGet($optionsIsGet = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsIsGet) && !is_bool($optionsIsGet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsIsGet, true), gettype($optionsIsGet)), __LINE__);
        }
        if (is_null($optionsIsGet) || (is_array($optionsIsGet) && empty($optionsIsGet))) {
            unset($this->OptionsIsGet);
        } else {
            $this->OptionsIsGet = $optionsIsGet;
        }
        return $this;
    }
    /**
     * Get OptionsIsPost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsIsPost()
    {
        return isset($this->OptionsIsPost) ? $this->OptionsIsPost : null;
    }
    /**
     * Set OptionsIsPost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsIsPost
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setOptionsIsPost($optionsIsPost = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsIsPost) && !is_bool($optionsIsPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsIsPost, true), gettype($optionsIsPost)), __LINE__);
        }
        if (is_null($optionsIsPost) || (is_array($optionsIsPost) && empty($optionsIsPost))) {
            unset($this->OptionsIsPost);
        } else {
            $this->OptionsIsPost = $optionsIsPost;
        }
        return $this;
    }
    /**
     * Get Platform value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlatform()
    {
        return isset($this->Platform) ? $this->Platform : null;
    }
    /**
     * Set Platform value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $platform
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setPlatform($platform = null)
    {
        // validation for constraint: string
        if (!is_null($platform) && !is_string($platform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($platform, true), gettype($platform)), __LINE__);
        }
        if (is_null($platform) || (is_array($platform) && empty($platform))) {
            unset($this->Platform);
        } else {
            $this->Platform = $platform;
        }
        return $this;
    }
    /**
     * Get SourceIp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceIp()
    {
        return isset($this->SourceIp) ? $this->SourceIp : null;
    }
    /**
     * Set SourceIp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceIp
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setSourceIp($sourceIp = null)
    {
        // validation for constraint: string
        if (!is_null($sourceIp) && !is_string($sourceIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceIp, true), gettype($sourceIp)), __LINE__);
        }
        if (is_null($sourceIp) || (is_array($sourceIp) && empty($sourceIp))) {
            unset($this->SourceIp);
        } else {
            $this->SourceIp = $sourceIp;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TlsProtocol value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTlsProtocol()
    {
        return isset($this->TlsProtocol) ? $this->TlsProtocol : null;
    }
    /**
     * Set TlsProtocol value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tlsProtocol
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setTlsProtocol($tlsProtocol = null)
    {
        // validation for constraint: string
        if (!is_null($tlsProtocol) && !is_string($tlsProtocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tlsProtocol, true), gettype($tlsProtocol)), __LINE__);
        }
        if (is_null($tlsProtocol) || (is_array($tlsProtocol) && empty($tlsProtocol))) {
            unset($this->TlsProtocol);
        } else {
            $this->TlsProtocol = $tlsProtocol;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userId) && mb_strlen($userId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userId) && !preg_match('/[a-zA-Z0-9]{18}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
