<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Knowledge__kav StructType
 * @subpackage Structs
 */
class Knowledge__kav extends SObject
{
    /**
     * The Agent_Instructions__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Agent_Instructions__c;
    /**
     * The Answer__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Answer__c;
    /**
     * The ArchivedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $ArchivedBy;
    /**
     * The ArchivedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ArchivedById;
    /**
     * The ArchivedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArchivedDate;
    /**
     * The ArticleArchivedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $ArticleArchivedBy;
    /**
     * The ArticleArchivedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ArticleArchivedById;
    /**
     * The ArticleArchivedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArticleArchivedDate;
    /**
     * The ArticleCaseAttachCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ArticleCaseAttachCount;
    /**
     * The ArticleCreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $ArticleCreatedBy;
    /**
     * The ArticleCreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ArticleCreatedById;
    /**
     * The ArticleCreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArticleCreatedDate;
    /**
     * The ArticleMasterLanguage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArticleMasterLanguage;
    /**
     * The ArticleNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArticleNumber;
    /**
     * The ArticleTotalViewCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ArticleTotalViewCount;
    /**
     * The AssignedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $AssignedBy;
    /**
     * The AssignedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AssignedById;
    /**
     * The AssignedTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $AssignedTo;
    /**
     * The AssignedToId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AssignedToId;
    /**
     * The AssignmentDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssignmentDate;
    /**
     * The AssignmentDueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssignmentDueDate;
    /**
     * The AssignmentNote
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssignmentNote;
    /**
     * The AttachedContentDocuments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentDocuments;
    /**
     * The AttachedContentNotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentNotes;
    /**
     * The Campaign__c
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $Campaign__c;
    /**
     * The Campaign__r
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Campaign__c
     */
    public $Campaign__r;
    /**
     * The CaseArticles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CaseArticles;
    /**
     * The Client_FAQ__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Client_FAQ__c;
    /**
     * The CombinedAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CombinedAttachments;
    /**
     * The ContentDocumentLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContentDocumentLinks;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DataCategorySelections
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $DataCategorySelections;
    /**
     * The Draw_Dates_and_Deadlines__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Draw_Dates_and_Deadlines__c;
    /**
     * The Draw_Details__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Draw_Details__c;
    /**
     * The Draws_FAQ__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Draws_FAQ__c;
    /**
     * The FirstPublishedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstPublishedDate;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsLatestVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsLatestVersion;
    /**
     * The IsVisibleInApp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVisibleInApp;
    /**
     * The IsVisibleInCsp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVisibleInCsp;
    /**
     * The IsVisibleInPkb
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVisibleInPkb;
    /**
     * The IsVisibleInPrm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVisibleInPrm;
    /**
     * The KnowledgeArticleId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $KnowledgeArticleId;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastPublishedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastPublishedDate;
    /**
     * The LinkedArticles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $LinkedArticles;
    /**
     * The Membership_FAQ__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Membership_FAQ__c;
    /**
     * The MigratedToFromArticleVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MigratedToFromArticleVersion;
    /**
     * The NetworkUserHistoryRecentToRecord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NetworkUserHistoryRecentToRecord;
    /**
     * The Online_Issues_FAQ__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Online_Issues_FAQ__c;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $Owner;
    /**
     * The OwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OwnerId;
    /**
     * The Payment_FAQ__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Payment_FAQ__c;
    /**
     * The Prizes_FAQ__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Prizes_FAQ__c;
    /**
     * The Prizes_List__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Prizes_List__c;
    /**
     * The Procedure_Audience__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Procedure_Audience__c;
    /**
     * The Procedure_Purpose__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Procedure_Purpose__c;
    /**
     * The Procedure_Steps__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Procedure_Steps__c;
    /**
     * The Procedure_Warnings__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Procedure_Warnings__c;
    /**
     * The ProcessInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessInstances;
    /**
     * The ProcessSteps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessSteps;
    /**
     * The PublishStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PublishStatus;
    /**
     * The Question__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Question__c;
    /**
     * The RecordType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\RecordType
     */
    public $RecordType;
    /**
     * The RecordTypeId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $RecordTypeId;
    /**
     * The SearchPromotionRules
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $SearchPromotionRules;
    /**
     * The Showhome_FAQ__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Showhome_FAQ__c;
    /**
     * The SourceId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $SourceId;
    /**
     * The Summary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Summary;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The Tickets_FAQ__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tickets_FAQ__c;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The TopicAssignments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $TopicAssignments;
    /**
     * The UrlName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UrlName;
    /**
     * The ValidationStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidationStatus;
    /**
     * The VersionNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $VersionNumber;
    /**
     * The Winners_FAQ__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Winners_FAQ__c;
    /**
     * Constructor method for Knowledge__kav
     * @uses Knowledge__kav::setAgent_Instructions__c()
     * @uses Knowledge__kav::setAnswer__c()
     * @uses Knowledge__kav::setArchivedBy()
     * @uses Knowledge__kav::setArchivedById()
     * @uses Knowledge__kav::setArchivedDate()
     * @uses Knowledge__kav::setArticleArchivedBy()
     * @uses Knowledge__kav::setArticleArchivedById()
     * @uses Knowledge__kav::setArticleArchivedDate()
     * @uses Knowledge__kav::setArticleCaseAttachCount()
     * @uses Knowledge__kav::setArticleCreatedBy()
     * @uses Knowledge__kav::setArticleCreatedById()
     * @uses Knowledge__kav::setArticleCreatedDate()
     * @uses Knowledge__kav::setArticleMasterLanguage()
     * @uses Knowledge__kav::setArticleNumber()
     * @uses Knowledge__kav::setArticleTotalViewCount()
     * @uses Knowledge__kav::setAssignedBy()
     * @uses Knowledge__kav::setAssignedById()
     * @uses Knowledge__kav::setAssignedTo()
     * @uses Knowledge__kav::setAssignedToId()
     * @uses Knowledge__kav::setAssignmentDate()
     * @uses Knowledge__kav::setAssignmentDueDate()
     * @uses Knowledge__kav::setAssignmentNote()
     * @uses Knowledge__kav::setAttachedContentDocuments()
     * @uses Knowledge__kav::setAttachedContentNotes()
     * @uses Knowledge__kav::setCampaign__c()
     * @uses Knowledge__kav::setCampaign__r()
     * @uses Knowledge__kav::setCaseArticles()
     * @uses Knowledge__kav::setClient_FAQ__c()
     * @uses Knowledge__kav::setCombinedAttachments()
     * @uses Knowledge__kav::setContentDocumentLinks()
     * @uses Knowledge__kav::setCreatedBy()
     * @uses Knowledge__kav::setCreatedById()
     * @uses Knowledge__kav::setCreatedDate()
     * @uses Knowledge__kav::setDataCategorySelections()
     * @uses Knowledge__kav::setDraw_Dates_and_Deadlines__c()
     * @uses Knowledge__kav::setDraw_Details__c()
     * @uses Knowledge__kav::setDraws_FAQ__c()
     * @uses Knowledge__kav::setFirstPublishedDate()
     * @uses Knowledge__kav::setIsDeleted()
     * @uses Knowledge__kav::setIsLatestVersion()
     * @uses Knowledge__kav::setIsVisibleInApp()
     * @uses Knowledge__kav::setIsVisibleInCsp()
     * @uses Knowledge__kav::setIsVisibleInPkb()
     * @uses Knowledge__kav::setIsVisibleInPrm()
     * @uses Knowledge__kav::setKnowledgeArticleId()
     * @uses Knowledge__kav::setLanguage()
     * @uses Knowledge__kav::setLastModifiedBy()
     * @uses Knowledge__kav::setLastModifiedById()
     * @uses Knowledge__kav::setLastModifiedDate()
     * @uses Knowledge__kav::setLastPublishedDate()
     * @uses Knowledge__kav::setLinkedArticles()
     * @uses Knowledge__kav::setMembership_FAQ__c()
     * @uses Knowledge__kav::setMigratedToFromArticleVersion()
     * @uses Knowledge__kav::setNetworkUserHistoryRecentToRecord()
     * @uses Knowledge__kav::setOnline_Issues_FAQ__c()
     * @uses Knowledge__kav::setOwner()
     * @uses Knowledge__kav::setOwnerId()
     * @uses Knowledge__kav::setPayment_FAQ__c()
     * @uses Knowledge__kav::setPrizes_FAQ__c()
     * @uses Knowledge__kav::setPrizes_List__c()
     * @uses Knowledge__kav::setProcedure_Audience__c()
     * @uses Knowledge__kav::setProcedure_Purpose__c()
     * @uses Knowledge__kav::setProcedure_Steps__c()
     * @uses Knowledge__kav::setProcedure_Warnings__c()
     * @uses Knowledge__kav::setProcessInstances()
     * @uses Knowledge__kav::setProcessSteps()
     * @uses Knowledge__kav::setPublishStatus()
     * @uses Knowledge__kav::setQuestion__c()
     * @uses Knowledge__kav::setRecordType()
     * @uses Knowledge__kav::setRecordTypeId()
     * @uses Knowledge__kav::setSearchPromotionRules()
     * @uses Knowledge__kav::setShowhome_FAQ__c()
     * @uses Knowledge__kav::setSourceId()
     * @uses Knowledge__kav::setSummary()
     * @uses Knowledge__kav::setSystemModstamp()
     * @uses Knowledge__kav::setTickets_FAQ__c()
     * @uses Knowledge__kav::setTitle()
     * @uses Knowledge__kav::setTopicAssignments()
     * @uses Knowledge__kav::setUrlName()
     * @uses Knowledge__kav::setValidationStatus()
     * @uses Knowledge__kav::setVersionNumber()
     * @uses Knowledge__kav::setWinners_FAQ__c()
     * @param string $agent_Instructions__c
     * @param string $answer__c
     * @param \NexusDigital/MiratelForce\StructType\User $archivedBy
     * @param string $archivedById
     * @param string $archivedDate
     * @param \NexusDigital/MiratelForce\StructType\User $articleArchivedBy
     * @param string $articleArchivedById
     * @param string $articleArchivedDate
     * @param int $articleCaseAttachCount
     * @param \NexusDigital/MiratelForce\StructType\User $articleCreatedBy
     * @param string $articleCreatedById
     * @param string $articleCreatedDate
     * @param string $articleMasterLanguage
     * @param string $articleNumber
     * @param int $articleTotalViewCount
     * @param \NexusDigital/MiratelForce\StructType\User $assignedBy
     * @param string $assignedById
     * @param \NexusDigital/MiratelForce\StructType\SObject $assignedTo
     * @param string $assignedToId
     * @param string $assignmentDate
     * @param string $assignmentDueDate
     * @param string $assignmentNote
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @param string $campaign__c
     * @param \NexusDigital/MiratelForce\StructType\Campaign__c $campaign__r
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $caseArticles
     * @param string $client_FAQ__c
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $dataCategorySelections
     * @param string $draw_Dates_and_Deadlines__c
     * @param string $draw_Details__c
     * @param string $draws_FAQ__c
     * @param string $firstPublishedDate
     * @param bool $isDeleted
     * @param bool $isLatestVersion
     * @param bool $isVisibleInApp
     * @param bool $isVisibleInCsp
     * @param bool $isVisibleInPkb
     * @param bool $isVisibleInPrm
     * @param string $knowledgeArticleId
     * @param string $language
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $lastPublishedDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $linkedArticles
     * @param string $membership_FAQ__c
     * @param string $migratedToFromArticleVersion
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkUserHistoryRecentToRecord
     * @param string $online_Issues_FAQ__c
     * @param \NexusDigital/MiratelForce\StructType\SObject $owner
     * @param string $ownerId
     * @param string $payment_FAQ__c
     * @param string $prizes_FAQ__c
     * @param string $prizes_List__c
     * @param string $procedure_Audience__c
     * @param string $procedure_Purpose__c
     * @param string $procedure_Steps__c
     * @param string $procedure_Warnings__c
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @param string $publishStatus
     * @param string $question__c
     * @param \NexusDigital/MiratelForce\StructType\RecordType $recordType
     * @param string $recordTypeId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $searchPromotionRules
     * @param string $showhome_FAQ__c
     * @param string $sourceId
     * @param string $summary
     * @param string $systemModstamp
     * @param string $tickets_FAQ__c
     * @param string $title
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments
     * @param string $urlName
     * @param string $validationStatus
     * @param int $versionNumber
     * @param string $winners_FAQ__c
     */
    public function __construct($agent_Instructions__c = null, $answer__c = null, \NexusDigital/MiratelForce\StructType\User $archivedBy = null, $archivedById = null, $archivedDate = null, \NexusDigital/MiratelForce\StructType\User $articleArchivedBy = null, $articleArchivedById = null, $articleArchivedDate = null, $articleCaseAttachCount = null, \NexusDigital/MiratelForce\StructType\User $articleCreatedBy = null, $articleCreatedById = null, $articleCreatedDate = null, $articleMasterLanguage = null, $articleNumber = null, $articleTotalViewCount = null, \NexusDigital/MiratelForce\StructType\User $assignedBy = null, $assignedById = null, \NexusDigital/MiratelForce\StructType\SObject $assignedTo = null, $assignedToId = null, $assignmentDate = null, $assignmentDueDate = null, $assignmentNote = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null, $campaign__c = null, \NexusDigital/MiratelForce\StructType\Campaign__c $campaign__r = null, \NexusDigital/MiratelForce\StructType\QueryResult $caseArticles = null, $client_FAQ__c = null, \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null, \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $dataCategorySelections = null, $draw_Dates_and_Deadlines__c = null, $draw_Details__c = null, $draws_FAQ__c = null, $firstPublishedDate = null, $isDeleted = null, $isLatestVersion = null, $isVisibleInApp = null, $isVisibleInCsp = null, $isVisibleInPkb = null, $isVisibleInPrm = null, $knowledgeArticleId = null, $language = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lastPublishedDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $linkedArticles = null, $membership_FAQ__c = null, $migratedToFromArticleVersion = null, \NexusDigital/MiratelForce\StructType\QueryResult $networkUserHistoryRecentToRecord = null, $online_Issues_FAQ__c = null, \NexusDigital/MiratelForce\StructType\SObject $owner = null, $ownerId = null, $payment_FAQ__c = null, $prizes_FAQ__c = null, $prizes_List__c = null, $procedure_Audience__c = null, $procedure_Purpose__c = null, $procedure_Steps__c = null, $procedure_Warnings__c = null, \NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null, \NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null, $publishStatus = null, $question__c = null, \NexusDigital/MiratelForce\StructType\RecordType $recordType = null, $recordTypeId = null, \NexusDigital/MiratelForce\StructType\QueryResult $searchPromotionRules = null, $showhome_FAQ__c = null, $sourceId = null, $summary = null, $systemModstamp = null, $tickets_FAQ__c = null, $title = null, \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments = null, $urlName = null, $validationStatus = null, $versionNumber = null, $winners_FAQ__c = null)
    {
        $this
            ->setAgent_Instructions__c($agent_Instructions__c)
            ->setAnswer__c($answer__c)
            ->setArchivedBy($archivedBy)
            ->setArchivedById($archivedById)
            ->setArchivedDate($archivedDate)
            ->setArticleArchivedBy($articleArchivedBy)
            ->setArticleArchivedById($articleArchivedById)
            ->setArticleArchivedDate($articleArchivedDate)
            ->setArticleCaseAttachCount($articleCaseAttachCount)
            ->setArticleCreatedBy($articleCreatedBy)
            ->setArticleCreatedById($articleCreatedById)
            ->setArticleCreatedDate($articleCreatedDate)
            ->setArticleMasterLanguage($articleMasterLanguage)
            ->setArticleNumber($articleNumber)
            ->setArticleTotalViewCount($articleTotalViewCount)
            ->setAssignedBy($assignedBy)
            ->setAssignedById($assignedById)
            ->setAssignedTo($assignedTo)
            ->setAssignedToId($assignedToId)
            ->setAssignmentDate($assignmentDate)
            ->setAssignmentDueDate($assignmentDueDate)
            ->setAssignmentNote($assignmentNote)
            ->setAttachedContentDocuments($attachedContentDocuments)
            ->setAttachedContentNotes($attachedContentNotes)
            ->setCampaign__c($campaign__c)
            ->setCampaign__r($campaign__r)
            ->setCaseArticles($caseArticles)
            ->setClient_FAQ__c($client_FAQ__c)
            ->setCombinedAttachments($combinedAttachments)
            ->setContentDocumentLinks($contentDocumentLinks)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDataCategorySelections($dataCategorySelections)
            ->setDraw_Dates_and_Deadlines__c($draw_Dates_and_Deadlines__c)
            ->setDraw_Details__c($draw_Details__c)
            ->setDraws_FAQ__c($draws_FAQ__c)
            ->setFirstPublishedDate($firstPublishedDate)
            ->setIsDeleted($isDeleted)
            ->setIsLatestVersion($isLatestVersion)
            ->setIsVisibleInApp($isVisibleInApp)
            ->setIsVisibleInCsp($isVisibleInCsp)
            ->setIsVisibleInPkb($isVisibleInPkb)
            ->setIsVisibleInPrm($isVisibleInPrm)
            ->setKnowledgeArticleId($knowledgeArticleId)
            ->setLanguage($language)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastPublishedDate($lastPublishedDate)
            ->setLinkedArticles($linkedArticles)
            ->setMembership_FAQ__c($membership_FAQ__c)
            ->setMigratedToFromArticleVersion($migratedToFromArticleVersion)
            ->setNetworkUserHistoryRecentToRecord($networkUserHistoryRecentToRecord)
            ->setOnline_Issues_FAQ__c($online_Issues_FAQ__c)
            ->setOwner($owner)
            ->setOwnerId($ownerId)
            ->setPayment_FAQ__c($payment_FAQ__c)
            ->setPrizes_FAQ__c($prizes_FAQ__c)
            ->setPrizes_List__c($prizes_List__c)
            ->setProcedure_Audience__c($procedure_Audience__c)
            ->setProcedure_Purpose__c($procedure_Purpose__c)
            ->setProcedure_Steps__c($procedure_Steps__c)
            ->setProcedure_Warnings__c($procedure_Warnings__c)
            ->setProcessInstances($processInstances)
            ->setProcessSteps($processSteps)
            ->setPublishStatus($publishStatus)
            ->setQuestion__c($question__c)
            ->setRecordType($recordType)
            ->setRecordTypeId($recordTypeId)
            ->setSearchPromotionRules($searchPromotionRules)
            ->setShowhome_FAQ__c($showhome_FAQ__c)
            ->setSourceId($sourceId)
            ->setSummary($summary)
            ->setSystemModstamp($systemModstamp)
            ->setTickets_FAQ__c($tickets_FAQ__c)
            ->setTitle($title)
            ->setTopicAssignments($topicAssignments)
            ->setUrlName($urlName)
            ->setValidationStatus($validationStatus)
            ->setVersionNumber($versionNumber)
            ->setWinners_FAQ__c($winners_FAQ__c);
    }
    /**
     * Get Agent_Instructions__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgent_Instructions__c()
    {
        return isset($this->Agent_Instructions__c) ? $this->Agent_Instructions__c : null;
    }
    /**
     * Set Agent_Instructions__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agent_Instructions__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setAgent_Instructions__c($agent_Instructions__c = null)
    {
        // validation for constraint: string
        if (!is_null($agent_Instructions__c) && !is_string($agent_Instructions__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agent_Instructions__c, true), gettype($agent_Instructions__c)), __LINE__);
        }
        if (is_null($agent_Instructions__c) || (is_array($agent_Instructions__c) && empty($agent_Instructions__c))) {
            unset($this->Agent_Instructions__c);
        } else {
            $this->Agent_Instructions__c = $agent_Instructions__c;
        }
        return $this;
    }
    /**
     * Get Answer__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnswer__c()
    {
        return isset($this->Answer__c) ? $this->Answer__c : null;
    }
    /**
     * Set Answer__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $answer__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setAnswer__c($answer__c = null)
    {
        // validation for constraint: string
        if (!is_null($answer__c) && !is_string($answer__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answer__c, true), gettype($answer__c)), __LINE__);
        }
        if (is_null($answer__c) || (is_array($answer__c) && empty($answer__c))) {
            unset($this->Answer__c);
        } else {
            $this->Answer__c = $answer__c;
        }
        return $this;
    }
    /**
     * Get ArchivedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getArchivedBy()
    {
        return isset($this->ArchivedBy) ? $this->ArchivedBy : null;
    }
    /**
     * Set ArchivedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $archivedBy
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setArchivedBy(\NexusDigital/MiratelForce\StructType\User $archivedBy = null)
    {
        if (is_null($archivedBy) || (is_array($archivedBy) && empty($archivedBy))) {
            unset($this->ArchivedBy);
        } else {
            $this->ArchivedBy = $archivedBy;
        }
        return $this;
    }
    /**
     * Get ArchivedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArchivedById()
    {
        return isset($this->ArchivedById) ? $this->ArchivedById : null;
    }
    /**
     * Set ArchivedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $archivedById
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setArchivedById($archivedById = null)
    {
        // validation for constraint: string
        if (!is_null($archivedById) && !is_string($archivedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($archivedById, true), gettype($archivedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($archivedById) && mb_strlen($archivedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($archivedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($archivedById) && !preg_match('/[a-zA-Z0-9]{18}/', $archivedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($archivedById, true)), __LINE__);
        }
        if (is_null($archivedById) || (is_array($archivedById) && empty($archivedById))) {
            unset($this->ArchivedById);
        } else {
            $this->ArchivedById = $archivedById;
        }
        return $this;
    }
    /**
     * Get ArchivedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArchivedDate()
    {
        return isset($this->ArchivedDate) ? $this->ArchivedDate : null;
    }
    /**
     * Set ArchivedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $archivedDate
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setArchivedDate($archivedDate = null)
    {
        // validation for constraint: string
        if (!is_null($archivedDate) && !is_string($archivedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($archivedDate, true), gettype($archivedDate)), __LINE__);
        }
        if (is_null($archivedDate) || (is_array($archivedDate) && empty($archivedDate))) {
            unset($this->ArchivedDate);
        } else {
            $this->ArchivedDate = $archivedDate;
        }
        return $this;
    }
    /**
     * Get ArticleArchivedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getArticleArchivedBy()
    {
        return isset($this->ArticleArchivedBy) ? $this->ArticleArchivedBy : null;
    }
    /**
     * Set ArticleArchivedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $articleArchivedBy
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setArticleArchivedBy(\NexusDigital/MiratelForce\StructType\User $articleArchivedBy = null)
    {
        if (is_null($articleArchivedBy) || (is_array($articleArchivedBy) && empty($articleArchivedBy))) {
            unset($this->ArticleArchivedBy);
        } else {
            $this->ArticleArchivedBy = $articleArchivedBy;
        }
        return $this;
    }
    /**
     * Get ArticleArchivedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArticleArchivedById()
    {
        return isset($this->ArticleArchivedById) ? $this->ArticleArchivedById : null;
    }
    /**
     * Set ArticleArchivedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $articleArchivedById
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setArticleArchivedById($articleArchivedById = null)
    {
        // validation for constraint: string
        if (!is_null($articleArchivedById) && !is_string($articleArchivedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleArchivedById, true), gettype($articleArchivedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($articleArchivedById) && mb_strlen($articleArchivedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($articleArchivedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($articleArchivedById) && !preg_match('/[a-zA-Z0-9]{18}/', $articleArchivedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($articleArchivedById, true)), __LINE__);
        }
        if (is_null($articleArchivedById) || (is_array($articleArchivedById) && empty($articleArchivedById))) {
            unset($this->ArticleArchivedById);
        } else {
            $this->ArticleArchivedById = $articleArchivedById;
        }
        return $this;
    }
    /**
     * Get ArticleArchivedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArticleArchivedDate()
    {
        return isset($this->ArticleArchivedDate) ? $this->ArticleArchivedDate : null;
    }
    /**
     * Set ArticleArchivedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $articleArchivedDate
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setArticleArchivedDate($articleArchivedDate = null)
    {
        // validation for constraint: string
        if (!is_null($articleArchivedDate) && !is_string($articleArchivedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleArchivedDate, true), gettype($articleArchivedDate)), __LINE__);
        }
        if (is_null($articleArchivedDate) || (is_array($articleArchivedDate) && empty($articleArchivedDate))) {
            unset($this->ArticleArchivedDate);
        } else {
            $this->ArticleArchivedDate = $articleArchivedDate;
        }
        return $this;
    }
    /**
     * Get ArticleCaseAttachCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getArticleCaseAttachCount()
    {
        return isset($this->ArticleCaseAttachCount) ? $this->ArticleCaseAttachCount : null;
    }
    /**
     * Set ArticleCaseAttachCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $articleCaseAttachCount
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setArticleCaseAttachCount($articleCaseAttachCount = null)
    {
        // validation for constraint: int
        if (!is_null($articleCaseAttachCount) && !(is_int($articleCaseAttachCount) || ctype_digit($articleCaseAttachCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleCaseAttachCount, true), gettype($articleCaseAttachCount)), __LINE__);
        }
        if (is_null($articleCaseAttachCount) || (is_array($articleCaseAttachCount) && empty($articleCaseAttachCount))) {
            unset($this->ArticleCaseAttachCount);
        } else {
            $this->ArticleCaseAttachCount = $articleCaseAttachCount;
        }
        return $this;
    }
    /**
     * Get ArticleCreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getArticleCreatedBy()
    {
        return isset($this->ArticleCreatedBy) ? $this->ArticleCreatedBy : null;
    }
    /**
     * Set ArticleCreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $articleCreatedBy
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setArticleCreatedBy(\NexusDigital/MiratelForce\StructType\User $articleCreatedBy = null)
    {
        if (is_null($articleCreatedBy) || (is_array($articleCreatedBy) && empty($articleCreatedBy))) {
            unset($this->ArticleCreatedBy);
        } else {
            $this->ArticleCreatedBy = $articleCreatedBy;
        }
        return $this;
    }
    /**
     * Get ArticleCreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArticleCreatedById()
    {
        return isset($this->ArticleCreatedById) ? $this->ArticleCreatedById : null;
    }
    /**
     * Set ArticleCreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $articleCreatedById
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setArticleCreatedById($articleCreatedById = null)
    {
        // validation for constraint: string
        if (!is_null($articleCreatedById) && !is_string($articleCreatedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleCreatedById, true), gettype($articleCreatedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($articleCreatedById) && mb_strlen($articleCreatedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($articleCreatedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($articleCreatedById) && !preg_match('/[a-zA-Z0-9]{18}/', $articleCreatedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($articleCreatedById, true)), __LINE__);
        }
        if (is_null($articleCreatedById) || (is_array($articleCreatedById) && empty($articleCreatedById))) {
            unset($this->ArticleCreatedById);
        } else {
            $this->ArticleCreatedById = $articleCreatedById;
        }
        return $this;
    }
    /**
     * Get ArticleCreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArticleCreatedDate()
    {
        return isset($this->ArticleCreatedDate) ? $this->ArticleCreatedDate : null;
    }
    /**
     * Set ArticleCreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $articleCreatedDate
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setArticleCreatedDate($articleCreatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($articleCreatedDate) && !is_string($articleCreatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleCreatedDate, true), gettype($articleCreatedDate)), __LINE__);
        }
        if (is_null($articleCreatedDate) || (is_array($articleCreatedDate) && empty($articleCreatedDate))) {
            unset($this->ArticleCreatedDate);
        } else {
            $this->ArticleCreatedDate = $articleCreatedDate;
        }
        return $this;
    }
    /**
     * Get ArticleMasterLanguage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArticleMasterLanguage()
    {
        return isset($this->ArticleMasterLanguage) ? $this->ArticleMasterLanguage : null;
    }
    /**
     * Set ArticleMasterLanguage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $articleMasterLanguage
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setArticleMasterLanguage($articleMasterLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($articleMasterLanguage) && !is_string($articleMasterLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleMasterLanguage, true), gettype($articleMasterLanguage)), __LINE__);
        }
        if (is_null($articleMasterLanguage) || (is_array($articleMasterLanguage) && empty($articleMasterLanguage))) {
            unset($this->ArticleMasterLanguage);
        } else {
            $this->ArticleMasterLanguage = $articleMasterLanguage;
        }
        return $this;
    }
    /**
     * Get ArticleNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArticleNumber()
    {
        return isset($this->ArticleNumber) ? $this->ArticleNumber : null;
    }
    /**
     * Set ArticleNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $articleNumber
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setArticleNumber($articleNumber = null)
    {
        // validation for constraint: string
        if (!is_null($articleNumber) && !is_string($articleNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleNumber, true), gettype($articleNumber)), __LINE__);
        }
        if (is_null($articleNumber) || (is_array($articleNumber) && empty($articleNumber))) {
            unset($this->ArticleNumber);
        } else {
            $this->ArticleNumber = $articleNumber;
        }
        return $this;
    }
    /**
     * Get ArticleTotalViewCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getArticleTotalViewCount()
    {
        return isset($this->ArticleTotalViewCount) ? $this->ArticleTotalViewCount : null;
    }
    /**
     * Set ArticleTotalViewCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $articleTotalViewCount
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setArticleTotalViewCount($articleTotalViewCount = null)
    {
        // validation for constraint: int
        if (!is_null($articleTotalViewCount) && !(is_int($articleTotalViewCount) || ctype_digit($articleTotalViewCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleTotalViewCount, true), gettype($articleTotalViewCount)), __LINE__);
        }
        if (is_null($articleTotalViewCount) || (is_array($articleTotalViewCount) && empty($articleTotalViewCount))) {
            unset($this->ArticleTotalViewCount);
        } else {
            $this->ArticleTotalViewCount = $articleTotalViewCount;
        }
        return $this;
    }
    /**
     * Get AssignedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getAssignedBy()
    {
        return isset($this->AssignedBy) ? $this->AssignedBy : null;
    }
    /**
     * Set AssignedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $assignedBy
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setAssignedBy(\NexusDigital/MiratelForce\StructType\User $assignedBy = null)
    {
        if (is_null($assignedBy) || (is_array($assignedBy) && empty($assignedBy))) {
            unset($this->AssignedBy);
        } else {
            $this->AssignedBy = $assignedBy;
        }
        return $this;
    }
    /**
     * Get AssignedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignedById()
    {
        return isset($this->AssignedById) ? $this->AssignedById : null;
    }
    /**
     * Set AssignedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignedById
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setAssignedById($assignedById = null)
    {
        // validation for constraint: string
        if (!is_null($assignedById) && !is_string($assignedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignedById, true), gettype($assignedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($assignedById) && mb_strlen($assignedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($assignedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($assignedById) && !preg_match('/[a-zA-Z0-9]{18}/', $assignedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($assignedById, true)), __LINE__);
        }
        if (is_null($assignedById) || (is_array($assignedById) && empty($assignedById))) {
            unset($this->AssignedById);
        } else {
            $this->AssignedById = $assignedById;
        }
        return $this;
    }
    /**
     * Get AssignedTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getAssignedTo()
    {
        return isset($this->AssignedTo) ? $this->AssignedTo : null;
    }
    /**
     * Set AssignedTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $assignedTo
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setAssignedTo(\NexusDigital/MiratelForce\StructType\SObject $assignedTo = null)
    {
        if (is_null($assignedTo) || (is_array($assignedTo) && empty($assignedTo))) {
            unset($this->AssignedTo);
        } else {
            $this->AssignedTo = $assignedTo;
        }
        return $this;
    }
    /**
     * Get AssignedToId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignedToId()
    {
        return isset($this->AssignedToId) ? $this->AssignedToId : null;
    }
    /**
     * Set AssignedToId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignedToId
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setAssignedToId($assignedToId = null)
    {
        // validation for constraint: string
        if (!is_null($assignedToId) && !is_string($assignedToId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignedToId, true), gettype($assignedToId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($assignedToId) && mb_strlen($assignedToId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($assignedToId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($assignedToId) && !preg_match('/[a-zA-Z0-9]{18}/', $assignedToId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($assignedToId, true)), __LINE__);
        }
        if (is_null($assignedToId) || (is_array($assignedToId) && empty($assignedToId))) {
            unset($this->AssignedToId);
        } else {
            $this->AssignedToId = $assignedToId;
        }
        return $this;
    }
    /**
     * Get AssignmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignmentDate()
    {
        return isset($this->AssignmentDate) ? $this->AssignmentDate : null;
    }
    /**
     * Set AssignmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignmentDate
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setAssignmentDate($assignmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($assignmentDate) && !is_string($assignmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignmentDate, true), gettype($assignmentDate)), __LINE__);
        }
        if (is_null($assignmentDate) || (is_array($assignmentDate) && empty($assignmentDate))) {
            unset($this->AssignmentDate);
        } else {
            $this->AssignmentDate = $assignmentDate;
        }
        return $this;
    }
    /**
     * Get AssignmentDueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignmentDueDate()
    {
        return isset($this->AssignmentDueDate) ? $this->AssignmentDueDate : null;
    }
    /**
     * Set AssignmentDueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignmentDueDate
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setAssignmentDueDate($assignmentDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($assignmentDueDate) && !is_string($assignmentDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignmentDueDate, true), gettype($assignmentDueDate)), __LINE__);
        }
        if (is_null($assignmentDueDate) || (is_array($assignmentDueDate) && empty($assignmentDueDate))) {
            unset($this->AssignmentDueDate);
        } else {
            $this->AssignmentDueDate = $assignmentDueDate;
        }
        return $this;
    }
    /**
     * Get AssignmentNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignmentNote()
    {
        return isset($this->AssignmentNote) ? $this->AssignmentNote : null;
    }
    /**
     * Set AssignmentNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignmentNote
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setAssignmentNote($assignmentNote = null)
    {
        // validation for constraint: string
        if (!is_null($assignmentNote) && !is_string($assignmentNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignmentNote, true), gettype($assignmentNote)), __LINE__);
        }
        if (is_null($assignmentNote) || (is_array($assignmentNote) && empty($assignmentNote))) {
            unset($this->AssignmentNote);
        } else {
            $this->AssignmentNote = $assignmentNote;
        }
        return $this;
    }
    /**
     * Get AttachedContentDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentDocuments()
    {
        return isset($this->AttachedContentDocuments) ? $this->AttachedContentDocuments : null;
    }
    /**
     * Set AttachedContentDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setAttachedContentDocuments(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null)
    {
        if (is_null($attachedContentDocuments) || (is_array($attachedContentDocuments) && empty($attachedContentDocuments))) {
            unset($this->AttachedContentDocuments);
        } else {
            $this->AttachedContentDocuments = $attachedContentDocuments;
        }
        return $this;
    }
    /**
     * Get AttachedContentNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentNotes()
    {
        return isset($this->AttachedContentNotes) ? $this->AttachedContentNotes : null;
    }
    /**
     * Set AttachedContentNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setAttachedContentNotes(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null)
    {
        if (is_null($attachedContentNotes) || (is_array($attachedContentNotes) && empty($attachedContentNotes))) {
            unset($this->AttachedContentNotes);
        } else {
            $this->AttachedContentNotes = $attachedContentNotes;
        }
        return $this;
    }
    /**
     * Get Campaign__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaign__c()
    {
        return isset($this->Campaign__c) ? $this->Campaign__c : null;
    }
    /**
     * Set Campaign__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaign__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setCampaign__c($campaign__c = null)
    {
        // validation for constraint: string
        if (!is_null($campaign__c) && !is_string($campaign__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaign__c, true), gettype($campaign__c)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($campaign__c) && mb_strlen($campaign__c) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($campaign__c)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($campaign__c) && !preg_match('/[a-zA-Z0-9]{18}/', $campaign__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($campaign__c, true)), __LINE__);
        }
        if (is_null($campaign__c) || (is_array($campaign__c) && empty($campaign__c))) {
            unset($this->Campaign__c);
        } else {
            $this->Campaign__c = $campaign__c;
        }
        return $this;
    }
    /**
     * Get Campaign__r value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Campaign__c|null
     */
    public function getCampaign__r()
    {
        return isset($this->Campaign__r) ? $this->Campaign__r : null;
    }
    /**
     * Set Campaign__r value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Campaign__c $campaign__r
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setCampaign__r(\NexusDigital/MiratelForce\StructType\Campaign__c $campaign__r = null)
    {
        if (is_null($campaign__r) || (is_array($campaign__r) && empty($campaign__r))) {
            unset($this->Campaign__r);
        } else {
            $this->Campaign__r = $campaign__r;
        }
        return $this;
    }
    /**
     * Get CaseArticles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCaseArticles()
    {
        return isset($this->CaseArticles) ? $this->CaseArticles : null;
    }
    /**
     * Set CaseArticles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $caseArticles
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setCaseArticles(\NexusDigital/MiratelForce\StructType\QueryResult $caseArticles = null)
    {
        if (is_null($caseArticles) || (is_array($caseArticles) && empty($caseArticles))) {
            unset($this->CaseArticles);
        } else {
            $this->CaseArticles = $caseArticles;
        }
        return $this;
    }
    /**
     * Get Client_FAQ__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClient_FAQ__c()
    {
        return isset($this->Client_FAQ__c) ? $this->Client_FAQ__c : null;
    }
    /**
     * Set Client_FAQ__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $client_FAQ__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setClient_FAQ__c($client_FAQ__c = null)
    {
        // validation for constraint: string
        if (!is_null($client_FAQ__c) && !is_string($client_FAQ__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($client_FAQ__c, true), gettype($client_FAQ__c)), __LINE__);
        }
        if (is_null($client_FAQ__c) || (is_array($client_FAQ__c) && empty($client_FAQ__c))) {
            unset($this->Client_FAQ__c);
        } else {
            $this->Client_FAQ__c = $client_FAQ__c;
        }
        return $this;
    }
    /**
     * Get CombinedAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCombinedAttachments()
    {
        return isset($this->CombinedAttachments) ? $this->CombinedAttachments : null;
    }
    /**
     * Set CombinedAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setCombinedAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null)
    {
        if (is_null($combinedAttachments) || (is_array($combinedAttachments) && empty($combinedAttachments))) {
            unset($this->CombinedAttachments);
        } else {
            $this->CombinedAttachments = $combinedAttachments;
        }
        return $this;
    }
    /**
     * Get ContentDocumentLinks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContentDocumentLinks()
    {
        return isset($this->ContentDocumentLinks) ? $this->ContentDocumentLinks : null;
    }
    /**
     * Set ContentDocumentLinks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setContentDocumentLinks(\NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null)
    {
        if (is_null($contentDocumentLinks) || (is_array($contentDocumentLinks) && empty($contentDocumentLinks))) {
            unset($this->ContentDocumentLinks);
        } else {
            $this->ContentDocumentLinks = $contentDocumentLinks;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DataCategorySelections value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getDataCategorySelections()
    {
        return isset($this->DataCategorySelections) ? $this->DataCategorySelections : null;
    }
    /**
     * Set DataCategorySelections value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $dataCategorySelections
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setDataCategorySelections(\NexusDigital/MiratelForce\StructType\QueryResult $dataCategorySelections = null)
    {
        if (is_null($dataCategorySelections) || (is_array($dataCategorySelections) && empty($dataCategorySelections))) {
            unset($this->DataCategorySelections);
        } else {
            $this->DataCategorySelections = $dataCategorySelections;
        }
        return $this;
    }
    /**
     * Get Draw_Dates_and_Deadlines__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDraw_Dates_and_Deadlines__c()
    {
        return isset($this->Draw_Dates_and_Deadlines__c) ? $this->Draw_Dates_and_Deadlines__c : null;
    }
    /**
     * Set Draw_Dates_and_Deadlines__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $draw_Dates_and_Deadlines__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setDraw_Dates_and_Deadlines__c($draw_Dates_and_Deadlines__c = null)
    {
        // validation for constraint: string
        if (!is_null($draw_Dates_and_Deadlines__c) && !is_string($draw_Dates_and_Deadlines__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($draw_Dates_and_Deadlines__c, true), gettype($draw_Dates_and_Deadlines__c)), __LINE__);
        }
        if (is_null($draw_Dates_and_Deadlines__c) || (is_array($draw_Dates_and_Deadlines__c) && empty($draw_Dates_and_Deadlines__c))) {
            unset($this->Draw_Dates_and_Deadlines__c);
        } else {
            $this->Draw_Dates_and_Deadlines__c = $draw_Dates_and_Deadlines__c;
        }
        return $this;
    }
    /**
     * Get Draw_Details__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDraw_Details__c()
    {
        return isset($this->Draw_Details__c) ? $this->Draw_Details__c : null;
    }
    /**
     * Set Draw_Details__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $draw_Details__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setDraw_Details__c($draw_Details__c = null)
    {
        // validation for constraint: string
        if (!is_null($draw_Details__c) && !is_string($draw_Details__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($draw_Details__c, true), gettype($draw_Details__c)), __LINE__);
        }
        if (is_null($draw_Details__c) || (is_array($draw_Details__c) && empty($draw_Details__c))) {
            unset($this->Draw_Details__c);
        } else {
            $this->Draw_Details__c = $draw_Details__c;
        }
        return $this;
    }
    /**
     * Get Draws_FAQ__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDraws_FAQ__c()
    {
        return isset($this->Draws_FAQ__c) ? $this->Draws_FAQ__c : null;
    }
    /**
     * Set Draws_FAQ__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $draws_FAQ__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setDraws_FAQ__c($draws_FAQ__c = null)
    {
        // validation for constraint: string
        if (!is_null($draws_FAQ__c) && !is_string($draws_FAQ__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($draws_FAQ__c, true), gettype($draws_FAQ__c)), __LINE__);
        }
        if (is_null($draws_FAQ__c) || (is_array($draws_FAQ__c) && empty($draws_FAQ__c))) {
            unset($this->Draws_FAQ__c);
        } else {
            $this->Draws_FAQ__c = $draws_FAQ__c;
        }
        return $this;
    }
    /**
     * Get FirstPublishedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstPublishedDate()
    {
        return isset($this->FirstPublishedDate) ? $this->FirstPublishedDate : null;
    }
    /**
     * Set FirstPublishedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstPublishedDate
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setFirstPublishedDate($firstPublishedDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstPublishedDate) && !is_string($firstPublishedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstPublishedDate, true), gettype($firstPublishedDate)), __LINE__);
        }
        if (is_null($firstPublishedDate) || (is_array($firstPublishedDate) && empty($firstPublishedDate))) {
            unset($this->FirstPublishedDate);
        } else {
            $this->FirstPublishedDate = $firstPublishedDate;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsLatestVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsLatestVersion()
    {
        return isset($this->IsLatestVersion) ? $this->IsLatestVersion : null;
    }
    /**
     * Set IsLatestVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isLatestVersion
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setIsLatestVersion($isLatestVersion = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLatestVersion) && !is_bool($isLatestVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLatestVersion, true), gettype($isLatestVersion)), __LINE__);
        }
        if (is_null($isLatestVersion) || (is_array($isLatestVersion) && empty($isLatestVersion))) {
            unset($this->IsLatestVersion);
        } else {
            $this->IsLatestVersion = $isLatestVersion;
        }
        return $this;
    }
    /**
     * Get IsVisibleInApp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVisibleInApp()
    {
        return isset($this->IsVisibleInApp) ? $this->IsVisibleInApp : null;
    }
    /**
     * Set IsVisibleInApp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVisibleInApp
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setIsVisibleInApp($isVisibleInApp = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVisibleInApp) && !is_bool($isVisibleInApp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVisibleInApp, true), gettype($isVisibleInApp)), __LINE__);
        }
        if (is_null($isVisibleInApp) || (is_array($isVisibleInApp) && empty($isVisibleInApp))) {
            unset($this->IsVisibleInApp);
        } else {
            $this->IsVisibleInApp = $isVisibleInApp;
        }
        return $this;
    }
    /**
     * Get IsVisibleInCsp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVisibleInCsp()
    {
        return isset($this->IsVisibleInCsp) ? $this->IsVisibleInCsp : null;
    }
    /**
     * Set IsVisibleInCsp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVisibleInCsp
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setIsVisibleInCsp($isVisibleInCsp = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVisibleInCsp) && !is_bool($isVisibleInCsp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVisibleInCsp, true), gettype($isVisibleInCsp)), __LINE__);
        }
        if (is_null($isVisibleInCsp) || (is_array($isVisibleInCsp) && empty($isVisibleInCsp))) {
            unset($this->IsVisibleInCsp);
        } else {
            $this->IsVisibleInCsp = $isVisibleInCsp;
        }
        return $this;
    }
    /**
     * Get IsVisibleInPkb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVisibleInPkb()
    {
        return isset($this->IsVisibleInPkb) ? $this->IsVisibleInPkb : null;
    }
    /**
     * Set IsVisibleInPkb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVisibleInPkb
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setIsVisibleInPkb($isVisibleInPkb = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVisibleInPkb) && !is_bool($isVisibleInPkb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVisibleInPkb, true), gettype($isVisibleInPkb)), __LINE__);
        }
        if (is_null($isVisibleInPkb) || (is_array($isVisibleInPkb) && empty($isVisibleInPkb))) {
            unset($this->IsVisibleInPkb);
        } else {
            $this->IsVisibleInPkb = $isVisibleInPkb;
        }
        return $this;
    }
    /**
     * Get IsVisibleInPrm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVisibleInPrm()
    {
        return isset($this->IsVisibleInPrm) ? $this->IsVisibleInPrm : null;
    }
    /**
     * Set IsVisibleInPrm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVisibleInPrm
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setIsVisibleInPrm($isVisibleInPrm = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVisibleInPrm) && !is_bool($isVisibleInPrm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVisibleInPrm, true), gettype($isVisibleInPrm)), __LINE__);
        }
        if (is_null($isVisibleInPrm) || (is_array($isVisibleInPrm) && empty($isVisibleInPrm))) {
            unset($this->IsVisibleInPrm);
        } else {
            $this->IsVisibleInPrm = $isVisibleInPrm;
        }
        return $this;
    }
    /**
     * Get KnowledgeArticleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKnowledgeArticleId()
    {
        return isset($this->KnowledgeArticleId) ? $this->KnowledgeArticleId : null;
    }
    /**
     * Set KnowledgeArticleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $knowledgeArticleId
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setKnowledgeArticleId($knowledgeArticleId = null)
    {
        // validation for constraint: string
        if (!is_null($knowledgeArticleId) && !is_string($knowledgeArticleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($knowledgeArticleId, true), gettype($knowledgeArticleId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($knowledgeArticleId) && mb_strlen($knowledgeArticleId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($knowledgeArticleId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($knowledgeArticleId) && !preg_match('/[a-zA-Z0-9]{18}/', $knowledgeArticleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($knowledgeArticleId, true)), __LINE__);
        }
        if (is_null($knowledgeArticleId) || (is_array($knowledgeArticleId) && empty($knowledgeArticleId))) {
            unset($this->KnowledgeArticleId);
        } else {
            $this->KnowledgeArticleId = $knowledgeArticleId;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LastPublishedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastPublishedDate()
    {
        return isset($this->LastPublishedDate) ? $this->LastPublishedDate : null;
    }
    /**
     * Set LastPublishedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastPublishedDate
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setLastPublishedDate($lastPublishedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastPublishedDate) && !is_string($lastPublishedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastPublishedDate, true), gettype($lastPublishedDate)), __LINE__);
        }
        if (is_null($lastPublishedDate) || (is_array($lastPublishedDate) && empty($lastPublishedDate))) {
            unset($this->LastPublishedDate);
        } else {
            $this->LastPublishedDate = $lastPublishedDate;
        }
        return $this;
    }
    /**
     * Get LinkedArticles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getLinkedArticles()
    {
        return isset($this->LinkedArticles) ? $this->LinkedArticles : null;
    }
    /**
     * Set LinkedArticles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $linkedArticles
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setLinkedArticles(\NexusDigital/MiratelForce\StructType\QueryResult $linkedArticles = null)
    {
        if (is_null($linkedArticles) || (is_array($linkedArticles) && empty($linkedArticles))) {
            unset($this->LinkedArticles);
        } else {
            $this->LinkedArticles = $linkedArticles;
        }
        return $this;
    }
    /**
     * Get Membership_FAQ__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembership_FAQ__c()
    {
        return isset($this->Membership_FAQ__c) ? $this->Membership_FAQ__c : null;
    }
    /**
     * Set Membership_FAQ__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membership_FAQ__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setMembership_FAQ__c($membership_FAQ__c = null)
    {
        // validation for constraint: string
        if (!is_null($membership_FAQ__c) && !is_string($membership_FAQ__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membership_FAQ__c, true), gettype($membership_FAQ__c)), __LINE__);
        }
        if (is_null($membership_FAQ__c) || (is_array($membership_FAQ__c) && empty($membership_FAQ__c))) {
            unset($this->Membership_FAQ__c);
        } else {
            $this->Membership_FAQ__c = $membership_FAQ__c;
        }
        return $this;
    }
    /**
     * Get MigratedToFromArticleVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMigratedToFromArticleVersion()
    {
        return isset($this->MigratedToFromArticleVersion) ? $this->MigratedToFromArticleVersion : null;
    }
    /**
     * Set MigratedToFromArticleVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $migratedToFromArticleVersion
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setMigratedToFromArticleVersion($migratedToFromArticleVersion = null)
    {
        // validation for constraint: string
        if (!is_null($migratedToFromArticleVersion) && !is_string($migratedToFromArticleVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($migratedToFromArticleVersion, true), gettype($migratedToFromArticleVersion)), __LINE__);
        }
        if (is_null($migratedToFromArticleVersion) || (is_array($migratedToFromArticleVersion) && empty($migratedToFromArticleVersion))) {
            unset($this->MigratedToFromArticleVersion);
        } else {
            $this->MigratedToFromArticleVersion = $migratedToFromArticleVersion;
        }
        return $this;
    }
    /**
     * Get NetworkUserHistoryRecentToRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNetworkUserHistoryRecentToRecord()
    {
        return isset($this->NetworkUserHistoryRecentToRecord) ? $this->NetworkUserHistoryRecentToRecord : null;
    }
    /**
     * Set NetworkUserHistoryRecentToRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkUserHistoryRecentToRecord
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setNetworkUserHistoryRecentToRecord(\NexusDigital/MiratelForce\StructType\QueryResult $networkUserHistoryRecentToRecord = null)
    {
        if (is_null($networkUserHistoryRecentToRecord) || (is_array($networkUserHistoryRecentToRecord) && empty($networkUserHistoryRecentToRecord))) {
            unset($this->NetworkUserHistoryRecentToRecord);
        } else {
            $this->NetworkUserHistoryRecentToRecord = $networkUserHistoryRecentToRecord;
        }
        return $this;
    }
    /**
     * Get Online_Issues_FAQ__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnline_Issues_FAQ__c()
    {
        return isset($this->Online_Issues_FAQ__c) ? $this->Online_Issues_FAQ__c : null;
    }
    /**
     * Set Online_Issues_FAQ__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $online_Issues_FAQ__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setOnline_Issues_FAQ__c($online_Issues_FAQ__c = null)
    {
        // validation for constraint: string
        if (!is_null($online_Issues_FAQ__c) && !is_string($online_Issues_FAQ__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($online_Issues_FAQ__c, true), gettype($online_Issues_FAQ__c)), __LINE__);
        }
        if (is_null($online_Issues_FAQ__c) || (is_array($online_Issues_FAQ__c) && empty($online_Issues_FAQ__c))) {
            unset($this->Online_Issues_FAQ__c);
        } else {
            $this->Online_Issues_FAQ__c = $online_Issues_FAQ__c;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $owner
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setOwner(\NexusDigital/MiratelForce\StructType\SObject $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ownerId) && mb_strlen($ownerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ownerId) && !preg_match('/[a-zA-Z0-9]{18}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get Payment_FAQ__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayment_FAQ__c()
    {
        return isset($this->Payment_FAQ__c) ? $this->Payment_FAQ__c : null;
    }
    /**
     * Set Payment_FAQ__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payment_FAQ__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setPayment_FAQ__c($payment_FAQ__c = null)
    {
        // validation for constraint: string
        if (!is_null($payment_FAQ__c) && !is_string($payment_FAQ__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payment_FAQ__c, true), gettype($payment_FAQ__c)), __LINE__);
        }
        if (is_null($payment_FAQ__c) || (is_array($payment_FAQ__c) && empty($payment_FAQ__c))) {
            unset($this->Payment_FAQ__c);
        } else {
            $this->Payment_FAQ__c = $payment_FAQ__c;
        }
        return $this;
    }
    /**
     * Get Prizes_FAQ__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrizes_FAQ__c()
    {
        return isset($this->Prizes_FAQ__c) ? $this->Prizes_FAQ__c : null;
    }
    /**
     * Set Prizes_FAQ__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prizes_FAQ__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setPrizes_FAQ__c($prizes_FAQ__c = null)
    {
        // validation for constraint: string
        if (!is_null($prizes_FAQ__c) && !is_string($prizes_FAQ__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prizes_FAQ__c, true), gettype($prizes_FAQ__c)), __LINE__);
        }
        if (is_null($prizes_FAQ__c) || (is_array($prizes_FAQ__c) && empty($prizes_FAQ__c))) {
            unset($this->Prizes_FAQ__c);
        } else {
            $this->Prizes_FAQ__c = $prizes_FAQ__c;
        }
        return $this;
    }
    /**
     * Get Prizes_List__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrizes_List__c()
    {
        return isset($this->Prizes_List__c) ? $this->Prizes_List__c : null;
    }
    /**
     * Set Prizes_List__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prizes_List__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setPrizes_List__c($prizes_List__c = null)
    {
        // validation for constraint: string
        if (!is_null($prizes_List__c) && !is_string($prizes_List__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prizes_List__c, true), gettype($prizes_List__c)), __LINE__);
        }
        if (is_null($prizes_List__c) || (is_array($prizes_List__c) && empty($prizes_List__c))) {
            unset($this->Prizes_List__c);
        } else {
            $this->Prizes_List__c = $prizes_List__c;
        }
        return $this;
    }
    /**
     * Get Procedure_Audience__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcedure_Audience__c()
    {
        return isset($this->Procedure_Audience__c) ? $this->Procedure_Audience__c : null;
    }
    /**
     * Set Procedure_Audience__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $procedure_Audience__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setProcedure_Audience__c($procedure_Audience__c = null)
    {
        // validation for constraint: string
        if (!is_null($procedure_Audience__c) && !is_string($procedure_Audience__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($procedure_Audience__c, true), gettype($procedure_Audience__c)), __LINE__);
        }
        if (is_null($procedure_Audience__c) || (is_array($procedure_Audience__c) && empty($procedure_Audience__c))) {
            unset($this->Procedure_Audience__c);
        } else {
            $this->Procedure_Audience__c = $procedure_Audience__c;
        }
        return $this;
    }
    /**
     * Get Procedure_Purpose__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcedure_Purpose__c()
    {
        return isset($this->Procedure_Purpose__c) ? $this->Procedure_Purpose__c : null;
    }
    /**
     * Set Procedure_Purpose__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $procedure_Purpose__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setProcedure_Purpose__c($procedure_Purpose__c = null)
    {
        // validation for constraint: string
        if (!is_null($procedure_Purpose__c) && !is_string($procedure_Purpose__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($procedure_Purpose__c, true), gettype($procedure_Purpose__c)), __LINE__);
        }
        if (is_null($procedure_Purpose__c) || (is_array($procedure_Purpose__c) && empty($procedure_Purpose__c))) {
            unset($this->Procedure_Purpose__c);
        } else {
            $this->Procedure_Purpose__c = $procedure_Purpose__c;
        }
        return $this;
    }
    /**
     * Get Procedure_Steps__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcedure_Steps__c()
    {
        return isset($this->Procedure_Steps__c) ? $this->Procedure_Steps__c : null;
    }
    /**
     * Set Procedure_Steps__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $procedure_Steps__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setProcedure_Steps__c($procedure_Steps__c = null)
    {
        // validation for constraint: string
        if (!is_null($procedure_Steps__c) && !is_string($procedure_Steps__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($procedure_Steps__c, true), gettype($procedure_Steps__c)), __LINE__);
        }
        if (is_null($procedure_Steps__c) || (is_array($procedure_Steps__c) && empty($procedure_Steps__c))) {
            unset($this->Procedure_Steps__c);
        } else {
            $this->Procedure_Steps__c = $procedure_Steps__c;
        }
        return $this;
    }
    /**
     * Get Procedure_Warnings__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcedure_Warnings__c()
    {
        return isset($this->Procedure_Warnings__c) ? $this->Procedure_Warnings__c : null;
    }
    /**
     * Set Procedure_Warnings__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $procedure_Warnings__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setProcedure_Warnings__c($procedure_Warnings__c = null)
    {
        // validation for constraint: string
        if (!is_null($procedure_Warnings__c) && !is_string($procedure_Warnings__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($procedure_Warnings__c, true), gettype($procedure_Warnings__c)), __LINE__);
        }
        if (is_null($procedure_Warnings__c) || (is_array($procedure_Warnings__c) && empty($procedure_Warnings__c))) {
            unset($this->Procedure_Warnings__c);
        } else {
            $this->Procedure_Warnings__c = $procedure_Warnings__c;
        }
        return $this;
    }
    /**
     * Get ProcessInstances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessInstances()
    {
        return isset($this->ProcessInstances) ? $this->ProcessInstances : null;
    }
    /**
     * Set ProcessInstances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setProcessInstances(\NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null)
    {
        if (is_null($processInstances) || (is_array($processInstances) && empty($processInstances))) {
            unset($this->ProcessInstances);
        } else {
            $this->ProcessInstances = $processInstances;
        }
        return $this;
    }
    /**
     * Get ProcessSteps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessSteps()
    {
        return isset($this->ProcessSteps) ? $this->ProcessSteps : null;
    }
    /**
     * Set ProcessSteps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setProcessSteps(\NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null)
    {
        if (is_null($processSteps) || (is_array($processSteps) && empty($processSteps))) {
            unset($this->ProcessSteps);
        } else {
            $this->ProcessSteps = $processSteps;
        }
        return $this;
    }
    /**
     * Get PublishStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPublishStatus()
    {
        return isset($this->PublishStatus) ? $this->PublishStatus : null;
    }
    /**
     * Set PublishStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $publishStatus
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setPublishStatus($publishStatus = null)
    {
        // validation for constraint: string
        if (!is_null($publishStatus) && !is_string($publishStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publishStatus, true), gettype($publishStatus)), __LINE__);
        }
        if (is_null($publishStatus) || (is_array($publishStatus) && empty($publishStatus))) {
            unset($this->PublishStatus);
        } else {
            $this->PublishStatus = $publishStatus;
        }
        return $this;
    }
    /**
     * Get Question__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQuestion__c()
    {
        return isset($this->Question__c) ? $this->Question__c : null;
    }
    /**
     * Set Question__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $question__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setQuestion__c($question__c = null)
    {
        // validation for constraint: string
        if (!is_null($question__c) && !is_string($question__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($question__c, true), gettype($question__c)), __LINE__);
        }
        if (is_null($question__c) || (is_array($question__c) && empty($question__c))) {
            unset($this->Question__c);
        } else {
            $this->Question__c = $question__c;
        }
        return $this;
    }
    /**
     * Get RecordType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\RecordType|null
     */
    public function getRecordType()
    {
        return isset($this->RecordType) ? $this->RecordType : null;
    }
    /**
     * Set RecordType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\RecordType $recordType
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setRecordType(\NexusDigital/MiratelForce\StructType\RecordType $recordType = null)
    {
        if (is_null($recordType) || (is_array($recordType) && empty($recordType))) {
            unset($this->RecordType);
        } else {
            $this->RecordType = $recordType;
        }
        return $this;
    }
    /**
     * Get RecordTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordTypeId()
    {
        return isset($this->RecordTypeId) ? $this->RecordTypeId : null;
    }
    /**
     * Set RecordTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordTypeId
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setRecordTypeId($recordTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($recordTypeId) && !is_string($recordTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordTypeId, true), gettype($recordTypeId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($recordTypeId) && mb_strlen($recordTypeId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($recordTypeId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($recordTypeId) && !preg_match('/[a-zA-Z0-9]{18}/', $recordTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($recordTypeId, true)), __LINE__);
        }
        if (is_null($recordTypeId) || (is_array($recordTypeId) && empty($recordTypeId))) {
            unset($this->RecordTypeId);
        } else {
            $this->RecordTypeId = $recordTypeId;
        }
        return $this;
    }
    /**
     * Get SearchPromotionRules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getSearchPromotionRules()
    {
        return isset($this->SearchPromotionRules) ? $this->SearchPromotionRules : null;
    }
    /**
     * Set SearchPromotionRules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $searchPromotionRules
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setSearchPromotionRules(\NexusDigital/MiratelForce\StructType\QueryResult $searchPromotionRules = null)
    {
        if (is_null($searchPromotionRules) || (is_array($searchPromotionRules) && empty($searchPromotionRules))) {
            unset($this->SearchPromotionRules);
        } else {
            $this->SearchPromotionRules = $searchPromotionRules;
        }
        return $this;
    }
    /**
     * Get Showhome_FAQ__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowhome_FAQ__c()
    {
        return isset($this->Showhome_FAQ__c) ? $this->Showhome_FAQ__c : null;
    }
    /**
     * Set Showhome_FAQ__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showhome_FAQ__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setShowhome_FAQ__c($showhome_FAQ__c = null)
    {
        // validation for constraint: string
        if (!is_null($showhome_FAQ__c) && !is_string($showhome_FAQ__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showhome_FAQ__c, true), gettype($showhome_FAQ__c)), __LINE__);
        }
        if (is_null($showhome_FAQ__c) || (is_array($showhome_FAQ__c) && empty($showhome_FAQ__c))) {
            unset($this->Showhome_FAQ__c);
        } else {
            $this->Showhome_FAQ__c = $showhome_FAQ__c;
        }
        return $this;
    }
    /**
     * Get SourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceId()
    {
        return isset($this->SourceId) ? $this->SourceId : null;
    }
    /**
     * Set SourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceId
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($sourceId) && mb_strlen($sourceId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($sourceId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($sourceId) && !preg_match('/[a-zA-Z0-9]{18}/', $sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($sourceId, true)), __LINE__);
        }
        if (is_null($sourceId) || (is_array($sourceId) && empty($sourceId))) {
            unset($this->SourceId);
        } else {
            $this->SourceId = $sourceId;
        }
        return $this;
    }
    /**
     * Get Summary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSummary()
    {
        return isset($this->Summary) ? $this->Summary : null;
    }
    /**
     * Set Summary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $summary
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setSummary($summary = null)
    {
        // validation for constraint: string
        if (!is_null($summary) && !is_string($summary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($summary, true), gettype($summary)), __LINE__);
        }
        if (is_null($summary) || (is_array($summary) && empty($summary))) {
            unset($this->Summary);
        } else {
            $this->Summary = $summary;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get Tickets_FAQ__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTickets_FAQ__c()
    {
        return isset($this->Tickets_FAQ__c) ? $this->Tickets_FAQ__c : null;
    }
    /**
     * Set Tickets_FAQ__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tickets_FAQ__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setTickets_FAQ__c($tickets_FAQ__c = null)
    {
        // validation for constraint: string
        if (!is_null($tickets_FAQ__c) && !is_string($tickets_FAQ__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tickets_FAQ__c, true), gettype($tickets_FAQ__c)), __LINE__);
        }
        if (is_null($tickets_FAQ__c) || (is_array($tickets_FAQ__c) && empty($tickets_FAQ__c))) {
            unset($this->Tickets_FAQ__c);
        } else {
            $this->Tickets_FAQ__c = $tickets_FAQ__c;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get TopicAssignments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTopicAssignments()
    {
        return isset($this->TopicAssignments) ? $this->TopicAssignments : null;
    }
    /**
     * Set TopicAssignments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setTopicAssignments(\NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments = null)
    {
        if (is_null($topicAssignments) || (is_array($topicAssignments) && empty($topicAssignments))) {
            unset($this->TopicAssignments);
        } else {
            $this->TopicAssignments = $topicAssignments;
        }
        return $this;
    }
    /**
     * Get UrlName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrlName()
    {
        return isset($this->UrlName) ? $this->UrlName : null;
    }
    /**
     * Set UrlName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $urlName
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setUrlName($urlName = null)
    {
        // validation for constraint: string
        if (!is_null($urlName) && !is_string($urlName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlName, true), gettype($urlName)), __LINE__);
        }
        if (is_null($urlName) || (is_array($urlName) && empty($urlName))) {
            unset($this->UrlName);
        } else {
            $this->UrlName = $urlName;
        }
        return $this;
    }
    /**
     * Get ValidationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidationStatus()
    {
        return isset($this->ValidationStatus) ? $this->ValidationStatus : null;
    }
    /**
     * Set ValidationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validationStatus
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setValidationStatus($validationStatus = null)
    {
        // validation for constraint: string
        if (!is_null($validationStatus) && !is_string($validationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validationStatus, true), gettype($validationStatus)), __LINE__);
        }
        if (is_null($validationStatus) || (is_array($validationStatus) && empty($validationStatus))) {
            unset($this->ValidationStatus);
        } else {
            $this->ValidationStatus = $validationStatus;
        }
        return $this;
    }
    /**
     * Get VersionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVersionNumber()
    {
        return isset($this->VersionNumber) ? $this->VersionNumber : null;
    }
    /**
     * Set VersionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $versionNumber
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setVersionNumber($versionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($versionNumber) && !(is_int($versionNumber) || ctype_digit($versionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($versionNumber, true), gettype($versionNumber)), __LINE__);
        }
        if (is_null($versionNumber) || (is_array($versionNumber) && empty($versionNumber))) {
            unset($this->VersionNumber);
        } else {
            $this->VersionNumber = $versionNumber;
        }
        return $this;
    }
    /**
     * Get Winners_FAQ__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWinners_FAQ__c()
    {
        return isset($this->Winners_FAQ__c) ? $this->Winners_FAQ__c : null;
    }
    /**
     * Set Winners_FAQ__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $winners_FAQ__c
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public function setWinners_FAQ__c($winners_FAQ__c = null)
    {
        // validation for constraint: string
        if (!is_null($winners_FAQ__c) && !is_string($winners_FAQ__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($winners_FAQ__c, true), gettype($winners_FAQ__c)), __LINE__);
        }
        if (is_null($winners_FAQ__c) || (is_array($winners_FAQ__c) && empty($winners_FAQ__c))) {
            unset($this->Winners_FAQ__c);
        } else {
            $this->Winners_FAQ__c = $winners_FAQ__c;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
