<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KnowledgeArticleVersion StructType
 * @subpackage Structs
 */
class KnowledgeArticleVersion extends SObject
{
    /**
     * The ArchivedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $ArchivedBy;
    /**
     * The ArchivedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ArchivedById;
    /**
     * The ArchivedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArchivedDate;
    /**
     * The ArticleArchivedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $ArticleArchivedBy;
    /**
     * The ArticleArchivedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ArticleArchivedById;
    /**
     * The ArticleArchivedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArticleArchivedDate;
    /**
     * The ArticleCaseAttachCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ArticleCaseAttachCount;
    /**
     * The ArticleCreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $ArticleCreatedBy;
    /**
     * The ArticleCreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ArticleCreatedById;
    /**
     * The ArticleCreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArticleCreatedDate;
    /**
     * The ArticleMasterLanguage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArticleMasterLanguage;
    /**
     * The ArticleNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArticleNumber;
    /**
     * The ArticleTotalViewCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ArticleTotalViewCount;
    /**
     * The AssignedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $AssignedBy;
    /**
     * The AssignedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AssignedById;
    /**
     * The AssignedTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $AssignedTo;
    /**
     * The AssignedToId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AssignedToId;
    /**
     * The AssignmentDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssignmentDate;
    /**
     * The AssignmentDueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssignmentDueDate;
    /**
     * The AssignmentNote
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssignmentNote;
    /**
     * The AttachedContentDocuments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentDocuments;
    /**
     * The AttachedContentNotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentNotes;
    /**
     * The CaseArticles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CaseArticles;
    /**
     * The CombinedAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CombinedAttachments;
    /**
     * The ContentDocumentLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContentDocumentLinks;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The FirstPublishedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstPublishedDate;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsLatestVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsLatestVersion;
    /**
     * The IsVisibleInApp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVisibleInApp;
    /**
     * The IsVisibleInCsp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVisibleInCsp;
    /**
     * The IsVisibleInPkb
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVisibleInPkb;
    /**
     * The IsVisibleInPrm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVisibleInPrm;
    /**
     * The KnowledgeArticleId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $KnowledgeArticleId;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastPublishedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastPublishedDate;
    /**
     * The LinkedArticles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $LinkedArticles;
    /**
     * The MigratedToFromArticleVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MigratedToFromArticleVersion;
    /**
     * The NetworkUserHistoryRecentToRecord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NetworkUserHistoryRecentToRecord;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $Owner;
    /**
     * The OwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OwnerId;
    /**
     * The ProcessInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessInstances;
    /**
     * The ProcessSteps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessSteps;
    /**
     * The PublishStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PublishStatus;
    /**
     * The SearchPromotionRules
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $SearchPromotionRules;
    /**
     * The SourceId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $SourceId;
    /**
     * The Summary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Summary;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The TopicAssignments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $TopicAssignments;
    /**
     * The UrlName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UrlName;
    /**
     * The ValidationStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidationStatus;
    /**
     * The VersionNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $VersionNumber;
    /**
     * Constructor method for KnowledgeArticleVersion
     * @uses KnowledgeArticleVersion::setArchivedBy()
     * @uses KnowledgeArticleVersion::setArchivedById()
     * @uses KnowledgeArticleVersion::setArchivedDate()
     * @uses KnowledgeArticleVersion::setArticleArchivedBy()
     * @uses KnowledgeArticleVersion::setArticleArchivedById()
     * @uses KnowledgeArticleVersion::setArticleArchivedDate()
     * @uses KnowledgeArticleVersion::setArticleCaseAttachCount()
     * @uses KnowledgeArticleVersion::setArticleCreatedBy()
     * @uses KnowledgeArticleVersion::setArticleCreatedById()
     * @uses KnowledgeArticleVersion::setArticleCreatedDate()
     * @uses KnowledgeArticleVersion::setArticleMasterLanguage()
     * @uses KnowledgeArticleVersion::setArticleNumber()
     * @uses KnowledgeArticleVersion::setArticleTotalViewCount()
     * @uses KnowledgeArticleVersion::setAssignedBy()
     * @uses KnowledgeArticleVersion::setAssignedById()
     * @uses KnowledgeArticleVersion::setAssignedTo()
     * @uses KnowledgeArticleVersion::setAssignedToId()
     * @uses KnowledgeArticleVersion::setAssignmentDate()
     * @uses KnowledgeArticleVersion::setAssignmentDueDate()
     * @uses KnowledgeArticleVersion::setAssignmentNote()
     * @uses KnowledgeArticleVersion::setAttachedContentDocuments()
     * @uses KnowledgeArticleVersion::setAttachedContentNotes()
     * @uses KnowledgeArticleVersion::setCaseArticles()
     * @uses KnowledgeArticleVersion::setCombinedAttachments()
     * @uses KnowledgeArticleVersion::setContentDocumentLinks()
     * @uses KnowledgeArticleVersion::setCreatedBy()
     * @uses KnowledgeArticleVersion::setCreatedById()
     * @uses KnowledgeArticleVersion::setCreatedDate()
     * @uses KnowledgeArticleVersion::setFirstPublishedDate()
     * @uses KnowledgeArticleVersion::setIsDeleted()
     * @uses KnowledgeArticleVersion::setIsLatestVersion()
     * @uses KnowledgeArticleVersion::setIsVisibleInApp()
     * @uses KnowledgeArticleVersion::setIsVisibleInCsp()
     * @uses KnowledgeArticleVersion::setIsVisibleInPkb()
     * @uses KnowledgeArticleVersion::setIsVisibleInPrm()
     * @uses KnowledgeArticleVersion::setKnowledgeArticleId()
     * @uses KnowledgeArticleVersion::setLanguage()
     * @uses KnowledgeArticleVersion::setLastModifiedBy()
     * @uses KnowledgeArticleVersion::setLastModifiedById()
     * @uses KnowledgeArticleVersion::setLastModifiedDate()
     * @uses KnowledgeArticleVersion::setLastPublishedDate()
     * @uses KnowledgeArticleVersion::setLinkedArticles()
     * @uses KnowledgeArticleVersion::setMigratedToFromArticleVersion()
     * @uses KnowledgeArticleVersion::setNetworkUserHistoryRecentToRecord()
     * @uses KnowledgeArticleVersion::setOwner()
     * @uses KnowledgeArticleVersion::setOwnerId()
     * @uses KnowledgeArticleVersion::setProcessInstances()
     * @uses KnowledgeArticleVersion::setProcessSteps()
     * @uses KnowledgeArticleVersion::setPublishStatus()
     * @uses KnowledgeArticleVersion::setSearchPromotionRules()
     * @uses KnowledgeArticleVersion::setSourceId()
     * @uses KnowledgeArticleVersion::setSummary()
     * @uses KnowledgeArticleVersion::setSystemModstamp()
     * @uses KnowledgeArticleVersion::setTitle()
     * @uses KnowledgeArticleVersion::setTopicAssignments()
     * @uses KnowledgeArticleVersion::setUrlName()
     * @uses KnowledgeArticleVersion::setValidationStatus()
     * @uses KnowledgeArticleVersion::setVersionNumber()
     * @param \NexusDigital/MiratelForce\StructType\User $archivedBy
     * @param string $archivedById
     * @param string $archivedDate
     * @param \NexusDigital/MiratelForce\StructType\User $articleArchivedBy
     * @param string $articleArchivedById
     * @param string $articleArchivedDate
     * @param int $articleCaseAttachCount
     * @param \NexusDigital/MiratelForce\StructType\User $articleCreatedBy
     * @param string $articleCreatedById
     * @param string $articleCreatedDate
     * @param string $articleMasterLanguage
     * @param string $articleNumber
     * @param int $articleTotalViewCount
     * @param \NexusDigital/MiratelForce\StructType\User $assignedBy
     * @param string $assignedById
     * @param \NexusDigital/MiratelForce\StructType\SObject $assignedTo
     * @param string $assignedToId
     * @param string $assignmentDate
     * @param string $assignmentDueDate
     * @param string $assignmentNote
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $caseArticles
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $firstPublishedDate
     * @param bool $isDeleted
     * @param bool $isLatestVersion
     * @param bool $isVisibleInApp
     * @param bool $isVisibleInCsp
     * @param bool $isVisibleInPkb
     * @param bool $isVisibleInPrm
     * @param string $knowledgeArticleId
     * @param string $language
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $lastPublishedDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $linkedArticles
     * @param string $migratedToFromArticleVersion
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkUserHistoryRecentToRecord
     * @param \NexusDigital/MiratelForce\StructType\SObject $owner
     * @param string $ownerId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @param string $publishStatus
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $searchPromotionRules
     * @param string $sourceId
     * @param string $summary
     * @param string $systemModstamp
     * @param string $title
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments
     * @param string $urlName
     * @param string $validationStatus
     * @param int $versionNumber
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\User $archivedBy = null, $archivedById = null, $archivedDate = null, \NexusDigital/MiratelForce\StructType\User $articleArchivedBy = null, $articleArchivedById = null, $articleArchivedDate = null, $articleCaseAttachCount = null, \NexusDigital/MiratelForce\StructType\User $articleCreatedBy = null, $articleCreatedById = null, $articleCreatedDate = null, $articleMasterLanguage = null, $articleNumber = null, $articleTotalViewCount = null, \NexusDigital/MiratelForce\StructType\User $assignedBy = null, $assignedById = null, \NexusDigital/MiratelForce\StructType\SObject $assignedTo = null, $assignedToId = null, $assignmentDate = null, $assignmentDueDate = null, $assignmentNote = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null, \NexusDigital/MiratelForce\StructType\QueryResult $caseArticles = null, \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null, \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $firstPublishedDate = null, $isDeleted = null, $isLatestVersion = null, $isVisibleInApp = null, $isVisibleInCsp = null, $isVisibleInPkb = null, $isVisibleInPrm = null, $knowledgeArticleId = null, $language = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lastPublishedDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $linkedArticles = null, $migratedToFromArticleVersion = null, \NexusDigital/MiratelForce\StructType\QueryResult $networkUserHistoryRecentToRecord = null, \NexusDigital/MiratelForce\StructType\SObject $owner = null, $ownerId = null, \NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null, \NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null, $publishStatus = null, \NexusDigital/MiratelForce\StructType\QueryResult $searchPromotionRules = null, $sourceId = null, $summary = null, $systemModstamp = null, $title = null, \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments = null, $urlName = null, $validationStatus = null, $versionNumber = null)
    {
        $this
            ->setArchivedBy($archivedBy)
            ->setArchivedById($archivedById)
            ->setArchivedDate($archivedDate)
            ->setArticleArchivedBy($articleArchivedBy)
            ->setArticleArchivedById($articleArchivedById)
            ->setArticleArchivedDate($articleArchivedDate)
            ->setArticleCaseAttachCount($articleCaseAttachCount)
            ->setArticleCreatedBy($articleCreatedBy)
            ->setArticleCreatedById($articleCreatedById)
            ->setArticleCreatedDate($articleCreatedDate)
            ->setArticleMasterLanguage($articleMasterLanguage)
            ->setArticleNumber($articleNumber)
            ->setArticleTotalViewCount($articleTotalViewCount)
            ->setAssignedBy($assignedBy)
            ->setAssignedById($assignedById)
            ->setAssignedTo($assignedTo)
            ->setAssignedToId($assignedToId)
            ->setAssignmentDate($assignmentDate)
            ->setAssignmentDueDate($assignmentDueDate)
            ->setAssignmentNote($assignmentNote)
            ->setAttachedContentDocuments($attachedContentDocuments)
            ->setAttachedContentNotes($attachedContentNotes)
            ->setCaseArticles($caseArticles)
            ->setCombinedAttachments($combinedAttachments)
            ->setContentDocumentLinks($contentDocumentLinks)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setFirstPublishedDate($firstPublishedDate)
            ->setIsDeleted($isDeleted)
            ->setIsLatestVersion($isLatestVersion)
            ->setIsVisibleInApp($isVisibleInApp)
            ->setIsVisibleInCsp($isVisibleInCsp)
            ->setIsVisibleInPkb($isVisibleInPkb)
            ->setIsVisibleInPrm($isVisibleInPrm)
            ->setKnowledgeArticleId($knowledgeArticleId)
            ->setLanguage($language)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastPublishedDate($lastPublishedDate)
            ->setLinkedArticles($linkedArticles)
            ->setMigratedToFromArticleVersion($migratedToFromArticleVersion)
            ->setNetworkUserHistoryRecentToRecord($networkUserHistoryRecentToRecord)
            ->setOwner($owner)
            ->setOwnerId($ownerId)
            ->setProcessInstances($processInstances)
            ->setProcessSteps($processSteps)
            ->setPublishStatus($publishStatus)
            ->setSearchPromotionRules($searchPromotionRules)
            ->setSourceId($sourceId)
            ->setSummary($summary)
            ->setSystemModstamp($systemModstamp)
            ->setTitle($title)
            ->setTopicAssignments($topicAssignments)
            ->setUrlName($urlName)
            ->setValidationStatus($validationStatus)
            ->setVersionNumber($versionNumber);
    }
    /**
     * Get ArchivedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getArchivedBy()
    {
        return isset($this->ArchivedBy) ? $this->ArchivedBy : null;
    }
    /**
     * Set ArchivedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $archivedBy
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setArchivedBy(\NexusDigital/MiratelForce\StructType\User $archivedBy = null)
    {
        if (is_null($archivedBy) || (is_array($archivedBy) && empty($archivedBy))) {
            unset($this->ArchivedBy);
        } else {
            $this->ArchivedBy = $archivedBy;
        }
        return $this;
    }
    /**
     * Get ArchivedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArchivedById()
    {
        return isset($this->ArchivedById) ? $this->ArchivedById : null;
    }
    /**
     * Set ArchivedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $archivedById
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setArchivedById($archivedById = null)
    {
        // validation for constraint: string
        if (!is_null($archivedById) && !is_string($archivedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($archivedById, true), gettype($archivedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($archivedById) && mb_strlen($archivedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($archivedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($archivedById) && !preg_match('/[a-zA-Z0-9]{18}/', $archivedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($archivedById, true)), __LINE__);
        }
        if (is_null($archivedById) || (is_array($archivedById) && empty($archivedById))) {
            unset($this->ArchivedById);
        } else {
            $this->ArchivedById = $archivedById;
        }
        return $this;
    }
    /**
     * Get ArchivedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArchivedDate()
    {
        return isset($this->ArchivedDate) ? $this->ArchivedDate : null;
    }
    /**
     * Set ArchivedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $archivedDate
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setArchivedDate($archivedDate = null)
    {
        // validation for constraint: string
        if (!is_null($archivedDate) && !is_string($archivedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($archivedDate, true), gettype($archivedDate)), __LINE__);
        }
        if (is_null($archivedDate) || (is_array($archivedDate) && empty($archivedDate))) {
            unset($this->ArchivedDate);
        } else {
            $this->ArchivedDate = $archivedDate;
        }
        return $this;
    }
    /**
     * Get ArticleArchivedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getArticleArchivedBy()
    {
        return isset($this->ArticleArchivedBy) ? $this->ArticleArchivedBy : null;
    }
    /**
     * Set ArticleArchivedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $articleArchivedBy
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setArticleArchivedBy(\NexusDigital/MiratelForce\StructType\User $articleArchivedBy = null)
    {
        if (is_null($articleArchivedBy) || (is_array($articleArchivedBy) && empty($articleArchivedBy))) {
            unset($this->ArticleArchivedBy);
        } else {
            $this->ArticleArchivedBy = $articleArchivedBy;
        }
        return $this;
    }
    /**
     * Get ArticleArchivedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArticleArchivedById()
    {
        return isset($this->ArticleArchivedById) ? $this->ArticleArchivedById : null;
    }
    /**
     * Set ArticleArchivedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $articleArchivedById
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setArticleArchivedById($articleArchivedById = null)
    {
        // validation for constraint: string
        if (!is_null($articleArchivedById) && !is_string($articleArchivedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleArchivedById, true), gettype($articleArchivedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($articleArchivedById) && mb_strlen($articleArchivedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($articleArchivedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($articleArchivedById) && !preg_match('/[a-zA-Z0-9]{18}/', $articleArchivedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($articleArchivedById, true)), __LINE__);
        }
        if (is_null($articleArchivedById) || (is_array($articleArchivedById) && empty($articleArchivedById))) {
            unset($this->ArticleArchivedById);
        } else {
            $this->ArticleArchivedById = $articleArchivedById;
        }
        return $this;
    }
    /**
     * Get ArticleArchivedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArticleArchivedDate()
    {
        return isset($this->ArticleArchivedDate) ? $this->ArticleArchivedDate : null;
    }
    /**
     * Set ArticleArchivedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $articleArchivedDate
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setArticleArchivedDate($articleArchivedDate = null)
    {
        // validation for constraint: string
        if (!is_null($articleArchivedDate) && !is_string($articleArchivedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleArchivedDate, true), gettype($articleArchivedDate)), __LINE__);
        }
        if (is_null($articleArchivedDate) || (is_array($articleArchivedDate) && empty($articleArchivedDate))) {
            unset($this->ArticleArchivedDate);
        } else {
            $this->ArticleArchivedDate = $articleArchivedDate;
        }
        return $this;
    }
    /**
     * Get ArticleCaseAttachCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getArticleCaseAttachCount()
    {
        return isset($this->ArticleCaseAttachCount) ? $this->ArticleCaseAttachCount : null;
    }
    /**
     * Set ArticleCaseAttachCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $articleCaseAttachCount
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setArticleCaseAttachCount($articleCaseAttachCount = null)
    {
        // validation for constraint: int
        if (!is_null($articleCaseAttachCount) && !(is_int($articleCaseAttachCount) || ctype_digit($articleCaseAttachCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleCaseAttachCount, true), gettype($articleCaseAttachCount)), __LINE__);
        }
        if (is_null($articleCaseAttachCount) || (is_array($articleCaseAttachCount) && empty($articleCaseAttachCount))) {
            unset($this->ArticleCaseAttachCount);
        } else {
            $this->ArticleCaseAttachCount = $articleCaseAttachCount;
        }
        return $this;
    }
    /**
     * Get ArticleCreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getArticleCreatedBy()
    {
        return isset($this->ArticleCreatedBy) ? $this->ArticleCreatedBy : null;
    }
    /**
     * Set ArticleCreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $articleCreatedBy
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setArticleCreatedBy(\NexusDigital/MiratelForce\StructType\User $articleCreatedBy = null)
    {
        if (is_null($articleCreatedBy) || (is_array($articleCreatedBy) && empty($articleCreatedBy))) {
            unset($this->ArticleCreatedBy);
        } else {
            $this->ArticleCreatedBy = $articleCreatedBy;
        }
        return $this;
    }
    /**
     * Get ArticleCreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArticleCreatedById()
    {
        return isset($this->ArticleCreatedById) ? $this->ArticleCreatedById : null;
    }
    /**
     * Set ArticleCreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $articleCreatedById
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setArticleCreatedById($articleCreatedById = null)
    {
        // validation for constraint: string
        if (!is_null($articleCreatedById) && !is_string($articleCreatedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleCreatedById, true), gettype($articleCreatedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($articleCreatedById) && mb_strlen($articleCreatedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($articleCreatedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($articleCreatedById) && !preg_match('/[a-zA-Z0-9]{18}/', $articleCreatedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($articleCreatedById, true)), __LINE__);
        }
        if (is_null($articleCreatedById) || (is_array($articleCreatedById) && empty($articleCreatedById))) {
            unset($this->ArticleCreatedById);
        } else {
            $this->ArticleCreatedById = $articleCreatedById;
        }
        return $this;
    }
    /**
     * Get ArticleCreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArticleCreatedDate()
    {
        return isset($this->ArticleCreatedDate) ? $this->ArticleCreatedDate : null;
    }
    /**
     * Set ArticleCreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $articleCreatedDate
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setArticleCreatedDate($articleCreatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($articleCreatedDate) && !is_string($articleCreatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleCreatedDate, true), gettype($articleCreatedDate)), __LINE__);
        }
        if (is_null($articleCreatedDate) || (is_array($articleCreatedDate) && empty($articleCreatedDate))) {
            unset($this->ArticleCreatedDate);
        } else {
            $this->ArticleCreatedDate = $articleCreatedDate;
        }
        return $this;
    }
    /**
     * Get ArticleMasterLanguage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArticleMasterLanguage()
    {
        return isset($this->ArticleMasterLanguage) ? $this->ArticleMasterLanguage : null;
    }
    /**
     * Set ArticleMasterLanguage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $articleMasterLanguage
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setArticleMasterLanguage($articleMasterLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($articleMasterLanguage) && !is_string($articleMasterLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleMasterLanguage, true), gettype($articleMasterLanguage)), __LINE__);
        }
        if (is_null($articleMasterLanguage) || (is_array($articleMasterLanguage) && empty($articleMasterLanguage))) {
            unset($this->ArticleMasterLanguage);
        } else {
            $this->ArticleMasterLanguage = $articleMasterLanguage;
        }
        return $this;
    }
    /**
     * Get ArticleNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArticleNumber()
    {
        return isset($this->ArticleNumber) ? $this->ArticleNumber : null;
    }
    /**
     * Set ArticleNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $articleNumber
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setArticleNumber($articleNumber = null)
    {
        // validation for constraint: string
        if (!is_null($articleNumber) && !is_string($articleNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleNumber, true), gettype($articleNumber)), __LINE__);
        }
        if (is_null($articleNumber) || (is_array($articleNumber) && empty($articleNumber))) {
            unset($this->ArticleNumber);
        } else {
            $this->ArticleNumber = $articleNumber;
        }
        return $this;
    }
    /**
     * Get ArticleTotalViewCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getArticleTotalViewCount()
    {
        return isset($this->ArticleTotalViewCount) ? $this->ArticleTotalViewCount : null;
    }
    /**
     * Set ArticleTotalViewCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $articleTotalViewCount
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setArticleTotalViewCount($articleTotalViewCount = null)
    {
        // validation for constraint: int
        if (!is_null($articleTotalViewCount) && !(is_int($articleTotalViewCount) || ctype_digit($articleTotalViewCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleTotalViewCount, true), gettype($articleTotalViewCount)), __LINE__);
        }
        if (is_null($articleTotalViewCount) || (is_array($articleTotalViewCount) && empty($articleTotalViewCount))) {
            unset($this->ArticleTotalViewCount);
        } else {
            $this->ArticleTotalViewCount = $articleTotalViewCount;
        }
        return $this;
    }
    /**
     * Get AssignedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getAssignedBy()
    {
        return isset($this->AssignedBy) ? $this->AssignedBy : null;
    }
    /**
     * Set AssignedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $assignedBy
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setAssignedBy(\NexusDigital/MiratelForce\StructType\User $assignedBy = null)
    {
        if (is_null($assignedBy) || (is_array($assignedBy) && empty($assignedBy))) {
            unset($this->AssignedBy);
        } else {
            $this->AssignedBy = $assignedBy;
        }
        return $this;
    }
    /**
     * Get AssignedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignedById()
    {
        return isset($this->AssignedById) ? $this->AssignedById : null;
    }
    /**
     * Set AssignedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignedById
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setAssignedById($assignedById = null)
    {
        // validation for constraint: string
        if (!is_null($assignedById) && !is_string($assignedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignedById, true), gettype($assignedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($assignedById) && mb_strlen($assignedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($assignedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($assignedById) && !preg_match('/[a-zA-Z0-9]{18}/', $assignedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($assignedById, true)), __LINE__);
        }
        if (is_null($assignedById) || (is_array($assignedById) && empty($assignedById))) {
            unset($this->AssignedById);
        } else {
            $this->AssignedById = $assignedById;
        }
        return $this;
    }
    /**
     * Get AssignedTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getAssignedTo()
    {
        return isset($this->AssignedTo) ? $this->AssignedTo : null;
    }
    /**
     * Set AssignedTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $assignedTo
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setAssignedTo(\NexusDigital/MiratelForce\StructType\SObject $assignedTo = null)
    {
        if (is_null($assignedTo) || (is_array($assignedTo) && empty($assignedTo))) {
            unset($this->AssignedTo);
        } else {
            $this->AssignedTo = $assignedTo;
        }
        return $this;
    }
    /**
     * Get AssignedToId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignedToId()
    {
        return isset($this->AssignedToId) ? $this->AssignedToId : null;
    }
    /**
     * Set AssignedToId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignedToId
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setAssignedToId($assignedToId = null)
    {
        // validation for constraint: string
        if (!is_null($assignedToId) && !is_string($assignedToId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignedToId, true), gettype($assignedToId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($assignedToId) && mb_strlen($assignedToId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($assignedToId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($assignedToId) && !preg_match('/[a-zA-Z0-9]{18}/', $assignedToId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($assignedToId, true)), __LINE__);
        }
        if (is_null($assignedToId) || (is_array($assignedToId) && empty($assignedToId))) {
            unset($this->AssignedToId);
        } else {
            $this->AssignedToId = $assignedToId;
        }
        return $this;
    }
    /**
     * Get AssignmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignmentDate()
    {
        return isset($this->AssignmentDate) ? $this->AssignmentDate : null;
    }
    /**
     * Set AssignmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignmentDate
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setAssignmentDate($assignmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($assignmentDate) && !is_string($assignmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignmentDate, true), gettype($assignmentDate)), __LINE__);
        }
        if (is_null($assignmentDate) || (is_array($assignmentDate) && empty($assignmentDate))) {
            unset($this->AssignmentDate);
        } else {
            $this->AssignmentDate = $assignmentDate;
        }
        return $this;
    }
    /**
     * Get AssignmentDueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignmentDueDate()
    {
        return isset($this->AssignmentDueDate) ? $this->AssignmentDueDate : null;
    }
    /**
     * Set AssignmentDueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignmentDueDate
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setAssignmentDueDate($assignmentDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($assignmentDueDate) && !is_string($assignmentDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignmentDueDate, true), gettype($assignmentDueDate)), __LINE__);
        }
        if (is_null($assignmentDueDate) || (is_array($assignmentDueDate) && empty($assignmentDueDate))) {
            unset($this->AssignmentDueDate);
        } else {
            $this->AssignmentDueDate = $assignmentDueDate;
        }
        return $this;
    }
    /**
     * Get AssignmentNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignmentNote()
    {
        return isset($this->AssignmentNote) ? $this->AssignmentNote : null;
    }
    /**
     * Set AssignmentNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignmentNote
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setAssignmentNote($assignmentNote = null)
    {
        // validation for constraint: string
        if (!is_null($assignmentNote) && !is_string($assignmentNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignmentNote, true), gettype($assignmentNote)), __LINE__);
        }
        if (is_null($assignmentNote) || (is_array($assignmentNote) && empty($assignmentNote))) {
            unset($this->AssignmentNote);
        } else {
            $this->AssignmentNote = $assignmentNote;
        }
        return $this;
    }
    /**
     * Get AttachedContentDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentDocuments()
    {
        return isset($this->AttachedContentDocuments) ? $this->AttachedContentDocuments : null;
    }
    /**
     * Set AttachedContentDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setAttachedContentDocuments(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null)
    {
        if (is_null($attachedContentDocuments) || (is_array($attachedContentDocuments) && empty($attachedContentDocuments))) {
            unset($this->AttachedContentDocuments);
        } else {
            $this->AttachedContentDocuments = $attachedContentDocuments;
        }
        return $this;
    }
    /**
     * Get AttachedContentNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentNotes()
    {
        return isset($this->AttachedContentNotes) ? $this->AttachedContentNotes : null;
    }
    /**
     * Set AttachedContentNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setAttachedContentNotes(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null)
    {
        if (is_null($attachedContentNotes) || (is_array($attachedContentNotes) && empty($attachedContentNotes))) {
            unset($this->AttachedContentNotes);
        } else {
            $this->AttachedContentNotes = $attachedContentNotes;
        }
        return $this;
    }
    /**
     * Get CaseArticles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCaseArticles()
    {
        return isset($this->CaseArticles) ? $this->CaseArticles : null;
    }
    /**
     * Set CaseArticles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $caseArticles
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setCaseArticles(\NexusDigital/MiratelForce\StructType\QueryResult $caseArticles = null)
    {
        if (is_null($caseArticles) || (is_array($caseArticles) && empty($caseArticles))) {
            unset($this->CaseArticles);
        } else {
            $this->CaseArticles = $caseArticles;
        }
        return $this;
    }
    /**
     * Get CombinedAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCombinedAttachments()
    {
        return isset($this->CombinedAttachments) ? $this->CombinedAttachments : null;
    }
    /**
     * Set CombinedAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setCombinedAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null)
    {
        if (is_null($combinedAttachments) || (is_array($combinedAttachments) && empty($combinedAttachments))) {
            unset($this->CombinedAttachments);
        } else {
            $this->CombinedAttachments = $combinedAttachments;
        }
        return $this;
    }
    /**
     * Get ContentDocumentLinks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContentDocumentLinks()
    {
        return isset($this->ContentDocumentLinks) ? $this->ContentDocumentLinks : null;
    }
    /**
     * Set ContentDocumentLinks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setContentDocumentLinks(\NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null)
    {
        if (is_null($contentDocumentLinks) || (is_array($contentDocumentLinks) && empty($contentDocumentLinks))) {
            unset($this->ContentDocumentLinks);
        } else {
            $this->ContentDocumentLinks = $contentDocumentLinks;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get FirstPublishedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstPublishedDate()
    {
        return isset($this->FirstPublishedDate) ? $this->FirstPublishedDate : null;
    }
    /**
     * Set FirstPublishedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstPublishedDate
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setFirstPublishedDate($firstPublishedDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstPublishedDate) && !is_string($firstPublishedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstPublishedDate, true), gettype($firstPublishedDate)), __LINE__);
        }
        if (is_null($firstPublishedDate) || (is_array($firstPublishedDate) && empty($firstPublishedDate))) {
            unset($this->FirstPublishedDate);
        } else {
            $this->FirstPublishedDate = $firstPublishedDate;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsLatestVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsLatestVersion()
    {
        return isset($this->IsLatestVersion) ? $this->IsLatestVersion : null;
    }
    /**
     * Set IsLatestVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isLatestVersion
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setIsLatestVersion($isLatestVersion = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLatestVersion) && !is_bool($isLatestVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLatestVersion, true), gettype($isLatestVersion)), __LINE__);
        }
        if (is_null($isLatestVersion) || (is_array($isLatestVersion) && empty($isLatestVersion))) {
            unset($this->IsLatestVersion);
        } else {
            $this->IsLatestVersion = $isLatestVersion;
        }
        return $this;
    }
    /**
     * Get IsVisibleInApp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVisibleInApp()
    {
        return isset($this->IsVisibleInApp) ? $this->IsVisibleInApp : null;
    }
    /**
     * Set IsVisibleInApp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVisibleInApp
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setIsVisibleInApp($isVisibleInApp = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVisibleInApp) && !is_bool($isVisibleInApp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVisibleInApp, true), gettype($isVisibleInApp)), __LINE__);
        }
        if (is_null($isVisibleInApp) || (is_array($isVisibleInApp) && empty($isVisibleInApp))) {
            unset($this->IsVisibleInApp);
        } else {
            $this->IsVisibleInApp = $isVisibleInApp;
        }
        return $this;
    }
    /**
     * Get IsVisibleInCsp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVisibleInCsp()
    {
        return isset($this->IsVisibleInCsp) ? $this->IsVisibleInCsp : null;
    }
    /**
     * Set IsVisibleInCsp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVisibleInCsp
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setIsVisibleInCsp($isVisibleInCsp = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVisibleInCsp) && !is_bool($isVisibleInCsp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVisibleInCsp, true), gettype($isVisibleInCsp)), __LINE__);
        }
        if (is_null($isVisibleInCsp) || (is_array($isVisibleInCsp) && empty($isVisibleInCsp))) {
            unset($this->IsVisibleInCsp);
        } else {
            $this->IsVisibleInCsp = $isVisibleInCsp;
        }
        return $this;
    }
    /**
     * Get IsVisibleInPkb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVisibleInPkb()
    {
        return isset($this->IsVisibleInPkb) ? $this->IsVisibleInPkb : null;
    }
    /**
     * Set IsVisibleInPkb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVisibleInPkb
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setIsVisibleInPkb($isVisibleInPkb = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVisibleInPkb) && !is_bool($isVisibleInPkb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVisibleInPkb, true), gettype($isVisibleInPkb)), __LINE__);
        }
        if (is_null($isVisibleInPkb) || (is_array($isVisibleInPkb) && empty($isVisibleInPkb))) {
            unset($this->IsVisibleInPkb);
        } else {
            $this->IsVisibleInPkb = $isVisibleInPkb;
        }
        return $this;
    }
    /**
     * Get IsVisibleInPrm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVisibleInPrm()
    {
        return isset($this->IsVisibleInPrm) ? $this->IsVisibleInPrm : null;
    }
    /**
     * Set IsVisibleInPrm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVisibleInPrm
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setIsVisibleInPrm($isVisibleInPrm = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVisibleInPrm) && !is_bool($isVisibleInPrm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVisibleInPrm, true), gettype($isVisibleInPrm)), __LINE__);
        }
        if (is_null($isVisibleInPrm) || (is_array($isVisibleInPrm) && empty($isVisibleInPrm))) {
            unset($this->IsVisibleInPrm);
        } else {
            $this->IsVisibleInPrm = $isVisibleInPrm;
        }
        return $this;
    }
    /**
     * Get KnowledgeArticleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKnowledgeArticleId()
    {
        return isset($this->KnowledgeArticleId) ? $this->KnowledgeArticleId : null;
    }
    /**
     * Set KnowledgeArticleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $knowledgeArticleId
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setKnowledgeArticleId($knowledgeArticleId = null)
    {
        // validation for constraint: string
        if (!is_null($knowledgeArticleId) && !is_string($knowledgeArticleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($knowledgeArticleId, true), gettype($knowledgeArticleId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($knowledgeArticleId) && mb_strlen($knowledgeArticleId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($knowledgeArticleId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($knowledgeArticleId) && !preg_match('/[a-zA-Z0-9]{18}/', $knowledgeArticleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($knowledgeArticleId, true)), __LINE__);
        }
        if (is_null($knowledgeArticleId) || (is_array($knowledgeArticleId) && empty($knowledgeArticleId))) {
            unset($this->KnowledgeArticleId);
        } else {
            $this->KnowledgeArticleId = $knowledgeArticleId;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LastPublishedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastPublishedDate()
    {
        return isset($this->LastPublishedDate) ? $this->LastPublishedDate : null;
    }
    /**
     * Set LastPublishedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastPublishedDate
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setLastPublishedDate($lastPublishedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastPublishedDate) && !is_string($lastPublishedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastPublishedDate, true), gettype($lastPublishedDate)), __LINE__);
        }
        if (is_null($lastPublishedDate) || (is_array($lastPublishedDate) && empty($lastPublishedDate))) {
            unset($this->LastPublishedDate);
        } else {
            $this->LastPublishedDate = $lastPublishedDate;
        }
        return $this;
    }
    /**
     * Get LinkedArticles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getLinkedArticles()
    {
        return isset($this->LinkedArticles) ? $this->LinkedArticles : null;
    }
    /**
     * Set LinkedArticles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $linkedArticles
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setLinkedArticles(\NexusDigital/MiratelForce\StructType\QueryResult $linkedArticles = null)
    {
        if (is_null($linkedArticles) || (is_array($linkedArticles) && empty($linkedArticles))) {
            unset($this->LinkedArticles);
        } else {
            $this->LinkedArticles = $linkedArticles;
        }
        return $this;
    }
    /**
     * Get MigratedToFromArticleVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMigratedToFromArticleVersion()
    {
        return isset($this->MigratedToFromArticleVersion) ? $this->MigratedToFromArticleVersion : null;
    }
    /**
     * Set MigratedToFromArticleVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $migratedToFromArticleVersion
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setMigratedToFromArticleVersion($migratedToFromArticleVersion = null)
    {
        // validation for constraint: string
        if (!is_null($migratedToFromArticleVersion) && !is_string($migratedToFromArticleVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($migratedToFromArticleVersion, true), gettype($migratedToFromArticleVersion)), __LINE__);
        }
        if (is_null($migratedToFromArticleVersion) || (is_array($migratedToFromArticleVersion) && empty($migratedToFromArticleVersion))) {
            unset($this->MigratedToFromArticleVersion);
        } else {
            $this->MigratedToFromArticleVersion = $migratedToFromArticleVersion;
        }
        return $this;
    }
    /**
     * Get NetworkUserHistoryRecentToRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNetworkUserHistoryRecentToRecord()
    {
        return isset($this->NetworkUserHistoryRecentToRecord) ? $this->NetworkUserHistoryRecentToRecord : null;
    }
    /**
     * Set NetworkUserHistoryRecentToRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkUserHistoryRecentToRecord
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setNetworkUserHistoryRecentToRecord(\NexusDigital/MiratelForce\StructType\QueryResult $networkUserHistoryRecentToRecord = null)
    {
        if (is_null($networkUserHistoryRecentToRecord) || (is_array($networkUserHistoryRecentToRecord) && empty($networkUserHistoryRecentToRecord))) {
            unset($this->NetworkUserHistoryRecentToRecord);
        } else {
            $this->NetworkUserHistoryRecentToRecord = $networkUserHistoryRecentToRecord;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $owner
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setOwner(\NexusDigital/MiratelForce\StructType\SObject $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ownerId) && mb_strlen($ownerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ownerId) && !preg_match('/[a-zA-Z0-9]{18}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get ProcessInstances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessInstances()
    {
        return isset($this->ProcessInstances) ? $this->ProcessInstances : null;
    }
    /**
     * Set ProcessInstances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setProcessInstances(\NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null)
    {
        if (is_null($processInstances) || (is_array($processInstances) && empty($processInstances))) {
            unset($this->ProcessInstances);
        } else {
            $this->ProcessInstances = $processInstances;
        }
        return $this;
    }
    /**
     * Get ProcessSteps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessSteps()
    {
        return isset($this->ProcessSteps) ? $this->ProcessSteps : null;
    }
    /**
     * Set ProcessSteps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setProcessSteps(\NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null)
    {
        if (is_null($processSteps) || (is_array($processSteps) && empty($processSteps))) {
            unset($this->ProcessSteps);
        } else {
            $this->ProcessSteps = $processSteps;
        }
        return $this;
    }
    /**
     * Get PublishStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPublishStatus()
    {
        return isset($this->PublishStatus) ? $this->PublishStatus : null;
    }
    /**
     * Set PublishStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $publishStatus
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setPublishStatus($publishStatus = null)
    {
        // validation for constraint: string
        if (!is_null($publishStatus) && !is_string($publishStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publishStatus, true), gettype($publishStatus)), __LINE__);
        }
        if (is_null($publishStatus) || (is_array($publishStatus) && empty($publishStatus))) {
            unset($this->PublishStatus);
        } else {
            $this->PublishStatus = $publishStatus;
        }
        return $this;
    }
    /**
     * Get SearchPromotionRules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getSearchPromotionRules()
    {
        return isset($this->SearchPromotionRules) ? $this->SearchPromotionRules : null;
    }
    /**
     * Set SearchPromotionRules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $searchPromotionRules
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setSearchPromotionRules(\NexusDigital/MiratelForce\StructType\QueryResult $searchPromotionRules = null)
    {
        if (is_null($searchPromotionRules) || (is_array($searchPromotionRules) && empty($searchPromotionRules))) {
            unset($this->SearchPromotionRules);
        } else {
            $this->SearchPromotionRules = $searchPromotionRules;
        }
        return $this;
    }
    /**
     * Get SourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceId()
    {
        return isset($this->SourceId) ? $this->SourceId : null;
    }
    /**
     * Set SourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceId
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($sourceId) && mb_strlen($sourceId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($sourceId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($sourceId) && !preg_match('/[a-zA-Z0-9]{18}/', $sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($sourceId, true)), __LINE__);
        }
        if (is_null($sourceId) || (is_array($sourceId) && empty($sourceId))) {
            unset($this->SourceId);
        } else {
            $this->SourceId = $sourceId;
        }
        return $this;
    }
    /**
     * Get Summary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSummary()
    {
        return isset($this->Summary) ? $this->Summary : null;
    }
    /**
     * Set Summary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $summary
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setSummary($summary = null)
    {
        // validation for constraint: string
        if (!is_null($summary) && !is_string($summary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($summary, true), gettype($summary)), __LINE__);
        }
        if (is_null($summary) || (is_array($summary) && empty($summary))) {
            unset($this->Summary);
        } else {
            $this->Summary = $summary;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get TopicAssignments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTopicAssignments()
    {
        return isset($this->TopicAssignments) ? $this->TopicAssignments : null;
    }
    /**
     * Set TopicAssignments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setTopicAssignments(\NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments = null)
    {
        if (is_null($topicAssignments) || (is_array($topicAssignments) && empty($topicAssignments))) {
            unset($this->TopicAssignments);
        } else {
            $this->TopicAssignments = $topicAssignments;
        }
        return $this;
    }
    /**
     * Get UrlName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrlName()
    {
        return isset($this->UrlName) ? $this->UrlName : null;
    }
    /**
     * Set UrlName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $urlName
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setUrlName($urlName = null)
    {
        // validation for constraint: string
        if (!is_null($urlName) && !is_string($urlName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlName, true), gettype($urlName)), __LINE__);
        }
        if (is_null($urlName) || (is_array($urlName) && empty($urlName))) {
            unset($this->UrlName);
        } else {
            $this->UrlName = $urlName;
        }
        return $this;
    }
    /**
     * Get ValidationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidationStatus()
    {
        return isset($this->ValidationStatus) ? $this->ValidationStatus : null;
    }
    /**
     * Set ValidationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validationStatus
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setValidationStatus($validationStatus = null)
    {
        // validation for constraint: string
        if (!is_null($validationStatus) && !is_string($validationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validationStatus, true), gettype($validationStatus)), __LINE__);
        }
        if (is_null($validationStatus) || (is_array($validationStatus) && empty($validationStatus))) {
            unset($this->ValidationStatus);
        } else {
            $this->ValidationStatus = $validationStatus;
        }
        return $this;
    }
    /**
     * Get VersionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVersionNumber()
    {
        return isset($this->VersionNumber) ? $this->VersionNumber : null;
    }
    /**
     * Set VersionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $versionNumber
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public function setVersionNumber($versionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($versionNumber) && !(is_int($versionNumber) || ctype_digit($versionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($versionNumber, true), gettype($versionNumber)), __LINE__);
        }
        if (is_null($versionNumber) || (is_array($versionNumber) && empty($versionNumber))) {
            unset($this->VersionNumber);
        } else {
            $this->VersionNumber = $versionNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleVersion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
