<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdpEventLog StructType
 * @subpackage Structs
 */
class IdpEventLog extends SObject
{
    /**
     * The AppId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AppId;
    /**
     * The AuthSessionId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AuthSessionId;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorCode;
    /**
     * The IdentityUsed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentityUsed;
    /**
     * The InitiatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InitiatedBy;
    /**
     * The OptionsHasLogoutUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsHasLogoutUrl;
    /**
     * The SamlEntityUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SamlEntityUrl;
    /**
     * The SsoType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SsoType;
    /**
     * The Timestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Timestamp;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for IdpEventLog
     * @uses IdpEventLog::setAppId()
     * @uses IdpEventLog::setAuthSessionId()
     * @uses IdpEventLog::setErrorCode()
     * @uses IdpEventLog::setIdentityUsed()
     * @uses IdpEventLog::setInitiatedBy()
     * @uses IdpEventLog::setOptionsHasLogoutUrl()
     * @uses IdpEventLog::setSamlEntityUrl()
     * @uses IdpEventLog::setSsoType()
     * @uses IdpEventLog::setTimestamp()
     * @uses IdpEventLog::setUserId()
     * @param string $appId
     * @param string $authSessionId
     * @param string $errorCode
     * @param string $identityUsed
     * @param string $initiatedBy
     * @param bool $optionsHasLogoutUrl
     * @param string $samlEntityUrl
     * @param string $ssoType
     * @param string $timestamp
     * @param string $userId
     */
    public function __construct($appId = null, $authSessionId = null, $errorCode = null, $identityUsed = null, $initiatedBy = null, $optionsHasLogoutUrl = null, $samlEntityUrl = null, $ssoType = null, $timestamp = null, $userId = null)
    {
        $this
            ->setAppId($appId)
            ->setAuthSessionId($authSessionId)
            ->setErrorCode($errorCode)
            ->setIdentityUsed($identityUsed)
            ->setInitiatedBy($initiatedBy)
            ->setOptionsHasLogoutUrl($optionsHasLogoutUrl)
            ->setSamlEntityUrl($samlEntityUrl)
            ->setSsoType($ssoType)
            ->setTimestamp($timestamp)
            ->setUserId($userId);
    }
    /**
     * Get AppId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppId()
    {
        return isset($this->AppId) ? $this->AppId : null;
    }
    /**
     * Set AppId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appId
     * @return \NexusDigital/MiratelForce\StructType\IdpEventLog
     */
    public function setAppId($appId = null)
    {
        // validation for constraint: string
        if (!is_null($appId) && !is_string($appId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appId, true), gettype($appId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($appId) && mb_strlen($appId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($appId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($appId) && !preg_match('/[a-zA-Z0-9]{18}/', $appId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($appId, true)), __LINE__);
        }
        if (is_null($appId) || (is_array($appId) && empty($appId))) {
            unset($this->AppId);
        } else {
            $this->AppId = $appId;
        }
        return $this;
    }
    /**
     * Get AuthSessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthSessionId()
    {
        return isset($this->AuthSessionId) ? $this->AuthSessionId : null;
    }
    /**
     * Set AuthSessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authSessionId
     * @return \NexusDigital/MiratelForce\StructType\IdpEventLog
     */
    public function setAuthSessionId($authSessionId = null)
    {
        // validation for constraint: string
        if (!is_null($authSessionId) && !is_string($authSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authSessionId, true), gettype($authSessionId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($authSessionId) && mb_strlen($authSessionId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($authSessionId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($authSessionId) && !preg_match('/[a-zA-Z0-9]{18}/', $authSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($authSessionId, true)), __LINE__);
        }
        if (is_null($authSessionId) || (is_array($authSessionId) && empty($authSessionId))) {
            unset($this->AuthSessionId);
        } else {
            $this->AuthSessionId = $authSessionId;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorCode()
    {
        return isset($this->ErrorCode) ? $this->ErrorCode : null;
    }
    /**
     * Set ErrorCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorCode
     * @return \NexusDigital/MiratelForce\StructType\IdpEventLog
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        if (is_null($errorCode) || (is_array($errorCode) && empty($errorCode))) {
            unset($this->ErrorCode);
        } else {
            $this->ErrorCode = $errorCode;
        }
        return $this;
    }
    /**
     * Get IdentityUsed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentityUsed()
    {
        return isset($this->IdentityUsed) ? $this->IdentityUsed : null;
    }
    /**
     * Set IdentityUsed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identityUsed
     * @return \NexusDigital/MiratelForce\StructType\IdpEventLog
     */
    public function setIdentityUsed($identityUsed = null)
    {
        // validation for constraint: string
        if (!is_null($identityUsed) && !is_string($identityUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identityUsed, true), gettype($identityUsed)), __LINE__);
        }
        if (is_null($identityUsed) || (is_array($identityUsed) && empty($identityUsed))) {
            unset($this->IdentityUsed);
        } else {
            $this->IdentityUsed = $identityUsed;
        }
        return $this;
    }
    /**
     * Get InitiatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInitiatedBy()
    {
        return isset($this->InitiatedBy) ? $this->InitiatedBy : null;
    }
    /**
     * Set InitiatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $initiatedBy
     * @return \NexusDigital/MiratelForce\StructType\IdpEventLog
     */
    public function setInitiatedBy($initiatedBy = null)
    {
        // validation for constraint: string
        if (!is_null($initiatedBy) && !is_string($initiatedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initiatedBy, true), gettype($initiatedBy)), __LINE__);
        }
        if (is_null($initiatedBy) || (is_array($initiatedBy) && empty($initiatedBy))) {
            unset($this->InitiatedBy);
        } else {
            $this->InitiatedBy = $initiatedBy;
        }
        return $this;
    }
    /**
     * Get OptionsHasLogoutUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsHasLogoutUrl()
    {
        return isset($this->OptionsHasLogoutUrl) ? $this->OptionsHasLogoutUrl : null;
    }
    /**
     * Set OptionsHasLogoutUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsHasLogoutUrl
     * @return \NexusDigital/MiratelForce\StructType\IdpEventLog
     */
    public function setOptionsHasLogoutUrl($optionsHasLogoutUrl = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsHasLogoutUrl) && !is_bool($optionsHasLogoutUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsHasLogoutUrl, true), gettype($optionsHasLogoutUrl)), __LINE__);
        }
        if (is_null($optionsHasLogoutUrl) || (is_array($optionsHasLogoutUrl) && empty($optionsHasLogoutUrl))) {
            unset($this->OptionsHasLogoutUrl);
        } else {
            $this->OptionsHasLogoutUrl = $optionsHasLogoutUrl;
        }
        return $this;
    }
    /**
     * Get SamlEntityUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSamlEntityUrl()
    {
        return isset($this->SamlEntityUrl) ? $this->SamlEntityUrl : null;
    }
    /**
     * Set SamlEntityUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $samlEntityUrl
     * @return \NexusDigital/MiratelForce\StructType\IdpEventLog
     */
    public function setSamlEntityUrl($samlEntityUrl = null)
    {
        // validation for constraint: string
        if (!is_null($samlEntityUrl) && !is_string($samlEntityUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($samlEntityUrl, true), gettype($samlEntityUrl)), __LINE__);
        }
        if (is_null($samlEntityUrl) || (is_array($samlEntityUrl) && empty($samlEntityUrl))) {
            unset($this->SamlEntityUrl);
        } else {
            $this->SamlEntityUrl = $samlEntityUrl;
        }
        return $this;
    }
    /**
     * Get SsoType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSsoType()
    {
        return isset($this->SsoType) ? $this->SsoType : null;
    }
    /**
     * Set SsoType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ssoType
     * @return \NexusDigital/MiratelForce\StructType\IdpEventLog
     */
    public function setSsoType($ssoType = null)
    {
        // validation for constraint: string
        if (!is_null($ssoType) && !is_string($ssoType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ssoType, true), gettype($ssoType)), __LINE__);
        }
        if (is_null($ssoType) || (is_array($ssoType) && empty($ssoType))) {
            unset($this->SsoType);
        } else {
            $this->SsoType = $ssoType;
        }
        return $this;
    }
    /**
     * Get Timestamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimestamp()
    {
        return isset($this->Timestamp) ? $this->Timestamp : null;
    }
    /**
     * Set Timestamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timestamp
     * @return \NexusDigital/MiratelForce\StructType\IdpEventLog
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        if (is_null($timestamp) || (is_array($timestamp) && empty($timestamp))) {
            unset($this->Timestamp);
        } else {
            $this->Timestamp = $timestamp;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \NexusDigital/MiratelForce\StructType\IdpEventLog
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userId) && mb_strlen($userId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userId) && !preg_match('/[a-zA-Z0-9]{18}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\IdpEventLog
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
