<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Idea StructType
 * @subpackage Structs
 */
class Idea extends SObject
{
    /**
     * The Body
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Body;
    /**
     * The Categories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Categories;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Comments;
    /**
     * The Community
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Community
     */
    public $Community;
    /**
     * The CommunityId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CommunityId;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The CreatorFullPhotoUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatorFullPhotoUrl;
    /**
     * The CreatorName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatorName;
    /**
     * The CreatorSmallPhotoUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatorSmallPhotoUrl;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsHtml
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHtml;
    /**
     * The IsMerged
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMerged;
    /**
     * The LastComment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public $LastComment;
    /**
     * The LastCommentDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastCommentDate;
    /**
     * The LastCommentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastCommentId;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastReferencedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastReferencedDate;
    /**
     * The LastViewedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastViewedDate;
    /**
     * The NumComments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumComments;
    /**
     * The ParentIdea
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Idea
     */
    public $ParentIdea;
    /**
     * The ParentIdeaId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentIdeaId;
    /**
     * The RecordType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\RecordType
     */
    public $RecordType;
    /**
     * The RecordTypeId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $RecordTypeId;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The UserRecordAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public $UserRecordAccess;
    /**
     * The VoteScore
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $VoteScore;
    /**
     * The VoteTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $VoteTotal;
    /**
     * The Votes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Votes;
    /**
     * Constructor method for Idea
     * @uses Idea::setBody()
     * @uses Idea::setCategories()
     * @uses Idea::setComments()
     * @uses Idea::setCommunity()
     * @uses Idea::setCommunityId()
     * @uses Idea::setCreatedBy()
     * @uses Idea::setCreatedById()
     * @uses Idea::setCreatedDate()
     * @uses Idea::setCreatorFullPhotoUrl()
     * @uses Idea::setCreatorName()
     * @uses Idea::setCreatorSmallPhotoUrl()
     * @uses Idea::setIsDeleted()
     * @uses Idea::setIsHtml()
     * @uses Idea::setIsMerged()
     * @uses Idea::setLastComment()
     * @uses Idea::setLastCommentDate()
     * @uses Idea::setLastCommentId()
     * @uses Idea::setLastModifiedBy()
     * @uses Idea::setLastModifiedById()
     * @uses Idea::setLastModifiedDate()
     * @uses Idea::setLastReferencedDate()
     * @uses Idea::setLastViewedDate()
     * @uses Idea::setNumComments()
     * @uses Idea::setParentIdea()
     * @uses Idea::setParentIdeaId()
     * @uses Idea::setRecordType()
     * @uses Idea::setRecordTypeId()
     * @uses Idea::setStatus()
     * @uses Idea::setSystemModstamp()
     * @uses Idea::setTitle()
     * @uses Idea::setUserRecordAccess()
     * @uses Idea::setVoteScore()
     * @uses Idea::setVoteTotal()
     * @uses Idea::setVotes()
     * @param string $body
     * @param string $categories
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $comments
     * @param \NexusDigital/MiratelForce\StructType\Community $community
     * @param string $communityId
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $creatorFullPhotoUrl
     * @param string $creatorName
     * @param string $creatorSmallPhotoUrl
     * @param bool $isDeleted
     * @param bool $isHtml
     * @param bool $isMerged
     * @param \NexusDigital/MiratelForce\StructType\IdeaComment $lastComment
     * @param string $lastCommentDate
     * @param string $lastCommentId
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $lastReferencedDate
     * @param string $lastViewedDate
     * @param int $numComments
     * @param \NexusDigital/MiratelForce\StructType\Idea $parentIdea
     * @param string $parentIdeaId
     * @param \NexusDigital/MiratelForce\StructType\RecordType $recordType
     * @param string $recordTypeId
     * @param string $status
     * @param string $systemModstamp
     * @param string $title
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @param float $voteScore
     * @param float $voteTotal
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $votes
     */
    public function __construct($body = null, $categories = null, \NexusDigital/MiratelForce\StructType\QueryResult $comments = null, \NexusDigital/MiratelForce\StructType\Community $community = null, $communityId = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $creatorFullPhotoUrl = null, $creatorName = null, $creatorSmallPhotoUrl = null, $isDeleted = null, $isHtml = null, $isMerged = null, \NexusDigital/MiratelForce\StructType\IdeaComment $lastComment = null, $lastCommentDate = null, $lastCommentId = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lastReferencedDate = null, $lastViewedDate = null, $numComments = null, \NexusDigital/MiratelForce\StructType\Idea $parentIdea = null, $parentIdeaId = null, \NexusDigital/MiratelForce\StructType\RecordType $recordType = null, $recordTypeId = null, $status = null, $systemModstamp = null, $title = null, \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null, $voteScore = null, $voteTotal = null, \NexusDigital/MiratelForce\StructType\QueryResult $votes = null)
    {
        $this
            ->setBody($body)
            ->setCategories($categories)
            ->setComments($comments)
            ->setCommunity($community)
            ->setCommunityId($communityId)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setCreatorFullPhotoUrl($creatorFullPhotoUrl)
            ->setCreatorName($creatorName)
            ->setCreatorSmallPhotoUrl($creatorSmallPhotoUrl)
            ->setIsDeleted($isDeleted)
            ->setIsHtml($isHtml)
            ->setIsMerged($isMerged)
            ->setLastComment($lastComment)
            ->setLastCommentDate($lastCommentDate)
            ->setLastCommentId($lastCommentId)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastReferencedDate($lastReferencedDate)
            ->setLastViewedDate($lastViewedDate)
            ->setNumComments($numComments)
            ->setParentIdea($parentIdea)
            ->setParentIdeaId($parentIdeaId)
            ->setRecordType($recordType)
            ->setRecordTypeId($recordTypeId)
            ->setStatus($status)
            ->setSystemModstamp($systemModstamp)
            ->setTitle($title)
            ->setUserRecordAccess($userRecordAccess)
            ->setVoteScore($voteScore)
            ->setVoteTotal($voteTotal)
            ->setVotes($votes);
    }
    /**
     * Get Body value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBody()
    {
        return isset($this->Body) ? $this->Body : null;
    }
    /**
     * Set Body value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $body
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setBody($body = null)
    {
        // validation for constraint: string
        if (!is_null($body) && !is_string($body)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($body, true), gettype($body)), __LINE__);
        }
        if (is_null($body) || (is_array($body) && empty($body))) {
            unset($this->Body);
        } else {
            $this->Body = $body;
        }
        return $this;
    }
    /**
     * Get Categories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategories()
    {
        return isset($this->Categories) ? $this->Categories : null;
    }
    /**
     * Set Categories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categories
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setCategories($categories = null)
    {
        // validation for constraint: string
        if (!is_null($categories) && !is_string($categories)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categories, true), gettype($categories)), __LINE__);
        }
        if (is_null($categories) || (is_array($categories) && empty($categories))) {
            unset($this->Categories);
        } else {
            $this->Categories = $categories;
        }
        return $this;
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $comments
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setComments(\NexusDigital/MiratelForce\StructType\QueryResult $comments = null)
    {
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
    /**
     * Get Community value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Community|null
     */
    public function getCommunity()
    {
        return isset($this->Community) ? $this->Community : null;
    }
    /**
     * Set Community value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Community $community
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setCommunity(\NexusDigital/MiratelForce\StructType\Community $community = null)
    {
        if (is_null($community) || (is_array($community) && empty($community))) {
            unset($this->Community);
        } else {
            $this->Community = $community;
        }
        return $this;
    }
    /**
     * Get CommunityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommunityId()
    {
        return isset($this->CommunityId) ? $this->CommunityId : null;
    }
    /**
     * Set CommunityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communityId
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setCommunityId($communityId = null)
    {
        // validation for constraint: string
        if (!is_null($communityId) && !is_string($communityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communityId, true), gettype($communityId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($communityId) && mb_strlen($communityId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($communityId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($communityId) && !preg_match('/[a-zA-Z0-9]{18}/', $communityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($communityId, true)), __LINE__);
        }
        if (is_null($communityId) || (is_array($communityId) && empty($communityId))) {
            unset($this->CommunityId);
        } else {
            $this->CommunityId = $communityId;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get CreatorFullPhotoUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatorFullPhotoUrl()
    {
        return isset($this->CreatorFullPhotoUrl) ? $this->CreatorFullPhotoUrl : null;
    }
    /**
     * Set CreatorFullPhotoUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creatorFullPhotoUrl
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setCreatorFullPhotoUrl($creatorFullPhotoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($creatorFullPhotoUrl) && !is_string($creatorFullPhotoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorFullPhotoUrl, true), gettype($creatorFullPhotoUrl)), __LINE__);
        }
        if (is_null($creatorFullPhotoUrl) || (is_array($creatorFullPhotoUrl) && empty($creatorFullPhotoUrl))) {
            unset($this->CreatorFullPhotoUrl);
        } else {
            $this->CreatorFullPhotoUrl = $creatorFullPhotoUrl;
        }
        return $this;
    }
    /**
     * Get CreatorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatorName()
    {
        return isset($this->CreatorName) ? $this->CreatorName : null;
    }
    /**
     * Set CreatorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creatorName
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setCreatorName($creatorName = null)
    {
        // validation for constraint: string
        if (!is_null($creatorName) && !is_string($creatorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorName, true), gettype($creatorName)), __LINE__);
        }
        if (is_null($creatorName) || (is_array($creatorName) && empty($creatorName))) {
            unset($this->CreatorName);
        } else {
            $this->CreatorName = $creatorName;
        }
        return $this;
    }
    /**
     * Get CreatorSmallPhotoUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatorSmallPhotoUrl()
    {
        return isset($this->CreatorSmallPhotoUrl) ? $this->CreatorSmallPhotoUrl : null;
    }
    /**
     * Set CreatorSmallPhotoUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creatorSmallPhotoUrl
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setCreatorSmallPhotoUrl($creatorSmallPhotoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($creatorSmallPhotoUrl) && !is_string($creatorSmallPhotoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorSmallPhotoUrl, true), gettype($creatorSmallPhotoUrl)), __LINE__);
        }
        if (is_null($creatorSmallPhotoUrl) || (is_array($creatorSmallPhotoUrl) && empty($creatorSmallPhotoUrl))) {
            unset($this->CreatorSmallPhotoUrl);
        } else {
            $this->CreatorSmallPhotoUrl = $creatorSmallPhotoUrl;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsHtml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHtml()
    {
        return isset($this->IsHtml) ? $this->IsHtml : null;
    }
    /**
     * Set IsHtml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHtml
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setIsHtml($isHtml = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHtml) && !is_bool($isHtml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHtml, true), gettype($isHtml)), __LINE__);
        }
        if (is_null($isHtml) || (is_array($isHtml) && empty($isHtml))) {
            unset($this->IsHtml);
        } else {
            $this->IsHtml = $isHtml;
        }
        return $this;
    }
    /**
     * Get IsMerged value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMerged()
    {
        return isset($this->IsMerged) ? $this->IsMerged : null;
    }
    /**
     * Set IsMerged value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMerged
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setIsMerged($isMerged = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMerged) && !is_bool($isMerged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMerged, true), gettype($isMerged)), __LINE__);
        }
        if (is_null($isMerged) || (is_array($isMerged) && empty($isMerged))) {
            unset($this->IsMerged);
        } else {
            $this->IsMerged = $isMerged;
        }
        return $this;
    }
    /**
     * Get LastComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment|null
     */
    public function getLastComment()
    {
        return isset($this->LastComment) ? $this->LastComment : null;
    }
    /**
     * Set LastComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\IdeaComment $lastComment
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setLastComment(\NexusDigital/MiratelForce\StructType\IdeaComment $lastComment = null)
    {
        if (is_null($lastComment) || (is_array($lastComment) && empty($lastComment))) {
            unset($this->LastComment);
        } else {
            $this->LastComment = $lastComment;
        }
        return $this;
    }
    /**
     * Get LastCommentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastCommentDate()
    {
        return isset($this->LastCommentDate) ? $this->LastCommentDate : null;
    }
    /**
     * Set LastCommentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastCommentDate
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setLastCommentDate($lastCommentDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastCommentDate) && !is_string($lastCommentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastCommentDate, true), gettype($lastCommentDate)), __LINE__);
        }
        if (is_null($lastCommentDate) || (is_array($lastCommentDate) && empty($lastCommentDate))) {
            unset($this->LastCommentDate);
        } else {
            $this->LastCommentDate = $lastCommentDate;
        }
        return $this;
    }
    /**
     * Get LastCommentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastCommentId()
    {
        return isset($this->LastCommentId) ? $this->LastCommentId : null;
    }
    /**
     * Set LastCommentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastCommentId
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setLastCommentId($lastCommentId = null)
    {
        // validation for constraint: string
        if (!is_null($lastCommentId) && !is_string($lastCommentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastCommentId, true), gettype($lastCommentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastCommentId) && mb_strlen($lastCommentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastCommentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastCommentId) && !preg_match('/[a-zA-Z0-9]{18}/', $lastCommentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastCommentId, true)), __LINE__);
        }
        if (is_null($lastCommentId) || (is_array($lastCommentId) && empty($lastCommentId))) {
            unset($this->LastCommentId);
        } else {
            $this->LastCommentId = $lastCommentId;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LastReferencedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastReferencedDate()
    {
        return isset($this->LastReferencedDate) ? $this->LastReferencedDate : null;
    }
    /**
     * Set LastReferencedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastReferencedDate
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setLastReferencedDate($lastReferencedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastReferencedDate) && !is_string($lastReferencedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastReferencedDate, true), gettype($lastReferencedDate)), __LINE__);
        }
        if (is_null($lastReferencedDate) || (is_array($lastReferencedDate) && empty($lastReferencedDate))) {
            unset($this->LastReferencedDate);
        } else {
            $this->LastReferencedDate = $lastReferencedDate;
        }
        return $this;
    }
    /**
     * Get LastViewedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastViewedDate()
    {
        return isset($this->LastViewedDate) ? $this->LastViewedDate : null;
    }
    /**
     * Set LastViewedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastViewedDate
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setLastViewedDate($lastViewedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastViewedDate) && !is_string($lastViewedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastViewedDate, true), gettype($lastViewedDate)), __LINE__);
        }
        if (is_null($lastViewedDate) || (is_array($lastViewedDate) && empty($lastViewedDate))) {
            unset($this->LastViewedDate);
        } else {
            $this->LastViewedDate = $lastViewedDate;
        }
        return $this;
    }
    /**
     * Get NumComments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumComments()
    {
        return isset($this->NumComments) ? $this->NumComments : null;
    }
    /**
     * Set NumComments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numComments
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setNumComments($numComments = null)
    {
        // validation for constraint: int
        if (!is_null($numComments) && !(is_int($numComments) || ctype_digit($numComments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numComments, true), gettype($numComments)), __LINE__);
        }
        if (is_null($numComments) || (is_array($numComments) && empty($numComments))) {
            unset($this->NumComments);
        } else {
            $this->NumComments = $numComments;
        }
        return $this;
    }
    /**
     * Get ParentIdea value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Idea|null
     */
    public function getParentIdea()
    {
        return isset($this->ParentIdea) ? $this->ParentIdea : null;
    }
    /**
     * Set ParentIdea value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Idea $parentIdea
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setParentIdea(\NexusDigital/MiratelForce\StructType\Idea $parentIdea = null)
    {
        if (is_null($parentIdea) || (is_array($parentIdea) && empty($parentIdea))) {
            unset($this->ParentIdea);
        } else {
            $this->ParentIdea = $parentIdea;
        }
        return $this;
    }
    /**
     * Get ParentIdeaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentIdeaId()
    {
        return isset($this->ParentIdeaId) ? $this->ParentIdeaId : null;
    }
    /**
     * Set ParentIdeaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentIdeaId
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setParentIdeaId($parentIdeaId = null)
    {
        // validation for constraint: string
        if (!is_null($parentIdeaId) && !is_string($parentIdeaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentIdeaId, true), gettype($parentIdeaId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentIdeaId) && mb_strlen($parentIdeaId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentIdeaId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentIdeaId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentIdeaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentIdeaId, true)), __LINE__);
        }
        if (is_null($parentIdeaId) || (is_array($parentIdeaId) && empty($parentIdeaId))) {
            unset($this->ParentIdeaId);
        } else {
            $this->ParentIdeaId = $parentIdeaId;
        }
        return $this;
    }
    /**
     * Get RecordType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\RecordType|null
     */
    public function getRecordType()
    {
        return isset($this->RecordType) ? $this->RecordType : null;
    }
    /**
     * Set RecordType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\RecordType $recordType
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setRecordType(\NexusDigital/MiratelForce\StructType\RecordType $recordType = null)
    {
        if (is_null($recordType) || (is_array($recordType) && empty($recordType))) {
            unset($this->RecordType);
        } else {
            $this->RecordType = $recordType;
        }
        return $this;
    }
    /**
     * Get RecordTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordTypeId()
    {
        return isset($this->RecordTypeId) ? $this->RecordTypeId : null;
    }
    /**
     * Set RecordTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordTypeId
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setRecordTypeId($recordTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($recordTypeId) && !is_string($recordTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordTypeId, true), gettype($recordTypeId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($recordTypeId) && mb_strlen($recordTypeId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($recordTypeId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($recordTypeId) && !preg_match('/[a-zA-Z0-9]{18}/', $recordTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($recordTypeId, true)), __LINE__);
        }
        if (is_null($recordTypeId) || (is_array($recordTypeId) && empty($recordTypeId))) {
            unset($this->RecordTypeId);
        } else {
            $this->RecordTypeId = $recordTypeId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get UserRecordAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess|null
     */
    public function getUserRecordAccess()
    {
        return isset($this->UserRecordAccess) ? $this->UserRecordAccess : null;
    }
    /**
     * Set UserRecordAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setUserRecordAccess(\NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        if (is_null($userRecordAccess) || (is_array($userRecordAccess) && empty($userRecordAccess))) {
            unset($this->UserRecordAccess);
        } else {
            $this->UserRecordAccess = $userRecordAccess;
        }
        return $this;
    }
    /**
     * Get VoteScore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVoteScore()
    {
        return isset($this->VoteScore) ? $this->VoteScore : null;
    }
    /**
     * Set VoteScore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $voteScore
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setVoteScore($voteScore = null)
    {
        // validation for constraint: float
        if (!is_null($voteScore) && !(is_float($voteScore) || is_numeric($voteScore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($voteScore, true), gettype($voteScore)), __LINE__);
        }
        if (is_null($voteScore) || (is_array($voteScore) && empty($voteScore))) {
            unset($this->VoteScore);
        } else {
            $this->VoteScore = $voteScore;
        }
        return $this;
    }
    /**
     * Get VoteTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVoteTotal()
    {
        return isset($this->VoteTotal) ? $this->VoteTotal : null;
    }
    /**
     * Set VoteTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $voteTotal
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setVoteTotal($voteTotal = null)
    {
        // validation for constraint: float
        if (!is_null($voteTotal) && !(is_float($voteTotal) || is_numeric($voteTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($voteTotal, true), gettype($voteTotal)), __LINE__);
        }
        if (is_null($voteTotal) || (is_array($voteTotal) && empty($voteTotal))) {
            unset($this->VoteTotal);
        } else {
            $this->VoteTotal = $voteTotal;
        }
        return $this;
    }
    /**
     * Get Votes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getVotes()
    {
        return isset($this->Votes) ? $this->Votes : null;
    }
    /**
     * Set Votes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $votes
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public function setVotes(\NexusDigital/MiratelForce\StructType\QueryResult $votes = null)
    {
        if (is_null($votes) || (is_array($votes) && empty($votes))) {
            unset($this->Votes);
        } else {
            $this->Votes = $votes;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\Idea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
