<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Holiday StructType
 * @subpackage Structs
 */
class Holiday extends SObject
{
    /**
     * The ActivityDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivityDate;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The EndTimeInMinutes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EndTimeInMinutes;
    /**
     * The IsAllDay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAllDay;
    /**
     * The IsRecurrence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRecurrence;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The RecurrenceDayOfMonth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RecurrenceDayOfMonth;
    /**
     * The RecurrenceDayOfWeekMask
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RecurrenceDayOfWeekMask;
    /**
     * The RecurrenceEndDateOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecurrenceEndDateOnly;
    /**
     * The RecurrenceInstance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecurrenceInstance;
    /**
     * The RecurrenceInterval
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RecurrenceInterval;
    /**
     * The RecurrenceMonthOfYear
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecurrenceMonthOfYear;
    /**
     * The RecurrenceStartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecurrenceStartDate;
    /**
     * The RecurrenceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecurrenceType;
    /**
     * The StartTimeInMinutes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StartTimeInMinutes;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for Holiday
     * @uses Holiday::setActivityDate()
     * @uses Holiday::setCreatedBy()
     * @uses Holiday::setCreatedById()
     * @uses Holiday::setCreatedDate()
     * @uses Holiday::setDescription()
     * @uses Holiday::setEndTimeInMinutes()
     * @uses Holiday::setIsAllDay()
     * @uses Holiday::setIsRecurrence()
     * @uses Holiday::setLastModifiedBy()
     * @uses Holiday::setLastModifiedById()
     * @uses Holiday::setLastModifiedDate()
     * @uses Holiday::setName()
     * @uses Holiday::setRecurrenceDayOfMonth()
     * @uses Holiday::setRecurrenceDayOfWeekMask()
     * @uses Holiday::setRecurrenceEndDateOnly()
     * @uses Holiday::setRecurrenceInstance()
     * @uses Holiday::setRecurrenceInterval()
     * @uses Holiday::setRecurrenceMonthOfYear()
     * @uses Holiday::setRecurrenceStartDate()
     * @uses Holiday::setRecurrenceType()
     * @uses Holiday::setStartTimeInMinutes()
     * @uses Holiday::setSystemModstamp()
     * @param string $activityDate
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $description
     * @param int $endTimeInMinutes
     * @param bool $isAllDay
     * @param bool $isRecurrence
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $name
     * @param int $recurrenceDayOfMonth
     * @param int $recurrenceDayOfWeekMask
     * @param string $recurrenceEndDateOnly
     * @param string $recurrenceInstance
     * @param int $recurrenceInterval
     * @param string $recurrenceMonthOfYear
     * @param string $recurrenceStartDate
     * @param string $recurrenceType
     * @param int $startTimeInMinutes
     * @param string $systemModstamp
     */
    public function __construct($activityDate = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $description = null, $endTimeInMinutes = null, $isAllDay = null, $isRecurrence = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $name = null, $recurrenceDayOfMonth = null, $recurrenceDayOfWeekMask = null, $recurrenceEndDateOnly = null, $recurrenceInstance = null, $recurrenceInterval = null, $recurrenceMonthOfYear = null, $recurrenceStartDate = null, $recurrenceType = null, $startTimeInMinutes = null, $systemModstamp = null)
    {
        $this
            ->setActivityDate($activityDate)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDescription($description)
            ->setEndTimeInMinutes($endTimeInMinutes)
            ->setIsAllDay($isAllDay)
            ->setIsRecurrence($isRecurrence)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setName($name)
            ->setRecurrenceDayOfMonth($recurrenceDayOfMonth)
            ->setRecurrenceDayOfWeekMask($recurrenceDayOfWeekMask)
            ->setRecurrenceEndDateOnly($recurrenceEndDateOnly)
            ->setRecurrenceInstance($recurrenceInstance)
            ->setRecurrenceInterval($recurrenceInterval)
            ->setRecurrenceMonthOfYear($recurrenceMonthOfYear)
            ->setRecurrenceStartDate($recurrenceStartDate)
            ->setRecurrenceType($recurrenceType)
            ->setStartTimeInMinutes($startTimeInMinutes)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get ActivityDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityDate()
    {
        return isset($this->ActivityDate) ? $this->ActivityDate : null;
    }
    /**
     * Set ActivityDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityDate
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setActivityDate($activityDate = null)
    {
        // validation for constraint: string
        if (!is_null($activityDate) && !is_string($activityDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityDate, true), gettype($activityDate)), __LINE__);
        }
        if (is_null($activityDate) || (is_array($activityDate) && empty($activityDate))) {
            unset($this->ActivityDate);
        } else {
            $this->ActivityDate = $activityDate;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EndTimeInMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEndTimeInMinutes()
    {
        return isset($this->EndTimeInMinutes) ? $this->EndTimeInMinutes : null;
    }
    /**
     * Set EndTimeInMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $endTimeInMinutes
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setEndTimeInMinutes($endTimeInMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($endTimeInMinutes) && !(is_int($endTimeInMinutes) || ctype_digit($endTimeInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($endTimeInMinutes, true), gettype($endTimeInMinutes)), __LINE__);
        }
        if (is_null($endTimeInMinutes) || (is_array($endTimeInMinutes) && empty($endTimeInMinutes))) {
            unset($this->EndTimeInMinutes);
        } else {
            $this->EndTimeInMinutes = $endTimeInMinutes;
        }
        return $this;
    }
    /**
     * Get IsAllDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAllDay()
    {
        return isset($this->IsAllDay) ? $this->IsAllDay : null;
    }
    /**
     * Set IsAllDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAllDay
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setIsAllDay($isAllDay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllDay) && !is_bool($isAllDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAllDay, true), gettype($isAllDay)), __LINE__);
        }
        if (is_null($isAllDay) || (is_array($isAllDay) && empty($isAllDay))) {
            unset($this->IsAllDay);
        } else {
            $this->IsAllDay = $isAllDay;
        }
        return $this;
    }
    /**
     * Get IsRecurrence value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRecurrence()
    {
        return isset($this->IsRecurrence) ? $this->IsRecurrence : null;
    }
    /**
     * Set IsRecurrence value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRecurrence
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setIsRecurrence($isRecurrence = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRecurrence) && !is_bool($isRecurrence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRecurrence, true), gettype($isRecurrence)), __LINE__);
        }
        if (is_null($isRecurrence) || (is_array($isRecurrence) && empty($isRecurrence))) {
            unset($this->IsRecurrence);
        } else {
            $this->IsRecurrence = $isRecurrence;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get RecurrenceDayOfMonth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRecurrenceDayOfMonth()
    {
        return isset($this->RecurrenceDayOfMonth) ? $this->RecurrenceDayOfMonth : null;
    }
    /**
     * Set RecurrenceDayOfMonth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $recurrenceDayOfMonth
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setRecurrenceDayOfMonth($recurrenceDayOfMonth = null)
    {
        // validation for constraint: int
        if (!is_null($recurrenceDayOfMonth) && !(is_int($recurrenceDayOfMonth) || ctype_digit($recurrenceDayOfMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recurrenceDayOfMonth, true), gettype($recurrenceDayOfMonth)), __LINE__);
        }
        if (is_null($recurrenceDayOfMonth) || (is_array($recurrenceDayOfMonth) && empty($recurrenceDayOfMonth))) {
            unset($this->RecurrenceDayOfMonth);
        } else {
            $this->RecurrenceDayOfMonth = $recurrenceDayOfMonth;
        }
        return $this;
    }
    /**
     * Get RecurrenceDayOfWeekMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRecurrenceDayOfWeekMask()
    {
        return isset($this->RecurrenceDayOfWeekMask) ? $this->RecurrenceDayOfWeekMask : null;
    }
    /**
     * Set RecurrenceDayOfWeekMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $recurrenceDayOfWeekMask
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setRecurrenceDayOfWeekMask($recurrenceDayOfWeekMask = null)
    {
        // validation for constraint: int
        if (!is_null($recurrenceDayOfWeekMask) && !(is_int($recurrenceDayOfWeekMask) || ctype_digit($recurrenceDayOfWeekMask))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recurrenceDayOfWeekMask, true), gettype($recurrenceDayOfWeekMask)), __LINE__);
        }
        if (is_null($recurrenceDayOfWeekMask) || (is_array($recurrenceDayOfWeekMask) && empty($recurrenceDayOfWeekMask))) {
            unset($this->RecurrenceDayOfWeekMask);
        } else {
            $this->RecurrenceDayOfWeekMask = $recurrenceDayOfWeekMask;
        }
        return $this;
    }
    /**
     * Get RecurrenceEndDateOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecurrenceEndDateOnly()
    {
        return isset($this->RecurrenceEndDateOnly) ? $this->RecurrenceEndDateOnly : null;
    }
    /**
     * Set RecurrenceEndDateOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recurrenceEndDateOnly
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setRecurrenceEndDateOnly($recurrenceEndDateOnly = null)
    {
        // validation for constraint: string
        if (!is_null($recurrenceEndDateOnly) && !is_string($recurrenceEndDateOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recurrenceEndDateOnly, true), gettype($recurrenceEndDateOnly)), __LINE__);
        }
        if (is_null($recurrenceEndDateOnly) || (is_array($recurrenceEndDateOnly) && empty($recurrenceEndDateOnly))) {
            unset($this->RecurrenceEndDateOnly);
        } else {
            $this->RecurrenceEndDateOnly = $recurrenceEndDateOnly;
        }
        return $this;
    }
    /**
     * Get RecurrenceInstance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecurrenceInstance()
    {
        return isset($this->RecurrenceInstance) ? $this->RecurrenceInstance : null;
    }
    /**
     * Set RecurrenceInstance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recurrenceInstance
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setRecurrenceInstance($recurrenceInstance = null)
    {
        // validation for constraint: string
        if (!is_null($recurrenceInstance) && !is_string($recurrenceInstance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recurrenceInstance, true), gettype($recurrenceInstance)), __LINE__);
        }
        if (is_null($recurrenceInstance) || (is_array($recurrenceInstance) && empty($recurrenceInstance))) {
            unset($this->RecurrenceInstance);
        } else {
            $this->RecurrenceInstance = $recurrenceInstance;
        }
        return $this;
    }
    /**
     * Get RecurrenceInterval value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRecurrenceInterval()
    {
        return isset($this->RecurrenceInterval) ? $this->RecurrenceInterval : null;
    }
    /**
     * Set RecurrenceInterval value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $recurrenceInterval
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setRecurrenceInterval($recurrenceInterval = null)
    {
        // validation for constraint: int
        if (!is_null($recurrenceInterval) && !(is_int($recurrenceInterval) || ctype_digit($recurrenceInterval))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recurrenceInterval, true), gettype($recurrenceInterval)), __LINE__);
        }
        if (is_null($recurrenceInterval) || (is_array($recurrenceInterval) && empty($recurrenceInterval))) {
            unset($this->RecurrenceInterval);
        } else {
            $this->RecurrenceInterval = $recurrenceInterval;
        }
        return $this;
    }
    /**
     * Get RecurrenceMonthOfYear value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecurrenceMonthOfYear()
    {
        return isset($this->RecurrenceMonthOfYear) ? $this->RecurrenceMonthOfYear : null;
    }
    /**
     * Set RecurrenceMonthOfYear value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recurrenceMonthOfYear
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setRecurrenceMonthOfYear($recurrenceMonthOfYear = null)
    {
        // validation for constraint: string
        if (!is_null($recurrenceMonthOfYear) && !is_string($recurrenceMonthOfYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recurrenceMonthOfYear, true), gettype($recurrenceMonthOfYear)), __LINE__);
        }
        if (is_null($recurrenceMonthOfYear) || (is_array($recurrenceMonthOfYear) && empty($recurrenceMonthOfYear))) {
            unset($this->RecurrenceMonthOfYear);
        } else {
            $this->RecurrenceMonthOfYear = $recurrenceMonthOfYear;
        }
        return $this;
    }
    /**
     * Get RecurrenceStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecurrenceStartDate()
    {
        return isset($this->RecurrenceStartDate) ? $this->RecurrenceStartDate : null;
    }
    /**
     * Set RecurrenceStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recurrenceStartDate
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setRecurrenceStartDate($recurrenceStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($recurrenceStartDate) && !is_string($recurrenceStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recurrenceStartDate, true), gettype($recurrenceStartDate)), __LINE__);
        }
        if (is_null($recurrenceStartDate) || (is_array($recurrenceStartDate) && empty($recurrenceStartDate))) {
            unset($this->RecurrenceStartDate);
        } else {
            $this->RecurrenceStartDate = $recurrenceStartDate;
        }
        return $this;
    }
    /**
     * Get RecurrenceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecurrenceType()
    {
        return isset($this->RecurrenceType) ? $this->RecurrenceType : null;
    }
    /**
     * Set RecurrenceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recurrenceType
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setRecurrenceType($recurrenceType = null)
    {
        // validation for constraint: string
        if (!is_null($recurrenceType) && !is_string($recurrenceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recurrenceType, true), gettype($recurrenceType)), __LINE__);
        }
        if (is_null($recurrenceType) || (is_array($recurrenceType) && empty($recurrenceType))) {
            unset($this->RecurrenceType);
        } else {
            $this->RecurrenceType = $recurrenceType;
        }
        return $this;
    }
    /**
     * Get StartTimeInMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStartTimeInMinutes()
    {
        return isset($this->StartTimeInMinutes) ? $this->StartTimeInMinutes : null;
    }
    /**
     * Set StartTimeInMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $startTimeInMinutes
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setStartTimeInMinutes($startTimeInMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($startTimeInMinutes) && !(is_int($startTimeInMinutes) || ctype_digit($startTimeInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startTimeInMinutes, true), gettype($startTimeInMinutes)), __LINE__);
        }
        if (is_null($startTimeInMinutes) || (is_array($startTimeInMinutes) && empty($startTimeInMinutes))) {
            unset($this->StartTimeInMinutes);
        } else {
            $this->StartTimeInMinutes = $startTimeInMinutes;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\Holiday
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
