<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FieldDefinition StructType
 * @subpackage Structs
 */
class FieldDefinition extends SObject
{
    /**
     * The BusinessOwner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $BusinessOwner;
    /**
     * The BusinessOwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $BusinessOwnerId;
    /**
     * The BusinessStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessStatus;
    /**
     * The ControlledFields
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ControlledFields;
    /**
     * The ControllingFieldDefinition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public $ControllingFieldDefinition;
    /**
     * The ControllingFieldDefinitionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ControllingFieldDefinitionId;
    /**
     * The DataType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataType;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DeveloperName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeveloperName;
    /**
     * The DurableId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurableId;
    /**
     * The EntityDefinition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\EntityDefinition
     */
    public $EntityDefinition;
    /**
     * The EntityDefinitionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityDefinitionId;
    /**
     * The ExtraTypeInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraTypeInfo;
    /**
     * The IsApiFilterable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsApiFilterable;
    /**
     * The IsApiGroupable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsApiGroupable;
    /**
     * The IsApiSortable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsApiSortable;
    /**
     * The IsCalculated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCalculated;
    /**
     * The IsCompactLayoutable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCompactLayoutable;
    /**
     * The IsCompound
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCompound;
    /**
     * The IsFieldHistoryTracked
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFieldHistoryTracked;
    /**
     * The IsHighScaleNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHighScaleNumber;
    /**
     * The IsHtmlFormatted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHtmlFormatted;
    /**
     * The IsIndexed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsIndexed;
    /**
     * The IsListFilterable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsListFilterable;
    /**
     * The IsListSortable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsListSortable;
    /**
     * The IsListVisible
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsListVisible;
    /**
     * The IsNameField
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsNameField;
    /**
     * The IsNillable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsNillable;
    /**
     * The IsPolymorphicForeignKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPolymorphicForeignKey;
    /**
     * The IsSearchPrefilterable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSearchPrefilterable;
    /**
     * The IsWorkflowFilterable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsWorkflowFilterable;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The Length
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Length;
    /**
     * The MasterLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterLabel;
    /**
     * The NamespacePrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NamespacePrefix;
    /**
     * The Particles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Particles;
    /**
     * The Precision
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Precision;
    /**
     * The Publisher
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Publisher
     */
    public $Publisher;
    /**
     * The PublisherId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PublisherId;
    /**
     * The QualifiedApiName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QualifiedApiName;
    /**
     * The ReferenceTargetField
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceTargetField;
    /**
     * The ReferenceTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\RelationshipReferenceTo
     */
    public $ReferenceTo;
    /**
     * The RelationshipDomains
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RelationshipDomains;
    /**
     * The RelationshipName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelationshipName;
    /**
     * The RunningUserFieldAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserFieldAccess
     */
    public $RunningUserFieldAccess;
    /**
     * The RunningUserFieldAccessId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RunningUserFieldAccessId;
    /**
     * The Scale
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Scale;
    /**
     * The SecurityClassification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecurityClassification;
    /**
     * The ServiceDataType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\DataType
     */
    public $ServiceDataType;
    /**
     * The ServiceDataTypeId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceDataTypeId;
    /**
     * The ValueType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\DataType
     */
    public $ValueType;
    /**
     * The ValueTypeId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValueTypeId;
    /**
     * Constructor method for FieldDefinition
     * @uses FieldDefinition::setBusinessOwner()
     * @uses FieldDefinition::setBusinessOwnerId()
     * @uses FieldDefinition::setBusinessStatus()
     * @uses FieldDefinition::setControlledFields()
     * @uses FieldDefinition::setControllingFieldDefinition()
     * @uses FieldDefinition::setControllingFieldDefinitionId()
     * @uses FieldDefinition::setDataType()
     * @uses FieldDefinition::setDescription()
     * @uses FieldDefinition::setDeveloperName()
     * @uses FieldDefinition::setDurableId()
     * @uses FieldDefinition::setEntityDefinition()
     * @uses FieldDefinition::setEntityDefinitionId()
     * @uses FieldDefinition::setExtraTypeInfo()
     * @uses FieldDefinition::setIsApiFilterable()
     * @uses FieldDefinition::setIsApiGroupable()
     * @uses FieldDefinition::setIsApiSortable()
     * @uses FieldDefinition::setIsCalculated()
     * @uses FieldDefinition::setIsCompactLayoutable()
     * @uses FieldDefinition::setIsCompound()
     * @uses FieldDefinition::setIsFieldHistoryTracked()
     * @uses FieldDefinition::setIsHighScaleNumber()
     * @uses FieldDefinition::setIsHtmlFormatted()
     * @uses FieldDefinition::setIsIndexed()
     * @uses FieldDefinition::setIsListFilterable()
     * @uses FieldDefinition::setIsListSortable()
     * @uses FieldDefinition::setIsListVisible()
     * @uses FieldDefinition::setIsNameField()
     * @uses FieldDefinition::setIsNillable()
     * @uses FieldDefinition::setIsPolymorphicForeignKey()
     * @uses FieldDefinition::setIsSearchPrefilterable()
     * @uses FieldDefinition::setIsWorkflowFilterable()
     * @uses FieldDefinition::setLabel()
     * @uses FieldDefinition::setLastModifiedBy()
     * @uses FieldDefinition::setLastModifiedById()
     * @uses FieldDefinition::setLastModifiedDate()
     * @uses FieldDefinition::setLength()
     * @uses FieldDefinition::setMasterLabel()
     * @uses FieldDefinition::setNamespacePrefix()
     * @uses FieldDefinition::setParticles()
     * @uses FieldDefinition::setPrecision()
     * @uses FieldDefinition::setPublisher()
     * @uses FieldDefinition::setPublisherId()
     * @uses FieldDefinition::setQualifiedApiName()
     * @uses FieldDefinition::setReferenceTargetField()
     * @uses FieldDefinition::setReferenceTo()
     * @uses FieldDefinition::setRelationshipDomains()
     * @uses FieldDefinition::setRelationshipName()
     * @uses FieldDefinition::setRunningUserFieldAccess()
     * @uses FieldDefinition::setRunningUserFieldAccessId()
     * @uses FieldDefinition::setScale()
     * @uses FieldDefinition::setSecurityClassification()
     * @uses FieldDefinition::setServiceDataType()
     * @uses FieldDefinition::setServiceDataTypeId()
     * @uses FieldDefinition::setValueType()
     * @uses FieldDefinition::setValueTypeId()
     * @param \NexusDigital/MiratelForce\StructType\SObject $businessOwner
     * @param string $businessOwnerId
     * @param string $businessStatus
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $controlledFields
     * @param \NexusDigital/MiratelForce\StructType\FieldDefinition $controllingFieldDefinition
     * @param string $controllingFieldDefinitionId
     * @param string $dataType
     * @param string $description
     * @param string $developerName
     * @param string $durableId
     * @param \NexusDigital/MiratelForce\StructType\EntityDefinition $entityDefinition
     * @param string $entityDefinitionId
     * @param string $extraTypeInfo
     * @param bool $isApiFilterable
     * @param bool $isApiGroupable
     * @param bool $isApiSortable
     * @param bool $isCalculated
     * @param bool $isCompactLayoutable
     * @param bool $isCompound
     * @param bool $isFieldHistoryTracked
     * @param bool $isHighScaleNumber
     * @param bool $isHtmlFormatted
     * @param bool $isIndexed
     * @param bool $isListFilterable
     * @param bool $isListSortable
     * @param bool $isListVisible
     * @param bool $isNameField
     * @param bool $isNillable
     * @param bool $isPolymorphicForeignKey
     * @param bool $isSearchPrefilterable
     * @param bool $isWorkflowFilterable
     * @param string $label
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param int $length
     * @param string $masterLabel
     * @param string $namespacePrefix
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $particles
     * @param int $precision
     * @param \NexusDigital/MiratelForce\StructType\Publisher $publisher
     * @param string $publisherId
     * @param string $qualifiedApiName
     * @param string $referenceTargetField
     * @param \NexusDigital/MiratelForce\StructType\RelationshipReferenceTo $referenceTo
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $relationshipDomains
     * @param string $relationshipName
     * @param \NexusDigital/MiratelForce\StructType\UserFieldAccess $runningUserFieldAccess
     * @param string $runningUserFieldAccessId
     * @param int $scale
     * @param string $securityClassification
     * @param \NexusDigital/MiratelForce\StructType\DataType $serviceDataType
     * @param string $serviceDataTypeId
     * @param \NexusDigital/MiratelForce\StructType\DataType $valueType
     * @param string $valueTypeId
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\SObject $businessOwner = null, $businessOwnerId = null, $businessStatus = null, \NexusDigital/MiratelForce\StructType\QueryResult $controlledFields = null, \NexusDigital/MiratelForce\StructType\FieldDefinition $controllingFieldDefinition = null, $controllingFieldDefinitionId = null, $dataType = null, $description = null, $developerName = null, $durableId = null, \NexusDigital/MiratelForce\StructType\EntityDefinition $entityDefinition = null, $entityDefinitionId = null, $extraTypeInfo = null, $isApiFilterable = null, $isApiGroupable = null, $isApiSortable = null, $isCalculated = null, $isCompactLayoutable = null, $isCompound = null, $isFieldHistoryTracked = null, $isHighScaleNumber = null, $isHtmlFormatted = null, $isIndexed = null, $isListFilterable = null, $isListSortable = null, $isListVisible = null, $isNameField = null, $isNillable = null, $isPolymorphicForeignKey = null, $isSearchPrefilterable = null, $isWorkflowFilterable = null, $label = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $length = null, $masterLabel = null, $namespacePrefix = null, \NexusDigital/MiratelForce\StructType\QueryResult $particles = null, $precision = null, \NexusDigital/MiratelForce\StructType\Publisher $publisher = null, $publisherId = null, $qualifiedApiName = null, $referenceTargetField = null, \NexusDigital/MiratelForce\StructType\RelationshipReferenceTo $referenceTo = null, \NexusDigital/MiratelForce\StructType\QueryResult $relationshipDomains = null, $relationshipName = null, \NexusDigital/MiratelForce\StructType\UserFieldAccess $runningUserFieldAccess = null, $runningUserFieldAccessId = null, $scale = null, $securityClassification = null, \NexusDigital/MiratelForce\StructType\DataType $serviceDataType = null, $serviceDataTypeId = null, \NexusDigital/MiratelForce\StructType\DataType $valueType = null, $valueTypeId = null)
    {
        $this
            ->setBusinessOwner($businessOwner)
            ->setBusinessOwnerId($businessOwnerId)
            ->setBusinessStatus($businessStatus)
            ->setControlledFields($controlledFields)
            ->setControllingFieldDefinition($controllingFieldDefinition)
            ->setControllingFieldDefinitionId($controllingFieldDefinitionId)
            ->setDataType($dataType)
            ->setDescription($description)
            ->setDeveloperName($developerName)
            ->setDurableId($durableId)
            ->setEntityDefinition($entityDefinition)
            ->setEntityDefinitionId($entityDefinitionId)
            ->setExtraTypeInfo($extraTypeInfo)
            ->setIsApiFilterable($isApiFilterable)
            ->setIsApiGroupable($isApiGroupable)
            ->setIsApiSortable($isApiSortable)
            ->setIsCalculated($isCalculated)
            ->setIsCompactLayoutable($isCompactLayoutable)
            ->setIsCompound($isCompound)
            ->setIsFieldHistoryTracked($isFieldHistoryTracked)
            ->setIsHighScaleNumber($isHighScaleNumber)
            ->setIsHtmlFormatted($isHtmlFormatted)
            ->setIsIndexed($isIndexed)
            ->setIsListFilterable($isListFilterable)
            ->setIsListSortable($isListSortable)
            ->setIsListVisible($isListVisible)
            ->setIsNameField($isNameField)
            ->setIsNillable($isNillable)
            ->setIsPolymorphicForeignKey($isPolymorphicForeignKey)
            ->setIsSearchPrefilterable($isSearchPrefilterable)
            ->setIsWorkflowFilterable($isWorkflowFilterable)
            ->setLabel($label)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLength($length)
            ->setMasterLabel($masterLabel)
            ->setNamespacePrefix($namespacePrefix)
            ->setParticles($particles)
            ->setPrecision($precision)
            ->setPublisher($publisher)
            ->setPublisherId($publisherId)
            ->setQualifiedApiName($qualifiedApiName)
            ->setReferenceTargetField($referenceTargetField)
            ->setReferenceTo($referenceTo)
            ->setRelationshipDomains($relationshipDomains)
            ->setRelationshipName($relationshipName)
            ->setRunningUserFieldAccess($runningUserFieldAccess)
            ->setRunningUserFieldAccessId($runningUserFieldAccessId)
            ->setScale($scale)
            ->setSecurityClassification($securityClassification)
            ->setServiceDataType($serviceDataType)
            ->setServiceDataTypeId($serviceDataTypeId)
            ->setValueType($valueType)
            ->setValueTypeId($valueTypeId);
    }
    /**
     * Get BusinessOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getBusinessOwner()
    {
        return isset($this->BusinessOwner) ? $this->BusinessOwner : null;
    }
    /**
     * Set BusinessOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $businessOwner
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setBusinessOwner(\NexusDigital/MiratelForce\StructType\SObject $businessOwner = null)
    {
        if (is_null($businessOwner) || (is_array($businessOwner) && empty($businessOwner))) {
            unset($this->BusinessOwner);
        } else {
            $this->BusinessOwner = $businessOwner;
        }
        return $this;
    }
    /**
     * Get BusinessOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessOwnerId()
    {
        return isset($this->BusinessOwnerId) ? $this->BusinessOwnerId : null;
    }
    /**
     * Set BusinessOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessOwnerId
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setBusinessOwnerId($businessOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($businessOwnerId) && !is_string($businessOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessOwnerId, true), gettype($businessOwnerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($businessOwnerId) && mb_strlen($businessOwnerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($businessOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($businessOwnerId) && !preg_match('/[a-zA-Z0-9]{18}/', $businessOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($businessOwnerId, true)), __LINE__);
        }
        if (is_null($businessOwnerId) || (is_array($businessOwnerId) && empty($businessOwnerId))) {
            unset($this->BusinessOwnerId);
        } else {
            $this->BusinessOwnerId = $businessOwnerId;
        }
        return $this;
    }
    /**
     * Get BusinessStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessStatus()
    {
        return isset($this->BusinessStatus) ? $this->BusinessStatus : null;
    }
    /**
     * Set BusinessStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessStatus
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setBusinessStatus($businessStatus = null)
    {
        // validation for constraint: string
        if (!is_null($businessStatus) && !is_string($businessStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessStatus, true), gettype($businessStatus)), __LINE__);
        }
        if (is_null($businessStatus) || (is_array($businessStatus) && empty($businessStatus))) {
            unset($this->BusinessStatus);
        } else {
            $this->BusinessStatus = $businessStatus;
        }
        return $this;
    }
    /**
     * Get ControlledFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getControlledFields()
    {
        return isset($this->ControlledFields) ? $this->ControlledFields : null;
    }
    /**
     * Set ControlledFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $controlledFields
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setControlledFields(\NexusDigital/MiratelForce\StructType\QueryResult $controlledFields = null)
    {
        if (is_null($controlledFields) || (is_array($controlledFields) && empty($controlledFields))) {
            unset($this->ControlledFields);
        } else {
            $this->ControlledFields = $controlledFields;
        }
        return $this;
    }
    /**
     * Get ControllingFieldDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition|null
     */
    public function getControllingFieldDefinition()
    {
        return isset($this->ControllingFieldDefinition) ? $this->ControllingFieldDefinition : null;
    }
    /**
     * Set ControllingFieldDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\FieldDefinition $controllingFieldDefinition
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setControllingFieldDefinition(\NexusDigital/MiratelForce\StructType\FieldDefinition $controllingFieldDefinition = null)
    {
        if (is_null($controllingFieldDefinition) || (is_array($controllingFieldDefinition) && empty($controllingFieldDefinition))) {
            unset($this->ControllingFieldDefinition);
        } else {
            $this->ControllingFieldDefinition = $controllingFieldDefinition;
        }
        return $this;
    }
    /**
     * Get ControllingFieldDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getControllingFieldDefinitionId()
    {
        return isset($this->ControllingFieldDefinitionId) ? $this->ControllingFieldDefinitionId : null;
    }
    /**
     * Set ControllingFieldDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $controllingFieldDefinitionId
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setControllingFieldDefinitionId($controllingFieldDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($controllingFieldDefinitionId) && !is_string($controllingFieldDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($controllingFieldDefinitionId, true), gettype($controllingFieldDefinitionId)), __LINE__);
        }
        if (is_null($controllingFieldDefinitionId) || (is_array($controllingFieldDefinitionId) && empty($controllingFieldDefinitionId))) {
            unset($this->ControllingFieldDefinitionId);
        } else {
            $this->ControllingFieldDefinitionId = $controllingFieldDefinitionId;
        }
        return $this;
    }
    /**
     * Get DataType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataType()
    {
        return isset($this->DataType) ? $this->DataType : null;
    }
    /**
     * Set DataType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataType
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setDataType($dataType = null)
    {
        // validation for constraint: string
        if (!is_null($dataType) && !is_string($dataType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataType, true), gettype($dataType)), __LINE__);
        }
        if (is_null($dataType) || (is_array($dataType) && empty($dataType))) {
            unset($this->DataType);
        } else {
            $this->DataType = $dataType;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DeveloperName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeveloperName()
    {
        return isset($this->DeveloperName) ? $this->DeveloperName : null;
    }
    /**
     * Set DeveloperName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $developerName
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setDeveloperName($developerName = null)
    {
        // validation for constraint: string
        if (!is_null($developerName) && !is_string($developerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($developerName, true), gettype($developerName)), __LINE__);
        }
        if (is_null($developerName) || (is_array($developerName) && empty($developerName))) {
            unset($this->DeveloperName);
        } else {
            $this->DeveloperName = $developerName;
        }
        return $this;
    }
    /**
     * Get DurableId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurableId()
    {
        return isset($this->DurableId) ? $this->DurableId : null;
    }
    /**
     * Set DurableId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $durableId
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setDurableId($durableId = null)
    {
        // validation for constraint: string
        if (!is_null($durableId) && !is_string($durableId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durableId, true), gettype($durableId)), __LINE__);
        }
        if (is_null($durableId) || (is_array($durableId) && empty($durableId))) {
            unset($this->DurableId);
        } else {
            $this->DurableId = $durableId;
        }
        return $this;
    }
    /**
     * Get EntityDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\EntityDefinition|null
     */
    public function getEntityDefinition()
    {
        return isset($this->EntityDefinition) ? $this->EntityDefinition : null;
    }
    /**
     * Set EntityDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\EntityDefinition $entityDefinition
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setEntityDefinition(\NexusDigital/MiratelForce\StructType\EntityDefinition $entityDefinition = null)
    {
        if (is_null($entityDefinition) || (is_array($entityDefinition) && empty($entityDefinition))) {
            unset($this->EntityDefinition);
        } else {
            $this->EntityDefinition = $entityDefinition;
        }
        return $this;
    }
    /**
     * Get EntityDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityDefinitionId()
    {
        return isset($this->EntityDefinitionId) ? $this->EntityDefinitionId : null;
    }
    /**
     * Set EntityDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityDefinitionId
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setEntityDefinitionId($entityDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($entityDefinitionId) && !is_string($entityDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityDefinitionId, true), gettype($entityDefinitionId)), __LINE__);
        }
        if (is_null($entityDefinitionId) || (is_array($entityDefinitionId) && empty($entityDefinitionId))) {
            unset($this->EntityDefinitionId);
        } else {
            $this->EntityDefinitionId = $entityDefinitionId;
        }
        return $this;
    }
    /**
     * Get ExtraTypeInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraTypeInfo()
    {
        return isset($this->ExtraTypeInfo) ? $this->ExtraTypeInfo : null;
    }
    /**
     * Set ExtraTypeInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraTypeInfo
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setExtraTypeInfo($extraTypeInfo = null)
    {
        // validation for constraint: string
        if (!is_null($extraTypeInfo) && !is_string($extraTypeInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraTypeInfo, true), gettype($extraTypeInfo)), __LINE__);
        }
        if (is_null($extraTypeInfo) || (is_array($extraTypeInfo) && empty($extraTypeInfo))) {
            unset($this->ExtraTypeInfo);
        } else {
            $this->ExtraTypeInfo = $extraTypeInfo;
        }
        return $this;
    }
    /**
     * Get IsApiFilterable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsApiFilterable()
    {
        return isset($this->IsApiFilterable) ? $this->IsApiFilterable : null;
    }
    /**
     * Set IsApiFilterable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isApiFilterable
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsApiFilterable($isApiFilterable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApiFilterable) && !is_bool($isApiFilterable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isApiFilterable, true), gettype($isApiFilterable)), __LINE__);
        }
        if (is_null($isApiFilterable) || (is_array($isApiFilterable) && empty($isApiFilterable))) {
            unset($this->IsApiFilterable);
        } else {
            $this->IsApiFilterable = $isApiFilterable;
        }
        return $this;
    }
    /**
     * Get IsApiGroupable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsApiGroupable()
    {
        return isset($this->IsApiGroupable) ? $this->IsApiGroupable : null;
    }
    /**
     * Set IsApiGroupable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isApiGroupable
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsApiGroupable($isApiGroupable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApiGroupable) && !is_bool($isApiGroupable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isApiGroupable, true), gettype($isApiGroupable)), __LINE__);
        }
        if (is_null($isApiGroupable) || (is_array($isApiGroupable) && empty($isApiGroupable))) {
            unset($this->IsApiGroupable);
        } else {
            $this->IsApiGroupable = $isApiGroupable;
        }
        return $this;
    }
    /**
     * Get IsApiSortable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsApiSortable()
    {
        return isset($this->IsApiSortable) ? $this->IsApiSortable : null;
    }
    /**
     * Set IsApiSortable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isApiSortable
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsApiSortable($isApiSortable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApiSortable) && !is_bool($isApiSortable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isApiSortable, true), gettype($isApiSortable)), __LINE__);
        }
        if (is_null($isApiSortable) || (is_array($isApiSortable) && empty($isApiSortable))) {
            unset($this->IsApiSortable);
        } else {
            $this->IsApiSortable = $isApiSortable;
        }
        return $this;
    }
    /**
     * Get IsCalculated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCalculated()
    {
        return isset($this->IsCalculated) ? $this->IsCalculated : null;
    }
    /**
     * Set IsCalculated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCalculated
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsCalculated($isCalculated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCalculated) && !is_bool($isCalculated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCalculated, true), gettype($isCalculated)), __LINE__);
        }
        if (is_null($isCalculated) || (is_array($isCalculated) && empty($isCalculated))) {
            unset($this->IsCalculated);
        } else {
            $this->IsCalculated = $isCalculated;
        }
        return $this;
    }
    /**
     * Get IsCompactLayoutable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCompactLayoutable()
    {
        return isset($this->IsCompactLayoutable) ? $this->IsCompactLayoutable : null;
    }
    /**
     * Set IsCompactLayoutable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCompactLayoutable
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsCompactLayoutable($isCompactLayoutable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCompactLayoutable) && !is_bool($isCompactLayoutable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCompactLayoutable, true), gettype($isCompactLayoutable)), __LINE__);
        }
        if (is_null($isCompactLayoutable) || (is_array($isCompactLayoutable) && empty($isCompactLayoutable))) {
            unset($this->IsCompactLayoutable);
        } else {
            $this->IsCompactLayoutable = $isCompactLayoutable;
        }
        return $this;
    }
    /**
     * Get IsCompound value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCompound()
    {
        return isset($this->IsCompound) ? $this->IsCompound : null;
    }
    /**
     * Set IsCompound value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCompound
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsCompound($isCompound = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCompound) && !is_bool($isCompound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCompound, true), gettype($isCompound)), __LINE__);
        }
        if (is_null($isCompound) || (is_array($isCompound) && empty($isCompound))) {
            unset($this->IsCompound);
        } else {
            $this->IsCompound = $isCompound;
        }
        return $this;
    }
    /**
     * Get IsFieldHistoryTracked value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFieldHistoryTracked()
    {
        return isset($this->IsFieldHistoryTracked) ? $this->IsFieldHistoryTracked : null;
    }
    /**
     * Set IsFieldHistoryTracked value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFieldHistoryTracked
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsFieldHistoryTracked($isFieldHistoryTracked = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFieldHistoryTracked) && !is_bool($isFieldHistoryTracked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFieldHistoryTracked, true), gettype($isFieldHistoryTracked)), __LINE__);
        }
        if (is_null($isFieldHistoryTracked) || (is_array($isFieldHistoryTracked) && empty($isFieldHistoryTracked))) {
            unset($this->IsFieldHistoryTracked);
        } else {
            $this->IsFieldHistoryTracked = $isFieldHistoryTracked;
        }
        return $this;
    }
    /**
     * Get IsHighScaleNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHighScaleNumber()
    {
        return isset($this->IsHighScaleNumber) ? $this->IsHighScaleNumber : null;
    }
    /**
     * Set IsHighScaleNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHighScaleNumber
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsHighScaleNumber($isHighScaleNumber = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHighScaleNumber) && !is_bool($isHighScaleNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHighScaleNumber, true), gettype($isHighScaleNumber)), __LINE__);
        }
        if (is_null($isHighScaleNumber) || (is_array($isHighScaleNumber) && empty($isHighScaleNumber))) {
            unset($this->IsHighScaleNumber);
        } else {
            $this->IsHighScaleNumber = $isHighScaleNumber;
        }
        return $this;
    }
    /**
     * Get IsHtmlFormatted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHtmlFormatted()
    {
        return isset($this->IsHtmlFormatted) ? $this->IsHtmlFormatted : null;
    }
    /**
     * Set IsHtmlFormatted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHtmlFormatted
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsHtmlFormatted($isHtmlFormatted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHtmlFormatted) && !is_bool($isHtmlFormatted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHtmlFormatted, true), gettype($isHtmlFormatted)), __LINE__);
        }
        if (is_null($isHtmlFormatted) || (is_array($isHtmlFormatted) && empty($isHtmlFormatted))) {
            unset($this->IsHtmlFormatted);
        } else {
            $this->IsHtmlFormatted = $isHtmlFormatted;
        }
        return $this;
    }
    /**
     * Get IsIndexed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsIndexed()
    {
        return isset($this->IsIndexed) ? $this->IsIndexed : null;
    }
    /**
     * Set IsIndexed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isIndexed
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsIndexed($isIndexed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIndexed) && !is_bool($isIndexed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIndexed, true), gettype($isIndexed)), __LINE__);
        }
        if (is_null($isIndexed) || (is_array($isIndexed) && empty($isIndexed))) {
            unset($this->IsIndexed);
        } else {
            $this->IsIndexed = $isIndexed;
        }
        return $this;
    }
    /**
     * Get IsListFilterable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsListFilterable()
    {
        return isset($this->IsListFilterable) ? $this->IsListFilterable : null;
    }
    /**
     * Set IsListFilterable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isListFilterable
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsListFilterable($isListFilterable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isListFilterable) && !is_bool($isListFilterable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isListFilterable, true), gettype($isListFilterable)), __LINE__);
        }
        if (is_null($isListFilterable) || (is_array($isListFilterable) && empty($isListFilterable))) {
            unset($this->IsListFilterable);
        } else {
            $this->IsListFilterable = $isListFilterable;
        }
        return $this;
    }
    /**
     * Get IsListSortable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsListSortable()
    {
        return isset($this->IsListSortable) ? $this->IsListSortable : null;
    }
    /**
     * Set IsListSortable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isListSortable
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsListSortable($isListSortable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isListSortable) && !is_bool($isListSortable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isListSortable, true), gettype($isListSortable)), __LINE__);
        }
        if (is_null($isListSortable) || (is_array($isListSortable) && empty($isListSortable))) {
            unset($this->IsListSortable);
        } else {
            $this->IsListSortable = $isListSortable;
        }
        return $this;
    }
    /**
     * Get IsListVisible value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsListVisible()
    {
        return isset($this->IsListVisible) ? $this->IsListVisible : null;
    }
    /**
     * Set IsListVisible value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isListVisible
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsListVisible($isListVisible = null)
    {
        // validation for constraint: boolean
        if (!is_null($isListVisible) && !is_bool($isListVisible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isListVisible, true), gettype($isListVisible)), __LINE__);
        }
        if (is_null($isListVisible) || (is_array($isListVisible) && empty($isListVisible))) {
            unset($this->IsListVisible);
        } else {
            $this->IsListVisible = $isListVisible;
        }
        return $this;
    }
    /**
     * Get IsNameField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNameField()
    {
        return isset($this->IsNameField) ? $this->IsNameField : null;
    }
    /**
     * Set IsNameField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNameField
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsNameField($isNameField = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNameField) && !is_bool($isNameField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNameField, true), gettype($isNameField)), __LINE__);
        }
        if (is_null($isNameField) || (is_array($isNameField) && empty($isNameField))) {
            unset($this->IsNameField);
        } else {
            $this->IsNameField = $isNameField;
        }
        return $this;
    }
    /**
     * Get IsNillable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNillable()
    {
        return isset($this->IsNillable) ? $this->IsNillable : null;
    }
    /**
     * Set IsNillable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNillable
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsNillable($isNillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNillable) && !is_bool($isNillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNillable, true), gettype($isNillable)), __LINE__);
        }
        if (is_null($isNillable) || (is_array($isNillable) && empty($isNillable))) {
            unset($this->IsNillable);
        } else {
            $this->IsNillable = $isNillable;
        }
        return $this;
    }
    /**
     * Get IsPolymorphicForeignKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPolymorphicForeignKey()
    {
        return isset($this->IsPolymorphicForeignKey) ? $this->IsPolymorphicForeignKey : null;
    }
    /**
     * Set IsPolymorphicForeignKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPolymorphicForeignKey
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsPolymorphicForeignKey($isPolymorphicForeignKey = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPolymorphicForeignKey) && !is_bool($isPolymorphicForeignKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPolymorphicForeignKey, true), gettype($isPolymorphicForeignKey)), __LINE__);
        }
        if (is_null($isPolymorphicForeignKey) || (is_array($isPolymorphicForeignKey) && empty($isPolymorphicForeignKey))) {
            unset($this->IsPolymorphicForeignKey);
        } else {
            $this->IsPolymorphicForeignKey = $isPolymorphicForeignKey;
        }
        return $this;
    }
    /**
     * Get IsSearchPrefilterable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSearchPrefilterable()
    {
        return isset($this->IsSearchPrefilterable) ? $this->IsSearchPrefilterable : null;
    }
    /**
     * Set IsSearchPrefilterable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSearchPrefilterable
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsSearchPrefilterable($isSearchPrefilterable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSearchPrefilterable) && !is_bool($isSearchPrefilterable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSearchPrefilterable, true), gettype($isSearchPrefilterable)), __LINE__);
        }
        if (is_null($isSearchPrefilterable) || (is_array($isSearchPrefilterable) && empty($isSearchPrefilterable))) {
            unset($this->IsSearchPrefilterable);
        } else {
            $this->IsSearchPrefilterable = $isSearchPrefilterable;
        }
        return $this;
    }
    /**
     * Get IsWorkflowFilterable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsWorkflowFilterable()
    {
        return isset($this->IsWorkflowFilterable) ? $this->IsWorkflowFilterable : null;
    }
    /**
     * Set IsWorkflowFilterable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isWorkflowFilterable
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setIsWorkflowFilterable($isWorkflowFilterable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWorkflowFilterable) && !is_bool($isWorkflowFilterable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isWorkflowFilterable, true), gettype($isWorkflowFilterable)), __LINE__);
        }
        if (is_null($isWorkflowFilterable) || (is_array($isWorkflowFilterable) && empty($isWorkflowFilterable))) {
            unset($this->IsWorkflowFilterable);
        } else {
            $this->IsWorkflowFilterable = $isWorkflowFilterable;
        }
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get Length value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLength()
    {
        return isset($this->Length) ? $this->Length : null;
    }
    /**
     * Set Length value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $length
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !(is_int($length) || ctype_digit($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        if (is_null($length) || (is_array($length) && empty($length))) {
            unset($this->Length);
        } else {
            $this->Length = $length;
        }
        return $this;
    }
    /**
     * Get MasterLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterLabel()
    {
        return isset($this->MasterLabel) ? $this->MasterLabel : null;
    }
    /**
     * Set MasterLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterLabel
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setMasterLabel($masterLabel = null)
    {
        // validation for constraint: string
        if (!is_null($masterLabel) && !is_string($masterLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterLabel, true), gettype($masterLabel)), __LINE__);
        }
        if (is_null($masterLabel) || (is_array($masterLabel) && empty($masterLabel))) {
            unset($this->MasterLabel);
        } else {
            $this->MasterLabel = $masterLabel;
        }
        return $this;
    }
    /**
     * Get NamespacePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNamespacePrefix()
    {
        return isset($this->NamespacePrefix) ? $this->NamespacePrefix : null;
    }
    /**
     * Set NamespacePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $namespacePrefix
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setNamespacePrefix($namespacePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($namespacePrefix) && !is_string($namespacePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namespacePrefix, true), gettype($namespacePrefix)), __LINE__);
        }
        if (is_null($namespacePrefix) || (is_array($namespacePrefix) && empty($namespacePrefix))) {
            unset($this->NamespacePrefix);
        } else {
            $this->NamespacePrefix = $namespacePrefix;
        }
        return $this;
    }
    /**
     * Get Particles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getParticles()
    {
        return isset($this->Particles) ? $this->Particles : null;
    }
    /**
     * Set Particles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $particles
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setParticles(\NexusDigital/MiratelForce\StructType\QueryResult $particles = null)
    {
        if (is_null($particles) || (is_array($particles) && empty($particles))) {
            unset($this->Particles);
        } else {
            $this->Particles = $particles;
        }
        return $this;
    }
    /**
     * Get Precision value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrecision()
    {
        return isset($this->Precision) ? $this->Precision : null;
    }
    /**
     * Set Precision value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $precision
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setPrecision($precision = null)
    {
        // validation for constraint: int
        if (!is_null($precision) && !(is_int($precision) || ctype_digit($precision))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($precision, true), gettype($precision)), __LINE__);
        }
        if (is_null($precision) || (is_array($precision) && empty($precision))) {
            unset($this->Precision);
        } else {
            $this->Precision = $precision;
        }
        return $this;
    }
    /**
     * Get Publisher value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Publisher|null
     */
    public function getPublisher()
    {
        return isset($this->Publisher) ? $this->Publisher : null;
    }
    /**
     * Set Publisher value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Publisher $publisher
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setPublisher(\NexusDigital/MiratelForce\StructType\Publisher $publisher = null)
    {
        if (is_null($publisher) || (is_array($publisher) && empty($publisher))) {
            unset($this->Publisher);
        } else {
            $this->Publisher = $publisher;
        }
        return $this;
    }
    /**
     * Get PublisherId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPublisherId()
    {
        return isset($this->PublisherId) ? $this->PublisherId : null;
    }
    /**
     * Set PublisherId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $publisherId
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setPublisherId($publisherId = null)
    {
        // validation for constraint: string
        if (!is_null($publisherId) && !is_string($publisherId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publisherId, true), gettype($publisherId)), __LINE__);
        }
        if (is_null($publisherId) || (is_array($publisherId) && empty($publisherId))) {
            unset($this->PublisherId);
        } else {
            $this->PublisherId = $publisherId;
        }
        return $this;
    }
    /**
     * Get QualifiedApiName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQualifiedApiName()
    {
        return isset($this->QualifiedApiName) ? $this->QualifiedApiName : null;
    }
    /**
     * Set QualifiedApiName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $qualifiedApiName
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setQualifiedApiName($qualifiedApiName = null)
    {
        // validation for constraint: string
        if (!is_null($qualifiedApiName) && !is_string($qualifiedApiName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qualifiedApiName, true), gettype($qualifiedApiName)), __LINE__);
        }
        if (is_null($qualifiedApiName) || (is_array($qualifiedApiName) && empty($qualifiedApiName))) {
            unset($this->QualifiedApiName);
        } else {
            $this->QualifiedApiName = $qualifiedApiName;
        }
        return $this;
    }
    /**
     * Get ReferenceTargetField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceTargetField()
    {
        return isset($this->ReferenceTargetField) ? $this->ReferenceTargetField : null;
    }
    /**
     * Set ReferenceTargetField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceTargetField
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setReferenceTargetField($referenceTargetField = null)
    {
        // validation for constraint: string
        if (!is_null($referenceTargetField) && !is_string($referenceTargetField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceTargetField, true), gettype($referenceTargetField)), __LINE__);
        }
        if (is_null($referenceTargetField) || (is_array($referenceTargetField) && empty($referenceTargetField))) {
            unset($this->ReferenceTargetField);
        } else {
            $this->ReferenceTargetField = $referenceTargetField;
        }
        return $this;
    }
    /**
     * Get ReferenceTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\RelationshipReferenceTo|null
     */
    public function getReferenceTo()
    {
        return isset($this->ReferenceTo) ? $this->ReferenceTo : null;
    }
    /**
     * Set ReferenceTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\RelationshipReferenceTo $referenceTo
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setReferenceTo(\NexusDigital/MiratelForce\StructType\RelationshipReferenceTo $referenceTo = null)
    {
        if (is_null($referenceTo) || (is_array($referenceTo) && empty($referenceTo))) {
            unset($this->ReferenceTo);
        } else {
            $this->ReferenceTo = $referenceTo;
        }
        return $this;
    }
    /**
     * Get RelationshipDomains value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRelationshipDomains()
    {
        return isset($this->RelationshipDomains) ? $this->RelationshipDomains : null;
    }
    /**
     * Set RelationshipDomains value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $relationshipDomains
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setRelationshipDomains(\NexusDigital/MiratelForce\StructType\QueryResult $relationshipDomains = null)
    {
        if (is_null($relationshipDomains) || (is_array($relationshipDomains) && empty($relationshipDomains))) {
            unset($this->RelationshipDomains);
        } else {
            $this->RelationshipDomains = $relationshipDomains;
        }
        return $this;
    }
    /**
     * Get RelationshipName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipName()
    {
        return isset($this->RelationshipName) ? $this->RelationshipName : null;
    }
    /**
     * Set RelationshipName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipName
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setRelationshipName($relationshipName = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipName) && !is_string($relationshipName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipName, true), gettype($relationshipName)), __LINE__);
        }
        if (is_null($relationshipName) || (is_array($relationshipName) && empty($relationshipName))) {
            unset($this->RelationshipName);
        } else {
            $this->RelationshipName = $relationshipName;
        }
        return $this;
    }
    /**
     * Get RunningUserFieldAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserFieldAccess|null
     */
    public function getRunningUserFieldAccess()
    {
        return isset($this->RunningUserFieldAccess) ? $this->RunningUserFieldAccess : null;
    }
    /**
     * Set RunningUserFieldAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserFieldAccess $runningUserFieldAccess
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setRunningUserFieldAccess(\NexusDigital/MiratelForce\StructType\UserFieldAccess $runningUserFieldAccess = null)
    {
        if (is_null($runningUserFieldAccess) || (is_array($runningUserFieldAccess) && empty($runningUserFieldAccess))) {
            unset($this->RunningUserFieldAccess);
        } else {
            $this->RunningUserFieldAccess = $runningUserFieldAccess;
        }
        return $this;
    }
    /**
     * Get RunningUserFieldAccessId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRunningUserFieldAccessId()
    {
        return isset($this->RunningUserFieldAccessId) ? $this->RunningUserFieldAccessId : null;
    }
    /**
     * Set RunningUserFieldAccessId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $runningUserFieldAccessId
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setRunningUserFieldAccessId($runningUserFieldAccessId = null)
    {
        // validation for constraint: string
        if (!is_null($runningUserFieldAccessId) && !is_string($runningUserFieldAccessId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($runningUserFieldAccessId, true), gettype($runningUserFieldAccessId)), __LINE__);
        }
        if (is_null($runningUserFieldAccessId) || (is_array($runningUserFieldAccessId) && empty($runningUserFieldAccessId))) {
            unset($this->RunningUserFieldAccessId);
        } else {
            $this->RunningUserFieldAccessId = $runningUserFieldAccessId;
        }
        return $this;
    }
    /**
     * Get Scale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getScale()
    {
        return isset($this->Scale) ? $this->Scale : null;
    }
    /**
     * Set Scale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $scale
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setScale($scale = null)
    {
        // validation for constraint: int
        if (!is_null($scale) && !(is_int($scale) || ctype_digit($scale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scale, true), gettype($scale)), __LINE__);
        }
        if (is_null($scale) || (is_array($scale) && empty($scale))) {
            unset($this->Scale);
        } else {
            $this->Scale = $scale;
        }
        return $this;
    }
    /**
     * Get SecurityClassification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityClassification()
    {
        return isset($this->SecurityClassification) ? $this->SecurityClassification : null;
    }
    /**
     * Set SecurityClassification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityClassification
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setSecurityClassification($securityClassification = null)
    {
        // validation for constraint: string
        if (!is_null($securityClassification) && !is_string($securityClassification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityClassification, true), gettype($securityClassification)), __LINE__);
        }
        if (is_null($securityClassification) || (is_array($securityClassification) && empty($securityClassification))) {
            unset($this->SecurityClassification);
        } else {
            $this->SecurityClassification = $securityClassification;
        }
        return $this;
    }
    /**
     * Get ServiceDataType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\DataType|null
     */
    public function getServiceDataType()
    {
        return isset($this->ServiceDataType) ? $this->ServiceDataType : null;
    }
    /**
     * Set ServiceDataType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\DataType $serviceDataType
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setServiceDataType(\NexusDigital/MiratelForce\StructType\DataType $serviceDataType = null)
    {
        if (is_null($serviceDataType) || (is_array($serviceDataType) && empty($serviceDataType))) {
            unset($this->ServiceDataType);
        } else {
            $this->ServiceDataType = $serviceDataType;
        }
        return $this;
    }
    /**
     * Get ServiceDataTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceDataTypeId()
    {
        return isset($this->ServiceDataTypeId) ? $this->ServiceDataTypeId : null;
    }
    /**
     * Set ServiceDataTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceDataTypeId
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setServiceDataTypeId($serviceDataTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDataTypeId) && !is_string($serviceDataTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDataTypeId, true), gettype($serviceDataTypeId)), __LINE__);
        }
        if (is_null($serviceDataTypeId) || (is_array($serviceDataTypeId) && empty($serviceDataTypeId))) {
            unset($this->ServiceDataTypeId);
        } else {
            $this->ServiceDataTypeId = $serviceDataTypeId;
        }
        return $this;
    }
    /**
     * Get ValueType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\DataType|null
     */
    public function getValueType()
    {
        return isset($this->ValueType) ? $this->ValueType : null;
    }
    /**
     * Set ValueType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\DataType $valueType
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setValueType(\NexusDigital/MiratelForce\StructType\DataType $valueType = null)
    {
        if (is_null($valueType) || (is_array($valueType) && empty($valueType))) {
            unset($this->ValueType);
        } else {
            $this->ValueType = $valueType;
        }
        return $this;
    }
    /**
     * Get ValueTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValueTypeId()
    {
        return isset($this->ValueTypeId) ? $this->ValueTypeId : null;
    }
    /**
     * Set ValueTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valueTypeId
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public function setValueTypeId($valueTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($valueTypeId) && !is_string($valueTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueTypeId, true), gettype($valueTypeId)), __LINE__);
        }
        if (is_null($valueTypeId) || (is_array($valueTypeId) && empty($valueTypeId))) {
            unset($this->ValueTypeId);
        } else {
            $this->ValueTypeId = $valueTypeId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
