<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeedComment StructType
 * @subpackage Structs
 */
class FeedComment extends SObject
{
    /**
     * The AuditableEntities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AuditableEntities;
    /**
     * The CommentBody
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommentBody;
    /**
     * The CommentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommentType;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The FeedAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $FeedAttachments;
    /**
     * The FeedItemId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $FeedItemId;
    /**
     * The FeedRevisions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $FeedRevisions;
    /**
     * The FeedThreadedComments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $FeedThreadedComments;
    /**
     * The HasEntityLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasEntityLinks;
    /**
     * The InsertedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $InsertedBy;
    /**
     * The InsertedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $InsertedById;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsRichText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRichText;
    /**
     * The IsVerified
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVerified;
    /**
     * The LastEditById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastEditById;
    /**
     * The LastEditDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastEditDate;
    /**
     * The NetworkUserHistoryRecentToFeedComment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NetworkUserHistoryRecentToFeedComment;
    /**
     * The ParentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentId;
    /**
     * The RelatedRecordId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $RelatedRecordId;
    /**
     * The Revision
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Revision;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The ThreadChildrenCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ThreadChildrenCount;
    /**
     * The ThreadLastUpdatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThreadLastUpdatedDate;
    /**
     * The ThreadLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ThreadLevel;
    /**
     * The ThreadParent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public $ThreadParent;
    /**
     * The ThreadParentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ThreadParentId;
    /**
     * Constructor method for FeedComment
     * @uses FeedComment::setAuditableEntities()
     * @uses FeedComment::setCommentBody()
     * @uses FeedComment::setCommentType()
     * @uses FeedComment::setCreatedBy()
     * @uses FeedComment::setCreatedById()
     * @uses FeedComment::setCreatedDate()
     * @uses FeedComment::setFeedAttachments()
     * @uses FeedComment::setFeedItemId()
     * @uses FeedComment::setFeedRevisions()
     * @uses FeedComment::setFeedThreadedComments()
     * @uses FeedComment::setHasEntityLinks()
     * @uses FeedComment::setInsertedBy()
     * @uses FeedComment::setInsertedById()
     * @uses FeedComment::setIsDeleted()
     * @uses FeedComment::setIsRichText()
     * @uses FeedComment::setIsVerified()
     * @uses FeedComment::setLastEditById()
     * @uses FeedComment::setLastEditDate()
     * @uses FeedComment::setNetworkUserHistoryRecentToFeedComment()
     * @uses FeedComment::setParentId()
     * @uses FeedComment::setRelatedRecordId()
     * @uses FeedComment::setRevision()
     * @uses FeedComment::setStatus()
     * @uses FeedComment::setSystemModstamp()
     * @uses FeedComment::setThreadChildrenCount()
     * @uses FeedComment::setThreadLastUpdatedDate()
     * @uses FeedComment::setThreadLevel()
     * @uses FeedComment::setThreadParent()
     * @uses FeedComment::setThreadParentId()
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $auditableEntities
     * @param string $commentBody
     * @param string $commentType
     * @param \NexusDigital/MiratelForce\StructType\SObject $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedAttachments
     * @param string $feedItemId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedRevisions
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedThreadedComments
     * @param bool $hasEntityLinks
     * @param \NexusDigital/MiratelForce\StructType\User $insertedBy
     * @param string $insertedById
     * @param bool $isDeleted
     * @param bool $isRichText
     * @param bool $isVerified
     * @param string $lastEditById
     * @param string $lastEditDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkUserHistoryRecentToFeedComment
     * @param string $parentId
     * @param string $relatedRecordId
     * @param int $revision
     * @param string $status
     * @param string $systemModstamp
     * @param int $threadChildrenCount
     * @param string $threadLastUpdatedDate
     * @param int $threadLevel
     * @param \NexusDigital/MiratelForce\StructType\FeedComment $threadParent
     * @param string $threadParentId
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\QueryResult $auditableEntities = null, $commentBody = null, $commentType = null, \NexusDigital/MiratelForce\StructType\SObject $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $feedAttachments = null, $feedItemId = null, \NexusDigital/MiratelForce\StructType\QueryResult $feedRevisions = null, \NexusDigital/MiratelForce\StructType\QueryResult $feedThreadedComments = null, $hasEntityLinks = null, \NexusDigital/MiratelForce\StructType\User $insertedBy = null, $insertedById = null, $isDeleted = null, $isRichText = null, $isVerified = null, $lastEditById = null, $lastEditDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $networkUserHistoryRecentToFeedComment = null, $parentId = null, $relatedRecordId = null, $revision = null, $status = null, $systemModstamp = null, $threadChildrenCount = null, $threadLastUpdatedDate = null, $threadLevel = null, \NexusDigital/MiratelForce\StructType\FeedComment $threadParent = null, $threadParentId = null)
    {
        $this
            ->setAuditableEntities($auditableEntities)
            ->setCommentBody($commentBody)
            ->setCommentType($commentType)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setFeedAttachments($feedAttachments)
            ->setFeedItemId($feedItemId)
            ->setFeedRevisions($feedRevisions)
            ->setFeedThreadedComments($feedThreadedComments)
            ->setHasEntityLinks($hasEntityLinks)
            ->setInsertedBy($insertedBy)
            ->setInsertedById($insertedById)
            ->setIsDeleted($isDeleted)
            ->setIsRichText($isRichText)
            ->setIsVerified($isVerified)
            ->setLastEditById($lastEditById)
            ->setLastEditDate($lastEditDate)
            ->setNetworkUserHistoryRecentToFeedComment($networkUserHistoryRecentToFeedComment)
            ->setParentId($parentId)
            ->setRelatedRecordId($relatedRecordId)
            ->setRevision($revision)
            ->setStatus($status)
            ->setSystemModstamp($systemModstamp)
            ->setThreadChildrenCount($threadChildrenCount)
            ->setThreadLastUpdatedDate($threadLastUpdatedDate)
            ->setThreadLevel($threadLevel)
            ->setThreadParent($threadParent)
            ->setThreadParentId($threadParentId);
    }
    /**
     * Get AuditableEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAuditableEntities()
    {
        return isset($this->AuditableEntities) ? $this->AuditableEntities : null;
    }
    /**
     * Set AuditableEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $auditableEntities
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setAuditableEntities(\NexusDigital/MiratelForce\StructType\QueryResult $auditableEntities = null)
    {
        if (is_null($auditableEntities) || (is_array($auditableEntities) && empty($auditableEntities))) {
            unset($this->AuditableEntities);
        } else {
            $this->AuditableEntities = $auditableEntities;
        }
        return $this;
    }
    /**
     * Get CommentBody value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommentBody()
    {
        return isset($this->CommentBody) ? $this->CommentBody : null;
    }
    /**
     * Set CommentBody value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commentBody
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setCommentBody($commentBody = null)
    {
        // validation for constraint: string
        if (!is_null($commentBody) && !is_string($commentBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentBody, true), gettype($commentBody)), __LINE__);
        }
        if (is_null($commentBody) || (is_array($commentBody) && empty($commentBody))) {
            unset($this->CommentBody);
        } else {
            $this->CommentBody = $commentBody;
        }
        return $this;
    }
    /**
     * Get CommentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommentType()
    {
        return isset($this->CommentType) ? $this->CommentType : null;
    }
    /**
     * Set CommentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commentType
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setCommentType($commentType = null)
    {
        // validation for constraint: string
        if (!is_null($commentType) && !is_string($commentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentType, true), gettype($commentType)), __LINE__);
        }
        if (is_null($commentType) || (is_array($commentType) && empty($commentType))) {
            unset($this->CommentType);
        } else {
            $this->CommentType = $commentType;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $createdBy
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\SObject $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get FeedAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeedAttachments()
    {
        return isset($this->FeedAttachments) ? $this->FeedAttachments : null;
    }
    /**
     * Set FeedAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedAttachments
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setFeedAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $feedAttachments = null)
    {
        if (is_null($feedAttachments) || (is_array($feedAttachments) && empty($feedAttachments))) {
            unset($this->FeedAttachments);
        } else {
            $this->FeedAttachments = $feedAttachments;
        }
        return $this;
    }
    /**
     * Get FeedItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFeedItemId()
    {
        return isset($this->FeedItemId) ? $this->FeedItemId : null;
    }
    /**
     * Set FeedItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $feedItemId
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setFeedItemId($feedItemId = null)
    {
        // validation for constraint: string
        if (!is_null($feedItemId) && !is_string($feedItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feedItemId, true), gettype($feedItemId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($feedItemId) && mb_strlen($feedItemId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($feedItemId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($feedItemId) && !preg_match('/[a-zA-Z0-9]{18}/', $feedItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($feedItemId, true)), __LINE__);
        }
        if (is_null($feedItemId) || (is_array($feedItemId) && empty($feedItemId))) {
            unset($this->FeedItemId);
        } else {
            $this->FeedItemId = $feedItemId;
        }
        return $this;
    }
    /**
     * Get FeedRevisions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeedRevisions()
    {
        return isset($this->FeedRevisions) ? $this->FeedRevisions : null;
    }
    /**
     * Set FeedRevisions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedRevisions
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setFeedRevisions(\NexusDigital/MiratelForce\StructType\QueryResult $feedRevisions = null)
    {
        if (is_null($feedRevisions) || (is_array($feedRevisions) && empty($feedRevisions))) {
            unset($this->FeedRevisions);
        } else {
            $this->FeedRevisions = $feedRevisions;
        }
        return $this;
    }
    /**
     * Get FeedThreadedComments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeedThreadedComments()
    {
        return isset($this->FeedThreadedComments) ? $this->FeedThreadedComments : null;
    }
    /**
     * Set FeedThreadedComments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedThreadedComments
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setFeedThreadedComments(\NexusDigital/MiratelForce\StructType\QueryResult $feedThreadedComments = null)
    {
        if (is_null($feedThreadedComments) || (is_array($feedThreadedComments) && empty($feedThreadedComments))) {
            unset($this->FeedThreadedComments);
        } else {
            $this->FeedThreadedComments = $feedThreadedComments;
        }
        return $this;
    }
    /**
     * Get HasEntityLinks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasEntityLinks()
    {
        return isset($this->HasEntityLinks) ? $this->HasEntityLinks : null;
    }
    /**
     * Set HasEntityLinks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasEntityLinks
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setHasEntityLinks($hasEntityLinks = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasEntityLinks) && !is_bool($hasEntityLinks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasEntityLinks, true), gettype($hasEntityLinks)), __LINE__);
        }
        if (is_null($hasEntityLinks) || (is_array($hasEntityLinks) && empty($hasEntityLinks))) {
            unset($this->HasEntityLinks);
        } else {
            $this->HasEntityLinks = $hasEntityLinks;
        }
        return $this;
    }
    /**
     * Get InsertedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getInsertedBy()
    {
        return isset($this->InsertedBy) ? $this->InsertedBy : null;
    }
    /**
     * Set InsertedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $insertedBy
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setInsertedBy(\NexusDigital/MiratelForce\StructType\User $insertedBy = null)
    {
        if (is_null($insertedBy) || (is_array($insertedBy) && empty($insertedBy))) {
            unset($this->InsertedBy);
        } else {
            $this->InsertedBy = $insertedBy;
        }
        return $this;
    }
    /**
     * Get InsertedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsertedById()
    {
        return isset($this->InsertedById) ? $this->InsertedById : null;
    }
    /**
     * Set InsertedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $insertedById
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setInsertedById($insertedById = null)
    {
        // validation for constraint: string
        if (!is_null($insertedById) && !is_string($insertedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insertedById, true), gettype($insertedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($insertedById) && mb_strlen($insertedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($insertedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($insertedById) && !preg_match('/[a-zA-Z0-9]{18}/', $insertedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($insertedById, true)), __LINE__);
        }
        if (is_null($insertedById) || (is_array($insertedById) && empty($insertedById))) {
            unset($this->InsertedById);
        } else {
            $this->InsertedById = $insertedById;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsRichText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRichText()
    {
        return isset($this->IsRichText) ? $this->IsRichText : null;
    }
    /**
     * Set IsRichText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRichText
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setIsRichText($isRichText = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRichText) && !is_bool($isRichText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRichText, true), gettype($isRichText)), __LINE__);
        }
        if (is_null($isRichText) || (is_array($isRichText) && empty($isRichText))) {
            unset($this->IsRichText);
        } else {
            $this->IsRichText = $isRichText;
        }
        return $this;
    }
    /**
     * Get IsVerified value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVerified()
    {
        return isset($this->IsVerified) ? $this->IsVerified : null;
    }
    /**
     * Set IsVerified value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVerified
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setIsVerified($isVerified = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVerified) && !is_bool($isVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVerified, true), gettype($isVerified)), __LINE__);
        }
        if (is_null($isVerified) || (is_array($isVerified) && empty($isVerified))) {
            unset($this->IsVerified);
        } else {
            $this->IsVerified = $isVerified;
        }
        return $this;
    }
    /**
     * Get LastEditById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastEditById()
    {
        return isset($this->LastEditById) ? $this->LastEditById : null;
    }
    /**
     * Set LastEditById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastEditById
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setLastEditById($lastEditById = null)
    {
        // validation for constraint: string
        if (!is_null($lastEditById) && !is_string($lastEditById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastEditById, true), gettype($lastEditById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastEditById) && mb_strlen($lastEditById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastEditById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastEditById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastEditById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastEditById, true)), __LINE__);
        }
        if (is_null($lastEditById) || (is_array($lastEditById) && empty($lastEditById))) {
            unset($this->LastEditById);
        } else {
            $this->LastEditById = $lastEditById;
        }
        return $this;
    }
    /**
     * Get LastEditDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastEditDate()
    {
        return isset($this->LastEditDate) ? $this->LastEditDate : null;
    }
    /**
     * Set LastEditDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastEditDate
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setLastEditDate($lastEditDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastEditDate) && !is_string($lastEditDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastEditDate, true), gettype($lastEditDate)), __LINE__);
        }
        if (is_null($lastEditDate) || (is_array($lastEditDate) && empty($lastEditDate))) {
            unset($this->LastEditDate);
        } else {
            $this->LastEditDate = $lastEditDate;
        }
        return $this;
    }
    /**
     * Get NetworkUserHistoryRecentToFeedComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNetworkUserHistoryRecentToFeedComment()
    {
        return isset($this->NetworkUserHistoryRecentToFeedComment) ? $this->NetworkUserHistoryRecentToFeedComment : null;
    }
    /**
     * Set NetworkUserHistoryRecentToFeedComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkUserHistoryRecentToFeedComment
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setNetworkUserHistoryRecentToFeedComment(\NexusDigital/MiratelForce\StructType\QueryResult $networkUserHistoryRecentToFeedComment = null)
    {
        if (is_null($networkUserHistoryRecentToFeedComment) || (is_array($networkUserHistoryRecentToFeedComment) && empty($networkUserHistoryRecentToFeedComment))) {
            unset($this->NetworkUserHistoryRecentToFeedComment);
        } else {
            $this->NetworkUserHistoryRecentToFeedComment = $networkUserHistoryRecentToFeedComment;
        }
        return $this;
    }
    /**
     * Get ParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->ParentId) ? $this->ParentId : null;
    }
    /**
     * Set ParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentId) && mb_strlen($parentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentId, true)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->ParentId);
        } else {
            $this->ParentId = $parentId;
        }
        return $this;
    }
    /**
     * Get RelatedRecordId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedRecordId()
    {
        return isset($this->RelatedRecordId) ? $this->RelatedRecordId : null;
    }
    /**
     * Set RelatedRecordId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedRecordId
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setRelatedRecordId($relatedRecordId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedRecordId) && !is_string($relatedRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedRecordId, true), gettype($relatedRecordId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($relatedRecordId) && mb_strlen($relatedRecordId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($relatedRecordId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($relatedRecordId) && !preg_match('/[a-zA-Z0-9]{18}/', $relatedRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($relatedRecordId, true)), __LINE__);
        }
        if (is_null($relatedRecordId) || (is_array($relatedRecordId) && empty($relatedRecordId))) {
            unset($this->RelatedRecordId);
        } else {
            $this->RelatedRecordId = $relatedRecordId;
        }
        return $this;
    }
    /**
     * Get Revision value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRevision()
    {
        return isset($this->Revision) ? $this->Revision : null;
    }
    /**
     * Set Revision value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $revision
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setRevision($revision = null)
    {
        // validation for constraint: int
        if (!is_null($revision) && !(is_int($revision) || ctype_digit($revision))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($revision, true), gettype($revision)), __LINE__);
        }
        if (is_null($revision) || (is_array($revision) && empty($revision))) {
            unset($this->Revision);
        } else {
            $this->Revision = $revision;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get ThreadChildrenCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getThreadChildrenCount()
    {
        return isset($this->ThreadChildrenCount) ? $this->ThreadChildrenCount : null;
    }
    /**
     * Set ThreadChildrenCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $threadChildrenCount
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setThreadChildrenCount($threadChildrenCount = null)
    {
        // validation for constraint: int
        if (!is_null($threadChildrenCount) && !(is_int($threadChildrenCount) || ctype_digit($threadChildrenCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($threadChildrenCount, true), gettype($threadChildrenCount)), __LINE__);
        }
        if (is_null($threadChildrenCount) || (is_array($threadChildrenCount) && empty($threadChildrenCount))) {
            unset($this->ThreadChildrenCount);
        } else {
            $this->ThreadChildrenCount = $threadChildrenCount;
        }
        return $this;
    }
    /**
     * Get ThreadLastUpdatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThreadLastUpdatedDate()
    {
        return isset($this->ThreadLastUpdatedDate) ? $this->ThreadLastUpdatedDate : null;
    }
    /**
     * Set ThreadLastUpdatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $threadLastUpdatedDate
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setThreadLastUpdatedDate($threadLastUpdatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($threadLastUpdatedDate) && !is_string($threadLastUpdatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($threadLastUpdatedDate, true), gettype($threadLastUpdatedDate)), __LINE__);
        }
        if (is_null($threadLastUpdatedDate) || (is_array($threadLastUpdatedDate) && empty($threadLastUpdatedDate))) {
            unset($this->ThreadLastUpdatedDate);
        } else {
            $this->ThreadLastUpdatedDate = $threadLastUpdatedDate;
        }
        return $this;
    }
    /**
     * Get ThreadLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getThreadLevel()
    {
        return isset($this->ThreadLevel) ? $this->ThreadLevel : null;
    }
    /**
     * Set ThreadLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $threadLevel
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setThreadLevel($threadLevel = null)
    {
        // validation for constraint: int
        if (!is_null($threadLevel) && !(is_int($threadLevel) || ctype_digit($threadLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($threadLevel, true), gettype($threadLevel)), __LINE__);
        }
        if (is_null($threadLevel) || (is_array($threadLevel) && empty($threadLevel))) {
            unset($this->ThreadLevel);
        } else {
            $this->ThreadLevel = $threadLevel;
        }
        return $this;
    }
    /**
     * Get ThreadParent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\FeedComment|null
     */
    public function getThreadParent()
    {
        return isset($this->ThreadParent) ? $this->ThreadParent : null;
    }
    /**
     * Set ThreadParent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\FeedComment $threadParent
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setThreadParent(\NexusDigital/MiratelForce\StructType\FeedComment $threadParent = null)
    {
        if (is_null($threadParent) || (is_array($threadParent) && empty($threadParent))) {
            unset($this->ThreadParent);
        } else {
            $this->ThreadParent = $threadParent;
        }
        return $this;
    }
    /**
     * Get ThreadParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThreadParentId()
    {
        return isset($this->ThreadParentId) ? $this->ThreadParentId : null;
    }
    /**
     * Set ThreadParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $threadParentId
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public function setThreadParentId($threadParentId = null)
    {
        // validation for constraint: string
        if (!is_null($threadParentId) && !is_string($threadParentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($threadParentId, true), gettype($threadParentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($threadParentId) && mb_strlen($threadParentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($threadParentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($threadParentId) && !preg_match('/[a-zA-Z0-9]{18}/', $threadParentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($threadParentId, true)), __LINE__);
        }
        if (is_null($threadParentId) || (is_array($threadParentId) && empty($threadParentId))) {
            unset($this->ThreadParentId);
        } else {
            $this->ThreadParentId = $threadParentId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
