<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExternalDataSource StructType
 * @subpackage Structs
 */
class ExternalDataSource extends SObject
{
    /**
     * The AuthProvider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public $AuthProvider;
    /**
     * The AuthProviderId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AuthProviderId;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The CustomConfiguration
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomConfiguration;
    /**
     * The CustomHttpHeaders
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CustomHttpHeaders;
    /**
     * The DeveloperName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeveloperName;
    /**
     * The Endpoint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Endpoint;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsWritable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsWritable;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The LargeIcon
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\StaticResource
     */
    public $LargeIcon;
    /**
     * The LargeIconId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LargeIconId;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The MasterLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterLabel;
    /**
     * The NamespacePrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NamespacePrefix;
    /**
     * The PrincipalType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrincipalType;
    /**
     * The Protocol
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Protocol;
    /**
     * The Repository
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Repository;
    /**
     * The SetupEntityAccessItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $SetupEntityAccessItems;
    /**
     * The SmallIcon
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\StaticResource
     */
    public $SmallIcon;
    /**
     * The SmallIconId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $SmallIconId;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The UserAuths
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $UserAuths;
    /**
     * Constructor method for ExternalDataSource
     * @uses ExternalDataSource::setAuthProvider()
     * @uses ExternalDataSource::setAuthProviderId()
     * @uses ExternalDataSource::setCreatedBy()
     * @uses ExternalDataSource::setCreatedById()
     * @uses ExternalDataSource::setCreatedDate()
     * @uses ExternalDataSource::setCustomConfiguration()
     * @uses ExternalDataSource::setCustomHttpHeaders()
     * @uses ExternalDataSource::setDeveloperName()
     * @uses ExternalDataSource::setEndpoint()
     * @uses ExternalDataSource::setIsDeleted()
     * @uses ExternalDataSource::setIsWritable()
     * @uses ExternalDataSource::setLanguage()
     * @uses ExternalDataSource::setLargeIcon()
     * @uses ExternalDataSource::setLargeIconId()
     * @uses ExternalDataSource::setLastModifiedBy()
     * @uses ExternalDataSource::setLastModifiedById()
     * @uses ExternalDataSource::setLastModifiedDate()
     * @uses ExternalDataSource::setMasterLabel()
     * @uses ExternalDataSource::setNamespacePrefix()
     * @uses ExternalDataSource::setPrincipalType()
     * @uses ExternalDataSource::setProtocol()
     * @uses ExternalDataSource::setRepository()
     * @uses ExternalDataSource::setSetupEntityAccessItems()
     * @uses ExternalDataSource::setSmallIcon()
     * @uses ExternalDataSource::setSmallIconId()
     * @uses ExternalDataSource::setSystemModstamp()
     * @uses ExternalDataSource::setType()
     * @uses ExternalDataSource::setUserAuths()
     * @param \NexusDigital/MiratelForce\StructType\AuthProvider $authProvider
     * @param string $authProviderId
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $customConfiguration
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $customHttpHeaders
     * @param string $developerName
     * @param string $endpoint
     * @param bool $isDeleted
     * @param bool $isWritable
     * @param string $language
     * @param \NexusDigital/MiratelForce\StructType\StaticResource $largeIcon
     * @param string $largeIconId
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $masterLabel
     * @param string $namespacePrefix
     * @param string $principalType
     * @param string $protocol
     * @param string $repository
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $setupEntityAccessItems
     * @param \NexusDigital/MiratelForce\StructType\StaticResource $smallIcon
     * @param string $smallIconId
     * @param string $systemModstamp
     * @param string $type
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $userAuths
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\AuthProvider $authProvider = null, $authProviderId = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $customConfiguration = null, \NexusDigital/MiratelForce\StructType\QueryResult $customHttpHeaders = null, $developerName = null, $endpoint = null, $isDeleted = null, $isWritable = null, $language = null, \NexusDigital/MiratelForce\StructType\StaticResource $largeIcon = null, $largeIconId = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $masterLabel = null, $namespacePrefix = null, $principalType = null, $protocol = null, $repository = null, \NexusDigital/MiratelForce\StructType\QueryResult $setupEntityAccessItems = null, \NexusDigital/MiratelForce\StructType\StaticResource $smallIcon = null, $smallIconId = null, $systemModstamp = null, $type = null, \NexusDigital/MiratelForce\StructType\QueryResult $userAuths = null)
    {
        $this
            ->setAuthProvider($authProvider)
            ->setAuthProviderId($authProviderId)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setCustomConfiguration($customConfiguration)
            ->setCustomHttpHeaders($customHttpHeaders)
            ->setDeveloperName($developerName)
            ->setEndpoint($endpoint)
            ->setIsDeleted($isDeleted)
            ->setIsWritable($isWritable)
            ->setLanguage($language)
            ->setLargeIcon($largeIcon)
            ->setLargeIconId($largeIconId)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setMasterLabel($masterLabel)
            ->setNamespacePrefix($namespacePrefix)
            ->setPrincipalType($principalType)
            ->setProtocol($protocol)
            ->setRepository($repository)
            ->setSetupEntityAccessItems($setupEntityAccessItems)
            ->setSmallIcon($smallIcon)
            ->setSmallIconId($smallIconId)
            ->setSystemModstamp($systemModstamp)
            ->setType($type)
            ->setUserAuths($userAuths);
    }
    /**
     * Get AuthProvider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider|null
     */
    public function getAuthProvider()
    {
        return isset($this->AuthProvider) ? $this->AuthProvider : null;
    }
    /**
     * Set AuthProvider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\AuthProvider $authProvider
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setAuthProvider(\NexusDigital/MiratelForce\StructType\AuthProvider $authProvider = null)
    {
        if (is_null($authProvider) || (is_array($authProvider) && empty($authProvider))) {
            unset($this->AuthProvider);
        } else {
            $this->AuthProvider = $authProvider;
        }
        return $this;
    }
    /**
     * Get AuthProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthProviderId()
    {
        return isset($this->AuthProviderId) ? $this->AuthProviderId : null;
    }
    /**
     * Set AuthProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authProviderId
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setAuthProviderId($authProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($authProviderId) && !is_string($authProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authProviderId, true), gettype($authProviderId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($authProviderId) && mb_strlen($authProviderId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($authProviderId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($authProviderId) && !preg_match('/[a-zA-Z0-9]{18}/', $authProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($authProviderId, true)), __LINE__);
        }
        if (is_null($authProviderId) || (is_array($authProviderId) && empty($authProviderId))) {
            unset($this->AuthProviderId);
        } else {
            $this->AuthProviderId = $authProviderId;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get CustomConfiguration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomConfiguration()
    {
        return isset($this->CustomConfiguration) ? $this->CustomConfiguration : null;
    }
    /**
     * Set CustomConfiguration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customConfiguration
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setCustomConfiguration($customConfiguration = null)
    {
        // validation for constraint: string
        if (!is_null($customConfiguration) && !is_string($customConfiguration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customConfiguration, true), gettype($customConfiguration)), __LINE__);
        }
        if (is_null($customConfiguration) || (is_array($customConfiguration) && empty($customConfiguration))) {
            unset($this->CustomConfiguration);
        } else {
            $this->CustomConfiguration = $customConfiguration;
        }
        return $this;
    }
    /**
     * Get CustomHttpHeaders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCustomHttpHeaders()
    {
        return isset($this->CustomHttpHeaders) ? $this->CustomHttpHeaders : null;
    }
    /**
     * Set CustomHttpHeaders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $customHttpHeaders
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setCustomHttpHeaders(\NexusDigital/MiratelForce\StructType\QueryResult $customHttpHeaders = null)
    {
        if (is_null($customHttpHeaders) || (is_array($customHttpHeaders) && empty($customHttpHeaders))) {
            unset($this->CustomHttpHeaders);
        } else {
            $this->CustomHttpHeaders = $customHttpHeaders;
        }
        return $this;
    }
    /**
     * Get DeveloperName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeveloperName()
    {
        return isset($this->DeveloperName) ? $this->DeveloperName : null;
    }
    /**
     * Set DeveloperName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $developerName
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setDeveloperName($developerName = null)
    {
        // validation for constraint: string
        if (!is_null($developerName) && !is_string($developerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($developerName, true), gettype($developerName)), __LINE__);
        }
        if (is_null($developerName) || (is_array($developerName) && empty($developerName))) {
            unset($this->DeveloperName);
        } else {
            $this->DeveloperName = $developerName;
        }
        return $this;
    }
    /**
     * Get Endpoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndpoint()
    {
        return isset($this->Endpoint) ? $this->Endpoint : null;
    }
    /**
     * Set Endpoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endpoint
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setEndpoint($endpoint = null)
    {
        // validation for constraint: string
        if (!is_null($endpoint) && !is_string($endpoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endpoint, true), gettype($endpoint)), __LINE__);
        }
        if (is_null($endpoint) || (is_array($endpoint) && empty($endpoint))) {
            unset($this->Endpoint);
        } else {
            $this->Endpoint = $endpoint;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsWritable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsWritable()
    {
        return isset($this->IsWritable) ? $this->IsWritable : null;
    }
    /**
     * Set IsWritable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isWritable
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setIsWritable($isWritable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWritable) && !is_bool($isWritable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isWritable, true), gettype($isWritable)), __LINE__);
        }
        if (is_null($isWritable) || (is_array($isWritable) && empty($isWritable))) {
            unset($this->IsWritable);
        } else {
            $this->IsWritable = $isWritable;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get LargeIcon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\StaticResource|null
     */
    public function getLargeIcon()
    {
        return isset($this->LargeIcon) ? $this->LargeIcon : null;
    }
    /**
     * Set LargeIcon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\StaticResource $largeIcon
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setLargeIcon(\NexusDigital/MiratelForce\StructType\StaticResource $largeIcon = null)
    {
        if (is_null($largeIcon) || (is_array($largeIcon) && empty($largeIcon))) {
            unset($this->LargeIcon);
        } else {
            $this->LargeIcon = $largeIcon;
        }
        return $this;
    }
    /**
     * Get LargeIconId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLargeIconId()
    {
        return isset($this->LargeIconId) ? $this->LargeIconId : null;
    }
    /**
     * Set LargeIconId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $largeIconId
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setLargeIconId($largeIconId = null)
    {
        // validation for constraint: string
        if (!is_null($largeIconId) && !is_string($largeIconId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($largeIconId, true), gettype($largeIconId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($largeIconId) && mb_strlen($largeIconId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($largeIconId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($largeIconId) && !preg_match('/[a-zA-Z0-9]{18}/', $largeIconId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($largeIconId, true)), __LINE__);
        }
        if (is_null($largeIconId) || (is_array($largeIconId) && empty($largeIconId))) {
            unset($this->LargeIconId);
        } else {
            $this->LargeIconId = $largeIconId;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get MasterLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterLabel()
    {
        return isset($this->MasterLabel) ? $this->MasterLabel : null;
    }
    /**
     * Set MasterLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterLabel
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setMasterLabel($masterLabel = null)
    {
        // validation for constraint: string
        if (!is_null($masterLabel) && !is_string($masterLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterLabel, true), gettype($masterLabel)), __LINE__);
        }
        if (is_null($masterLabel) || (is_array($masterLabel) && empty($masterLabel))) {
            unset($this->MasterLabel);
        } else {
            $this->MasterLabel = $masterLabel;
        }
        return $this;
    }
    /**
     * Get NamespacePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNamespacePrefix()
    {
        return isset($this->NamespacePrefix) ? $this->NamespacePrefix : null;
    }
    /**
     * Set NamespacePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $namespacePrefix
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setNamespacePrefix($namespacePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($namespacePrefix) && !is_string($namespacePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namespacePrefix, true), gettype($namespacePrefix)), __LINE__);
        }
        if (is_null($namespacePrefix) || (is_array($namespacePrefix) && empty($namespacePrefix))) {
            unset($this->NamespacePrefix);
        } else {
            $this->NamespacePrefix = $namespacePrefix;
        }
        return $this;
    }
    /**
     * Get PrincipalType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrincipalType()
    {
        return isset($this->PrincipalType) ? $this->PrincipalType : null;
    }
    /**
     * Set PrincipalType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $principalType
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setPrincipalType($principalType = null)
    {
        // validation for constraint: string
        if (!is_null($principalType) && !is_string($principalType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($principalType, true), gettype($principalType)), __LINE__);
        }
        if (is_null($principalType) || (is_array($principalType) && empty($principalType))) {
            unset($this->PrincipalType);
        } else {
            $this->PrincipalType = $principalType;
        }
        return $this;
    }
    /**
     * Get Protocol value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProtocol()
    {
        return isset($this->Protocol) ? $this->Protocol : null;
    }
    /**
     * Set Protocol value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $protocol
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: string
        if (!is_null($protocol) && !is_string($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($protocol, true), gettype($protocol)), __LINE__);
        }
        if (is_null($protocol) || (is_array($protocol) && empty($protocol))) {
            unset($this->Protocol);
        } else {
            $this->Protocol = $protocol;
        }
        return $this;
    }
    /**
     * Get Repository value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRepository()
    {
        return isset($this->Repository) ? $this->Repository : null;
    }
    /**
     * Set Repository value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $repository
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setRepository($repository = null)
    {
        // validation for constraint: string
        if (!is_null($repository) && !is_string($repository)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repository, true), gettype($repository)), __LINE__);
        }
        if (is_null($repository) || (is_array($repository) && empty($repository))) {
            unset($this->Repository);
        } else {
            $this->Repository = $repository;
        }
        return $this;
    }
    /**
     * Get SetupEntityAccessItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getSetupEntityAccessItems()
    {
        return isset($this->SetupEntityAccessItems) ? $this->SetupEntityAccessItems : null;
    }
    /**
     * Set SetupEntityAccessItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $setupEntityAccessItems
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setSetupEntityAccessItems(\NexusDigital/MiratelForce\StructType\QueryResult $setupEntityAccessItems = null)
    {
        if (is_null($setupEntityAccessItems) || (is_array($setupEntityAccessItems) && empty($setupEntityAccessItems))) {
            unset($this->SetupEntityAccessItems);
        } else {
            $this->SetupEntityAccessItems = $setupEntityAccessItems;
        }
        return $this;
    }
    /**
     * Get SmallIcon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\StaticResource|null
     */
    public function getSmallIcon()
    {
        return isset($this->SmallIcon) ? $this->SmallIcon : null;
    }
    /**
     * Set SmallIcon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\StaticResource $smallIcon
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setSmallIcon(\NexusDigital/MiratelForce\StructType\StaticResource $smallIcon = null)
    {
        if (is_null($smallIcon) || (is_array($smallIcon) && empty($smallIcon))) {
            unset($this->SmallIcon);
        } else {
            $this->SmallIcon = $smallIcon;
        }
        return $this;
    }
    /**
     * Get SmallIconId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSmallIconId()
    {
        return isset($this->SmallIconId) ? $this->SmallIconId : null;
    }
    /**
     * Set SmallIconId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $smallIconId
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setSmallIconId($smallIconId = null)
    {
        // validation for constraint: string
        if (!is_null($smallIconId) && !is_string($smallIconId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($smallIconId, true), gettype($smallIconId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($smallIconId) && mb_strlen($smallIconId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($smallIconId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($smallIconId) && !preg_match('/[a-zA-Z0-9]{18}/', $smallIconId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($smallIconId, true)), __LINE__);
        }
        if (is_null($smallIconId) || (is_array($smallIconId) && empty($smallIconId))) {
            unset($this->SmallIconId);
        } else {
            $this->SmallIconId = $smallIconId;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UserAuths value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getUserAuths()
    {
        return isset($this->UserAuths) ? $this->UserAuths : null;
    }
    /**
     * Set UserAuths value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $userAuths
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public function setUserAuths(\NexusDigital/MiratelForce\StructType\QueryResult $userAuths = null)
    {
        if (is_null($userAuths) || (is_array($userAuths) && empty($userAuths))) {
            unset($this->UserAuths);
        } else {
            $this->UserAuths = $userAuths;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
