<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailMessageRelation StructType
 * @subpackage Structs
 */
class EmailMessageRelation extends SObject
{
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The EmailMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public $EmailMessage;
    /**
     * The EmailMessageId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $EmailMessageId;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The Relation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $Relation;
    /**
     * The RelationAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelationAddress;
    /**
     * The RelationId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $RelationId;
    /**
     * The RelationObjectType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelationObjectType;
    /**
     * The RelationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelationType;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for EmailMessageRelation
     * @uses EmailMessageRelation::setCreatedBy()
     * @uses EmailMessageRelation::setCreatedById()
     * @uses EmailMessageRelation::setCreatedDate()
     * @uses EmailMessageRelation::setEmailMessage()
     * @uses EmailMessageRelation::setEmailMessageId()
     * @uses EmailMessageRelation::setIsDeleted()
     * @uses EmailMessageRelation::setRelation()
     * @uses EmailMessageRelation::setRelationAddress()
     * @uses EmailMessageRelation::setRelationId()
     * @uses EmailMessageRelation::setRelationObjectType()
     * @uses EmailMessageRelation::setRelationType()
     * @uses EmailMessageRelation::setSystemModstamp()
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\EmailMessage $emailMessage
     * @param string $emailMessageId
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\SObject $relation
     * @param string $relationAddress
     * @param string $relationId
     * @param string $relationObjectType
     * @param string $relationType
     * @param string $systemModstamp
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\EmailMessage $emailMessage = null, $emailMessageId = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\SObject $relation = null, $relationAddress = null, $relationId = null, $relationObjectType = null, $relationType = null, $systemModstamp = null)
    {
        $this
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setEmailMessage($emailMessage)
            ->setEmailMessageId($emailMessageId)
            ->setIsDeleted($isDeleted)
            ->setRelation($relation)
            ->setRelationAddress($relationAddress)
            ->setRelationId($relationId)
            ->setRelationObjectType($relationObjectType)
            ->setRelationType($relationType)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\EmailMessageRelation
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\EmailMessageRelation
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\EmailMessageRelation
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get EmailMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage|null
     */
    public function getEmailMessage()
    {
        return isset($this->EmailMessage) ? $this->EmailMessage : null;
    }
    /**
     * Set EmailMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\EmailMessage $emailMessage
     * @return \NexusDigital/MiratelForce\StructType\EmailMessageRelation
     */
    public function setEmailMessage(\NexusDigital/MiratelForce\StructType\EmailMessage $emailMessage = null)
    {
        if (is_null($emailMessage) || (is_array($emailMessage) && empty($emailMessage))) {
            unset($this->EmailMessage);
        } else {
            $this->EmailMessage = $emailMessage;
        }
        return $this;
    }
    /**
     * Get EmailMessageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailMessageId()
    {
        return isset($this->EmailMessageId) ? $this->EmailMessageId : null;
    }
    /**
     * Set EmailMessageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailMessageId
     * @return \NexusDigital/MiratelForce\StructType\EmailMessageRelation
     */
    public function setEmailMessageId($emailMessageId = null)
    {
        // validation for constraint: string
        if (!is_null($emailMessageId) && !is_string($emailMessageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailMessageId, true), gettype($emailMessageId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($emailMessageId) && mb_strlen($emailMessageId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($emailMessageId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($emailMessageId) && !preg_match('/[a-zA-Z0-9]{18}/', $emailMessageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($emailMessageId, true)), __LINE__);
        }
        if (is_null($emailMessageId) || (is_array($emailMessageId) && empty($emailMessageId))) {
            unset($this->EmailMessageId);
        } else {
            $this->EmailMessageId = $emailMessageId;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\EmailMessageRelation
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get Relation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getRelation()
    {
        return isset($this->Relation) ? $this->Relation : null;
    }
    /**
     * Set Relation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $relation
     * @return \NexusDigital/MiratelForce\StructType\EmailMessageRelation
     */
    public function setRelation(\NexusDigital/MiratelForce\StructType\SObject $relation = null)
    {
        if (is_null($relation) || (is_array($relation) && empty($relation))) {
            unset($this->Relation);
        } else {
            $this->Relation = $relation;
        }
        return $this;
    }
    /**
     * Get RelationAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationAddress()
    {
        return isset($this->RelationAddress) ? $this->RelationAddress : null;
    }
    /**
     * Set RelationAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationAddress
     * @return \NexusDigital/MiratelForce\StructType\EmailMessageRelation
     */
    public function setRelationAddress($relationAddress = null)
    {
        // validation for constraint: string
        if (!is_null($relationAddress) && !is_string($relationAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationAddress, true), gettype($relationAddress)), __LINE__);
        }
        if (is_null($relationAddress) || (is_array($relationAddress) && empty($relationAddress))) {
            unset($this->RelationAddress);
        } else {
            $this->RelationAddress = $relationAddress;
        }
        return $this;
    }
    /**
     * Get RelationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationId()
    {
        return isset($this->RelationId) ? $this->RelationId : null;
    }
    /**
     * Set RelationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationId
     * @return \NexusDigital/MiratelForce\StructType\EmailMessageRelation
     */
    public function setRelationId($relationId = null)
    {
        // validation for constraint: string
        if (!is_null($relationId) && !is_string($relationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationId, true), gettype($relationId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($relationId) && mb_strlen($relationId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($relationId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($relationId) && !preg_match('/[a-zA-Z0-9]{18}/', $relationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($relationId, true)), __LINE__);
        }
        if (is_null($relationId) || (is_array($relationId) && empty($relationId))) {
            unset($this->RelationId);
        } else {
            $this->RelationId = $relationId;
        }
        return $this;
    }
    /**
     * Get RelationObjectType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationObjectType()
    {
        return isset($this->RelationObjectType) ? $this->RelationObjectType : null;
    }
    /**
     * Set RelationObjectType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationObjectType
     * @return \NexusDigital/MiratelForce\StructType\EmailMessageRelation
     */
    public function setRelationObjectType($relationObjectType = null)
    {
        // validation for constraint: string
        if (!is_null($relationObjectType) && !is_string($relationObjectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationObjectType, true), gettype($relationObjectType)), __LINE__);
        }
        if (is_null($relationObjectType) || (is_array($relationObjectType) && empty($relationObjectType))) {
            unset($this->RelationObjectType);
        } else {
            $this->RelationObjectType = $relationObjectType;
        }
        return $this;
    }
    /**
     * Get RelationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationType()
    {
        return isset($this->RelationType) ? $this->RelationType : null;
    }
    /**
     * Set RelationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationType
     * @return \NexusDigital/MiratelForce\StructType\EmailMessageRelation
     */
    public function setRelationType($relationType = null)
    {
        // validation for constraint: string
        if (!is_null($relationType) && !is_string($relationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationType, true), gettype($relationType)), __LINE__);
        }
        if (is_null($relationType) || (is_array($relationType) && empty($relationType))) {
            unset($this->RelationType);
        } else {
            $this->RelationType = $relationType;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\EmailMessageRelation
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\EmailMessageRelation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
