<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DescribeThemeItem StructType
 * @subpackage Structs
 */
class DescribeThemeItem extends AbstractStructBase
{
    /**
     * The colors
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \NexusDigital/MiratelForce\StructType\DescribeColor[]
     */
    public $colors;
    /**
     * The icons
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \NexusDigital/MiratelForce\StructType\DescribeIcon[]
     */
    public $icons;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * Constructor method for DescribeThemeItem
     * @uses DescribeThemeItem::setColors()
     * @uses DescribeThemeItem::setIcons()
     * @uses DescribeThemeItem::setName()
     * @param \NexusDigital/MiratelForce\StructType\DescribeColor[] $colors
     * @param \NexusDigital/MiratelForce\StructType\DescribeIcon[] $icons
     * @param string $name
     */
    public function __construct(array $colors = array(), array $icons = array(), $name = null)
    {
        $this
            ->setColors($colors)
            ->setIcons($icons)
            ->setName($name);
    }
    /**
     * Get colors value
     * @return \NexusDigital/MiratelForce\StructType\DescribeColor[]|null
     */
    public function getColors()
    {
        return $this->colors;
    }
    /**
     * This method is responsible for validating the values passed to the setColors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setColors method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateColorsForArrayConstraintsFromSetColors(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $describeThemeItemColorsItem) {
            // validation for constraint: itemType
            if (!$describeThemeItemColorsItem instanceof \NexusDigital/MiratelForce\StructType\DescribeColor) {
                $invalidValues[] = is_object($describeThemeItemColorsItem) ? get_class($describeThemeItemColorsItem) : sprintf('%s(%s)', gettype($describeThemeItemColorsItem), var_export($describeThemeItemColorsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The colors property can only contain items of type \NexusDigital/MiratelForce\StructType\DescribeColor, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set colors value
     * @throws \InvalidArgumentException
     * @param \NexusDigital/MiratelForce\StructType\DescribeColor[] $colors
     * @return \NexusDigital/MiratelForce\StructType\DescribeThemeItem
     */
    public function setColors(array $colors = array())
    {
        // validation for constraint: array
        if ('' !== ($colorsArrayErrorMessage = self::validateColorsForArrayConstraintsFromSetColors($colors))) {
            throw new \InvalidArgumentException($colorsArrayErrorMessage, __LINE__);
        }
        $this->colors = $colors;
        return $this;
    }
    /**
     * Add item to colors value
     * @throws \InvalidArgumentException
     * @param \NexusDigital/MiratelForce\StructType\DescribeColor $item
     * @return \NexusDigital/MiratelForce\StructType\DescribeThemeItem
     */
    public function addToColors(\NexusDigital/MiratelForce\StructType\DescribeColor $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \NexusDigital/MiratelForce\StructType\DescribeColor) {
            throw new \InvalidArgumentException(sprintf('The colors property can only contain items of type \NexusDigital/MiratelForce\StructType\DescribeColor, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->colors[] = $item;
        return $this;
    }
    /**
     * Get icons value
     * @return \NexusDigital/MiratelForce\StructType\DescribeIcon[]|null
     */
    public function getIcons()
    {
        return $this->icons;
    }
    /**
     * This method is responsible for validating the values passed to the setIcons method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIcons method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIconsForArrayConstraintsFromSetIcons(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $describeThemeItemIconsItem) {
            // validation for constraint: itemType
            if (!$describeThemeItemIconsItem instanceof \NexusDigital/MiratelForce\StructType\DescribeIcon) {
                $invalidValues[] = is_object($describeThemeItemIconsItem) ? get_class($describeThemeItemIconsItem) : sprintf('%s(%s)', gettype($describeThemeItemIconsItem), var_export($describeThemeItemIconsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The icons property can only contain items of type \NexusDigital/MiratelForce\StructType\DescribeIcon, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set icons value
     * @throws \InvalidArgumentException
     * @param \NexusDigital/MiratelForce\StructType\DescribeIcon[] $icons
     * @return \NexusDigital/MiratelForce\StructType\DescribeThemeItem
     */
    public function setIcons(array $icons = array())
    {
        // validation for constraint: array
        if ('' !== ($iconsArrayErrorMessage = self::validateIconsForArrayConstraintsFromSetIcons($icons))) {
            throw new \InvalidArgumentException($iconsArrayErrorMessage, __LINE__);
        }
        $this->icons = $icons;
        return $this;
    }
    /**
     * Add item to icons value
     * @throws \InvalidArgumentException
     * @param \NexusDigital/MiratelForce\StructType\DescribeIcon $item
     * @return \NexusDigital/MiratelForce\StructType\DescribeThemeItem
     */
    public function addToIcons(\NexusDigital/MiratelForce\StructType\DescribeIcon $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \NexusDigital/MiratelForce\StructType\DescribeIcon) {
            throw new \InvalidArgumentException(sprintf('The icons property can only contain items of type \NexusDigital/MiratelForce\StructType\DescribeIcon, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->icons[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\DescribeThemeItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\DescribeThemeItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
