<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for describeSObjectsResponse StructType
 * @subpackage Structs
 */
class DescribeSObjectsResponse extends AbstractStructBase
{
    /**
     * The result
     * Meta informations extracted from the WSDL
     * - maxOccurs: 100
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\DescribeSObjectResult[]
     */
    public $result;
    /**
     * Constructor method for describeSObjectsResponse
     * @uses DescribeSObjectsResponse::setResult()
     * @param \NexusDigital/MiratelForce\StructType\DescribeSObjectResult[] $result
     */
    public function __construct(array $result = array())
    {
        $this
            ->setResult($result);
    }
    /**
     * Get result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\DescribeSObjectResult[]|null
     */
    public function getResult()
    {
        return isset($this->result) ? $this->result : null;
    }
    /**
     * This method is responsible for validating the values passed to the setResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResultForArrayConstraintsFromSetResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $describeSObjectsResponseResultItem) {
            // validation for constraint: itemType
            if (!$describeSObjectsResponseResultItem instanceof \NexusDigital/MiratelForce\StructType\DescribeSObjectResult) {
                $invalidValues[] = is_object($describeSObjectsResponseResultItem) ? get_class($describeSObjectsResponseResultItem) : sprintf('%s(%s)', gettype($describeSObjectsResponseResultItem), var_export($describeSObjectsResponseResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The result property can only contain items of type \NexusDigital/MiratelForce\StructType\DescribeSObjectResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \NexusDigital/MiratelForce\StructType\DescribeSObjectResult[] $result
     * @return \NexusDigital/MiratelForce\StructType\DescribeSObjectsResponse
     */
    public function setResult(array $result = array())
    {
        // validation for constraint: array
        if ('' !== ($resultArrayErrorMessage = self::validateResultForArrayConstraintsFromSetResult($result))) {
            throw new \InvalidArgumentException($resultArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(100)
        if (is_array($result) && count($result) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 100', count($result)), __LINE__);
        }
        if (is_null($result) || (is_array($result) && empty($result))) {
            unset($this->result);
        } else {
            $this->result = $result;
        }
        return $this;
    }
    /**
     * Add item to result value
     * @throws \InvalidArgumentException
     * @param \NexusDigital/MiratelForce\StructType\DescribeSObjectResult $item
     * @return \NexusDigital/MiratelForce\StructType\DescribeSObjectsResponse
     */
    public function addToResult(\NexusDigital/MiratelForce\StructType\DescribeSObjectResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \NexusDigital/MiratelForce\StructType\DescribeSObjectResult) {
            throw new \InvalidArgumentException(sprintf('The result property can only contain items of type \NexusDigital/MiratelForce\StructType\DescribeSObjectResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(100)
        if (is_array($this->result) && count($this->result) >= 100) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 100', count($this->result)), __LINE__);
        }
        $this->result[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\DescribeSObjectsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
