<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DescribePathAssistant StructType
 * @subpackage Structs
 */
class DescribePathAssistant extends AbstractStructBase
{
    /**
     * The active
     * @var bool
     */
    public $active;
    /**
     * The apiName
     * @var string
     */
    public $apiName;
    /**
     * The label
     * @var string
     */
    public $label;
    /**
     * The pathPicklistField
     * @var string
     */
    public $pathPicklistField;
    /**
     * The picklistsForRecordType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\PicklistForRecordType[]
     */
    public $picklistsForRecordType;
    /**
     * The recordTypeId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $recordTypeId;
    /**
     * The steps
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \NexusDigital/MiratelForce\StructType\DescribePathAssistantStep[]
     */
    public $steps;
    /**
     * Constructor method for DescribePathAssistant
     * @uses DescribePathAssistant::setActive()
     * @uses DescribePathAssistant::setApiName()
     * @uses DescribePathAssistant::setLabel()
     * @uses DescribePathAssistant::setPathPicklistField()
     * @uses DescribePathAssistant::setPicklistsForRecordType()
     * @uses DescribePathAssistant::setRecordTypeId()
     * @uses DescribePathAssistant::setSteps()
     * @param bool $active
     * @param string $apiName
     * @param string $label
     * @param string $pathPicklistField
     * @param \NexusDigital/MiratelForce\StructType\PicklistForRecordType[] $picklistsForRecordType
     * @param string $recordTypeId
     * @param \NexusDigital/MiratelForce\StructType\DescribePathAssistantStep[] $steps
     */
    public function __construct($active = null, $apiName = null, $label = null, $pathPicklistField = null, array $picklistsForRecordType = array(), $recordTypeId = null, array $steps = array())
    {
        $this
            ->setActive($active)
            ->setApiName($apiName)
            ->setLabel($label)
            ->setPathPicklistField($pathPicklistField)
            ->setPicklistsForRecordType($picklistsForRecordType)
            ->setRecordTypeId($recordTypeId)
            ->setSteps($steps);
    }
    /**
     * Get active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param bool $active
     * @return \NexusDigital/MiratelForce\StructType\DescribePathAssistant
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get apiName value
     * @return string|null
     */
    public function getApiName()
    {
        return $this->apiName;
    }
    /**
     * Set apiName value
     * @param string $apiName
     * @return \NexusDigital/MiratelForce\StructType\DescribePathAssistant
     */
    public function setApiName($apiName = null)
    {
        // validation for constraint: string
        if (!is_null($apiName) && !is_string($apiName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiName, true), gettype($apiName)), __LINE__);
        }
        $this->apiName = $apiName;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \NexusDigital/MiratelForce\StructType\DescribePathAssistant
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get pathPicklistField value
     * @return string|null
     */
    public function getPathPicklistField()
    {
        return $this->pathPicklistField;
    }
    /**
     * Set pathPicklistField value
     * @param string $pathPicklistField
     * @return \NexusDigital/MiratelForce\StructType\DescribePathAssistant
     */
    public function setPathPicklistField($pathPicklistField = null)
    {
        // validation for constraint: string
        if (!is_null($pathPicklistField) && !is_string($pathPicklistField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pathPicklistField, true), gettype($pathPicklistField)), __LINE__);
        }
        $this->pathPicklistField = $pathPicklistField;
        return $this;
    }
    /**
     * Get picklistsForRecordType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\PicklistForRecordType[]|null
     */
    public function getPicklistsForRecordType()
    {
        return isset($this->picklistsForRecordType) ? $this->picklistsForRecordType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPicklistsForRecordType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPicklistsForRecordType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePicklistsForRecordTypeForArrayConstraintsFromSetPicklistsForRecordType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $describePathAssistantPicklistsForRecordTypeItem) {
            // validation for constraint: itemType
            if (!$describePathAssistantPicklistsForRecordTypeItem instanceof \NexusDigital/MiratelForce\StructType\PicklistForRecordType) {
                $invalidValues[] = is_object($describePathAssistantPicklistsForRecordTypeItem) ? get_class($describePathAssistantPicklistsForRecordTypeItem) : sprintf('%s(%s)', gettype($describePathAssistantPicklistsForRecordTypeItem), var_export($describePathAssistantPicklistsForRecordTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The picklistsForRecordType property can only contain items of type \NexusDigital/MiratelForce\StructType\PicklistForRecordType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set picklistsForRecordType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \NexusDigital/MiratelForce\StructType\PicklistForRecordType[] $picklistsForRecordType
     * @return \NexusDigital/MiratelForce\StructType\DescribePathAssistant
     */
    public function setPicklistsForRecordType(array $picklistsForRecordType = array())
    {
        // validation for constraint: array
        if ('' !== ($picklistsForRecordTypeArrayErrorMessage = self::validatePicklistsForRecordTypeForArrayConstraintsFromSetPicklistsForRecordType($picklistsForRecordType))) {
            throw new \InvalidArgumentException($picklistsForRecordTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($picklistsForRecordType) || (is_array($picklistsForRecordType) && empty($picklistsForRecordType))) {
            unset($this->picklistsForRecordType);
        } else {
            $this->picklistsForRecordType = $picklistsForRecordType;
        }
        return $this;
    }
    /**
     * Add item to picklistsForRecordType value
     * @throws \InvalidArgumentException
     * @param \NexusDigital/MiratelForce\StructType\PicklistForRecordType $item
     * @return \NexusDigital/MiratelForce\StructType\DescribePathAssistant
     */
    public function addToPicklistsForRecordType(\NexusDigital/MiratelForce\StructType\PicklistForRecordType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \NexusDigital/MiratelForce\StructType\PicklistForRecordType) {
            throw new \InvalidArgumentException(sprintf('The picklistsForRecordType property can only contain items of type \NexusDigital/MiratelForce\StructType\PicklistForRecordType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->picklistsForRecordType[] = $item;
        return $this;
    }
    /**
     * Get recordTypeId value
     * @return string|null
     */
    public function getRecordTypeId()
    {
        return $this->recordTypeId;
    }
    /**
     * Set recordTypeId value
     * @param string $recordTypeId
     * @return \NexusDigital/MiratelForce\StructType\DescribePathAssistant
     */
    public function setRecordTypeId($recordTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($recordTypeId) && !is_string($recordTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordTypeId, true), gettype($recordTypeId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($recordTypeId) && mb_strlen($recordTypeId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($recordTypeId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($recordTypeId) && !preg_match('/[a-zA-Z0-9]{18}/', $recordTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($recordTypeId, true)), __LINE__);
        }
        $this->recordTypeId = $recordTypeId;
        return $this;
    }
    /**
     * Get steps value
     * @return \NexusDigital/MiratelForce\StructType\DescribePathAssistantStep[]|null
     */
    public function getSteps()
    {
        return $this->steps;
    }
    /**
     * This method is responsible for validating the values passed to the setSteps method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSteps method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStepsForArrayConstraintsFromSetSteps(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $describePathAssistantStepsItem) {
            // validation for constraint: itemType
            if (!$describePathAssistantStepsItem instanceof \NexusDigital/MiratelForce\StructType\DescribePathAssistantStep) {
                $invalidValues[] = is_object($describePathAssistantStepsItem) ? get_class($describePathAssistantStepsItem) : sprintf('%s(%s)', gettype($describePathAssistantStepsItem), var_export($describePathAssistantStepsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The steps property can only contain items of type \NexusDigital/MiratelForce\StructType\DescribePathAssistantStep, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set steps value
     * @throws \InvalidArgumentException
     * @param \NexusDigital/MiratelForce\StructType\DescribePathAssistantStep[] $steps
     * @return \NexusDigital/MiratelForce\StructType\DescribePathAssistant
     */
    public function setSteps(array $steps = array())
    {
        // validation for constraint: array
        if ('' !== ($stepsArrayErrorMessage = self::validateStepsForArrayConstraintsFromSetSteps($steps))) {
            throw new \InvalidArgumentException($stepsArrayErrorMessage, __LINE__);
        }
        $this->steps = $steps;
        return $this;
    }
    /**
     * Add item to steps value
     * @throws \InvalidArgumentException
     * @param \NexusDigital/MiratelForce\StructType\DescribePathAssistantStep $item
     * @return \NexusDigital/MiratelForce\StructType\DescribePathAssistant
     */
    public function addToSteps(\NexusDigital/MiratelForce\StructType\DescribePathAssistantStep $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \NexusDigital/MiratelForce\StructType\DescribePathAssistantStep) {
            throw new \InvalidArgumentException(sprintf('The steps property can only contain items of type \NexusDigital/MiratelForce\StructType\DescribePathAssistantStep, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->steps[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\DescribePathAssistant
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
