<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataUsePurposeHistory StructType
 * @subpackage Structs
 */
class DataUsePurposeHistory extends SObject
{
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DataUsePurpose
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\DataUsePurpose
     */
    public $DataUsePurpose;
    /**
     * The DataUsePurposeId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $DataUsePurposeId;
    /**
     * The Field
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Field;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The NewValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var mixed
     */
    public $NewValue;
    /**
     * The OldValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var mixed
     */
    public $OldValue;
    /**
     * Constructor method for DataUsePurposeHistory
     * @uses DataUsePurposeHistory::setCreatedBy()
     * @uses DataUsePurposeHistory::setCreatedById()
     * @uses DataUsePurposeHistory::setCreatedDate()
     * @uses DataUsePurposeHistory::setDataUsePurpose()
     * @uses DataUsePurposeHistory::setDataUsePurposeId()
     * @uses DataUsePurposeHistory::setField()
     * @uses DataUsePurposeHistory::setIsDeleted()
     * @uses DataUsePurposeHistory::setNewValue()
     * @uses DataUsePurposeHistory::setOldValue()
     * @param \NexusDigital/MiratelForce\StructType\SObject $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\DataUsePurpose $dataUsePurpose
     * @param string $dataUsePurposeId
     * @param string $field
     * @param bool $isDeleted
     * @param mixed $newValue
     * @param mixed $oldValue
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\SObject $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\DataUsePurpose $dataUsePurpose = null, $dataUsePurposeId = null, $field = null, $isDeleted = null, $newValue = null, $oldValue = null)
    {
        $this
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDataUsePurpose($dataUsePurpose)
            ->setDataUsePurposeId($dataUsePurposeId)
            ->setField($field)
            ->setIsDeleted($isDeleted)
            ->setNewValue($newValue)
            ->setOldValue($oldValue);
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $createdBy
     * @return \NexusDigital/MiratelForce\StructType\DataUsePurposeHistory
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\SObject $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\DataUsePurposeHistory
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\DataUsePurposeHistory
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DataUsePurpose value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\DataUsePurpose|null
     */
    public function getDataUsePurpose()
    {
        return isset($this->DataUsePurpose) ? $this->DataUsePurpose : null;
    }
    /**
     * Set DataUsePurpose value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\DataUsePurpose $dataUsePurpose
     * @return \NexusDigital/MiratelForce\StructType\DataUsePurposeHistory
     */
    public function setDataUsePurpose(\NexusDigital/MiratelForce\StructType\DataUsePurpose $dataUsePurpose = null)
    {
        if (is_null($dataUsePurpose) || (is_array($dataUsePurpose) && empty($dataUsePurpose))) {
            unset($this->DataUsePurpose);
        } else {
            $this->DataUsePurpose = $dataUsePurpose;
        }
        return $this;
    }
    /**
     * Get DataUsePurposeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataUsePurposeId()
    {
        return isset($this->DataUsePurposeId) ? $this->DataUsePurposeId : null;
    }
    /**
     * Set DataUsePurposeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataUsePurposeId
     * @return \NexusDigital/MiratelForce\StructType\DataUsePurposeHistory
     */
    public function setDataUsePurposeId($dataUsePurposeId = null)
    {
        // validation for constraint: string
        if (!is_null($dataUsePurposeId) && !is_string($dataUsePurposeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataUsePurposeId, true), gettype($dataUsePurposeId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($dataUsePurposeId) && mb_strlen($dataUsePurposeId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($dataUsePurposeId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($dataUsePurposeId) && !preg_match('/[a-zA-Z0-9]{18}/', $dataUsePurposeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($dataUsePurposeId, true)), __LINE__);
        }
        if (is_null($dataUsePurposeId) || (is_array($dataUsePurposeId) && empty($dataUsePurposeId))) {
            unset($this->DataUsePurposeId);
        } else {
            $this->DataUsePurposeId = $dataUsePurposeId;
        }
        return $this;
    }
    /**
     * Get Field value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getField()
    {
        return isset($this->Field) ? $this->Field : null;
    }
    /**
     * Set Field value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $field
     * @return \NexusDigital/MiratelForce\StructType\DataUsePurposeHistory
     */
    public function setField($field = null)
    {
        // validation for constraint: string
        if (!is_null($field) && !is_string($field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($field, true), gettype($field)), __LINE__);
        }
        if (is_null($field) || (is_array($field) && empty($field))) {
            unset($this->Field);
        } else {
            $this->Field = $field;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\DataUsePurposeHistory
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get NewValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return mixed|null
     */
    public function getNewValue()
    {
        return isset($this->NewValue) ? $this->NewValue : null;
    }
    /**
     * Set NewValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param mixed $newValue
     * @return \NexusDigital/MiratelForce\StructType\DataUsePurposeHistory
     */
    public function setNewValue($newValue = null)
    {
        if (is_null($newValue) || (is_array($newValue) && empty($newValue))) {
            unset($this->NewValue);
        } else {
            $this->NewValue = $newValue;
        }
        return $this;
    }
    /**
     * Get OldValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return mixed|null
     */
    public function getOldValue()
    {
        return isset($this->OldValue) ? $this->OldValue : null;
    }
    /**
     * Set OldValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param mixed $oldValue
     * @return \NexusDigital/MiratelForce\StructType\DataUsePurposeHistory
     */
    public function setOldValue($oldValue = null)
    {
        if (is_null($oldValue) || (is_array($oldValue) && empty($oldValue))) {
            unset($this->OldValue);
        } else {
            $this->OldValue = $oldValue;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\DataUsePurposeHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
