<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataAssessmentMetric StructType
 * @subpackage Structs
 */
class DataAssessmentMetric extends SObject
{
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DataAssessmentMetrics
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $DataAssessmentMetrics;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NumDuplicates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumDuplicates;
    /**
     * The NumMatched
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumMatched;
    /**
     * The NumMatchedDifferent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumMatchedDifferent;
    /**
     * The NumProcessed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumProcessed;
    /**
     * The NumTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumTotal;
    /**
     * The NumUnmatched
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumUnmatched;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The UserRecordAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public $UserRecordAccess;
    /**
     * Constructor method for DataAssessmentMetric
     * @uses DataAssessmentMetric::setCreatedBy()
     * @uses DataAssessmentMetric::setCreatedById()
     * @uses DataAssessmentMetric::setCreatedDate()
     * @uses DataAssessmentMetric::setDataAssessmentMetrics()
     * @uses DataAssessmentMetric::setIsDeleted()
     * @uses DataAssessmentMetric::setLastModifiedBy()
     * @uses DataAssessmentMetric::setLastModifiedById()
     * @uses DataAssessmentMetric::setLastModifiedDate()
     * @uses DataAssessmentMetric::setName()
     * @uses DataAssessmentMetric::setNumDuplicates()
     * @uses DataAssessmentMetric::setNumMatched()
     * @uses DataAssessmentMetric::setNumMatchedDifferent()
     * @uses DataAssessmentMetric::setNumProcessed()
     * @uses DataAssessmentMetric::setNumTotal()
     * @uses DataAssessmentMetric::setNumUnmatched()
     * @uses DataAssessmentMetric::setSystemModstamp()
     * @uses DataAssessmentMetric::setUserRecordAccess()
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $dataAssessmentMetrics
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $name
     * @param int $numDuplicates
     * @param int $numMatched
     * @param int $numMatchedDifferent
     * @param int $numProcessed
     * @param int $numTotal
     * @param int $numUnmatched
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $dataAssessmentMetrics = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $name = null, $numDuplicates = null, $numMatched = null, $numMatchedDifferent = null, $numProcessed = null, $numTotal = null, $numUnmatched = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        $this
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDataAssessmentMetrics($dataAssessmentMetrics)
            ->setIsDeleted($isDeleted)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setName($name)
            ->setNumDuplicates($numDuplicates)
            ->setNumMatched($numMatched)
            ->setNumMatchedDifferent($numMatchedDifferent)
            ->setNumProcessed($numProcessed)
            ->setNumTotal($numTotal)
            ->setNumUnmatched($numUnmatched)
            ->setSystemModstamp($systemModstamp)
            ->setUserRecordAccess($userRecordAccess);
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DataAssessmentMetrics value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getDataAssessmentMetrics()
    {
        return isset($this->DataAssessmentMetrics) ? $this->DataAssessmentMetrics : null;
    }
    /**
     * Set DataAssessmentMetrics value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $dataAssessmentMetrics
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setDataAssessmentMetrics(\NexusDigital/MiratelForce\StructType\QueryResult $dataAssessmentMetrics = null)
    {
        if (is_null($dataAssessmentMetrics) || (is_array($dataAssessmentMetrics) && empty($dataAssessmentMetrics))) {
            unset($this->DataAssessmentMetrics);
        } else {
            $this->DataAssessmentMetrics = $dataAssessmentMetrics;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumDuplicates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumDuplicates()
    {
        return isset($this->NumDuplicates) ? $this->NumDuplicates : null;
    }
    /**
     * Set NumDuplicates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numDuplicates
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setNumDuplicates($numDuplicates = null)
    {
        // validation for constraint: int
        if (!is_null($numDuplicates) && !(is_int($numDuplicates) || ctype_digit($numDuplicates))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numDuplicates, true), gettype($numDuplicates)), __LINE__);
        }
        if (is_null($numDuplicates) || (is_array($numDuplicates) && empty($numDuplicates))) {
            unset($this->NumDuplicates);
        } else {
            $this->NumDuplicates = $numDuplicates;
        }
        return $this;
    }
    /**
     * Get NumMatched value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumMatched()
    {
        return isset($this->NumMatched) ? $this->NumMatched : null;
    }
    /**
     * Set NumMatched value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numMatched
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setNumMatched($numMatched = null)
    {
        // validation for constraint: int
        if (!is_null($numMatched) && !(is_int($numMatched) || ctype_digit($numMatched))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numMatched, true), gettype($numMatched)), __LINE__);
        }
        if (is_null($numMatched) || (is_array($numMatched) && empty($numMatched))) {
            unset($this->NumMatched);
        } else {
            $this->NumMatched = $numMatched;
        }
        return $this;
    }
    /**
     * Get NumMatchedDifferent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumMatchedDifferent()
    {
        return isset($this->NumMatchedDifferent) ? $this->NumMatchedDifferent : null;
    }
    /**
     * Set NumMatchedDifferent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numMatchedDifferent
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setNumMatchedDifferent($numMatchedDifferent = null)
    {
        // validation for constraint: int
        if (!is_null($numMatchedDifferent) && !(is_int($numMatchedDifferent) || ctype_digit($numMatchedDifferent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numMatchedDifferent, true), gettype($numMatchedDifferent)), __LINE__);
        }
        if (is_null($numMatchedDifferent) || (is_array($numMatchedDifferent) && empty($numMatchedDifferent))) {
            unset($this->NumMatchedDifferent);
        } else {
            $this->NumMatchedDifferent = $numMatchedDifferent;
        }
        return $this;
    }
    /**
     * Get NumProcessed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumProcessed()
    {
        return isset($this->NumProcessed) ? $this->NumProcessed : null;
    }
    /**
     * Set NumProcessed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numProcessed
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setNumProcessed($numProcessed = null)
    {
        // validation for constraint: int
        if (!is_null($numProcessed) && !(is_int($numProcessed) || ctype_digit($numProcessed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numProcessed, true), gettype($numProcessed)), __LINE__);
        }
        if (is_null($numProcessed) || (is_array($numProcessed) && empty($numProcessed))) {
            unset($this->NumProcessed);
        } else {
            $this->NumProcessed = $numProcessed;
        }
        return $this;
    }
    /**
     * Get NumTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumTotal()
    {
        return isset($this->NumTotal) ? $this->NumTotal : null;
    }
    /**
     * Set NumTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numTotal
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setNumTotal($numTotal = null)
    {
        // validation for constraint: int
        if (!is_null($numTotal) && !(is_int($numTotal) || ctype_digit($numTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numTotal, true), gettype($numTotal)), __LINE__);
        }
        if (is_null($numTotal) || (is_array($numTotal) && empty($numTotal))) {
            unset($this->NumTotal);
        } else {
            $this->NumTotal = $numTotal;
        }
        return $this;
    }
    /**
     * Get NumUnmatched value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumUnmatched()
    {
        return isset($this->NumUnmatched) ? $this->NumUnmatched : null;
    }
    /**
     * Set NumUnmatched value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numUnmatched
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setNumUnmatched($numUnmatched = null)
    {
        // validation for constraint: int
        if (!is_null($numUnmatched) && !(is_int($numUnmatched) || ctype_digit($numUnmatched))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numUnmatched, true), gettype($numUnmatched)), __LINE__);
        }
        if (is_null($numUnmatched) || (is_array($numUnmatched) && empty($numUnmatched))) {
            unset($this->NumUnmatched);
        } else {
            $this->NumUnmatched = $numUnmatched;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get UserRecordAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess|null
     */
    public function getUserRecordAccess()
    {
        return isset($this->UserRecordAccess) ? $this->UserRecordAccess : null;
    }
    /**
     * Set UserRecordAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public function setUserRecordAccess(\NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        if (is_null($userRecordAccess) || (is_array($userRecordAccess) && empty($userRecordAccess))) {
            unset($this->UserRecordAccess);
        } else {
            $this->UserRecordAccess = $userRecordAccess;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
