<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomObjectUserLicenseMetrics StructType
 * @subpackage Structs
 */
class CustomObjectUserLicenseMetrics extends SObject
{
    /**
     * The CustomObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomObjectId;
    /**
     * The CustomObjectName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomObjectName;
    /**
     * The CustomObjectType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomObjectType;
    /**
     * The MetricsDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MetricsDate;
    /**
     * The ObjectCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ObjectCount;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The UserLicense
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserLicense
     */
    public $UserLicense;
    /**
     * The UserLicenseId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserLicenseId;
    /**
     * Constructor method for CustomObjectUserLicenseMetrics
     * @uses CustomObjectUserLicenseMetrics::setCustomObjectId()
     * @uses CustomObjectUserLicenseMetrics::setCustomObjectName()
     * @uses CustomObjectUserLicenseMetrics::setCustomObjectType()
     * @uses CustomObjectUserLicenseMetrics::setMetricsDate()
     * @uses CustomObjectUserLicenseMetrics::setObjectCount()
     * @uses CustomObjectUserLicenseMetrics::setSystemModstamp()
     * @uses CustomObjectUserLicenseMetrics::setUserLicense()
     * @uses CustomObjectUserLicenseMetrics::setUserLicenseId()
     * @param string $customObjectId
     * @param string $customObjectName
     * @param string $customObjectType
     * @param string $metricsDate
     * @param int $objectCount
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\UserLicense $userLicense
     * @param string $userLicenseId
     */
    public function __construct($customObjectId = null, $customObjectName = null, $customObjectType = null, $metricsDate = null, $objectCount = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\UserLicense $userLicense = null, $userLicenseId = null)
    {
        $this
            ->setCustomObjectId($customObjectId)
            ->setCustomObjectName($customObjectName)
            ->setCustomObjectType($customObjectType)
            ->setMetricsDate($metricsDate)
            ->setObjectCount($objectCount)
            ->setSystemModstamp($systemModstamp)
            ->setUserLicense($userLicense)
            ->setUserLicenseId($userLicenseId);
    }
    /**
     * Get CustomObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomObjectId()
    {
        return isset($this->CustomObjectId) ? $this->CustomObjectId : null;
    }
    /**
     * Set CustomObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customObjectId
     * @return \NexusDigital/MiratelForce\StructType\CustomObjectUserLicenseMetrics
     */
    public function setCustomObjectId($customObjectId = null)
    {
        // validation for constraint: string
        if (!is_null($customObjectId) && !is_string($customObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customObjectId, true), gettype($customObjectId)), __LINE__);
        }
        if (is_null($customObjectId) || (is_array($customObjectId) && empty($customObjectId))) {
            unset($this->CustomObjectId);
        } else {
            $this->CustomObjectId = $customObjectId;
        }
        return $this;
    }
    /**
     * Get CustomObjectName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomObjectName()
    {
        return isset($this->CustomObjectName) ? $this->CustomObjectName : null;
    }
    /**
     * Set CustomObjectName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customObjectName
     * @return \NexusDigital/MiratelForce\StructType\CustomObjectUserLicenseMetrics
     */
    public function setCustomObjectName($customObjectName = null)
    {
        // validation for constraint: string
        if (!is_null($customObjectName) && !is_string($customObjectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customObjectName, true), gettype($customObjectName)), __LINE__);
        }
        if (is_null($customObjectName) || (is_array($customObjectName) && empty($customObjectName))) {
            unset($this->CustomObjectName);
        } else {
            $this->CustomObjectName = $customObjectName;
        }
        return $this;
    }
    /**
     * Get CustomObjectType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomObjectType()
    {
        return isset($this->CustomObjectType) ? $this->CustomObjectType : null;
    }
    /**
     * Set CustomObjectType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customObjectType
     * @return \NexusDigital/MiratelForce\StructType\CustomObjectUserLicenseMetrics
     */
    public function setCustomObjectType($customObjectType = null)
    {
        // validation for constraint: string
        if (!is_null($customObjectType) && !is_string($customObjectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customObjectType, true), gettype($customObjectType)), __LINE__);
        }
        if (is_null($customObjectType) || (is_array($customObjectType) && empty($customObjectType))) {
            unset($this->CustomObjectType);
        } else {
            $this->CustomObjectType = $customObjectType;
        }
        return $this;
    }
    /**
     * Get MetricsDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMetricsDate()
    {
        return isset($this->MetricsDate) ? $this->MetricsDate : null;
    }
    /**
     * Set MetricsDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $metricsDate
     * @return \NexusDigital/MiratelForce\StructType\CustomObjectUserLicenseMetrics
     */
    public function setMetricsDate($metricsDate = null)
    {
        // validation for constraint: string
        if (!is_null($metricsDate) && !is_string($metricsDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metricsDate, true), gettype($metricsDate)), __LINE__);
        }
        if (is_null($metricsDate) || (is_array($metricsDate) && empty($metricsDate))) {
            unset($this->MetricsDate);
        } else {
            $this->MetricsDate = $metricsDate;
        }
        return $this;
    }
    /**
     * Get ObjectCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getObjectCount()
    {
        return isset($this->ObjectCount) ? $this->ObjectCount : null;
    }
    /**
     * Set ObjectCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $objectCount
     * @return \NexusDigital/MiratelForce\StructType\CustomObjectUserLicenseMetrics
     */
    public function setObjectCount($objectCount = null)
    {
        // validation for constraint: int
        if (!is_null($objectCount) && !(is_int($objectCount) || ctype_digit($objectCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objectCount, true), gettype($objectCount)), __LINE__);
        }
        if (is_null($objectCount) || (is_array($objectCount) && empty($objectCount))) {
            unset($this->ObjectCount);
        } else {
            $this->ObjectCount = $objectCount;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\CustomObjectUserLicenseMetrics
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get UserLicense value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserLicense|null
     */
    public function getUserLicense()
    {
        return isset($this->UserLicense) ? $this->UserLicense : null;
    }
    /**
     * Set UserLicense value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserLicense $userLicense
     * @return \NexusDigital/MiratelForce\StructType\CustomObjectUserLicenseMetrics
     */
    public function setUserLicense(\NexusDigital/MiratelForce\StructType\UserLicense $userLicense = null)
    {
        if (is_null($userLicense) || (is_array($userLicense) && empty($userLicense))) {
            unset($this->UserLicense);
        } else {
            $this->UserLicense = $userLicense;
        }
        return $this;
    }
    /**
     * Get UserLicenseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLicenseId()
    {
        return isset($this->UserLicenseId) ? $this->UserLicenseId : null;
    }
    /**
     * Set UserLicenseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userLicenseId
     * @return \NexusDigital/MiratelForce\StructType\CustomObjectUserLicenseMetrics
     */
    public function setUserLicenseId($userLicenseId = null)
    {
        // validation for constraint: string
        if (!is_null($userLicenseId) && !is_string($userLicenseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLicenseId, true), gettype($userLicenseId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userLicenseId) && mb_strlen($userLicenseId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userLicenseId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userLicenseId) && !preg_match('/[a-zA-Z0-9]{18}/', $userLicenseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userLicenseId, true)), __LINE__);
        }
        if (is_null($userLicenseId) || (is_array($userLicenseId) && empty($userLicenseId))) {
            unset($this->UserLicenseId);
        } else {
            $this->UserLicenseId = $userLicenseId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\CustomObjectUserLicenseMetrics
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
