<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cost_Calculation__mdt StructType
 * @subpackage Structs
 */
class Cost_Calculation__mdt extends SObject
{
    /**
     * The Client__c
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $Client__c;
    /**
     * The Client__r
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Client__mdt
     */
    public $Client__r;
    /**
     * The DeveloperName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeveloperName;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The MasterLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterLabel;
    /**
     * The NamespacePrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NamespacePrefix;
    /**
     * The QualifiedApiName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QualifiedApiName;
    /**
     * The Ticket_Name__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ticket_Name__c;
    /**
     * The Ticket_Price__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Ticket_Price__c;
    /**
     * Constructor method for Cost_Calculation__mdt
     * @uses Cost_Calculation__mdt::setClient__c()
     * @uses Cost_Calculation__mdt::setClient__r()
     * @uses Cost_Calculation__mdt::setDeveloperName()
     * @uses Cost_Calculation__mdt::setLabel()
     * @uses Cost_Calculation__mdt::setLanguage()
     * @uses Cost_Calculation__mdt::setMasterLabel()
     * @uses Cost_Calculation__mdt::setNamespacePrefix()
     * @uses Cost_Calculation__mdt::setQualifiedApiName()
     * @uses Cost_Calculation__mdt::setTicket_Name__c()
     * @uses Cost_Calculation__mdt::setTicket_Price__c()
     * @param string $client__c
     * @param \NexusDigital/MiratelForce\StructType\Client__mdt $client__r
     * @param string $developerName
     * @param string $label
     * @param string $language
     * @param string $masterLabel
     * @param string $namespacePrefix
     * @param string $qualifiedApiName
     * @param string $ticket_Name__c
     * @param float $ticket_Price__c
     */
    public function __construct($client__c = null, \NexusDigital/MiratelForce\StructType\Client__mdt $client__r = null, $developerName = null, $label = null, $language = null, $masterLabel = null, $namespacePrefix = null, $qualifiedApiName = null, $ticket_Name__c = null, $ticket_Price__c = null)
    {
        $this
            ->setClient__c($client__c)
            ->setClient__r($client__r)
            ->setDeveloperName($developerName)
            ->setLabel($label)
            ->setLanguage($language)
            ->setMasterLabel($masterLabel)
            ->setNamespacePrefix($namespacePrefix)
            ->setQualifiedApiName($qualifiedApiName)
            ->setTicket_Name__c($ticket_Name__c)
            ->setTicket_Price__c($ticket_Price__c);
    }
    /**
     * Get Client__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClient__c()
    {
        return isset($this->Client__c) ? $this->Client__c : null;
    }
    /**
     * Set Client__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $client__c
     * @return \NexusDigital/MiratelForce\StructType\Cost_Calculation__mdt
     */
    public function setClient__c($client__c = null)
    {
        // validation for constraint: string
        if (!is_null($client__c) && !is_string($client__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($client__c, true), gettype($client__c)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($client__c) && mb_strlen($client__c) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($client__c)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($client__c) && !preg_match('/[a-zA-Z0-9]{18}/', $client__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($client__c, true)), __LINE__);
        }
        if (is_null($client__c) || (is_array($client__c) && empty($client__c))) {
            unset($this->Client__c);
        } else {
            $this->Client__c = $client__c;
        }
        return $this;
    }
    /**
     * Get Client__r value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Client__mdt|null
     */
    public function getClient__r()
    {
        return isset($this->Client__r) ? $this->Client__r : null;
    }
    /**
     * Set Client__r value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Client__mdt $client__r
     * @return \NexusDigital/MiratelForce\StructType\Cost_Calculation__mdt
     */
    public function setClient__r(\NexusDigital/MiratelForce\StructType\Client__mdt $client__r = null)
    {
        if (is_null($client__r) || (is_array($client__r) && empty($client__r))) {
            unset($this->Client__r);
        } else {
            $this->Client__r = $client__r;
        }
        return $this;
    }
    /**
     * Get DeveloperName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeveloperName()
    {
        return isset($this->DeveloperName) ? $this->DeveloperName : null;
    }
    /**
     * Set DeveloperName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $developerName
     * @return \NexusDigital/MiratelForce\StructType\Cost_Calculation__mdt
     */
    public function setDeveloperName($developerName = null)
    {
        // validation for constraint: string
        if (!is_null($developerName) && !is_string($developerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($developerName, true), gettype($developerName)), __LINE__);
        }
        if (is_null($developerName) || (is_array($developerName) && empty($developerName))) {
            unset($this->DeveloperName);
        } else {
            $this->DeveloperName = $developerName;
        }
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \NexusDigital/MiratelForce\StructType\Cost_Calculation__mdt
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \NexusDigital/MiratelForce\StructType\Cost_Calculation__mdt
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get MasterLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterLabel()
    {
        return isset($this->MasterLabel) ? $this->MasterLabel : null;
    }
    /**
     * Set MasterLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterLabel
     * @return \NexusDigital/MiratelForce\StructType\Cost_Calculation__mdt
     */
    public function setMasterLabel($masterLabel = null)
    {
        // validation for constraint: string
        if (!is_null($masterLabel) && !is_string($masterLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterLabel, true), gettype($masterLabel)), __LINE__);
        }
        if (is_null($masterLabel) || (is_array($masterLabel) && empty($masterLabel))) {
            unset($this->MasterLabel);
        } else {
            $this->MasterLabel = $masterLabel;
        }
        return $this;
    }
    /**
     * Get NamespacePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNamespacePrefix()
    {
        return isset($this->NamespacePrefix) ? $this->NamespacePrefix : null;
    }
    /**
     * Set NamespacePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $namespacePrefix
     * @return \NexusDigital/MiratelForce\StructType\Cost_Calculation__mdt
     */
    public function setNamespacePrefix($namespacePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($namespacePrefix) && !is_string($namespacePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namespacePrefix, true), gettype($namespacePrefix)), __LINE__);
        }
        if (is_null($namespacePrefix) || (is_array($namespacePrefix) && empty($namespacePrefix))) {
            unset($this->NamespacePrefix);
        } else {
            $this->NamespacePrefix = $namespacePrefix;
        }
        return $this;
    }
    /**
     * Get QualifiedApiName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQualifiedApiName()
    {
        return isset($this->QualifiedApiName) ? $this->QualifiedApiName : null;
    }
    /**
     * Set QualifiedApiName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $qualifiedApiName
     * @return \NexusDigital/MiratelForce\StructType\Cost_Calculation__mdt
     */
    public function setQualifiedApiName($qualifiedApiName = null)
    {
        // validation for constraint: string
        if (!is_null($qualifiedApiName) && !is_string($qualifiedApiName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qualifiedApiName, true), gettype($qualifiedApiName)), __LINE__);
        }
        if (is_null($qualifiedApiName) || (is_array($qualifiedApiName) && empty($qualifiedApiName))) {
            unset($this->QualifiedApiName);
        } else {
            $this->QualifiedApiName = $qualifiedApiName;
        }
        return $this;
    }
    /**
     * Get Ticket_Name__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicket_Name__c()
    {
        return isset($this->Ticket_Name__c) ? $this->Ticket_Name__c : null;
    }
    /**
     * Set Ticket_Name__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticket_Name__c
     * @return \NexusDigital/MiratelForce\StructType\Cost_Calculation__mdt
     */
    public function setTicket_Name__c($ticket_Name__c = null)
    {
        // validation for constraint: string
        if (!is_null($ticket_Name__c) && !is_string($ticket_Name__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket_Name__c, true), gettype($ticket_Name__c)), __LINE__);
        }
        if (is_null($ticket_Name__c) || (is_array($ticket_Name__c) && empty($ticket_Name__c))) {
            unset($this->Ticket_Name__c);
        } else {
            $this->Ticket_Name__c = $ticket_Name__c;
        }
        return $this;
    }
    /**
     * Get Ticket_Price__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTicket_Price__c()
    {
        return isset($this->Ticket_Price__c) ? $this->Ticket_Price__c : null;
    }
    /**
     * Set Ticket_Price__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ticket_Price__c
     * @return \NexusDigital/MiratelForce\StructType\Cost_Calculation__mdt
     */
    public function setTicket_Price__c($ticket_Price__c = null)
    {
        // validation for constraint: float
        if (!is_null($ticket_Price__c) && !(is_float($ticket_Price__c) || is_numeric($ticket_Price__c))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ticket_Price__c, true), gettype($ticket_Price__c)), __LINE__);
        }
        if (is_null($ticket_Price__c) || (is_array($ticket_Price__c) && empty($ticket_Price__c))) {
            unset($this->Ticket_Price__c);
        } else {
            $this->Ticket_Price__c = $ticket_Price__c;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\Cost_Calculation__mdt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
