<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentVersion StructType
 * @subpackage Structs
 */
class ContentVersion extends SObject
{
    /**
     * The AuditableEntities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AuditableEntities;
    /**
     * The Checksum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Checksum;
    /**
     * The ContentDocument
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ContentDocument
     */
    public $ContentDocument;
    /**
     * The ContentDocumentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ContentDocumentId;
    /**
     * The ContentLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContentLocation;
    /**
     * The ContentModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $ContentModifiedBy;
    /**
     * The ContentModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ContentModifiedById;
    /**
     * The ContentModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContentModifiedDate;
    /**
     * The ContentSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ContentSize;
    /**
     * The ContentUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContentUrl;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ExternalDataSource
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ExternalDataSource
     */
    public $ExternalDataSource;
    /**
     * The ExternalDataSourceId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ExternalDataSourceId;
    /**
     * The ExternalDocumentInfo1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalDocumentInfo1;
    /**
     * The ExternalDocumentInfo2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalDocumentInfo2;
    /**
     * The FeaturedContentBoost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FeaturedContentBoost;
    /**
     * The FeaturedContentDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FeaturedContentDate;
    /**
     * The FileExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileExtension;
    /**
     * The FileType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileType;
    /**
     * The FirstPublishLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $FirstPublishLocation;
    /**
     * The FirstPublishLocationId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $FirstPublishLocationId;
    /**
     * The Histories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Histories;
    /**
     * The IsAssetEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAssetEnabled;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsLatest
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsLatest;
    /**
     * The IsMajorVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMajorVersion;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The NegativeRatingCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NegativeRatingCount;
    /**
     * The NetworkId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $NetworkId;
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $Owner;
    /**
     * The OwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OwnerId;
    /**
     * The PathOnClient
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PathOnClient;
    /**
     * The PositiveRatingCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PositiveRatingCount;
    /**
     * The PublishStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PublishStatus;
    /**
     * The RatingCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RatingCount;
    /**
     * The ReasonForChange
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReasonForChange;
    /**
     * The SharingOption
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SharingOption;
    /**
     * The SharingPrivacy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SharingPrivacy;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TagCsv
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TagCsv;
    /**
     * The TextPreview
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TextPreview;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The VersionData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VersionData;
    /**
     * The VersionNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VersionNumber;
    /**
     * Constructor method for ContentVersion
     * @uses ContentVersion::setAuditableEntities()
     * @uses ContentVersion::setChecksum()
     * @uses ContentVersion::setContentDocument()
     * @uses ContentVersion::setContentDocumentId()
     * @uses ContentVersion::setContentLocation()
     * @uses ContentVersion::setContentModifiedBy()
     * @uses ContentVersion::setContentModifiedById()
     * @uses ContentVersion::setContentModifiedDate()
     * @uses ContentVersion::setContentSize()
     * @uses ContentVersion::setContentUrl()
     * @uses ContentVersion::setCreatedBy()
     * @uses ContentVersion::setCreatedById()
     * @uses ContentVersion::setCreatedDate()
     * @uses ContentVersion::setDescription()
     * @uses ContentVersion::setExternalDataSource()
     * @uses ContentVersion::setExternalDataSourceId()
     * @uses ContentVersion::setExternalDocumentInfo1()
     * @uses ContentVersion::setExternalDocumentInfo2()
     * @uses ContentVersion::setFeaturedContentBoost()
     * @uses ContentVersion::setFeaturedContentDate()
     * @uses ContentVersion::setFileExtension()
     * @uses ContentVersion::setFileType()
     * @uses ContentVersion::setFirstPublishLocation()
     * @uses ContentVersion::setFirstPublishLocationId()
     * @uses ContentVersion::setHistories()
     * @uses ContentVersion::setIsAssetEnabled()
     * @uses ContentVersion::setIsDeleted()
     * @uses ContentVersion::setIsLatest()
     * @uses ContentVersion::setIsMajorVersion()
     * @uses ContentVersion::setLastModifiedBy()
     * @uses ContentVersion::setLastModifiedById()
     * @uses ContentVersion::setLastModifiedDate()
     * @uses ContentVersion::setNegativeRatingCount()
     * @uses ContentVersion::setNetworkId()
     * @uses ContentVersion::setOrigin()
     * @uses ContentVersion::setOwner()
     * @uses ContentVersion::setOwnerId()
     * @uses ContentVersion::setPathOnClient()
     * @uses ContentVersion::setPositiveRatingCount()
     * @uses ContentVersion::setPublishStatus()
     * @uses ContentVersion::setRatingCount()
     * @uses ContentVersion::setReasonForChange()
     * @uses ContentVersion::setSharingOption()
     * @uses ContentVersion::setSharingPrivacy()
     * @uses ContentVersion::setSystemModstamp()
     * @uses ContentVersion::setTagCsv()
     * @uses ContentVersion::setTextPreview()
     * @uses ContentVersion::setTitle()
     * @uses ContentVersion::setVersionData()
     * @uses ContentVersion::setVersionNumber()
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $auditableEntities
     * @param string $checksum
     * @param \NexusDigital/MiratelForce\StructType\ContentDocument $contentDocument
     * @param string $contentDocumentId
     * @param string $contentLocation
     * @param \NexusDigital/MiratelForce\StructType\User $contentModifiedBy
     * @param string $contentModifiedById
     * @param string $contentModifiedDate
     * @param int $contentSize
     * @param string $contentUrl
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $description
     * @param \NexusDigital/MiratelForce\StructType\ExternalDataSource $externalDataSource
     * @param string $externalDataSourceId
     * @param string $externalDocumentInfo1
     * @param string $externalDocumentInfo2
     * @param int $featuredContentBoost
     * @param string $featuredContentDate
     * @param string $fileExtension
     * @param string $fileType
     * @param \NexusDigital/MiratelForce\StructType\SObject $firstPublishLocation
     * @param string $firstPublishLocationId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @param bool $isAssetEnabled
     * @param bool $isDeleted
     * @param bool $isLatest
     * @param bool $isMajorVersion
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param int $negativeRatingCount
     * @param string $networkId
     * @param string $origin
     * @param \NexusDigital/MiratelForce\StructType\User $owner
     * @param string $ownerId
     * @param string $pathOnClient
     * @param int $positiveRatingCount
     * @param string $publishStatus
     * @param int $ratingCount
     * @param string $reasonForChange
     * @param string $sharingOption
     * @param string $sharingPrivacy
     * @param string $systemModstamp
     * @param string $tagCsv
     * @param string $textPreview
     * @param string $title
     * @param string $versionData
     * @param string $versionNumber
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\QueryResult $auditableEntities = null, $checksum = null, \NexusDigital/MiratelForce\StructType\ContentDocument $contentDocument = null, $contentDocumentId = null, $contentLocation = null, \NexusDigital/MiratelForce\StructType\User $contentModifiedBy = null, $contentModifiedById = null, $contentModifiedDate = null, $contentSize = null, $contentUrl = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $description = null, \NexusDigital/MiratelForce\StructType\ExternalDataSource $externalDataSource = null, $externalDataSourceId = null, $externalDocumentInfo1 = null, $externalDocumentInfo2 = null, $featuredContentBoost = null, $featuredContentDate = null, $fileExtension = null, $fileType = null, \NexusDigital/MiratelForce\StructType\SObject $firstPublishLocation = null, $firstPublishLocationId = null, \NexusDigital/MiratelForce\StructType\QueryResult $histories = null, $isAssetEnabled = null, $isDeleted = null, $isLatest = null, $isMajorVersion = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $negativeRatingCount = null, $networkId = null, $origin = null, \NexusDigital/MiratelForce\StructType\User $owner = null, $ownerId = null, $pathOnClient = null, $positiveRatingCount = null, $publishStatus = null, $ratingCount = null, $reasonForChange = null, $sharingOption = null, $sharingPrivacy = null, $systemModstamp = null, $tagCsv = null, $textPreview = null, $title = null, $versionData = null, $versionNumber = null)
    {
        $this
            ->setAuditableEntities($auditableEntities)
            ->setChecksum($checksum)
            ->setContentDocument($contentDocument)
            ->setContentDocumentId($contentDocumentId)
            ->setContentLocation($contentLocation)
            ->setContentModifiedBy($contentModifiedBy)
            ->setContentModifiedById($contentModifiedById)
            ->setContentModifiedDate($contentModifiedDate)
            ->setContentSize($contentSize)
            ->setContentUrl($contentUrl)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDescription($description)
            ->setExternalDataSource($externalDataSource)
            ->setExternalDataSourceId($externalDataSourceId)
            ->setExternalDocumentInfo1($externalDocumentInfo1)
            ->setExternalDocumentInfo2($externalDocumentInfo2)
            ->setFeaturedContentBoost($featuredContentBoost)
            ->setFeaturedContentDate($featuredContentDate)
            ->setFileExtension($fileExtension)
            ->setFileType($fileType)
            ->setFirstPublishLocation($firstPublishLocation)
            ->setFirstPublishLocationId($firstPublishLocationId)
            ->setHistories($histories)
            ->setIsAssetEnabled($isAssetEnabled)
            ->setIsDeleted($isDeleted)
            ->setIsLatest($isLatest)
            ->setIsMajorVersion($isMajorVersion)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setNegativeRatingCount($negativeRatingCount)
            ->setNetworkId($networkId)
            ->setOrigin($origin)
            ->setOwner($owner)
            ->setOwnerId($ownerId)
            ->setPathOnClient($pathOnClient)
            ->setPositiveRatingCount($positiveRatingCount)
            ->setPublishStatus($publishStatus)
            ->setRatingCount($ratingCount)
            ->setReasonForChange($reasonForChange)
            ->setSharingOption($sharingOption)
            ->setSharingPrivacy($sharingPrivacy)
            ->setSystemModstamp($systemModstamp)
            ->setTagCsv($tagCsv)
            ->setTextPreview($textPreview)
            ->setTitle($title)
            ->setVersionData($versionData)
            ->setVersionNumber($versionNumber);
    }
    /**
     * Get AuditableEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAuditableEntities()
    {
        return isset($this->AuditableEntities) ? $this->AuditableEntities : null;
    }
    /**
     * Set AuditableEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $auditableEntities
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setAuditableEntities(\NexusDigital/MiratelForce\StructType\QueryResult $auditableEntities = null)
    {
        if (is_null($auditableEntities) || (is_array($auditableEntities) && empty($auditableEntities))) {
            unset($this->AuditableEntities);
        } else {
            $this->AuditableEntities = $auditableEntities;
        }
        return $this;
    }
    /**
     * Get Checksum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChecksum()
    {
        return isset($this->Checksum) ? $this->Checksum : null;
    }
    /**
     * Set Checksum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checksum
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setChecksum($checksum = null)
    {
        // validation for constraint: string
        if (!is_null($checksum) && !is_string($checksum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checksum, true), gettype($checksum)), __LINE__);
        }
        if (is_null($checksum) || (is_array($checksum) && empty($checksum))) {
            unset($this->Checksum);
        } else {
            $this->Checksum = $checksum;
        }
        return $this;
    }
    /**
     * Get ContentDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ContentDocument|null
     */
    public function getContentDocument()
    {
        return isset($this->ContentDocument) ? $this->ContentDocument : null;
    }
    /**
     * Set ContentDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ContentDocument $contentDocument
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setContentDocument(\NexusDigital/MiratelForce\StructType\ContentDocument $contentDocument = null)
    {
        if (is_null($contentDocument) || (is_array($contentDocument) && empty($contentDocument))) {
            unset($this->ContentDocument);
        } else {
            $this->ContentDocument = $contentDocument;
        }
        return $this;
    }
    /**
     * Get ContentDocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentDocumentId()
    {
        return isset($this->ContentDocumentId) ? $this->ContentDocumentId : null;
    }
    /**
     * Set ContentDocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentDocumentId
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setContentDocumentId($contentDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($contentDocumentId) && !is_string($contentDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentDocumentId, true), gettype($contentDocumentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($contentDocumentId) && mb_strlen($contentDocumentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($contentDocumentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($contentDocumentId) && !preg_match('/[a-zA-Z0-9]{18}/', $contentDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($contentDocumentId, true)), __LINE__);
        }
        if (is_null($contentDocumentId) || (is_array($contentDocumentId) && empty($contentDocumentId))) {
            unset($this->ContentDocumentId);
        } else {
            $this->ContentDocumentId = $contentDocumentId;
        }
        return $this;
    }
    /**
     * Get ContentLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentLocation()
    {
        return isset($this->ContentLocation) ? $this->ContentLocation : null;
    }
    /**
     * Set ContentLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentLocation
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setContentLocation($contentLocation = null)
    {
        // validation for constraint: string
        if (!is_null($contentLocation) && !is_string($contentLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentLocation, true), gettype($contentLocation)), __LINE__);
        }
        if (is_null($contentLocation) || (is_array($contentLocation) && empty($contentLocation))) {
            unset($this->ContentLocation);
        } else {
            $this->ContentLocation = $contentLocation;
        }
        return $this;
    }
    /**
     * Get ContentModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getContentModifiedBy()
    {
        return isset($this->ContentModifiedBy) ? $this->ContentModifiedBy : null;
    }
    /**
     * Set ContentModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $contentModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setContentModifiedBy(\NexusDigital/MiratelForce\StructType\User $contentModifiedBy = null)
    {
        if (is_null($contentModifiedBy) || (is_array($contentModifiedBy) && empty($contentModifiedBy))) {
            unset($this->ContentModifiedBy);
        } else {
            $this->ContentModifiedBy = $contentModifiedBy;
        }
        return $this;
    }
    /**
     * Get ContentModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentModifiedById()
    {
        return isset($this->ContentModifiedById) ? $this->ContentModifiedById : null;
    }
    /**
     * Set ContentModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentModifiedById
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setContentModifiedById($contentModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($contentModifiedById) && !is_string($contentModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentModifiedById, true), gettype($contentModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($contentModifiedById) && mb_strlen($contentModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($contentModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($contentModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $contentModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($contentModifiedById, true)), __LINE__);
        }
        if (is_null($contentModifiedById) || (is_array($contentModifiedById) && empty($contentModifiedById))) {
            unset($this->ContentModifiedById);
        } else {
            $this->ContentModifiedById = $contentModifiedById;
        }
        return $this;
    }
    /**
     * Get ContentModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentModifiedDate()
    {
        return isset($this->ContentModifiedDate) ? $this->ContentModifiedDate : null;
    }
    /**
     * Set ContentModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setContentModifiedDate($contentModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($contentModifiedDate) && !is_string($contentModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentModifiedDate, true), gettype($contentModifiedDate)), __LINE__);
        }
        if (is_null($contentModifiedDate) || (is_array($contentModifiedDate) && empty($contentModifiedDate))) {
            unset($this->ContentModifiedDate);
        } else {
            $this->ContentModifiedDate = $contentModifiedDate;
        }
        return $this;
    }
    /**
     * Get ContentSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getContentSize()
    {
        return isset($this->ContentSize) ? $this->ContentSize : null;
    }
    /**
     * Set ContentSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $contentSize
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setContentSize($contentSize = null)
    {
        // validation for constraint: int
        if (!is_null($contentSize) && !(is_int($contentSize) || ctype_digit($contentSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contentSize, true), gettype($contentSize)), __LINE__);
        }
        if (is_null($contentSize) || (is_array($contentSize) && empty($contentSize))) {
            unset($this->ContentSize);
        } else {
            $this->ContentSize = $contentSize;
        }
        return $this;
    }
    /**
     * Get ContentUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentUrl()
    {
        return isset($this->ContentUrl) ? $this->ContentUrl : null;
    }
    /**
     * Set ContentUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentUrl
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setContentUrl($contentUrl = null)
    {
        // validation for constraint: string
        if (!is_null($contentUrl) && !is_string($contentUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentUrl, true), gettype($contentUrl)), __LINE__);
        }
        if (is_null($contentUrl) || (is_array($contentUrl) && empty($contentUrl))) {
            unset($this->ContentUrl);
        } else {
            $this->ContentUrl = $contentUrl;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExternalDataSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ExternalDataSource|null
     */
    public function getExternalDataSource()
    {
        return isset($this->ExternalDataSource) ? $this->ExternalDataSource : null;
    }
    /**
     * Set ExternalDataSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ExternalDataSource $externalDataSource
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setExternalDataSource(\NexusDigital/MiratelForce\StructType\ExternalDataSource $externalDataSource = null)
    {
        if (is_null($externalDataSource) || (is_array($externalDataSource) && empty($externalDataSource))) {
            unset($this->ExternalDataSource);
        } else {
            $this->ExternalDataSource = $externalDataSource;
        }
        return $this;
    }
    /**
     * Get ExternalDataSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalDataSourceId()
    {
        return isset($this->ExternalDataSourceId) ? $this->ExternalDataSourceId : null;
    }
    /**
     * Set ExternalDataSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalDataSourceId
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setExternalDataSourceId($externalDataSourceId = null)
    {
        // validation for constraint: string
        if (!is_null($externalDataSourceId) && !is_string($externalDataSourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalDataSourceId, true), gettype($externalDataSourceId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($externalDataSourceId) && mb_strlen($externalDataSourceId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($externalDataSourceId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($externalDataSourceId) && !preg_match('/[a-zA-Z0-9]{18}/', $externalDataSourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($externalDataSourceId, true)), __LINE__);
        }
        if (is_null($externalDataSourceId) || (is_array($externalDataSourceId) && empty($externalDataSourceId))) {
            unset($this->ExternalDataSourceId);
        } else {
            $this->ExternalDataSourceId = $externalDataSourceId;
        }
        return $this;
    }
    /**
     * Get ExternalDocumentInfo1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalDocumentInfo1()
    {
        return isset($this->ExternalDocumentInfo1) ? $this->ExternalDocumentInfo1 : null;
    }
    /**
     * Set ExternalDocumentInfo1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalDocumentInfo1
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setExternalDocumentInfo1($externalDocumentInfo1 = null)
    {
        // validation for constraint: string
        if (!is_null($externalDocumentInfo1) && !is_string($externalDocumentInfo1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalDocumentInfo1, true), gettype($externalDocumentInfo1)), __LINE__);
        }
        if (is_null($externalDocumentInfo1) || (is_array($externalDocumentInfo1) && empty($externalDocumentInfo1))) {
            unset($this->ExternalDocumentInfo1);
        } else {
            $this->ExternalDocumentInfo1 = $externalDocumentInfo1;
        }
        return $this;
    }
    /**
     * Get ExternalDocumentInfo2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalDocumentInfo2()
    {
        return isset($this->ExternalDocumentInfo2) ? $this->ExternalDocumentInfo2 : null;
    }
    /**
     * Set ExternalDocumentInfo2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalDocumentInfo2
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setExternalDocumentInfo2($externalDocumentInfo2 = null)
    {
        // validation for constraint: string
        if (!is_null($externalDocumentInfo2) && !is_string($externalDocumentInfo2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalDocumentInfo2, true), gettype($externalDocumentInfo2)), __LINE__);
        }
        if (is_null($externalDocumentInfo2) || (is_array($externalDocumentInfo2) && empty($externalDocumentInfo2))) {
            unset($this->ExternalDocumentInfo2);
        } else {
            $this->ExternalDocumentInfo2 = $externalDocumentInfo2;
        }
        return $this;
    }
    /**
     * Get FeaturedContentBoost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFeaturedContentBoost()
    {
        return isset($this->FeaturedContentBoost) ? $this->FeaturedContentBoost : null;
    }
    /**
     * Set FeaturedContentBoost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $featuredContentBoost
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setFeaturedContentBoost($featuredContentBoost = null)
    {
        // validation for constraint: int
        if (!is_null($featuredContentBoost) && !(is_int($featuredContentBoost) || ctype_digit($featuredContentBoost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($featuredContentBoost, true), gettype($featuredContentBoost)), __LINE__);
        }
        if (is_null($featuredContentBoost) || (is_array($featuredContentBoost) && empty($featuredContentBoost))) {
            unset($this->FeaturedContentBoost);
        } else {
            $this->FeaturedContentBoost = $featuredContentBoost;
        }
        return $this;
    }
    /**
     * Get FeaturedContentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFeaturedContentDate()
    {
        return isset($this->FeaturedContentDate) ? $this->FeaturedContentDate : null;
    }
    /**
     * Set FeaturedContentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $featuredContentDate
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setFeaturedContentDate($featuredContentDate = null)
    {
        // validation for constraint: string
        if (!is_null($featuredContentDate) && !is_string($featuredContentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($featuredContentDate, true), gettype($featuredContentDate)), __LINE__);
        }
        if (is_null($featuredContentDate) || (is_array($featuredContentDate) && empty($featuredContentDate))) {
            unset($this->FeaturedContentDate);
        } else {
            $this->FeaturedContentDate = $featuredContentDate;
        }
        return $this;
    }
    /**
     * Get FileExtension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileExtension()
    {
        return isset($this->FileExtension) ? $this->FileExtension : null;
    }
    /**
     * Set FileExtension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileExtension
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setFileExtension($fileExtension = null)
    {
        // validation for constraint: string
        if (!is_null($fileExtension) && !is_string($fileExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileExtension, true), gettype($fileExtension)), __LINE__);
        }
        if (is_null($fileExtension) || (is_array($fileExtension) && empty($fileExtension))) {
            unset($this->FileExtension);
        } else {
            $this->FileExtension = $fileExtension;
        }
        return $this;
    }
    /**
     * Get FileType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileType()
    {
        return isset($this->FileType) ? $this->FileType : null;
    }
    /**
     * Set FileType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileType
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setFileType($fileType = null)
    {
        // validation for constraint: string
        if (!is_null($fileType) && !is_string($fileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileType, true), gettype($fileType)), __LINE__);
        }
        if (is_null($fileType) || (is_array($fileType) && empty($fileType))) {
            unset($this->FileType);
        } else {
            $this->FileType = $fileType;
        }
        return $this;
    }
    /**
     * Get FirstPublishLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getFirstPublishLocation()
    {
        return isset($this->FirstPublishLocation) ? $this->FirstPublishLocation : null;
    }
    /**
     * Set FirstPublishLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $firstPublishLocation
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setFirstPublishLocation(\NexusDigital/MiratelForce\StructType\SObject $firstPublishLocation = null)
    {
        if (is_null($firstPublishLocation) || (is_array($firstPublishLocation) && empty($firstPublishLocation))) {
            unset($this->FirstPublishLocation);
        } else {
            $this->FirstPublishLocation = $firstPublishLocation;
        }
        return $this;
    }
    /**
     * Get FirstPublishLocationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstPublishLocationId()
    {
        return isset($this->FirstPublishLocationId) ? $this->FirstPublishLocationId : null;
    }
    /**
     * Set FirstPublishLocationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstPublishLocationId
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setFirstPublishLocationId($firstPublishLocationId = null)
    {
        // validation for constraint: string
        if (!is_null($firstPublishLocationId) && !is_string($firstPublishLocationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstPublishLocationId, true), gettype($firstPublishLocationId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($firstPublishLocationId) && mb_strlen($firstPublishLocationId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($firstPublishLocationId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($firstPublishLocationId) && !preg_match('/[a-zA-Z0-9]{18}/', $firstPublishLocationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($firstPublishLocationId, true)), __LINE__);
        }
        if (is_null($firstPublishLocationId) || (is_array($firstPublishLocationId) && empty($firstPublishLocationId))) {
            unset($this->FirstPublishLocationId);
        } else {
            $this->FirstPublishLocationId = $firstPublishLocationId;
        }
        return $this;
    }
    /**
     * Get Histories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getHistories()
    {
        return isset($this->Histories) ? $this->Histories : null;
    }
    /**
     * Set Histories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setHistories(\NexusDigital/MiratelForce\StructType\QueryResult $histories = null)
    {
        if (is_null($histories) || (is_array($histories) && empty($histories))) {
            unset($this->Histories);
        } else {
            $this->Histories = $histories;
        }
        return $this;
    }
    /**
     * Get IsAssetEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAssetEnabled()
    {
        return isset($this->IsAssetEnabled) ? $this->IsAssetEnabled : null;
    }
    /**
     * Set IsAssetEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAssetEnabled
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setIsAssetEnabled($isAssetEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAssetEnabled) && !is_bool($isAssetEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAssetEnabled, true), gettype($isAssetEnabled)), __LINE__);
        }
        if (is_null($isAssetEnabled) || (is_array($isAssetEnabled) && empty($isAssetEnabled))) {
            unset($this->IsAssetEnabled);
        } else {
            $this->IsAssetEnabled = $isAssetEnabled;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsLatest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsLatest()
    {
        return isset($this->IsLatest) ? $this->IsLatest : null;
    }
    /**
     * Set IsLatest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isLatest
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setIsLatest($isLatest = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLatest) && !is_bool($isLatest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLatest, true), gettype($isLatest)), __LINE__);
        }
        if (is_null($isLatest) || (is_array($isLatest) && empty($isLatest))) {
            unset($this->IsLatest);
        } else {
            $this->IsLatest = $isLatest;
        }
        return $this;
    }
    /**
     * Get IsMajorVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMajorVersion()
    {
        return isset($this->IsMajorVersion) ? $this->IsMajorVersion : null;
    }
    /**
     * Set IsMajorVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMajorVersion
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setIsMajorVersion($isMajorVersion = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMajorVersion) && !is_bool($isMajorVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMajorVersion, true), gettype($isMajorVersion)), __LINE__);
        }
        if (is_null($isMajorVersion) || (is_array($isMajorVersion) && empty($isMajorVersion))) {
            unset($this->IsMajorVersion);
        } else {
            $this->IsMajorVersion = $isMajorVersion;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get NegativeRatingCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNegativeRatingCount()
    {
        return isset($this->NegativeRatingCount) ? $this->NegativeRatingCount : null;
    }
    /**
     * Set NegativeRatingCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $negativeRatingCount
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setNegativeRatingCount($negativeRatingCount = null)
    {
        // validation for constraint: int
        if (!is_null($negativeRatingCount) && !(is_int($negativeRatingCount) || ctype_digit($negativeRatingCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($negativeRatingCount, true), gettype($negativeRatingCount)), __LINE__);
        }
        if (is_null($negativeRatingCount) || (is_array($negativeRatingCount) && empty($negativeRatingCount))) {
            unset($this->NegativeRatingCount);
        } else {
            $this->NegativeRatingCount = $negativeRatingCount;
        }
        return $this;
    }
    /**
     * Get NetworkId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkId()
    {
        return isset($this->NetworkId) ? $this->NetworkId : null;
    }
    /**
     * Set NetworkId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkId
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setNetworkId($networkId = null)
    {
        // validation for constraint: string
        if (!is_null($networkId) && !is_string($networkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($networkId, true), gettype($networkId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($networkId) && mb_strlen($networkId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($networkId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($networkId) && !preg_match('/[a-zA-Z0-9]{18}/', $networkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($networkId, true)), __LINE__);
        }
        if (is_null($networkId) || (is_array($networkId) && empty($networkId))) {
            unset($this->NetworkId);
        } else {
            $this->NetworkId = $networkId;
        }
        return $this;
    }
    /**
     * Get Origin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrigin()
    {
        return isset($this->Origin) ? $this->Origin : null;
    }
    /**
     * Set Origin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $origin
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        if (is_null($origin) || (is_array($origin) && empty($origin))) {
            unset($this->Origin);
        } else {
            $this->Origin = $origin;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $owner
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setOwner(\NexusDigital/MiratelForce\StructType\User $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ownerId) && mb_strlen($ownerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ownerId) && !preg_match('/[a-zA-Z0-9]{18}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get PathOnClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPathOnClient()
    {
        return isset($this->PathOnClient) ? $this->PathOnClient : null;
    }
    /**
     * Set PathOnClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pathOnClient
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setPathOnClient($pathOnClient = null)
    {
        // validation for constraint: string
        if (!is_null($pathOnClient) && !is_string($pathOnClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pathOnClient, true), gettype($pathOnClient)), __LINE__);
        }
        if (is_null($pathOnClient) || (is_array($pathOnClient) && empty($pathOnClient))) {
            unset($this->PathOnClient);
        } else {
            $this->PathOnClient = $pathOnClient;
        }
        return $this;
    }
    /**
     * Get PositiveRatingCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPositiveRatingCount()
    {
        return isset($this->PositiveRatingCount) ? $this->PositiveRatingCount : null;
    }
    /**
     * Set PositiveRatingCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $positiveRatingCount
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setPositiveRatingCount($positiveRatingCount = null)
    {
        // validation for constraint: int
        if (!is_null($positiveRatingCount) && !(is_int($positiveRatingCount) || ctype_digit($positiveRatingCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($positiveRatingCount, true), gettype($positiveRatingCount)), __LINE__);
        }
        if (is_null($positiveRatingCount) || (is_array($positiveRatingCount) && empty($positiveRatingCount))) {
            unset($this->PositiveRatingCount);
        } else {
            $this->PositiveRatingCount = $positiveRatingCount;
        }
        return $this;
    }
    /**
     * Get PublishStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPublishStatus()
    {
        return isset($this->PublishStatus) ? $this->PublishStatus : null;
    }
    /**
     * Set PublishStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $publishStatus
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setPublishStatus($publishStatus = null)
    {
        // validation for constraint: string
        if (!is_null($publishStatus) && !is_string($publishStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publishStatus, true), gettype($publishStatus)), __LINE__);
        }
        if (is_null($publishStatus) || (is_array($publishStatus) && empty($publishStatus))) {
            unset($this->PublishStatus);
        } else {
            $this->PublishStatus = $publishStatus;
        }
        return $this;
    }
    /**
     * Get RatingCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRatingCount()
    {
        return isset($this->RatingCount) ? $this->RatingCount : null;
    }
    /**
     * Set RatingCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ratingCount
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setRatingCount($ratingCount = null)
    {
        // validation for constraint: int
        if (!is_null($ratingCount) && !(is_int($ratingCount) || ctype_digit($ratingCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ratingCount, true), gettype($ratingCount)), __LINE__);
        }
        if (is_null($ratingCount) || (is_array($ratingCount) && empty($ratingCount))) {
            unset($this->RatingCount);
        } else {
            $this->RatingCount = $ratingCount;
        }
        return $this;
    }
    /**
     * Get ReasonForChange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReasonForChange()
    {
        return isset($this->ReasonForChange) ? $this->ReasonForChange : null;
    }
    /**
     * Set ReasonForChange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reasonForChange
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setReasonForChange($reasonForChange = null)
    {
        // validation for constraint: string
        if (!is_null($reasonForChange) && !is_string($reasonForChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonForChange, true), gettype($reasonForChange)), __LINE__);
        }
        if (is_null($reasonForChange) || (is_array($reasonForChange) && empty($reasonForChange))) {
            unset($this->ReasonForChange);
        } else {
            $this->ReasonForChange = $reasonForChange;
        }
        return $this;
    }
    /**
     * Get SharingOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharingOption()
    {
        return isset($this->SharingOption) ? $this->SharingOption : null;
    }
    /**
     * Set SharingOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sharingOption
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setSharingOption($sharingOption = null)
    {
        // validation for constraint: string
        if (!is_null($sharingOption) && !is_string($sharingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sharingOption, true), gettype($sharingOption)), __LINE__);
        }
        if (is_null($sharingOption) || (is_array($sharingOption) && empty($sharingOption))) {
            unset($this->SharingOption);
        } else {
            $this->SharingOption = $sharingOption;
        }
        return $this;
    }
    /**
     * Get SharingPrivacy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharingPrivacy()
    {
        return isset($this->SharingPrivacy) ? $this->SharingPrivacy : null;
    }
    /**
     * Set SharingPrivacy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sharingPrivacy
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setSharingPrivacy($sharingPrivacy = null)
    {
        // validation for constraint: string
        if (!is_null($sharingPrivacy) && !is_string($sharingPrivacy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sharingPrivacy, true), gettype($sharingPrivacy)), __LINE__);
        }
        if (is_null($sharingPrivacy) || (is_array($sharingPrivacy) && empty($sharingPrivacy))) {
            unset($this->SharingPrivacy);
        } else {
            $this->SharingPrivacy = $sharingPrivacy;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TagCsv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTagCsv()
    {
        return isset($this->TagCsv) ? $this->TagCsv : null;
    }
    /**
     * Set TagCsv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tagCsv
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setTagCsv($tagCsv = null)
    {
        // validation for constraint: string
        if (!is_null($tagCsv) && !is_string($tagCsv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tagCsv, true), gettype($tagCsv)), __LINE__);
        }
        if (is_null($tagCsv) || (is_array($tagCsv) && empty($tagCsv))) {
            unset($this->TagCsv);
        } else {
            $this->TagCsv = $tagCsv;
        }
        return $this;
    }
    /**
     * Get TextPreview value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTextPreview()
    {
        return isset($this->TextPreview) ? $this->TextPreview : null;
    }
    /**
     * Set TextPreview value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $textPreview
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setTextPreview($textPreview = null)
    {
        // validation for constraint: string
        if (!is_null($textPreview) && !is_string($textPreview)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($textPreview, true), gettype($textPreview)), __LINE__);
        }
        if (is_null($textPreview) || (is_array($textPreview) && empty($textPreview))) {
            unset($this->TextPreview);
        } else {
            $this->TextPreview = $textPreview;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get VersionData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVersionData()
    {
        return isset($this->VersionData) ? $this->VersionData : null;
    }
    /**
     * Set VersionData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $versionData
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setVersionData($versionData = null)
    {
        // validation for constraint: string
        if (!is_null($versionData) && !is_string($versionData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versionData, true), gettype($versionData)), __LINE__);
        }
        if (is_null($versionData) || (is_array($versionData) && empty($versionData))) {
            unset($this->VersionData);
        } else {
            $this->VersionData = $versionData;
        }
        return $this;
    }
    /**
     * Get VersionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVersionNumber()
    {
        return isset($this->VersionNumber) ? $this->VersionNumber : null;
    }
    /**
     * Set VersionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $versionNumber
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public function setVersionNumber($versionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($versionNumber) && !is_string($versionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versionNumber, true), gettype($versionNumber)), __LINE__);
        }
        if (is_null($versionNumber) || (is_array($versionNumber) && empty($versionNumber))) {
            unset($this->VersionNumber);
        } else {
            $this->VersionNumber = $versionNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
