<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentUserSubscription StructType
 * @subpackage Structs
 */
class ContentUserSubscription extends SObject
{
    /**
     * The SubscribedToUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $SubscribedToUser;
    /**
     * The SubscribedToUserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $SubscribedToUserId;
    /**
     * The SubscriberUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $SubscriberUser;
    /**
     * The SubscriberUserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $SubscriberUserId;
    /**
     * Constructor method for ContentUserSubscription
     * @uses ContentUserSubscription::setSubscribedToUser()
     * @uses ContentUserSubscription::setSubscribedToUserId()
     * @uses ContentUserSubscription::setSubscriberUser()
     * @uses ContentUserSubscription::setSubscriberUserId()
     * @param \NexusDigital/MiratelForce\StructType\User $subscribedToUser
     * @param string $subscribedToUserId
     * @param \NexusDigital/MiratelForce\StructType\User $subscriberUser
     * @param string $subscriberUserId
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\User $subscribedToUser = null, $subscribedToUserId = null, \NexusDigital/MiratelForce\StructType\User $subscriberUser = null, $subscriberUserId = null)
    {
        $this
            ->setSubscribedToUser($subscribedToUser)
            ->setSubscribedToUserId($subscribedToUserId)
            ->setSubscriberUser($subscriberUser)
            ->setSubscriberUserId($subscriberUserId);
    }
    /**
     * Get SubscribedToUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getSubscribedToUser()
    {
        return isset($this->SubscribedToUser) ? $this->SubscribedToUser : null;
    }
    /**
     * Set SubscribedToUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $subscribedToUser
     * @return \NexusDigital/MiratelForce\StructType\ContentUserSubscription
     */
    public function setSubscribedToUser(\NexusDigital/MiratelForce\StructType\User $subscribedToUser = null)
    {
        if (is_null($subscribedToUser) || (is_array($subscribedToUser) && empty($subscribedToUser))) {
            unset($this->SubscribedToUser);
        } else {
            $this->SubscribedToUser = $subscribedToUser;
        }
        return $this;
    }
    /**
     * Get SubscribedToUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscribedToUserId()
    {
        return isset($this->SubscribedToUserId) ? $this->SubscribedToUserId : null;
    }
    /**
     * Set SubscribedToUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscribedToUserId
     * @return \NexusDigital/MiratelForce\StructType\ContentUserSubscription
     */
    public function setSubscribedToUserId($subscribedToUserId = null)
    {
        // validation for constraint: string
        if (!is_null($subscribedToUserId) && !is_string($subscribedToUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscribedToUserId, true), gettype($subscribedToUserId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($subscribedToUserId) && mb_strlen($subscribedToUserId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($subscribedToUserId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($subscribedToUserId) && !preg_match('/[a-zA-Z0-9]{18}/', $subscribedToUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($subscribedToUserId, true)), __LINE__);
        }
        if (is_null($subscribedToUserId) || (is_array($subscribedToUserId) && empty($subscribedToUserId))) {
            unset($this->SubscribedToUserId);
        } else {
            $this->SubscribedToUserId = $subscribedToUserId;
        }
        return $this;
    }
    /**
     * Get SubscriberUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getSubscriberUser()
    {
        return isset($this->SubscriberUser) ? $this->SubscriberUser : null;
    }
    /**
     * Set SubscriberUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $subscriberUser
     * @return \NexusDigital/MiratelForce\StructType\ContentUserSubscription
     */
    public function setSubscriberUser(\NexusDigital/MiratelForce\StructType\User $subscriberUser = null)
    {
        if (is_null($subscriberUser) || (is_array($subscriberUser) && empty($subscriberUser))) {
            unset($this->SubscriberUser);
        } else {
            $this->SubscriberUser = $subscriberUser;
        }
        return $this;
    }
    /**
     * Get SubscriberUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberUserId()
    {
        return isset($this->SubscriberUserId) ? $this->SubscriberUserId : null;
    }
    /**
     * Set SubscriberUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriberUserId
     * @return \NexusDigital/MiratelForce\StructType\ContentUserSubscription
     */
    public function setSubscriberUserId($subscriberUserId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberUserId) && !is_string($subscriberUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberUserId, true), gettype($subscriberUserId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($subscriberUserId) && mb_strlen($subscriberUserId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($subscriberUserId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($subscriberUserId) && !preg_match('/[a-zA-Z0-9]{18}/', $subscriberUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($subscriberUserId, true)), __LINE__);
        }
        if (is_null($subscriberUserId) || (is_array($subscriberUserId) && empty($subscriberUserId))) {
            unset($this->SubscriberUserId);
        } else {
            $this->SubscriberUserId = $subscriberUserId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ContentUserSubscription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
