<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentDocumentLink StructType
 * @subpackage Structs
 */
class ContentDocumentLink extends SObject
{
    /**
     * The ContentDocument
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ContentDocument
     */
    public $ContentDocument;
    /**
     * The ContentDocumentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ContentDocumentId;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The LinkedEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $LinkedEntity;
    /**
     * The LinkedEntityId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LinkedEntityId;
    /**
     * The ShareType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShareType;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The Visibility
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Visibility;
    /**
     * Constructor method for ContentDocumentLink
     * @uses ContentDocumentLink::setContentDocument()
     * @uses ContentDocumentLink::setContentDocumentId()
     * @uses ContentDocumentLink::setIsDeleted()
     * @uses ContentDocumentLink::setLinkedEntity()
     * @uses ContentDocumentLink::setLinkedEntityId()
     * @uses ContentDocumentLink::setShareType()
     * @uses ContentDocumentLink::setSystemModstamp()
     * @uses ContentDocumentLink::setVisibility()
     * @param \NexusDigital/MiratelForce\StructType\ContentDocument $contentDocument
     * @param string $contentDocumentId
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\SObject $linkedEntity
     * @param string $linkedEntityId
     * @param string $shareType
     * @param string $systemModstamp
     * @param string $visibility
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\ContentDocument $contentDocument = null, $contentDocumentId = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\SObject $linkedEntity = null, $linkedEntityId = null, $shareType = null, $systemModstamp = null, $visibility = null)
    {
        $this
            ->setContentDocument($contentDocument)
            ->setContentDocumentId($contentDocumentId)
            ->setIsDeleted($isDeleted)
            ->setLinkedEntity($linkedEntity)
            ->setLinkedEntityId($linkedEntityId)
            ->setShareType($shareType)
            ->setSystemModstamp($systemModstamp)
            ->setVisibility($visibility);
    }
    /**
     * Get ContentDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ContentDocument|null
     */
    public function getContentDocument()
    {
        return isset($this->ContentDocument) ? $this->ContentDocument : null;
    }
    /**
     * Set ContentDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ContentDocument $contentDocument
     * @return \NexusDigital/MiratelForce\StructType\ContentDocumentLink
     */
    public function setContentDocument(\NexusDigital/MiratelForce\StructType\ContentDocument $contentDocument = null)
    {
        if (is_null($contentDocument) || (is_array($contentDocument) && empty($contentDocument))) {
            unset($this->ContentDocument);
        } else {
            $this->ContentDocument = $contentDocument;
        }
        return $this;
    }
    /**
     * Get ContentDocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentDocumentId()
    {
        return isset($this->ContentDocumentId) ? $this->ContentDocumentId : null;
    }
    /**
     * Set ContentDocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentDocumentId
     * @return \NexusDigital/MiratelForce\StructType\ContentDocumentLink
     */
    public function setContentDocumentId($contentDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($contentDocumentId) && !is_string($contentDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentDocumentId, true), gettype($contentDocumentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($contentDocumentId) && mb_strlen($contentDocumentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($contentDocumentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($contentDocumentId) && !preg_match('/[a-zA-Z0-9]{18}/', $contentDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($contentDocumentId, true)), __LINE__);
        }
        if (is_null($contentDocumentId) || (is_array($contentDocumentId) && empty($contentDocumentId))) {
            unset($this->ContentDocumentId);
        } else {
            $this->ContentDocumentId = $contentDocumentId;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\ContentDocumentLink
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get LinkedEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getLinkedEntity()
    {
        return isset($this->LinkedEntity) ? $this->LinkedEntity : null;
    }
    /**
     * Set LinkedEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $linkedEntity
     * @return \NexusDigital/MiratelForce\StructType\ContentDocumentLink
     */
    public function setLinkedEntity(\NexusDigital/MiratelForce\StructType\SObject $linkedEntity = null)
    {
        if (is_null($linkedEntity) || (is_array($linkedEntity) && empty($linkedEntity))) {
            unset($this->LinkedEntity);
        } else {
            $this->LinkedEntity = $linkedEntity;
        }
        return $this;
    }
    /**
     * Get LinkedEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkedEntityId()
    {
        return isset($this->LinkedEntityId) ? $this->LinkedEntityId : null;
    }
    /**
     * Set LinkedEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkedEntityId
     * @return \NexusDigital/MiratelForce\StructType\ContentDocumentLink
     */
    public function setLinkedEntityId($linkedEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($linkedEntityId) && !is_string($linkedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedEntityId, true), gettype($linkedEntityId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($linkedEntityId) && mb_strlen($linkedEntityId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($linkedEntityId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($linkedEntityId) && !preg_match('/[a-zA-Z0-9]{18}/', $linkedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($linkedEntityId, true)), __LINE__);
        }
        if (is_null($linkedEntityId) || (is_array($linkedEntityId) && empty($linkedEntityId))) {
            unset($this->LinkedEntityId);
        } else {
            $this->LinkedEntityId = $linkedEntityId;
        }
        return $this;
    }
    /**
     * Get ShareType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShareType()
    {
        return isset($this->ShareType) ? $this->ShareType : null;
    }
    /**
     * Set ShareType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shareType
     * @return \NexusDigital/MiratelForce\StructType\ContentDocumentLink
     */
    public function setShareType($shareType = null)
    {
        // validation for constraint: string
        if (!is_null($shareType) && !is_string($shareType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareType, true), gettype($shareType)), __LINE__);
        }
        if (is_null($shareType) || (is_array($shareType) && empty($shareType))) {
            unset($this->ShareType);
        } else {
            $this->ShareType = $shareType;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ContentDocumentLink
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get Visibility value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisibility()
    {
        return isset($this->Visibility) ? $this->Visibility : null;
    }
    /**
     * Set Visibility value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visibility
     * @return \NexusDigital/MiratelForce\StructType\ContentDocumentLink
     */
    public function setVisibility($visibility = null)
    {
        // validation for constraint: string
        if (!is_null($visibility) && !is_string($visibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visibility, true), gettype($visibility)), __LINE__);
        }
        if (is_null($visibility) || (is_array($visibility) && empty($visibility))) {
            unset($this->Visibility);
        } else {
            $this->Visibility = $visibility;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ContentDocumentLink
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
