<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectedApplication StructType
 * @subpackage Structs
 */
class ConnectedApplication extends SObject
{
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The InstalledMobileApps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $InstalledMobileApps;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The MobileSessionTimeout
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileSessionTimeout;
    /**
     * The MobileStartUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileStartUrl;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OptionsAllowAdminApprovedUsersOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsAllowAdminApprovedUsersOnly;
    /**
     * The OptionsFullContentPushNotifications
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsFullContentPushNotifications;
    /**
     * The OptionsHasSessionLevelPolicy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsHasSessionLevelPolicy;
    /**
     * The OptionsIsInternal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsIsInternal;
    /**
     * The OptionsRefreshTokenValidityMetric
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsRefreshTokenValidityMetric;
    /**
     * The PinLength
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PinLength;
    /**
     * The RefreshTokenValidityPeriod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RefreshTokenValidityPeriod;
    /**
     * The SetupEntityAccessItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $SetupEntityAccessItems;
    /**
     * The StartUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartUrl;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for ConnectedApplication
     * @uses ConnectedApplication::setCreatedBy()
     * @uses ConnectedApplication::setCreatedById()
     * @uses ConnectedApplication::setCreatedDate()
     * @uses ConnectedApplication::setInstalledMobileApps()
     * @uses ConnectedApplication::setLastModifiedBy()
     * @uses ConnectedApplication::setLastModifiedById()
     * @uses ConnectedApplication::setLastModifiedDate()
     * @uses ConnectedApplication::setMobileSessionTimeout()
     * @uses ConnectedApplication::setMobileStartUrl()
     * @uses ConnectedApplication::setName()
     * @uses ConnectedApplication::setOptionsAllowAdminApprovedUsersOnly()
     * @uses ConnectedApplication::setOptionsFullContentPushNotifications()
     * @uses ConnectedApplication::setOptionsHasSessionLevelPolicy()
     * @uses ConnectedApplication::setOptionsIsInternal()
     * @uses ConnectedApplication::setOptionsRefreshTokenValidityMetric()
     * @uses ConnectedApplication::setPinLength()
     * @uses ConnectedApplication::setRefreshTokenValidityPeriod()
     * @uses ConnectedApplication::setSetupEntityAccessItems()
     * @uses ConnectedApplication::setStartUrl()
     * @uses ConnectedApplication::setSystemModstamp()
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $installedMobileApps
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $mobileSessionTimeout
     * @param string $mobileStartUrl
     * @param string $name
     * @param bool $optionsAllowAdminApprovedUsersOnly
     * @param bool $optionsFullContentPushNotifications
     * @param bool $optionsHasSessionLevelPolicy
     * @param bool $optionsIsInternal
     * @param bool $optionsRefreshTokenValidityMetric
     * @param string $pinLength
     * @param int $refreshTokenValidityPeriod
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $setupEntityAccessItems
     * @param string $startUrl
     * @param string $systemModstamp
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $installedMobileApps = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $mobileSessionTimeout = null, $mobileStartUrl = null, $name = null, $optionsAllowAdminApprovedUsersOnly = null, $optionsFullContentPushNotifications = null, $optionsHasSessionLevelPolicy = null, $optionsIsInternal = null, $optionsRefreshTokenValidityMetric = null, $pinLength = null, $refreshTokenValidityPeriod = null, \NexusDigital/MiratelForce\StructType\QueryResult $setupEntityAccessItems = null, $startUrl = null, $systemModstamp = null)
    {
        $this
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setInstalledMobileApps($installedMobileApps)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setMobileSessionTimeout($mobileSessionTimeout)
            ->setMobileStartUrl($mobileStartUrl)
            ->setName($name)
            ->setOptionsAllowAdminApprovedUsersOnly($optionsAllowAdminApprovedUsersOnly)
            ->setOptionsFullContentPushNotifications($optionsFullContentPushNotifications)
            ->setOptionsHasSessionLevelPolicy($optionsHasSessionLevelPolicy)
            ->setOptionsIsInternal($optionsIsInternal)
            ->setOptionsRefreshTokenValidityMetric($optionsRefreshTokenValidityMetric)
            ->setPinLength($pinLength)
            ->setRefreshTokenValidityPeriod($refreshTokenValidityPeriod)
            ->setSetupEntityAccessItems($setupEntityAccessItems)
            ->setStartUrl($startUrl)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get InstalledMobileApps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getInstalledMobileApps()
    {
        return isset($this->InstalledMobileApps) ? $this->InstalledMobileApps : null;
    }
    /**
     * Set InstalledMobileApps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $installedMobileApps
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setInstalledMobileApps(\NexusDigital/MiratelForce\StructType\QueryResult $installedMobileApps = null)
    {
        if (is_null($installedMobileApps) || (is_array($installedMobileApps) && empty($installedMobileApps))) {
            unset($this->InstalledMobileApps);
        } else {
            $this->InstalledMobileApps = $installedMobileApps;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get MobileSessionTimeout value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileSessionTimeout()
    {
        return isset($this->MobileSessionTimeout) ? $this->MobileSessionTimeout : null;
    }
    /**
     * Set MobileSessionTimeout value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileSessionTimeout
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setMobileSessionTimeout($mobileSessionTimeout = null)
    {
        // validation for constraint: string
        if (!is_null($mobileSessionTimeout) && !is_string($mobileSessionTimeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileSessionTimeout, true), gettype($mobileSessionTimeout)), __LINE__);
        }
        if (is_null($mobileSessionTimeout) || (is_array($mobileSessionTimeout) && empty($mobileSessionTimeout))) {
            unset($this->MobileSessionTimeout);
        } else {
            $this->MobileSessionTimeout = $mobileSessionTimeout;
        }
        return $this;
    }
    /**
     * Get MobileStartUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileStartUrl()
    {
        return isset($this->MobileStartUrl) ? $this->MobileStartUrl : null;
    }
    /**
     * Set MobileStartUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileStartUrl
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setMobileStartUrl($mobileStartUrl = null)
    {
        // validation for constraint: string
        if (!is_null($mobileStartUrl) && !is_string($mobileStartUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileStartUrl, true), gettype($mobileStartUrl)), __LINE__);
        }
        if (is_null($mobileStartUrl) || (is_array($mobileStartUrl) && empty($mobileStartUrl))) {
            unset($this->MobileStartUrl);
        } else {
            $this->MobileStartUrl = $mobileStartUrl;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OptionsAllowAdminApprovedUsersOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsAllowAdminApprovedUsersOnly()
    {
        return isset($this->OptionsAllowAdminApprovedUsersOnly) ? $this->OptionsAllowAdminApprovedUsersOnly : null;
    }
    /**
     * Set OptionsAllowAdminApprovedUsersOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsAllowAdminApprovedUsersOnly
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setOptionsAllowAdminApprovedUsersOnly($optionsAllowAdminApprovedUsersOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsAllowAdminApprovedUsersOnly) && !is_bool($optionsAllowAdminApprovedUsersOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsAllowAdminApprovedUsersOnly, true), gettype($optionsAllowAdminApprovedUsersOnly)), __LINE__);
        }
        if (is_null($optionsAllowAdminApprovedUsersOnly) || (is_array($optionsAllowAdminApprovedUsersOnly) && empty($optionsAllowAdminApprovedUsersOnly))) {
            unset($this->OptionsAllowAdminApprovedUsersOnly);
        } else {
            $this->OptionsAllowAdminApprovedUsersOnly = $optionsAllowAdminApprovedUsersOnly;
        }
        return $this;
    }
    /**
     * Get OptionsFullContentPushNotifications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsFullContentPushNotifications()
    {
        return isset($this->OptionsFullContentPushNotifications) ? $this->OptionsFullContentPushNotifications : null;
    }
    /**
     * Set OptionsFullContentPushNotifications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsFullContentPushNotifications
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setOptionsFullContentPushNotifications($optionsFullContentPushNotifications = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsFullContentPushNotifications) && !is_bool($optionsFullContentPushNotifications)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsFullContentPushNotifications, true), gettype($optionsFullContentPushNotifications)), __LINE__);
        }
        if (is_null($optionsFullContentPushNotifications) || (is_array($optionsFullContentPushNotifications) && empty($optionsFullContentPushNotifications))) {
            unset($this->OptionsFullContentPushNotifications);
        } else {
            $this->OptionsFullContentPushNotifications = $optionsFullContentPushNotifications;
        }
        return $this;
    }
    /**
     * Get OptionsHasSessionLevelPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsHasSessionLevelPolicy()
    {
        return isset($this->OptionsHasSessionLevelPolicy) ? $this->OptionsHasSessionLevelPolicy : null;
    }
    /**
     * Set OptionsHasSessionLevelPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsHasSessionLevelPolicy
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setOptionsHasSessionLevelPolicy($optionsHasSessionLevelPolicy = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsHasSessionLevelPolicy) && !is_bool($optionsHasSessionLevelPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsHasSessionLevelPolicy, true), gettype($optionsHasSessionLevelPolicy)), __LINE__);
        }
        if (is_null($optionsHasSessionLevelPolicy) || (is_array($optionsHasSessionLevelPolicy) && empty($optionsHasSessionLevelPolicy))) {
            unset($this->OptionsHasSessionLevelPolicy);
        } else {
            $this->OptionsHasSessionLevelPolicy = $optionsHasSessionLevelPolicy;
        }
        return $this;
    }
    /**
     * Get OptionsIsInternal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsIsInternal()
    {
        return isset($this->OptionsIsInternal) ? $this->OptionsIsInternal : null;
    }
    /**
     * Set OptionsIsInternal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsIsInternal
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setOptionsIsInternal($optionsIsInternal = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsIsInternal) && !is_bool($optionsIsInternal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsIsInternal, true), gettype($optionsIsInternal)), __LINE__);
        }
        if (is_null($optionsIsInternal) || (is_array($optionsIsInternal) && empty($optionsIsInternal))) {
            unset($this->OptionsIsInternal);
        } else {
            $this->OptionsIsInternal = $optionsIsInternal;
        }
        return $this;
    }
    /**
     * Get OptionsRefreshTokenValidityMetric value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsRefreshTokenValidityMetric()
    {
        return isset($this->OptionsRefreshTokenValidityMetric) ? $this->OptionsRefreshTokenValidityMetric : null;
    }
    /**
     * Set OptionsRefreshTokenValidityMetric value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsRefreshTokenValidityMetric
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setOptionsRefreshTokenValidityMetric($optionsRefreshTokenValidityMetric = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsRefreshTokenValidityMetric) && !is_bool($optionsRefreshTokenValidityMetric)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsRefreshTokenValidityMetric, true), gettype($optionsRefreshTokenValidityMetric)), __LINE__);
        }
        if (is_null($optionsRefreshTokenValidityMetric) || (is_array($optionsRefreshTokenValidityMetric) && empty($optionsRefreshTokenValidityMetric))) {
            unset($this->OptionsRefreshTokenValidityMetric);
        } else {
            $this->OptionsRefreshTokenValidityMetric = $optionsRefreshTokenValidityMetric;
        }
        return $this;
    }
    /**
     * Get PinLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPinLength()
    {
        return isset($this->PinLength) ? $this->PinLength : null;
    }
    /**
     * Set PinLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pinLength
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setPinLength($pinLength = null)
    {
        // validation for constraint: string
        if (!is_null($pinLength) && !is_string($pinLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pinLength, true), gettype($pinLength)), __LINE__);
        }
        if (is_null($pinLength) || (is_array($pinLength) && empty($pinLength))) {
            unset($this->PinLength);
        } else {
            $this->PinLength = $pinLength;
        }
        return $this;
    }
    /**
     * Get RefreshTokenValidityPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRefreshTokenValidityPeriod()
    {
        return isset($this->RefreshTokenValidityPeriod) ? $this->RefreshTokenValidityPeriod : null;
    }
    /**
     * Set RefreshTokenValidityPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $refreshTokenValidityPeriod
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setRefreshTokenValidityPeriod($refreshTokenValidityPeriod = null)
    {
        // validation for constraint: int
        if (!is_null($refreshTokenValidityPeriod) && !(is_int($refreshTokenValidityPeriod) || ctype_digit($refreshTokenValidityPeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($refreshTokenValidityPeriod, true), gettype($refreshTokenValidityPeriod)), __LINE__);
        }
        if (is_null($refreshTokenValidityPeriod) || (is_array($refreshTokenValidityPeriod) && empty($refreshTokenValidityPeriod))) {
            unset($this->RefreshTokenValidityPeriod);
        } else {
            $this->RefreshTokenValidityPeriod = $refreshTokenValidityPeriod;
        }
        return $this;
    }
    /**
     * Get SetupEntityAccessItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getSetupEntityAccessItems()
    {
        return isset($this->SetupEntityAccessItems) ? $this->SetupEntityAccessItems : null;
    }
    /**
     * Set SetupEntityAccessItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $setupEntityAccessItems
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setSetupEntityAccessItems(\NexusDigital/MiratelForce\StructType\QueryResult $setupEntityAccessItems = null)
    {
        if (is_null($setupEntityAccessItems) || (is_array($setupEntityAccessItems) && empty($setupEntityAccessItems))) {
            unset($this->SetupEntityAccessItems);
        } else {
            $this->SetupEntityAccessItems = $setupEntityAccessItems;
        }
        return $this;
    }
    /**
     * Get StartUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartUrl()
    {
        return isset($this->StartUrl) ? $this->StartUrl : null;
    }
    /**
     * Set StartUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startUrl
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setStartUrl($startUrl = null)
    {
        // validation for constraint: string
        if (!is_null($startUrl) && !is_string($startUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startUrl, true), gettype($startUrl)), __LINE__);
        }
        if (is_null($startUrl) || (is_array($startUrl) && empty($startUrl))) {
            unset($this->StartUrl);
        } else {
            $this->StartUrl = $startUrl;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
