<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ColorDefinition StructType
 * @subpackage Structs
 */
class ColorDefinition extends SObject
{
    /**
     * The Color
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Color;
    /**
     * The Context
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Context;
    /**
     * The DurableId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurableId;
    /**
     * The TabDefinition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\TabDefinition
     */
    public $TabDefinition;
    /**
     * The TabDefinitionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TabDefinitionId;
    /**
     * The Theme
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Theme;
    /**
     * Constructor method for ColorDefinition
     * @uses ColorDefinition::setColor()
     * @uses ColorDefinition::setContext()
     * @uses ColorDefinition::setDurableId()
     * @uses ColorDefinition::setTabDefinition()
     * @uses ColorDefinition::setTabDefinitionId()
     * @uses ColorDefinition::setTheme()
     * @param string $color
     * @param string $context
     * @param string $durableId
     * @param \NexusDigital/MiratelForce\StructType\TabDefinition $tabDefinition
     * @param string $tabDefinitionId
     * @param string $theme
     */
    public function __construct($color = null, $context = null, $durableId = null, \NexusDigital/MiratelForce\StructType\TabDefinition $tabDefinition = null, $tabDefinitionId = null, $theme = null)
    {
        $this
            ->setColor($color)
            ->setContext($context)
            ->setDurableId($durableId)
            ->setTabDefinition($tabDefinition)
            ->setTabDefinitionId($tabDefinitionId)
            ->setTheme($theme);
    }
    /**
     * Get Color value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getColor()
    {
        return isset($this->Color) ? $this->Color : null;
    }
    /**
     * Set Color value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $color
     * @return \NexusDigital/MiratelForce\StructType\ColorDefinition
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        if (is_null($color) || (is_array($color) && empty($color))) {
            unset($this->Color);
        } else {
            $this->Color = $color;
        }
        return $this;
    }
    /**
     * Get Context value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContext()
    {
        return isset($this->Context) ? $this->Context : null;
    }
    /**
     * Set Context value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $context
     * @return \NexusDigital/MiratelForce\StructType\ColorDefinition
     */
    public function setContext($context = null)
    {
        // validation for constraint: string
        if (!is_null($context) && !is_string($context)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($context, true), gettype($context)), __LINE__);
        }
        if (is_null($context) || (is_array($context) && empty($context))) {
            unset($this->Context);
        } else {
            $this->Context = $context;
        }
        return $this;
    }
    /**
     * Get DurableId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurableId()
    {
        return isset($this->DurableId) ? $this->DurableId : null;
    }
    /**
     * Set DurableId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $durableId
     * @return \NexusDigital/MiratelForce\StructType\ColorDefinition
     */
    public function setDurableId($durableId = null)
    {
        // validation for constraint: string
        if (!is_null($durableId) && !is_string($durableId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durableId, true), gettype($durableId)), __LINE__);
        }
        if (is_null($durableId) || (is_array($durableId) && empty($durableId))) {
            unset($this->DurableId);
        } else {
            $this->DurableId = $durableId;
        }
        return $this;
    }
    /**
     * Get TabDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\TabDefinition|null
     */
    public function getTabDefinition()
    {
        return isset($this->TabDefinition) ? $this->TabDefinition : null;
    }
    /**
     * Set TabDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\TabDefinition $tabDefinition
     * @return \NexusDigital/MiratelForce\StructType\ColorDefinition
     */
    public function setTabDefinition(\NexusDigital/MiratelForce\StructType\TabDefinition $tabDefinition = null)
    {
        if (is_null($tabDefinition) || (is_array($tabDefinition) && empty($tabDefinition))) {
            unset($this->TabDefinition);
        } else {
            $this->TabDefinition = $tabDefinition;
        }
        return $this;
    }
    /**
     * Get TabDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTabDefinitionId()
    {
        return isset($this->TabDefinitionId) ? $this->TabDefinitionId : null;
    }
    /**
     * Set TabDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tabDefinitionId
     * @return \NexusDigital/MiratelForce\StructType\ColorDefinition
     */
    public function setTabDefinitionId($tabDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($tabDefinitionId) && !is_string($tabDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tabDefinitionId, true), gettype($tabDefinitionId)), __LINE__);
        }
        if (is_null($tabDefinitionId) || (is_array($tabDefinitionId) && empty($tabDefinitionId))) {
            unset($this->TabDefinitionId);
        } else {
            $this->TabDefinitionId = $tabDefinitionId;
        }
        return $this;
    }
    /**
     * Get Theme value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTheme()
    {
        return isset($this->Theme) ? $this->Theme : null;
    }
    /**
     * Set Theme value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $theme
     * @return \NexusDigital/MiratelForce\StructType\ColorDefinition
     */
    public function setTheme($theme = null)
    {
        // validation for constraint: string
        if (!is_null($theme) && !is_string($theme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($theme, true), gettype($theme)), __LINE__);
        }
        if (is_null($theme) || (is_array($theme) && empty($theme))) {
            unset($this->Theme);
        } else {
            $this->Theme = $theme;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ColorDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
