<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChatterActivity StructType
 * @subpackage Structs
 */
class ChatterActivity extends SObject
{
    /**
     * The CommentCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CommentCount;
    /**
     * The CommentReceivedCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CommentReceivedCount;
    /**
     * The InfluenceRawRank
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InfluenceRawRank;
    /**
     * The LikeReceivedCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LikeReceivedCount;
    /**
     * The NetworkId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $NetworkId;
    /**
     * The ParentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentId;
    /**
     * The PostCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PostCount;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for ChatterActivity
     * @uses ChatterActivity::setCommentCount()
     * @uses ChatterActivity::setCommentReceivedCount()
     * @uses ChatterActivity::setInfluenceRawRank()
     * @uses ChatterActivity::setLikeReceivedCount()
     * @uses ChatterActivity::setNetworkId()
     * @uses ChatterActivity::setParentId()
     * @uses ChatterActivity::setPostCount()
     * @uses ChatterActivity::setSystemModstamp()
     * @param int $commentCount
     * @param int $commentReceivedCount
     * @param int $influenceRawRank
     * @param int $likeReceivedCount
     * @param string $networkId
     * @param string $parentId
     * @param int $postCount
     * @param string $systemModstamp
     */
    public function __construct($commentCount = null, $commentReceivedCount = null, $influenceRawRank = null, $likeReceivedCount = null, $networkId = null, $parentId = null, $postCount = null, $systemModstamp = null)
    {
        $this
            ->setCommentCount($commentCount)
            ->setCommentReceivedCount($commentReceivedCount)
            ->setInfluenceRawRank($influenceRawRank)
            ->setLikeReceivedCount($likeReceivedCount)
            ->setNetworkId($networkId)
            ->setParentId($parentId)
            ->setPostCount($postCount)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get CommentCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCommentCount()
    {
        return isset($this->CommentCount) ? $this->CommentCount : null;
    }
    /**
     * Set CommentCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $commentCount
     * @return \NexusDigital/MiratelForce\StructType\ChatterActivity
     */
    public function setCommentCount($commentCount = null)
    {
        // validation for constraint: int
        if (!is_null($commentCount) && !(is_int($commentCount) || ctype_digit($commentCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commentCount, true), gettype($commentCount)), __LINE__);
        }
        if (is_null($commentCount) || (is_array($commentCount) && empty($commentCount))) {
            unset($this->CommentCount);
        } else {
            $this->CommentCount = $commentCount;
        }
        return $this;
    }
    /**
     * Get CommentReceivedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCommentReceivedCount()
    {
        return isset($this->CommentReceivedCount) ? $this->CommentReceivedCount : null;
    }
    /**
     * Set CommentReceivedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $commentReceivedCount
     * @return \NexusDigital/MiratelForce\StructType\ChatterActivity
     */
    public function setCommentReceivedCount($commentReceivedCount = null)
    {
        // validation for constraint: int
        if (!is_null($commentReceivedCount) && !(is_int($commentReceivedCount) || ctype_digit($commentReceivedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commentReceivedCount, true), gettype($commentReceivedCount)), __LINE__);
        }
        if (is_null($commentReceivedCount) || (is_array($commentReceivedCount) && empty($commentReceivedCount))) {
            unset($this->CommentReceivedCount);
        } else {
            $this->CommentReceivedCount = $commentReceivedCount;
        }
        return $this;
    }
    /**
     * Get InfluenceRawRank value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInfluenceRawRank()
    {
        return isset($this->InfluenceRawRank) ? $this->InfluenceRawRank : null;
    }
    /**
     * Set InfluenceRawRank value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $influenceRawRank
     * @return \NexusDigital/MiratelForce\StructType\ChatterActivity
     */
    public function setInfluenceRawRank($influenceRawRank = null)
    {
        // validation for constraint: int
        if (!is_null($influenceRawRank) && !(is_int($influenceRawRank) || ctype_digit($influenceRawRank))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($influenceRawRank, true), gettype($influenceRawRank)), __LINE__);
        }
        if (is_null($influenceRawRank) || (is_array($influenceRawRank) && empty($influenceRawRank))) {
            unset($this->InfluenceRawRank);
        } else {
            $this->InfluenceRawRank = $influenceRawRank;
        }
        return $this;
    }
    /**
     * Get LikeReceivedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLikeReceivedCount()
    {
        return isset($this->LikeReceivedCount) ? $this->LikeReceivedCount : null;
    }
    /**
     * Set LikeReceivedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $likeReceivedCount
     * @return \NexusDigital/MiratelForce\StructType\ChatterActivity
     */
    public function setLikeReceivedCount($likeReceivedCount = null)
    {
        // validation for constraint: int
        if (!is_null($likeReceivedCount) && !(is_int($likeReceivedCount) || ctype_digit($likeReceivedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($likeReceivedCount, true), gettype($likeReceivedCount)), __LINE__);
        }
        if (is_null($likeReceivedCount) || (is_array($likeReceivedCount) && empty($likeReceivedCount))) {
            unset($this->LikeReceivedCount);
        } else {
            $this->LikeReceivedCount = $likeReceivedCount;
        }
        return $this;
    }
    /**
     * Get NetworkId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkId()
    {
        return isset($this->NetworkId) ? $this->NetworkId : null;
    }
    /**
     * Set NetworkId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkId
     * @return \NexusDigital/MiratelForce\StructType\ChatterActivity
     */
    public function setNetworkId($networkId = null)
    {
        // validation for constraint: string
        if (!is_null($networkId) && !is_string($networkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($networkId, true), gettype($networkId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($networkId) && mb_strlen($networkId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($networkId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($networkId) && !preg_match('/[a-zA-Z0-9]{18}/', $networkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($networkId, true)), __LINE__);
        }
        if (is_null($networkId) || (is_array($networkId) && empty($networkId))) {
            unset($this->NetworkId);
        } else {
            $this->NetworkId = $networkId;
        }
        return $this;
    }
    /**
     * Get ParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->ParentId) ? $this->ParentId : null;
    }
    /**
     * Set ParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \NexusDigital/MiratelForce\StructType\ChatterActivity
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentId) && mb_strlen($parentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentId, true)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->ParentId);
        } else {
            $this->ParentId = $parentId;
        }
        return $this;
    }
    /**
     * Get PostCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPostCount()
    {
        return isset($this->PostCount) ? $this->PostCount : null;
    }
    /**
     * Set PostCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $postCount
     * @return \NexusDigital/MiratelForce\StructType\ChatterActivity
     */
    public function setPostCount($postCount = null)
    {
        // validation for constraint: int
        if (!is_null($postCount) && !(is_int($postCount) || ctype_digit($postCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postCount, true), gettype($postCount)), __LINE__);
        }
        if (is_null($postCount) || (is_array($postCount) && empty($postCount))) {
            unset($this->PostCount);
        } else {
            $this->PostCount = $postCount;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ChatterActivity
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ChatterActivity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
