<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CaseArticle StructType
 * @subpackage Structs
 */
class CaseArticle extends SObject
{
    /**
     * The ArticleLanguage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArticleLanguage;
    /**
     * The ArticleVersionNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ArticleVersionNumber;
    /**
     * The Case
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\_Case
     */
    public $Case;
    /**
     * The CaseId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CaseId;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsSharedByEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSharedByEmail;
    /**
     * The KnowledgeArticle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Knowledge__ka
     */
    public $KnowledgeArticle;
    /**
     * The KnowledgeArticleId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $KnowledgeArticleId;
    /**
     * The KnowledgeArticleVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public $KnowledgeArticleVersion;
    /**
     * The KnowledgeArticleVersionId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $KnowledgeArticleVersionId;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for CaseArticle
     * @uses CaseArticle::setArticleLanguage()
     * @uses CaseArticle::setArticleVersionNumber()
     * @uses CaseArticle::setCase()
     * @uses CaseArticle::setCaseId()
     * @uses CaseArticle::setCreatedBy()
     * @uses CaseArticle::setCreatedById()
     * @uses CaseArticle::setCreatedDate()
     * @uses CaseArticle::setIsDeleted()
     * @uses CaseArticle::setIsSharedByEmail()
     * @uses CaseArticle::setKnowledgeArticle()
     * @uses CaseArticle::setKnowledgeArticleId()
     * @uses CaseArticle::setKnowledgeArticleVersion()
     * @uses CaseArticle::setKnowledgeArticleVersionId()
     * @uses CaseArticle::setSystemModstamp()
     * @param string $articleLanguage
     * @param int $articleVersionNumber
     * @param \NexusDigital/MiratelForce\StructType\_Case $case
     * @param string $caseId
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param bool $isDeleted
     * @param bool $isSharedByEmail
     * @param \NexusDigital/MiratelForce\StructType\Knowledge__ka $knowledgeArticle
     * @param string $knowledgeArticleId
     * @param \NexusDigital/MiratelForce\StructType\Knowledge__kav $knowledgeArticleVersion
     * @param string $knowledgeArticleVersionId
     * @param string $systemModstamp
     */
    public function __construct($articleLanguage = null, $articleVersionNumber = null, \NexusDigital/MiratelForce\StructType\_Case $case = null, $caseId = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $isDeleted = null, $isSharedByEmail = null, \NexusDigital/MiratelForce\StructType\Knowledge__ka $knowledgeArticle = null, $knowledgeArticleId = null, \NexusDigital/MiratelForce\StructType\Knowledge__kav $knowledgeArticleVersion = null, $knowledgeArticleVersionId = null, $systemModstamp = null)
    {
        $this
            ->setArticleLanguage($articleLanguage)
            ->setArticleVersionNumber($articleVersionNumber)
            ->setCase($case)
            ->setCaseId($caseId)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setIsDeleted($isDeleted)
            ->setIsSharedByEmail($isSharedByEmail)
            ->setKnowledgeArticle($knowledgeArticle)
            ->setKnowledgeArticleId($knowledgeArticleId)
            ->setKnowledgeArticleVersion($knowledgeArticleVersion)
            ->setKnowledgeArticleVersionId($knowledgeArticleVersionId)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get ArticleLanguage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArticleLanguage()
    {
        return isset($this->ArticleLanguage) ? $this->ArticleLanguage : null;
    }
    /**
     * Set ArticleLanguage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $articleLanguage
     * @return \NexusDigital/MiratelForce\StructType\CaseArticle
     */
    public function setArticleLanguage($articleLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($articleLanguage) && !is_string($articleLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleLanguage, true), gettype($articleLanguage)), __LINE__);
        }
        if (is_null($articleLanguage) || (is_array($articleLanguage) && empty($articleLanguage))) {
            unset($this->ArticleLanguage);
        } else {
            $this->ArticleLanguage = $articleLanguage;
        }
        return $this;
    }
    /**
     * Get ArticleVersionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getArticleVersionNumber()
    {
        return isset($this->ArticleVersionNumber) ? $this->ArticleVersionNumber : null;
    }
    /**
     * Set ArticleVersionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $articleVersionNumber
     * @return \NexusDigital/MiratelForce\StructType\CaseArticle
     */
    public function setArticleVersionNumber($articleVersionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($articleVersionNumber) && !(is_int($articleVersionNumber) || ctype_digit($articleVersionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleVersionNumber, true), gettype($articleVersionNumber)), __LINE__);
        }
        if (is_null($articleVersionNumber) || (is_array($articleVersionNumber) && empty($articleVersionNumber))) {
            unset($this->ArticleVersionNumber);
        } else {
            $this->ArticleVersionNumber = $articleVersionNumber;
        }
        return $this;
    }
    /**
     * Get Case value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\_Case|null
     */
    public function getCase()
    {
        return isset($this->Case) ? $this->Case : null;
    }
    /**
     * Set Case value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\_Case $case
     * @return \NexusDigital/MiratelForce\StructType\CaseArticle
     */
    public function setCase(\NexusDigital/MiratelForce\StructType\_Case $case = null)
    {
        if (is_null($case) || (is_array($case) && empty($case))) {
            unset($this->Case);
        } else {
            $this->Case = $case;
        }
        return $this;
    }
    /**
     * Get CaseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCaseId()
    {
        return isset($this->CaseId) ? $this->CaseId : null;
    }
    /**
     * Set CaseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $caseId
     * @return \NexusDigital/MiratelForce\StructType\CaseArticle
     */
    public function setCaseId($caseId = null)
    {
        // validation for constraint: string
        if (!is_null($caseId) && !is_string($caseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caseId, true), gettype($caseId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($caseId) && mb_strlen($caseId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($caseId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($caseId) && !preg_match('/[a-zA-Z0-9]{18}/', $caseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($caseId, true)), __LINE__);
        }
        if (is_null($caseId) || (is_array($caseId) && empty($caseId))) {
            unset($this->CaseId);
        } else {
            $this->CaseId = $caseId;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\CaseArticle
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\CaseArticle
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\CaseArticle
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\CaseArticle
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsSharedByEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSharedByEmail()
    {
        return isset($this->IsSharedByEmail) ? $this->IsSharedByEmail : null;
    }
    /**
     * Set IsSharedByEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSharedByEmail
     * @return \NexusDigital/MiratelForce\StructType\CaseArticle
     */
    public function setIsSharedByEmail($isSharedByEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSharedByEmail) && !is_bool($isSharedByEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSharedByEmail, true), gettype($isSharedByEmail)), __LINE__);
        }
        if (is_null($isSharedByEmail) || (is_array($isSharedByEmail) && empty($isSharedByEmail))) {
            unset($this->IsSharedByEmail);
        } else {
            $this->IsSharedByEmail = $isSharedByEmail;
        }
        return $this;
    }
    /**
     * Get KnowledgeArticle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__ka|null
     */
    public function getKnowledgeArticle()
    {
        return isset($this->KnowledgeArticle) ? $this->KnowledgeArticle : null;
    }
    /**
     * Set KnowledgeArticle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Knowledge__ka $knowledgeArticle
     * @return \NexusDigital/MiratelForce\StructType\CaseArticle
     */
    public function setKnowledgeArticle(\NexusDigital/MiratelForce\StructType\Knowledge__ka $knowledgeArticle = null)
    {
        if (is_null($knowledgeArticle) || (is_array($knowledgeArticle) && empty($knowledgeArticle))) {
            unset($this->KnowledgeArticle);
        } else {
            $this->KnowledgeArticle = $knowledgeArticle;
        }
        return $this;
    }
    /**
     * Get KnowledgeArticleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKnowledgeArticleId()
    {
        return isset($this->KnowledgeArticleId) ? $this->KnowledgeArticleId : null;
    }
    /**
     * Set KnowledgeArticleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $knowledgeArticleId
     * @return \NexusDigital/MiratelForce\StructType\CaseArticle
     */
    public function setKnowledgeArticleId($knowledgeArticleId = null)
    {
        // validation for constraint: string
        if (!is_null($knowledgeArticleId) && !is_string($knowledgeArticleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($knowledgeArticleId, true), gettype($knowledgeArticleId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($knowledgeArticleId) && mb_strlen($knowledgeArticleId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($knowledgeArticleId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($knowledgeArticleId) && !preg_match('/[a-zA-Z0-9]{18}/', $knowledgeArticleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($knowledgeArticleId, true)), __LINE__);
        }
        if (is_null($knowledgeArticleId) || (is_array($knowledgeArticleId) && empty($knowledgeArticleId))) {
            unset($this->KnowledgeArticleId);
        } else {
            $this->KnowledgeArticleId = $knowledgeArticleId;
        }
        return $this;
    }
    /**
     * Get KnowledgeArticleVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav|null
     */
    public function getKnowledgeArticleVersion()
    {
        return isset($this->KnowledgeArticleVersion) ? $this->KnowledgeArticleVersion : null;
    }
    /**
     * Set KnowledgeArticleVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Knowledge__kav $knowledgeArticleVersion
     * @return \NexusDigital/MiratelForce\StructType\CaseArticle
     */
    public function setKnowledgeArticleVersion(\NexusDigital/MiratelForce\StructType\Knowledge__kav $knowledgeArticleVersion = null)
    {
        if (is_null($knowledgeArticleVersion) || (is_array($knowledgeArticleVersion) && empty($knowledgeArticleVersion))) {
            unset($this->KnowledgeArticleVersion);
        } else {
            $this->KnowledgeArticleVersion = $knowledgeArticleVersion;
        }
        return $this;
    }
    /**
     * Get KnowledgeArticleVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKnowledgeArticleVersionId()
    {
        return isset($this->KnowledgeArticleVersionId) ? $this->KnowledgeArticleVersionId : null;
    }
    /**
     * Set KnowledgeArticleVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $knowledgeArticleVersionId
     * @return \NexusDigital/MiratelForce\StructType\CaseArticle
     */
    public function setKnowledgeArticleVersionId($knowledgeArticleVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($knowledgeArticleVersionId) && !is_string($knowledgeArticleVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($knowledgeArticleVersionId, true), gettype($knowledgeArticleVersionId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($knowledgeArticleVersionId) && mb_strlen($knowledgeArticleVersionId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($knowledgeArticleVersionId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($knowledgeArticleVersionId) && !preg_match('/[a-zA-Z0-9]{18}/', $knowledgeArticleVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($knowledgeArticleVersionId, true)), __LINE__);
        }
        if (is_null($knowledgeArticleVersionId) || (is_array($knowledgeArticleVersionId) && empty($knowledgeArticleVersionId))) {
            unset($this->KnowledgeArticleVersionId);
        } else {
            $this->KnowledgeArticleVersionId = $knowledgeArticleVersionId;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\CaseArticle
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\CaseArticle
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
