<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CallCenter StructType
 * @subpackage Structs
 */
class CallCenter extends SObject
{
    /**
     * The AdapterUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdapterUrl;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The CustomSettings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomSettings;
    /**
     * The InternalName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InternalName;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Version;
    /**
     * Constructor method for CallCenter
     * @uses CallCenter::setAdapterUrl()
     * @uses CallCenter::setCreatedBy()
     * @uses CallCenter::setCreatedById()
     * @uses CallCenter::setCreatedDate()
     * @uses CallCenter::setCustomSettings()
     * @uses CallCenter::setInternalName()
     * @uses CallCenter::setLastModifiedBy()
     * @uses CallCenter::setLastModifiedById()
     * @uses CallCenter::setLastModifiedDate()
     * @uses CallCenter::setName()
     * @uses CallCenter::setSystemModstamp()
     * @uses CallCenter::setVersion()
     * @param string $adapterUrl
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $customSettings
     * @param string $internalName
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $name
     * @param string $systemModstamp
     * @param float $version
     */
    public function __construct($adapterUrl = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $customSettings = null, $internalName = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $name = null, $systemModstamp = null, $version = null)
    {
        $this
            ->setAdapterUrl($adapterUrl)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setCustomSettings($customSettings)
            ->setInternalName($internalName)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setName($name)
            ->setSystemModstamp($systemModstamp)
            ->setVersion($version);
    }
    /**
     * Get AdapterUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdapterUrl()
    {
        return isset($this->AdapterUrl) ? $this->AdapterUrl : null;
    }
    /**
     * Set AdapterUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adapterUrl
     * @return \NexusDigital/MiratelForce\StructType\CallCenter
     */
    public function setAdapterUrl($adapterUrl = null)
    {
        // validation for constraint: string
        if (!is_null($adapterUrl) && !is_string($adapterUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adapterUrl, true), gettype($adapterUrl)), __LINE__);
        }
        if (is_null($adapterUrl) || (is_array($adapterUrl) && empty($adapterUrl))) {
            unset($this->AdapterUrl);
        } else {
            $this->AdapterUrl = $adapterUrl;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\CallCenter
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\CallCenter
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\CallCenter
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get CustomSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomSettings()
    {
        return isset($this->CustomSettings) ? $this->CustomSettings : null;
    }
    /**
     * Set CustomSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customSettings
     * @return \NexusDigital/MiratelForce\StructType\CallCenter
     */
    public function setCustomSettings($customSettings = null)
    {
        // validation for constraint: string
        if (!is_null($customSettings) && !is_string($customSettings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customSettings, true), gettype($customSettings)), __LINE__);
        }
        if (is_null($customSettings) || (is_array($customSettings) && empty($customSettings))) {
            unset($this->CustomSettings);
        } else {
            $this->CustomSettings = $customSettings;
        }
        return $this;
    }
    /**
     * Get InternalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternalName()
    {
        return isset($this->InternalName) ? $this->InternalName : null;
    }
    /**
     * Set InternalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $internalName
     * @return \NexusDigital/MiratelForce\StructType\CallCenter
     */
    public function setInternalName($internalName = null)
    {
        // validation for constraint: string
        if (!is_null($internalName) && !is_string($internalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalName, true), gettype($internalName)), __LINE__);
        }
        if (is_null($internalName) || (is_array($internalName) && empty($internalName))) {
            unset($this->InternalName);
        } else {
            $this->InternalName = $internalName;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\CallCenter
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\CallCenter
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\CallCenter
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\CallCenter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\CallCenter
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get Version value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVersion()
    {
        return isset($this->Version) ? $this->Version : null;
    }
    /**
     * Set Version value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $version
     * @return \NexusDigital/MiratelForce\StructType\CallCenter
     */
    public function setVersion($version = null)
    {
        // validation for constraint: float
        if (!is_null($version) && !(is_float($version) || is_numeric($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        if (is_null($version) || (is_array($version) && empty($version))) {
            unset($this->Version);
        } else {
            $this->Version = $version;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\CallCenter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
