<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessHours StructType
 * @subpackage Structs
 */
class BusinessHours extends SObject
{
    /**
     * The Cases
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Cases;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The FridayEndTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FridayEndTime;
    /**
     * The FridayStartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FridayStartTime;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsDefault
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDefault;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastViewedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastViewedDate;
    /**
     * The MondayEndTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MondayEndTime;
    /**
     * The MondayStartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MondayStartTime;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SaturdayEndTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaturdayEndTime;
    /**
     * The SaturdayStartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaturdayStartTime;
    /**
     * The SundayEndTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SundayEndTime;
    /**
     * The SundayStartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SundayStartTime;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The ThursdayEndTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThursdayEndTime;
    /**
     * The ThursdayStartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThursdayStartTime;
    /**
     * The TimeZoneSidKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeZoneSidKey;
    /**
     * The TuesdayEndTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TuesdayEndTime;
    /**
     * The TuesdayStartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TuesdayStartTime;
    /**
     * The WednesdayEndTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WednesdayEndTime;
    /**
     * The WednesdayStartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WednesdayStartTime;
    /**
     * The WorkOrders
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $WorkOrders;
    /**
     * Constructor method for BusinessHours
     * @uses BusinessHours::setCases()
     * @uses BusinessHours::setCreatedBy()
     * @uses BusinessHours::setCreatedById()
     * @uses BusinessHours::setCreatedDate()
     * @uses BusinessHours::setFridayEndTime()
     * @uses BusinessHours::setFridayStartTime()
     * @uses BusinessHours::setIsActive()
     * @uses BusinessHours::setIsDefault()
     * @uses BusinessHours::setLastModifiedBy()
     * @uses BusinessHours::setLastModifiedById()
     * @uses BusinessHours::setLastModifiedDate()
     * @uses BusinessHours::setLastViewedDate()
     * @uses BusinessHours::setMondayEndTime()
     * @uses BusinessHours::setMondayStartTime()
     * @uses BusinessHours::setName()
     * @uses BusinessHours::setSaturdayEndTime()
     * @uses BusinessHours::setSaturdayStartTime()
     * @uses BusinessHours::setSundayEndTime()
     * @uses BusinessHours::setSundayStartTime()
     * @uses BusinessHours::setSystemModstamp()
     * @uses BusinessHours::setThursdayEndTime()
     * @uses BusinessHours::setThursdayStartTime()
     * @uses BusinessHours::setTimeZoneSidKey()
     * @uses BusinessHours::setTuesdayEndTime()
     * @uses BusinessHours::setTuesdayStartTime()
     * @uses BusinessHours::setWednesdayEndTime()
     * @uses BusinessHours::setWednesdayStartTime()
     * @uses BusinessHours::setWorkOrders()
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $cases
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $fridayEndTime
     * @param string $fridayStartTime
     * @param bool $isActive
     * @param bool $isDefault
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $lastViewedDate
     * @param string $mondayEndTime
     * @param string $mondayStartTime
     * @param string $name
     * @param string $saturdayEndTime
     * @param string $saturdayStartTime
     * @param string $sundayEndTime
     * @param string $sundayStartTime
     * @param string $systemModstamp
     * @param string $thursdayEndTime
     * @param string $thursdayStartTime
     * @param string $timeZoneSidKey
     * @param string $tuesdayEndTime
     * @param string $tuesdayStartTime
     * @param string $wednesdayEndTime
     * @param string $wednesdayStartTime
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $workOrders
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\QueryResult $cases = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $fridayEndTime = null, $fridayStartTime = null, $isActive = null, $isDefault = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lastViewedDate = null, $mondayEndTime = null, $mondayStartTime = null, $name = null, $saturdayEndTime = null, $saturdayStartTime = null, $sundayEndTime = null, $sundayStartTime = null, $systemModstamp = null, $thursdayEndTime = null, $thursdayStartTime = null, $timeZoneSidKey = null, $tuesdayEndTime = null, $tuesdayStartTime = null, $wednesdayEndTime = null, $wednesdayStartTime = null, \NexusDigital/MiratelForce\StructType\QueryResult $workOrders = null)
    {
        $this
            ->setCases($cases)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setFridayEndTime($fridayEndTime)
            ->setFridayStartTime($fridayStartTime)
            ->setIsActive($isActive)
            ->setIsDefault($isDefault)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastViewedDate($lastViewedDate)
            ->setMondayEndTime($mondayEndTime)
            ->setMondayStartTime($mondayStartTime)
            ->setName($name)
            ->setSaturdayEndTime($saturdayEndTime)
            ->setSaturdayStartTime($saturdayStartTime)
            ->setSundayEndTime($sundayEndTime)
            ->setSundayStartTime($sundayStartTime)
            ->setSystemModstamp($systemModstamp)
            ->setThursdayEndTime($thursdayEndTime)
            ->setThursdayStartTime($thursdayStartTime)
            ->setTimeZoneSidKey($timeZoneSidKey)
            ->setTuesdayEndTime($tuesdayEndTime)
            ->setTuesdayStartTime($tuesdayStartTime)
            ->setWednesdayEndTime($wednesdayEndTime)
            ->setWednesdayStartTime($wednesdayStartTime)
            ->setWorkOrders($workOrders);
    }
    /**
     * Get Cases value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCases()
    {
        return isset($this->Cases) ? $this->Cases : null;
    }
    /**
     * Set Cases value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $cases
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setCases(\NexusDigital/MiratelForce\StructType\QueryResult $cases = null)
    {
        if (is_null($cases) || (is_array($cases) && empty($cases))) {
            unset($this->Cases);
        } else {
            $this->Cases = $cases;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get FridayEndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFridayEndTime()
    {
        return isset($this->FridayEndTime) ? $this->FridayEndTime : null;
    }
    /**
     * Set FridayEndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fridayEndTime
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setFridayEndTime($fridayEndTime = null)
    {
        // validation for constraint: string
        if (!is_null($fridayEndTime) && !is_string($fridayEndTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fridayEndTime, true), gettype($fridayEndTime)), __LINE__);
        }
        if (is_null($fridayEndTime) || (is_array($fridayEndTime) && empty($fridayEndTime))) {
            unset($this->FridayEndTime);
        } else {
            $this->FridayEndTime = $fridayEndTime;
        }
        return $this;
    }
    /**
     * Get FridayStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFridayStartTime()
    {
        return isset($this->FridayStartTime) ? $this->FridayStartTime : null;
    }
    /**
     * Set FridayStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fridayStartTime
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setFridayStartTime($fridayStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($fridayStartTime) && !is_string($fridayStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fridayStartTime, true), gettype($fridayStartTime)), __LINE__);
        }
        if (is_null($fridayStartTime) || (is_array($fridayStartTime) && empty($fridayStartTime))) {
            unset($this->FridayStartTime);
        } else {
            $this->FridayStartTime = $fridayStartTime;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDefault()
    {
        return isset($this->IsDefault) ? $this->IsDefault : null;
    }
    /**
     * Set IsDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDefault
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        if (is_null($isDefault) || (is_array($isDefault) && empty($isDefault))) {
            unset($this->IsDefault);
        } else {
            $this->IsDefault = $isDefault;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LastViewedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastViewedDate()
    {
        return isset($this->LastViewedDate) ? $this->LastViewedDate : null;
    }
    /**
     * Set LastViewedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastViewedDate
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setLastViewedDate($lastViewedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastViewedDate) && !is_string($lastViewedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastViewedDate, true), gettype($lastViewedDate)), __LINE__);
        }
        if (is_null($lastViewedDate) || (is_array($lastViewedDate) && empty($lastViewedDate))) {
            unset($this->LastViewedDate);
        } else {
            $this->LastViewedDate = $lastViewedDate;
        }
        return $this;
    }
    /**
     * Get MondayEndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMondayEndTime()
    {
        return isset($this->MondayEndTime) ? $this->MondayEndTime : null;
    }
    /**
     * Set MondayEndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mondayEndTime
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setMondayEndTime($mondayEndTime = null)
    {
        // validation for constraint: string
        if (!is_null($mondayEndTime) && !is_string($mondayEndTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mondayEndTime, true), gettype($mondayEndTime)), __LINE__);
        }
        if (is_null($mondayEndTime) || (is_array($mondayEndTime) && empty($mondayEndTime))) {
            unset($this->MondayEndTime);
        } else {
            $this->MondayEndTime = $mondayEndTime;
        }
        return $this;
    }
    /**
     * Get MondayStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMondayStartTime()
    {
        return isset($this->MondayStartTime) ? $this->MondayStartTime : null;
    }
    /**
     * Set MondayStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mondayStartTime
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setMondayStartTime($mondayStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($mondayStartTime) && !is_string($mondayStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mondayStartTime, true), gettype($mondayStartTime)), __LINE__);
        }
        if (is_null($mondayStartTime) || (is_array($mondayStartTime) && empty($mondayStartTime))) {
            unset($this->MondayStartTime);
        } else {
            $this->MondayStartTime = $mondayStartTime;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SaturdayEndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaturdayEndTime()
    {
        return isset($this->SaturdayEndTime) ? $this->SaturdayEndTime : null;
    }
    /**
     * Set SaturdayEndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saturdayEndTime
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setSaturdayEndTime($saturdayEndTime = null)
    {
        // validation for constraint: string
        if (!is_null($saturdayEndTime) && !is_string($saturdayEndTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saturdayEndTime, true), gettype($saturdayEndTime)), __LINE__);
        }
        if (is_null($saturdayEndTime) || (is_array($saturdayEndTime) && empty($saturdayEndTime))) {
            unset($this->SaturdayEndTime);
        } else {
            $this->SaturdayEndTime = $saturdayEndTime;
        }
        return $this;
    }
    /**
     * Get SaturdayStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaturdayStartTime()
    {
        return isset($this->SaturdayStartTime) ? $this->SaturdayStartTime : null;
    }
    /**
     * Set SaturdayStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saturdayStartTime
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setSaturdayStartTime($saturdayStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($saturdayStartTime) && !is_string($saturdayStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saturdayStartTime, true), gettype($saturdayStartTime)), __LINE__);
        }
        if (is_null($saturdayStartTime) || (is_array($saturdayStartTime) && empty($saturdayStartTime))) {
            unset($this->SaturdayStartTime);
        } else {
            $this->SaturdayStartTime = $saturdayStartTime;
        }
        return $this;
    }
    /**
     * Get SundayEndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSundayEndTime()
    {
        return isset($this->SundayEndTime) ? $this->SundayEndTime : null;
    }
    /**
     * Set SundayEndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sundayEndTime
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setSundayEndTime($sundayEndTime = null)
    {
        // validation for constraint: string
        if (!is_null($sundayEndTime) && !is_string($sundayEndTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sundayEndTime, true), gettype($sundayEndTime)), __LINE__);
        }
        if (is_null($sundayEndTime) || (is_array($sundayEndTime) && empty($sundayEndTime))) {
            unset($this->SundayEndTime);
        } else {
            $this->SundayEndTime = $sundayEndTime;
        }
        return $this;
    }
    /**
     * Get SundayStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSundayStartTime()
    {
        return isset($this->SundayStartTime) ? $this->SundayStartTime : null;
    }
    /**
     * Set SundayStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sundayStartTime
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setSundayStartTime($sundayStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($sundayStartTime) && !is_string($sundayStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sundayStartTime, true), gettype($sundayStartTime)), __LINE__);
        }
        if (is_null($sundayStartTime) || (is_array($sundayStartTime) && empty($sundayStartTime))) {
            unset($this->SundayStartTime);
        } else {
            $this->SundayStartTime = $sundayStartTime;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get ThursdayEndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThursdayEndTime()
    {
        return isset($this->ThursdayEndTime) ? $this->ThursdayEndTime : null;
    }
    /**
     * Set ThursdayEndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thursdayEndTime
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setThursdayEndTime($thursdayEndTime = null)
    {
        // validation for constraint: string
        if (!is_null($thursdayEndTime) && !is_string($thursdayEndTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thursdayEndTime, true), gettype($thursdayEndTime)), __LINE__);
        }
        if (is_null($thursdayEndTime) || (is_array($thursdayEndTime) && empty($thursdayEndTime))) {
            unset($this->ThursdayEndTime);
        } else {
            $this->ThursdayEndTime = $thursdayEndTime;
        }
        return $this;
    }
    /**
     * Get ThursdayStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThursdayStartTime()
    {
        return isset($this->ThursdayStartTime) ? $this->ThursdayStartTime : null;
    }
    /**
     * Set ThursdayStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thursdayStartTime
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setThursdayStartTime($thursdayStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($thursdayStartTime) && !is_string($thursdayStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thursdayStartTime, true), gettype($thursdayStartTime)), __LINE__);
        }
        if (is_null($thursdayStartTime) || (is_array($thursdayStartTime) && empty($thursdayStartTime))) {
            unset($this->ThursdayStartTime);
        } else {
            $this->ThursdayStartTime = $thursdayStartTime;
        }
        return $this;
    }
    /**
     * Get TimeZoneSidKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeZoneSidKey()
    {
        return isset($this->TimeZoneSidKey) ? $this->TimeZoneSidKey : null;
    }
    /**
     * Set TimeZoneSidKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeZoneSidKey
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setTimeZoneSidKey($timeZoneSidKey = null)
    {
        // validation for constraint: string
        if (!is_null($timeZoneSidKey) && !is_string($timeZoneSidKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZoneSidKey, true), gettype($timeZoneSidKey)), __LINE__);
        }
        if (is_null($timeZoneSidKey) || (is_array($timeZoneSidKey) && empty($timeZoneSidKey))) {
            unset($this->TimeZoneSidKey);
        } else {
            $this->TimeZoneSidKey = $timeZoneSidKey;
        }
        return $this;
    }
    /**
     * Get TuesdayEndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTuesdayEndTime()
    {
        return isset($this->TuesdayEndTime) ? $this->TuesdayEndTime : null;
    }
    /**
     * Set TuesdayEndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tuesdayEndTime
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setTuesdayEndTime($tuesdayEndTime = null)
    {
        // validation for constraint: string
        if (!is_null($tuesdayEndTime) && !is_string($tuesdayEndTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tuesdayEndTime, true), gettype($tuesdayEndTime)), __LINE__);
        }
        if (is_null($tuesdayEndTime) || (is_array($tuesdayEndTime) && empty($tuesdayEndTime))) {
            unset($this->TuesdayEndTime);
        } else {
            $this->TuesdayEndTime = $tuesdayEndTime;
        }
        return $this;
    }
    /**
     * Get TuesdayStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTuesdayStartTime()
    {
        return isset($this->TuesdayStartTime) ? $this->TuesdayStartTime : null;
    }
    /**
     * Set TuesdayStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tuesdayStartTime
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setTuesdayStartTime($tuesdayStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($tuesdayStartTime) && !is_string($tuesdayStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tuesdayStartTime, true), gettype($tuesdayStartTime)), __LINE__);
        }
        if (is_null($tuesdayStartTime) || (is_array($tuesdayStartTime) && empty($tuesdayStartTime))) {
            unset($this->TuesdayStartTime);
        } else {
            $this->TuesdayStartTime = $tuesdayStartTime;
        }
        return $this;
    }
    /**
     * Get WednesdayEndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWednesdayEndTime()
    {
        return isset($this->WednesdayEndTime) ? $this->WednesdayEndTime : null;
    }
    /**
     * Set WednesdayEndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wednesdayEndTime
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setWednesdayEndTime($wednesdayEndTime = null)
    {
        // validation for constraint: string
        if (!is_null($wednesdayEndTime) && !is_string($wednesdayEndTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wednesdayEndTime, true), gettype($wednesdayEndTime)), __LINE__);
        }
        if (is_null($wednesdayEndTime) || (is_array($wednesdayEndTime) && empty($wednesdayEndTime))) {
            unset($this->WednesdayEndTime);
        } else {
            $this->WednesdayEndTime = $wednesdayEndTime;
        }
        return $this;
    }
    /**
     * Get WednesdayStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWednesdayStartTime()
    {
        return isset($this->WednesdayStartTime) ? $this->WednesdayStartTime : null;
    }
    /**
     * Set WednesdayStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wednesdayStartTime
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setWednesdayStartTime($wednesdayStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($wednesdayStartTime) && !is_string($wednesdayStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wednesdayStartTime, true), gettype($wednesdayStartTime)), __LINE__);
        }
        if (is_null($wednesdayStartTime) || (is_array($wednesdayStartTime) && empty($wednesdayStartTime))) {
            unset($this->WednesdayStartTime);
        } else {
            $this->WednesdayStartTime = $wednesdayStartTime;
        }
        return $this;
    }
    /**
     * Get WorkOrders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getWorkOrders()
    {
        return isset($this->WorkOrders) ? $this->WorkOrders : null;
    }
    /**
     * Set WorkOrders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $workOrders
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public function setWorkOrders(\NexusDigital/MiratelForce\StructType\QueryResult $workOrders = null)
    {
        if (is_null($workOrders) || (is_array($workOrders) && empty($workOrders))) {
            unset($this->WorkOrders);
        } else {
            $this->WorkOrders = $workOrders;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\BusinessHours
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
