<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AsyncApexJob StructType
 * @subpackage Structs
 */
class AsyncApexJob extends SObject
{
    /**
     * The ApexClass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ApexClass
     */
    public $ApexClass;
    /**
     * The ApexClassId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ApexClassId;
    /**
     * The AsyncApex
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AsyncApex;
    /**
     * The CompletedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompletedDate;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The ExtendedStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedStatus;
    /**
     * The JobItemsProcessed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $JobItemsProcessed;
    /**
     * The JobType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JobType;
    /**
     * The LastProcessed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastProcessed;
    /**
     * The LastProcessedOffset
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LastProcessedOffset;
    /**
     * The MethodName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MethodName;
    /**
     * The NumberOfErrors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfErrors;
    /**
     * The ParentJobId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentJobId;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TotalJobItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalJobItems;
    /**
     * Constructor method for AsyncApexJob
     * @uses AsyncApexJob::setApexClass()
     * @uses AsyncApexJob::setApexClassId()
     * @uses AsyncApexJob::setAsyncApex()
     * @uses AsyncApexJob::setCompletedDate()
     * @uses AsyncApexJob::setCreatedBy()
     * @uses AsyncApexJob::setCreatedById()
     * @uses AsyncApexJob::setCreatedDate()
     * @uses AsyncApexJob::setExtendedStatus()
     * @uses AsyncApexJob::setJobItemsProcessed()
     * @uses AsyncApexJob::setJobType()
     * @uses AsyncApexJob::setLastProcessed()
     * @uses AsyncApexJob::setLastProcessedOffset()
     * @uses AsyncApexJob::setMethodName()
     * @uses AsyncApexJob::setNumberOfErrors()
     * @uses AsyncApexJob::setParentJobId()
     * @uses AsyncApexJob::setStatus()
     * @uses AsyncApexJob::setTotalJobItems()
     * @param \NexusDigital/MiratelForce\StructType\ApexClass $apexClass
     * @param string $apexClassId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $asyncApex
     * @param string $completedDate
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $extendedStatus
     * @param int $jobItemsProcessed
     * @param string $jobType
     * @param string $lastProcessed
     * @param int $lastProcessedOffset
     * @param string $methodName
     * @param int $numberOfErrors
     * @param string $parentJobId
     * @param string $status
     * @param int $totalJobItems
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\ApexClass $apexClass = null, $apexClassId = null, \NexusDigital/MiratelForce\StructType\QueryResult $asyncApex = null, $completedDate = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $extendedStatus = null, $jobItemsProcessed = null, $jobType = null, $lastProcessed = null, $lastProcessedOffset = null, $methodName = null, $numberOfErrors = null, $parentJobId = null, $status = null, $totalJobItems = null)
    {
        $this
            ->setApexClass($apexClass)
            ->setApexClassId($apexClassId)
            ->setAsyncApex($asyncApex)
            ->setCompletedDate($completedDate)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setExtendedStatus($extendedStatus)
            ->setJobItemsProcessed($jobItemsProcessed)
            ->setJobType($jobType)
            ->setLastProcessed($lastProcessed)
            ->setLastProcessedOffset($lastProcessedOffset)
            ->setMethodName($methodName)
            ->setNumberOfErrors($numberOfErrors)
            ->setParentJobId($parentJobId)
            ->setStatus($status)
            ->setTotalJobItems($totalJobItems);
    }
    /**
     * Get ApexClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ApexClass|null
     */
    public function getApexClass()
    {
        return isset($this->ApexClass) ? $this->ApexClass : null;
    }
    /**
     * Set ApexClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ApexClass $apexClass
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setApexClass(\NexusDigital/MiratelForce\StructType\ApexClass $apexClass = null)
    {
        if (is_null($apexClass) || (is_array($apexClass) && empty($apexClass))) {
            unset($this->ApexClass);
        } else {
            $this->ApexClass = $apexClass;
        }
        return $this;
    }
    /**
     * Get ApexClassId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApexClassId()
    {
        return isset($this->ApexClassId) ? $this->ApexClassId : null;
    }
    /**
     * Set ApexClassId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apexClassId
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setApexClassId($apexClassId = null)
    {
        // validation for constraint: string
        if (!is_null($apexClassId) && !is_string($apexClassId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apexClassId, true), gettype($apexClassId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($apexClassId) && mb_strlen($apexClassId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($apexClassId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($apexClassId) && !preg_match('/[a-zA-Z0-9]{18}/', $apexClassId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($apexClassId, true)), __LINE__);
        }
        if (is_null($apexClassId) || (is_array($apexClassId) && empty($apexClassId))) {
            unset($this->ApexClassId);
        } else {
            $this->ApexClassId = $apexClassId;
        }
        return $this;
    }
    /**
     * Get AsyncApex value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAsyncApex()
    {
        return isset($this->AsyncApex) ? $this->AsyncApex : null;
    }
    /**
     * Set AsyncApex value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $asyncApex
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setAsyncApex(\NexusDigital/MiratelForce\StructType\QueryResult $asyncApex = null)
    {
        if (is_null($asyncApex) || (is_array($asyncApex) && empty($asyncApex))) {
            unset($this->AsyncApex);
        } else {
            $this->AsyncApex = $asyncApex;
        }
        return $this;
    }
    /**
     * Get CompletedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompletedDate()
    {
        return isset($this->CompletedDate) ? $this->CompletedDate : null;
    }
    /**
     * Set CompletedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $completedDate
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setCompletedDate($completedDate = null)
    {
        // validation for constraint: string
        if (!is_null($completedDate) && !is_string($completedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($completedDate, true), gettype($completedDate)), __LINE__);
        }
        if (is_null($completedDate) || (is_array($completedDate) && empty($completedDate))) {
            unset($this->CompletedDate);
        } else {
            $this->CompletedDate = $completedDate;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get ExtendedStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedStatus()
    {
        return isset($this->ExtendedStatus) ? $this->ExtendedStatus : null;
    }
    /**
     * Set ExtendedStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedStatus
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setExtendedStatus($extendedStatus = null)
    {
        // validation for constraint: string
        if (!is_null($extendedStatus) && !is_string($extendedStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedStatus, true), gettype($extendedStatus)), __LINE__);
        }
        if (is_null($extendedStatus) || (is_array($extendedStatus) && empty($extendedStatus))) {
            unset($this->ExtendedStatus);
        } else {
            $this->ExtendedStatus = $extendedStatus;
        }
        return $this;
    }
    /**
     * Get JobItemsProcessed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getJobItemsProcessed()
    {
        return isset($this->JobItemsProcessed) ? $this->JobItemsProcessed : null;
    }
    /**
     * Set JobItemsProcessed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $jobItemsProcessed
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setJobItemsProcessed($jobItemsProcessed = null)
    {
        // validation for constraint: int
        if (!is_null($jobItemsProcessed) && !(is_int($jobItemsProcessed) || ctype_digit($jobItemsProcessed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jobItemsProcessed, true), gettype($jobItemsProcessed)), __LINE__);
        }
        if (is_null($jobItemsProcessed) || (is_array($jobItemsProcessed) && empty($jobItemsProcessed))) {
            unset($this->JobItemsProcessed);
        } else {
            $this->JobItemsProcessed = $jobItemsProcessed;
        }
        return $this;
    }
    /**
     * Get JobType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJobType()
    {
        return isset($this->JobType) ? $this->JobType : null;
    }
    /**
     * Set JobType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jobType
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setJobType($jobType = null)
    {
        // validation for constraint: string
        if (!is_null($jobType) && !is_string($jobType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobType, true), gettype($jobType)), __LINE__);
        }
        if (is_null($jobType) || (is_array($jobType) && empty($jobType))) {
            unset($this->JobType);
        } else {
            $this->JobType = $jobType;
        }
        return $this;
    }
    /**
     * Get LastProcessed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastProcessed()
    {
        return isset($this->LastProcessed) ? $this->LastProcessed : null;
    }
    /**
     * Set LastProcessed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastProcessed
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setLastProcessed($lastProcessed = null)
    {
        // validation for constraint: string
        if (!is_null($lastProcessed) && !is_string($lastProcessed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastProcessed, true), gettype($lastProcessed)), __LINE__);
        }
        if (is_null($lastProcessed) || (is_array($lastProcessed) && empty($lastProcessed))) {
            unset($this->LastProcessed);
        } else {
            $this->LastProcessed = $lastProcessed;
        }
        return $this;
    }
    /**
     * Get LastProcessedOffset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLastProcessedOffset()
    {
        return isset($this->LastProcessedOffset) ? $this->LastProcessedOffset : null;
    }
    /**
     * Set LastProcessedOffset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lastProcessedOffset
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setLastProcessedOffset($lastProcessedOffset = null)
    {
        // validation for constraint: int
        if (!is_null($lastProcessedOffset) && !(is_int($lastProcessedOffset) || ctype_digit($lastProcessedOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastProcessedOffset, true), gettype($lastProcessedOffset)), __LINE__);
        }
        if (is_null($lastProcessedOffset) || (is_array($lastProcessedOffset) && empty($lastProcessedOffset))) {
            unset($this->LastProcessedOffset);
        } else {
            $this->LastProcessedOffset = $lastProcessedOffset;
        }
        return $this;
    }
    /**
     * Get MethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMethodName()
    {
        return isset($this->MethodName) ? $this->MethodName : null;
    }
    /**
     * Set MethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $methodName
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setMethodName($methodName = null)
    {
        // validation for constraint: string
        if (!is_null($methodName) && !is_string($methodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodName, true), gettype($methodName)), __LINE__);
        }
        if (is_null($methodName) || (is_array($methodName) && empty($methodName))) {
            unset($this->MethodName);
        } else {
            $this->MethodName = $methodName;
        }
        return $this;
    }
    /**
     * Get NumberOfErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfErrors()
    {
        return isset($this->NumberOfErrors) ? $this->NumberOfErrors : null;
    }
    /**
     * Set NumberOfErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfErrors
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setNumberOfErrors($numberOfErrors = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfErrors) && !(is_int($numberOfErrors) || ctype_digit($numberOfErrors))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfErrors, true), gettype($numberOfErrors)), __LINE__);
        }
        if (is_null($numberOfErrors) || (is_array($numberOfErrors) && empty($numberOfErrors))) {
            unset($this->NumberOfErrors);
        } else {
            $this->NumberOfErrors = $numberOfErrors;
        }
        return $this;
    }
    /**
     * Get ParentJobId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentJobId()
    {
        return isset($this->ParentJobId) ? $this->ParentJobId : null;
    }
    /**
     * Set ParentJobId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentJobId
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setParentJobId($parentJobId = null)
    {
        // validation for constraint: string
        if (!is_null($parentJobId) && !is_string($parentJobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentJobId, true), gettype($parentJobId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentJobId) && mb_strlen($parentJobId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentJobId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentJobId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentJobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentJobId, true)), __LINE__);
        }
        if (is_null($parentJobId) || (is_array($parentJobId) && empty($parentJobId))) {
            unset($this->ParentJobId);
        } else {
            $this->ParentJobId = $parentJobId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TotalJobItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalJobItems()
    {
        return isset($this->TotalJobItems) ? $this->TotalJobItems : null;
    }
    /**
     * Set TotalJobItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalJobItems
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public function setTotalJobItems($totalJobItems = null)
    {
        // validation for constraint: int
        if (!is_null($totalJobItems) && !(is_int($totalJobItems) || ctype_digit($totalJobItems))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalJobItems, true), gettype($totalJobItems)), __LINE__);
        }
        if (is_null($totalJobItems) || (is_array($totalJobItems) && empty($totalJobItems))) {
            unset($this->TotalJobItems);
        } else {
            $this->TotalJobItems = $totalJobItems;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
