<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssetTokenEvent StructType
 * @subpackage Structs
 */
class AssetTokenEvent extends SObject
{
    /**
     * The ActorTokenPayload
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActorTokenPayload;
    /**
     * The Asset
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Asset
     */
    public $Asset;
    /**
     * The AssetId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AssetId;
    /**
     * The AssetName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssetName;
    /**
     * The AssetSerialNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssetSerialNumber;
    /**
     * The ConnectedApp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ConnectedApplication
     */
    public $ConnectedApp;
    /**
     * The ConnectedAppId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ConnectedAppId;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DeviceId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceId;
    /**
     * The DeviceKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceKey;
    /**
     * The Expiration
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Expiration;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The ReplayId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReplayId;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $User;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for AssetTokenEvent
     * @uses AssetTokenEvent::setActorTokenPayload()
     * @uses AssetTokenEvent::setAsset()
     * @uses AssetTokenEvent::setAssetId()
     * @uses AssetTokenEvent::setAssetName()
     * @uses AssetTokenEvent::setAssetSerialNumber()
     * @uses AssetTokenEvent::setConnectedApp()
     * @uses AssetTokenEvent::setConnectedAppId()
     * @uses AssetTokenEvent::setCreatedBy()
     * @uses AssetTokenEvent::setCreatedById()
     * @uses AssetTokenEvent::setCreatedDate()
     * @uses AssetTokenEvent::setDeviceId()
     * @uses AssetTokenEvent::setDeviceKey()
     * @uses AssetTokenEvent::setExpiration()
     * @uses AssetTokenEvent::setName()
     * @uses AssetTokenEvent::setReplayId()
     * @uses AssetTokenEvent::setUser()
     * @uses AssetTokenEvent::setUserId()
     * @param string $actorTokenPayload
     * @param \NexusDigital/MiratelForce\StructType\Asset $asset
     * @param string $assetId
     * @param string $assetName
     * @param string $assetSerialNumber
     * @param \NexusDigital/MiratelForce\StructType\ConnectedApplication $connectedApp
     * @param string $connectedAppId
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $deviceId
     * @param string $deviceKey
     * @param string $expiration
     * @param string $name
     * @param string $replayId
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @param string $userId
     */
    public function __construct($actorTokenPayload = null, \NexusDigital/MiratelForce\StructType\Asset $asset = null, $assetId = null, $assetName = null, $assetSerialNumber = null, \NexusDigital/MiratelForce\StructType\ConnectedApplication $connectedApp = null, $connectedAppId = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $deviceId = null, $deviceKey = null, $expiration = null, $name = null, $replayId = null, \NexusDigital/MiratelForce\StructType\User $user = null, $userId = null)
    {
        $this
            ->setActorTokenPayload($actorTokenPayload)
            ->setAsset($asset)
            ->setAssetId($assetId)
            ->setAssetName($assetName)
            ->setAssetSerialNumber($assetSerialNumber)
            ->setConnectedApp($connectedApp)
            ->setConnectedAppId($connectedAppId)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDeviceId($deviceId)
            ->setDeviceKey($deviceKey)
            ->setExpiration($expiration)
            ->setName($name)
            ->setReplayId($replayId)
            ->setUser($user)
            ->setUserId($userId);
    }
    /**
     * Get ActorTokenPayload value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActorTokenPayload()
    {
        return isset($this->ActorTokenPayload) ? $this->ActorTokenPayload : null;
    }
    /**
     * Set ActorTokenPayload value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actorTokenPayload
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setActorTokenPayload($actorTokenPayload = null)
    {
        // validation for constraint: string
        if (!is_null($actorTokenPayload) && !is_string($actorTokenPayload)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actorTokenPayload, true), gettype($actorTokenPayload)), __LINE__);
        }
        if (is_null($actorTokenPayload) || (is_array($actorTokenPayload) && empty($actorTokenPayload))) {
            unset($this->ActorTokenPayload);
        } else {
            $this->ActorTokenPayload = $actorTokenPayload;
        }
        return $this;
    }
    /**
     * Get Asset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Asset|null
     */
    public function getAsset()
    {
        return isset($this->Asset) ? $this->Asset : null;
    }
    /**
     * Set Asset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Asset $asset
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setAsset(\NexusDigital/MiratelForce\StructType\Asset $asset = null)
    {
        if (is_null($asset) || (is_array($asset) && empty($asset))) {
            unset($this->Asset);
        } else {
            $this->Asset = $asset;
        }
        return $this;
    }
    /**
     * Get AssetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssetId()
    {
        return isset($this->AssetId) ? $this->AssetId : null;
    }
    /**
     * Set AssetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assetId
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setAssetId($assetId = null)
    {
        // validation for constraint: string
        if (!is_null($assetId) && !is_string($assetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assetId, true), gettype($assetId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($assetId) && mb_strlen($assetId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($assetId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($assetId) && !preg_match('/[a-zA-Z0-9]{18}/', $assetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($assetId, true)), __LINE__);
        }
        if (is_null($assetId) || (is_array($assetId) && empty($assetId))) {
            unset($this->AssetId);
        } else {
            $this->AssetId = $assetId;
        }
        return $this;
    }
    /**
     * Get AssetName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssetName()
    {
        return isset($this->AssetName) ? $this->AssetName : null;
    }
    /**
     * Set AssetName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assetName
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setAssetName($assetName = null)
    {
        // validation for constraint: string
        if (!is_null($assetName) && !is_string($assetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assetName, true), gettype($assetName)), __LINE__);
        }
        if (is_null($assetName) || (is_array($assetName) && empty($assetName))) {
            unset($this->AssetName);
        } else {
            $this->AssetName = $assetName;
        }
        return $this;
    }
    /**
     * Get AssetSerialNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssetSerialNumber()
    {
        return isset($this->AssetSerialNumber) ? $this->AssetSerialNumber : null;
    }
    /**
     * Set AssetSerialNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assetSerialNumber
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setAssetSerialNumber($assetSerialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($assetSerialNumber) && !is_string($assetSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assetSerialNumber, true), gettype($assetSerialNumber)), __LINE__);
        }
        if (is_null($assetSerialNumber) || (is_array($assetSerialNumber) && empty($assetSerialNumber))) {
            unset($this->AssetSerialNumber);
        } else {
            $this->AssetSerialNumber = $assetSerialNumber;
        }
        return $this;
    }
    /**
     * Get ConnectedApp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ConnectedApplication|null
     */
    public function getConnectedApp()
    {
        return isset($this->ConnectedApp) ? $this->ConnectedApp : null;
    }
    /**
     * Set ConnectedApp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ConnectedApplication $connectedApp
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setConnectedApp(\NexusDigital/MiratelForce\StructType\ConnectedApplication $connectedApp = null)
    {
        if (is_null($connectedApp) || (is_array($connectedApp) && empty($connectedApp))) {
            unset($this->ConnectedApp);
        } else {
            $this->ConnectedApp = $connectedApp;
        }
        return $this;
    }
    /**
     * Get ConnectedAppId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConnectedAppId()
    {
        return isset($this->ConnectedAppId) ? $this->ConnectedAppId : null;
    }
    /**
     * Set ConnectedAppId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $connectedAppId
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setConnectedAppId($connectedAppId = null)
    {
        // validation for constraint: string
        if (!is_null($connectedAppId) && !is_string($connectedAppId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectedAppId, true), gettype($connectedAppId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($connectedAppId) && mb_strlen($connectedAppId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($connectedAppId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($connectedAppId) && !preg_match('/[a-zA-Z0-9]{18}/', $connectedAppId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($connectedAppId, true)), __LINE__);
        }
        if (is_null($connectedAppId) || (is_array($connectedAppId) && empty($connectedAppId))) {
            unset($this->ConnectedAppId);
        } else {
            $this->ConnectedAppId = $connectedAppId;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DeviceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceId()
    {
        return isset($this->DeviceId) ? $this->DeviceId : null;
    }
    /**
     * Set DeviceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceId
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: string
        if (!is_null($deviceId) && !is_string($deviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        if (is_null($deviceId) || (is_array($deviceId) && empty($deviceId))) {
            unset($this->DeviceId);
        } else {
            $this->DeviceId = $deviceId;
        }
        return $this;
    }
    /**
     * Get DeviceKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceKey()
    {
        return isset($this->DeviceKey) ? $this->DeviceKey : null;
    }
    /**
     * Set DeviceKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceKey
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setDeviceKey($deviceKey = null)
    {
        // validation for constraint: string
        if (!is_null($deviceKey) && !is_string($deviceKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceKey, true), gettype($deviceKey)), __LINE__);
        }
        if (is_null($deviceKey) || (is_array($deviceKey) && empty($deviceKey))) {
            unset($this->DeviceKey);
        } else {
            $this->DeviceKey = $deviceKey;
        }
        return $this;
    }
    /**
     * Get Expiration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiration()
    {
        return isset($this->Expiration) ? $this->Expiration : null;
    }
    /**
     * Set Expiration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiration
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setExpiration($expiration = null)
    {
        // validation for constraint: string
        if (!is_null($expiration) && !is_string($expiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiration, true), gettype($expiration)), __LINE__);
        }
        if (is_null($expiration) || (is_array($expiration) && empty($expiration))) {
            unset($this->Expiration);
        } else {
            $this->Expiration = $expiration;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get ReplayId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReplayId()
    {
        return isset($this->ReplayId) ? $this->ReplayId : null;
    }
    /**
     * Set ReplayId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $replayId
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setReplayId($replayId = null)
    {
        // validation for constraint: string
        if (!is_null($replayId) && !is_string($replayId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replayId, true), gettype($replayId)), __LINE__);
        }
        if (is_null($replayId) || (is_array($replayId) && empty($replayId))) {
            unset($this->ReplayId);
        } else {
            $this->ReplayId = $replayId;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setUser(\NexusDigital/MiratelForce\StructType\User $user = null)
    {
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userId) && mb_strlen($userId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userId) && !preg_match('/[a-zA-Z0-9]{18}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\AssetTokenEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
