<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgentWork StructType
 * @subpackage Structs
 */
class AgentWork extends SObject
{
    /**
     * The AcceptDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AcceptDateTime;
    /**
     * The ActiveTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ActiveTime;
    /**
     * The AgentCapacityWhenDeclined
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AgentCapacityWhenDeclined;
    /**
     * The AssignedDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssignedDateTime;
    /**
     * The CancelDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CancelDateTime;
    /**
     * The CapacityPercentage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CapacityPercentage;
    /**
     * The CapacityWeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CapacityWeight;
    /**
     * The CloseDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CloseDateTime;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DeclineDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeclineDateTime;
    /**
     * The DeclineReason
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeclineReason;
    /**
     * The HandleTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HandleTime;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OriginalGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Group
     */
    public $OriginalGroup;
    /**
     * The OriginalGroupId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OriginalGroupId;
    /**
     * The OriginalQueue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Group
     */
    public $OriginalQueue;
    /**
     * The OriginalQueueId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OriginalQueueId;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $Owner;
    /**
     * The OwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OwnerId;
    /**
     * The PendingServiceRouting
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\PendingServiceRouting
     */
    public $PendingServiceRouting;
    /**
     * The PendingServiceRoutingId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PendingServiceRoutingId;
    /**
     * The PreferredUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $PreferredUser;
    /**
     * The PreferredUserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PreferredUserId;
    /**
     * The PushTimeout
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PushTimeout;
    /**
     * The PushTimeoutDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PushTimeoutDateTime;
    /**
     * The RequestDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestDateTime;
    /**
     * The RoutingModel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoutingModel;
    /**
     * The RoutingPriority
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RoutingPriority;
    /**
     * The RoutingType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoutingType;
    /**
     * The ServiceChannel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ServiceChannel
     */
    public $ServiceChannel;
    /**
     * The ServiceChannelId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ServiceChannelId;
    /**
     * The ShouldSkipCapacityCheck
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShouldSkipCapacityCheck;
    /**
     * The SpeedToAnswer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SpeedToAnswer;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $User;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserId;
    /**
     * The UserRecordAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public $UserRecordAccess;
    /**
     * The WorkItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\_Case
     */
    public $WorkItem;
    /**
     * The WorkItemId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $WorkItemId;
    /**
     * Constructor method for AgentWork
     * @uses AgentWork::setAcceptDateTime()
     * @uses AgentWork::setActiveTime()
     * @uses AgentWork::setAgentCapacityWhenDeclined()
     * @uses AgentWork::setAssignedDateTime()
     * @uses AgentWork::setCancelDateTime()
     * @uses AgentWork::setCapacityPercentage()
     * @uses AgentWork::setCapacityWeight()
     * @uses AgentWork::setCloseDateTime()
     * @uses AgentWork::setCreatedBy()
     * @uses AgentWork::setCreatedById()
     * @uses AgentWork::setCreatedDate()
     * @uses AgentWork::setDeclineDateTime()
     * @uses AgentWork::setDeclineReason()
     * @uses AgentWork::setHandleTime()
     * @uses AgentWork::setIsDeleted()
     * @uses AgentWork::setLastModifiedBy()
     * @uses AgentWork::setLastModifiedById()
     * @uses AgentWork::setLastModifiedDate()
     * @uses AgentWork::setName()
     * @uses AgentWork::setOriginalGroup()
     * @uses AgentWork::setOriginalGroupId()
     * @uses AgentWork::setOriginalQueue()
     * @uses AgentWork::setOriginalQueueId()
     * @uses AgentWork::setOwner()
     * @uses AgentWork::setOwnerId()
     * @uses AgentWork::setPendingServiceRouting()
     * @uses AgentWork::setPendingServiceRoutingId()
     * @uses AgentWork::setPreferredUser()
     * @uses AgentWork::setPreferredUserId()
     * @uses AgentWork::setPushTimeout()
     * @uses AgentWork::setPushTimeoutDateTime()
     * @uses AgentWork::setRequestDateTime()
     * @uses AgentWork::setRoutingModel()
     * @uses AgentWork::setRoutingPriority()
     * @uses AgentWork::setRoutingType()
     * @uses AgentWork::setServiceChannel()
     * @uses AgentWork::setServiceChannelId()
     * @uses AgentWork::setShouldSkipCapacityCheck()
     * @uses AgentWork::setSpeedToAnswer()
     * @uses AgentWork::setStatus()
     * @uses AgentWork::setSystemModstamp()
     * @uses AgentWork::setUser()
     * @uses AgentWork::setUserId()
     * @uses AgentWork::setUserRecordAccess()
     * @uses AgentWork::setWorkItem()
     * @uses AgentWork::setWorkItemId()
     * @param string $acceptDateTime
     * @param int $activeTime
     * @param float $agentCapacityWhenDeclined
     * @param string $assignedDateTime
     * @param string $cancelDateTime
     * @param float $capacityPercentage
     * @param float $capacityWeight
     * @param string $closeDateTime
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $declineDateTime
     * @param string $declineReason
     * @param int $handleTime
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $name
     * @param \NexusDigital/MiratelForce\StructType\Group $originalGroup
     * @param string $originalGroupId
     * @param \NexusDigital/MiratelForce\StructType\Group $originalQueue
     * @param string $originalQueueId
     * @param \NexusDigital/MiratelForce\StructType\SObject $owner
     * @param string $ownerId
     * @param \NexusDigital/MiratelForce\StructType\PendingServiceRouting $pendingServiceRouting
     * @param string $pendingServiceRoutingId
     * @param \NexusDigital/MiratelForce\StructType\User $preferredUser
     * @param string $preferredUserId
     * @param int $pushTimeout
     * @param string $pushTimeoutDateTime
     * @param string $requestDateTime
     * @param string $routingModel
     * @param int $routingPriority
     * @param string $routingType
     * @param \NexusDigital/MiratelForce\StructType\ServiceChannel $serviceChannel
     * @param string $serviceChannelId
     * @param bool $shouldSkipCapacityCheck
     * @param int $speedToAnswer
     * @param string $status
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @param string $userId
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @param \NexusDigital/MiratelForce\StructType\_Case $workItem
     * @param string $workItemId
     */
    public function __construct($acceptDateTime = null, $activeTime = null, $agentCapacityWhenDeclined = null, $assignedDateTime = null, $cancelDateTime = null, $capacityPercentage = null, $capacityWeight = null, $closeDateTime = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $declineDateTime = null, $declineReason = null, $handleTime = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $name = null, \NexusDigital/MiratelForce\StructType\Group $originalGroup = null, $originalGroupId = null, \NexusDigital/MiratelForce\StructType\Group $originalQueue = null, $originalQueueId = null, \NexusDigital/MiratelForce\StructType\SObject $owner = null, $ownerId = null, \NexusDigital/MiratelForce\StructType\PendingServiceRouting $pendingServiceRouting = null, $pendingServiceRoutingId = null, \NexusDigital/MiratelForce\StructType\User $preferredUser = null, $preferredUserId = null, $pushTimeout = null, $pushTimeoutDateTime = null, $requestDateTime = null, $routingModel = null, $routingPriority = null, $routingType = null, \NexusDigital/MiratelForce\StructType\ServiceChannel $serviceChannel = null, $serviceChannelId = null, $shouldSkipCapacityCheck = null, $speedToAnswer = null, $status = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\User $user = null, $userId = null, \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null, \NexusDigital/MiratelForce\StructType\_Case $workItem = null, $workItemId = null)
    {
        $this
            ->setAcceptDateTime($acceptDateTime)
            ->setActiveTime($activeTime)
            ->setAgentCapacityWhenDeclined($agentCapacityWhenDeclined)
            ->setAssignedDateTime($assignedDateTime)
            ->setCancelDateTime($cancelDateTime)
            ->setCapacityPercentage($capacityPercentage)
            ->setCapacityWeight($capacityWeight)
            ->setCloseDateTime($closeDateTime)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDeclineDateTime($declineDateTime)
            ->setDeclineReason($declineReason)
            ->setHandleTime($handleTime)
            ->setIsDeleted($isDeleted)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setName($name)
            ->setOriginalGroup($originalGroup)
            ->setOriginalGroupId($originalGroupId)
            ->setOriginalQueue($originalQueue)
            ->setOriginalQueueId($originalQueueId)
            ->setOwner($owner)
            ->setOwnerId($ownerId)
            ->setPendingServiceRouting($pendingServiceRouting)
            ->setPendingServiceRoutingId($pendingServiceRoutingId)
            ->setPreferredUser($preferredUser)
            ->setPreferredUserId($preferredUserId)
            ->setPushTimeout($pushTimeout)
            ->setPushTimeoutDateTime($pushTimeoutDateTime)
            ->setRequestDateTime($requestDateTime)
            ->setRoutingModel($routingModel)
            ->setRoutingPriority($routingPriority)
            ->setRoutingType($routingType)
            ->setServiceChannel($serviceChannel)
            ->setServiceChannelId($serviceChannelId)
            ->setShouldSkipCapacityCheck($shouldSkipCapacityCheck)
            ->setSpeedToAnswer($speedToAnswer)
            ->setStatus($status)
            ->setSystemModstamp($systemModstamp)
            ->setUser($user)
            ->setUserId($userId)
            ->setUserRecordAccess($userRecordAccess)
            ->setWorkItem($workItem)
            ->setWorkItemId($workItemId);
    }
    /**
     * Get AcceptDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcceptDateTime()
    {
        return isset($this->AcceptDateTime) ? $this->AcceptDateTime : null;
    }
    /**
     * Set AcceptDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acceptDateTime
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setAcceptDateTime($acceptDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($acceptDateTime) && !is_string($acceptDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptDateTime, true), gettype($acceptDateTime)), __LINE__);
        }
        if (is_null($acceptDateTime) || (is_array($acceptDateTime) && empty($acceptDateTime))) {
            unset($this->AcceptDateTime);
        } else {
            $this->AcceptDateTime = $acceptDateTime;
        }
        return $this;
    }
    /**
     * Get ActiveTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getActiveTime()
    {
        return isset($this->ActiveTime) ? $this->ActiveTime : null;
    }
    /**
     * Set ActiveTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $activeTime
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setActiveTime($activeTime = null)
    {
        // validation for constraint: int
        if (!is_null($activeTime) && !(is_int($activeTime) || ctype_digit($activeTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($activeTime, true), gettype($activeTime)), __LINE__);
        }
        if (is_null($activeTime) || (is_array($activeTime) && empty($activeTime))) {
            unset($this->ActiveTime);
        } else {
            $this->ActiveTime = $activeTime;
        }
        return $this;
    }
    /**
     * Get AgentCapacityWhenDeclined value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAgentCapacityWhenDeclined()
    {
        return isset($this->AgentCapacityWhenDeclined) ? $this->AgentCapacityWhenDeclined : null;
    }
    /**
     * Set AgentCapacityWhenDeclined value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $agentCapacityWhenDeclined
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setAgentCapacityWhenDeclined($agentCapacityWhenDeclined = null)
    {
        // validation for constraint: float
        if (!is_null($agentCapacityWhenDeclined) && !(is_float($agentCapacityWhenDeclined) || is_numeric($agentCapacityWhenDeclined))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($agentCapacityWhenDeclined, true), gettype($agentCapacityWhenDeclined)), __LINE__);
        }
        if (is_null($agentCapacityWhenDeclined) || (is_array($agentCapacityWhenDeclined) && empty($agentCapacityWhenDeclined))) {
            unset($this->AgentCapacityWhenDeclined);
        } else {
            $this->AgentCapacityWhenDeclined = $agentCapacityWhenDeclined;
        }
        return $this;
    }
    /**
     * Get AssignedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignedDateTime()
    {
        return isset($this->AssignedDateTime) ? $this->AssignedDateTime : null;
    }
    /**
     * Set AssignedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignedDateTime
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setAssignedDateTime($assignedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($assignedDateTime) && !is_string($assignedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignedDateTime, true), gettype($assignedDateTime)), __LINE__);
        }
        if (is_null($assignedDateTime) || (is_array($assignedDateTime) && empty($assignedDateTime))) {
            unset($this->AssignedDateTime);
        } else {
            $this->AssignedDateTime = $assignedDateTime;
        }
        return $this;
    }
    /**
     * Get CancelDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCancelDateTime()
    {
        return isset($this->CancelDateTime) ? $this->CancelDateTime : null;
    }
    /**
     * Set CancelDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cancelDateTime
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setCancelDateTime($cancelDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($cancelDateTime) && !is_string($cancelDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelDateTime, true), gettype($cancelDateTime)), __LINE__);
        }
        if (is_null($cancelDateTime) || (is_array($cancelDateTime) && empty($cancelDateTime))) {
            unset($this->CancelDateTime);
        } else {
            $this->CancelDateTime = $cancelDateTime;
        }
        return $this;
    }
    /**
     * Get CapacityPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCapacityPercentage()
    {
        return isset($this->CapacityPercentage) ? $this->CapacityPercentage : null;
    }
    /**
     * Set CapacityPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $capacityPercentage
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setCapacityPercentage($capacityPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($capacityPercentage) && !(is_float($capacityPercentage) || is_numeric($capacityPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($capacityPercentage, true), gettype($capacityPercentage)), __LINE__);
        }
        if (is_null($capacityPercentage) || (is_array($capacityPercentage) && empty($capacityPercentage))) {
            unset($this->CapacityPercentage);
        } else {
            $this->CapacityPercentage = $capacityPercentage;
        }
        return $this;
    }
    /**
     * Get CapacityWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCapacityWeight()
    {
        return isset($this->CapacityWeight) ? $this->CapacityWeight : null;
    }
    /**
     * Set CapacityWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $capacityWeight
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setCapacityWeight($capacityWeight = null)
    {
        // validation for constraint: float
        if (!is_null($capacityWeight) && !(is_float($capacityWeight) || is_numeric($capacityWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($capacityWeight, true), gettype($capacityWeight)), __LINE__);
        }
        if (is_null($capacityWeight) || (is_array($capacityWeight) && empty($capacityWeight))) {
            unset($this->CapacityWeight);
        } else {
            $this->CapacityWeight = $capacityWeight;
        }
        return $this;
    }
    /**
     * Get CloseDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCloseDateTime()
    {
        return isset($this->CloseDateTime) ? $this->CloseDateTime : null;
    }
    /**
     * Set CloseDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $closeDateTime
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setCloseDateTime($closeDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($closeDateTime) && !is_string($closeDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closeDateTime, true), gettype($closeDateTime)), __LINE__);
        }
        if (is_null($closeDateTime) || (is_array($closeDateTime) && empty($closeDateTime))) {
            unset($this->CloseDateTime);
        } else {
            $this->CloseDateTime = $closeDateTime;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DeclineDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeclineDateTime()
    {
        return isset($this->DeclineDateTime) ? $this->DeclineDateTime : null;
    }
    /**
     * Set DeclineDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $declineDateTime
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setDeclineDateTime($declineDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($declineDateTime) && !is_string($declineDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declineDateTime, true), gettype($declineDateTime)), __LINE__);
        }
        if (is_null($declineDateTime) || (is_array($declineDateTime) && empty($declineDateTime))) {
            unset($this->DeclineDateTime);
        } else {
            $this->DeclineDateTime = $declineDateTime;
        }
        return $this;
    }
    /**
     * Get DeclineReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeclineReason()
    {
        return isset($this->DeclineReason) ? $this->DeclineReason : null;
    }
    /**
     * Set DeclineReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $declineReason
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setDeclineReason($declineReason = null)
    {
        // validation for constraint: string
        if (!is_null($declineReason) && !is_string($declineReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declineReason, true), gettype($declineReason)), __LINE__);
        }
        if (is_null($declineReason) || (is_array($declineReason) && empty($declineReason))) {
            unset($this->DeclineReason);
        } else {
            $this->DeclineReason = $declineReason;
        }
        return $this;
    }
    /**
     * Get HandleTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHandleTime()
    {
        return isset($this->HandleTime) ? $this->HandleTime : null;
    }
    /**
     * Set HandleTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $handleTime
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setHandleTime($handleTime = null)
    {
        // validation for constraint: int
        if (!is_null($handleTime) && !(is_int($handleTime) || ctype_digit($handleTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($handleTime, true), gettype($handleTime)), __LINE__);
        }
        if (is_null($handleTime) || (is_array($handleTime) && empty($handleTime))) {
            unset($this->HandleTime);
        } else {
            $this->HandleTime = $handleTime;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OriginalGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Group|null
     */
    public function getOriginalGroup()
    {
        return isset($this->OriginalGroup) ? $this->OriginalGroup : null;
    }
    /**
     * Set OriginalGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Group $originalGroup
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setOriginalGroup(\NexusDigital/MiratelForce\StructType\Group $originalGroup = null)
    {
        if (is_null($originalGroup) || (is_array($originalGroup) && empty($originalGroup))) {
            unset($this->OriginalGroup);
        } else {
            $this->OriginalGroup = $originalGroup;
        }
        return $this;
    }
    /**
     * Get OriginalGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalGroupId()
    {
        return isset($this->OriginalGroupId) ? $this->OriginalGroupId : null;
    }
    /**
     * Set OriginalGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalGroupId
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setOriginalGroupId($originalGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($originalGroupId) && !is_string($originalGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalGroupId, true), gettype($originalGroupId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($originalGroupId) && mb_strlen($originalGroupId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($originalGroupId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($originalGroupId) && !preg_match('/[a-zA-Z0-9]{18}/', $originalGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($originalGroupId, true)), __LINE__);
        }
        if (is_null($originalGroupId) || (is_array($originalGroupId) && empty($originalGroupId))) {
            unset($this->OriginalGroupId);
        } else {
            $this->OriginalGroupId = $originalGroupId;
        }
        return $this;
    }
    /**
     * Get OriginalQueue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Group|null
     */
    public function getOriginalQueue()
    {
        return isset($this->OriginalQueue) ? $this->OriginalQueue : null;
    }
    /**
     * Set OriginalQueue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Group $originalQueue
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setOriginalQueue(\NexusDigital/MiratelForce\StructType\Group $originalQueue = null)
    {
        if (is_null($originalQueue) || (is_array($originalQueue) && empty($originalQueue))) {
            unset($this->OriginalQueue);
        } else {
            $this->OriginalQueue = $originalQueue;
        }
        return $this;
    }
    /**
     * Get OriginalQueueId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalQueueId()
    {
        return isset($this->OriginalQueueId) ? $this->OriginalQueueId : null;
    }
    /**
     * Set OriginalQueueId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalQueueId
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setOriginalQueueId($originalQueueId = null)
    {
        // validation for constraint: string
        if (!is_null($originalQueueId) && !is_string($originalQueueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalQueueId, true), gettype($originalQueueId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($originalQueueId) && mb_strlen($originalQueueId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($originalQueueId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($originalQueueId) && !preg_match('/[a-zA-Z0-9]{18}/', $originalQueueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($originalQueueId, true)), __LINE__);
        }
        if (is_null($originalQueueId) || (is_array($originalQueueId) && empty($originalQueueId))) {
            unset($this->OriginalQueueId);
        } else {
            $this->OriginalQueueId = $originalQueueId;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $owner
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setOwner(\NexusDigital/MiratelForce\StructType\SObject $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ownerId) && mb_strlen($ownerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ownerId) && !preg_match('/[a-zA-Z0-9]{18}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get PendingServiceRouting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\PendingServiceRouting|null
     */
    public function getPendingServiceRouting()
    {
        return isset($this->PendingServiceRouting) ? $this->PendingServiceRouting : null;
    }
    /**
     * Set PendingServiceRouting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\PendingServiceRouting $pendingServiceRouting
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setPendingServiceRouting(\NexusDigital/MiratelForce\StructType\PendingServiceRouting $pendingServiceRouting = null)
    {
        if (is_null($pendingServiceRouting) || (is_array($pendingServiceRouting) && empty($pendingServiceRouting))) {
            unset($this->PendingServiceRouting);
        } else {
            $this->PendingServiceRouting = $pendingServiceRouting;
        }
        return $this;
    }
    /**
     * Get PendingServiceRoutingId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPendingServiceRoutingId()
    {
        return isset($this->PendingServiceRoutingId) ? $this->PendingServiceRoutingId : null;
    }
    /**
     * Set PendingServiceRoutingId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pendingServiceRoutingId
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setPendingServiceRoutingId($pendingServiceRoutingId = null)
    {
        // validation for constraint: string
        if (!is_null($pendingServiceRoutingId) && !is_string($pendingServiceRoutingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pendingServiceRoutingId, true), gettype($pendingServiceRoutingId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($pendingServiceRoutingId) && mb_strlen($pendingServiceRoutingId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($pendingServiceRoutingId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($pendingServiceRoutingId) && !preg_match('/[a-zA-Z0-9]{18}/', $pendingServiceRoutingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($pendingServiceRoutingId, true)), __LINE__);
        }
        if (is_null($pendingServiceRoutingId) || (is_array($pendingServiceRoutingId) && empty($pendingServiceRoutingId))) {
            unset($this->PendingServiceRoutingId);
        } else {
            $this->PendingServiceRoutingId = $pendingServiceRoutingId;
        }
        return $this;
    }
    /**
     * Get PreferredUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getPreferredUser()
    {
        return isset($this->PreferredUser) ? $this->PreferredUser : null;
    }
    /**
     * Set PreferredUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $preferredUser
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setPreferredUser(\NexusDigital/MiratelForce\StructType\User $preferredUser = null)
    {
        if (is_null($preferredUser) || (is_array($preferredUser) && empty($preferredUser))) {
            unset($this->PreferredUser);
        } else {
            $this->PreferredUser = $preferredUser;
        }
        return $this;
    }
    /**
     * Get PreferredUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredUserId()
    {
        return isset($this->PreferredUserId) ? $this->PreferredUserId : null;
    }
    /**
     * Set PreferredUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredUserId
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setPreferredUserId($preferredUserId = null)
    {
        // validation for constraint: string
        if (!is_null($preferredUserId) && !is_string($preferredUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredUserId, true), gettype($preferredUserId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($preferredUserId) && mb_strlen($preferredUserId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($preferredUserId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($preferredUserId) && !preg_match('/[a-zA-Z0-9]{18}/', $preferredUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($preferredUserId, true)), __LINE__);
        }
        if (is_null($preferredUserId) || (is_array($preferredUserId) && empty($preferredUserId))) {
            unset($this->PreferredUserId);
        } else {
            $this->PreferredUserId = $preferredUserId;
        }
        return $this;
    }
    /**
     * Get PushTimeout value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPushTimeout()
    {
        return isset($this->PushTimeout) ? $this->PushTimeout : null;
    }
    /**
     * Set PushTimeout value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pushTimeout
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setPushTimeout($pushTimeout = null)
    {
        // validation for constraint: int
        if (!is_null($pushTimeout) && !(is_int($pushTimeout) || ctype_digit($pushTimeout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pushTimeout, true), gettype($pushTimeout)), __LINE__);
        }
        if (is_null($pushTimeout) || (is_array($pushTimeout) && empty($pushTimeout))) {
            unset($this->PushTimeout);
        } else {
            $this->PushTimeout = $pushTimeout;
        }
        return $this;
    }
    /**
     * Get PushTimeoutDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPushTimeoutDateTime()
    {
        return isset($this->PushTimeoutDateTime) ? $this->PushTimeoutDateTime : null;
    }
    /**
     * Set PushTimeoutDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pushTimeoutDateTime
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setPushTimeoutDateTime($pushTimeoutDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($pushTimeoutDateTime) && !is_string($pushTimeoutDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pushTimeoutDateTime, true), gettype($pushTimeoutDateTime)), __LINE__);
        }
        if (is_null($pushTimeoutDateTime) || (is_array($pushTimeoutDateTime) && empty($pushTimeoutDateTime))) {
            unset($this->PushTimeoutDateTime);
        } else {
            $this->PushTimeoutDateTime = $pushTimeoutDateTime;
        }
        return $this;
    }
    /**
     * Get RequestDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestDateTime()
    {
        return isset($this->RequestDateTime) ? $this->RequestDateTime : null;
    }
    /**
     * Set RequestDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestDateTime
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setRequestDateTime($requestDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($requestDateTime) && !is_string($requestDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestDateTime, true), gettype($requestDateTime)), __LINE__);
        }
        if (is_null($requestDateTime) || (is_array($requestDateTime) && empty($requestDateTime))) {
            unset($this->RequestDateTime);
        } else {
            $this->RequestDateTime = $requestDateTime;
        }
        return $this;
    }
    /**
     * Get RoutingModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoutingModel()
    {
        return isset($this->RoutingModel) ? $this->RoutingModel : null;
    }
    /**
     * Set RoutingModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routingModel
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setRoutingModel($routingModel = null)
    {
        // validation for constraint: string
        if (!is_null($routingModel) && !is_string($routingModel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routingModel, true), gettype($routingModel)), __LINE__);
        }
        if (is_null($routingModel) || (is_array($routingModel) && empty($routingModel))) {
            unset($this->RoutingModel);
        } else {
            $this->RoutingModel = $routingModel;
        }
        return $this;
    }
    /**
     * Get RoutingPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRoutingPriority()
    {
        return isset($this->RoutingPriority) ? $this->RoutingPriority : null;
    }
    /**
     * Set RoutingPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $routingPriority
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setRoutingPriority($routingPriority = null)
    {
        // validation for constraint: int
        if (!is_null($routingPriority) && !(is_int($routingPriority) || ctype_digit($routingPriority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($routingPriority, true), gettype($routingPriority)), __LINE__);
        }
        if (is_null($routingPriority) || (is_array($routingPriority) && empty($routingPriority))) {
            unset($this->RoutingPriority);
        } else {
            $this->RoutingPriority = $routingPriority;
        }
        return $this;
    }
    /**
     * Get RoutingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoutingType()
    {
        return isset($this->RoutingType) ? $this->RoutingType : null;
    }
    /**
     * Set RoutingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routingType
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setRoutingType($routingType = null)
    {
        // validation for constraint: string
        if (!is_null($routingType) && !is_string($routingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routingType, true), gettype($routingType)), __LINE__);
        }
        if (is_null($routingType) || (is_array($routingType) && empty($routingType))) {
            unset($this->RoutingType);
        } else {
            $this->RoutingType = $routingType;
        }
        return $this;
    }
    /**
     * Get ServiceChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ServiceChannel|null
     */
    public function getServiceChannel()
    {
        return isset($this->ServiceChannel) ? $this->ServiceChannel : null;
    }
    /**
     * Set ServiceChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ServiceChannel $serviceChannel
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setServiceChannel(\NexusDigital/MiratelForce\StructType\ServiceChannel $serviceChannel = null)
    {
        if (is_null($serviceChannel) || (is_array($serviceChannel) && empty($serviceChannel))) {
            unset($this->ServiceChannel);
        } else {
            $this->ServiceChannel = $serviceChannel;
        }
        return $this;
    }
    /**
     * Get ServiceChannelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceChannelId()
    {
        return isset($this->ServiceChannelId) ? $this->ServiceChannelId : null;
    }
    /**
     * Set ServiceChannelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceChannelId
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setServiceChannelId($serviceChannelId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceChannelId) && !is_string($serviceChannelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceChannelId, true), gettype($serviceChannelId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($serviceChannelId) && mb_strlen($serviceChannelId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($serviceChannelId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($serviceChannelId) && !preg_match('/[a-zA-Z0-9]{18}/', $serviceChannelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($serviceChannelId, true)), __LINE__);
        }
        if (is_null($serviceChannelId) || (is_array($serviceChannelId) && empty($serviceChannelId))) {
            unset($this->ServiceChannelId);
        } else {
            $this->ServiceChannelId = $serviceChannelId;
        }
        return $this;
    }
    /**
     * Get ShouldSkipCapacityCheck value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShouldSkipCapacityCheck()
    {
        return isset($this->ShouldSkipCapacityCheck) ? $this->ShouldSkipCapacityCheck : null;
    }
    /**
     * Set ShouldSkipCapacityCheck value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $shouldSkipCapacityCheck
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setShouldSkipCapacityCheck($shouldSkipCapacityCheck = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldSkipCapacityCheck) && !is_bool($shouldSkipCapacityCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldSkipCapacityCheck, true), gettype($shouldSkipCapacityCheck)), __LINE__);
        }
        if (is_null($shouldSkipCapacityCheck) || (is_array($shouldSkipCapacityCheck) && empty($shouldSkipCapacityCheck))) {
            unset($this->ShouldSkipCapacityCheck);
        } else {
            $this->ShouldSkipCapacityCheck = $shouldSkipCapacityCheck;
        }
        return $this;
    }
    /**
     * Get SpeedToAnswer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSpeedToAnswer()
    {
        return isset($this->SpeedToAnswer) ? $this->SpeedToAnswer : null;
    }
    /**
     * Set SpeedToAnswer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $speedToAnswer
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setSpeedToAnswer($speedToAnswer = null)
    {
        // validation for constraint: int
        if (!is_null($speedToAnswer) && !(is_int($speedToAnswer) || ctype_digit($speedToAnswer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($speedToAnswer, true), gettype($speedToAnswer)), __LINE__);
        }
        if (is_null($speedToAnswer) || (is_array($speedToAnswer) && empty($speedToAnswer))) {
            unset($this->SpeedToAnswer);
        } else {
            $this->SpeedToAnswer = $speedToAnswer;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setUser(\NexusDigital/MiratelForce\StructType\User $user = null)
    {
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userId) && mb_strlen($userId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userId) && !preg_match('/[a-zA-Z0-9]{18}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get UserRecordAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess|null
     */
    public function getUserRecordAccess()
    {
        return isset($this->UserRecordAccess) ? $this->UserRecordAccess : null;
    }
    /**
     * Set UserRecordAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setUserRecordAccess(\NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        if (is_null($userRecordAccess) || (is_array($userRecordAccess) && empty($userRecordAccess))) {
            unset($this->UserRecordAccess);
        } else {
            $this->UserRecordAccess = $userRecordAccess;
        }
        return $this;
    }
    /**
     * Get WorkItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\_Case|null
     */
    public function getWorkItem()
    {
        return isset($this->WorkItem) ? $this->WorkItem : null;
    }
    /**
     * Set WorkItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\_Case $workItem
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setWorkItem(\NexusDigital/MiratelForce\StructType\_Case $workItem = null)
    {
        if (is_null($workItem) || (is_array($workItem) && empty($workItem))) {
            unset($this->WorkItem);
        } else {
            $this->WorkItem = $workItem;
        }
        return $this;
    }
    /**
     * Get WorkItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkItemId()
    {
        return isset($this->WorkItemId) ? $this->WorkItemId : null;
    }
    /**
     * Set WorkItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $workItemId
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public function setWorkItemId($workItemId = null)
    {
        // validation for constraint: string
        if (!is_null($workItemId) && !is_string($workItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workItemId, true), gettype($workItemId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($workItemId) && mb_strlen($workItemId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($workItemId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($workItemId) && !preg_match('/[a-zA-Z0-9]{18}/', $workItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($workItemId, true)), __LINE__);
        }
        if (is_null($workItemId) || (is_array($workItemId) && empty($workItemId))) {
            unset($this->WorkItemId);
        } else {
            $this->WorkItemId = $workItemId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\AgentWork
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
