<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActionLinkTemplate StructType
 * @subpackage Structs
 */
class ActionLinkTemplate extends SObject
{
    /**
     * The ActionLinkGroupTemplate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ActionLinkGroupTemplate
     */
    public $ActionLinkGroupTemplate;
    /**
     * The ActionLinkGroupTemplateId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ActionLinkGroupTemplateId;
    /**
     * The ActionUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionUrl;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The Headers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Headers;
    /**
     * The IsConfirmationRequired
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsConfirmationRequired;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsGroupDefault
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGroupDefault;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * The LabelKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LabelKey;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LinkType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LinkType;
    /**
     * The Method
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Method;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Position;
    /**
     * The RequestBody
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestBody;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The UserAlias
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserAlias;
    /**
     * The UserVisibility
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserVisibility;
    /**
     * Constructor method for ActionLinkTemplate
     * @uses ActionLinkTemplate::setActionLinkGroupTemplate()
     * @uses ActionLinkTemplate::setActionLinkGroupTemplateId()
     * @uses ActionLinkTemplate::setActionUrl()
     * @uses ActionLinkTemplate::setCreatedBy()
     * @uses ActionLinkTemplate::setCreatedById()
     * @uses ActionLinkTemplate::setCreatedDate()
     * @uses ActionLinkTemplate::setHeaders()
     * @uses ActionLinkTemplate::setIsConfirmationRequired()
     * @uses ActionLinkTemplate::setIsDeleted()
     * @uses ActionLinkTemplate::setIsGroupDefault()
     * @uses ActionLinkTemplate::setLabel()
     * @uses ActionLinkTemplate::setLabelKey()
     * @uses ActionLinkTemplate::setLastModifiedBy()
     * @uses ActionLinkTemplate::setLastModifiedById()
     * @uses ActionLinkTemplate::setLastModifiedDate()
     * @uses ActionLinkTemplate::setLinkType()
     * @uses ActionLinkTemplate::setMethod()
     * @uses ActionLinkTemplate::setPosition()
     * @uses ActionLinkTemplate::setRequestBody()
     * @uses ActionLinkTemplate::setSystemModstamp()
     * @uses ActionLinkTemplate::setUserAlias()
     * @uses ActionLinkTemplate::setUserVisibility()
     * @param \NexusDigital/MiratelForce\StructType\ActionLinkGroupTemplate $actionLinkGroupTemplate
     * @param string $actionLinkGroupTemplateId
     * @param string $actionUrl
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $headers
     * @param bool $isConfirmationRequired
     * @param bool $isDeleted
     * @param bool $isGroupDefault
     * @param string $label
     * @param string $labelKey
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $linkType
     * @param string $method
     * @param int $position
     * @param string $requestBody
     * @param string $systemModstamp
     * @param string $userAlias
     * @param string $userVisibility
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\ActionLinkGroupTemplate $actionLinkGroupTemplate = null, $actionLinkGroupTemplateId = null, $actionUrl = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $headers = null, $isConfirmationRequired = null, $isDeleted = null, $isGroupDefault = null, $label = null, $labelKey = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $linkType = null, $method = null, $position = null, $requestBody = null, $systemModstamp = null, $userAlias = null, $userVisibility = null)
    {
        $this
            ->setActionLinkGroupTemplate($actionLinkGroupTemplate)
            ->setActionLinkGroupTemplateId($actionLinkGroupTemplateId)
            ->setActionUrl($actionUrl)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setHeaders($headers)
            ->setIsConfirmationRequired($isConfirmationRequired)
            ->setIsDeleted($isDeleted)
            ->setIsGroupDefault($isGroupDefault)
            ->setLabel($label)
            ->setLabelKey($labelKey)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLinkType($linkType)
            ->setMethod($method)
            ->setPosition($position)
            ->setRequestBody($requestBody)
            ->setSystemModstamp($systemModstamp)
            ->setUserAlias($userAlias)
            ->setUserVisibility($userVisibility);
    }
    /**
     * Get ActionLinkGroupTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkGroupTemplate|null
     */
    public function getActionLinkGroupTemplate()
    {
        return isset($this->ActionLinkGroupTemplate) ? $this->ActionLinkGroupTemplate : null;
    }
    /**
     * Set ActionLinkGroupTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ActionLinkGroupTemplate $actionLinkGroupTemplate
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setActionLinkGroupTemplate(\NexusDigital/MiratelForce\StructType\ActionLinkGroupTemplate $actionLinkGroupTemplate = null)
    {
        if (is_null($actionLinkGroupTemplate) || (is_array($actionLinkGroupTemplate) && empty($actionLinkGroupTemplate))) {
            unset($this->ActionLinkGroupTemplate);
        } else {
            $this->ActionLinkGroupTemplate = $actionLinkGroupTemplate;
        }
        return $this;
    }
    /**
     * Get ActionLinkGroupTemplateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionLinkGroupTemplateId()
    {
        return isset($this->ActionLinkGroupTemplateId) ? $this->ActionLinkGroupTemplateId : null;
    }
    /**
     * Set ActionLinkGroupTemplateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionLinkGroupTemplateId
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setActionLinkGroupTemplateId($actionLinkGroupTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($actionLinkGroupTemplateId) && !is_string($actionLinkGroupTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionLinkGroupTemplateId, true), gettype($actionLinkGroupTemplateId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($actionLinkGroupTemplateId) && mb_strlen($actionLinkGroupTemplateId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($actionLinkGroupTemplateId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($actionLinkGroupTemplateId) && !preg_match('/[a-zA-Z0-9]{18}/', $actionLinkGroupTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($actionLinkGroupTemplateId, true)), __LINE__);
        }
        if (is_null($actionLinkGroupTemplateId) || (is_array($actionLinkGroupTemplateId) && empty($actionLinkGroupTemplateId))) {
            unset($this->ActionLinkGroupTemplateId);
        } else {
            $this->ActionLinkGroupTemplateId = $actionLinkGroupTemplateId;
        }
        return $this;
    }
    /**
     * Get ActionUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionUrl()
    {
        return isset($this->ActionUrl) ? $this->ActionUrl : null;
    }
    /**
     * Set ActionUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionUrl
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setActionUrl($actionUrl = null)
    {
        // validation for constraint: string
        if (!is_null($actionUrl) && !is_string($actionUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionUrl, true), gettype($actionUrl)), __LINE__);
        }
        if (is_null($actionUrl) || (is_array($actionUrl) && empty($actionUrl))) {
            unset($this->ActionUrl);
        } else {
            $this->ActionUrl = $actionUrl;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get Headers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHeaders()
    {
        return isset($this->Headers) ? $this->Headers : null;
    }
    /**
     * Set Headers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $headers
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setHeaders($headers = null)
    {
        // validation for constraint: string
        if (!is_null($headers) && !is_string($headers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($headers, true), gettype($headers)), __LINE__);
        }
        if (is_null($headers) || (is_array($headers) && empty($headers))) {
            unset($this->Headers);
        } else {
            $this->Headers = $headers;
        }
        return $this;
    }
    /**
     * Get IsConfirmationRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsConfirmationRequired()
    {
        return isset($this->IsConfirmationRequired) ? $this->IsConfirmationRequired : null;
    }
    /**
     * Set IsConfirmationRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isConfirmationRequired
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setIsConfirmationRequired($isConfirmationRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConfirmationRequired) && !is_bool($isConfirmationRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConfirmationRequired, true), gettype($isConfirmationRequired)), __LINE__);
        }
        if (is_null($isConfirmationRequired) || (is_array($isConfirmationRequired) && empty($isConfirmationRequired))) {
            unset($this->IsConfirmationRequired);
        } else {
            $this->IsConfirmationRequired = $isConfirmationRequired;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsGroupDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGroupDefault()
    {
        return isset($this->IsGroupDefault) ? $this->IsGroupDefault : null;
    }
    /**
     * Set IsGroupDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGroupDefault
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setIsGroupDefault($isGroupDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGroupDefault) && !is_bool($isGroupDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGroupDefault, true), gettype($isGroupDefault)), __LINE__);
        }
        if (is_null($isGroupDefault) || (is_array($isGroupDefault) && empty($isGroupDefault))) {
            unset($this->IsGroupDefault);
        } else {
            $this->IsGroupDefault = $isGroupDefault;
        }
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
    /**
     * Get LabelKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabelKey()
    {
        return isset($this->LabelKey) ? $this->LabelKey : null;
    }
    /**
     * Set LabelKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $labelKey
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setLabelKey($labelKey = null)
    {
        // validation for constraint: string
        if (!is_null($labelKey) && !is_string($labelKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelKey, true), gettype($labelKey)), __LINE__);
        }
        if (is_null($labelKey) || (is_array($labelKey) && empty($labelKey))) {
            unset($this->LabelKey);
        } else {
            $this->LabelKey = $labelKey;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LinkType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkType()
    {
        return isset($this->LinkType) ? $this->LinkType : null;
    }
    /**
     * Set LinkType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkType
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setLinkType($linkType = null)
    {
        // validation for constraint: string
        if (!is_null($linkType) && !is_string($linkType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkType, true), gettype($linkType)), __LINE__);
        }
        if (is_null($linkType) || (is_array($linkType) && empty($linkType))) {
            unset($this->LinkType);
        } else {
            $this->LinkType = $linkType;
        }
        return $this;
    }
    /**
     * Get Method value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMethod()
    {
        return isset($this->Method) ? $this->Method : null;
    }
    /**
     * Set Method value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $method
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setMethod($method = null)
    {
        // validation for constraint: string
        if (!is_null($method) && !is_string($method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($method, true), gettype($method)), __LINE__);
        }
        if (is_null($method) || (is_array($method) && empty($method))) {
            unset($this->Method);
        } else {
            $this->Method = $method;
        }
        return $this;
    }
    /**
     * Get Position value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPosition()
    {
        return isset($this->Position) ? $this->Position : null;
    }
    /**
     * Set Position value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $position
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setPosition($position = null)
    {
        // validation for constraint: int
        if (!is_null($position) && !(is_int($position) || ctype_digit($position))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($position, true), gettype($position)), __LINE__);
        }
        if (is_null($position) || (is_array($position) && empty($position))) {
            unset($this->Position);
        } else {
            $this->Position = $position;
        }
        return $this;
    }
    /**
     * Get RequestBody value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestBody()
    {
        return isset($this->RequestBody) ? $this->RequestBody : null;
    }
    /**
     * Set RequestBody value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestBody
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setRequestBody($requestBody = null)
    {
        // validation for constraint: string
        if (!is_null($requestBody) && !is_string($requestBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestBody, true), gettype($requestBody)), __LINE__);
        }
        if (is_null($requestBody) || (is_array($requestBody) && empty($requestBody))) {
            unset($this->RequestBody);
        } else {
            $this->RequestBody = $requestBody;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get UserAlias value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserAlias()
    {
        return isset($this->UserAlias) ? $this->UserAlias : null;
    }
    /**
     * Set UserAlias value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userAlias
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setUserAlias($userAlias = null)
    {
        // validation for constraint: string
        if (!is_null($userAlias) && !is_string($userAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userAlias, true), gettype($userAlias)), __LINE__);
        }
        if (is_null($userAlias) || (is_array($userAlias) && empty($userAlias))) {
            unset($this->UserAlias);
        } else {
            $this->UserAlias = $userAlias;
        }
        return $this;
    }
    /**
     * Get UserVisibility value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserVisibility()
    {
        return isset($this->UserVisibility) ? $this->UserVisibility : null;
    }
    /**
     * Set UserVisibility value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userVisibility
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public function setUserVisibility($userVisibility = null)
    {
        // validation for constraint: string
        if (!is_null($userVisibility) && !is_string($userVisibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userVisibility, true), gettype($userVisibility)), __LINE__);
        }
        if (is_null($userVisibility) || (is_array($userVisibility) && empty($userVisibility))) {
            unset($this->UserVisibility);
        } else {
            $this->UserVisibility = $userVisibility;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ActionLinkTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
