<?php

namespace NexusDigital/MiratelForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeader(\NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeader', $sessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named setPassword
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader
     * - SOAPHeaders: required
     * - documentation: Set a user's password
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\SetPassword $parameters
     * @return \NexusDigital/MiratelForce\StructType\SetPasswordResponse|bool
     */
    public function setPassword(\NexusDigital/MiratelForce\StructType\SetPassword $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->setPassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \NexusDigital/MiratelForce\StructType\SetPasswordResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
