<?php

namespace NexusDigital/MiratelForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Login ServiceType
 * @subpackage Services
 */
class Login extends AbstractSoapClientBase
{
    /**
     * Sets the LoginScopeHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\LoginScopeHeader $loginScopeHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderLoginScopeHeader(\NexusDigital/MiratelForce\StructType\LoginScopeHeader $loginScopeHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'LoginScopeHeader', $loginScopeHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named login
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: LoginScopeHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\LoginScopeHeader
     * - SOAPHeaders: required
     * - documentation: Login to the Salesforce.com SOAP Api
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\Login $parameters
     * @return \NexusDigital/MiratelForce\StructType\LoginResponse|bool
     */
    public function login(\NexusDigital/MiratelForce\StructType\Login $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->login($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \NexusDigital/MiratelForce\StructType\LoginResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
