<?php

namespace NexusDigital/MiratelForce\EnumType;

/**
 * This class stands for ExtendedErrorCode EnumType
 * @subpackage Enumerations
 */
class ExtendedErrorCode
{
    /**
     * Constant for value 'ACTIONCALL_DUPLICATE_INPUT_PARAM'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, actionCallName, parameterName
     * @return string 'ACTIONCALL_DUPLICATE_INPUT_PARAM'
     */
    const VALUE_ACTIONCALL_DUPLICATE_INPUT_PARAM = 'ACTIONCALL_DUPLICATE_INPUT_PARAM';
    /**
     * Constant for value 'ACTIONCALL_DUPLICATE_OUTPUT_PARAM'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, actionCallName, parameterName
     * @return string 'ACTIONCALL_DUPLICATE_OUTPUT_PARAM'
     */
    const VALUE_ACTIONCALL_DUPLICATE_OUTPUT_PARAM = 'ACTIONCALL_DUPLICATE_OUTPUT_PARAM';
    /**
     * Constant for value 'ACTIONCALL_MISSING_NAME'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'ACTIONCALL_MISSING_NAME'
     */
    const VALUE_ACTIONCALL_MISSING_NAME = 'ACTIONCALL_MISSING_NAME';
    /**
     * Constant for value 'ACTIONCALL_MISSING_REQUIRED_PARAM'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, actionCallName, parameterName
     * @return string 'ACTIONCALL_MISSING_REQUIRED_PARAM'
     */
    const VALUE_ACTIONCALL_MISSING_REQUIRED_PARAM = 'ACTIONCALL_MISSING_REQUIRED_PARAM';
    /**
     * Constant for value 'ACTIONCALL_MISSING_REQUIRED_TYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, actionCallName
     * @return string 'ACTIONCALL_MISSING_REQUIRED_TYPE'
     */
    const VALUE_ACTIONCALL_MISSING_REQUIRED_TYPE = 'ACTIONCALL_MISSING_REQUIRED_TYPE';
    /**
     * Constant for value 'ACTIONCALL_NOT_FOUND_WITH_NAME_AND_TYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'ACTIONCALL_NOT_FOUND_WITH_NAME_AND_TYPE'
     */
    const VALUE_ACTIONCALL_NOT_FOUND_WITH_NAME_AND_TYPE = 'ACTIONCALL_NOT_FOUND_WITH_NAME_AND_TYPE';
    /**
     * Constant for value 'ACTIONCALL_NOT_SUPPORTED_FOR_PROCESSTYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, processType
     * @return string 'ACTIONCALL_NOT_SUPPORTED_FOR_PROCESSTYPE'
     */
    const VALUE_ACTIONCALL_NOT_SUPPORTED_FOR_PROCESSTYPE = 'ACTIONCALL_NOT_SUPPORTED_FOR_PROCESSTYPE';
    /**
     * Constant for value 'APEXCALLOUT_INPUT_DUPLICATE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, apexClassName, parameterName
     * @return string 'APEXCALLOUT_INPUT_DUPLICATE'
     */
    const VALUE_APEXCALLOUT_INPUT_DUPLICATE = 'APEXCALLOUT_INPUT_DUPLICATE';
    /**
     * Constant for value 'APEXCALLOUT_INPUT_INCOMPATIBLE_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, apexClassName, parameterName
     * @return string 'APEXCALLOUT_INPUT_INCOMPATIBLE_DATATYPE'
     */
    const VALUE_APEXCALLOUT_INPUT_INCOMPATIBLE_DATATYPE = 'APEXCALLOUT_INPUT_INCOMPATIBLE_DATATYPE';
    /**
     * Constant for value 'APEXCALLOUT_INVALID'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, apexClassName
     * @return string 'APEXCALLOUT_INVALID'
     */
    const VALUE_APEXCALLOUT_INVALID = 'APEXCALLOUT_INVALID';
    /**
     * Constant for value 'APEXCALLOUT_MISSING_CLASSNAME'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, apexClassName
     * @return string 'APEXCALLOUT_MISSING_CLASSNAME'
     */
    const VALUE_APEXCALLOUT_MISSING_CLASSNAME = 'APEXCALLOUT_MISSING_CLASSNAME';
    /**
     * Constant for value 'APEXCALLOUT_NOT_FOUND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, apexClassName
     * @return string 'APEXCALLOUT_NOT_FOUND'
     */
    const VALUE_APEXCALLOUT_NOT_FOUND = 'APEXCALLOUT_NOT_FOUND';
    /**
     * Constant for value 'APEXCALLOUT_OUTPUT_INCOMPATIBLE_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, apexClassName, parameterName
     * @return string 'APEXCALLOUT_OUTPUT_INCOMPATIBLE_DATATYPE'
     */
    const VALUE_APEXCALLOUT_OUTPUT_INCOMPATIBLE_DATATYPE = 'APEXCALLOUT_OUTPUT_INCOMPATIBLE_DATATYPE';
    /**
     * Constant for value 'APEXCALLOUT_OUTPUT_NOT_FOUND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, apexClassName, parameterName
     * @return string 'APEXCALLOUT_OUTPUT_NOT_FOUND'
     */
    const VALUE_APEXCALLOUT_OUTPUT_NOT_FOUND = 'APEXCALLOUT_OUTPUT_NOT_FOUND';
    /**
     * Constant for value 'APEXCALLOUT_REQUIRED_INPUT_MISSING'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, apexClassName, parameterName
     * @return string 'APEXCALLOUT_REQUIRED_INPUT_MISSING'
     */
    const VALUE_APEXCALLOUT_REQUIRED_INPUT_MISSING = 'APEXCALLOUT_REQUIRED_INPUT_MISSING';
    /**
     * Constant for value 'APEXCLASS_MISSING_INTERFACE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, apexClassName, parentScreenFieldName
     * @return string 'APEXCLASS_MISSING_INTERFACE'
     */
    const VALUE_APEXCLASS_MISSING_INTERFACE = 'APEXCLASS_MISSING_INTERFACE';
    /**
     * Constant for value 'APEX_CLASS_VARIABLE_NOT_FOUND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, apexClass
     * @return string 'APEX_CLASS_VARIABLE_NOT_FOUND'
     */
    const VALUE_APEX_CLASS_VARIABLE_NOT_FOUND = 'APEX_CLASS_VARIABLE_NOT_FOUND';
    /**
     * Constant for value 'ASSIGNMENTITEM_ELEMENT_MISSING_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, assignmentName, operatorName, elementName
     * @return string 'ASSIGNMENTITEM_ELEMENT_MISSING_DATATYPE'
     */
    const VALUE_ASSIGNMENTITEM_ELEMENT_MISSING_DATATYPE = 'ASSIGNMENTITEM_ELEMENT_MISSING_DATATYPE';
    /**
     * Constant for value 'ASSIGNMENTITEM_ELEMENT_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, assignmentName, elementType
     * @return string 'ASSIGNMENTITEM_ELEMENT_NOT_SUPPORTED'
     */
    const VALUE_ASSIGNMENTITEM_ELEMENT_NOT_SUPPORTED = 'ASSIGNMENTITEM_ELEMENT_NOT_SUPPORTED';
    /**
     * Constant for value 'ASSIGNMENTITEM_FIELD_INVALID_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldValue, dataType, incompatibleDataType
     * @return string 'ASSIGNMENTITEM_FIELD_INVALID_DATATYPE'
     */
    const VALUE_ASSIGNMENTITEM_FIELD_INVALID_DATATYPE = 'ASSIGNMENTITEM_FIELD_INVALID_DATATYPE';
    /**
     * Constant for value 'ASSIGNMENTITEM_FIELD_INVALID_DATATYPE_WITH_ELEMENT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, acceptedDataType, dataType, fieldValue
     * @return string 'ASSIGNMENTITEM_FIELD_INVALID_DATATYPE_WITH_ELEMENT'
     */
    const VALUE_ASSIGNMENTITEM_FIELD_INVALID_DATATYPE_WITH_ELEMENT = 'ASSIGNMENTITEM_FIELD_INVALID_DATATYPE_WITH_ELEMENT';
    /**
     * Constant for value 'ASSIGNMENTITEM_INCOMPATIBLE_DATATYPES'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, assignmentName, operatorName, leftElementName, leftElementType, rightElementName, rightElementType
     * @return string 'ASSIGNMENTITEM_INCOMPATIBLE_DATATYPES'
     */
    const VALUE_ASSIGNMENTITEM_INCOMPATIBLE_DATATYPES = 'ASSIGNMENTITEM_INCOMPATIBLE_DATATYPES';
    /**
     * Constant for value 'ASSIGNMENTITEM_INVALID_ASSIGNTOREFERENCE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, assignmentName
     * @return string 'ASSIGNMENTITEM_INVALID_ASSIGNTOREFERENCE'
     */
    const VALUE_ASSIGNMENTITEM_INVALID_ASSIGNTOREFERENCE = 'ASSIGNMENTITEM_INVALID_ASSIGNTOREFERENCE';
    /**
     * Constant for value 'ASSIGNMENTITEM_INVALID_COLLECTION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, assignmentName, operatorName, leftElementName, rightElementName
     * @return string 'ASSIGNMENTITEM_INVALID_COLLECTION'
     */
    const VALUE_ASSIGNMENTITEM_INVALID_COLLECTION = 'ASSIGNMENTITEM_INVALID_COLLECTION';
    /**
     * Constant for value 'ASSIGNMENTITEM_INVALID_DATATYPE_IN_ELEMENT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, dataType, incompatibleDataType
     * @return string 'ASSIGNMENTITEM_INVALID_DATATYPE_IN_ELEMENT'
     */
    const VALUE_ASSIGNMENTITEM_INVALID_DATATYPE_IN_ELEMENT = 'ASSIGNMENTITEM_INVALID_DATATYPE_IN_ELEMENT';
    /**
     * Constant for value 'ASSIGNMENTITEM_INVALID_ELEMENTREFERENCE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, assignmentName
     * @return string 'ASSIGNMENTITEM_INVALID_ELEMENTREFERENCE'
     */
    const VALUE_ASSIGNMENTITEM_INVALID_ELEMENTREFERENCE = 'ASSIGNMENTITEM_INVALID_ELEMENTREFERENCE';
    /**
     * Constant for value 'ASSIGNMENTITEM_INVALID_MERGE_FIELD'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, parameterName, operatorName
     * @return string 'ASSIGNMENTITEM_INVALID_MERGE_FIELD'
     */
    const VALUE_ASSIGNMENTITEM_INVALID_MERGE_FIELD = 'ASSIGNMENTITEM_INVALID_MERGE_FIELD';
    /**
     * Constant for value 'ASSIGNMENTITEM_INVALID_OPERATOR'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, assignmentName
     * @return string 'ASSIGNMENTITEM_INVALID_OPERATOR'
     */
    const VALUE_ASSIGNMENTITEM_INVALID_OPERATOR = 'ASSIGNMENTITEM_INVALID_OPERATOR';
    /**
     * Constant for value 'ASSIGNMENTITEM_INVALID_REFERENCE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, parameterName, operatorName
     * @return string 'ASSIGNMENTITEM_INVALID_REFERENCE'
     */
    const VALUE_ASSIGNMENTITEM_INVALID_REFERENCE = 'ASSIGNMENTITEM_INVALID_REFERENCE';
    /**
     * Constant for value 'ASSIGNMENTITEM_INVALID_VALUE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, assignmentName
     * @return string 'ASSIGNMENTITEM_INVALID_VALUE'
     */
    const VALUE_ASSIGNMENTITEM_INVALID_VALUE = 'ASSIGNMENTITEM_INVALID_VALUE';
    /**
     * Constant for value 'ASSIGNMENTITEM_LEFT_DATATYPE_INVALID_FOR_OPERATOR'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, assignmentName, operatorName, dataType, elementName
     * @return string 'ASSIGNMENTITEM_LEFT_DATATYPE_INVALID_FOR_OPERATOR'
     */
    const VALUE_ASSIGNMENTITEM_LEFT_DATATYPE_INVALID_FOR_OPERATOR = 'ASSIGNMENTITEM_LEFT_DATATYPE_INVALID_FOR_OPERATOR';
    /**
     * Constant for value 'ASSIGNMENTITEM_MODIFIES_NONVARIABLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, assignmentName
     * @return string 'ASSIGNMENTITEM_MODIFIES_NONVARIABLE'
     */
    const VALUE_ASSIGNMENTITEM_MODIFIES_NONVARIABLE = 'ASSIGNMENTITEM_MODIFIES_NONVARIABLE';
    /**
     * Constant for value 'ASSIGNMENTITEM_NONEXISTENT_REFERENCE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, parameterName, operatorName
     * @return string 'ASSIGNMENTITEM_NONEXISTENT_REFERENCE'
     */
    const VALUE_ASSIGNMENTITEM_NONEXISTENT_REFERENCE = 'ASSIGNMENTITEM_NONEXISTENT_REFERENCE';
    /**
     * Constant for value 'ASSIGNMENTITEM_REQUIRED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, assignmentName
     * @return string 'ASSIGNMENTITEM_REQUIRED'
     */
    const VALUE_ASSIGNMENTITEM_REQUIRED = 'ASSIGNMENTITEM_REQUIRED';
    /**
     * Constant for value 'ASSIGNMENTITEM_RIGHT_DATATYPE_INVALID_FOR_OPERATOR'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'ASSIGNMENTITEM_RIGHT_DATATYPE_INVALID_FOR_OPERATOR'
     */
    const VALUE_ASSIGNMENTITEM_RIGHT_DATATYPE_INVALID_FOR_OPERATOR = 'ASSIGNMENTITEM_RIGHT_DATATYPE_INVALID_FOR_OPERATOR';
    /**
     * Constant for value 'AUTOLAUNCHED_CHOICELOOKUP_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, choiceLookupName
     * @return string 'AUTOLAUNCHED_CHOICELOOKUP_NOT_SUPPORTED'
     */
    const VALUE_AUTOLAUNCHED_CHOICELOOKUP_NOT_SUPPORTED = 'AUTOLAUNCHED_CHOICELOOKUP_NOT_SUPPORTED';
    /**
     * Constant for value 'AUTOLAUNCHED_CHOICE_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, choiceName
     * @return string 'AUTOLAUNCHED_CHOICE_NOT_SUPPORTED'
     */
    const VALUE_AUTOLAUNCHED_CHOICE_NOT_SUPPORTED = 'AUTOLAUNCHED_CHOICE_NOT_SUPPORTED';
    /**
     * Constant for value 'AUTOLAUNCHED_SCREEN_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'AUTOLAUNCHED_SCREEN_NOT_SUPPORTED'
     */
    const VALUE_AUTOLAUNCHED_SCREEN_NOT_SUPPORTED = 'AUTOLAUNCHED_SCREEN_NOT_SUPPORTED';
    /**
     * Constant for value 'AUTOLAUNCHED_STEP_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'AUTOLAUNCHED_STEP_NOT_SUPPORTED'
     */
    const VALUE_AUTOLAUNCHED_STEP_NOT_SUPPORTED = 'AUTOLAUNCHED_STEP_NOT_SUPPORTED';
    /**
     * Constant for value 'AUTOLAUNCHED_SUBFLOW_INCOMPATIBLE_FLOWTYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowType
     * @return string 'AUTOLAUNCHED_SUBFLOW_INCOMPATIBLE_FLOWTYPE'
     */
    const VALUE_AUTOLAUNCHED_SUBFLOW_INCOMPATIBLE_FLOWTYPE = 'AUTOLAUNCHED_SUBFLOW_INCOMPATIBLE_FLOWTYPE';
    /**
     * Constant for value 'AUTOLAUNCHED_WAIT_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'AUTOLAUNCHED_WAIT_NOT_SUPPORTED'
     */
    const VALUE_AUTOLAUNCHED_WAIT_NOT_SUPPORTED = 'AUTOLAUNCHED_WAIT_NOT_SUPPORTED';
    /**
     * Constant for value 'CHOICEFIELD_DEFAULT_CHOICE_NOT_FOUND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, screenFieldName
     * @return string 'CHOICEFIELD_DEFAULT_CHOICE_NOT_FOUND'
     */
    const VALUE_CHOICEFIELD_DEFAULT_CHOICE_NOT_FOUND = 'CHOICEFIELD_DEFAULT_CHOICE_NOT_FOUND';
    /**
     * Constant for value 'CHOICEFIELD_MISSING_CHOICE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, questionName
     * @return string 'CHOICEFIELD_MISSING_CHOICE'
     */
    const VALUE_CHOICEFIELD_MISSING_CHOICE = 'CHOICEFIELD_MISSING_CHOICE';
    /**
     * Constant for value 'CHOICELOOKUP_DATATYPE_INCOMPATIBLE_WITH_CHOICEFIELD'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, choiceName, parentScreenFieldName
     * @return string 'CHOICELOOKUP_DATATYPE_INCOMPATIBLE_WITH_CHOICEFIELD'
     */
    const VALUE_CHOICELOOKUP_DATATYPE_INCOMPATIBLE_WITH_CHOICEFIELD = 'CHOICELOOKUP_DATATYPE_INCOMPATIBLE_WITH_CHOICEFIELD';
    /**
     * Constant for value 'CHOICE_DATATYPE_INCOMPATIBLE_WITH_CHOICEFIELD'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, choiceName, parentScreenFieldName
     * @return string 'CHOICE_DATATYPE_INCOMPATIBLE_WITH_CHOICEFIELD'
     */
    const VALUE_CHOICE_DATATYPE_INCOMPATIBLE_WITH_CHOICEFIELD = 'CHOICE_DATATYPE_INCOMPATIBLE_WITH_CHOICEFIELD';
    /**
     * Constant for value 'CHOICE_NOT_SUPPORTED_FOR_SCREENFIELDTYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, screenFieldName
     * @return string 'CHOICE_NOT_SUPPORTED_FOR_SCREENFIELDTYPE'
     */
    const VALUE_CHOICE_NOT_SUPPORTED_FOR_SCREENFIELDTYPE = 'CHOICE_NOT_SUPPORTED_FOR_SCREENFIELDTYPE';
    /**
     * Constant for value 'CHOICE_USED_MULTIPLE_TIMES_IN_SAME_FIELD'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, choiceName
     * @return string 'CHOICE_USED_MULTIPLE_TIMES_IN_SAME_FIELD'
     */
    const VALUE_CHOICE_USED_MULTIPLE_TIMES_IN_SAME_FIELD = 'CHOICE_USED_MULTIPLE_TIMES_IN_SAME_FIELD';
    /**
     * Constant for value 'CONDITION_BUILDER_MISSING_FLOW_VARIABLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'CONDITION_BUILDER_MISSING_FLOW_VARIABLE'
     */
    const VALUE_CONDITION_BUILDER_MISSING_FLOW_VARIABLE = 'CONDITION_BUILDER_MISSING_FLOW_VARIABLE';
    /**
     * Constant for value 'CONDITION_BUILDER_MISSING_REQUIRED_PERMISSIONS'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'CONDITION_BUILDER_MISSING_REQUIRED_PERMISSIONS'
     */
    const VALUE_CONDITION_BUILDER_MISSING_REQUIRED_PERMISSIONS = 'CONDITION_BUILDER_MISSING_REQUIRED_PERMISSIONS';
    /**
     * Constant for value 'CONDITION_BUILDER_UNSUPPORTED_FLOW_VARIABLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'CONDITION_BUILDER_UNSUPPORTED_FLOW_VARIABLE'
     */
    const VALUE_CONDITION_BUILDER_UNSUPPORTED_FLOW_VARIABLE = 'CONDITION_BUILDER_UNSUPPORTED_FLOW_VARIABLE';
    /**
     * Constant for value 'CONDITION_DATATYPE_INCOMPATIBLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, leftElementName, leftElementType, operatorName, rightElementName, rightElementType, ruleName
     * @return string 'CONDITION_DATATYPE_INCOMPATIBLE'
     */
    const VALUE_CONDITION_DATATYPE_INCOMPATIBLE = 'CONDITION_DATATYPE_INCOMPATIBLE';
    /**
     * Constant for value 'CONDITION_DATATYPE_INCOMPATIBLE_WITH_ELEMENT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, dataType, operatorName, parameterName, ruleName
     * @return string 'CONDITION_DATATYPE_INCOMPATIBLE_WITH_ELEMENT'
     */
    const VALUE_CONDITION_DATATYPE_INCOMPATIBLE_WITH_ELEMENT = 'CONDITION_DATATYPE_INCOMPATIBLE_WITH_ELEMENT';
    /**
     * Constant for value 'CONDITION_ELEMENT_DATATYPES_INCOMPATIBLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, leftElementType, operatorName, rightElementType, ruleName
     * @return string 'CONDITION_ELEMENT_DATATYPES_INCOMPATIBLE'
     */
    const VALUE_CONDITION_ELEMENT_DATATYPES_INCOMPATIBLE = 'CONDITION_ELEMENT_DATATYPES_INCOMPATIBLE';
    /**
     * Constant for value 'CONDITION_INVALID_LEFTOPERAND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, ruleName
     * @return string 'CONDITION_INVALID_LEFTOPERAND'
     */
    const VALUE_CONDITION_INVALID_LEFTOPERAND = 'CONDITION_INVALID_LEFTOPERAND';
    /**
     * Constant for value 'CONDITION_INVALID_LEFT_ELEMENT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, dataType, operatorName, parameterName, ruleName
     * @return string 'CONDITION_INVALID_LEFT_ELEMENT'
     */
    const VALUE_CONDITION_INVALID_LEFT_ELEMENT = 'CONDITION_INVALID_LEFT_ELEMENT';
    /**
     * Constant for value 'CONDITION_LOGIC_EXCEEDS_LIMIT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, characterLimit
     * @return string 'CONDITION_LOGIC_EXCEEDS_LIMIT'
     */
    const VALUE_CONDITION_LOGIC_EXCEEDS_LIMIT = 'CONDITION_LOGIC_EXCEEDS_LIMIT';
    /**
     * Constant for value 'CONDITION_LOGIC_INVALID'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'CONDITION_LOGIC_INVALID'
     */
    const VALUE_CONDITION_LOGIC_INVALID = 'CONDITION_LOGIC_INVALID';
    /**
     * Constant for value 'CONDITION_LOGIC_MISSING'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'CONDITION_LOGIC_MISSING'
     */
    const VALUE_CONDITION_LOGIC_MISSING = 'CONDITION_LOGIC_MISSING';
    /**
     * Constant for value 'CONDITION_MISSING_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, dataType, operatorName, parameterName, ruleName
     * @return string 'CONDITION_MISSING_DATATYPE'
     */
    const VALUE_CONDITION_MISSING_DATATYPE = 'CONDITION_MISSING_DATATYPE';
    /**
     * Constant for value 'CONDITION_MISSING_OPERATOR'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, ruleName
     * @return string 'CONDITION_MISSING_OPERATOR'
     */
    const VALUE_CONDITION_MISSING_OPERATOR = 'CONDITION_MISSING_OPERATOR';
    /**
     * Constant for value 'CONDITION_REFERENCED_ELEMENT_NOT_FOUND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, ruleName
     * @return string 'CONDITION_REFERENCED_ELEMENT_NOT_FOUND'
     */
    const VALUE_CONDITION_REFERENCED_ELEMENT_NOT_FOUND = 'CONDITION_REFERENCED_ELEMENT_NOT_FOUND';
    /**
     * Constant for value 'CONDITION_RIGHTOPERAND_NULL'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, ruleName
     * @return string 'CONDITION_RIGHTOPERAND_NULL'
     */
    const VALUE_CONDITION_RIGHTOPERAND_NULL = 'CONDITION_RIGHTOPERAND_NULL';
    /**
     * Constant for value 'CONNECTOR_MISSING_TARGET'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'CONNECTOR_MISSING_TARGET'
     */
    const VALUE_CONNECTOR_MISSING_TARGET = 'CONNECTOR_MISSING_TARGET';
    /**
     * Constant for value 'CONSTANT_INCLUDES_REFERENCES'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, constantName
     * @return string 'CONSTANT_INCLUDES_REFERENCES'
     */
    const VALUE_CONSTANT_INCLUDES_REFERENCES = 'CONSTANT_INCLUDES_REFERENCES';
    /**
     * Constant for value 'CUSTOMEVENTS_NOT_ENABLED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'CUSTOMEVENTS_NOT_ENABLED'
     */
    const VALUE_CUSTOMEVENTS_NOT_ENABLED = 'CUSTOMEVENTS_NOT_ENABLED';
    /**
     * Constant for value 'CUSTOMEVENT_MISSING_PROCESSMETADATAVALUES'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'CUSTOMEVENT_MISSING_PROCESSMETADATAVALUES'
     */
    const VALUE_CUSTOMEVENT_MISSING_PROCESSMETADATAVALUES = 'CUSTOMEVENT_MISSING_PROCESSMETADATAVALUES';
    /**
     * Constant for value 'CUSTOMEVENT_OBJECTTYPE_NOT_FOUND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectType
     * @return string 'CUSTOMEVENT_OBJECTTYPE_NOT_FOUND'
     */
    const VALUE_CUSTOMEVENT_OBJECTTYPE_NOT_FOUND = 'CUSTOMEVENT_OBJECTTYPE_NOT_FOUND';
    /**
     * Constant for value 'CUSTOMEVENT_OBJECTTYPE_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectType
     * @return string 'CUSTOMEVENT_OBJECTTYPE_NOT_SUPPORTED'
     */
    const VALUE_CUSTOMEVENT_OBJECTTYPE_NOT_SUPPORTED = 'CUSTOMEVENT_OBJECTTYPE_NOT_SUPPORTED';
    /**
     * Constant for value 'CUSTOMEVENT_PROCESSMETADATAVALUES_MISSING_NAME'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, metadataValue
     * @return string 'CUSTOMEVENT_PROCESSMETADATAVALUES_MISSING_NAME'
     */
    const VALUE_CUSTOMEVENT_PROCESSMETADATAVALUES_MISSING_NAME = 'CUSTOMEVENT_PROCESSMETADATAVALUES_MISSING_NAME';
    /**
     * Constant for value 'CUSTOMEVENT_PROCESSMETADATAVALUES_MORE_THAN_ONE_NAME'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, metadataValue
     * @return string 'CUSTOMEVENT_PROCESSMETADATAVALUES_MORE_THAN_ONE_NAME'
     */
    const VALUE_CUSTOMEVENT_PROCESSMETADATAVALUES_MORE_THAN_ONE_NAME = 'CUSTOMEVENT_PROCESSMETADATAVALUES_MORE_THAN_ONE_NAME';
    /**
     * Constant for value 'DATATYPE_INVALID'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, dataType
     * @return string 'DATATYPE_INVALID'
     */
    const VALUE_DATATYPE_INVALID = 'DATATYPE_INVALID';
    /**
     * Constant for value 'DATATYPE_MISSING'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'DATATYPE_MISSING'
     */
    const VALUE_DATATYPE_MISSING = 'DATATYPE_MISSING';
    /**
     * Constant for value 'DATA_TYPE_NOT_SUPPORTED_FOR_PROCESSTYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, processType, dataType, elementType
     * @return string 'DATA_TYPE_NOT_SUPPORTED_FOR_PROCESSTYPE'
     */
    const VALUE_DATA_TYPE_NOT_SUPPORTED_FOR_PROCESSTYPE = 'DATA_TYPE_NOT_SUPPORTED_FOR_PROCESSTYPE';
    /**
     * Constant for value 'DECISION_DEFAULT_CONNECTOR_MISSING_LABEL'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, flowDecision
     * @return string 'DECISION_DEFAULT_CONNECTOR_MISSING_LABEL'
     */
    const VALUE_DECISION_DEFAULT_CONNECTOR_MISSING_LABEL = 'DECISION_DEFAULT_CONNECTOR_MISSING_LABEL';
    /**
     * Constant for value 'DECISION_MISSING_OUTCOME'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, flowDecision
     * @return string 'DECISION_MISSING_OUTCOME'
     */
    const VALUE_DECISION_MISSING_OUTCOME = 'DECISION_MISSING_OUTCOME';
    /**
     * Constant for value 'ELEMENT_CONNECTS_TO_SELF'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'ELEMENT_CONNECTS_TO_SELF'
     */
    const VALUE_ELEMENT_CONNECTS_TO_SELF = 'ELEMENT_CONNECTS_TO_SELF';
    /**
     * Constant for value 'ELEMENT_COORDINATES_INVALID'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, coordinateLimit, coordinateName
     * @return string 'ELEMENT_COORDINATES_INVALID'
     */
    const VALUE_ELEMENT_COORDINATES_INVALID = 'ELEMENT_COORDINATES_INVALID';
    /**
     * Constant for value 'ELEMENT_INVALID_CONNECTOR'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'ELEMENT_INVALID_CONNECTOR'
     */
    const VALUE_ELEMENT_INVALID_CONNECTOR = 'ELEMENT_INVALID_CONNECTOR';
    /**
     * Constant for value 'ELEMENT_INVALID_REFERENCE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'ELEMENT_INVALID_REFERENCE'
     */
    const VALUE_ELEMENT_INVALID_REFERENCE = 'ELEMENT_INVALID_REFERENCE';
    /**
     * Constant for value 'ELEMENT_MISSING_CONNECTOR'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'ELEMENT_MISSING_CONNECTOR'
     */
    const VALUE_ELEMENT_MISSING_CONNECTOR = 'ELEMENT_MISSING_CONNECTOR';
    /**
     * Constant for value 'ELEMENT_MISSING_LABEL'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, characterLimit, elementName
     * @return string 'ELEMENT_MISSING_LABEL'
     */
    const VALUE_ELEMENT_MISSING_LABEL = 'ELEMENT_MISSING_LABEL';
    /**
     * Constant for value 'ELEMENT_MISSING_NAME'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, characterLimit
     * @return string 'ELEMENT_MISSING_NAME'
     */
    const VALUE_ELEMENT_MISSING_NAME = 'ELEMENT_MISSING_NAME';
    /**
     * Constant for value 'ELEMENT_MISSING_REFERENCE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'ELEMENT_MISSING_REFERENCE'
     */
    const VALUE_ELEMENT_MISSING_REFERENCE = 'ELEMENT_MISSING_REFERENCE';
    /**
     * Constant for value 'ELEMENT_MORE_THAN_ONE_FIELD'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'ELEMENT_MORE_THAN_ONE_FIELD'
     */
    const VALUE_ELEMENT_MORE_THAN_ONE_FIELD = 'ELEMENT_MORE_THAN_ONE_FIELD';
    /**
     * Constant for value 'ELEMENT_NAME_INVALID'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'ELEMENT_NAME_INVALID'
     */
    const VALUE_ELEMENT_NAME_INVALID = 'ELEMENT_NAME_INVALID';
    /**
     * Constant for value 'ELEMENT_NEVER_USED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'ELEMENT_NEVER_USED'
     */
    const VALUE_ELEMENT_NEVER_USED = 'ELEMENT_NEVER_USED';
    /**
     * Constant for value 'ELEMENT_SCALE_SMALLER_THAN_DEFAULTVALUE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'ELEMENT_SCALE_SMALLER_THAN_DEFAULTVALUE'
     */
    const VALUE_ELEMENT_SCALE_SMALLER_THAN_DEFAULTVALUE = 'ELEMENT_SCALE_SMALLER_THAN_DEFAULTVALUE';
    /**
     * Constant for value 'EXTERNAL_OBJECTS_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectName
     * @return string 'EXTERNAL_OBJECTS_NOT_SUPPORTED'
     */
    const VALUE_EXTERNAL_OBJECTS_NOT_SUPPORTED = 'EXTERNAL_OBJECTS_NOT_SUPPORTED';
    /**
     * Constant for value 'EXTERNAL_OBJECT_FIELDS_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldReference
     * @return string 'EXTERNAL_OBJECT_FIELDS_NOT_SUPPORTED'
     */
    const VALUE_EXTERNAL_OBJECT_FIELDS_NOT_SUPPORTED = 'EXTERNAL_OBJECT_FIELDS_NOT_SUPPORTED';
    /**
     * Constant for value 'EX_AUTOLAUNCHED_SUBFLOW_INCOMPATIBLE_FLOWTYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowType
     * @return string 'EX_AUTOLAUNCHED_SUBFLOW_INCOMPATIBLE_FLOWTYPE'
     */
    const VALUE_EX_AUTOLAUNCHED_SUBFLOW_INCOMPATIBLE_FLOWTYPE = 'EX_AUTOLAUNCHED_SUBFLOW_INCOMPATIBLE_FLOWTYPE';
    /**
     * Constant for value 'FIELDASSIGNMENT_FIELD_INCOMPATIBLE_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, elementName
     * @return string 'FIELDASSIGNMENT_FIELD_INCOMPATIBLE_DATATYPE'
     */
    const VALUE_FIELDASSIGNMENT_FIELD_INCOMPATIBLE_DATATYPE = 'FIELDASSIGNMENT_FIELD_INCOMPATIBLE_DATATYPE';
    /**
     * Constant for value 'FIELDASSIGNMENT_INVALID_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, elementName, assignmentName
     * @return string 'FIELDASSIGNMENT_INVALID_DATATYPE'
     */
    const VALUE_FIELDASSIGNMENT_INVALID_DATATYPE = 'FIELDASSIGNMENT_INVALID_DATATYPE';
    /**
     * Constant for value 'FIELDASSIGNMENT_INVALID_ELEMENT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, elementName, elementType
     * @return string 'FIELDASSIGNMENT_INVALID_ELEMENT'
     */
    const VALUE_FIELDASSIGNMENT_INVALID_ELEMENT = 'FIELDASSIGNMENT_INVALID_ELEMENT';
    /**
     * Constant for value 'FIELDASSIGNMENT_INVALID_REFERENCE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, parameterName
     * @return string 'FIELDASSIGNMENT_INVALID_REFERENCE'
     */
    const VALUE_FIELDASSIGNMENT_INVALID_REFERENCE = 'FIELDASSIGNMENT_INVALID_REFERENCE';
    /**
     * Constant for value 'FIELDASSIGNMENT_MULTIPLE_REFERENCES_SAME_FIELD'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName
     * @return string 'FIELDASSIGNMENT_MULTIPLE_REFERENCES_SAME_FIELD'
     */
    const VALUE_FIELDASSIGNMENT_MULTIPLE_REFERENCES_SAME_FIELD = 'FIELDASSIGNMENT_MULTIPLE_REFERENCES_SAME_FIELD';
    /**
     * Constant for value 'FIELDASSIGNMENT_PICKLISTFIELD_INCOMPATIBLE_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, dataType
     * @return string 'FIELDASSIGNMENT_PICKLISTFIELD_INCOMPATIBLE_DATATYPE'
     */
    const VALUE_FIELDASSIGNMENT_PICKLISTFIELD_INCOMPATIBLE_DATATYPE = 'FIELDASSIGNMENT_PICKLISTFIELD_INCOMPATIBLE_DATATYPE';
    /**
     * Constant for value 'FIELDASSIGNMENT_REFERENCED_ELEMENT_MISSING_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, elementName, elementType
     * @return string 'FIELDASSIGNMENT_REFERENCED_ELEMENT_MISSING_DATATYPE'
     */
    const VALUE_FIELDASSIGNMENT_REFERENCED_ELEMENT_MISSING_DATATYPE = 'FIELDASSIGNMENT_REFERENCED_ELEMENT_MISSING_DATATYPE';
    /**
     * Constant for value 'FIELDSERVICE_UNSUPPORTED_FIELD_TYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'FIELDSERVICE_UNSUPPORTED_FIELD_TYPE'
     */
    const VALUE_FIELDSERVICE_UNSUPPORTED_FIELD_TYPE = 'FIELDSERVICE_UNSUPPORTED_FIELD_TYPE';
    /**
     * Constant for value 'FIELD_INVALID_VALUE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, parameterName
     * @return string 'FIELD_INVALID_VALUE'
     */
    const VALUE_FIELD_INVALID_VALUE = 'FIELD_INVALID_VALUE';
    /**
     * Constant for value 'FIELD_NOT_FOUND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectName, fieldName
     * @return string 'FIELD_NOT_FOUND'
     */
    const VALUE_FIELD_NOT_FOUND = 'FIELD_NOT_FOUND';
    /**
     * Constant for value 'FIELD_RELATIONSHIP_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldRelationshipName
     * @return string 'FIELD_RELATIONSHIP_NOT_SUPPORTED'
     */
    const VALUE_FIELD_RELATIONSHIP_NOT_SUPPORTED = 'FIELD_RELATIONSHIP_NOT_SUPPORTED';
    /**
     * Constant for value 'FLEXIPAGE_COMPONENT_ATTRIBUTE_EXPRESSION_EXCEPTION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: componentName, propertyName, propertyType, errorCode, invalidTokens
     * @return string 'FLEXIPAGE_COMPONENT_ATTRIBUTE_EXPRESSION_EXCEPTION'
     */
    const VALUE_FLEXIPAGE_COMPONENT_ATTRIBUTE_EXPRESSION_EXCEPTION = 'FLEXIPAGE_COMPONENT_ATTRIBUTE_EXPRESSION_EXCEPTION';
    /**
     * Constant for value 'FLEXIPAGE_COMPONENT_ATTRIBUTE_GENERIC_EXCEPTION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: componentName, propertyName, propertyType, errorIdentifier, errorParams
     * @return string 'FLEXIPAGE_COMPONENT_ATTRIBUTE_GENERIC_EXCEPTION'
     */
    const VALUE_FLEXIPAGE_COMPONENT_ATTRIBUTE_GENERIC_EXCEPTION = 'FLEXIPAGE_COMPONENT_ATTRIBUTE_GENERIC_EXCEPTION';
    /**
     * Constant for value 'FLEXIPAGE_COMPONENT_ATTRIBUTE_MISSING_REQUIRED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: componentName, propertyName, propertyType
     * @return string 'FLEXIPAGE_COMPONENT_ATTRIBUTE_MISSING_REQUIRED'
     */
    const VALUE_FLEXIPAGE_COMPONENT_ATTRIBUTE_MISSING_REQUIRED = 'FLEXIPAGE_COMPONENT_ATTRIBUTE_MISSING_REQUIRED';
    /**
     * Constant for value 'FLEXIPAGE_COMPONENT_ATTRIBUTE_TOO_LONG'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: componentName, propertyName, propertyType, maxLength
     * @return string 'FLEXIPAGE_COMPONENT_ATTRIBUTE_TOO_LONG'
     */
    const VALUE_FLEXIPAGE_COMPONENT_ATTRIBUTE_TOO_LONG = 'FLEXIPAGE_COMPONENT_ATTRIBUTE_TOO_LONG';
    /**
     * Constant for value 'FLEXIPAGE_COMPONENT_CUSTOM_VALIDATION_EXCEPTION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: componentName
     * @return string 'FLEXIPAGE_COMPONENT_CUSTOM_VALIDATION_EXCEPTION'
     */
    const VALUE_FLEXIPAGE_COMPONENT_CUSTOM_VALIDATION_EXCEPTION = 'FLEXIPAGE_COMPONENT_CUSTOM_VALIDATION_EXCEPTION';
    /**
     * Constant for value 'FLEXIPAGE_COMPONENT_MAX_LIMIT_EXCEPTION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties:
     * @return string 'FLEXIPAGE_COMPONENT_MAX_LIMIT_EXCEPTION'
     */
    const VALUE_FLEXIPAGE_COMPONENT_MAX_LIMIT_EXCEPTION = 'FLEXIPAGE_COMPONENT_MAX_LIMIT_EXCEPTION';
    /**
     * Constant for value 'FLEXIPAGE_COMPONENT_RULE_VALIDATION_EXCEPTION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: componentName, criterionIndex
     * @return string 'FLEXIPAGE_COMPONENT_RULE_VALIDATION_EXCEPTION'
     */
    const VALUE_FLEXIPAGE_COMPONENT_RULE_VALIDATION_EXCEPTION = 'FLEXIPAGE_COMPONENT_RULE_VALIDATION_EXCEPTION';
    /**
     * Constant for value 'FLEXIPAGE_PICKLIST_INVALID_VALUE_EXCEPTION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: componentName, propertyName, propertyType, invalidValue
     * @return string 'FLEXIPAGE_PICKLIST_INVALID_VALUE_EXCEPTION'
     */
    const VALUE_FLEXIPAGE_PICKLIST_INVALID_VALUE_EXCEPTION = 'FLEXIPAGE_PICKLIST_INVALID_VALUE_EXCEPTION';
    /**
     * Constant for value 'FLEXIPAGE_TEMPLATE_INVALID_SWITCH'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: newTemplate, oldTemplate
     * @return string 'FLEXIPAGE_TEMPLATE_INVALID_SWITCH'
     */
    const VALUE_FLEXIPAGE_TEMPLATE_INVALID_SWITCH = 'FLEXIPAGE_TEMPLATE_INVALID_SWITCH';
    /**
     * Constant for value 'FLOW_ELEMENT_SCALE_LESS_THAN_ZERO'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'FLOW_ELEMENT_SCALE_LESS_THAN_ZERO'
     */
    const VALUE_FLOW_ELEMENT_SCALE_LESS_THAN_ZERO = 'FLOW_ELEMENT_SCALE_LESS_THAN_ZERO';
    /**
     * Constant for value 'FLOW_INCLUDES_STEP'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'FLOW_INCLUDES_STEP'
     */
    const VALUE_FLOW_INCLUDES_STEP = 'FLOW_INCLUDES_STEP';
    /**
     * Constant for value 'FLOW_INTERVIEW_BULK_EXECUTION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_BULK_EXECUTION'
     */
    const VALUE_FLOW_INTERVIEW_BULK_EXECUTION = 'FLOW_INTERVIEW_BULK_EXECUTION';
    /**
     * Constant for value 'FLOW_INTERVIEW_HANDLED_ERROR'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_HANDLED_ERROR'
     */
    const VALUE_FLOW_INTERVIEW_HANDLED_ERROR = 'FLOW_INTERVIEW_HANDLED_ERROR';
    /**
     * Constant for value 'FLOW_INTERVIEW_INPUT_VALIDATION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_INPUT_VALIDATION'
     */
    const VALUE_FLOW_INTERVIEW_INPUT_VALIDATION = 'FLOW_INTERVIEW_INPUT_VALIDATION';
    /**
     * Constant for value 'FLOW_INTERVIEW_INTERACTION_NOT_FOUND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_INTERACTION_NOT_FOUND'
     */
    const VALUE_FLOW_INTERVIEW_INTERACTION_NOT_FOUND = 'FLOW_INTERVIEW_INTERACTION_NOT_FOUND';
    /**
     * Constant for value 'FLOW_INTERVIEW_INVALID_CHOICE_USER_INPUT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_INVALID_CHOICE_USER_INPUT'
     */
    const VALUE_FLOW_INTERVIEW_INVALID_CHOICE_USER_INPUT = 'FLOW_INTERVIEW_INVALID_CHOICE_USER_INPUT';
    /**
     * Constant for value 'FLOW_INTERVIEW_INVALID_FIELD_VALUE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_INVALID_FIELD_VALUE'
     */
    const VALUE_FLOW_INTERVIEW_INVALID_FIELD_VALUE = 'FLOW_INTERVIEW_INVALID_FIELD_VALUE';
    /**
     * Constant for value 'FLOW_INTERVIEW_INVALID_START_REQUEST'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_INVALID_START_REQUEST'
     */
    const VALUE_FLOW_INTERVIEW_INVALID_START_REQUEST = 'FLOW_INTERVIEW_INVALID_START_REQUEST';
    /**
     * Constant for value 'FLOW_INTERVIEW_LIMIT_EXCEEDED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_LIMIT_EXCEEDED'
     */
    const VALUE_FLOW_INTERVIEW_LIMIT_EXCEEDED = 'FLOW_INTERVIEW_LIMIT_EXCEEDED';
    /**
     * Constant for value 'FLOW_INTERVIEW_MISSING_CHOICE_FOR_REQUIRED_CHOICE_FIELD'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_MISSING_CHOICE_FOR_REQUIRED_CHOICE_FIELD'
     */
    const VALUE_FLOW_INTERVIEW_MISSING_CHOICE_FOR_REQUIRED_CHOICE_FIELD = 'FLOW_INTERVIEW_MISSING_CHOICE_FOR_REQUIRED_CHOICE_FIELD';
    /**
     * Constant for value 'FLOW_INTERVIEW_MISSING_VALUE_FOR_REQUIRED_INPUT_FIELD'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_MISSING_VALUE_FOR_REQUIRED_INPUT_FIELD'
     */
    const VALUE_FLOW_INTERVIEW_MISSING_VALUE_FOR_REQUIRED_INPUT_FIELD = 'FLOW_INTERVIEW_MISSING_VALUE_FOR_REQUIRED_INPUT_FIELD';
    /**
     * Constant for value 'FLOW_INTERVIEW_NAVIGATE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_NAVIGATE'
     */
    const VALUE_FLOW_INTERVIEW_NAVIGATE = 'FLOW_INTERVIEW_NAVIGATE';
    /**
     * Constant for value 'FLOW_INTERVIEW_RANGE_VALIDATION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_RANGE_VALIDATION'
     */
    const VALUE_FLOW_INTERVIEW_RANGE_VALIDATION = 'FLOW_INTERVIEW_RANGE_VALIDATION';
    /**
     * Constant for value 'FLOW_INTERVIEW_REGEX_VALIDATION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_REGEX_VALIDATION'
     */
    const VALUE_FLOW_INTERVIEW_REGEX_VALIDATION = 'FLOW_INTERVIEW_REGEX_VALIDATION';
    /**
     * Constant for value 'FLOW_INTERVIEW_RESUME_INTERVIEW'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_RESUME_INTERVIEW'
     */
    const VALUE_FLOW_INTERVIEW_RESUME_INTERVIEW = 'FLOW_INTERVIEW_RESUME_INTERVIEW';
    /**
     * Constant for value 'FLOW_INTERVIEW_SAVE_RESULT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_SAVE_RESULT'
     */
    const VALUE_FLOW_INTERVIEW_SAVE_RESULT = 'FLOW_INTERVIEW_SAVE_RESULT';
    /**
     * Constant for value 'FLOW_INTERVIEW_SET_CHOICE_SELECTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_SET_CHOICE_SELECTED'
     */
    const VALUE_FLOW_INTERVIEW_SET_CHOICE_SELECTED = 'FLOW_INTERVIEW_SET_CHOICE_SELECTED';
    /**
     * Constant for value 'FLOW_INTERVIEW_START_INTERVIEW'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_START_INTERVIEW'
     */
    const VALUE_FLOW_INTERVIEW_START_INTERVIEW = 'FLOW_INTERVIEW_START_INTERVIEW';
    /**
     * Constant for value 'FLOW_INTERVIEW_TYPE_CONVERSION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'FLOW_INTERVIEW_TYPE_CONVERSION'
     */
    const VALUE_FLOW_INTERVIEW_TYPE_CONVERSION = 'FLOW_INTERVIEW_TYPE_CONVERSION';
    /**
     * Constant for value 'FLOW_INVALID_NAME'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, maxDevNameLength
     * @return string 'FLOW_INVALID_NAME'
     */
    const VALUE_FLOW_INVALID_NAME = 'FLOW_INVALID_NAME';
    /**
     * Constant for value 'FLOW_NAME_USED_IN_OTHER_CLIENT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, flowName
     * @return string 'FLOW_NAME_USED_IN_OTHER_CLIENT'
     */
    const VALUE_FLOW_NAME_USED_IN_OTHER_CLIENT = 'FLOW_NAME_USED_IN_OTHER_CLIENT';
    /**
     * Constant for value 'FLOW_STAGE_INCLUDES_REFERENCES'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, stageName
     * @return string 'FLOW_STAGE_INCLUDES_REFERENCES'
     */
    const VALUE_FLOW_STAGE_INCLUDES_REFERENCES = 'FLOW_STAGE_INCLUDES_REFERENCES';
    /**
     * Constant for value 'FLOW_STAGE_ORDER_DUPLICATE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, stageName, stageOrder, stageWithSameOrder
     * @return string 'FLOW_STAGE_ORDER_DUPLICATE'
     */
    const VALUE_FLOW_STAGE_ORDER_DUPLICATE = 'FLOW_STAGE_ORDER_DUPLICATE';
    /**
     * Constant for value 'FLOW_STAGE_ORDER_OUT_OF_RANGE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, stageName, invalidStageOrder, maxOrder, minOrder
     * @return string 'FLOW_STAGE_ORDER_OUT_OF_RANGE'
     */
    const VALUE_FLOW_STAGE_ORDER_OUT_OF_RANGE = 'FLOW_STAGE_ORDER_OUT_OF_RANGE';
    /**
     * Constant for value 'FORMULA_CMT_LIMIT_EXCEEDED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, formulaExpression
     * @return string 'FORMULA_CMT_LIMIT_EXCEEDED'
     */
    const VALUE_FORMULA_CMT_LIMIT_EXCEEDED = 'FORMULA_CMT_LIMIT_EXCEEDED';
    /**
     * Constant for value 'FORMULA_EXPRESSION_INVALID'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, formulaExpression
     * @return string 'FORMULA_EXPRESSION_INVALID'
     */
    const VALUE_FORMULA_EXPRESSION_INVALID = 'FORMULA_EXPRESSION_INVALID';
    /**
     * Constant for value 'GLOBAL_VARIABLE_NOT_SUPPORTED_FOR_PROCESSTYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, processType, systemVariable
     * @return string 'GLOBAL_VARIABLE_NOT_SUPPORTED_FOR_PROCESSTYPE'
     */
    const VALUE_GLOBAL_VARIABLE_NOT_SUPPORTED_FOR_PROCESSTYPE = 'GLOBAL_VARIABLE_NOT_SUPPORTED_FOR_PROCESSTYPE';
    /**
     * Constant for value 'INPUTPARAM_INCOMPATIBLE_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, parameterName
     * @return string 'INPUTPARAM_INCOMPATIBLE_DATATYPE'
     */
    const VALUE_INPUTPARAM_INCOMPATIBLE_DATATYPE = 'INPUTPARAM_INCOMPATIBLE_DATATYPE';
    /**
     * Constant for value 'INPUTPARAM_INCOMPATIBLE_WITH_COLLECTION_VARIABLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, parameterName
     * @return string 'INPUTPARAM_INCOMPATIBLE_WITH_COLLECTION_VARIABLE'
     */
    const VALUE_INPUTPARAM_INCOMPATIBLE_WITH_COLLECTION_VARIABLE = 'INPUTPARAM_INCOMPATIBLE_WITH_COLLECTION_VARIABLE';
    /**
     * Constant for value 'INPUTPARAM_INCOMPATIBLE_WITH_NONCOLLECTION_VARIABLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, parameterName
     * @return string 'INPUTPARAM_INCOMPATIBLE_WITH_NONCOLLECTION_VARIABLE'
     */
    const VALUE_INPUTPARAM_INCOMPATIBLE_WITH_NONCOLLECTION_VARIABLE = 'INPUTPARAM_INCOMPATIBLE_WITH_NONCOLLECTION_VARIABLE';
    /**
     * Constant for value 'INPUTPARAM_MISMATCHED_OBJECTTYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, parameterName
     * @return string 'INPUTPARAM_MISMATCHED_OBJECTTYPE'
     */
    const VALUE_INPUTPARAM_MISMATCHED_OBJECTTYPE = 'INPUTPARAM_MISMATCHED_OBJECTTYPE';
    /**
     * Constant for value 'INVALID_FLOW'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'INVALID_FLOW'
     */
    const VALUE_INVALID_FLOW = 'INVALID_FLOW';
    /**
     * Constant for value 'INVALID_FLOW_INTERVIEW'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'INVALID_FLOW_INTERVIEW'
     */
    const VALUE_INVALID_FLOW_INTERVIEW = 'INVALID_FLOW_INTERVIEW';
    /**
     * Constant for value 'INVALID_SURVEY_VARIABLE_NAME_OR_TYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, surveyName
     * @return string 'INVALID_SURVEY_VARIABLE_NAME_OR_TYPE'
     */
    const VALUE_INVALID_SURVEY_VARIABLE_NAME_OR_TYPE = 'INVALID_SURVEY_VARIABLE_NAME_OR_TYPE';
    /**
     * Constant for value 'LOOP_ASSIGNNEXTVALUETO_MISMATCHED_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'LOOP_ASSIGNNEXTVALUETO_MISMATCHED_DATATYPE'
     */
    const VALUE_LOOP_ASSIGNNEXTVALUETO_MISMATCHED_DATATYPE = 'LOOP_ASSIGNNEXTVALUETO_MISMATCHED_DATATYPE';
    /**
     * Constant for value 'LOOP_ASSIGNNEXTVALUETO_MISMATCHED_OBJECTTYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'LOOP_ASSIGNNEXTVALUETO_MISMATCHED_OBJECTTYPE'
     */
    const VALUE_LOOP_ASSIGNNEXTVALUETO_MISMATCHED_OBJECTTYPE = 'LOOP_ASSIGNNEXTVALUETO_MISMATCHED_OBJECTTYPE';
    /**
     * Constant for value 'LOOP_ASSIGNNEXTVALUETO_MISSING'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'LOOP_ASSIGNNEXTVALUETO_MISSING'
     */
    const VALUE_LOOP_ASSIGNNEXTVALUETO_MISSING = 'LOOP_ASSIGNNEXTVALUETO_MISSING';
    /**
     * Constant for value 'LOOP_ASSIGNNEXTVALUETO_MISSING_VARIABLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'LOOP_ASSIGNNEXTVALUETO_MISSING_VARIABLE'
     */
    const VALUE_LOOP_ASSIGNNEXTVALUETO_MISSING_VARIABLE = 'LOOP_ASSIGNNEXTVALUETO_MISSING_VARIABLE';
    /**
     * Constant for value 'LOOP_ASSIGNNEXTVALUETO_REFERENCE_NOT_FOUND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldRelationshipName
     * @return string 'LOOP_ASSIGNNEXTVALUETO_REFERENCE_NOT_FOUND'
     */
    const VALUE_LOOP_ASSIGNNEXTVALUETO_REFERENCE_NOT_FOUND = 'LOOP_ASSIGNNEXTVALUETO_REFERENCE_NOT_FOUND';
    /**
     * Constant for value 'LOOP_COLLECTION_ELEMENT_NOT_FOUND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'LOOP_COLLECTION_ELEMENT_NOT_FOUND'
     */
    const VALUE_LOOP_COLLECTION_ELEMENT_NOT_FOUND = 'LOOP_COLLECTION_ELEMENT_NOT_FOUND';
    /**
     * Constant for value 'LOOP_COLLECTION_NOT_FOUND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'LOOP_COLLECTION_NOT_FOUND'
     */
    const VALUE_LOOP_COLLECTION_NOT_FOUND = 'LOOP_COLLECTION_NOT_FOUND';
    /**
     * Constant for value 'LOOP_COLLECTION_NOT_SUPPORTED_FOR_FIELD'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName
     * @return string 'LOOP_COLLECTION_NOT_SUPPORTED_FOR_FIELD'
     */
    const VALUE_LOOP_COLLECTION_NOT_SUPPORTED_FOR_FIELD = 'LOOP_COLLECTION_NOT_SUPPORTED_FOR_FIELD';
    /**
     * Constant for value 'LOOP_MISSING_COLLECTION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'LOOP_MISSING_COLLECTION'
     */
    const VALUE_LOOP_MISSING_COLLECTION = 'LOOP_MISSING_COLLECTION';
    /**
     * Constant for value 'OBJECTTYPE_INVALID'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectType
     * @return string 'OBJECTTYPE_INVALID'
     */
    const VALUE_OBJECTTYPE_INVALID = 'OBJECTTYPE_INVALID';
    /**
     * Constant for value 'OBJECT_CANNOT_BE_CREATED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectName
     * @return string 'OBJECT_CANNOT_BE_CREATED'
     */
    const VALUE_OBJECT_CANNOT_BE_CREATED = 'OBJECT_CANNOT_BE_CREATED';
    /**
     * Constant for value 'OBJECT_CANNOT_BE_DELETED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectName
     * @return string 'OBJECT_CANNOT_BE_DELETED'
     */
    const VALUE_OBJECT_CANNOT_BE_DELETED = 'OBJECT_CANNOT_BE_DELETED';
    /**
     * Constant for value 'OBJECT_CANNOT_BE_QUERIED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectName
     * @return string 'OBJECT_CANNOT_BE_QUERIED'
     */
    const VALUE_OBJECT_CANNOT_BE_QUERIED = 'OBJECT_CANNOT_BE_QUERIED';
    /**
     * Constant for value 'OBJECT_CANNOT_BE_UPDATED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectName
     * @return string 'OBJECT_CANNOT_BE_UPDATED'
     */
    const VALUE_OBJECT_CANNOT_BE_UPDATED = 'OBJECT_CANNOT_BE_UPDATED';
    /**
     * Constant for value 'OBJECT_ENCRYPTED_FIELDS_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName
     * @return string 'OBJECT_ENCRYPTED_FIELDS_NOT_SUPPORTED'
     */
    const VALUE_OBJECT_ENCRYPTED_FIELDS_NOT_SUPPORTED = 'OBJECT_ENCRYPTED_FIELDS_NOT_SUPPORTED';
    /**
     * Constant for value 'OBJECT_NOT_FOUND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectName
     * @return string 'OBJECT_NOT_FOUND'
     */
    const VALUE_OBJECT_NOT_FOUND = 'OBJECT_NOT_FOUND';
    /**
     * Constant for value 'OUTPUTPARAM_ASSIGNTOREFERENCE_NOTFOUND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, parameterName
     * @return string 'OUTPUTPARAM_ASSIGNTOREFERENCE_NOTFOUND'
     */
    const VALUE_OUTPUTPARAM_ASSIGNTOREFERENCE_NOTFOUND = 'OUTPUTPARAM_ASSIGNTOREFERENCE_NOTFOUND';
    /**
     * Constant for value 'OUTPUTPARAM_INCOMPATIBLE_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, parameterName
     * @return string 'OUTPUTPARAM_INCOMPATIBLE_DATATYPE'
     */
    const VALUE_OUTPUTPARAM_INCOMPATIBLE_DATATYPE = 'OUTPUTPARAM_INCOMPATIBLE_DATATYPE';
    /**
     * Constant for value 'OUTPUTPARAM_MISMATCHED_OBJECTTYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, parameterName
     * @return string 'OUTPUTPARAM_MISMATCHED_OBJECTTYPE'
     */
    const VALUE_OUTPUTPARAM_MISMATCHED_OBJECTTYPE = 'OUTPUTPARAM_MISMATCHED_OBJECTTYPE';
    /**
     * Constant for value 'OUTPUTPARAM_MISMATCHED_WITH_COLLECTION_VARIABLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, parameterName
     * @return string 'OUTPUTPARAM_MISMATCHED_WITH_COLLECTION_VARIABLE'
     */
    const VALUE_OUTPUTPARAM_MISMATCHED_WITH_COLLECTION_VARIABLE = 'OUTPUTPARAM_MISMATCHED_WITH_COLLECTION_VARIABLE';
    /**
     * Constant for value 'OUTPUTPARAM_MISSING_ASSIGNTOREFERENCE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, parameterName
     * @return string 'OUTPUTPARAM_MISSING_ASSIGNTOREFERENCE'
     */
    const VALUE_OUTPUTPARAM_MISSING_ASSIGNTOREFERENCE = 'OUTPUTPARAM_MISSING_ASSIGNTOREFERENCE';
    /**
     * Constant for value 'OUTPUTPARAM_MISTMATCHED_WITH_NONCOLLECTION_VARIABLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, parameterName
     * @return string 'OUTPUTPARAM_MISTMATCHED_WITH_NONCOLLECTION_VARIABLE'
     */
    const VALUE_OUTPUTPARAM_MISTMATCHED_WITH_NONCOLLECTION_VARIABLE = 'OUTPUTPARAM_MISTMATCHED_WITH_NONCOLLECTION_VARIABLE';
    /**
     * Constant for value 'PARAM_DATATYPE_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, parameterName
     * @return string 'PARAM_DATATYPE_NOT_SUPPORTED'
     */
    const VALUE_PARAM_DATATYPE_NOT_SUPPORTED = 'PARAM_DATATYPE_NOT_SUPPORTED';
    /**
     * Constant for value 'PROCESSMETADATAVALUES_NOT_SUPPORTED_FOR_PROCESSTYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, processType, metadataValue
     * @return string 'PROCESSMETADATAVALUES_NOT_SUPPORTED_FOR_PROCESSTYPE'
     */
    const VALUE_PROCESSMETADATAVALUES_NOT_SUPPORTED_FOR_PROCESSTYPE = 'PROCESSMETADATAVALUES_NOT_SUPPORTED_FOR_PROCESSTYPE';
    /**
     * Constant for value 'PROCESSMETADATAVALUE_NONEXISTENT_ELEMENT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, metadataValue
     * @return string 'PROCESSMETADATAVALUE_NONEXISTENT_ELEMENT'
     */
    const VALUE_PROCESSMETADATAVALUE_NONEXISTENT_ELEMENT = 'PROCESSMETADATAVALUE_NONEXISTENT_ELEMENT';
    /**
     * Constant for value 'PROCESSTYPE_COMPONENTTYPE_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, processType, fieldType
     * @return string 'PROCESSTYPE_COMPONENTTYPE_NOT_SUPPORTED'
     */
    const VALUE_PROCESSTYPE_COMPONENTTYPE_NOT_SUPPORTED = 'PROCESSTYPE_COMPONENTTYPE_NOT_SUPPORTED';
    /**
     * Constant for value 'PROCESSTYPE_ELEMENT_CONFIG_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, processType, attributeSet, elementType
     * @return string 'PROCESSTYPE_ELEMENT_CONFIG_NOT_SUPPORTED'
     */
    const VALUE_PROCESSTYPE_ELEMENT_CONFIG_NOT_SUPPORTED = 'PROCESSTYPE_ELEMENT_CONFIG_NOT_SUPPORTED';
    /**
     * Constant for value 'PROCESSTYPE_ELEMENT_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, processType, elementType
     * @return string 'PROCESSTYPE_ELEMENT_NOT_SUPPORTED'
     */
    const VALUE_PROCESSTYPE_ELEMENT_NOT_SUPPORTED = 'PROCESSTYPE_ELEMENT_NOT_SUPPORTED';
    /**
     * Constant for value 'PROCESSTYPE_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, processType
     * @return string 'PROCESSTYPE_NOT_SUPPORTED'
     */
    const VALUE_PROCESSTYPE_NOT_SUPPORTED = 'PROCESSTYPE_NOT_SUPPORTED';
    /**
     * Constant for value 'PROCESSTYPE_SCREEN_FIELDTYPE_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, processType, fieldType
     * @return string 'PROCESSTYPE_SCREEN_FIELDTYPE_NOT_SUPPORTED'
     */
    const VALUE_PROCESSTYPE_SCREEN_FIELDTYPE_NOT_SUPPORTED = 'PROCESSTYPE_SCREEN_FIELDTYPE_NOT_SUPPORTED';
    /**
     * Constant for value 'PROCESS_TYPE_INCOMPATIBLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, currentProcessType, flowName, incompatibleProcessType
     * @return string 'PROCESS_TYPE_INCOMPATIBLE'
     */
    const VALUE_PROCESS_TYPE_INCOMPATIBLE = 'PROCESS_TYPE_INCOMPATIBLE';
    /**
     * Constant for value 'RECOMMENDATION_STRATEGY_EXCEPTION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: errorArguments, errorCode
     * @return string 'RECOMMENDATION_STRATEGY_EXCEPTION'
     */
    const VALUE_RECOMMENDATION_STRATEGY_EXCEPTION = 'RECOMMENDATION_STRATEGY_EXCEPTION';
    /**
     * Constant for value 'RECORDFILTER_ENCRYPTED_FIELDS_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName
     * @return string 'RECORDFILTER_ENCRYPTED_FIELDS_NOT_SUPPORTED'
     */
    const VALUE_RECORDFILTER_ENCRYPTED_FIELDS_NOT_SUPPORTED = 'RECORDFILTER_ENCRYPTED_FIELDS_NOT_SUPPORTED';
    /**
     * Constant for value 'RECORDFILTER_GEOLOCATION_FIELDS_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, objectName
     * @return string 'RECORDFILTER_GEOLOCATION_FIELDS_NOT_SUPPORTED'
     */
    const VALUE_RECORDFILTER_GEOLOCATION_FIELDS_NOT_SUPPORTED = 'RECORDFILTER_GEOLOCATION_FIELDS_NOT_SUPPORTED';
    /**
     * Constant for value 'RECORDFILTER_INVALID_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, elementName, elementType, operatorName
     * @return string 'RECORDFILTER_INVALID_DATATYPE'
     */
    const VALUE_RECORDFILTER_INVALID_DATATYPE = 'RECORDFILTER_INVALID_DATATYPE';
    /**
     * Constant for value 'RECORDFILTER_INVALID_ELEMENT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, assignmentName, elementName, elementType
     * @return string 'RECORDFILTER_INVALID_ELEMENT'
     */
    const VALUE_RECORDFILTER_INVALID_ELEMENT = 'RECORDFILTER_INVALID_ELEMENT';
    /**
     * Constant for value 'RECORDFILTER_INVALID_OPERATOR'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, operatorName
     * @return string 'RECORDFILTER_INVALID_OPERATOR'
     */
    const VALUE_RECORDFILTER_INVALID_OPERATOR = 'RECORDFILTER_INVALID_OPERATOR';
    /**
     * Constant for value 'RECORDFILTER_INVALID_REFERENCE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, operatorName
     * @return string 'RECORDFILTER_INVALID_REFERENCE'
     */
    const VALUE_RECORDFILTER_INVALID_REFERENCE = 'RECORDFILTER_INVALID_REFERENCE';
    /**
     * Constant for value 'RECORDFILTER_MISSING_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, elementName, elementType, operatorName
     * @return string 'RECORDFILTER_MISSING_DATATYPE'
     */
    const VALUE_RECORDFILTER_MISSING_DATATYPE = 'RECORDFILTER_MISSING_DATATYPE';
    /**
     * Constant for value 'RECORDFILTER_MULTIPLE_QUERIES_SAME_FIELD'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName
     * @return string 'RECORDFILTER_MULTIPLE_QUERIES_SAME_FIELD'
     */
    const VALUE_RECORDFILTER_MULTIPLE_QUERIES_SAME_FIELD = 'RECORDFILTER_MULTIPLE_QUERIES_SAME_FIELD';
    /**
     * Constant for value 'RECORDLOOKUP_IDASSIGNMENT_VARIABLE_INCOMPATIBLE_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'RECORDLOOKUP_IDASSIGNMENT_VARIABLE_INCOMPATIBLE_DATATYPE'
     */
    const VALUE_RECORDLOOKUP_IDASSIGNMENT_VARIABLE_INCOMPATIBLE_DATATYPE = 'RECORDLOOKUP_IDASSIGNMENT_VARIABLE_INCOMPATIBLE_DATATYPE';
    /**
     * Constant for value 'RECORDLOOKUP_IDASSIGNMENT_VARIABLE_NOT_FOUND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'RECORDLOOKUP_IDASSIGNMENT_VARIABLE_NOT_FOUND'
     */
    const VALUE_RECORDLOOKUP_IDASSIGNMENT_VARIABLE_NOT_FOUND = 'RECORDLOOKUP_IDASSIGNMENT_VARIABLE_NOT_FOUND';
    /**
     * Constant for value 'RECORDUPDATE_MISSING_FILTERS'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectName
     * @return string 'RECORDUPDATE_MISSING_FILTERS'
     */
    const VALUE_RECORDUPDATE_MISSING_FILTERS = 'RECORDUPDATE_MISSING_FILTERS';
    /**
     * Constant for value 'REFERENCED_ELEMENT_NOT_FOUND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, mergeFieldReference
     * @return string 'REFERENCED_ELEMENT_NOT_FOUND'
     */
    const VALUE_REFERENCED_ELEMENT_NOT_FOUND = 'REFERENCED_ELEMENT_NOT_FOUND';
    /**
     * Constant for value 'RULE_MISSING_CONDITION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, ruleName
     * @return string 'RULE_MISSING_CONDITION'
     */
    const VALUE_RULE_MISSING_CONDITION = 'RULE_MISSING_CONDITION';
    /**
     * Constant for value 'SCREENFIELD_API_VERSION_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName
     * @return string 'SCREENFIELD_API_VERSION_NOT_SUPPORTED'
     */
    const VALUE_SCREENFIELD_API_VERSION_NOT_SUPPORTED = 'SCREENFIELD_API_VERSION_NOT_SUPPORTED';
    /**
     * Constant for value 'SCREENFIELD_BOOLEAN_ISREQUIRED_IS_FALSE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName
     * @return string 'SCREENFIELD_BOOLEAN_ISREQUIRED_IS_FALSE'
     */
    const VALUE_SCREENFIELD_BOOLEAN_ISREQUIRED_IS_FALSE = 'SCREENFIELD_BOOLEAN_ISREQUIRED_IS_FALSE';
    /**
     * Constant for value 'SCREENFIELD_DEFAULTVALUE_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'SCREENFIELD_DEFAULTVALUE_NOT_SUPPORTED'
     */
    const VALUE_SCREENFIELD_DEFAULTVALUE_NOT_SUPPORTED = 'SCREENFIELD_DEFAULTVALUE_NOT_SUPPORTED';
    /**
     * Constant for value 'SCREENFIELD_EXTENSION_COMPONENT_NOT_GLOBAL'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'SCREENFIELD_EXTENSION_COMPONENT_NOT_GLOBAL'
     */
    const VALUE_SCREENFIELD_EXTENSION_COMPONENT_NOT_GLOBAL = 'SCREENFIELD_EXTENSION_COMPONENT_NOT_GLOBAL';
    /**
     * Constant for value 'SCREENFIELD_EXTENSION_DUPLICATE_INPUT_PARAM'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, extensionName, parameterName
     * @return string 'SCREENFIELD_EXTENSION_DUPLICATE_INPUT_PARAM'
     */
    const VALUE_SCREENFIELD_EXTENSION_DUPLICATE_INPUT_PARAM = 'SCREENFIELD_EXTENSION_DUPLICATE_INPUT_PARAM';
    /**
     * Constant for value 'SCREENFIELD_EXTENSION_DUPLICATE_OUTPUT_PARAM'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, extensionName, parameterName
     * @return string 'SCREENFIELD_EXTENSION_DUPLICATE_OUTPUT_PARAM'
     */
    const VALUE_SCREENFIELD_EXTENSION_DUPLICATE_OUTPUT_PARAM = 'SCREENFIELD_EXTENSION_DUPLICATE_OUTPUT_PARAM';
    /**
     * Constant for value 'SCREENFIELD_EXTENSION_IMPLEMENTATION_INVALID'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, extensionName
     * @return string 'SCREENFIELD_EXTENSION_IMPLEMENTATION_INVALID'
     */
    const VALUE_SCREENFIELD_EXTENSION_IMPLEMENTATION_INVALID = 'SCREENFIELD_EXTENSION_IMPLEMENTATION_INVALID';
    /**
     * Constant for value 'SCREENFIELD_EXTENSION_INPUT_ATTRIBUTE_INVALID'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, extensionName, parameterName
     * @return string 'SCREENFIELD_EXTENSION_INPUT_ATTRIBUTE_INVALID'
     */
    const VALUE_SCREENFIELD_EXTENSION_INPUT_ATTRIBUTE_INVALID = 'SCREENFIELD_EXTENSION_INPUT_ATTRIBUTE_INVALID';
    /**
     * Constant for value 'SCREENFIELD_EXTENSION_NAME_INVALID'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, extensionName
     * @return string 'SCREENFIELD_EXTENSION_NAME_INVALID'
     */
    const VALUE_SCREENFIELD_EXTENSION_NAME_INVALID = 'SCREENFIELD_EXTENSION_NAME_INVALID';
    /**
     * Constant for value 'SCREENFIELD_EXTENSION_NAME_MISSING'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, fieldType
     * @return string 'SCREENFIELD_EXTENSION_NAME_MISSING'
     */
    const VALUE_SCREENFIELD_EXTENSION_NAME_MISSING = 'SCREENFIELD_EXTENSION_NAME_MISSING';
    /**
     * Constant for value 'SCREENFIELD_EXTENSION_NAME_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, fieldType
     * @return string 'SCREENFIELD_EXTENSION_NAME_NOT_SUPPORTED'
     */
    const VALUE_SCREENFIELD_EXTENSION_NAME_NOT_SUPPORTED = 'SCREENFIELD_EXTENSION_NAME_NOT_SUPPORTED';
    /**
     * Constant for value 'SCREENFIELD_EXTENSION_OUTPUT_ATTRIBUTE_INVALID'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, extensionName, parameterName
     * @return string 'SCREENFIELD_EXTENSION_OUTPUT_ATTRIBUTE_INVALID'
     */
    const VALUE_SCREENFIELD_EXTENSION_OUTPUT_ATTRIBUTE_INVALID = 'SCREENFIELD_EXTENSION_OUTPUT_ATTRIBUTE_INVALID';
    /**
     * Constant for value 'SCREENFIELD_EXTENSION_REQUIRED_INPUT_MISSING'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, extensionName, parameterName
     * @return string 'SCREENFIELD_EXTENSION_REQUIRED_INPUT_MISSING'
     */
    const VALUE_SCREENFIELD_EXTENSION_REQUIRED_INPUT_MISSING = 'SCREENFIELD_EXTENSION_REQUIRED_INPUT_MISSING';
    /**
     * Constant for value 'SCREENFIELD_INPUTS_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, fieldType
     * @return string 'SCREENFIELD_INPUTS_NOT_SUPPORTED'
     */
    const VALUE_SCREENFIELD_INPUTS_NOT_SUPPORTED = 'SCREENFIELD_INPUTS_NOT_SUPPORTED';
    /**
     * Constant for value 'SCREENFIELD_INVALID_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, dataType, fieldType
     * @return string 'SCREENFIELD_INVALID_DATATYPE'
     */
    const VALUE_SCREENFIELD_INVALID_DATATYPE = 'SCREENFIELD_INVALID_DATATYPE';
    /**
     * Constant for value 'SCREENFIELD_MULTISELECTCHOICE_SEMICOLON_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, choiceName
     * @return string 'SCREENFIELD_MULTISELECTCHOICE_SEMICOLON_NOT_SUPPORTED'
     */
    const VALUE_SCREENFIELD_MULTISELECTCHOICE_SEMICOLON_NOT_SUPPORTED = 'SCREENFIELD_MULTISELECTCHOICE_SEMICOLON_NOT_SUPPORTED';
    /**
     * Constant for value 'SCREENFIELD_OUTPUTS_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, fieldType
     * @return string 'SCREENFIELD_OUTPUTS_NOT_SUPPORTED'
     */
    const VALUE_SCREENFIELD_OUTPUTS_NOT_SUPPORTED = 'SCREENFIELD_OUTPUTS_NOT_SUPPORTED';
    /**
     * Constant for value 'SCREENFIELD_TYPE_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, fieldType
     * @return string 'SCREENFIELD_TYPE_NOT_SUPPORTED'
     */
    const VALUE_SCREENFIELD_TYPE_NOT_SUPPORTED = 'SCREENFIELD_TYPE_NOT_SUPPORTED';
    /**
     * Constant for value 'SCREENFIELD_USERINPUT_NOT_SUPPORTED_FOR_CHOICETYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, choiceName
     * @return string 'SCREENFIELD_USERINPUT_NOT_SUPPORTED_FOR_CHOICETYPE'
     */
    const VALUE_SCREENFIELD_USERINPUT_NOT_SUPPORTED_FOR_CHOICETYPE = 'SCREENFIELD_USERINPUT_NOT_SUPPORTED_FOR_CHOICETYPE';
    /**
     * Constant for value 'SCREENFIELD_VALIDATIONRULE_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'SCREENFIELD_VALIDATIONRULE_NOT_SUPPORTED'
     */
    const VALUE_SCREENFIELD_VALIDATIONRULE_NOT_SUPPORTED = 'SCREENFIELD_VALIDATIONRULE_NOT_SUPPORTED';
    /**
     * Constant for value 'SCREENRULE_ACTION_INVALID_ATTRIBUTE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, screenRuleName, attributeName
     * @return string 'SCREENRULE_ACTION_INVALID_ATTRIBUTE'
     */
    const VALUE_SCREENRULE_ACTION_INVALID_ATTRIBUTE = 'SCREENRULE_ACTION_INVALID_ATTRIBUTE';
    /**
     * Constant for value 'SCREENRULE_ACTION_INVALID_ATTRIBUTE_FOR_API_VERSION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, screenRuleName, attributeName
     * @return string 'SCREENRULE_ACTION_INVALID_ATTRIBUTE_FOR_API_VERSION'
     */
    const VALUE_SCREENRULE_ACTION_INVALID_ATTRIBUTE_FOR_API_VERSION = 'SCREENRULE_ACTION_INVALID_ATTRIBUTE_FOR_API_VERSION';
    /**
     * Constant for value 'SCREENRULE_ACTION_INVALID_VALUE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, screenRuleName, acceptedValues, actionValue
     * @return string 'SCREENRULE_ACTION_INVALID_VALUE'
     */
    const VALUE_SCREENRULE_ACTION_INVALID_VALUE = 'SCREENRULE_ACTION_INVALID_VALUE';
    /**
     * Constant for value 'SCREENRULE_ACTION_MISSING_ATTRIBUTE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, screenRuleName
     * @return string 'SCREENRULE_ACTION_MISSING_ATTRIBUTE'
     */
    const VALUE_SCREENRULE_ACTION_MISSING_ATTRIBUTE = 'SCREENRULE_ACTION_MISSING_ATTRIBUTE';
    /**
     * Constant for value 'SCREENRULE_ACTION_MISSING_FIELDREFERENCE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, screenRuleName
     * @return string 'SCREENRULE_ACTION_MISSING_FIELDREFERENCE'
     */
    const VALUE_SCREENRULE_ACTION_MISSING_FIELDREFERENCE = 'SCREENRULE_ACTION_MISSING_FIELDREFERENCE';
    /**
     * Constant for value 'SCREENRULE_ACTION_MISSING_VALUE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, screenRuleName
     * @return string 'SCREENRULE_ACTION_MISSING_VALUE'
     */
    const VALUE_SCREENRULE_ACTION_MISSING_VALUE = 'SCREENRULE_ACTION_MISSING_VALUE';
    /**
     * Constant for value 'SCREENRULE_ATTRIBUTE_NOT_SUPPORTED_FOR_SCREENFIELD'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, screenRuleName, attributeName, fieldName
     * @return string 'SCREENRULE_ATTRIBUTE_NOT_SUPPORTED_FOR_SCREENFIELD'
     */
    const VALUE_SCREENRULE_ATTRIBUTE_NOT_SUPPORTED_FOR_SCREENFIELD = 'SCREENRULE_ATTRIBUTE_NOT_SUPPORTED_FOR_SCREENFIELD';
    /**
     * Constant for value 'SCREENRULE_FIELD_NOT_FOUND_ON_SCREEN'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, screenRuleName, fieldValue
     * @return string 'SCREENRULE_FIELD_NOT_FOUND_ON_SCREEN'
     */
    const VALUE_SCREENRULE_FIELD_NOT_FOUND_ON_SCREEN = 'SCREENRULE_FIELD_NOT_FOUND_ON_SCREEN';
    /**
     * Constant for value 'SCREENRULE_MISSING_ACTION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, screenRuleName
     * @return string 'SCREENRULE_MISSING_ACTION'
     */
    const VALUE_SCREENRULE_MISSING_ACTION = 'SCREENRULE_MISSING_ACTION';
    /**
     * Constant for value 'SCREENRULE_NOT_SUPPORTED_IN_ORG'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'SCREENRULE_NOT_SUPPORTED_IN_ORG'
     */
    const VALUE_SCREENRULE_NOT_SUPPORTED_IN_ORG = 'SCREENRULE_NOT_SUPPORTED_IN_ORG';
    /**
     * Constant for value 'SCREENRULE_SCREENFIELD_NOT_VISIBLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName
     * @return string 'SCREENRULE_SCREENFIELD_NOT_VISIBLE'
     */
    const VALUE_SCREENRULE_SCREENFIELD_NOT_VISIBLE = 'SCREENRULE_SCREENFIELD_NOT_VISIBLE';
    /**
     * Constant for value 'SCREENRULE_VISIBILITY_NOT_SUPPORTED_IN_ORG'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'SCREENRULE_VISIBILITY_NOT_SUPPORTED_IN_ORG'
     */
    const VALUE_SCREENRULE_VISIBILITY_NOT_SUPPORTED_IN_ORG = 'SCREENRULE_VISIBILITY_NOT_SUPPORTED_IN_ORG';
    /**
     * Constant for value 'SCREEN_ALLOWBACK_ALLOWFINISH_BOTH_FALSE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'SCREEN_ALLOWBACK_ALLOWFINISH_BOTH_FALSE'
     */
    const VALUE_SCREEN_ALLOWBACK_ALLOWFINISH_BOTH_FALSE = 'SCREEN_ALLOWBACK_ALLOWFINISH_BOTH_FALSE';
    /**
     * Constant for value 'SCREEN_CONTAINS_LIGHTNING_COMPONENT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'SCREEN_CONTAINS_LIGHTNING_COMPONENT'
     */
    const VALUE_SCREEN_CONTAINS_LIGHTNING_COMPONENT = 'SCREEN_CONTAINS_LIGHTNING_COMPONENT';
    /**
     * Constant for value 'SCREEN_MISSING_FOOTER_AND_LIGHTNING_COMPONENT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'SCREEN_MISSING_FOOTER_AND_LIGHTNING_COMPONENT'
     */
    const VALUE_SCREEN_MISSING_FOOTER_AND_LIGHTNING_COMPONENT = 'SCREEN_MISSING_FOOTER_AND_LIGHTNING_COMPONENT';
    /**
     * Constant for value 'SCREEN_MISSING_LABEL'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, characterLimit
     * @return string 'SCREEN_MISSING_LABEL'
     */
    const VALUE_SCREEN_MISSING_LABEL = 'SCREEN_MISSING_LABEL';
    /**
     * Constant for value
     * 'SCREEN_MULTISELECTFIELD_DOESNT_SUPPORT_CHOICE_WITH_USERINPUT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, choiceName
     * @return string 'SCREEN_MULTISELECTFIELD_DOESNT_SUPPORT_CHOICE_WITH_USERINPUT'
     */
    const VALUE_SCREEN_MULTISELECTFIELD_DOESNT_SUPPORT_CHOICE_WITH_USERINPUT = 'SCREEN_MULTISELECTFIELD_DOESNT_SUPPORT_CHOICE_WITH_USERINPUT';
    /**
     * Constant for value 'SCREEN_PAUSEDTEXT_NOT_SHOWN_WHEN_ALLOWPAUSE_IS_FALSE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName
     * @return string 'SCREEN_PAUSEDTEXT_NOT_SHOWN_WHEN_ALLOWPAUSE_IS_FALSE'
     */
    const VALUE_SCREEN_PAUSEDTEXT_NOT_SHOWN_WHEN_ALLOWPAUSE_IS_FALSE = 'SCREEN_PAUSEDTEXT_NOT_SHOWN_WHEN_ALLOWPAUSE_IS_FALSE';
    /**
     * Constant for value 'SETTING_FIELD_MAKES_OTHER_FIELD_REQUIRED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, requiredField
     * @return string 'SETTING_FIELD_MAKES_OTHER_FIELD_REQUIRED'
     */
    const VALUE_SETTING_FIELD_MAKES_OTHER_FIELD_REQUIRED = 'SETTING_FIELD_MAKES_OTHER_FIELD_REQUIRED';
    /**
     * Constant for value 'SETTING_FIELD_MAKES_OTHER_FIELD_UNSUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, otherFieldName
     * @return string 'SETTING_FIELD_MAKES_OTHER_FIELD_UNSUPPORTED'
     */
    const VALUE_SETTING_FIELD_MAKES_OTHER_FIELD_UNSUPPORTED = 'SETTING_FIELD_MAKES_OTHER_FIELD_UNSUPPORTED';
    /**
     * Constant for value 'SOBJECT_ELEMENT_INCOMPATIBLE_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, fieldValue
     * @return string 'SOBJECT_ELEMENT_INCOMPATIBLE_DATATYPE'
     */
    const VALUE_SOBJECT_ELEMENT_INCOMPATIBLE_DATATYPE = 'SOBJECT_ELEMENT_INCOMPATIBLE_DATATYPE';
    /**
     * Constant for value 'SOBJECT_ELEMENT_MISMATCHED_OBJECTTYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectType, sobjectName
     * @return string 'SOBJECT_ELEMENT_MISMATCHED_OBJECTTYPE'
     */
    const VALUE_SOBJECT_ELEMENT_MISMATCHED_OBJECTTYPE = 'SOBJECT_ELEMENT_MISMATCHED_OBJECTTYPE';
    /**
     * Constant for value 'SORT_ENCRYPTED_FIELDS_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, objectType
     * @return string 'SORT_ENCRYPTED_FIELDS_NOT_SUPPORTED'
     */
    const VALUE_SORT_ENCRYPTED_FIELDS_NOT_SUPPORTED = 'SORT_ENCRYPTED_FIELDS_NOT_SUPPORTED';
    /**
     * Constant for value 'SORT_FIELD_MISSING'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, sortOrder
     * @return string 'SORT_FIELD_MISSING'
     */
    const VALUE_SORT_FIELD_MISSING = 'SORT_FIELD_MISSING';
    /**
     * Constant for value 'SORT_FIELD_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, objectName
     * @return string 'SORT_FIELD_NOT_SUPPORTED'
     */
    const VALUE_SORT_FIELD_NOT_SUPPORTED = 'SORT_FIELD_NOT_SUPPORTED';
    /**
     * Constant for value 'SORT_GEOLOCATION_FIELDS_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, objectName
     * @return string 'SORT_GEOLOCATION_FIELDS_NOT_SUPPORTED'
     */
    const VALUE_SORT_GEOLOCATION_FIELDS_NOT_SUPPORTED = 'SORT_GEOLOCATION_FIELDS_NOT_SUPPORTED';
    /**
     * Constant for value 'SORT_LIMIT_INVALID'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, maxLimit
     * @return string 'SORT_LIMIT_INVALID'
     */
    const VALUE_SORT_LIMIT_INVALID = 'SORT_LIMIT_INVALID';
    /**
     * Constant for value 'SORT_ORDER_MISSING'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName
     * @return string 'SORT_ORDER_MISSING'
     */
    const VALUE_SORT_ORDER_MISSING = 'SORT_ORDER_MISSING';
    /**
     * Constant for value 'SPECIFIC_FIELD_VALUE_MAKES_OTHER_FIELD_REQUIRED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, fieldType, requiedField
     * @return string 'SPECIFIC_FIELD_VALUE_MAKES_OTHER_FIELD_REQUIRED'
     */
    const VALUE_SPECIFIC_FIELD_VALUE_MAKES_OTHER_FIELD_REQUIRED = 'SPECIFIC_FIELD_VALUE_MAKES_OTHER_FIELD_REQUIRED';
    /**
     * Constant for value 'STAGE_NAME_NOT_FULLY_QUALIFIED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, parameterName
     * @return string 'STAGE_NAME_NOT_FULLY_QUALIFIED'
     */
    const VALUE_STAGE_NAME_NOT_FULLY_QUALIFIED = 'STAGE_NAME_NOT_FULLY_QUALIFIED';
    /**
     * Constant for value 'START_ELEMENT_MISSING'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'START_ELEMENT_MISSING'
     */
    const VALUE_START_ELEMENT_MISSING = 'START_ELEMENT_MISSING';
    /**
     * Constant for value 'SUBFLOW_DESKTOP_DESIGNER_FLOWS_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, flowName
     * @return string 'SUBFLOW_DESKTOP_DESIGNER_FLOWS_NOT_SUPPORTED'
     */
    const VALUE_SUBFLOW_DESKTOP_DESIGNER_FLOWS_NOT_SUPPORTED = 'SUBFLOW_DESKTOP_DESIGNER_FLOWS_NOT_SUPPORTED';
    /**
     * Constant for value 'SUBFLOW_INPUT_ELEMENT_INCOMPATIBLE_DATATYPES'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, inputAssignmentNames
     * @return string 'SUBFLOW_INPUT_ELEMENT_INCOMPATIBLE_DATATYPES'
     */
    const VALUE_SUBFLOW_INPUT_ELEMENT_INCOMPATIBLE_DATATYPES = 'SUBFLOW_INPUT_ELEMENT_INCOMPATIBLE_DATATYPES';
    /**
     * Constant for value 'SUBFLOW_INPUT_INVALID_VALUE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, inputAssignmentNames
     * @return string 'SUBFLOW_INPUT_INVALID_VALUE'
     */
    const VALUE_SUBFLOW_INPUT_INVALID_VALUE = 'SUBFLOW_INPUT_INVALID_VALUE';
    /**
     * Constant for value 'SUBFLOW_INPUT_MISMATCHED_COLLECTIONTYPES'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, inputParameterNames
     * @return string 'SUBFLOW_INPUT_MISMATCHED_COLLECTIONTYPES'
     */
    const VALUE_SUBFLOW_INPUT_MISMATCHED_COLLECTIONTYPES = 'SUBFLOW_INPUT_MISMATCHED_COLLECTIONTYPES';
    /**
     * Constant for value 'SUBFLOW_INPUT_MISMATCHED_OBJECTS'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, inputParameterNames
     * @return string 'SUBFLOW_INPUT_MISMATCHED_OBJECTS'
     */
    const VALUE_SUBFLOW_INPUT_MISMATCHED_OBJECTS = 'SUBFLOW_INPUT_MISMATCHED_OBJECTS';
    /**
     * Constant for value 'SUBFLOW_INPUT_MISSING_NAME'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName
     * @return string 'SUBFLOW_INPUT_MISSING_NAME'
     */
    const VALUE_SUBFLOW_INPUT_MISSING_NAME = 'SUBFLOW_INPUT_MISSING_NAME';
    /**
     * Constant for value 'SUBFLOW_INPUT_MULTIPLE_ASSIGNMENTS_TO_ONE_VARIABLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, inputVariableName
     * @return string 'SUBFLOW_INPUT_MULTIPLE_ASSIGNMENTS_TO_ONE_VARIABLE'
     */
    const VALUE_SUBFLOW_INPUT_MULTIPLE_ASSIGNMENTS_TO_ONE_VARIABLE = 'SUBFLOW_INPUT_MULTIPLE_ASSIGNMENTS_TO_ONE_VARIABLE';
    /**
     * Constant for value 'SUBFLOW_INPUT_REFERENCES_FIELD_ON_SOBJECT_VARIABLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, inputVariableName
     * @return string 'SUBFLOW_INPUT_REFERENCES_FIELD_ON_SOBJECT_VARIABLE'
     */
    const VALUE_SUBFLOW_INPUT_REFERENCES_FIELD_ON_SOBJECT_VARIABLE = 'SUBFLOW_INPUT_REFERENCES_FIELD_ON_SOBJECT_VARIABLE';
    /**
     * Constant for value 'SUBFLOW_INPUT_VALUE_INCOMPATIBLE_DATATYPES'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, inputAssignmentNames
     * @return string 'SUBFLOW_INPUT_VALUE_INCOMPATIBLE_DATATYPES'
     */
    const VALUE_SUBFLOW_INPUT_VALUE_INCOMPATIBLE_DATATYPES = 'SUBFLOW_INPUT_VALUE_INCOMPATIBLE_DATATYPES';
    /**
     * Constant for value 'SUBFLOW_INPUT_VARIABLE_NOT_FOUND_IN_MASTERFLOW'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, inputAssignmentNames
     * @return string 'SUBFLOW_INPUT_VARIABLE_NOT_FOUND_IN_MASTERFLOW'
     */
    const VALUE_SUBFLOW_INPUT_VARIABLE_NOT_FOUND_IN_MASTERFLOW = 'SUBFLOW_INPUT_VARIABLE_NOT_FOUND_IN_MASTERFLOW';
    /**
     * Constant for value 'SUBFLOW_INPUT_VARIABLE_NOT_FOUND_IN_REFERENCEDFLOW'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, inputAssignmentNames
     * @return string 'SUBFLOW_INPUT_VARIABLE_NOT_FOUND_IN_REFERENCEDFLOW'
     */
    const VALUE_SUBFLOW_INPUT_VARIABLE_NOT_FOUND_IN_REFERENCEDFLOW = 'SUBFLOW_INPUT_VARIABLE_NOT_FOUND_IN_REFERENCEDFLOW';
    /**
     * Constant for value 'SUBFLOW_INPUT_VARIABLE_NO_INPUT_ACCESS'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, inputAssignmentNames
     * @return string 'SUBFLOW_INPUT_VARIABLE_NO_INPUT_ACCESS'
     */
    const VALUE_SUBFLOW_INPUT_VARIABLE_NO_INPUT_ACCESS = 'SUBFLOW_INPUT_VARIABLE_NO_INPUT_ACCESS';
    /**
     * Constant for value 'SUBFLOW_INVALID_NAME'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'SUBFLOW_INVALID_NAME'
     */
    const VALUE_SUBFLOW_INVALID_NAME = 'SUBFLOW_INVALID_NAME';
    /**
     * Constant for value 'SUBFLOW_INVALID_REFERENCE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, flowName
     * @return string 'SUBFLOW_INVALID_REFERENCE'
     */
    const VALUE_SUBFLOW_INVALID_REFERENCE = 'SUBFLOW_INVALID_REFERENCE';
    /**
     * Constant for value 'SUBFLOW_MASTER_FLOW_TYPE_NOT_AUTOLAUNCHED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, parentFlowName
     * @return string 'SUBFLOW_MASTER_FLOW_TYPE_NOT_AUTOLAUNCHED'
     */
    const VALUE_SUBFLOW_MASTER_FLOW_TYPE_NOT_AUTOLAUNCHED = 'SUBFLOW_MASTER_FLOW_TYPE_NOT_AUTOLAUNCHED';
    /**
     * Constant for value 'SUBFLOW_MISSING_NAME'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'SUBFLOW_MISSING_NAME'
     */
    const VALUE_SUBFLOW_MISSING_NAME = 'SUBFLOW_MISSING_NAME';
    /**
     * Constant for value 'SUBFLOW_NO_ACTIVE_VERSION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, flowName
     * @return string 'SUBFLOW_NO_ACTIVE_VERSION'
     */
    const VALUE_SUBFLOW_NO_ACTIVE_VERSION = 'SUBFLOW_NO_ACTIVE_VERSION';
    /**
     * Constant for value 'SUBFLOW_OUTPUT_INCOMPATIBLE_DATATYPES'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, flowVersion, outputParameterNames
     * @return string 'SUBFLOW_OUTPUT_INCOMPATIBLE_DATATYPES'
     */
    const VALUE_SUBFLOW_OUTPUT_INCOMPATIBLE_DATATYPES = 'SUBFLOW_OUTPUT_INCOMPATIBLE_DATATYPES';
    /**
     * Constant for value 'SUBFLOW_OUTPUT_MISMATCHED_COLLECTIONTYPES'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, flowVersion, outputParameterNames
     * @return string 'SUBFLOW_OUTPUT_MISMATCHED_COLLECTIONTYPES'
     */
    const VALUE_SUBFLOW_OUTPUT_MISMATCHED_COLLECTIONTYPES = 'SUBFLOW_OUTPUT_MISMATCHED_COLLECTIONTYPES';
    /**
     * Constant for value 'SUBFLOW_OUTPUT_MISMATCHED_OBJECTS'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, flowVersion, outputParameterNames
     * @return string 'SUBFLOW_OUTPUT_MISMATCHED_OBJECTS'
     */
    const VALUE_SUBFLOW_OUTPUT_MISMATCHED_OBJECTS = 'SUBFLOW_OUTPUT_MISMATCHED_OBJECTS';
    /**
     * Constant for value 'SUBFLOW_OUTPUT_MISSING_ASSIGNTOREFERENCE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, outputAssignment
     * @return string 'SUBFLOW_OUTPUT_MISSING_ASSIGNTOREFERENCE'
     */
    const VALUE_SUBFLOW_OUTPUT_MISSING_ASSIGNTOREFERENCE = 'SUBFLOW_OUTPUT_MISSING_ASSIGNTOREFERENCE';
    /**
     * Constant for value 'SUBFLOW_OUTPUT_MISSING_NAME'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName
     * @return string 'SUBFLOW_OUTPUT_MISSING_NAME'
     */
    const VALUE_SUBFLOW_OUTPUT_MISSING_NAME = 'SUBFLOW_OUTPUT_MISSING_NAME';
    /**
     * Constant for value 'SUBFLOW_OUTPUT_MULTIPLE_ASSIGNMENTS_TO_ONE_VARIABLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, outputVariableName
     * @return string 'SUBFLOW_OUTPUT_MULTIPLE_ASSIGNMENTS_TO_ONE_VARIABLE'
     */
    const VALUE_SUBFLOW_OUTPUT_MULTIPLE_ASSIGNMENTS_TO_ONE_VARIABLE = 'SUBFLOW_OUTPUT_MULTIPLE_ASSIGNMENTS_TO_ONE_VARIABLE';
    /**
     * Constant for value 'SUBFLOW_OUTPUT_REFERENCES_FIELD_ON_SOBJECT_VARIABLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, outputAssignment
     * @return string 'SUBFLOW_OUTPUT_REFERENCES_FIELD_ON_SOBJECT_VARIABLE'
     */
    const VALUE_SUBFLOW_OUTPUT_REFERENCES_FIELD_ON_SOBJECT_VARIABLE = 'SUBFLOW_OUTPUT_REFERENCES_FIELD_ON_SOBJECT_VARIABLE';
    /**
     * Constant for value 'SUBFLOW_OUTPUT_TARGET_DOES_NOT_EXIST_IN_MASTER_FLOW'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, outputAssignmentName
     * @return string 'SUBFLOW_OUTPUT_TARGET_DOES_NOT_EXIST_IN_MASTER_FLOW'
     */
    const VALUE_SUBFLOW_OUTPUT_TARGET_DOES_NOT_EXIST_IN_MASTER_FLOW = 'SUBFLOW_OUTPUT_TARGET_DOES_NOT_EXIST_IN_MASTER_FLOW';
    /**
     * Constant for value 'SUBFLOW_OUTPUT_VARIABLE_NOT_FOUND_IN_MASTERFLOW'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, variableName
     * @return string 'SUBFLOW_OUTPUT_VARIABLE_NOT_FOUND_IN_MASTERFLOW'
     */
    const VALUE_SUBFLOW_OUTPUT_VARIABLE_NOT_FOUND_IN_MASTERFLOW = 'SUBFLOW_OUTPUT_VARIABLE_NOT_FOUND_IN_MASTERFLOW';
    /**
     * Constant for value 'SUBFLOW_OUTPUT_VARIABLE_NOT_FOUND_IN_REFERENCEDFLOW'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, flowVersion, outputParameterNames
     * @return string 'SUBFLOW_OUTPUT_VARIABLE_NOT_FOUND_IN_REFERENCEDFLOW'
     */
    const VALUE_SUBFLOW_OUTPUT_VARIABLE_NOT_FOUND_IN_REFERENCEDFLOW = 'SUBFLOW_OUTPUT_VARIABLE_NOT_FOUND_IN_REFERENCEDFLOW';
    /**
     * Constant for value 'SUBFLOW_OUTPUT_VARIABLE_NO_OUTPUT_ACCESS'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, variableName
     * @return string 'SUBFLOW_OUTPUT_VARIABLE_NO_OUTPUT_ACCESS'
     */
    const VALUE_SUBFLOW_OUTPUT_VARIABLE_NO_OUTPUT_ACCESS = 'SUBFLOW_OUTPUT_VARIABLE_NO_OUTPUT_ACCESS';
    /**
     * Constant for value 'SUBFLOW_PROCESSTYPE_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, processType, subflowElementName, subflowName, subflowProcessType
     * @return string 'SUBFLOW_PROCESSTYPE_NOT_SUPPORTED'
     */
    const VALUE_SUBFLOW_PROCESSTYPE_NOT_SUPPORTED = 'SUBFLOW_PROCESSTYPE_NOT_SUPPORTED';
    /**
     * Constant for value 'SUBFLOW_PROCESS_TYPE_INCOMPATIBLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName, flowName, processType
     * @return string 'SUBFLOW_PROCESS_TYPE_INCOMPATIBLE'
     */
    const VALUE_SUBFLOW_PROCESS_TYPE_INCOMPATIBLE = 'SUBFLOW_PROCESS_TYPE_INCOMPATIBLE';
    /**
     * Constant for value 'SUBFLOW_REFERENCES_MASTERFLOW'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'SUBFLOW_REFERENCES_MASTERFLOW'
     */
    const VALUE_SUBFLOW_REFERENCES_MASTERFLOW = 'SUBFLOW_REFERENCES_MASTERFLOW';
    /**
     * Constant for value 'SURVEY_ADVANCED_CONDITION_LOGIC_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'SURVEY_ADVANCED_CONDITION_LOGIC_NOT_SUPPORTED'
     */
    const VALUE_SURVEY_ADVANCED_CONDITION_LOGIC_NOT_SUPPORTED = 'SURVEY_ADVANCED_CONDITION_LOGIC_NOT_SUPPORTED';
    /**
     * Constant for value 'SURVEY_CHOICE_NOT_REFERENCED_BY_A_QUESTION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, choiceName
     * @return string 'SURVEY_CHOICE_NOT_REFERENCED_BY_A_QUESTION'
     */
    const VALUE_SURVEY_CHOICE_NOT_REFERENCED_BY_A_QUESTION = 'SURVEY_CHOICE_NOT_REFERENCED_BY_A_QUESTION';
    /**
     * Constant for value 'SURVEY_CHOICE_REFERENCED_BY_MULTIPLE_QUESTIONS'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, choiceName
     * @return string 'SURVEY_CHOICE_REFERENCED_BY_MULTIPLE_QUESTIONS'
     */
    const VALUE_SURVEY_CHOICE_REFERENCED_BY_MULTIPLE_QUESTIONS = 'SURVEY_CHOICE_REFERENCED_BY_MULTIPLE_QUESTIONS';
    /**
     * Constant for value 'SURVEY_ELEMENT_NEVER_REACHED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'SURVEY_ELEMENT_NEVER_REACHED'
     */
    const VALUE_SURVEY_ELEMENT_NEVER_REACHED = 'SURVEY_ELEMENT_NEVER_REACHED';
    /**
     * Constant for value 'SURVEY_INACTIVE_SUBFLOWS'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName
     * @return string 'SURVEY_INACTIVE_SUBFLOWS'
     */
    const VALUE_SURVEY_INACTIVE_SUBFLOWS = 'SURVEY_INACTIVE_SUBFLOWS';
    /**
     * Constant for value 'SURVEY_MISSING_QUESTION_OR_SUBFLOW'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, surveyName
     * @return string 'SURVEY_MISSING_QUESTION_OR_SUBFLOW'
     */
    const VALUE_SURVEY_MISSING_QUESTION_OR_SUBFLOW = 'SURVEY_MISSING_QUESTION_OR_SUBFLOW';
    /**
     * Constant for value 'SURVEY_MISSING_REQUIRED_VARIABLES'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, surveyName
     * @return string 'SURVEY_MISSING_REQUIRED_VARIABLES'
     */
    const VALUE_SURVEY_MISSING_REQUIRED_VARIABLES = 'SURVEY_MISSING_REQUIRED_VARIABLES';
    /**
     * Constant for value 'SURVEY_MULTIPLE_SCREENS_CANNOT_CONNECT_TO_SAME_DECISION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, flowDecision
     * @return string 'SURVEY_MULTIPLE_SCREENS_CANNOT_CONNECT_TO_SAME_DECISION'
     */
    const VALUE_SURVEY_MULTIPLE_SCREENS_CANNOT_CONNECT_TO_SAME_DECISION = 'SURVEY_MULTIPLE_SCREENS_CANNOT_CONNECT_TO_SAME_DECISION';
    /**
     * Constant for value 'SURVEY_NESTED_SUBFLOWS'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName
     * @return string 'SURVEY_NESTED_SUBFLOWS'
     */
    const VALUE_SURVEY_NESTED_SUBFLOWS = 'SURVEY_NESTED_SUBFLOWS';
    /**
     * Constant for value 'SURVEY_NONSURVEY_SUBFLOWS'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, subflowName
     * @return string 'SURVEY_NONSURVEY_SUBFLOWS'
     */
    const VALUE_SURVEY_NONSURVEY_SUBFLOWS = 'SURVEY_NONSURVEY_SUBFLOWS';
    /**
     * Constant for value 'SURVEY_RULE_INVALID_RIGHT_OPERAND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'SURVEY_RULE_INVALID_RIGHT_OPERAND'
     */
    const VALUE_SURVEY_RULE_INVALID_RIGHT_OPERAND = 'SURVEY_RULE_INVALID_RIGHT_OPERAND';
    /**
     * Constant for value 'SURVEY_SCREENFIELD_TYPE_NOT_SUPPORTED_FOR_QUESTION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'SURVEY_SCREENFIELD_TYPE_NOT_SUPPORTED_FOR_QUESTION'
     */
    const VALUE_SURVEY_SCREENFIELD_TYPE_NOT_SUPPORTED_FOR_QUESTION = 'SURVEY_SCREENFIELD_TYPE_NOT_SUPPORTED_FOR_QUESTION';
    /**
     * Constant for value 'SURVEY_START_ELEMENT_INVALID'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'SURVEY_START_ELEMENT_INVALID'
     */
    const VALUE_SURVEY_START_ELEMENT_INVALID = 'SURVEY_START_ELEMENT_INVALID';
    /**
     * Constant for value 'SURVEY_VARIABLE_ACCESS_INVALID'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, surveyName
     * @return string 'SURVEY_VARIABLE_ACCESS_INVALID'
     */
    const VALUE_SURVEY_VARIABLE_ACCESS_INVALID = 'SURVEY_VARIABLE_ACCESS_INVALID';
    /**
     * Constant for value 'UNEXPECTED_ERROR'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'UNEXPECTED_ERROR'
     */
    const VALUE_UNEXPECTED_ERROR = 'UNEXPECTED_ERROR';
    /**
     * Constant for value 'VALUE_CHAR_LIMIT_EXCEEDED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName, characterLimit
     * @return string 'VALUE_CHAR_LIMIT_EXCEEDED'
     */
    const VALUE_VALUE_CHAR_LIMIT_EXCEEDED = 'VALUE_CHAR_LIMIT_EXCEEDED';
    /**
     * Constant for value 'VARIABLE_FIELD_NOT_SUPPORTED_FOR_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, datatype
     * @return string 'VARIABLE_FIELD_NOT_SUPPORTED_FOR_DATATYPE'
     */
    const VALUE_VARIABLE_FIELD_NOT_SUPPORTED_FOR_DATATYPE = 'VARIABLE_FIELD_NOT_SUPPORTED_FOR_DATATYPE';
    /**
     * Constant for value 'VARIABLE_FIELD_NOT_SUPPORTED_FOR_DATATYPE_AND_COLLECTION'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, fieldName, datatype
     * @return string 'VARIABLE_FIELD_NOT_SUPPORTED_FOR_DATATYPE_AND_COLLECTION'
     */
    const VALUE_VARIABLE_FIELD_NOT_SUPPORTED_FOR_DATATYPE_AND_COLLECTION = 'VARIABLE_FIELD_NOT_SUPPORTED_FOR_DATATYPE_AND_COLLECTION';
    /**
     * Constant for value 'VARIABLE_FIELD_REQUIRED_FOR_DATATYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, datatype, fieldName
     * @return string 'VARIABLE_FIELD_REQUIRED_FOR_DATATYPE'
     */
    const VALUE_VARIABLE_FIELD_REQUIRED_FOR_DATATYPE = 'VARIABLE_FIELD_REQUIRED_FOR_DATATYPE';
    /**
     * Constant for value 'VARIABLE_SCALE_EXCEEDS_LIMIT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'VARIABLE_SCALE_EXCEEDS_LIMIT'
     */
    const VALUE_VARIABLE_SCALE_EXCEEDS_LIMIT = 'VARIABLE_SCALE_EXCEEDS_LIMIT';
    /**
     * Constant for value 'VARIABLE_SCALE_NEGATIVE_INTEGER'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'VARIABLE_SCALE_NEGATIVE_INTEGER'
     */
    const VALUE_VARIABLE_SCALE_NEGATIVE_INTEGER = 'VARIABLE_SCALE_NEGATIVE_INTEGER';
    /**
     * Constant for value 'VARIABLE_SCALE_NULL'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'VARIABLE_SCALE_NULL'
     */
    const VALUE_VARIABLE_SCALE_NULL = 'VARIABLE_SCALE_NULL';
    /**
     * Constant for value 'VISIBILITY_RULE_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'VISIBILITY_RULE_NOT_SUPPORTED'
     */
    const VALUE_VISIBILITY_RULE_NOT_SUPPORTED = 'VISIBILITY_RULE_NOT_SUPPORTED';
    /**
     * Constant for value 'WAITEVENT_DEFAULT_CONNECTOR_MISSING_LABEL'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, waitEventName
     * @return string 'WAITEVENT_DEFAULT_CONNECTOR_MISSING_LABEL'
     */
    const VALUE_WAITEVENT_DEFAULT_CONNECTOR_MISSING_LABEL = 'WAITEVENT_DEFAULT_CONNECTOR_MISSING_LABEL';
    /**
     * Constant for value 'WAITEVENT_DUPLICATE_INPUT_PARAM'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, parameterName
     * @return string 'WAITEVENT_DUPLICATE_INPUT_PARAM'
     */
    const VALUE_WAITEVENT_DUPLICATE_INPUT_PARAM = 'WAITEVENT_DUPLICATE_INPUT_PARAM';
    /**
     * Constant for value 'WAITEVENT_INPUT_NOT_SUPPORTED_FOR_EVENTTYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, waitEventName, inputParameterName
     * @return string 'WAITEVENT_INPUT_NOT_SUPPORTED_FOR_EVENTTYPE'
     */
    const VALUE_WAITEVENT_INPUT_NOT_SUPPORTED_FOR_EVENTTYPE = 'WAITEVENT_INPUT_NOT_SUPPORTED_FOR_EVENTTYPE';
    /**
     * Constant for value 'WAITEVENT_INPUT_REQUIRES_LITERAL_VALUE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, waitEventName, parameterName
     * @return string 'WAITEVENT_INPUT_REQUIRES_LITERAL_VALUE'
     */
    const VALUE_WAITEVENT_INPUT_REQUIRES_LITERAL_VALUE = 'WAITEVENT_INPUT_REQUIRES_LITERAL_VALUE';
    /**
     * Constant for value 'WAITEVENT_INVALID_CONDITION_LOGIC'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, waitEventName
     * @return string 'WAITEVENT_INVALID_CONDITION_LOGIC'
     */
    const VALUE_WAITEVENT_INVALID_CONDITION_LOGIC = 'WAITEVENT_INVALID_CONDITION_LOGIC';
    /**
     * Constant for value 'WAITEVENT_MISSING'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'WAITEVENT_MISSING'
     */
    const VALUE_WAITEVENT_MISSING = 'WAITEVENT_MISSING';
    /**
     * Constant for value 'WAITEVENT_MISSING_CONNECTOR'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, waitEventName
     * @return string 'WAITEVENT_MISSING_CONNECTOR'
     */
    const VALUE_WAITEVENT_MISSING_CONNECTOR = 'WAITEVENT_MISSING_CONNECTOR';
    /**
     * Constant for value 'WAITEVENT_MISSING_EVENTTYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, waitEventName
     * @return string 'WAITEVENT_MISSING_EVENTTYPE'
     */
    const VALUE_WAITEVENT_MISSING_EVENTTYPE = 'WAITEVENT_MISSING_EVENTTYPE';
    /**
     * Constant for value 'WAITEVENT_OBJECT_NOT_SUPPORTED_FOR_EVENTTYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, waitEventName
     * @return string 'WAITEVENT_OBJECT_NOT_SUPPORTED_FOR_EVENTTYPE'
     */
    const VALUE_WAITEVENT_OBJECT_NOT_SUPPORTED_FOR_EVENTTYPE = 'WAITEVENT_OBJECT_NOT_SUPPORTED_FOR_EVENTTYPE';
    /**
     * Constant for value 'WAITEVENT_OUTPUT_NOT_SUPPORTED_FOR_EVENTTYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, waitEventName, outputParameter
     * @return string 'WAITEVENT_OUTPUT_NOT_SUPPORTED_FOR_EVENTTYPE'
     */
    const VALUE_WAITEVENT_OUTPUT_NOT_SUPPORTED_FOR_EVENTTYPE = 'WAITEVENT_OUTPUT_NOT_SUPPORTED_FOR_EVENTTYPE';
    /**
     * Constant for value 'WAITEVENT_RELATIVEALARM_INVALID_DATETIME_FIELD'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, waitEventName, eventParameterName, incompatibleValue
     * @return string 'WAITEVENT_RELATIVEALARM_INVALID_DATETIME_FIELD'
     */
    const VALUE_WAITEVENT_RELATIVEALARM_INVALID_DATETIME_FIELD = 'WAITEVENT_RELATIVEALARM_INVALID_DATETIME_FIELD';
    /**
     * Constant for value 'WAITEVENT_RELATIVEALARM_INVALID_FIELD'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, waitEventName, eventParameterName, incompatibleValue
     * @return string 'WAITEVENT_RELATIVEALARM_INVALID_FIELD'
     */
    const VALUE_WAITEVENT_RELATIVEALARM_INVALID_FIELD = 'WAITEVENT_RELATIVEALARM_INVALID_FIELD';
    /**
     * Constant for value 'WAITEVENT_RELATIVEALARM_INVALID_OBJECTTYPE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, waitEventName, inputParameterName
     * @return string 'WAITEVENT_RELATIVEALARM_INVALID_OBJECTTYPE'
     */
    const VALUE_WAITEVENT_RELATIVEALARM_INVALID_OBJECTTYPE = 'WAITEVENT_RELATIVEALARM_INVALID_OBJECTTYPE';
    /**
     * Constant for value 'WAITEVENT_RELATIVEALARM_INVALID_OFFSETNUMBER'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, waitEventName, eventParameterName, incompatibleValue
     * @return string 'WAITEVENT_RELATIVEALARM_INVALID_OFFSETNUMBER'
     */
    const VALUE_WAITEVENT_RELATIVEALARM_INVALID_OFFSETNUMBER = 'WAITEVENT_RELATIVEALARM_INVALID_OFFSETNUMBER';
    /**
     * Constant for value 'WAITEVENT_RELATIVEALARM_INVALID_OFFSETUNIT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, waitEventName, eventParameterName, incompatibleValue
     * @return string 'WAITEVENT_RELATIVEALARM_INVALID_OFFSETUNIT'
     */
    const VALUE_WAITEVENT_RELATIVEALARM_INVALID_OFFSETUNIT = 'WAITEVENT_RELATIVEALARM_INVALID_OFFSETUNIT';
    /**
     * Constant for value 'WAITEVENT_REQUIRED_INPUT_MISSING'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, waitEventName, parameterName
     * @return string 'WAITEVENT_REQUIRED_INPUT_MISSING'
     */
    const VALUE_WAITEVENT_REQUIRED_INPUT_MISSING = 'WAITEVENT_REQUIRED_INPUT_MISSING';
    /**
     * Constant for value 'WAITEVENT_TYPE_INVALID_OR_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, waitEventName
     * @return string 'WAITEVENT_TYPE_INVALID_OR_NOT_SUPPORTED'
     */
    const VALUE_WAITEVENT_TYPE_INVALID_OR_NOT_SUPPORTED = 'WAITEVENT_TYPE_INVALID_OR_NOT_SUPPORTED';
    /**
     * Constant for value 'WORKFLOW_MISSING_PROCESSMETADATAVALUES'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, flowName
     * @return string 'WORKFLOW_MISSING_PROCESSMETADATAVALUES'
     */
    const VALUE_WORKFLOW_MISSING_PROCESSMETADATAVALUES = 'WORKFLOW_MISSING_PROCESSMETADATAVALUES';
    /**
     * Constant for value 'WORKFLOW_OBJECTTYPE_NOT_FOUND'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectType
     * @return string 'WORKFLOW_OBJECTTYPE_NOT_FOUND'
     */
    const VALUE_WORKFLOW_OBJECTTYPE_NOT_FOUND = 'WORKFLOW_OBJECTTYPE_NOT_FOUND';
    /**
     * Constant for value 'WORKFLOW_OBJECTTYPE_NOT_SUPPORTED'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectType
     * @return string 'WORKFLOW_OBJECTTYPE_NOT_SUPPORTED'
     */
    const VALUE_WORKFLOW_OBJECTTYPE_NOT_SUPPORTED = 'WORKFLOW_OBJECTTYPE_NOT_SUPPORTED';
    /**
     * Constant for value
     * 'WORKFLOW_OBJECTVARIABLE_AND_OLDOBJECTVARIABLE_REFERENCE_SAME_SOBJECT_VARIABLE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectVariableName, oldObjectVariableName
     * @return string 'WORKFLOW_OBJECTVARIABLE_AND_OLDOBJECTVARIABLE_REFERENCE_SAME_SOBJECT_VARIABLE'
     */
    const VALUE_WORKFLOW_OBJECTVARIABLE_AND_OLDOBJECTVARIABLE_REFERENCE_SAME_SOBJECT_VARIABLE = 'WORKFLOW_OBJECTVARIABLE_AND_OLDOBJECTVARIABLE_REFERENCE_SAME_SOBJECT_VARIABLE';
    /**
     * Constant for value 'WORKFLOW_OBJECTVARIABLE_DOESNT_SUPPORT_INPUT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectType, objectVariableName
     * @return string 'WORKFLOW_OBJECTVARIABLE_DOESNT_SUPPORT_INPUT'
     */
    const VALUE_WORKFLOW_OBJECTVARIABLE_DOESNT_SUPPORT_INPUT = 'WORKFLOW_OBJECTVARIABLE_DOESNT_SUPPORT_INPUT';
    /**
     * Constant for value 'WORKFLOW_OLDOBJECTVARIABLE_DOESNT_SUPPORT_INPUT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, objectType, oldObjectVariableName
     * @return string 'WORKFLOW_OLDOBJECTVARIABLE_DOESNT_SUPPORT_INPUT'
     */
    const VALUE_WORKFLOW_OLDOBJECTVARIABLE_DOESNT_SUPPORT_INPUT = 'WORKFLOW_OLDOBJECTVARIABLE_DOESNT_SUPPORT_INPUT';
    /**
     * Constant for value 'WORKFLOW_PROCESSMETADATAVALUES_MORE_THAN_ONE_NAME'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, metadataValue
     * @return string 'WORKFLOW_PROCESSMETADATAVALUES_MORE_THAN_ONE_NAME'
     */
    const VALUE_WORKFLOW_PROCESSMETADATAVALUES_MORE_THAN_ONE_NAME = 'WORKFLOW_PROCESSMETADATAVALUES_MORE_THAN_ONE_NAME';
    /**
     * Constant for value 'WORKFLOW_PROCESS_METADATAVALUES_MISSING_NAME'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, metadataValue
     * @return string 'WORKFLOW_PROCESS_METADATAVALUES_MISSING_NAME'
     */
    const VALUE_WORKFLOW_PROCESS_METADATAVALUES_MISSING_NAME = 'WORKFLOW_PROCESS_METADATAVALUES_MISSING_NAME';
    /**
     * Constant for value 'WORKFLOW_RECURSIVECOUNTVARIABLE_DOESNT_SUPPORT_INPUT'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity, elementName
     * @return string 'WORKFLOW_RECURSIVECOUNTVARIABLE_DOESNT_SUPPORT_INPUT'
     */
    const VALUE_WORKFLOW_RECURSIVECOUNTVARIABLE_DOESNT_SUPPORT_INPUT = 'WORKFLOW_RECURSIVECOUNTVARIABLE_DOESNT_SUPPORT_INPUT';
    /**
     * Constant for value 'WORKFLOW_TRIGGERTYPE_INVALID_VALUE'
     * Meta informations extracted from the WSDL
     * - documentation: Errors with this extended error code have the following properties: severity
     * @return string 'WORKFLOW_TRIGGERTYPE_INVALID_VALUE'
     */
    const VALUE_WORKFLOW_TRIGGERTYPE_INVALID_VALUE = 'WORKFLOW_TRIGGERTYPE_INVALID_VALUE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIONCALL_DUPLICATE_INPUT_PARAM
     * @uses self::VALUE_ACTIONCALL_DUPLICATE_OUTPUT_PARAM
     * @uses self::VALUE_ACTIONCALL_MISSING_NAME
     * @uses self::VALUE_ACTIONCALL_MISSING_REQUIRED_PARAM
     * @uses self::VALUE_ACTIONCALL_MISSING_REQUIRED_TYPE
     * @uses self::VALUE_ACTIONCALL_NOT_FOUND_WITH_NAME_AND_TYPE
     * @uses self::VALUE_ACTIONCALL_NOT_SUPPORTED_FOR_PROCESSTYPE
     * @uses self::VALUE_APEXCALLOUT_INPUT_DUPLICATE
     * @uses self::VALUE_APEXCALLOUT_INPUT_INCOMPATIBLE_DATATYPE
     * @uses self::VALUE_APEXCALLOUT_INVALID
     * @uses self::VALUE_APEXCALLOUT_MISSING_CLASSNAME
     * @uses self::VALUE_APEXCALLOUT_NOT_FOUND
     * @uses self::VALUE_APEXCALLOUT_OUTPUT_INCOMPATIBLE_DATATYPE
     * @uses self::VALUE_APEXCALLOUT_OUTPUT_NOT_FOUND
     * @uses self::VALUE_APEXCALLOUT_REQUIRED_INPUT_MISSING
     * @uses self::VALUE_APEXCLASS_MISSING_INTERFACE
     * @uses self::VALUE_APEX_CLASS_VARIABLE_NOT_FOUND
     * @uses self::VALUE_ASSIGNMENTITEM_ELEMENT_MISSING_DATATYPE
     * @uses self::VALUE_ASSIGNMENTITEM_ELEMENT_NOT_SUPPORTED
     * @uses self::VALUE_ASSIGNMENTITEM_FIELD_INVALID_DATATYPE
     * @uses self::VALUE_ASSIGNMENTITEM_FIELD_INVALID_DATATYPE_WITH_ELEMENT
     * @uses self::VALUE_ASSIGNMENTITEM_INCOMPATIBLE_DATATYPES
     * @uses self::VALUE_ASSIGNMENTITEM_INVALID_ASSIGNTOREFERENCE
     * @uses self::VALUE_ASSIGNMENTITEM_INVALID_COLLECTION
     * @uses self::VALUE_ASSIGNMENTITEM_INVALID_DATATYPE_IN_ELEMENT
     * @uses self::VALUE_ASSIGNMENTITEM_INVALID_ELEMENTREFERENCE
     * @uses self::VALUE_ASSIGNMENTITEM_INVALID_MERGE_FIELD
     * @uses self::VALUE_ASSIGNMENTITEM_INVALID_OPERATOR
     * @uses self::VALUE_ASSIGNMENTITEM_INVALID_REFERENCE
     * @uses self::VALUE_ASSIGNMENTITEM_INVALID_VALUE
     * @uses self::VALUE_ASSIGNMENTITEM_LEFT_DATATYPE_INVALID_FOR_OPERATOR
     * @uses self::VALUE_ASSIGNMENTITEM_MODIFIES_NONVARIABLE
     * @uses self::VALUE_ASSIGNMENTITEM_NONEXISTENT_REFERENCE
     * @uses self::VALUE_ASSIGNMENTITEM_REQUIRED
     * @uses self::VALUE_ASSIGNMENTITEM_RIGHT_DATATYPE_INVALID_FOR_OPERATOR
     * @uses self::VALUE_AUTOLAUNCHED_CHOICELOOKUP_NOT_SUPPORTED
     * @uses self::VALUE_AUTOLAUNCHED_CHOICE_NOT_SUPPORTED
     * @uses self::VALUE_AUTOLAUNCHED_SCREEN_NOT_SUPPORTED
     * @uses self::VALUE_AUTOLAUNCHED_STEP_NOT_SUPPORTED
     * @uses self::VALUE_AUTOLAUNCHED_SUBFLOW_INCOMPATIBLE_FLOWTYPE
     * @uses self::VALUE_AUTOLAUNCHED_WAIT_NOT_SUPPORTED
     * @uses self::VALUE_CHOICEFIELD_DEFAULT_CHOICE_NOT_FOUND
     * @uses self::VALUE_CHOICEFIELD_MISSING_CHOICE
     * @uses self::VALUE_CHOICELOOKUP_DATATYPE_INCOMPATIBLE_WITH_CHOICEFIELD
     * @uses self::VALUE_CHOICE_DATATYPE_INCOMPATIBLE_WITH_CHOICEFIELD
     * @uses self::VALUE_CHOICE_NOT_SUPPORTED_FOR_SCREENFIELDTYPE
     * @uses self::VALUE_CHOICE_USED_MULTIPLE_TIMES_IN_SAME_FIELD
     * @uses self::VALUE_CONDITION_BUILDER_MISSING_FLOW_VARIABLE
     * @uses self::VALUE_CONDITION_BUILDER_MISSING_REQUIRED_PERMISSIONS
     * @uses self::VALUE_CONDITION_BUILDER_UNSUPPORTED_FLOW_VARIABLE
     * @uses self::VALUE_CONDITION_DATATYPE_INCOMPATIBLE
     * @uses self::VALUE_CONDITION_DATATYPE_INCOMPATIBLE_WITH_ELEMENT
     * @uses self::VALUE_CONDITION_ELEMENT_DATATYPES_INCOMPATIBLE
     * @uses self::VALUE_CONDITION_INVALID_LEFTOPERAND
     * @uses self::VALUE_CONDITION_INVALID_LEFT_ELEMENT
     * @uses self::VALUE_CONDITION_LOGIC_EXCEEDS_LIMIT
     * @uses self::VALUE_CONDITION_LOGIC_INVALID
     * @uses self::VALUE_CONDITION_LOGIC_MISSING
     * @uses self::VALUE_CONDITION_MISSING_DATATYPE
     * @uses self::VALUE_CONDITION_MISSING_OPERATOR
     * @uses self::VALUE_CONDITION_REFERENCED_ELEMENT_NOT_FOUND
     * @uses self::VALUE_CONDITION_RIGHTOPERAND_NULL
     * @uses self::VALUE_CONNECTOR_MISSING_TARGET
     * @uses self::VALUE_CONSTANT_INCLUDES_REFERENCES
     * @uses self::VALUE_CUSTOMEVENTS_NOT_ENABLED
     * @uses self::VALUE_CUSTOMEVENT_MISSING_PROCESSMETADATAVALUES
     * @uses self::VALUE_CUSTOMEVENT_OBJECTTYPE_NOT_FOUND
     * @uses self::VALUE_CUSTOMEVENT_OBJECTTYPE_NOT_SUPPORTED
     * @uses self::VALUE_CUSTOMEVENT_PROCESSMETADATAVALUES_MISSING_NAME
     * @uses self::VALUE_CUSTOMEVENT_PROCESSMETADATAVALUES_MORE_THAN_ONE_NAME
     * @uses self::VALUE_DATATYPE_INVALID
     * @uses self::VALUE_DATATYPE_MISSING
     * @uses self::VALUE_DATA_TYPE_NOT_SUPPORTED_FOR_PROCESSTYPE
     * @uses self::VALUE_DECISION_DEFAULT_CONNECTOR_MISSING_LABEL
     * @uses self::VALUE_DECISION_MISSING_OUTCOME
     * @uses self::VALUE_ELEMENT_CONNECTS_TO_SELF
     * @uses self::VALUE_ELEMENT_COORDINATES_INVALID
     * @uses self::VALUE_ELEMENT_INVALID_CONNECTOR
     * @uses self::VALUE_ELEMENT_INVALID_REFERENCE
     * @uses self::VALUE_ELEMENT_MISSING_CONNECTOR
     * @uses self::VALUE_ELEMENT_MISSING_LABEL
     * @uses self::VALUE_ELEMENT_MISSING_NAME
     * @uses self::VALUE_ELEMENT_MISSING_REFERENCE
     * @uses self::VALUE_ELEMENT_MORE_THAN_ONE_FIELD
     * @uses self::VALUE_ELEMENT_NAME_INVALID
     * @uses self::VALUE_ELEMENT_NEVER_USED
     * @uses self::VALUE_ELEMENT_SCALE_SMALLER_THAN_DEFAULTVALUE
     * @uses self::VALUE_EXTERNAL_OBJECTS_NOT_SUPPORTED
     * @uses self::VALUE_EXTERNAL_OBJECT_FIELDS_NOT_SUPPORTED
     * @uses self::VALUE_EX_AUTOLAUNCHED_SUBFLOW_INCOMPATIBLE_FLOWTYPE
     * @uses self::VALUE_FIELDASSIGNMENT_FIELD_INCOMPATIBLE_DATATYPE
     * @uses self::VALUE_FIELDASSIGNMENT_INVALID_DATATYPE
     * @uses self::VALUE_FIELDASSIGNMENT_INVALID_ELEMENT
     * @uses self::VALUE_FIELDASSIGNMENT_INVALID_REFERENCE
     * @uses self::VALUE_FIELDASSIGNMENT_MULTIPLE_REFERENCES_SAME_FIELD
     * @uses self::VALUE_FIELDASSIGNMENT_PICKLISTFIELD_INCOMPATIBLE_DATATYPE
     * @uses self::VALUE_FIELDASSIGNMENT_REFERENCED_ELEMENT_MISSING_DATATYPE
     * @uses self::VALUE_FIELDSERVICE_UNSUPPORTED_FIELD_TYPE
     * @uses self::VALUE_FIELD_INVALID_VALUE
     * @uses self::VALUE_FIELD_NOT_FOUND
     * @uses self::VALUE_FIELD_RELATIONSHIP_NOT_SUPPORTED
     * @uses self::VALUE_FLEXIPAGE_COMPONENT_ATTRIBUTE_EXPRESSION_EXCEPTION
     * @uses self::VALUE_FLEXIPAGE_COMPONENT_ATTRIBUTE_GENERIC_EXCEPTION
     * @uses self::VALUE_FLEXIPAGE_COMPONENT_ATTRIBUTE_MISSING_REQUIRED
     * @uses self::VALUE_FLEXIPAGE_COMPONENT_ATTRIBUTE_TOO_LONG
     * @uses self::VALUE_FLEXIPAGE_COMPONENT_CUSTOM_VALIDATION_EXCEPTION
     * @uses self::VALUE_FLEXIPAGE_COMPONENT_MAX_LIMIT_EXCEPTION
     * @uses self::VALUE_FLEXIPAGE_COMPONENT_RULE_VALIDATION_EXCEPTION
     * @uses self::VALUE_FLEXIPAGE_PICKLIST_INVALID_VALUE_EXCEPTION
     * @uses self::VALUE_FLEXIPAGE_TEMPLATE_INVALID_SWITCH
     * @uses self::VALUE_FLOW_ELEMENT_SCALE_LESS_THAN_ZERO
     * @uses self::VALUE_FLOW_INCLUDES_STEP
     * @uses self::VALUE_FLOW_INTERVIEW_BULK_EXECUTION
     * @uses self::VALUE_FLOW_INTERVIEW_HANDLED_ERROR
     * @uses self::VALUE_FLOW_INTERVIEW_INPUT_VALIDATION
     * @uses self::VALUE_FLOW_INTERVIEW_INTERACTION_NOT_FOUND
     * @uses self::VALUE_FLOW_INTERVIEW_INVALID_CHOICE_USER_INPUT
     * @uses self::VALUE_FLOW_INTERVIEW_INVALID_FIELD_VALUE
     * @uses self::VALUE_FLOW_INTERVIEW_INVALID_START_REQUEST
     * @uses self::VALUE_FLOW_INTERVIEW_LIMIT_EXCEEDED
     * @uses self::VALUE_FLOW_INTERVIEW_MISSING_CHOICE_FOR_REQUIRED_CHOICE_FIELD
     * @uses self::VALUE_FLOW_INTERVIEW_MISSING_VALUE_FOR_REQUIRED_INPUT_FIELD
     * @uses self::VALUE_FLOW_INTERVIEW_NAVIGATE
     * @uses self::VALUE_FLOW_INTERVIEW_RANGE_VALIDATION
     * @uses self::VALUE_FLOW_INTERVIEW_REGEX_VALIDATION
     * @uses self::VALUE_FLOW_INTERVIEW_RESUME_INTERVIEW
     * @uses self::VALUE_FLOW_INTERVIEW_SAVE_RESULT
     * @uses self::VALUE_FLOW_INTERVIEW_SET_CHOICE_SELECTED
     * @uses self::VALUE_FLOW_INTERVIEW_START_INTERVIEW
     * @uses self::VALUE_FLOW_INTERVIEW_TYPE_CONVERSION
     * @uses self::VALUE_FLOW_INVALID_NAME
     * @uses self::VALUE_FLOW_NAME_USED_IN_OTHER_CLIENT
     * @uses self::VALUE_FLOW_STAGE_INCLUDES_REFERENCES
     * @uses self::VALUE_FLOW_STAGE_ORDER_DUPLICATE
     * @uses self::VALUE_FLOW_STAGE_ORDER_OUT_OF_RANGE
     * @uses self::VALUE_FORMULA_CMT_LIMIT_EXCEEDED
     * @uses self::VALUE_FORMULA_EXPRESSION_INVALID
     * @uses self::VALUE_GLOBAL_VARIABLE_NOT_SUPPORTED_FOR_PROCESSTYPE
     * @uses self::VALUE_INPUTPARAM_INCOMPATIBLE_DATATYPE
     * @uses self::VALUE_INPUTPARAM_INCOMPATIBLE_WITH_COLLECTION_VARIABLE
     * @uses self::VALUE_INPUTPARAM_INCOMPATIBLE_WITH_NONCOLLECTION_VARIABLE
     * @uses self::VALUE_INPUTPARAM_MISMATCHED_OBJECTTYPE
     * @uses self::VALUE_INVALID_FLOW
     * @uses self::VALUE_INVALID_FLOW_INTERVIEW
     * @uses self::VALUE_INVALID_SURVEY_VARIABLE_NAME_OR_TYPE
     * @uses self::VALUE_LOOP_ASSIGNNEXTVALUETO_MISMATCHED_DATATYPE
     * @uses self::VALUE_LOOP_ASSIGNNEXTVALUETO_MISMATCHED_OBJECTTYPE
     * @uses self::VALUE_LOOP_ASSIGNNEXTVALUETO_MISSING
     * @uses self::VALUE_LOOP_ASSIGNNEXTVALUETO_MISSING_VARIABLE
     * @uses self::VALUE_LOOP_ASSIGNNEXTVALUETO_REFERENCE_NOT_FOUND
     * @uses self::VALUE_LOOP_COLLECTION_ELEMENT_NOT_FOUND
     * @uses self::VALUE_LOOP_COLLECTION_NOT_FOUND
     * @uses self::VALUE_LOOP_COLLECTION_NOT_SUPPORTED_FOR_FIELD
     * @uses self::VALUE_LOOP_MISSING_COLLECTION
     * @uses self::VALUE_OBJECTTYPE_INVALID
     * @uses self::VALUE_OBJECT_CANNOT_BE_CREATED
     * @uses self::VALUE_OBJECT_CANNOT_BE_DELETED
     * @uses self::VALUE_OBJECT_CANNOT_BE_QUERIED
     * @uses self::VALUE_OBJECT_CANNOT_BE_UPDATED
     * @uses self::VALUE_OBJECT_ENCRYPTED_FIELDS_NOT_SUPPORTED
     * @uses self::VALUE_OBJECT_NOT_FOUND
     * @uses self::VALUE_OUTPUTPARAM_ASSIGNTOREFERENCE_NOTFOUND
     * @uses self::VALUE_OUTPUTPARAM_INCOMPATIBLE_DATATYPE
     * @uses self::VALUE_OUTPUTPARAM_MISMATCHED_OBJECTTYPE
     * @uses self::VALUE_OUTPUTPARAM_MISMATCHED_WITH_COLLECTION_VARIABLE
     * @uses self::VALUE_OUTPUTPARAM_MISSING_ASSIGNTOREFERENCE
     * @uses self::VALUE_OUTPUTPARAM_MISTMATCHED_WITH_NONCOLLECTION_VARIABLE
     * @uses self::VALUE_PARAM_DATATYPE_NOT_SUPPORTED
     * @uses self::VALUE_PROCESSMETADATAVALUES_NOT_SUPPORTED_FOR_PROCESSTYPE
     * @uses self::VALUE_PROCESSMETADATAVALUE_NONEXISTENT_ELEMENT
     * @uses self::VALUE_PROCESSTYPE_COMPONENTTYPE_NOT_SUPPORTED
     * @uses self::VALUE_PROCESSTYPE_ELEMENT_CONFIG_NOT_SUPPORTED
     * @uses self::VALUE_PROCESSTYPE_ELEMENT_NOT_SUPPORTED
     * @uses self::VALUE_PROCESSTYPE_NOT_SUPPORTED
     * @uses self::VALUE_PROCESSTYPE_SCREEN_FIELDTYPE_NOT_SUPPORTED
     * @uses self::VALUE_PROCESS_TYPE_INCOMPATIBLE
     * @uses self::VALUE_RECOMMENDATION_STRATEGY_EXCEPTION
     * @uses self::VALUE_RECORDFILTER_ENCRYPTED_FIELDS_NOT_SUPPORTED
     * @uses self::VALUE_RECORDFILTER_GEOLOCATION_FIELDS_NOT_SUPPORTED
     * @uses self::VALUE_RECORDFILTER_INVALID_DATATYPE
     * @uses self::VALUE_RECORDFILTER_INVALID_ELEMENT
     * @uses self::VALUE_RECORDFILTER_INVALID_OPERATOR
     * @uses self::VALUE_RECORDFILTER_INVALID_REFERENCE
     * @uses self::VALUE_RECORDFILTER_MISSING_DATATYPE
     * @uses self::VALUE_RECORDFILTER_MULTIPLE_QUERIES_SAME_FIELD
     * @uses self::VALUE_RECORDLOOKUP_IDASSIGNMENT_VARIABLE_INCOMPATIBLE_DATATYPE
     * @uses self::VALUE_RECORDLOOKUP_IDASSIGNMENT_VARIABLE_NOT_FOUND
     * @uses self::VALUE_RECORDUPDATE_MISSING_FILTERS
     * @uses self::VALUE_REFERENCED_ELEMENT_NOT_FOUND
     * @uses self::VALUE_RULE_MISSING_CONDITION
     * @uses self::VALUE_SCREENFIELD_API_VERSION_NOT_SUPPORTED
     * @uses self::VALUE_SCREENFIELD_BOOLEAN_ISREQUIRED_IS_FALSE
     * @uses self::VALUE_SCREENFIELD_DEFAULTVALUE_NOT_SUPPORTED
     * @uses self::VALUE_SCREENFIELD_EXTENSION_COMPONENT_NOT_GLOBAL
     * @uses self::VALUE_SCREENFIELD_EXTENSION_DUPLICATE_INPUT_PARAM
     * @uses self::VALUE_SCREENFIELD_EXTENSION_DUPLICATE_OUTPUT_PARAM
     * @uses self::VALUE_SCREENFIELD_EXTENSION_IMPLEMENTATION_INVALID
     * @uses self::VALUE_SCREENFIELD_EXTENSION_INPUT_ATTRIBUTE_INVALID
     * @uses self::VALUE_SCREENFIELD_EXTENSION_NAME_INVALID
     * @uses self::VALUE_SCREENFIELD_EXTENSION_NAME_MISSING
     * @uses self::VALUE_SCREENFIELD_EXTENSION_NAME_NOT_SUPPORTED
     * @uses self::VALUE_SCREENFIELD_EXTENSION_OUTPUT_ATTRIBUTE_INVALID
     * @uses self::VALUE_SCREENFIELD_EXTENSION_REQUIRED_INPUT_MISSING
     * @uses self::VALUE_SCREENFIELD_INPUTS_NOT_SUPPORTED
     * @uses self::VALUE_SCREENFIELD_INVALID_DATATYPE
     * @uses self::VALUE_SCREENFIELD_MULTISELECTCHOICE_SEMICOLON_NOT_SUPPORTED
     * @uses self::VALUE_SCREENFIELD_OUTPUTS_NOT_SUPPORTED
     * @uses self::VALUE_SCREENFIELD_TYPE_NOT_SUPPORTED
     * @uses self::VALUE_SCREENFIELD_USERINPUT_NOT_SUPPORTED_FOR_CHOICETYPE
     * @uses self::VALUE_SCREENFIELD_VALIDATIONRULE_NOT_SUPPORTED
     * @uses self::VALUE_SCREENRULE_ACTION_INVALID_ATTRIBUTE
     * @uses self::VALUE_SCREENRULE_ACTION_INVALID_ATTRIBUTE_FOR_API_VERSION
     * @uses self::VALUE_SCREENRULE_ACTION_INVALID_VALUE
     * @uses self::VALUE_SCREENRULE_ACTION_MISSING_ATTRIBUTE
     * @uses self::VALUE_SCREENRULE_ACTION_MISSING_FIELDREFERENCE
     * @uses self::VALUE_SCREENRULE_ACTION_MISSING_VALUE
     * @uses self::VALUE_SCREENRULE_ATTRIBUTE_NOT_SUPPORTED_FOR_SCREENFIELD
     * @uses self::VALUE_SCREENRULE_FIELD_NOT_FOUND_ON_SCREEN
     * @uses self::VALUE_SCREENRULE_MISSING_ACTION
     * @uses self::VALUE_SCREENRULE_NOT_SUPPORTED_IN_ORG
     * @uses self::VALUE_SCREENRULE_SCREENFIELD_NOT_VISIBLE
     * @uses self::VALUE_SCREENRULE_VISIBILITY_NOT_SUPPORTED_IN_ORG
     * @uses self::VALUE_SCREEN_ALLOWBACK_ALLOWFINISH_BOTH_FALSE
     * @uses self::VALUE_SCREEN_CONTAINS_LIGHTNING_COMPONENT
     * @uses self::VALUE_SCREEN_MISSING_FOOTER_AND_LIGHTNING_COMPONENT
     * @uses self::VALUE_SCREEN_MISSING_LABEL
     * @uses self::VALUE_SCREEN_MULTISELECTFIELD_DOESNT_SUPPORT_CHOICE_WITH_USERINPUT
     * @uses self::VALUE_SCREEN_PAUSEDTEXT_NOT_SHOWN_WHEN_ALLOWPAUSE_IS_FALSE
     * @uses self::VALUE_SETTING_FIELD_MAKES_OTHER_FIELD_REQUIRED
     * @uses self::VALUE_SETTING_FIELD_MAKES_OTHER_FIELD_UNSUPPORTED
     * @uses self::VALUE_SOBJECT_ELEMENT_INCOMPATIBLE_DATATYPE
     * @uses self::VALUE_SOBJECT_ELEMENT_MISMATCHED_OBJECTTYPE
     * @uses self::VALUE_SORT_ENCRYPTED_FIELDS_NOT_SUPPORTED
     * @uses self::VALUE_SORT_FIELD_MISSING
     * @uses self::VALUE_SORT_FIELD_NOT_SUPPORTED
     * @uses self::VALUE_SORT_GEOLOCATION_FIELDS_NOT_SUPPORTED
     * @uses self::VALUE_SORT_LIMIT_INVALID
     * @uses self::VALUE_SORT_ORDER_MISSING
     * @uses self::VALUE_SPECIFIC_FIELD_VALUE_MAKES_OTHER_FIELD_REQUIRED
     * @uses self::VALUE_STAGE_NAME_NOT_FULLY_QUALIFIED
     * @uses self::VALUE_START_ELEMENT_MISSING
     * @uses self::VALUE_SUBFLOW_DESKTOP_DESIGNER_FLOWS_NOT_SUPPORTED
     * @uses self::VALUE_SUBFLOW_INPUT_ELEMENT_INCOMPATIBLE_DATATYPES
     * @uses self::VALUE_SUBFLOW_INPUT_INVALID_VALUE
     * @uses self::VALUE_SUBFLOW_INPUT_MISMATCHED_COLLECTIONTYPES
     * @uses self::VALUE_SUBFLOW_INPUT_MISMATCHED_OBJECTS
     * @uses self::VALUE_SUBFLOW_INPUT_MISSING_NAME
     * @uses self::VALUE_SUBFLOW_INPUT_MULTIPLE_ASSIGNMENTS_TO_ONE_VARIABLE
     * @uses self::VALUE_SUBFLOW_INPUT_REFERENCES_FIELD_ON_SOBJECT_VARIABLE
     * @uses self::VALUE_SUBFLOW_INPUT_VALUE_INCOMPATIBLE_DATATYPES
     * @uses self::VALUE_SUBFLOW_INPUT_VARIABLE_NOT_FOUND_IN_MASTERFLOW
     * @uses self::VALUE_SUBFLOW_INPUT_VARIABLE_NOT_FOUND_IN_REFERENCEDFLOW
     * @uses self::VALUE_SUBFLOW_INPUT_VARIABLE_NO_INPUT_ACCESS
     * @uses self::VALUE_SUBFLOW_INVALID_NAME
     * @uses self::VALUE_SUBFLOW_INVALID_REFERENCE
     * @uses self::VALUE_SUBFLOW_MASTER_FLOW_TYPE_NOT_AUTOLAUNCHED
     * @uses self::VALUE_SUBFLOW_MISSING_NAME
     * @uses self::VALUE_SUBFLOW_NO_ACTIVE_VERSION
     * @uses self::VALUE_SUBFLOW_OUTPUT_INCOMPATIBLE_DATATYPES
     * @uses self::VALUE_SUBFLOW_OUTPUT_MISMATCHED_COLLECTIONTYPES
     * @uses self::VALUE_SUBFLOW_OUTPUT_MISMATCHED_OBJECTS
     * @uses self::VALUE_SUBFLOW_OUTPUT_MISSING_ASSIGNTOREFERENCE
     * @uses self::VALUE_SUBFLOW_OUTPUT_MISSING_NAME
     * @uses self::VALUE_SUBFLOW_OUTPUT_MULTIPLE_ASSIGNMENTS_TO_ONE_VARIABLE
     * @uses self::VALUE_SUBFLOW_OUTPUT_REFERENCES_FIELD_ON_SOBJECT_VARIABLE
     * @uses self::VALUE_SUBFLOW_OUTPUT_TARGET_DOES_NOT_EXIST_IN_MASTER_FLOW
     * @uses self::VALUE_SUBFLOW_OUTPUT_VARIABLE_NOT_FOUND_IN_MASTERFLOW
     * @uses self::VALUE_SUBFLOW_OUTPUT_VARIABLE_NOT_FOUND_IN_REFERENCEDFLOW
     * @uses self::VALUE_SUBFLOW_OUTPUT_VARIABLE_NO_OUTPUT_ACCESS
     * @uses self::VALUE_SUBFLOW_PROCESSTYPE_NOT_SUPPORTED
     * @uses self::VALUE_SUBFLOW_PROCESS_TYPE_INCOMPATIBLE
     * @uses self::VALUE_SUBFLOW_REFERENCES_MASTERFLOW
     * @uses self::VALUE_SURVEY_ADVANCED_CONDITION_LOGIC_NOT_SUPPORTED
     * @uses self::VALUE_SURVEY_CHOICE_NOT_REFERENCED_BY_A_QUESTION
     * @uses self::VALUE_SURVEY_CHOICE_REFERENCED_BY_MULTIPLE_QUESTIONS
     * @uses self::VALUE_SURVEY_ELEMENT_NEVER_REACHED
     * @uses self::VALUE_SURVEY_INACTIVE_SUBFLOWS
     * @uses self::VALUE_SURVEY_MISSING_QUESTION_OR_SUBFLOW
     * @uses self::VALUE_SURVEY_MISSING_REQUIRED_VARIABLES
     * @uses self::VALUE_SURVEY_MULTIPLE_SCREENS_CANNOT_CONNECT_TO_SAME_DECISION
     * @uses self::VALUE_SURVEY_NESTED_SUBFLOWS
     * @uses self::VALUE_SURVEY_NONSURVEY_SUBFLOWS
     * @uses self::VALUE_SURVEY_RULE_INVALID_RIGHT_OPERAND
     * @uses self::VALUE_SURVEY_SCREENFIELD_TYPE_NOT_SUPPORTED_FOR_QUESTION
     * @uses self::VALUE_SURVEY_START_ELEMENT_INVALID
     * @uses self::VALUE_SURVEY_VARIABLE_ACCESS_INVALID
     * @uses self::VALUE_UNEXPECTED_ERROR
     * @uses self::VALUE_VALUE_CHAR_LIMIT_EXCEEDED
     * @uses self::VALUE_VARIABLE_FIELD_NOT_SUPPORTED_FOR_DATATYPE
     * @uses self::VALUE_VARIABLE_FIELD_NOT_SUPPORTED_FOR_DATATYPE_AND_COLLECTION
     * @uses self::VALUE_VARIABLE_FIELD_REQUIRED_FOR_DATATYPE
     * @uses self::VALUE_VARIABLE_SCALE_EXCEEDS_LIMIT
     * @uses self::VALUE_VARIABLE_SCALE_NEGATIVE_INTEGER
     * @uses self::VALUE_VARIABLE_SCALE_NULL
     * @uses self::VALUE_VISIBILITY_RULE_NOT_SUPPORTED
     * @uses self::VALUE_WAITEVENT_DEFAULT_CONNECTOR_MISSING_LABEL
     * @uses self::VALUE_WAITEVENT_DUPLICATE_INPUT_PARAM
     * @uses self::VALUE_WAITEVENT_INPUT_NOT_SUPPORTED_FOR_EVENTTYPE
     * @uses self::VALUE_WAITEVENT_INPUT_REQUIRES_LITERAL_VALUE
     * @uses self::VALUE_WAITEVENT_INVALID_CONDITION_LOGIC
     * @uses self::VALUE_WAITEVENT_MISSING
     * @uses self::VALUE_WAITEVENT_MISSING_CONNECTOR
     * @uses self::VALUE_WAITEVENT_MISSING_EVENTTYPE
     * @uses self::VALUE_WAITEVENT_OBJECT_NOT_SUPPORTED_FOR_EVENTTYPE
     * @uses self::VALUE_WAITEVENT_OUTPUT_NOT_SUPPORTED_FOR_EVENTTYPE
     * @uses self::VALUE_WAITEVENT_RELATIVEALARM_INVALID_DATETIME_FIELD
     * @uses self::VALUE_WAITEVENT_RELATIVEALARM_INVALID_FIELD
     * @uses self::VALUE_WAITEVENT_RELATIVEALARM_INVALID_OBJECTTYPE
     * @uses self::VALUE_WAITEVENT_RELATIVEALARM_INVALID_OFFSETNUMBER
     * @uses self::VALUE_WAITEVENT_RELATIVEALARM_INVALID_OFFSETUNIT
     * @uses self::VALUE_WAITEVENT_REQUIRED_INPUT_MISSING
     * @uses self::VALUE_WAITEVENT_TYPE_INVALID_OR_NOT_SUPPORTED
     * @uses self::VALUE_WORKFLOW_MISSING_PROCESSMETADATAVALUES
     * @uses self::VALUE_WORKFLOW_OBJECTTYPE_NOT_FOUND
     * @uses self::VALUE_WORKFLOW_OBJECTTYPE_NOT_SUPPORTED
     * @uses self::VALUE_WORKFLOW_OBJECTVARIABLE_AND_OLDOBJECTVARIABLE_REFERENCE_SAME_SOBJECT_VARIABLE
     * @uses self::VALUE_WORKFLOW_OBJECTVARIABLE_DOESNT_SUPPORT_INPUT
     * @uses self::VALUE_WORKFLOW_OLDOBJECTVARIABLE_DOESNT_SUPPORT_INPUT
     * @uses self::VALUE_WORKFLOW_PROCESSMETADATAVALUES_MORE_THAN_ONE_NAME
     * @uses self::VALUE_WORKFLOW_PROCESS_METADATAVALUES_MISSING_NAME
     * @uses self::VALUE_WORKFLOW_RECURSIVECOUNTVARIABLE_DOESNT_SUPPORT_INPUT
     * @uses self::VALUE_WORKFLOW_TRIGGERTYPE_INVALID_VALUE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIONCALL_DUPLICATE_INPUT_PARAM,
            self::VALUE_ACTIONCALL_DUPLICATE_OUTPUT_PARAM,
            self::VALUE_ACTIONCALL_MISSING_NAME,
            self::VALUE_ACTIONCALL_MISSING_REQUIRED_PARAM,
            self::VALUE_ACTIONCALL_MISSING_REQUIRED_TYPE,
            self::VALUE_ACTIONCALL_NOT_FOUND_WITH_NAME_AND_TYPE,
            self::VALUE_ACTIONCALL_NOT_SUPPORTED_FOR_PROCESSTYPE,
            self::VALUE_APEXCALLOUT_INPUT_DUPLICATE,
            self::VALUE_APEXCALLOUT_INPUT_INCOMPATIBLE_DATATYPE,
            self::VALUE_APEXCALLOUT_INVALID,
            self::VALUE_APEXCALLOUT_MISSING_CLASSNAME,
            self::VALUE_APEXCALLOUT_NOT_FOUND,
            self::VALUE_APEXCALLOUT_OUTPUT_INCOMPATIBLE_DATATYPE,
            self::VALUE_APEXCALLOUT_OUTPUT_NOT_FOUND,
            self::VALUE_APEXCALLOUT_REQUIRED_INPUT_MISSING,
            self::VALUE_APEXCLASS_MISSING_INTERFACE,
            self::VALUE_APEX_CLASS_VARIABLE_NOT_FOUND,
            self::VALUE_ASSIGNMENTITEM_ELEMENT_MISSING_DATATYPE,
            self::VALUE_ASSIGNMENTITEM_ELEMENT_NOT_SUPPORTED,
            self::VALUE_ASSIGNMENTITEM_FIELD_INVALID_DATATYPE,
            self::VALUE_ASSIGNMENTITEM_FIELD_INVALID_DATATYPE_WITH_ELEMENT,
            self::VALUE_ASSIGNMENTITEM_INCOMPATIBLE_DATATYPES,
            self::VALUE_ASSIGNMENTITEM_INVALID_ASSIGNTOREFERENCE,
            self::VALUE_ASSIGNMENTITEM_INVALID_COLLECTION,
            self::VALUE_ASSIGNMENTITEM_INVALID_DATATYPE_IN_ELEMENT,
            self::VALUE_ASSIGNMENTITEM_INVALID_ELEMENTREFERENCE,
            self::VALUE_ASSIGNMENTITEM_INVALID_MERGE_FIELD,
            self::VALUE_ASSIGNMENTITEM_INVALID_OPERATOR,
            self::VALUE_ASSIGNMENTITEM_INVALID_REFERENCE,
            self::VALUE_ASSIGNMENTITEM_INVALID_VALUE,
            self::VALUE_ASSIGNMENTITEM_LEFT_DATATYPE_INVALID_FOR_OPERATOR,
            self::VALUE_ASSIGNMENTITEM_MODIFIES_NONVARIABLE,
            self::VALUE_ASSIGNMENTITEM_NONEXISTENT_REFERENCE,
            self::VALUE_ASSIGNMENTITEM_REQUIRED,
            self::VALUE_ASSIGNMENTITEM_RIGHT_DATATYPE_INVALID_FOR_OPERATOR,
            self::VALUE_AUTOLAUNCHED_CHOICELOOKUP_NOT_SUPPORTED,
            self::VALUE_AUTOLAUNCHED_CHOICE_NOT_SUPPORTED,
            self::VALUE_AUTOLAUNCHED_SCREEN_NOT_SUPPORTED,
            self::VALUE_AUTOLAUNCHED_STEP_NOT_SUPPORTED,
            self::VALUE_AUTOLAUNCHED_SUBFLOW_INCOMPATIBLE_FLOWTYPE,
            self::VALUE_AUTOLAUNCHED_WAIT_NOT_SUPPORTED,
            self::VALUE_CHOICEFIELD_DEFAULT_CHOICE_NOT_FOUND,
            self::VALUE_CHOICEFIELD_MISSING_CHOICE,
            self::VALUE_CHOICELOOKUP_DATATYPE_INCOMPATIBLE_WITH_CHOICEFIELD,
            self::VALUE_CHOICE_DATATYPE_INCOMPATIBLE_WITH_CHOICEFIELD,
            self::VALUE_CHOICE_NOT_SUPPORTED_FOR_SCREENFIELDTYPE,
            self::VALUE_CHOICE_USED_MULTIPLE_TIMES_IN_SAME_FIELD,
            self::VALUE_CONDITION_BUILDER_MISSING_FLOW_VARIABLE,
            self::VALUE_CONDITION_BUILDER_MISSING_REQUIRED_PERMISSIONS,
            self::VALUE_CONDITION_BUILDER_UNSUPPORTED_FLOW_VARIABLE,
            self::VALUE_CONDITION_DATATYPE_INCOMPATIBLE,
            self::VALUE_CONDITION_DATATYPE_INCOMPATIBLE_WITH_ELEMENT,
            self::VALUE_CONDITION_ELEMENT_DATATYPES_INCOMPATIBLE,
            self::VALUE_CONDITION_INVALID_LEFTOPERAND,
            self::VALUE_CONDITION_INVALID_LEFT_ELEMENT,
            self::VALUE_CONDITION_LOGIC_EXCEEDS_LIMIT,
            self::VALUE_CONDITION_LOGIC_INVALID,
            self::VALUE_CONDITION_LOGIC_MISSING,
            self::VALUE_CONDITION_MISSING_DATATYPE,
            self::VALUE_CONDITION_MISSING_OPERATOR,
            self::VALUE_CONDITION_REFERENCED_ELEMENT_NOT_FOUND,
            self::VALUE_CONDITION_RIGHTOPERAND_NULL,
            self::VALUE_CONNECTOR_MISSING_TARGET,
            self::VALUE_CONSTANT_INCLUDES_REFERENCES,
            self::VALUE_CUSTOMEVENTS_NOT_ENABLED,
            self::VALUE_CUSTOMEVENT_MISSING_PROCESSMETADATAVALUES,
            self::VALUE_CUSTOMEVENT_OBJECTTYPE_NOT_FOUND,
            self::VALUE_CUSTOMEVENT_OBJECTTYPE_NOT_SUPPORTED,
            self::VALUE_CUSTOMEVENT_PROCESSMETADATAVALUES_MISSING_NAME,
            self::VALUE_CUSTOMEVENT_PROCESSMETADATAVALUES_MORE_THAN_ONE_NAME,
            self::VALUE_DATATYPE_INVALID,
            self::VALUE_DATATYPE_MISSING,
            self::VALUE_DATA_TYPE_NOT_SUPPORTED_FOR_PROCESSTYPE,
            self::VALUE_DECISION_DEFAULT_CONNECTOR_MISSING_LABEL,
            self::VALUE_DECISION_MISSING_OUTCOME,
            self::VALUE_ELEMENT_CONNECTS_TO_SELF,
            self::VALUE_ELEMENT_COORDINATES_INVALID,
            self::VALUE_ELEMENT_INVALID_CONNECTOR,
            self::VALUE_ELEMENT_INVALID_REFERENCE,
            self::VALUE_ELEMENT_MISSING_CONNECTOR,
            self::VALUE_ELEMENT_MISSING_LABEL,
            self::VALUE_ELEMENT_MISSING_NAME,
            self::VALUE_ELEMENT_MISSING_REFERENCE,
            self::VALUE_ELEMENT_MORE_THAN_ONE_FIELD,
            self::VALUE_ELEMENT_NAME_INVALID,
            self::VALUE_ELEMENT_NEVER_USED,
            self::VALUE_ELEMENT_SCALE_SMALLER_THAN_DEFAULTVALUE,
            self::VALUE_EXTERNAL_OBJECTS_NOT_SUPPORTED,
            self::VALUE_EXTERNAL_OBJECT_FIELDS_NOT_SUPPORTED,
            self::VALUE_EX_AUTOLAUNCHED_SUBFLOW_INCOMPATIBLE_FLOWTYPE,
            self::VALUE_FIELDASSIGNMENT_FIELD_INCOMPATIBLE_DATATYPE,
            self::VALUE_FIELDASSIGNMENT_INVALID_DATATYPE,
            self::VALUE_FIELDASSIGNMENT_INVALID_ELEMENT,
            self::VALUE_FIELDASSIGNMENT_INVALID_REFERENCE,
            self::VALUE_FIELDASSIGNMENT_MULTIPLE_REFERENCES_SAME_FIELD,
            self::VALUE_FIELDASSIGNMENT_PICKLISTFIELD_INCOMPATIBLE_DATATYPE,
            self::VALUE_FIELDASSIGNMENT_REFERENCED_ELEMENT_MISSING_DATATYPE,
            self::VALUE_FIELDSERVICE_UNSUPPORTED_FIELD_TYPE,
            self::VALUE_FIELD_INVALID_VALUE,
            self::VALUE_FIELD_NOT_FOUND,
            self::VALUE_FIELD_RELATIONSHIP_NOT_SUPPORTED,
            self::VALUE_FLEXIPAGE_COMPONENT_ATTRIBUTE_EXPRESSION_EXCEPTION,
            self::VALUE_FLEXIPAGE_COMPONENT_ATTRIBUTE_GENERIC_EXCEPTION,
            self::VALUE_FLEXIPAGE_COMPONENT_ATTRIBUTE_MISSING_REQUIRED,
            self::VALUE_FLEXIPAGE_COMPONENT_ATTRIBUTE_TOO_LONG,
            self::VALUE_FLEXIPAGE_COMPONENT_CUSTOM_VALIDATION_EXCEPTION,
            self::VALUE_FLEXIPAGE_COMPONENT_MAX_LIMIT_EXCEPTION,
            self::VALUE_FLEXIPAGE_COMPONENT_RULE_VALIDATION_EXCEPTION,
            self::VALUE_FLEXIPAGE_PICKLIST_INVALID_VALUE_EXCEPTION,
            self::VALUE_FLEXIPAGE_TEMPLATE_INVALID_SWITCH,
            self::VALUE_FLOW_ELEMENT_SCALE_LESS_THAN_ZERO,
            self::VALUE_FLOW_INCLUDES_STEP,
            self::VALUE_FLOW_INTERVIEW_BULK_EXECUTION,
            self::VALUE_FLOW_INTERVIEW_HANDLED_ERROR,
            self::VALUE_FLOW_INTERVIEW_INPUT_VALIDATION,
            self::VALUE_FLOW_INTERVIEW_INTERACTION_NOT_FOUND,
            self::VALUE_FLOW_INTERVIEW_INVALID_CHOICE_USER_INPUT,
            self::VALUE_FLOW_INTERVIEW_INVALID_FIELD_VALUE,
            self::VALUE_FLOW_INTERVIEW_INVALID_START_REQUEST,
            self::VALUE_FLOW_INTERVIEW_LIMIT_EXCEEDED,
            self::VALUE_FLOW_INTERVIEW_MISSING_CHOICE_FOR_REQUIRED_CHOICE_FIELD,
            self::VALUE_FLOW_INTERVIEW_MISSING_VALUE_FOR_REQUIRED_INPUT_FIELD,
            self::VALUE_FLOW_INTERVIEW_NAVIGATE,
            self::VALUE_FLOW_INTERVIEW_RANGE_VALIDATION,
            self::VALUE_FLOW_INTERVIEW_REGEX_VALIDATION,
            self::VALUE_FLOW_INTERVIEW_RESUME_INTERVIEW,
            self::VALUE_FLOW_INTERVIEW_SAVE_RESULT,
            self::VALUE_FLOW_INTERVIEW_SET_CHOICE_SELECTED,
            self::VALUE_FLOW_INTERVIEW_START_INTERVIEW,
            self::VALUE_FLOW_INTERVIEW_TYPE_CONVERSION,
            self::VALUE_FLOW_INVALID_NAME,
            self::VALUE_FLOW_NAME_USED_IN_OTHER_CLIENT,
            self::VALUE_FLOW_STAGE_INCLUDES_REFERENCES,
            self::VALUE_FLOW_STAGE_ORDER_DUPLICATE,
            self::VALUE_FLOW_STAGE_ORDER_OUT_OF_RANGE,
            self::VALUE_FORMULA_CMT_LIMIT_EXCEEDED,
            self::VALUE_FORMULA_EXPRESSION_INVALID,
            self::VALUE_GLOBAL_VARIABLE_NOT_SUPPORTED_FOR_PROCESSTYPE,
            self::VALUE_INPUTPARAM_INCOMPATIBLE_DATATYPE,
            self::VALUE_INPUTPARAM_INCOMPATIBLE_WITH_COLLECTION_VARIABLE,
            self::VALUE_INPUTPARAM_INCOMPATIBLE_WITH_NONCOLLECTION_VARIABLE,
            self::VALUE_INPUTPARAM_MISMATCHED_OBJECTTYPE,
            self::VALUE_INVALID_FLOW,
            self::VALUE_INVALID_FLOW_INTERVIEW,
            self::VALUE_INVALID_SURVEY_VARIABLE_NAME_OR_TYPE,
            self::VALUE_LOOP_ASSIGNNEXTVALUETO_MISMATCHED_DATATYPE,
            self::VALUE_LOOP_ASSIGNNEXTVALUETO_MISMATCHED_OBJECTTYPE,
            self::VALUE_LOOP_ASSIGNNEXTVALUETO_MISSING,
            self::VALUE_LOOP_ASSIGNNEXTVALUETO_MISSING_VARIABLE,
            self::VALUE_LOOP_ASSIGNNEXTVALUETO_REFERENCE_NOT_FOUND,
            self::VALUE_LOOP_COLLECTION_ELEMENT_NOT_FOUND,
            self::VALUE_LOOP_COLLECTION_NOT_FOUND,
            self::VALUE_LOOP_COLLECTION_NOT_SUPPORTED_FOR_FIELD,
            self::VALUE_LOOP_MISSING_COLLECTION,
            self::VALUE_OBJECTTYPE_INVALID,
            self::VALUE_OBJECT_CANNOT_BE_CREATED,
            self::VALUE_OBJECT_CANNOT_BE_DELETED,
            self::VALUE_OBJECT_CANNOT_BE_QUERIED,
            self::VALUE_OBJECT_CANNOT_BE_UPDATED,
            self::VALUE_OBJECT_ENCRYPTED_FIELDS_NOT_SUPPORTED,
            self::VALUE_OBJECT_NOT_FOUND,
            self::VALUE_OUTPUTPARAM_ASSIGNTOREFERENCE_NOTFOUND,
            self::VALUE_OUTPUTPARAM_INCOMPATIBLE_DATATYPE,
            self::VALUE_OUTPUTPARAM_MISMATCHED_OBJECTTYPE,
            self::VALUE_OUTPUTPARAM_MISMATCHED_WITH_COLLECTION_VARIABLE,
            self::VALUE_OUTPUTPARAM_MISSING_ASSIGNTOREFERENCE,
            self::VALUE_OUTPUTPARAM_MISTMATCHED_WITH_NONCOLLECTION_VARIABLE,
            self::VALUE_PARAM_DATATYPE_NOT_SUPPORTED,
            self::VALUE_PROCESSMETADATAVALUES_NOT_SUPPORTED_FOR_PROCESSTYPE,
            self::VALUE_PROCESSMETADATAVALUE_NONEXISTENT_ELEMENT,
            self::VALUE_PROCESSTYPE_COMPONENTTYPE_NOT_SUPPORTED,
            self::VALUE_PROCESSTYPE_ELEMENT_CONFIG_NOT_SUPPORTED,
            self::VALUE_PROCESSTYPE_ELEMENT_NOT_SUPPORTED,
            self::VALUE_PROCESSTYPE_NOT_SUPPORTED,
            self::VALUE_PROCESSTYPE_SCREEN_FIELDTYPE_NOT_SUPPORTED,
            self::VALUE_PROCESS_TYPE_INCOMPATIBLE,
            self::VALUE_RECOMMENDATION_STRATEGY_EXCEPTION,
            self::VALUE_RECORDFILTER_ENCRYPTED_FIELDS_NOT_SUPPORTED,
            self::VALUE_RECORDFILTER_GEOLOCATION_FIELDS_NOT_SUPPORTED,
            self::VALUE_RECORDFILTER_INVALID_DATATYPE,
            self::VALUE_RECORDFILTER_INVALID_ELEMENT,
            self::VALUE_RECORDFILTER_INVALID_OPERATOR,
            self::VALUE_RECORDFILTER_INVALID_REFERENCE,
            self::VALUE_RECORDFILTER_MISSING_DATATYPE,
            self::VALUE_RECORDFILTER_MULTIPLE_QUERIES_SAME_FIELD,
            self::VALUE_RECORDLOOKUP_IDASSIGNMENT_VARIABLE_INCOMPATIBLE_DATATYPE,
            self::VALUE_RECORDLOOKUP_IDASSIGNMENT_VARIABLE_NOT_FOUND,
            self::VALUE_RECORDUPDATE_MISSING_FILTERS,
            self::VALUE_REFERENCED_ELEMENT_NOT_FOUND,
            self::VALUE_RULE_MISSING_CONDITION,
            self::VALUE_SCREENFIELD_API_VERSION_NOT_SUPPORTED,
            self::VALUE_SCREENFIELD_BOOLEAN_ISREQUIRED_IS_FALSE,
            self::VALUE_SCREENFIELD_DEFAULTVALUE_NOT_SUPPORTED,
            self::VALUE_SCREENFIELD_EXTENSION_COMPONENT_NOT_GLOBAL,
            self::VALUE_SCREENFIELD_EXTENSION_DUPLICATE_INPUT_PARAM,
            self::VALUE_SCREENFIELD_EXTENSION_DUPLICATE_OUTPUT_PARAM,
            self::VALUE_SCREENFIELD_EXTENSION_IMPLEMENTATION_INVALID,
            self::VALUE_SCREENFIELD_EXTENSION_INPUT_ATTRIBUTE_INVALID,
            self::VALUE_SCREENFIELD_EXTENSION_NAME_INVALID,
            self::VALUE_SCREENFIELD_EXTENSION_NAME_MISSING,
            self::VALUE_SCREENFIELD_EXTENSION_NAME_NOT_SUPPORTED,
            self::VALUE_SCREENFIELD_EXTENSION_OUTPUT_ATTRIBUTE_INVALID,
            self::VALUE_SCREENFIELD_EXTENSION_REQUIRED_INPUT_MISSING,
            self::VALUE_SCREENFIELD_INPUTS_NOT_SUPPORTED,
            self::VALUE_SCREENFIELD_INVALID_DATATYPE,
            self::VALUE_SCREENFIELD_MULTISELECTCHOICE_SEMICOLON_NOT_SUPPORTED,
            self::VALUE_SCREENFIELD_OUTPUTS_NOT_SUPPORTED,
            self::VALUE_SCREENFIELD_TYPE_NOT_SUPPORTED,
            self::VALUE_SCREENFIELD_USERINPUT_NOT_SUPPORTED_FOR_CHOICETYPE,
            self::VALUE_SCREENFIELD_VALIDATIONRULE_NOT_SUPPORTED,
            self::VALUE_SCREENRULE_ACTION_INVALID_ATTRIBUTE,
            self::VALUE_SCREENRULE_ACTION_INVALID_ATTRIBUTE_FOR_API_VERSION,
            self::VALUE_SCREENRULE_ACTION_INVALID_VALUE,
            self::VALUE_SCREENRULE_ACTION_MISSING_ATTRIBUTE,
            self::VALUE_SCREENRULE_ACTION_MISSING_FIELDREFERENCE,
            self::VALUE_SCREENRULE_ACTION_MISSING_VALUE,
            self::VALUE_SCREENRULE_ATTRIBUTE_NOT_SUPPORTED_FOR_SCREENFIELD,
            self::VALUE_SCREENRULE_FIELD_NOT_FOUND_ON_SCREEN,
            self::VALUE_SCREENRULE_MISSING_ACTION,
            self::VALUE_SCREENRULE_NOT_SUPPORTED_IN_ORG,
            self::VALUE_SCREENRULE_SCREENFIELD_NOT_VISIBLE,
            self::VALUE_SCREENRULE_VISIBILITY_NOT_SUPPORTED_IN_ORG,
            self::VALUE_SCREEN_ALLOWBACK_ALLOWFINISH_BOTH_FALSE,
            self::VALUE_SCREEN_CONTAINS_LIGHTNING_COMPONENT,
            self::VALUE_SCREEN_MISSING_FOOTER_AND_LIGHTNING_COMPONENT,
            self::VALUE_SCREEN_MISSING_LABEL,
            self::VALUE_SCREEN_MULTISELECTFIELD_DOESNT_SUPPORT_CHOICE_WITH_USERINPUT,
            self::VALUE_SCREEN_PAUSEDTEXT_NOT_SHOWN_WHEN_ALLOWPAUSE_IS_FALSE,
            self::VALUE_SETTING_FIELD_MAKES_OTHER_FIELD_REQUIRED,
            self::VALUE_SETTING_FIELD_MAKES_OTHER_FIELD_UNSUPPORTED,
            self::VALUE_SOBJECT_ELEMENT_INCOMPATIBLE_DATATYPE,
            self::VALUE_SOBJECT_ELEMENT_MISMATCHED_OBJECTTYPE,
            self::VALUE_SORT_ENCRYPTED_FIELDS_NOT_SUPPORTED,
            self::VALUE_SORT_FIELD_MISSING,
            self::VALUE_SORT_FIELD_NOT_SUPPORTED,
            self::VALUE_SORT_GEOLOCATION_FIELDS_NOT_SUPPORTED,
            self::VALUE_SORT_LIMIT_INVALID,
            self::VALUE_SORT_ORDER_MISSING,
            self::VALUE_SPECIFIC_FIELD_VALUE_MAKES_OTHER_FIELD_REQUIRED,
            self::VALUE_STAGE_NAME_NOT_FULLY_QUALIFIED,
            self::VALUE_START_ELEMENT_MISSING,
            self::VALUE_SUBFLOW_DESKTOP_DESIGNER_FLOWS_NOT_SUPPORTED,
            self::VALUE_SUBFLOW_INPUT_ELEMENT_INCOMPATIBLE_DATATYPES,
            self::VALUE_SUBFLOW_INPUT_INVALID_VALUE,
            self::VALUE_SUBFLOW_INPUT_MISMATCHED_COLLECTIONTYPES,
            self::VALUE_SUBFLOW_INPUT_MISMATCHED_OBJECTS,
            self::VALUE_SUBFLOW_INPUT_MISSING_NAME,
            self::VALUE_SUBFLOW_INPUT_MULTIPLE_ASSIGNMENTS_TO_ONE_VARIABLE,
            self::VALUE_SUBFLOW_INPUT_REFERENCES_FIELD_ON_SOBJECT_VARIABLE,
            self::VALUE_SUBFLOW_INPUT_VALUE_INCOMPATIBLE_DATATYPES,
            self::VALUE_SUBFLOW_INPUT_VARIABLE_NOT_FOUND_IN_MASTERFLOW,
            self::VALUE_SUBFLOW_INPUT_VARIABLE_NOT_FOUND_IN_REFERENCEDFLOW,
            self::VALUE_SUBFLOW_INPUT_VARIABLE_NO_INPUT_ACCESS,
            self::VALUE_SUBFLOW_INVALID_NAME,
            self::VALUE_SUBFLOW_INVALID_REFERENCE,
            self::VALUE_SUBFLOW_MASTER_FLOW_TYPE_NOT_AUTOLAUNCHED,
            self::VALUE_SUBFLOW_MISSING_NAME,
            self::VALUE_SUBFLOW_NO_ACTIVE_VERSION,
            self::VALUE_SUBFLOW_OUTPUT_INCOMPATIBLE_DATATYPES,
            self::VALUE_SUBFLOW_OUTPUT_MISMATCHED_COLLECTIONTYPES,
            self::VALUE_SUBFLOW_OUTPUT_MISMATCHED_OBJECTS,
            self::VALUE_SUBFLOW_OUTPUT_MISSING_ASSIGNTOREFERENCE,
            self::VALUE_SUBFLOW_OUTPUT_MISSING_NAME,
            self::VALUE_SUBFLOW_OUTPUT_MULTIPLE_ASSIGNMENTS_TO_ONE_VARIABLE,
            self::VALUE_SUBFLOW_OUTPUT_REFERENCES_FIELD_ON_SOBJECT_VARIABLE,
            self::VALUE_SUBFLOW_OUTPUT_TARGET_DOES_NOT_EXIST_IN_MASTER_FLOW,
            self::VALUE_SUBFLOW_OUTPUT_VARIABLE_NOT_FOUND_IN_MASTERFLOW,
            self::VALUE_SUBFLOW_OUTPUT_VARIABLE_NOT_FOUND_IN_REFERENCEDFLOW,
            self::VALUE_SUBFLOW_OUTPUT_VARIABLE_NO_OUTPUT_ACCESS,
            self::VALUE_SUBFLOW_PROCESSTYPE_NOT_SUPPORTED,
            self::VALUE_SUBFLOW_PROCESS_TYPE_INCOMPATIBLE,
            self::VALUE_SUBFLOW_REFERENCES_MASTERFLOW,
            self::VALUE_SURVEY_ADVANCED_CONDITION_LOGIC_NOT_SUPPORTED,
            self::VALUE_SURVEY_CHOICE_NOT_REFERENCED_BY_A_QUESTION,
            self::VALUE_SURVEY_CHOICE_REFERENCED_BY_MULTIPLE_QUESTIONS,
            self::VALUE_SURVEY_ELEMENT_NEVER_REACHED,
            self::VALUE_SURVEY_INACTIVE_SUBFLOWS,
            self::VALUE_SURVEY_MISSING_QUESTION_OR_SUBFLOW,
            self::VALUE_SURVEY_MISSING_REQUIRED_VARIABLES,
            self::VALUE_SURVEY_MULTIPLE_SCREENS_CANNOT_CONNECT_TO_SAME_DECISION,
            self::VALUE_SURVEY_NESTED_SUBFLOWS,
            self::VALUE_SURVEY_NONSURVEY_SUBFLOWS,
            self::VALUE_SURVEY_RULE_INVALID_RIGHT_OPERAND,
            self::VALUE_SURVEY_SCREENFIELD_TYPE_NOT_SUPPORTED_FOR_QUESTION,
            self::VALUE_SURVEY_START_ELEMENT_INVALID,
            self::VALUE_SURVEY_VARIABLE_ACCESS_INVALID,
            self::VALUE_UNEXPECTED_ERROR,
            self::VALUE_VALUE_CHAR_LIMIT_EXCEEDED,
            self::VALUE_VARIABLE_FIELD_NOT_SUPPORTED_FOR_DATATYPE,
            self::VALUE_VARIABLE_FIELD_NOT_SUPPORTED_FOR_DATATYPE_AND_COLLECTION,
            self::VALUE_VARIABLE_FIELD_REQUIRED_FOR_DATATYPE,
            self::VALUE_VARIABLE_SCALE_EXCEEDS_LIMIT,
            self::VALUE_VARIABLE_SCALE_NEGATIVE_INTEGER,
            self::VALUE_VARIABLE_SCALE_NULL,
            self::VALUE_VISIBILITY_RULE_NOT_SUPPORTED,
            self::VALUE_WAITEVENT_DEFAULT_CONNECTOR_MISSING_LABEL,
            self::VALUE_WAITEVENT_DUPLICATE_INPUT_PARAM,
            self::VALUE_WAITEVENT_INPUT_NOT_SUPPORTED_FOR_EVENTTYPE,
            self::VALUE_WAITEVENT_INPUT_REQUIRES_LITERAL_VALUE,
            self::VALUE_WAITEVENT_INVALID_CONDITION_LOGIC,
            self::VALUE_WAITEVENT_MISSING,
            self::VALUE_WAITEVENT_MISSING_CONNECTOR,
            self::VALUE_WAITEVENT_MISSING_EVENTTYPE,
            self::VALUE_WAITEVENT_OBJECT_NOT_SUPPORTED_FOR_EVENTTYPE,
            self::VALUE_WAITEVENT_OUTPUT_NOT_SUPPORTED_FOR_EVENTTYPE,
            self::VALUE_WAITEVENT_RELATIVEALARM_INVALID_DATETIME_FIELD,
            self::VALUE_WAITEVENT_RELATIVEALARM_INVALID_FIELD,
            self::VALUE_WAITEVENT_RELATIVEALARM_INVALID_OBJECTTYPE,
            self::VALUE_WAITEVENT_RELATIVEALARM_INVALID_OFFSETNUMBER,
            self::VALUE_WAITEVENT_RELATIVEALARM_INVALID_OFFSETUNIT,
            self::VALUE_WAITEVENT_REQUIRED_INPUT_MISSING,
            self::VALUE_WAITEVENT_TYPE_INVALID_OR_NOT_SUPPORTED,
            self::VALUE_WORKFLOW_MISSING_PROCESSMETADATAVALUES,
            self::VALUE_WORKFLOW_OBJECTTYPE_NOT_FOUND,
            self::VALUE_WORKFLOW_OBJECTTYPE_NOT_SUPPORTED,
            self::VALUE_WORKFLOW_OBJECTVARIABLE_AND_OLDOBJECTVARIABLE_REFERENCE_SAME_SOBJECT_VARIABLE,
            self::VALUE_WORKFLOW_OBJECTVARIABLE_DOESNT_SUPPORT_INPUT,
            self::VALUE_WORKFLOW_OLDOBJECTVARIABLE_DOESNT_SUPPORT_INPUT,
            self::VALUE_WORKFLOW_PROCESSMETADATAVALUES_MORE_THAN_ONE_NAME,
            self::VALUE_WORKFLOW_PROCESS_METADATAVALUES_MISSING_NAME,
            self::VALUE_WORKFLOW_RECURSIVECOUNTVARIABLE_DOESNT_SUPPORT_INPUT,
            self::VALUE_WORKFLOW_TRIGGERTYPE_INVALID_VALUE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
