<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VisualforceAccessMetrics StructType
 * @subpackage Structs
 */
class VisualforceAccessMetrics extends SObject
{
    /**
     * The ApexPage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ApexPage
     */
    public $ApexPage;
    /**
     * The ApexPageId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ApexPageId;
    /**
     * The DailyPageViewCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DailyPageViewCount;
    /**
     * The LogDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LogDate;
    /**
     * The MetricsDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MetricsDate;
    /**
     * The Profile
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Profile
     */
    public $Profile;
    /**
     * The ProfileId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ProfileId;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for VisualforceAccessMetrics
     * @uses VisualforceAccessMetrics::setApexPage()
     * @uses VisualforceAccessMetrics::setApexPageId()
     * @uses VisualforceAccessMetrics::setDailyPageViewCount()
     * @uses VisualforceAccessMetrics::setLogDate()
     * @uses VisualforceAccessMetrics::setMetricsDate()
     * @uses VisualforceAccessMetrics::setProfile()
     * @uses VisualforceAccessMetrics::setProfileId()
     * @uses VisualforceAccessMetrics::setSystemModstamp()
     * @param \NexusDigital/MiratelForce\StructType\ApexPage $apexPage
     * @param string $apexPageId
     * @param int $dailyPageViewCount
     * @param string $logDate
     * @param string $metricsDate
     * @param \NexusDigital/MiratelForce\StructType\Profile $profile
     * @param string $profileId
     * @param string $systemModstamp
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\ApexPage $apexPage = null, $apexPageId = null, $dailyPageViewCount = null, $logDate = null, $metricsDate = null, \NexusDigital/MiratelForce\StructType\Profile $profile = null, $profileId = null, $systemModstamp = null)
    {
        $this
            ->setApexPage($apexPage)
            ->setApexPageId($apexPageId)
            ->setDailyPageViewCount($dailyPageViewCount)
            ->setLogDate($logDate)
            ->setMetricsDate($metricsDate)
            ->setProfile($profile)
            ->setProfileId($profileId)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get ApexPage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ApexPage|null
     */
    public function getApexPage()
    {
        return isset($this->ApexPage) ? $this->ApexPage : null;
    }
    /**
     * Set ApexPage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ApexPage $apexPage
     * @return \NexusDigital/MiratelForce\StructType\VisualforceAccessMetrics
     */
    public function setApexPage(\NexusDigital/MiratelForce\StructType\ApexPage $apexPage = null)
    {
        if (is_null($apexPage) || (is_array($apexPage) && empty($apexPage))) {
            unset($this->ApexPage);
        } else {
            $this->ApexPage = $apexPage;
        }
        return $this;
    }
    /**
     * Get ApexPageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApexPageId()
    {
        return isset($this->ApexPageId) ? $this->ApexPageId : null;
    }
    /**
     * Set ApexPageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apexPageId
     * @return \NexusDigital/MiratelForce\StructType\VisualforceAccessMetrics
     */
    public function setApexPageId($apexPageId = null)
    {
        // validation for constraint: string
        if (!is_null($apexPageId) && !is_string($apexPageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apexPageId, true), gettype($apexPageId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($apexPageId) && mb_strlen($apexPageId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($apexPageId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($apexPageId) && !preg_match('/[a-zA-Z0-9]{18}/', $apexPageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($apexPageId, true)), __LINE__);
        }
        if (is_null($apexPageId) || (is_array($apexPageId) && empty($apexPageId))) {
            unset($this->ApexPageId);
        } else {
            $this->ApexPageId = $apexPageId;
        }
        return $this;
    }
    /**
     * Get DailyPageViewCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDailyPageViewCount()
    {
        return isset($this->DailyPageViewCount) ? $this->DailyPageViewCount : null;
    }
    /**
     * Set DailyPageViewCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dailyPageViewCount
     * @return \NexusDigital/MiratelForce\StructType\VisualforceAccessMetrics
     */
    public function setDailyPageViewCount($dailyPageViewCount = null)
    {
        // validation for constraint: int
        if (!is_null($dailyPageViewCount) && !(is_int($dailyPageViewCount) || ctype_digit($dailyPageViewCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dailyPageViewCount, true), gettype($dailyPageViewCount)), __LINE__);
        }
        if (is_null($dailyPageViewCount) || (is_array($dailyPageViewCount) && empty($dailyPageViewCount))) {
            unset($this->DailyPageViewCount);
        } else {
            $this->DailyPageViewCount = $dailyPageViewCount;
        }
        return $this;
    }
    /**
     * Get LogDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogDate()
    {
        return isset($this->LogDate) ? $this->LogDate : null;
    }
    /**
     * Set LogDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logDate
     * @return \NexusDigital/MiratelForce\StructType\VisualforceAccessMetrics
     */
    public function setLogDate($logDate = null)
    {
        // validation for constraint: string
        if (!is_null($logDate) && !is_string($logDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logDate, true), gettype($logDate)), __LINE__);
        }
        if (is_null($logDate) || (is_array($logDate) && empty($logDate))) {
            unset($this->LogDate);
        } else {
            $this->LogDate = $logDate;
        }
        return $this;
    }
    /**
     * Get MetricsDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMetricsDate()
    {
        return isset($this->MetricsDate) ? $this->MetricsDate : null;
    }
    /**
     * Set MetricsDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $metricsDate
     * @return \NexusDigital/MiratelForce\StructType\VisualforceAccessMetrics
     */
    public function setMetricsDate($metricsDate = null)
    {
        // validation for constraint: string
        if (!is_null($metricsDate) && !is_string($metricsDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metricsDate, true), gettype($metricsDate)), __LINE__);
        }
        if (is_null($metricsDate) || (is_array($metricsDate) && empty($metricsDate))) {
            unset($this->MetricsDate);
        } else {
            $this->MetricsDate = $metricsDate;
        }
        return $this;
    }
    /**
     * Get Profile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Profile|null
     */
    public function getProfile()
    {
        return isset($this->Profile) ? $this->Profile : null;
    }
    /**
     * Set Profile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Profile $profile
     * @return \NexusDigital/MiratelForce\StructType\VisualforceAccessMetrics
     */
    public function setProfile(\NexusDigital/MiratelForce\StructType\Profile $profile = null)
    {
        if (is_null($profile) || (is_array($profile) && empty($profile))) {
            unset($this->Profile);
        } else {
            $this->Profile = $profile;
        }
        return $this;
    }
    /**
     * Get ProfileId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProfileId()
    {
        return isset($this->ProfileId) ? $this->ProfileId : null;
    }
    /**
     * Set ProfileId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $profileId
     * @return \NexusDigital/MiratelForce\StructType\VisualforceAccessMetrics
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: string
        if (!is_null($profileId) && !is_string($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileId, true), gettype($profileId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($profileId) && mb_strlen($profileId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($profileId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($profileId) && !preg_match('/[a-zA-Z0-9]{18}/', $profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($profileId, true)), __LINE__);
        }
        if (is_null($profileId) || (is_array($profileId) && empty($profileId))) {
            unset($this->ProfileId);
        } else {
            $this->ProfileId = $profileId;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\VisualforceAccessMetrics
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\VisualforceAccessMetrics
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
