<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserRole StructType
 * @subpackage Structs
 */
class UserRole extends SObject
{
    /**
     * The CaseAccessForAccountOwner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CaseAccessForAccountOwner;
    /**
     * The ContactAccessForAccountOwner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactAccessForAccountOwner;
    /**
     * The DeveloperName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeveloperName;
    /**
     * The ForecastUserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ForecastUserId;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The MayForecastManagerShare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MayForecastManagerShare;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OpportunityAccessForAccountOwner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OpportunityAccessForAccountOwner;
    /**
     * The ParentRoleId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentRoleId;
    /**
     * The PortalAccountId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PortalAccountId;
    /**
     * The PortalAccountOwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PortalAccountOwnerId;
    /**
     * The PortalRole
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PortalRole;
    /**
     * The PortalType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PortalType;
    /**
     * The RollupDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RollupDescription;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The Users
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Users;
    /**
     * Constructor method for UserRole
     * @uses UserRole::setCaseAccessForAccountOwner()
     * @uses UserRole::setContactAccessForAccountOwner()
     * @uses UserRole::setDeveloperName()
     * @uses UserRole::setForecastUserId()
     * @uses UserRole::setLastModifiedBy()
     * @uses UserRole::setLastModifiedById()
     * @uses UserRole::setLastModifiedDate()
     * @uses UserRole::setMayForecastManagerShare()
     * @uses UserRole::setName()
     * @uses UserRole::setOpportunityAccessForAccountOwner()
     * @uses UserRole::setParentRoleId()
     * @uses UserRole::setPortalAccountId()
     * @uses UserRole::setPortalAccountOwnerId()
     * @uses UserRole::setPortalRole()
     * @uses UserRole::setPortalType()
     * @uses UserRole::setRollupDescription()
     * @uses UserRole::setSystemModstamp()
     * @uses UserRole::setUsers()
     * @param string $caseAccessForAccountOwner
     * @param string $contactAccessForAccountOwner
     * @param string $developerName
     * @param string $forecastUserId
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param bool $mayForecastManagerShare
     * @param string $name
     * @param string $opportunityAccessForAccountOwner
     * @param string $parentRoleId
     * @param string $portalAccountId
     * @param string $portalAccountOwnerId
     * @param string $portalRole
     * @param string $portalType
     * @param string $rollupDescription
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $users
     */
    public function __construct($caseAccessForAccountOwner = null, $contactAccessForAccountOwner = null, $developerName = null, $forecastUserId = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $mayForecastManagerShare = null, $name = null, $opportunityAccessForAccountOwner = null, $parentRoleId = null, $portalAccountId = null, $portalAccountOwnerId = null, $portalRole = null, $portalType = null, $rollupDescription = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\QueryResult $users = null)
    {
        $this
            ->setCaseAccessForAccountOwner($caseAccessForAccountOwner)
            ->setContactAccessForAccountOwner($contactAccessForAccountOwner)
            ->setDeveloperName($developerName)
            ->setForecastUserId($forecastUserId)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setMayForecastManagerShare($mayForecastManagerShare)
            ->setName($name)
            ->setOpportunityAccessForAccountOwner($opportunityAccessForAccountOwner)
            ->setParentRoleId($parentRoleId)
            ->setPortalAccountId($portalAccountId)
            ->setPortalAccountOwnerId($portalAccountOwnerId)
            ->setPortalRole($portalRole)
            ->setPortalType($portalType)
            ->setRollupDescription($rollupDescription)
            ->setSystemModstamp($systemModstamp)
            ->setUsers($users);
    }
    /**
     * Get CaseAccessForAccountOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCaseAccessForAccountOwner()
    {
        return isset($this->CaseAccessForAccountOwner) ? $this->CaseAccessForAccountOwner : null;
    }
    /**
     * Set CaseAccessForAccountOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $caseAccessForAccountOwner
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setCaseAccessForAccountOwner($caseAccessForAccountOwner = null)
    {
        // validation for constraint: string
        if (!is_null($caseAccessForAccountOwner) && !is_string($caseAccessForAccountOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caseAccessForAccountOwner, true), gettype($caseAccessForAccountOwner)), __LINE__);
        }
        if (is_null($caseAccessForAccountOwner) || (is_array($caseAccessForAccountOwner) && empty($caseAccessForAccountOwner))) {
            unset($this->CaseAccessForAccountOwner);
        } else {
            $this->CaseAccessForAccountOwner = $caseAccessForAccountOwner;
        }
        return $this;
    }
    /**
     * Get ContactAccessForAccountOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactAccessForAccountOwner()
    {
        return isset($this->ContactAccessForAccountOwner) ? $this->ContactAccessForAccountOwner : null;
    }
    /**
     * Set ContactAccessForAccountOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactAccessForAccountOwner
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setContactAccessForAccountOwner($contactAccessForAccountOwner = null)
    {
        // validation for constraint: string
        if (!is_null($contactAccessForAccountOwner) && !is_string($contactAccessForAccountOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactAccessForAccountOwner, true), gettype($contactAccessForAccountOwner)), __LINE__);
        }
        if (is_null($contactAccessForAccountOwner) || (is_array($contactAccessForAccountOwner) && empty($contactAccessForAccountOwner))) {
            unset($this->ContactAccessForAccountOwner);
        } else {
            $this->ContactAccessForAccountOwner = $contactAccessForAccountOwner;
        }
        return $this;
    }
    /**
     * Get DeveloperName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeveloperName()
    {
        return isset($this->DeveloperName) ? $this->DeveloperName : null;
    }
    /**
     * Set DeveloperName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $developerName
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setDeveloperName($developerName = null)
    {
        // validation for constraint: string
        if (!is_null($developerName) && !is_string($developerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($developerName, true), gettype($developerName)), __LINE__);
        }
        if (is_null($developerName) || (is_array($developerName) && empty($developerName))) {
            unset($this->DeveloperName);
        } else {
            $this->DeveloperName = $developerName;
        }
        return $this;
    }
    /**
     * Get ForecastUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastUserId()
    {
        return isset($this->ForecastUserId) ? $this->ForecastUserId : null;
    }
    /**
     * Set ForecastUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastUserId
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setForecastUserId($forecastUserId = null)
    {
        // validation for constraint: string
        if (!is_null($forecastUserId) && !is_string($forecastUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastUserId, true), gettype($forecastUserId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($forecastUserId) && mb_strlen($forecastUserId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($forecastUserId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($forecastUserId) && !preg_match('/[a-zA-Z0-9]{18}/', $forecastUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($forecastUserId, true)), __LINE__);
        }
        if (is_null($forecastUserId) || (is_array($forecastUserId) && empty($forecastUserId))) {
            unset($this->ForecastUserId);
        } else {
            $this->ForecastUserId = $forecastUserId;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get MayForecastManagerShare value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMayForecastManagerShare()
    {
        return isset($this->MayForecastManagerShare) ? $this->MayForecastManagerShare : null;
    }
    /**
     * Set MayForecastManagerShare value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $mayForecastManagerShare
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setMayForecastManagerShare($mayForecastManagerShare = null)
    {
        // validation for constraint: boolean
        if (!is_null($mayForecastManagerShare) && !is_bool($mayForecastManagerShare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mayForecastManagerShare, true), gettype($mayForecastManagerShare)), __LINE__);
        }
        if (is_null($mayForecastManagerShare) || (is_array($mayForecastManagerShare) && empty($mayForecastManagerShare))) {
            unset($this->MayForecastManagerShare);
        } else {
            $this->MayForecastManagerShare = $mayForecastManagerShare;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OpportunityAccessForAccountOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpportunityAccessForAccountOwner()
    {
        return isset($this->OpportunityAccessForAccountOwner) ? $this->OpportunityAccessForAccountOwner : null;
    }
    /**
     * Set OpportunityAccessForAccountOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opportunityAccessForAccountOwner
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setOpportunityAccessForAccountOwner($opportunityAccessForAccountOwner = null)
    {
        // validation for constraint: string
        if (!is_null($opportunityAccessForAccountOwner) && !is_string($opportunityAccessForAccountOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opportunityAccessForAccountOwner, true), gettype($opportunityAccessForAccountOwner)), __LINE__);
        }
        if (is_null($opportunityAccessForAccountOwner) || (is_array($opportunityAccessForAccountOwner) && empty($opportunityAccessForAccountOwner))) {
            unset($this->OpportunityAccessForAccountOwner);
        } else {
            $this->OpportunityAccessForAccountOwner = $opportunityAccessForAccountOwner;
        }
        return $this;
    }
    /**
     * Get ParentRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentRoleId()
    {
        return isset($this->ParentRoleId) ? $this->ParentRoleId : null;
    }
    /**
     * Set ParentRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentRoleId
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setParentRoleId($parentRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($parentRoleId) && !is_string($parentRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentRoleId, true), gettype($parentRoleId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentRoleId) && mb_strlen($parentRoleId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentRoleId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentRoleId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentRoleId, true)), __LINE__);
        }
        if (is_null($parentRoleId) || (is_array($parentRoleId) && empty($parentRoleId))) {
            unset($this->ParentRoleId);
        } else {
            $this->ParentRoleId = $parentRoleId;
        }
        return $this;
    }
    /**
     * Get PortalAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPortalAccountId()
    {
        return isset($this->PortalAccountId) ? $this->PortalAccountId : null;
    }
    /**
     * Set PortalAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $portalAccountId
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setPortalAccountId($portalAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($portalAccountId) && !is_string($portalAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($portalAccountId, true), gettype($portalAccountId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($portalAccountId) && mb_strlen($portalAccountId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($portalAccountId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($portalAccountId) && !preg_match('/[a-zA-Z0-9]{18}/', $portalAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($portalAccountId, true)), __LINE__);
        }
        if (is_null($portalAccountId) || (is_array($portalAccountId) && empty($portalAccountId))) {
            unset($this->PortalAccountId);
        } else {
            $this->PortalAccountId = $portalAccountId;
        }
        return $this;
    }
    /**
     * Get PortalAccountOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPortalAccountOwnerId()
    {
        return isset($this->PortalAccountOwnerId) ? $this->PortalAccountOwnerId : null;
    }
    /**
     * Set PortalAccountOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $portalAccountOwnerId
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setPortalAccountOwnerId($portalAccountOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($portalAccountOwnerId) && !is_string($portalAccountOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($portalAccountOwnerId, true), gettype($portalAccountOwnerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($portalAccountOwnerId) && mb_strlen($portalAccountOwnerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($portalAccountOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($portalAccountOwnerId) && !preg_match('/[a-zA-Z0-9]{18}/', $portalAccountOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($portalAccountOwnerId, true)), __LINE__);
        }
        if (is_null($portalAccountOwnerId) || (is_array($portalAccountOwnerId) && empty($portalAccountOwnerId))) {
            unset($this->PortalAccountOwnerId);
        } else {
            $this->PortalAccountOwnerId = $portalAccountOwnerId;
        }
        return $this;
    }
    /**
     * Get PortalRole value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPortalRole()
    {
        return isset($this->PortalRole) ? $this->PortalRole : null;
    }
    /**
     * Set PortalRole value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $portalRole
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setPortalRole($portalRole = null)
    {
        // validation for constraint: string
        if (!is_null($portalRole) && !is_string($portalRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($portalRole, true), gettype($portalRole)), __LINE__);
        }
        if (is_null($portalRole) || (is_array($portalRole) && empty($portalRole))) {
            unset($this->PortalRole);
        } else {
            $this->PortalRole = $portalRole;
        }
        return $this;
    }
    /**
     * Get PortalType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPortalType()
    {
        return isset($this->PortalType) ? $this->PortalType : null;
    }
    /**
     * Set PortalType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $portalType
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setPortalType($portalType = null)
    {
        // validation for constraint: string
        if (!is_null($portalType) && !is_string($portalType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($portalType, true), gettype($portalType)), __LINE__);
        }
        if (is_null($portalType) || (is_array($portalType) && empty($portalType))) {
            unset($this->PortalType);
        } else {
            $this->PortalType = $portalType;
        }
        return $this;
    }
    /**
     * Get RollupDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRollupDescription()
    {
        return isset($this->RollupDescription) ? $this->RollupDescription : null;
    }
    /**
     * Set RollupDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rollupDescription
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setRollupDescription($rollupDescription = null)
    {
        // validation for constraint: string
        if (!is_null($rollupDescription) && !is_string($rollupDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rollupDescription, true), gettype($rollupDescription)), __LINE__);
        }
        if (is_null($rollupDescription) || (is_array($rollupDescription) && empty($rollupDescription))) {
            unset($this->RollupDescription);
        } else {
            $this->RollupDescription = $rollupDescription;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get Users value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getUsers()
    {
        return isset($this->Users) ? $this->Users : null;
    }
    /**
     * Set Users value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $users
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public function setUsers(\NexusDigital/MiratelForce\StructType\QueryResult $users = null)
    {
        if (is_null($users) || (is_array($users) && empty($users))) {
            unset($this->Users);
        } else {
            $this->Users = $users;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\UserRole
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
