<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserFieldAccess StructType
 * @subpackage Structs
 */
class UserFieldAccess extends SObject
{
    /**
     * The DurableId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurableId;
    /**
     * The EntityDefinition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\EntityDefinition
     */
    public $EntityDefinition;
    /**
     * The EntityDefinitionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityDefinitionId;
    /**
     * The FieldDefinition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public $FieldDefinition;
    /**
     * The FieldDefinitionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FieldDefinitionId;
    /**
     * The IsAccessible
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAccessible;
    /**
     * The IsCreatable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCreatable;
    /**
     * The IsUpdatable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdatable;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $User;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for UserFieldAccess
     * @uses UserFieldAccess::setDurableId()
     * @uses UserFieldAccess::setEntityDefinition()
     * @uses UserFieldAccess::setEntityDefinitionId()
     * @uses UserFieldAccess::setFieldDefinition()
     * @uses UserFieldAccess::setFieldDefinitionId()
     * @uses UserFieldAccess::setIsAccessible()
     * @uses UserFieldAccess::setIsCreatable()
     * @uses UserFieldAccess::setIsUpdatable()
     * @uses UserFieldAccess::setUser()
     * @uses UserFieldAccess::setUserId()
     * @param string $durableId
     * @param \NexusDigital/MiratelForce\StructType\EntityDefinition $entityDefinition
     * @param string $entityDefinitionId
     * @param \NexusDigital/MiratelForce\StructType\FieldDefinition $fieldDefinition
     * @param string $fieldDefinitionId
     * @param bool $isAccessible
     * @param bool $isCreatable
     * @param bool $isUpdatable
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @param string $userId
     */
    public function __construct($durableId = null, \NexusDigital/MiratelForce\StructType\EntityDefinition $entityDefinition = null, $entityDefinitionId = null, \NexusDigital/MiratelForce\StructType\FieldDefinition $fieldDefinition = null, $fieldDefinitionId = null, $isAccessible = null, $isCreatable = null, $isUpdatable = null, \NexusDigital/MiratelForce\StructType\User $user = null, $userId = null)
    {
        $this
            ->setDurableId($durableId)
            ->setEntityDefinition($entityDefinition)
            ->setEntityDefinitionId($entityDefinitionId)
            ->setFieldDefinition($fieldDefinition)
            ->setFieldDefinitionId($fieldDefinitionId)
            ->setIsAccessible($isAccessible)
            ->setIsCreatable($isCreatable)
            ->setIsUpdatable($isUpdatable)
            ->setUser($user)
            ->setUserId($userId);
    }
    /**
     * Get DurableId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurableId()
    {
        return isset($this->DurableId) ? $this->DurableId : null;
    }
    /**
     * Set DurableId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $durableId
     * @return \NexusDigital/MiratelForce\StructType\UserFieldAccess
     */
    public function setDurableId($durableId = null)
    {
        // validation for constraint: string
        if (!is_null($durableId) && !is_string($durableId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durableId, true), gettype($durableId)), __LINE__);
        }
        if (is_null($durableId) || (is_array($durableId) && empty($durableId))) {
            unset($this->DurableId);
        } else {
            $this->DurableId = $durableId;
        }
        return $this;
    }
    /**
     * Get EntityDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\EntityDefinition|null
     */
    public function getEntityDefinition()
    {
        return isset($this->EntityDefinition) ? $this->EntityDefinition : null;
    }
    /**
     * Set EntityDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\EntityDefinition $entityDefinition
     * @return \NexusDigital/MiratelForce\StructType\UserFieldAccess
     */
    public function setEntityDefinition(\NexusDigital/MiratelForce\StructType\EntityDefinition $entityDefinition = null)
    {
        if (is_null($entityDefinition) || (is_array($entityDefinition) && empty($entityDefinition))) {
            unset($this->EntityDefinition);
        } else {
            $this->EntityDefinition = $entityDefinition;
        }
        return $this;
    }
    /**
     * Get EntityDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityDefinitionId()
    {
        return isset($this->EntityDefinitionId) ? $this->EntityDefinitionId : null;
    }
    /**
     * Set EntityDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityDefinitionId
     * @return \NexusDigital/MiratelForce\StructType\UserFieldAccess
     */
    public function setEntityDefinitionId($entityDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($entityDefinitionId) && !is_string($entityDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityDefinitionId, true), gettype($entityDefinitionId)), __LINE__);
        }
        if (is_null($entityDefinitionId) || (is_array($entityDefinitionId) && empty($entityDefinitionId))) {
            unset($this->EntityDefinitionId);
        } else {
            $this->EntityDefinitionId = $entityDefinitionId;
        }
        return $this;
    }
    /**
     * Get FieldDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition|null
     */
    public function getFieldDefinition()
    {
        return isset($this->FieldDefinition) ? $this->FieldDefinition : null;
    }
    /**
     * Set FieldDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\FieldDefinition $fieldDefinition
     * @return \NexusDigital/MiratelForce\StructType\UserFieldAccess
     */
    public function setFieldDefinition(\NexusDigital/MiratelForce\StructType\FieldDefinition $fieldDefinition = null)
    {
        if (is_null($fieldDefinition) || (is_array($fieldDefinition) && empty($fieldDefinition))) {
            unset($this->FieldDefinition);
        } else {
            $this->FieldDefinition = $fieldDefinition;
        }
        return $this;
    }
    /**
     * Get FieldDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFieldDefinitionId()
    {
        return isset($this->FieldDefinitionId) ? $this->FieldDefinitionId : null;
    }
    /**
     * Set FieldDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fieldDefinitionId
     * @return \NexusDigital/MiratelForce\StructType\UserFieldAccess
     */
    public function setFieldDefinitionId($fieldDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($fieldDefinitionId) && !is_string($fieldDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldDefinitionId, true), gettype($fieldDefinitionId)), __LINE__);
        }
        if (is_null($fieldDefinitionId) || (is_array($fieldDefinitionId) && empty($fieldDefinitionId))) {
            unset($this->FieldDefinitionId);
        } else {
            $this->FieldDefinitionId = $fieldDefinitionId;
        }
        return $this;
    }
    /**
     * Get IsAccessible value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAccessible()
    {
        return isset($this->IsAccessible) ? $this->IsAccessible : null;
    }
    /**
     * Set IsAccessible value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAccessible
     * @return \NexusDigital/MiratelForce\StructType\UserFieldAccess
     */
    public function setIsAccessible($isAccessible = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccessible) && !is_bool($isAccessible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAccessible, true), gettype($isAccessible)), __LINE__);
        }
        if (is_null($isAccessible) || (is_array($isAccessible) && empty($isAccessible))) {
            unset($this->IsAccessible);
        } else {
            $this->IsAccessible = $isAccessible;
        }
        return $this;
    }
    /**
     * Get IsCreatable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCreatable()
    {
        return isset($this->IsCreatable) ? $this->IsCreatable : null;
    }
    /**
     * Set IsCreatable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCreatable
     * @return \NexusDigital/MiratelForce\StructType\UserFieldAccess
     */
    public function setIsCreatable($isCreatable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCreatable) && !is_bool($isCreatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCreatable, true), gettype($isCreatable)), __LINE__);
        }
        if (is_null($isCreatable) || (is_array($isCreatable) && empty($isCreatable))) {
            unset($this->IsCreatable);
        } else {
            $this->IsCreatable = $isCreatable;
        }
        return $this;
    }
    /**
     * Get IsUpdatable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdatable()
    {
        return isset($this->IsUpdatable) ? $this->IsUpdatable : null;
    }
    /**
     * Set IsUpdatable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdatable
     * @return \NexusDigital/MiratelForce\StructType\UserFieldAccess
     */
    public function setIsUpdatable($isUpdatable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdatable) && !is_bool($isUpdatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdatable, true), gettype($isUpdatable)), __LINE__);
        }
        if (is_null($isUpdatable) || (is_array($isUpdatable) && empty($isUpdatable))) {
            unset($this->IsUpdatable);
        } else {
            $this->IsUpdatable = $isUpdatable;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @return \NexusDigital/MiratelForce\StructType\UserFieldAccess
     */
    public function setUser(\NexusDigital/MiratelForce\StructType\User $user = null)
    {
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \NexusDigital/MiratelForce\StructType\UserFieldAccess
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userId) && mb_strlen($userId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userId) && !preg_match('/[a-zA-Z0-9]{18}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\UserFieldAccess
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
