<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ThirdPartyAccountLink StructType
 * @subpackage Structs
 */
class ThirdPartyAccountLink extends SObject
{
    /**
     * The Handle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Handle;
    /**
     * The IsNotSsoUsable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsNotSsoUsable;
    /**
     * The Provider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Provider;
    /**
     * The RemoteIdentifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RemoteIdentifier;
    /**
     * The SsoProvider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public $SsoProvider;
    /**
     * The SsoProviderId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $SsoProviderId;
    /**
     * The SsoProviderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SsoProviderName;
    /**
     * The ThirdPartyAccountLinkKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThirdPartyAccountLinkKey;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $User;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for ThirdPartyAccountLink
     * @uses ThirdPartyAccountLink::setHandle()
     * @uses ThirdPartyAccountLink::setIsNotSsoUsable()
     * @uses ThirdPartyAccountLink::setProvider()
     * @uses ThirdPartyAccountLink::setRemoteIdentifier()
     * @uses ThirdPartyAccountLink::setSsoProvider()
     * @uses ThirdPartyAccountLink::setSsoProviderId()
     * @uses ThirdPartyAccountLink::setSsoProviderName()
     * @uses ThirdPartyAccountLink::setThirdPartyAccountLinkKey()
     * @uses ThirdPartyAccountLink::setUser()
     * @uses ThirdPartyAccountLink::setUserId()
     * @param string $handle
     * @param bool $isNotSsoUsable
     * @param string $provider
     * @param string $remoteIdentifier
     * @param \NexusDigital/MiratelForce\StructType\AuthProvider $ssoProvider
     * @param string $ssoProviderId
     * @param string $ssoProviderName
     * @param string $thirdPartyAccountLinkKey
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @param string $userId
     */
    public function __construct($handle = null, $isNotSsoUsable = null, $provider = null, $remoteIdentifier = null, \NexusDigital/MiratelForce\StructType\AuthProvider $ssoProvider = null, $ssoProviderId = null, $ssoProviderName = null, $thirdPartyAccountLinkKey = null, \NexusDigital/MiratelForce\StructType\User $user = null, $userId = null)
    {
        $this
            ->setHandle($handle)
            ->setIsNotSsoUsable($isNotSsoUsable)
            ->setProvider($provider)
            ->setRemoteIdentifier($remoteIdentifier)
            ->setSsoProvider($ssoProvider)
            ->setSsoProviderId($ssoProviderId)
            ->setSsoProviderName($ssoProviderName)
            ->setThirdPartyAccountLinkKey($thirdPartyAccountLinkKey)
            ->setUser($user)
            ->setUserId($userId);
    }
    /**
     * Get Handle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandle()
    {
        return isset($this->Handle) ? $this->Handle : null;
    }
    /**
     * Set Handle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handle
     * @return \NexusDigital/MiratelForce\StructType\ThirdPartyAccountLink
     */
    public function setHandle($handle = null)
    {
        // validation for constraint: string
        if (!is_null($handle) && !is_string($handle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handle, true), gettype($handle)), __LINE__);
        }
        if (is_null($handle) || (is_array($handle) && empty($handle))) {
            unset($this->Handle);
        } else {
            $this->Handle = $handle;
        }
        return $this;
    }
    /**
     * Get IsNotSsoUsable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNotSsoUsable()
    {
        return isset($this->IsNotSsoUsable) ? $this->IsNotSsoUsable : null;
    }
    /**
     * Set IsNotSsoUsable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNotSsoUsable
     * @return \NexusDigital/MiratelForce\StructType\ThirdPartyAccountLink
     */
    public function setIsNotSsoUsable($isNotSsoUsable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNotSsoUsable) && !is_bool($isNotSsoUsable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNotSsoUsable, true), gettype($isNotSsoUsable)), __LINE__);
        }
        if (is_null($isNotSsoUsable) || (is_array($isNotSsoUsable) && empty($isNotSsoUsable))) {
            unset($this->IsNotSsoUsable);
        } else {
            $this->IsNotSsoUsable = $isNotSsoUsable;
        }
        return $this;
    }
    /**
     * Get Provider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvider()
    {
        return isset($this->Provider) ? $this->Provider : null;
    }
    /**
     * Set Provider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provider
     * @return \NexusDigital/MiratelForce\StructType\ThirdPartyAccountLink
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provider, true), gettype($provider)), __LINE__);
        }
        if (is_null($provider) || (is_array($provider) && empty($provider))) {
            unset($this->Provider);
        } else {
            $this->Provider = $provider;
        }
        return $this;
    }
    /**
     * Get RemoteIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemoteIdentifier()
    {
        return isset($this->RemoteIdentifier) ? $this->RemoteIdentifier : null;
    }
    /**
     * Set RemoteIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remoteIdentifier
     * @return \NexusDigital/MiratelForce\StructType\ThirdPartyAccountLink
     */
    public function setRemoteIdentifier($remoteIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($remoteIdentifier) && !is_string($remoteIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remoteIdentifier, true), gettype($remoteIdentifier)), __LINE__);
        }
        if (is_null($remoteIdentifier) || (is_array($remoteIdentifier) && empty($remoteIdentifier))) {
            unset($this->RemoteIdentifier);
        } else {
            $this->RemoteIdentifier = $remoteIdentifier;
        }
        return $this;
    }
    /**
     * Get SsoProvider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider|null
     */
    public function getSsoProvider()
    {
        return isset($this->SsoProvider) ? $this->SsoProvider : null;
    }
    /**
     * Set SsoProvider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\AuthProvider $ssoProvider
     * @return \NexusDigital/MiratelForce\StructType\ThirdPartyAccountLink
     */
    public function setSsoProvider(\NexusDigital/MiratelForce\StructType\AuthProvider $ssoProvider = null)
    {
        if (is_null($ssoProvider) || (is_array($ssoProvider) && empty($ssoProvider))) {
            unset($this->SsoProvider);
        } else {
            $this->SsoProvider = $ssoProvider;
        }
        return $this;
    }
    /**
     * Get SsoProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSsoProviderId()
    {
        return isset($this->SsoProviderId) ? $this->SsoProviderId : null;
    }
    /**
     * Set SsoProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ssoProviderId
     * @return \NexusDigital/MiratelForce\StructType\ThirdPartyAccountLink
     */
    public function setSsoProviderId($ssoProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($ssoProviderId) && !is_string($ssoProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ssoProviderId, true), gettype($ssoProviderId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ssoProviderId) && mb_strlen($ssoProviderId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ssoProviderId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ssoProviderId) && !preg_match('/[a-zA-Z0-9]{18}/', $ssoProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ssoProviderId, true)), __LINE__);
        }
        if (is_null($ssoProviderId) || (is_array($ssoProviderId) && empty($ssoProviderId))) {
            unset($this->SsoProviderId);
        } else {
            $this->SsoProviderId = $ssoProviderId;
        }
        return $this;
    }
    /**
     * Get SsoProviderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSsoProviderName()
    {
        return isset($this->SsoProviderName) ? $this->SsoProviderName : null;
    }
    /**
     * Set SsoProviderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ssoProviderName
     * @return \NexusDigital/MiratelForce\StructType\ThirdPartyAccountLink
     */
    public function setSsoProviderName($ssoProviderName = null)
    {
        // validation for constraint: string
        if (!is_null($ssoProviderName) && !is_string($ssoProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ssoProviderName, true), gettype($ssoProviderName)), __LINE__);
        }
        if (is_null($ssoProviderName) || (is_array($ssoProviderName) && empty($ssoProviderName))) {
            unset($this->SsoProviderName);
        } else {
            $this->SsoProviderName = $ssoProviderName;
        }
        return $this;
    }
    /**
     * Get ThirdPartyAccountLinkKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThirdPartyAccountLinkKey()
    {
        return isset($this->ThirdPartyAccountLinkKey) ? $this->ThirdPartyAccountLinkKey : null;
    }
    /**
     * Set ThirdPartyAccountLinkKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thirdPartyAccountLinkKey
     * @return \NexusDigital/MiratelForce\StructType\ThirdPartyAccountLink
     */
    public function setThirdPartyAccountLinkKey($thirdPartyAccountLinkKey = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyAccountLinkKey) && !is_string($thirdPartyAccountLinkKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyAccountLinkKey, true), gettype($thirdPartyAccountLinkKey)), __LINE__);
        }
        if (is_null($thirdPartyAccountLinkKey) || (is_array($thirdPartyAccountLinkKey) && empty($thirdPartyAccountLinkKey))) {
            unset($this->ThirdPartyAccountLinkKey);
        } else {
            $this->ThirdPartyAccountLinkKey = $thirdPartyAccountLinkKey;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @return \NexusDigital/MiratelForce\StructType\ThirdPartyAccountLink
     */
    public function setUser(\NexusDigital/MiratelForce\StructType\User $user = null)
    {
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \NexusDigital/MiratelForce\StructType\ThirdPartyAccountLink
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userId) && mb_strlen($userId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userId) && !preg_match('/[a-zA-Z0-9]{18}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ThirdPartyAccountLink
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
