<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TenantUsageEntitlement StructType
 * @subpackage Structs
 */
class TenantUsageEntitlement extends SObject
{
    /**
     * The AmountUsed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AmountUsed;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The CurrentAmountAllowed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CurrentAmountAllowed;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The Frequency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Frequency;
    /**
     * The HasRollover
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasRollover;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsPersistentResource
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPersistentResource;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The MasterLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterLabel;
    /**
     * The OverageGrace
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OverageGrace;
    /**
     * The ResourceGroupKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResourceGroupKey;
    /**
     * The Setting
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Setting;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The UsageDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UsageDate;
    /**
     * Constructor method for TenantUsageEntitlement
     * @uses TenantUsageEntitlement::setAmountUsed()
     * @uses TenantUsageEntitlement::setCreatedBy()
     * @uses TenantUsageEntitlement::setCreatedById()
     * @uses TenantUsageEntitlement::setCreatedDate()
     * @uses TenantUsageEntitlement::setCurrentAmountAllowed()
     * @uses TenantUsageEntitlement::setEndDate()
     * @uses TenantUsageEntitlement::setFrequency()
     * @uses TenantUsageEntitlement::setHasRollover()
     * @uses TenantUsageEntitlement::setIsDeleted()
     * @uses TenantUsageEntitlement::setIsPersistentResource()
     * @uses TenantUsageEntitlement::setLastModifiedBy()
     * @uses TenantUsageEntitlement::setLastModifiedById()
     * @uses TenantUsageEntitlement::setLastModifiedDate()
     * @uses TenantUsageEntitlement::setMasterLabel()
     * @uses TenantUsageEntitlement::setOverageGrace()
     * @uses TenantUsageEntitlement::setResourceGroupKey()
     * @uses TenantUsageEntitlement::setSetting()
     * @uses TenantUsageEntitlement::setStartDate()
     * @uses TenantUsageEntitlement::setSystemModstamp()
     * @uses TenantUsageEntitlement::setUsageDate()
     * @param float $amountUsed
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param float $currentAmountAllowed
     * @param string $endDate
     * @param string $frequency
     * @param bool $hasRollover
     * @param bool $isDeleted
     * @param bool $isPersistentResource
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $masterLabel
     * @param float $overageGrace
     * @param string $resourceGroupKey
     * @param string $setting
     * @param string $startDate
     * @param string $systemModstamp
     * @param string $usageDate
     */
    public function __construct($amountUsed = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $currentAmountAllowed = null, $endDate = null, $frequency = null, $hasRollover = null, $isDeleted = null, $isPersistentResource = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $masterLabel = null, $overageGrace = null, $resourceGroupKey = null, $setting = null, $startDate = null, $systemModstamp = null, $usageDate = null)
    {
        $this
            ->setAmountUsed($amountUsed)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setCurrentAmountAllowed($currentAmountAllowed)
            ->setEndDate($endDate)
            ->setFrequency($frequency)
            ->setHasRollover($hasRollover)
            ->setIsDeleted($isDeleted)
            ->setIsPersistentResource($isPersistentResource)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setMasterLabel($masterLabel)
            ->setOverageGrace($overageGrace)
            ->setResourceGroupKey($resourceGroupKey)
            ->setSetting($setting)
            ->setStartDate($startDate)
            ->setSystemModstamp($systemModstamp)
            ->setUsageDate($usageDate);
    }
    /**
     * Get AmountUsed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmountUsed()
    {
        return isset($this->AmountUsed) ? $this->AmountUsed : null;
    }
    /**
     * Set AmountUsed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amountUsed
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setAmountUsed($amountUsed = null)
    {
        // validation for constraint: float
        if (!is_null($amountUsed) && !(is_float($amountUsed) || is_numeric($amountUsed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountUsed, true), gettype($amountUsed)), __LINE__);
        }
        if (is_null($amountUsed) || (is_array($amountUsed) && empty($amountUsed))) {
            unset($this->AmountUsed);
        } else {
            $this->AmountUsed = $amountUsed;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get CurrentAmountAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCurrentAmountAllowed()
    {
        return isset($this->CurrentAmountAllowed) ? $this->CurrentAmountAllowed : null;
    }
    /**
     * Set CurrentAmountAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $currentAmountAllowed
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setCurrentAmountAllowed($currentAmountAllowed = null)
    {
        // validation for constraint: float
        if (!is_null($currentAmountAllowed) && !(is_float($currentAmountAllowed) || is_numeric($currentAmountAllowed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currentAmountAllowed, true), gettype($currentAmountAllowed)), __LINE__);
        }
        if (is_null($currentAmountAllowed) || (is_array($currentAmountAllowed) && empty($currentAmountAllowed))) {
            unset($this->CurrentAmountAllowed);
        } else {
            $this->CurrentAmountAllowed = $currentAmountAllowed;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get Frequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrequency()
    {
        return isset($this->Frequency) ? $this->Frequency : null;
    }
    /**
     * Set Frequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frequency
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: string
        if (!is_null($frequency) && !is_string($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequency, true), gettype($frequency)), __LINE__);
        }
        if (is_null($frequency) || (is_array($frequency) && empty($frequency))) {
            unset($this->Frequency);
        } else {
            $this->Frequency = $frequency;
        }
        return $this;
    }
    /**
     * Get HasRollover value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasRollover()
    {
        return isset($this->HasRollover) ? $this->HasRollover : null;
    }
    /**
     * Set HasRollover value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasRollover
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setHasRollover($hasRollover = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasRollover) && !is_bool($hasRollover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasRollover, true), gettype($hasRollover)), __LINE__);
        }
        if (is_null($hasRollover) || (is_array($hasRollover) && empty($hasRollover))) {
            unset($this->HasRollover);
        } else {
            $this->HasRollover = $hasRollover;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsPersistentResource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPersistentResource()
    {
        return isset($this->IsPersistentResource) ? $this->IsPersistentResource : null;
    }
    /**
     * Set IsPersistentResource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPersistentResource
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setIsPersistentResource($isPersistentResource = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPersistentResource) && !is_bool($isPersistentResource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPersistentResource, true), gettype($isPersistentResource)), __LINE__);
        }
        if (is_null($isPersistentResource) || (is_array($isPersistentResource) && empty($isPersistentResource))) {
            unset($this->IsPersistentResource);
        } else {
            $this->IsPersistentResource = $isPersistentResource;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get MasterLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterLabel()
    {
        return isset($this->MasterLabel) ? $this->MasterLabel : null;
    }
    /**
     * Set MasterLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterLabel
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setMasterLabel($masterLabel = null)
    {
        // validation for constraint: string
        if (!is_null($masterLabel) && !is_string($masterLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterLabel, true), gettype($masterLabel)), __LINE__);
        }
        if (is_null($masterLabel) || (is_array($masterLabel) && empty($masterLabel))) {
            unset($this->MasterLabel);
        } else {
            $this->MasterLabel = $masterLabel;
        }
        return $this;
    }
    /**
     * Get OverageGrace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOverageGrace()
    {
        return isset($this->OverageGrace) ? $this->OverageGrace : null;
    }
    /**
     * Set OverageGrace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $overageGrace
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setOverageGrace($overageGrace = null)
    {
        // validation for constraint: float
        if (!is_null($overageGrace) && !(is_float($overageGrace) || is_numeric($overageGrace))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($overageGrace, true), gettype($overageGrace)), __LINE__);
        }
        if (is_null($overageGrace) || (is_array($overageGrace) && empty($overageGrace))) {
            unset($this->OverageGrace);
        } else {
            $this->OverageGrace = $overageGrace;
        }
        return $this;
    }
    /**
     * Get ResourceGroupKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResourceGroupKey()
    {
        return isset($this->ResourceGroupKey) ? $this->ResourceGroupKey : null;
    }
    /**
     * Set ResourceGroupKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resourceGroupKey
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setResourceGroupKey($resourceGroupKey = null)
    {
        // validation for constraint: string
        if (!is_null($resourceGroupKey) && !is_string($resourceGroupKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resourceGroupKey, true), gettype($resourceGroupKey)), __LINE__);
        }
        if (is_null($resourceGroupKey) || (is_array($resourceGroupKey) && empty($resourceGroupKey))) {
            unset($this->ResourceGroupKey);
        } else {
            $this->ResourceGroupKey = $resourceGroupKey;
        }
        return $this;
    }
    /**
     * Get Setting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSetting()
    {
        return isset($this->Setting) ? $this->Setting : null;
    }
    /**
     * Set Setting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $setting
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setSetting($setting = null)
    {
        // validation for constraint: string
        if (!is_null($setting) && !is_string($setting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($setting, true), gettype($setting)), __LINE__);
        }
        if (is_null($setting) || (is_array($setting) && empty($setting))) {
            unset($this->Setting);
        } else {
            $this->Setting = $setting;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get UsageDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsageDate()
    {
        return isset($this->UsageDate) ? $this->UsageDate : null;
    }
    /**
     * Set UsageDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $usageDate
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public function setUsageDate($usageDate = null)
    {
        // validation for constraint: string
        if (!is_null($usageDate) && !is_string($usageDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usageDate, true), gettype($usageDate)), __LINE__);
        }
        if (is_null($usageDate) || (is_array($usageDate) && empty($usageDate))) {
            unset($this->UsageDate);
        } else {
            $this->UsageDate = $usageDate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\TenantUsageEntitlement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
