<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SocialPost StructType
 * @subpackage Structs
 */
class SocialPost extends SObject
{
    /**
     * The AnalyzerScore
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AnalyzerScore;
    /**
     * The AssignedTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssignedTo;
    /**
     * The AttachedContentDocuments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentDocuments;
    /**
     * The AttachedContentNotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentNotes;
    /**
     * The AttachmentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttachmentType;
    /**
     * The AttachmentUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttachmentUrl;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Attachments;
    /**
     * The Classification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Classification;
    /**
     * The CombinedAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CombinedAttachments;
    /**
     * The CommentCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CommentCount;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Content;
    /**
     * The ContentDocumentIds
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string[]
     */
    public $ContentDocumentIds;
    /**
     * The ContentDocumentLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContentDocumentLinks;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DeletedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $DeletedBy;
    /**
     * The DeletedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $DeletedById;
    /**
     * The EngagementLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EngagementLevel;
    /**
     * The ExternalPostId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalPostId;
    /**
     * The FeedSubscriptionsForEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $FeedSubscriptionsForEntity;
    /**
     * The Feeds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Feeds;
    /**
     * The Handle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Handle;
    /**
     * The HarvestDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HarvestDate;
    /**
     * The Headline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Headline;
    /**
     * The HiddenBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $HiddenBy;
    /**
     * The HiddenById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $HiddenById;
    /**
     * The Histories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Histories;
    /**
     * The InboundLinkCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InboundLinkCount;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsOutbound
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOutbound;
    /**
     * The KeywordGroupName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KeywordGroupName;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastReferencedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastReferencedDate;
    /**
     * The LastViewedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastViewedDate;
    /**
     * The LikedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LikedBy;
    /**
     * The LikesAndVotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LikesAndVotes;
    /**
     * The MediaProvider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MediaProvider;
    /**
     * The MediaType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MediaType;
    /**
     * The MessageType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MessageType;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Notes;
    /**
     * The NotesAndAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NotesAndAttachments;
    /**
     * The OutboundSocialAccount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public $OutboundSocialAccount;
    /**
     * The OutboundSocialAccountId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OutboundSocialAccountId;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $Owner;
    /**
     * The OwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OwnerId;
    /**
     * The Parent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $Parent;
    /**
     * The ParentEntities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ParentEntities;
    /**
     * The ParentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentId;
    /**
     * The Persona
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public $Persona;
    /**
     * The PersonaId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PersonaId;
    /**
     * The Personas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Personas;
    /**
     * The PostPriority
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostPriority;
    /**
     * The PostTags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostTags;
    /**
     * The PostUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostUrl;
    /**
     * The Posted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Posted;
    /**
     * The ProcessInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessInstances;
    /**
     * The ProcessSteps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessSteps;
    /**
     * The Provider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Provider;
    /**
     * The R6PostId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $R6PostId;
    /**
     * The R6SourceId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $R6SourceId;
    /**
     * The R6TopicId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $R6TopicId;
    /**
     * The Recipient
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Recipient;
    /**
     * The RecipientType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecipientType;
    /**
     * The RecordActionHistories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RecordActionHistories;
    /**
     * The RecordActions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RecordActions;
    /**
     * The Replies
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Replies;
    /**
     * The ReplyTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public $ReplyTo;
    /**
     * The ReplyToId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ReplyToId;
    /**
     * The ResponseContextExternalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseContextExternalId;
    /**
     * The ReviewScale
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ReviewScale;
    /**
     * The ReviewScore
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ReviewScore;
    /**
     * The ReviewedStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReviewedStatus;
    /**
     * The Sentiment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sentiment;
    /**
     * The Shares
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Shares;
    /**
     * The SourceTags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceTags;
    /**
     * The SpamRating
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpamRating;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The StatusMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusMessage;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The ThreadSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ThreadSize;
    /**
     * The TopicProfileName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TopicProfileName;
    /**
     * The TopicType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TopicType;
    /**
     * The TruncatedContent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TruncatedContent;
    /**
     * The UniqueCommentors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UniqueCommentors;
    /**
     * The UserRecordAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public $UserRecordAccess;
    /**
     * The ViewCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ViewCount;
    /**
     * The Who
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $Who;
    /**
     * The WhoId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $WhoId;
    /**
     * Constructor method for SocialPost
     * @uses SocialPost::setAnalyzerScore()
     * @uses SocialPost::setAssignedTo()
     * @uses SocialPost::setAttachedContentDocuments()
     * @uses SocialPost::setAttachedContentNotes()
     * @uses SocialPost::setAttachmentType()
     * @uses SocialPost::setAttachmentUrl()
     * @uses SocialPost::setAttachments()
     * @uses SocialPost::setClassification()
     * @uses SocialPost::setCombinedAttachments()
     * @uses SocialPost::setCommentCount()
     * @uses SocialPost::setContent()
     * @uses SocialPost::setContentDocumentIds()
     * @uses SocialPost::setContentDocumentLinks()
     * @uses SocialPost::setCreatedBy()
     * @uses SocialPost::setCreatedById()
     * @uses SocialPost::setCreatedDate()
     * @uses SocialPost::setDeletedBy()
     * @uses SocialPost::setDeletedById()
     * @uses SocialPost::setEngagementLevel()
     * @uses SocialPost::setExternalPostId()
     * @uses SocialPost::setFeedSubscriptionsForEntity()
     * @uses SocialPost::setFeeds()
     * @uses SocialPost::setHandle()
     * @uses SocialPost::setHarvestDate()
     * @uses SocialPost::setHeadline()
     * @uses SocialPost::setHiddenBy()
     * @uses SocialPost::setHiddenById()
     * @uses SocialPost::setHistories()
     * @uses SocialPost::setInboundLinkCount()
     * @uses SocialPost::setIsDeleted()
     * @uses SocialPost::setIsOutbound()
     * @uses SocialPost::setKeywordGroupName()
     * @uses SocialPost::setLanguage()
     * @uses SocialPost::setLastModifiedBy()
     * @uses SocialPost::setLastModifiedById()
     * @uses SocialPost::setLastModifiedDate()
     * @uses SocialPost::setLastReferencedDate()
     * @uses SocialPost::setLastViewedDate()
     * @uses SocialPost::setLikedBy()
     * @uses SocialPost::setLikesAndVotes()
     * @uses SocialPost::setMediaProvider()
     * @uses SocialPost::setMediaType()
     * @uses SocialPost::setMessageType()
     * @uses SocialPost::setName()
     * @uses SocialPost::setNotes()
     * @uses SocialPost::setNotesAndAttachments()
     * @uses SocialPost::setOutboundSocialAccount()
     * @uses SocialPost::setOutboundSocialAccountId()
     * @uses SocialPost::setOwner()
     * @uses SocialPost::setOwnerId()
     * @uses SocialPost::setParent()
     * @uses SocialPost::setParentEntities()
     * @uses SocialPost::setParentId()
     * @uses SocialPost::setPersona()
     * @uses SocialPost::setPersonaId()
     * @uses SocialPost::setPersonas()
     * @uses SocialPost::setPostPriority()
     * @uses SocialPost::setPostTags()
     * @uses SocialPost::setPostUrl()
     * @uses SocialPost::setPosted()
     * @uses SocialPost::setProcessInstances()
     * @uses SocialPost::setProcessSteps()
     * @uses SocialPost::setProvider()
     * @uses SocialPost::setR6PostId()
     * @uses SocialPost::setR6SourceId()
     * @uses SocialPost::setR6TopicId()
     * @uses SocialPost::setRecipient()
     * @uses SocialPost::setRecipientType()
     * @uses SocialPost::setRecordActionHistories()
     * @uses SocialPost::setRecordActions()
     * @uses SocialPost::setReplies()
     * @uses SocialPost::setReplyTo()
     * @uses SocialPost::setReplyToId()
     * @uses SocialPost::setResponseContextExternalId()
     * @uses SocialPost::setReviewScale()
     * @uses SocialPost::setReviewScore()
     * @uses SocialPost::setReviewedStatus()
     * @uses SocialPost::setSentiment()
     * @uses SocialPost::setShares()
     * @uses SocialPost::setSourceTags()
     * @uses SocialPost::setSpamRating()
     * @uses SocialPost::setStatus()
     * @uses SocialPost::setStatusMessage()
     * @uses SocialPost::setSystemModstamp()
     * @uses SocialPost::setThreadSize()
     * @uses SocialPost::setTopicProfileName()
     * @uses SocialPost::setTopicType()
     * @uses SocialPost::setTruncatedContent()
     * @uses SocialPost::setUniqueCommentors()
     * @uses SocialPost::setUserRecordAccess()
     * @uses SocialPost::setViewCount()
     * @uses SocialPost::setWho()
     * @uses SocialPost::setWhoId()
     * @param float $analyzerScore
     * @param string $assignedTo
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @param string $attachmentType
     * @param string $attachmentUrl
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachments
     * @param string $classification
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @param int $commentCount
     * @param string $content
     * @param string[] $contentDocumentIds
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\User $deletedBy
     * @param string $deletedById
     * @param string $engagementLevel
     * @param string $externalPostId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feeds
     * @param string $handle
     * @param string $harvestDate
     * @param string $headline
     * @param \NexusDigital/MiratelForce\StructType\User $hiddenBy
     * @param string $hiddenById
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @param int $inboundLinkCount
     * @param bool $isDeleted
     * @param bool $isOutbound
     * @param string $keywordGroupName
     * @param string $language
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $lastReferencedDate
     * @param string $lastViewedDate
     * @param string $likedBy
     * @param int $likesAndVotes
     * @param string $mediaProvider
     * @param string $mediaType
     * @param string $messageType
     * @param string $name
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notes
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments
     * @param \NexusDigital/MiratelForce\StructType\ExternalSocialAccount $outboundSocialAccount
     * @param string $outboundSocialAccountId
     * @param \NexusDigital/MiratelForce\StructType\SObject $owner
     * @param string $ownerId
     * @param \NexusDigital/MiratelForce\StructType\SObject $parent
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities
     * @param string $parentId
     * @param \NexusDigital/MiratelForce\StructType\SocialPersona $persona
     * @param string $personaId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $personas
     * @param string $postPriority
     * @param string $postTags
     * @param string $postUrl
     * @param string $posted
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @param string $provider
     * @param string $r6PostId
     * @param string $r6SourceId
     * @param string $r6TopicId
     * @param string $recipient
     * @param string $recipientType
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActions
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $replies
     * @param \NexusDigital/MiratelForce\StructType\SocialPost $replyTo
     * @param string $replyToId
     * @param string $responseContextExternalId
     * @param float $reviewScale
     * @param float $reviewScore
     * @param string $reviewedStatus
     * @param string $sentiment
     * @param int $shares
     * @param string $sourceTags
     * @param string $spamRating
     * @param string $status
     * @param string $statusMessage
     * @param string $systemModstamp
     * @param int $threadSize
     * @param string $topicProfileName
     * @param string $topicType
     * @param string $truncatedContent
     * @param int $uniqueCommentors
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @param int $viewCount
     * @param \NexusDigital/MiratelForce\StructType\SObject $who
     * @param string $whoId
     */
    public function __construct($analyzerScore = null, $assignedTo = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null, $attachmentType = null, $attachmentUrl = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachments = null, $classification = null, \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null, $commentCount = null, $content = null, array $contentDocumentIds = array(), \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\User $deletedBy = null, $deletedById = null, $engagementLevel = null, $externalPostId = null, \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity = null, \NexusDigital/MiratelForce\StructType\QueryResult $feeds = null, $handle = null, $harvestDate = null, $headline = null, \NexusDigital/MiratelForce\StructType\User $hiddenBy = null, $hiddenById = null, \NexusDigital/MiratelForce\StructType\QueryResult $histories = null, $inboundLinkCount = null, $isDeleted = null, $isOutbound = null, $keywordGroupName = null, $language = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lastReferencedDate = null, $lastViewedDate = null, $likedBy = null, $likesAndVotes = null, $mediaProvider = null, $mediaType = null, $messageType = null, $name = null, \NexusDigital/MiratelForce\StructType\QueryResult $notes = null, \NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments = null, \NexusDigital/MiratelForce\StructType\ExternalSocialAccount $outboundSocialAccount = null, $outboundSocialAccountId = null, \NexusDigital/MiratelForce\StructType\SObject $owner = null, $ownerId = null, \NexusDigital/MiratelForce\StructType\SObject $parent = null, \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities = null, $parentId = null, \NexusDigital/MiratelForce\StructType\SocialPersona $persona = null, $personaId = null, \NexusDigital/MiratelForce\StructType\QueryResult $personas = null, $postPriority = null, $postTags = null, $postUrl = null, $posted = null, \NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null, \NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null, $provider = null, $r6PostId = null, $r6SourceId = null, $r6TopicId = null, $recipient = null, $recipientType = null, \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories = null, \NexusDigital/MiratelForce\StructType\QueryResult $recordActions = null, \NexusDigital/MiratelForce\StructType\QueryResult $replies = null, \NexusDigital/MiratelForce\StructType\SocialPost $replyTo = null, $replyToId = null, $responseContextExternalId = null, $reviewScale = null, $reviewScore = null, $reviewedStatus = null, $sentiment = null, $shares = null, $sourceTags = null, $spamRating = null, $status = null, $statusMessage = null, $systemModstamp = null, $threadSize = null, $topicProfileName = null, $topicType = null, $truncatedContent = null, $uniqueCommentors = null, \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null, $viewCount = null, \NexusDigital/MiratelForce\StructType\SObject $who = null, $whoId = null)
    {
        $this
            ->setAnalyzerScore($analyzerScore)
            ->setAssignedTo($assignedTo)
            ->setAttachedContentDocuments($attachedContentDocuments)
            ->setAttachedContentNotes($attachedContentNotes)
            ->setAttachmentType($attachmentType)
            ->setAttachmentUrl($attachmentUrl)
            ->setAttachments($attachments)
            ->setClassification($classification)
            ->setCombinedAttachments($combinedAttachments)
            ->setCommentCount($commentCount)
            ->setContent($content)
            ->setContentDocumentIds($contentDocumentIds)
            ->setContentDocumentLinks($contentDocumentLinks)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDeletedBy($deletedBy)
            ->setDeletedById($deletedById)
            ->setEngagementLevel($engagementLevel)
            ->setExternalPostId($externalPostId)
            ->setFeedSubscriptionsForEntity($feedSubscriptionsForEntity)
            ->setFeeds($feeds)
            ->setHandle($handle)
            ->setHarvestDate($harvestDate)
            ->setHeadline($headline)
            ->setHiddenBy($hiddenBy)
            ->setHiddenById($hiddenById)
            ->setHistories($histories)
            ->setInboundLinkCount($inboundLinkCount)
            ->setIsDeleted($isDeleted)
            ->setIsOutbound($isOutbound)
            ->setKeywordGroupName($keywordGroupName)
            ->setLanguage($language)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastReferencedDate($lastReferencedDate)
            ->setLastViewedDate($lastViewedDate)
            ->setLikedBy($likedBy)
            ->setLikesAndVotes($likesAndVotes)
            ->setMediaProvider($mediaProvider)
            ->setMediaType($mediaType)
            ->setMessageType($messageType)
            ->setName($name)
            ->setNotes($notes)
            ->setNotesAndAttachments($notesAndAttachments)
            ->setOutboundSocialAccount($outboundSocialAccount)
            ->setOutboundSocialAccountId($outboundSocialAccountId)
            ->setOwner($owner)
            ->setOwnerId($ownerId)
            ->setParent($parent)
            ->setParentEntities($parentEntities)
            ->setParentId($parentId)
            ->setPersona($persona)
            ->setPersonaId($personaId)
            ->setPersonas($personas)
            ->setPostPriority($postPriority)
            ->setPostTags($postTags)
            ->setPostUrl($postUrl)
            ->setPosted($posted)
            ->setProcessInstances($processInstances)
            ->setProcessSteps($processSteps)
            ->setProvider($provider)
            ->setR6PostId($r6PostId)
            ->setR6SourceId($r6SourceId)
            ->setR6TopicId($r6TopicId)
            ->setRecipient($recipient)
            ->setRecipientType($recipientType)
            ->setRecordActionHistories($recordActionHistories)
            ->setRecordActions($recordActions)
            ->setReplies($replies)
            ->setReplyTo($replyTo)
            ->setReplyToId($replyToId)
            ->setResponseContextExternalId($responseContextExternalId)
            ->setReviewScale($reviewScale)
            ->setReviewScore($reviewScore)
            ->setReviewedStatus($reviewedStatus)
            ->setSentiment($sentiment)
            ->setShares($shares)
            ->setSourceTags($sourceTags)
            ->setSpamRating($spamRating)
            ->setStatus($status)
            ->setStatusMessage($statusMessage)
            ->setSystemModstamp($systemModstamp)
            ->setThreadSize($threadSize)
            ->setTopicProfileName($topicProfileName)
            ->setTopicType($topicType)
            ->setTruncatedContent($truncatedContent)
            ->setUniqueCommentors($uniqueCommentors)
            ->setUserRecordAccess($userRecordAccess)
            ->setViewCount($viewCount)
            ->setWho($who)
            ->setWhoId($whoId);
    }
    /**
     * Get AnalyzerScore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAnalyzerScore()
    {
        return isset($this->AnalyzerScore) ? $this->AnalyzerScore : null;
    }
    /**
     * Set AnalyzerScore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $analyzerScore
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setAnalyzerScore($analyzerScore = null)
    {
        // validation for constraint: float
        if (!is_null($analyzerScore) && !(is_float($analyzerScore) || is_numeric($analyzerScore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($analyzerScore, true), gettype($analyzerScore)), __LINE__);
        }
        if (is_null($analyzerScore) || (is_array($analyzerScore) && empty($analyzerScore))) {
            unset($this->AnalyzerScore);
        } else {
            $this->AnalyzerScore = $analyzerScore;
        }
        return $this;
    }
    /**
     * Get AssignedTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignedTo()
    {
        return isset($this->AssignedTo) ? $this->AssignedTo : null;
    }
    /**
     * Set AssignedTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignedTo
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setAssignedTo($assignedTo = null)
    {
        // validation for constraint: string
        if (!is_null($assignedTo) && !is_string($assignedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignedTo, true), gettype($assignedTo)), __LINE__);
        }
        if (is_null($assignedTo) || (is_array($assignedTo) && empty($assignedTo))) {
            unset($this->AssignedTo);
        } else {
            $this->AssignedTo = $assignedTo;
        }
        return $this;
    }
    /**
     * Get AttachedContentDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentDocuments()
    {
        return isset($this->AttachedContentDocuments) ? $this->AttachedContentDocuments : null;
    }
    /**
     * Set AttachedContentDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setAttachedContentDocuments(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null)
    {
        if (is_null($attachedContentDocuments) || (is_array($attachedContentDocuments) && empty($attachedContentDocuments))) {
            unset($this->AttachedContentDocuments);
        } else {
            $this->AttachedContentDocuments = $attachedContentDocuments;
        }
        return $this;
    }
    /**
     * Get AttachedContentNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentNotes()
    {
        return isset($this->AttachedContentNotes) ? $this->AttachedContentNotes : null;
    }
    /**
     * Set AttachedContentNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setAttachedContentNotes(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null)
    {
        if (is_null($attachedContentNotes) || (is_array($attachedContentNotes) && empty($attachedContentNotes))) {
            unset($this->AttachedContentNotes);
        } else {
            $this->AttachedContentNotes = $attachedContentNotes;
        }
        return $this;
    }
    /**
     * Get AttachmentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttachmentType()
    {
        return isset($this->AttachmentType) ? $this->AttachmentType : null;
    }
    /**
     * Set AttachmentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attachmentType
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setAttachmentType($attachmentType = null)
    {
        // validation for constraint: string
        if (!is_null($attachmentType) && !is_string($attachmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachmentType, true), gettype($attachmentType)), __LINE__);
        }
        if (is_null($attachmentType) || (is_array($attachmentType) && empty($attachmentType))) {
            unset($this->AttachmentType);
        } else {
            $this->AttachmentType = $attachmentType;
        }
        return $this;
    }
    /**
     * Get AttachmentUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttachmentUrl()
    {
        return isset($this->AttachmentUrl) ? $this->AttachmentUrl : null;
    }
    /**
     * Set AttachmentUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attachmentUrl
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setAttachmentUrl($attachmentUrl = null)
    {
        // validation for constraint: string
        if (!is_null($attachmentUrl) && !is_string($attachmentUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachmentUrl, true), gettype($attachmentUrl)), __LINE__);
        }
        if (is_null($attachmentUrl) || (is_array($attachmentUrl) && empty($attachmentUrl))) {
            unset($this->AttachmentUrl);
        } else {
            $this->AttachmentUrl = $attachmentUrl;
        }
        return $this;
    }
    /**
     * Get Attachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachments()
    {
        return isset($this->Attachments) ? $this->Attachments : null;
    }
    /**
     * Set Attachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachments
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $attachments = null)
    {
        if (is_null($attachments) || (is_array($attachments) && empty($attachments))) {
            unset($this->Attachments);
        } else {
            $this->Attachments = $attachments;
        }
        return $this;
    }
    /**
     * Get Classification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClassification()
    {
        return isset($this->Classification) ? $this->Classification : null;
    }
    /**
     * Set Classification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $classification
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setClassification($classification = null)
    {
        // validation for constraint: string
        if (!is_null($classification) && !is_string($classification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classification, true), gettype($classification)), __LINE__);
        }
        if (is_null($classification) || (is_array($classification) && empty($classification))) {
            unset($this->Classification);
        } else {
            $this->Classification = $classification;
        }
        return $this;
    }
    /**
     * Get CombinedAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCombinedAttachments()
    {
        return isset($this->CombinedAttachments) ? $this->CombinedAttachments : null;
    }
    /**
     * Set CombinedAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setCombinedAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null)
    {
        if (is_null($combinedAttachments) || (is_array($combinedAttachments) && empty($combinedAttachments))) {
            unset($this->CombinedAttachments);
        } else {
            $this->CombinedAttachments = $combinedAttachments;
        }
        return $this;
    }
    /**
     * Get CommentCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCommentCount()
    {
        return isset($this->CommentCount) ? $this->CommentCount : null;
    }
    /**
     * Set CommentCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $commentCount
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setCommentCount($commentCount = null)
    {
        // validation for constraint: int
        if (!is_null($commentCount) && !(is_int($commentCount) || ctype_digit($commentCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commentCount, true), gettype($commentCount)), __LINE__);
        }
        if (is_null($commentCount) || (is_array($commentCount) && empty($commentCount))) {
            unset($this->CommentCount);
        } else {
            $this->CommentCount = $commentCount;
        }
        return $this;
    }
    /**
     * Get Content value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContent()
    {
        return isset($this->Content) ? $this->Content : null;
    }
    /**
     * Set Content value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $content
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content, true), gettype($content)), __LINE__);
        }
        if (is_null($content) || (is_array($content) && empty($content))) {
            unset($this->Content);
        } else {
            $this->Content = $content;
        }
        return $this;
    }
    /**
     * Get ContentDocumentIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getContentDocumentIds()
    {
        return isset($this->ContentDocumentIds) ? $this->ContentDocumentIds : null;
    }
    /**
     * This method is responsible for validating the values passed to the setContentDocumentIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContentDocumentIds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContentDocumentIdsForArrayConstraintsFromSetContentDocumentIds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $socialPostContentDocumentIdsItem) {
            // validation for constraint: itemType
            if (!is_string($socialPostContentDocumentIdsItem)) {
                $invalidValues[] = is_object($socialPostContentDocumentIdsItem) ? get_class($socialPostContentDocumentIdsItem) : sprintf('%s(%s)', gettype($socialPostContentDocumentIdsItem), var_export($socialPostContentDocumentIdsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContentDocumentIds property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setContentDocumentIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContentDocumentIds method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContentDocumentIdsForLengthConstraintFromSetContentDocumentIds($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $socialPostContentDocumentIdsItem) {
            // validation for constraint: length(18)
            if (mb_strlen($socialPostContentDocumentIdsItem) !== 18) {
                $invalidValues[] = var_export($socialPostContentDocumentIdsItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be equal to 18', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContentDocumentIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $contentDocumentIds
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setContentDocumentIds(array $contentDocumentIds = array())
    {
        // validation for constraint: array
        if ('' !== ($contentDocumentIdsArrayErrorMessage = self::validateContentDocumentIdsForArrayConstraintsFromSetContentDocumentIds($contentDocumentIds))) {
            throw new \InvalidArgumentException($contentDocumentIdsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: length(18)
        if ('' !== ($contentDocumentIdsLengthErrorMessage = self::validateContentDocumentIdsForLengthConstraintFromSetContentDocumentIds($contentDocumentIds))) {
            throw new \InvalidArgumentException($contentDocumentIdsLengthErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($contentDocumentIds) && !preg_match('/[a-zA-Z0-9]{18}/', $contentDocumentIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($contentDocumentIds, true)), __LINE__);
        }
        if (is_null($contentDocumentIds) || (is_array($contentDocumentIds) && empty($contentDocumentIds))) {
            unset($this->ContentDocumentIds);
        } else {
            $this->ContentDocumentIds = $contentDocumentIds;
        }
        return $this;
    }
    /**
     * Add item to ContentDocumentIds value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function addToContentDocumentIds($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ContentDocumentIds property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: length(18)
        if (mb_strlen($item) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!preg_match('/[a-zA-Z0-9]{18}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($item, true)), __LINE__);
        }
        $this->ContentDocumentIds[] = $item;
        return $this;
    }
    /**
     * Get ContentDocumentLinks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContentDocumentLinks()
    {
        return isset($this->ContentDocumentLinks) ? $this->ContentDocumentLinks : null;
    }
    /**
     * Set ContentDocumentLinks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setContentDocumentLinks(\NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null)
    {
        if (is_null($contentDocumentLinks) || (is_array($contentDocumentLinks) && empty($contentDocumentLinks))) {
            unset($this->ContentDocumentLinks);
        } else {
            $this->ContentDocumentLinks = $contentDocumentLinks;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DeletedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getDeletedBy()
    {
        return isset($this->DeletedBy) ? $this->DeletedBy : null;
    }
    /**
     * Set DeletedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $deletedBy
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setDeletedBy(\NexusDigital/MiratelForce\StructType\User $deletedBy = null)
    {
        if (is_null($deletedBy) || (is_array($deletedBy) && empty($deletedBy))) {
            unset($this->DeletedBy);
        } else {
            $this->DeletedBy = $deletedBy;
        }
        return $this;
    }
    /**
     * Get DeletedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeletedById()
    {
        return isset($this->DeletedById) ? $this->DeletedById : null;
    }
    /**
     * Set DeletedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deletedById
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setDeletedById($deletedById = null)
    {
        // validation for constraint: string
        if (!is_null($deletedById) && !is_string($deletedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deletedById, true), gettype($deletedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($deletedById) && mb_strlen($deletedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($deletedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($deletedById) && !preg_match('/[a-zA-Z0-9]{18}/', $deletedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($deletedById, true)), __LINE__);
        }
        if (is_null($deletedById) || (is_array($deletedById) && empty($deletedById))) {
            unset($this->DeletedById);
        } else {
            $this->DeletedById = $deletedById;
        }
        return $this;
    }
    /**
     * Get EngagementLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEngagementLevel()
    {
        return isset($this->EngagementLevel) ? $this->EngagementLevel : null;
    }
    /**
     * Set EngagementLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $engagementLevel
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setEngagementLevel($engagementLevel = null)
    {
        // validation for constraint: string
        if (!is_null($engagementLevel) && !is_string($engagementLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($engagementLevel, true), gettype($engagementLevel)), __LINE__);
        }
        if (is_null($engagementLevel) || (is_array($engagementLevel) && empty($engagementLevel))) {
            unset($this->EngagementLevel);
        } else {
            $this->EngagementLevel = $engagementLevel;
        }
        return $this;
    }
    /**
     * Get ExternalPostId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalPostId()
    {
        return isset($this->ExternalPostId) ? $this->ExternalPostId : null;
    }
    /**
     * Set ExternalPostId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalPostId
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setExternalPostId($externalPostId = null)
    {
        // validation for constraint: string
        if (!is_null($externalPostId) && !is_string($externalPostId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalPostId, true), gettype($externalPostId)), __LINE__);
        }
        if (is_null($externalPostId) || (is_array($externalPostId) && empty($externalPostId))) {
            unset($this->ExternalPostId);
        } else {
            $this->ExternalPostId = $externalPostId;
        }
        return $this;
    }
    /**
     * Get FeedSubscriptionsForEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeedSubscriptionsForEntity()
    {
        return isset($this->FeedSubscriptionsForEntity) ? $this->FeedSubscriptionsForEntity : null;
    }
    /**
     * Set FeedSubscriptionsForEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setFeedSubscriptionsForEntity(\NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity = null)
    {
        if (is_null($feedSubscriptionsForEntity) || (is_array($feedSubscriptionsForEntity) && empty($feedSubscriptionsForEntity))) {
            unset($this->FeedSubscriptionsForEntity);
        } else {
            $this->FeedSubscriptionsForEntity = $feedSubscriptionsForEntity;
        }
        return $this;
    }
    /**
     * Get Feeds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeeds()
    {
        return isset($this->Feeds) ? $this->Feeds : null;
    }
    /**
     * Set Feeds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feeds
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setFeeds(\NexusDigital/MiratelForce\StructType\QueryResult $feeds = null)
    {
        if (is_null($feeds) || (is_array($feeds) && empty($feeds))) {
            unset($this->Feeds);
        } else {
            $this->Feeds = $feeds;
        }
        return $this;
    }
    /**
     * Get Handle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandle()
    {
        return isset($this->Handle) ? $this->Handle : null;
    }
    /**
     * Set Handle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handle
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setHandle($handle = null)
    {
        // validation for constraint: string
        if (!is_null($handle) && !is_string($handle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handle, true), gettype($handle)), __LINE__);
        }
        if (is_null($handle) || (is_array($handle) && empty($handle))) {
            unset($this->Handle);
        } else {
            $this->Handle = $handle;
        }
        return $this;
    }
    /**
     * Get HarvestDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHarvestDate()
    {
        return isset($this->HarvestDate) ? $this->HarvestDate : null;
    }
    /**
     * Set HarvestDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $harvestDate
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setHarvestDate($harvestDate = null)
    {
        // validation for constraint: string
        if (!is_null($harvestDate) && !is_string($harvestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($harvestDate, true), gettype($harvestDate)), __LINE__);
        }
        if (is_null($harvestDate) || (is_array($harvestDate) && empty($harvestDate))) {
            unset($this->HarvestDate);
        } else {
            $this->HarvestDate = $harvestDate;
        }
        return $this;
    }
    /**
     * Get Headline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHeadline()
    {
        return isset($this->Headline) ? $this->Headline : null;
    }
    /**
     * Set Headline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $headline
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setHeadline($headline = null)
    {
        // validation for constraint: string
        if (!is_null($headline) && !is_string($headline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($headline, true), gettype($headline)), __LINE__);
        }
        if (is_null($headline) || (is_array($headline) && empty($headline))) {
            unset($this->Headline);
        } else {
            $this->Headline = $headline;
        }
        return $this;
    }
    /**
     * Get HiddenBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getHiddenBy()
    {
        return isset($this->HiddenBy) ? $this->HiddenBy : null;
    }
    /**
     * Set HiddenBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $hiddenBy
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setHiddenBy(\NexusDigital/MiratelForce\StructType\User $hiddenBy = null)
    {
        if (is_null($hiddenBy) || (is_array($hiddenBy) && empty($hiddenBy))) {
            unset($this->HiddenBy);
        } else {
            $this->HiddenBy = $hiddenBy;
        }
        return $this;
    }
    /**
     * Get HiddenById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHiddenById()
    {
        return isset($this->HiddenById) ? $this->HiddenById : null;
    }
    /**
     * Set HiddenById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hiddenById
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setHiddenById($hiddenById = null)
    {
        // validation for constraint: string
        if (!is_null($hiddenById) && !is_string($hiddenById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hiddenById, true), gettype($hiddenById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($hiddenById) && mb_strlen($hiddenById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($hiddenById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($hiddenById) && !preg_match('/[a-zA-Z0-9]{18}/', $hiddenById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($hiddenById, true)), __LINE__);
        }
        if (is_null($hiddenById) || (is_array($hiddenById) && empty($hiddenById))) {
            unset($this->HiddenById);
        } else {
            $this->HiddenById = $hiddenById;
        }
        return $this;
    }
    /**
     * Get Histories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getHistories()
    {
        return isset($this->Histories) ? $this->Histories : null;
    }
    /**
     * Set Histories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setHistories(\NexusDigital/MiratelForce\StructType\QueryResult $histories = null)
    {
        if (is_null($histories) || (is_array($histories) && empty($histories))) {
            unset($this->Histories);
        } else {
            $this->Histories = $histories;
        }
        return $this;
    }
    /**
     * Get InboundLinkCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInboundLinkCount()
    {
        return isset($this->InboundLinkCount) ? $this->InboundLinkCount : null;
    }
    /**
     * Set InboundLinkCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $inboundLinkCount
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setInboundLinkCount($inboundLinkCount = null)
    {
        // validation for constraint: int
        if (!is_null($inboundLinkCount) && !(is_int($inboundLinkCount) || ctype_digit($inboundLinkCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inboundLinkCount, true), gettype($inboundLinkCount)), __LINE__);
        }
        if (is_null($inboundLinkCount) || (is_array($inboundLinkCount) && empty($inboundLinkCount))) {
            unset($this->InboundLinkCount);
        } else {
            $this->InboundLinkCount = $inboundLinkCount;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsOutbound value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOutbound()
    {
        return isset($this->IsOutbound) ? $this->IsOutbound : null;
    }
    /**
     * Set IsOutbound value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOutbound
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setIsOutbound($isOutbound = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOutbound) && !is_bool($isOutbound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOutbound, true), gettype($isOutbound)), __LINE__);
        }
        if (is_null($isOutbound) || (is_array($isOutbound) && empty($isOutbound))) {
            unset($this->IsOutbound);
        } else {
            $this->IsOutbound = $isOutbound;
        }
        return $this;
    }
    /**
     * Get KeywordGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKeywordGroupName()
    {
        return isset($this->KeywordGroupName) ? $this->KeywordGroupName : null;
    }
    /**
     * Set KeywordGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $keywordGroupName
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setKeywordGroupName($keywordGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($keywordGroupName) && !is_string($keywordGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keywordGroupName, true), gettype($keywordGroupName)), __LINE__);
        }
        if (is_null($keywordGroupName) || (is_array($keywordGroupName) && empty($keywordGroupName))) {
            unset($this->KeywordGroupName);
        } else {
            $this->KeywordGroupName = $keywordGroupName;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LastReferencedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastReferencedDate()
    {
        return isset($this->LastReferencedDate) ? $this->LastReferencedDate : null;
    }
    /**
     * Set LastReferencedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastReferencedDate
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setLastReferencedDate($lastReferencedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastReferencedDate) && !is_string($lastReferencedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastReferencedDate, true), gettype($lastReferencedDate)), __LINE__);
        }
        if (is_null($lastReferencedDate) || (is_array($lastReferencedDate) && empty($lastReferencedDate))) {
            unset($this->LastReferencedDate);
        } else {
            $this->LastReferencedDate = $lastReferencedDate;
        }
        return $this;
    }
    /**
     * Get LastViewedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastViewedDate()
    {
        return isset($this->LastViewedDate) ? $this->LastViewedDate : null;
    }
    /**
     * Set LastViewedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastViewedDate
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setLastViewedDate($lastViewedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastViewedDate) && !is_string($lastViewedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastViewedDate, true), gettype($lastViewedDate)), __LINE__);
        }
        if (is_null($lastViewedDate) || (is_array($lastViewedDate) && empty($lastViewedDate))) {
            unset($this->LastViewedDate);
        } else {
            $this->LastViewedDate = $lastViewedDate;
        }
        return $this;
    }
    /**
     * Get LikedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLikedBy()
    {
        return isset($this->LikedBy) ? $this->LikedBy : null;
    }
    /**
     * Set LikedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $likedBy
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setLikedBy($likedBy = null)
    {
        // validation for constraint: string
        if (!is_null($likedBy) && !is_string($likedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($likedBy, true), gettype($likedBy)), __LINE__);
        }
        if (is_null($likedBy) || (is_array($likedBy) && empty($likedBy))) {
            unset($this->LikedBy);
        } else {
            $this->LikedBy = $likedBy;
        }
        return $this;
    }
    /**
     * Get LikesAndVotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLikesAndVotes()
    {
        return isset($this->LikesAndVotes) ? $this->LikesAndVotes : null;
    }
    /**
     * Set LikesAndVotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $likesAndVotes
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setLikesAndVotes($likesAndVotes = null)
    {
        // validation for constraint: int
        if (!is_null($likesAndVotes) && !(is_int($likesAndVotes) || ctype_digit($likesAndVotes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($likesAndVotes, true), gettype($likesAndVotes)), __LINE__);
        }
        if (is_null($likesAndVotes) || (is_array($likesAndVotes) && empty($likesAndVotes))) {
            unset($this->LikesAndVotes);
        } else {
            $this->LikesAndVotes = $likesAndVotes;
        }
        return $this;
    }
    /**
     * Get MediaProvider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMediaProvider()
    {
        return isset($this->MediaProvider) ? $this->MediaProvider : null;
    }
    /**
     * Set MediaProvider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mediaProvider
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setMediaProvider($mediaProvider = null)
    {
        // validation for constraint: string
        if (!is_null($mediaProvider) && !is_string($mediaProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mediaProvider, true), gettype($mediaProvider)), __LINE__);
        }
        if (is_null($mediaProvider) || (is_array($mediaProvider) && empty($mediaProvider))) {
            unset($this->MediaProvider);
        } else {
            $this->MediaProvider = $mediaProvider;
        }
        return $this;
    }
    /**
     * Get MediaType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMediaType()
    {
        return isset($this->MediaType) ? $this->MediaType : null;
    }
    /**
     * Set MediaType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mediaType
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setMediaType($mediaType = null)
    {
        // validation for constraint: string
        if (!is_null($mediaType) && !is_string($mediaType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mediaType, true), gettype($mediaType)), __LINE__);
        }
        if (is_null($mediaType) || (is_array($mediaType) && empty($mediaType))) {
            unset($this->MediaType);
        } else {
            $this->MediaType = $mediaType;
        }
        return $this;
    }
    /**
     * Get MessageType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessageType()
    {
        return isset($this->MessageType) ? $this->MessageType : null;
    }
    /**
     * Set MessageType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $messageType
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: string
        if (!is_null($messageType) && !is_string($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageType, true), gettype($messageType)), __LINE__);
        }
        if (is_null($messageType) || (is_array($messageType) && empty($messageType))) {
            unset($this->MessageType);
        } else {
            $this->MessageType = $messageType;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notes
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setNotes(\NexusDigital/MiratelForce\StructType\QueryResult $notes = null)
    {
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get NotesAndAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNotesAndAttachments()
    {
        return isset($this->NotesAndAttachments) ? $this->NotesAndAttachments : null;
    }
    /**
     * Set NotesAndAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setNotesAndAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments = null)
    {
        if (is_null($notesAndAttachments) || (is_array($notesAndAttachments) && empty($notesAndAttachments))) {
            unset($this->NotesAndAttachments);
        } else {
            $this->NotesAndAttachments = $notesAndAttachments;
        }
        return $this;
    }
    /**
     * Get OutboundSocialAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount|null
     */
    public function getOutboundSocialAccount()
    {
        return isset($this->OutboundSocialAccount) ? $this->OutboundSocialAccount : null;
    }
    /**
     * Set OutboundSocialAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ExternalSocialAccount $outboundSocialAccount
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setOutboundSocialAccount(\NexusDigital/MiratelForce\StructType\ExternalSocialAccount $outboundSocialAccount = null)
    {
        if (is_null($outboundSocialAccount) || (is_array($outboundSocialAccount) && empty($outboundSocialAccount))) {
            unset($this->OutboundSocialAccount);
        } else {
            $this->OutboundSocialAccount = $outboundSocialAccount;
        }
        return $this;
    }
    /**
     * Get OutboundSocialAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOutboundSocialAccountId()
    {
        return isset($this->OutboundSocialAccountId) ? $this->OutboundSocialAccountId : null;
    }
    /**
     * Set OutboundSocialAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $outboundSocialAccountId
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setOutboundSocialAccountId($outboundSocialAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($outboundSocialAccountId) && !is_string($outboundSocialAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outboundSocialAccountId, true), gettype($outboundSocialAccountId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($outboundSocialAccountId) && mb_strlen($outboundSocialAccountId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($outboundSocialAccountId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($outboundSocialAccountId) && !preg_match('/[a-zA-Z0-9]{18}/', $outboundSocialAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($outboundSocialAccountId, true)), __LINE__);
        }
        if (is_null($outboundSocialAccountId) || (is_array($outboundSocialAccountId) && empty($outboundSocialAccountId))) {
            unset($this->OutboundSocialAccountId);
        } else {
            $this->OutboundSocialAccountId = $outboundSocialAccountId;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $owner
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setOwner(\NexusDigital/MiratelForce\StructType\SObject $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ownerId) && mb_strlen($ownerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ownerId) && !preg_match('/[a-zA-Z0-9]{18}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get Parent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getParent()
    {
        return isset($this->Parent) ? $this->Parent : null;
    }
    /**
     * Set Parent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $parent
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setParent(\NexusDigital/MiratelForce\StructType\SObject $parent = null)
    {
        if (is_null($parent) || (is_array($parent) && empty($parent))) {
            unset($this->Parent);
        } else {
            $this->Parent = $parent;
        }
        return $this;
    }
    /**
     * Get ParentEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getParentEntities()
    {
        return isset($this->ParentEntities) ? $this->ParentEntities : null;
    }
    /**
     * Set ParentEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setParentEntities(\NexusDigital/MiratelForce\StructType\QueryResult $parentEntities = null)
    {
        if (is_null($parentEntities) || (is_array($parentEntities) && empty($parentEntities))) {
            unset($this->ParentEntities);
        } else {
            $this->ParentEntities = $parentEntities;
        }
        return $this;
    }
    /**
     * Get ParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->ParentId) ? $this->ParentId : null;
    }
    /**
     * Set ParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentId) && mb_strlen($parentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentId, true)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->ParentId);
        } else {
            $this->ParentId = $parentId;
        }
        return $this;
    }
    /**
     * Get Persona value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona|null
     */
    public function getPersona()
    {
        return isset($this->Persona) ? $this->Persona : null;
    }
    /**
     * Set Persona value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SocialPersona $persona
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setPersona(\NexusDigital/MiratelForce\StructType\SocialPersona $persona = null)
    {
        if (is_null($persona) || (is_array($persona) && empty($persona))) {
            unset($this->Persona);
        } else {
            $this->Persona = $persona;
        }
        return $this;
    }
    /**
     * Get PersonaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonaId()
    {
        return isset($this->PersonaId) ? $this->PersonaId : null;
    }
    /**
     * Set PersonaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personaId
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setPersonaId($personaId = null)
    {
        // validation for constraint: string
        if (!is_null($personaId) && !is_string($personaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personaId, true), gettype($personaId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($personaId) && mb_strlen($personaId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($personaId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($personaId) && !preg_match('/[a-zA-Z0-9]{18}/', $personaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($personaId, true)), __LINE__);
        }
        if (is_null($personaId) || (is_array($personaId) && empty($personaId))) {
            unset($this->PersonaId);
        } else {
            $this->PersonaId = $personaId;
        }
        return $this;
    }
    /**
     * Get Personas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getPersonas()
    {
        return isset($this->Personas) ? $this->Personas : null;
    }
    /**
     * Set Personas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $personas
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setPersonas(\NexusDigital/MiratelForce\StructType\QueryResult $personas = null)
    {
        if (is_null($personas) || (is_array($personas) && empty($personas))) {
            unset($this->Personas);
        } else {
            $this->Personas = $personas;
        }
        return $this;
    }
    /**
     * Get PostPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostPriority()
    {
        return isset($this->PostPriority) ? $this->PostPriority : null;
    }
    /**
     * Set PostPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postPriority
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setPostPriority($postPriority = null)
    {
        // validation for constraint: string
        if (!is_null($postPriority) && !is_string($postPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postPriority, true), gettype($postPriority)), __LINE__);
        }
        if (is_null($postPriority) || (is_array($postPriority) && empty($postPriority))) {
            unset($this->PostPriority);
        } else {
            $this->PostPriority = $postPriority;
        }
        return $this;
    }
    /**
     * Get PostTags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostTags()
    {
        return isset($this->PostTags) ? $this->PostTags : null;
    }
    /**
     * Set PostTags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postTags
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setPostTags($postTags = null)
    {
        // validation for constraint: string
        if (!is_null($postTags) && !is_string($postTags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postTags, true), gettype($postTags)), __LINE__);
        }
        if (is_null($postTags) || (is_array($postTags) && empty($postTags))) {
            unset($this->PostTags);
        } else {
            $this->PostTags = $postTags;
        }
        return $this;
    }
    /**
     * Get PostUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostUrl()
    {
        return isset($this->PostUrl) ? $this->PostUrl : null;
    }
    /**
     * Set PostUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postUrl
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setPostUrl($postUrl = null)
    {
        // validation for constraint: string
        if (!is_null($postUrl) && !is_string($postUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postUrl, true), gettype($postUrl)), __LINE__);
        }
        if (is_null($postUrl) || (is_array($postUrl) && empty($postUrl))) {
            unset($this->PostUrl);
        } else {
            $this->PostUrl = $postUrl;
        }
        return $this;
    }
    /**
     * Get Posted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPosted()
    {
        return isset($this->Posted) ? $this->Posted : null;
    }
    /**
     * Set Posted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $posted
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setPosted($posted = null)
    {
        // validation for constraint: string
        if (!is_null($posted) && !is_string($posted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($posted, true), gettype($posted)), __LINE__);
        }
        if (is_null($posted) || (is_array($posted) && empty($posted))) {
            unset($this->Posted);
        } else {
            $this->Posted = $posted;
        }
        return $this;
    }
    /**
     * Get ProcessInstances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessInstances()
    {
        return isset($this->ProcessInstances) ? $this->ProcessInstances : null;
    }
    /**
     * Set ProcessInstances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setProcessInstances(\NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null)
    {
        if (is_null($processInstances) || (is_array($processInstances) && empty($processInstances))) {
            unset($this->ProcessInstances);
        } else {
            $this->ProcessInstances = $processInstances;
        }
        return $this;
    }
    /**
     * Get ProcessSteps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessSteps()
    {
        return isset($this->ProcessSteps) ? $this->ProcessSteps : null;
    }
    /**
     * Set ProcessSteps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setProcessSteps(\NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null)
    {
        if (is_null($processSteps) || (is_array($processSteps) && empty($processSteps))) {
            unset($this->ProcessSteps);
        } else {
            $this->ProcessSteps = $processSteps;
        }
        return $this;
    }
    /**
     * Get Provider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvider()
    {
        return isset($this->Provider) ? $this->Provider : null;
    }
    /**
     * Set Provider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provider
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provider, true), gettype($provider)), __LINE__);
        }
        if (is_null($provider) || (is_array($provider) && empty($provider))) {
            unset($this->Provider);
        } else {
            $this->Provider = $provider;
        }
        return $this;
    }
    /**
     * Get R6PostId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getR6PostId()
    {
        return isset($this->R6PostId) ? $this->R6PostId : null;
    }
    /**
     * Set R6PostId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $r6PostId
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setR6PostId($r6PostId = null)
    {
        // validation for constraint: string
        if (!is_null($r6PostId) && !is_string($r6PostId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($r6PostId, true), gettype($r6PostId)), __LINE__);
        }
        if (is_null($r6PostId) || (is_array($r6PostId) && empty($r6PostId))) {
            unset($this->R6PostId);
        } else {
            $this->R6PostId = $r6PostId;
        }
        return $this;
    }
    /**
     * Get R6SourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getR6SourceId()
    {
        return isset($this->R6SourceId) ? $this->R6SourceId : null;
    }
    /**
     * Set R6SourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $r6SourceId
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setR6SourceId($r6SourceId = null)
    {
        // validation for constraint: string
        if (!is_null($r6SourceId) && !is_string($r6SourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($r6SourceId, true), gettype($r6SourceId)), __LINE__);
        }
        if (is_null($r6SourceId) || (is_array($r6SourceId) && empty($r6SourceId))) {
            unset($this->R6SourceId);
        } else {
            $this->R6SourceId = $r6SourceId;
        }
        return $this;
    }
    /**
     * Get R6TopicId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getR6TopicId()
    {
        return isset($this->R6TopicId) ? $this->R6TopicId : null;
    }
    /**
     * Set R6TopicId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $r6TopicId
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setR6TopicId($r6TopicId = null)
    {
        // validation for constraint: string
        if (!is_null($r6TopicId) && !is_string($r6TopicId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($r6TopicId, true), gettype($r6TopicId)), __LINE__);
        }
        if (is_null($r6TopicId) || (is_array($r6TopicId) && empty($r6TopicId))) {
            unset($this->R6TopicId);
        } else {
            $this->R6TopicId = $r6TopicId;
        }
        return $this;
    }
    /**
     * Get Recipient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecipient()
    {
        return isset($this->Recipient) ? $this->Recipient : null;
    }
    /**
     * Set Recipient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recipient
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setRecipient($recipient = null)
    {
        // validation for constraint: string
        if (!is_null($recipient) && !is_string($recipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipient, true), gettype($recipient)), __LINE__);
        }
        if (is_null($recipient) || (is_array($recipient) && empty($recipient))) {
            unset($this->Recipient);
        } else {
            $this->Recipient = $recipient;
        }
        return $this;
    }
    /**
     * Get RecipientType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecipientType()
    {
        return isset($this->RecipientType) ? $this->RecipientType : null;
    }
    /**
     * Set RecipientType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recipientType
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setRecipientType($recipientType = null)
    {
        // validation for constraint: string
        if (!is_null($recipientType) && !is_string($recipientType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientType, true), gettype($recipientType)), __LINE__);
        }
        if (is_null($recipientType) || (is_array($recipientType) && empty($recipientType))) {
            unset($this->RecipientType);
        } else {
            $this->RecipientType = $recipientType;
        }
        return $this;
    }
    /**
     * Get RecordActionHistories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRecordActionHistories()
    {
        return isset($this->RecordActionHistories) ? $this->RecordActionHistories : null;
    }
    /**
     * Set RecordActionHistories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setRecordActionHistories(\NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories = null)
    {
        if (is_null($recordActionHistories) || (is_array($recordActionHistories) && empty($recordActionHistories))) {
            unset($this->RecordActionHistories);
        } else {
            $this->RecordActionHistories = $recordActionHistories;
        }
        return $this;
    }
    /**
     * Get RecordActions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRecordActions()
    {
        return isset($this->RecordActions) ? $this->RecordActions : null;
    }
    /**
     * Set RecordActions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActions
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setRecordActions(\NexusDigital/MiratelForce\StructType\QueryResult $recordActions = null)
    {
        if (is_null($recordActions) || (is_array($recordActions) && empty($recordActions))) {
            unset($this->RecordActions);
        } else {
            $this->RecordActions = $recordActions;
        }
        return $this;
    }
    /**
     * Get Replies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getReplies()
    {
        return isset($this->Replies) ? $this->Replies : null;
    }
    /**
     * Set Replies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $replies
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setReplies(\NexusDigital/MiratelForce\StructType\QueryResult $replies = null)
    {
        if (is_null($replies) || (is_array($replies) && empty($replies))) {
            unset($this->Replies);
        } else {
            $this->Replies = $replies;
        }
        return $this;
    }
    /**
     * Get ReplyTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SocialPost|null
     */
    public function getReplyTo()
    {
        return isset($this->ReplyTo) ? $this->ReplyTo : null;
    }
    /**
     * Set ReplyTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SocialPost $replyTo
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setReplyTo(\NexusDigital/MiratelForce\StructType\SocialPost $replyTo = null)
    {
        if (is_null($replyTo) || (is_array($replyTo) && empty($replyTo))) {
            unset($this->ReplyTo);
        } else {
            $this->ReplyTo = $replyTo;
        }
        return $this;
    }
    /**
     * Get ReplyToId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReplyToId()
    {
        return isset($this->ReplyToId) ? $this->ReplyToId : null;
    }
    /**
     * Set ReplyToId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $replyToId
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setReplyToId($replyToId = null)
    {
        // validation for constraint: string
        if (!is_null($replyToId) && !is_string($replyToId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replyToId, true), gettype($replyToId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($replyToId) && mb_strlen($replyToId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($replyToId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($replyToId) && !preg_match('/[a-zA-Z0-9]{18}/', $replyToId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($replyToId, true)), __LINE__);
        }
        if (is_null($replyToId) || (is_array($replyToId) && empty($replyToId))) {
            unset($this->ReplyToId);
        } else {
            $this->ReplyToId = $replyToId;
        }
        return $this;
    }
    /**
     * Get ResponseContextExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseContextExternalId()
    {
        return isset($this->ResponseContextExternalId) ? $this->ResponseContextExternalId : null;
    }
    /**
     * Set ResponseContextExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseContextExternalId
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setResponseContextExternalId($responseContextExternalId = null)
    {
        // validation for constraint: string
        if (!is_null($responseContextExternalId) && !is_string($responseContextExternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseContextExternalId, true), gettype($responseContextExternalId)), __LINE__);
        }
        if (is_null($responseContextExternalId) || (is_array($responseContextExternalId) && empty($responseContextExternalId))) {
            unset($this->ResponseContextExternalId);
        } else {
            $this->ResponseContextExternalId = $responseContextExternalId;
        }
        return $this;
    }
    /**
     * Get ReviewScale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getReviewScale()
    {
        return isset($this->ReviewScale) ? $this->ReviewScale : null;
    }
    /**
     * Set ReviewScale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $reviewScale
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setReviewScale($reviewScale = null)
    {
        // validation for constraint: float
        if (!is_null($reviewScale) && !(is_float($reviewScale) || is_numeric($reviewScale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reviewScale, true), gettype($reviewScale)), __LINE__);
        }
        if (is_null($reviewScale) || (is_array($reviewScale) && empty($reviewScale))) {
            unset($this->ReviewScale);
        } else {
            $this->ReviewScale = $reviewScale;
        }
        return $this;
    }
    /**
     * Get ReviewScore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getReviewScore()
    {
        return isset($this->ReviewScore) ? $this->ReviewScore : null;
    }
    /**
     * Set ReviewScore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $reviewScore
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setReviewScore($reviewScore = null)
    {
        // validation for constraint: float
        if (!is_null($reviewScore) && !(is_float($reviewScore) || is_numeric($reviewScore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reviewScore, true), gettype($reviewScore)), __LINE__);
        }
        if (is_null($reviewScore) || (is_array($reviewScore) && empty($reviewScore))) {
            unset($this->ReviewScore);
        } else {
            $this->ReviewScore = $reviewScore;
        }
        return $this;
    }
    /**
     * Get ReviewedStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReviewedStatus()
    {
        return isset($this->ReviewedStatus) ? $this->ReviewedStatus : null;
    }
    /**
     * Set ReviewedStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reviewedStatus
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setReviewedStatus($reviewedStatus = null)
    {
        // validation for constraint: string
        if (!is_null($reviewedStatus) && !is_string($reviewedStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reviewedStatus, true), gettype($reviewedStatus)), __LINE__);
        }
        if (is_null($reviewedStatus) || (is_array($reviewedStatus) && empty($reviewedStatus))) {
            unset($this->ReviewedStatus);
        } else {
            $this->ReviewedStatus = $reviewedStatus;
        }
        return $this;
    }
    /**
     * Get Sentiment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSentiment()
    {
        return isset($this->Sentiment) ? $this->Sentiment : null;
    }
    /**
     * Set Sentiment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sentiment
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setSentiment($sentiment = null)
    {
        // validation for constraint: string
        if (!is_null($sentiment) && !is_string($sentiment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sentiment, true), gettype($sentiment)), __LINE__);
        }
        if (is_null($sentiment) || (is_array($sentiment) && empty($sentiment))) {
            unset($this->Sentiment);
        } else {
            $this->Sentiment = $sentiment;
        }
        return $this;
    }
    /**
     * Get Shares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShares()
    {
        return isset($this->Shares) ? $this->Shares : null;
    }
    /**
     * Set Shares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $shares
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setShares($shares = null)
    {
        // validation for constraint: int
        if (!is_null($shares) && !(is_int($shares) || ctype_digit($shares))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shares, true), gettype($shares)), __LINE__);
        }
        if (is_null($shares) || (is_array($shares) && empty($shares))) {
            unset($this->Shares);
        } else {
            $this->Shares = $shares;
        }
        return $this;
    }
    /**
     * Get SourceTags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceTags()
    {
        return isset($this->SourceTags) ? $this->SourceTags : null;
    }
    /**
     * Set SourceTags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceTags
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setSourceTags($sourceTags = null)
    {
        // validation for constraint: string
        if (!is_null($sourceTags) && !is_string($sourceTags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceTags, true), gettype($sourceTags)), __LINE__);
        }
        if (is_null($sourceTags) || (is_array($sourceTags) && empty($sourceTags))) {
            unset($this->SourceTags);
        } else {
            $this->SourceTags = $sourceTags;
        }
        return $this;
    }
    /**
     * Get SpamRating value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpamRating()
    {
        return isset($this->SpamRating) ? $this->SpamRating : null;
    }
    /**
     * Set SpamRating value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spamRating
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setSpamRating($spamRating = null)
    {
        // validation for constraint: string
        if (!is_null($spamRating) && !is_string($spamRating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spamRating, true), gettype($spamRating)), __LINE__);
        }
        if (is_null($spamRating) || (is_array($spamRating) && empty($spamRating))) {
            unset($this->SpamRating);
        } else {
            $this->SpamRating = $spamRating;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get StatusMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusMessage()
    {
        return isset($this->StatusMessage) ? $this->StatusMessage : null;
    }
    /**
     * Set StatusMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusMessage
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setStatusMessage($statusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($statusMessage) && !is_string($statusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusMessage, true), gettype($statusMessage)), __LINE__);
        }
        if (is_null($statusMessage) || (is_array($statusMessage) && empty($statusMessage))) {
            unset($this->StatusMessage);
        } else {
            $this->StatusMessage = $statusMessage;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get ThreadSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getThreadSize()
    {
        return isset($this->ThreadSize) ? $this->ThreadSize : null;
    }
    /**
     * Set ThreadSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $threadSize
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setThreadSize($threadSize = null)
    {
        // validation for constraint: int
        if (!is_null($threadSize) && !(is_int($threadSize) || ctype_digit($threadSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($threadSize, true), gettype($threadSize)), __LINE__);
        }
        if (is_null($threadSize) || (is_array($threadSize) && empty($threadSize))) {
            unset($this->ThreadSize);
        } else {
            $this->ThreadSize = $threadSize;
        }
        return $this;
    }
    /**
     * Get TopicProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTopicProfileName()
    {
        return isset($this->TopicProfileName) ? $this->TopicProfileName : null;
    }
    /**
     * Set TopicProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $topicProfileName
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setTopicProfileName($topicProfileName = null)
    {
        // validation for constraint: string
        if (!is_null($topicProfileName) && !is_string($topicProfileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($topicProfileName, true), gettype($topicProfileName)), __LINE__);
        }
        if (is_null($topicProfileName) || (is_array($topicProfileName) && empty($topicProfileName))) {
            unset($this->TopicProfileName);
        } else {
            $this->TopicProfileName = $topicProfileName;
        }
        return $this;
    }
    /**
     * Get TopicType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTopicType()
    {
        return isset($this->TopicType) ? $this->TopicType : null;
    }
    /**
     * Set TopicType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $topicType
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setTopicType($topicType = null)
    {
        // validation for constraint: string
        if (!is_null($topicType) && !is_string($topicType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($topicType, true), gettype($topicType)), __LINE__);
        }
        if (is_null($topicType) || (is_array($topicType) && empty($topicType))) {
            unset($this->TopicType);
        } else {
            $this->TopicType = $topicType;
        }
        return $this;
    }
    /**
     * Get TruncatedContent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTruncatedContent()
    {
        return isset($this->TruncatedContent) ? $this->TruncatedContent : null;
    }
    /**
     * Set TruncatedContent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $truncatedContent
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setTruncatedContent($truncatedContent = null)
    {
        // validation for constraint: string
        if (!is_null($truncatedContent) && !is_string($truncatedContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($truncatedContent, true), gettype($truncatedContent)), __LINE__);
        }
        if (is_null($truncatedContent) || (is_array($truncatedContent) && empty($truncatedContent))) {
            unset($this->TruncatedContent);
        } else {
            $this->TruncatedContent = $truncatedContent;
        }
        return $this;
    }
    /**
     * Get UniqueCommentors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUniqueCommentors()
    {
        return isset($this->UniqueCommentors) ? $this->UniqueCommentors : null;
    }
    /**
     * Set UniqueCommentors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $uniqueCommentors
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setUniqueCommentors($uniqueCommentors = null)
    {
        // validation for constraint: int
        if (!is_null($uniqueCommentors) && !(is_int($uniqueCommentors) || ctype_digit($uniqueCommentors))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uniqueCommentors, true), gettype($uniqueCommentors)), __LINE__);
        }
        if (is_null($uniqueCommentors) || (is_array($uniqueCommentors) && empty($uniqueCommentors))) {
            unset($this->UniqueCommentors);
        } else {
            $this->UniqueCommentors = $uniqueCommentors;
        }
        return $this;
    }
    /**
     * Get UserRecordAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess|null
     */
    public function getUserRecordAccess()
    {
        return isset($this->UserRecordAccess) ? $this->UserRecordAccess : null;
    }
    /**
     * Set UserRecordAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setUserRecordAccess(\NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        if (is_null($userRecordAccess) || (is_array($userRecordAccess) && empty($userRecordAccess))) {
            unset($this->UserRecordAccess);
        } else {
            $this->UserRecordAccess = $userRecordAccess;
        }
        return $this;
    }
    /**
     * Get ViewCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getViewCount()
    {
        return isset($this->ViewCount) ? $this->ViewCount : null;
    }
    /**
     * Set ViewCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $viewCount
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setViewCount($viewCount = null)
    {
        // validation for constraint: int
        if (!is_null($viewCount) && !(is_int($viewCount) || ctype_digit($viewCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($viewCount, true), gettype($viewCount)), __LINE__);
        }
        if (is_null($viewCount) || (is_array($viewCount) && empty($viewCount))) {
            unset($this->ViewCount);
        } else {
            $this->ViewCount = $viewCount;
        }
        return $this;
    }
    /**
     * Get Who value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getWho()
    {
        return isset($this->Who) ? $this->Who : null;
    }
    /**
     * Set Who value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $who
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setWho(\NexusDigital/MiratelForce\StructType\SObject $who = null)
    {
        if (is_null($who) || (is_array($who) && empty($who))) {
            unset($this->Who);
        } else {
            $this->Who = $who;
        }
        return $this;
    }
    /**
     * Get WhoId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWhoId()
    {
        return isset($this->WhoId) ? $this->WhoId : null;
    }
    /**
     * Set WhoId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $whoId
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public function setWhoId($whoId = null)
    {
        // validation for constraint: string
        if (!is_null($whoId) && !is_string($whoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whoId, true), gettype($whoId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($whoId) && mb_strlen($whoId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($whoId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($whoId) && !preg_match('/[a-zA-Z0-9]{18}/', $whoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($whoId, true)), __LINE__);
        }
        if (is_null($whoId) || (is_array($whoId) && empty($whoId))) {
            unset($this->WhoId);
        } else {
            $this->WhoId = $whoId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\SocialPost
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
