<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Site StructType
 * @subpackage Structs
 */
class Site extends SObject
{
    /**
     * The Admin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $Admin;
    /**
     * The AdminId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AdminId;
    /**
     * The AnalyticsTrackingCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AnalyticsTrackingCode;
    /**
     * The AttachedContentDocuments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentDocuments;
    /**
     * The AttachedContentNotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentNotes;
    /**
     * The ClickjackProtectionLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClickjackProtectionLevel;
    /**
     * The CombinedAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CombinedAttachments;
    /**
     * The ContentDocumentLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContentDocumentLinks;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DailyBandwidthLimit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DailyBandwidthLimit;
    /**
     * The DailyBandwidthUsed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DailyBandwidthUsed;
    /**
     * The DailyRequestTimeLimit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DailyRequestTimeLimit;
    /**
     * The DailyRequestTimeUsed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DailyRequestTimeUsed;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The FeedSubscriptionsForEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $FeedSubscriptionsForEntity;
    /**
     * The Feeds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Feeds;
    /**
     * The GuestUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $GuestUser;
    /**
     * The GuestUserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $GuestUserId;
    /**
     * The Histories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Histories;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The MasterLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterLabel;
    /**
     * The MonthlyPageViewsEntitlement
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MonthlyPageViewsEntitlement;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OptionsAllowGuestSupportApi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsAllowGuestSupportApi;
    /**
     * The OptionsAllowHomePage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsAllowHomePage;
    /**
     * The OptionsAllowStandardAnswersPages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsAllowStandardAnswersPages;
    /**
     * The OptionsAllowStandardIdeasPages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsAllowStandardIdeasPages;
    /**
     * The OptionsAllowStandardLookups
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsAllowStandardLookups;
    /**
     * The OptionsAllowStandardPortalPages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsAllowStandardPortalPages;
    /**
     * The OptionsAllowStandardSearch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsAllowStandardSearch;
    /**
     * The OptionsBrowserXssProtection
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsBrowserXssProtection;
    /**
     * The OptionsContentSniffingProtection
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsContentSniffingProtection;
    /**
     * The OptionsCspUpgradeInsecureRequests
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsCspUpgradeInsecureRequests;
    /**
     * The OptionsEnableFeeds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsEnableFeeds;
    /**
     * The OptionsReferrerPolicyOriginWhenCrossOrigin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsReferrerPolicyOriginWhenCrossOrigin;
    /**
     * The OptionsRequireHttps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsRequireHttps;
    /**
     * The ParentEntities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ParentEntities;
    /**
     * The SiteDomainPaths
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $SiteDomainPaths;
    /**
     * The SiteIframeWhiteListUrls
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $SiteIframeWhiteListUrls;
    /**
     * The SiteType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteType;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Subdomain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Subdomain;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The UrlPathPrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UrlPathPrefix;
    /**
     * Constructor method for Site
     * @uses Site::setAdmin()
     * @uses Site::setAdminId()
     * @uses Site::setAnalyticsTrackingCode()
     * @uses Site::setAttachedContentDocuments()
     * @uses Site::setAttachedContentNotes()
     * @uses Site::setClickjackProtectionLevel()
     * @uses Site::setCombinedAttachments()
     * @uses Site::setContentDocumentLinks()
     * @uses Site::setCreatedBy()
     * @uses Site::setCreatedById()
     * @uses Site::setCreatedDate()
     * @uses Site::setDailyBandwidthLimit()
     * @uses Site::setDailyBandwidthUsed()
     * @uses Site::setDailyRequestTimeLimit()
     * @uses Site::setDailyRequestTimeUsed()
     * @uses Site::setDescription()
     * @uses Site::setFeedSubscriptionsForEntity()
     * @uses Site::setFeeds()
     * @uses Site::setGuestUser()
     * @uses Site::setGuestUserId()
     * @uses Site::setHistories()
     * @uses Site::setLastModifiedBy()
     * @uses Site::setLastModifiedById()
     * @uses Site::setLastModifiedDate()
     * @uses Site::setMasterLabel()
     * @uses Site::setMonthlyPageViewsEntitlement()
     * @uses Site::setName()
     * @uses Site::setOptionsAllowGuestSupportApi()
     * @uses Site::setOptionsAllowHomePage()
     * @uses Site::setOptionsAllowStandardAnswersPages()
     * @uses Site::setOptionsAllowStandardIdeasPages()
     * @uses Site::setOptionsAllowStandardLookups()
     * @uses Site::setOptionsAllowStandardPortalPages()
     * @uses Site::setOptionsAllowStandardSearch()
     * @uses Site::setOptionsBrowserXssProtection()
     * @uses Site::setOptionsContentSniffingProtection()
     * @uses Site::setOptionsCspUpgradeInsecureRequests()
     * @uses Site::setOptionsEnableFeeds()
     * @uses Site::setOptionsReferrerPolicyOriginWhenCrossOrigin()
     * @uses Site::setOptionsRequireHttps()
     * @uses Site::setParentEntities()
     * @uses Site::setSiteDomainPaths()
     * @uses Site::setSiteIframeWhiteListUrls()
     * @uses Site::setSiteType()
     * @uses Site::setStatus()
     * @uses Site::setSubdomain()
     * @uses Site::setSystemModstamp()
     * @uses Site::setUrlPathPrefix()
     * @param \NexusDigital/MiratelForce\StructType\User $admin
     * @param string $adminId
     * @param string $analyticsTrackingCode
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @param string $clickjackProtectionLevel
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param int $dailyBandwidthLimit
     * @param int $dailyBandwidthUsed
     * @param int $dailyRequestTimeLimit
     * @param int $dailyRequestTimeUsed
     * @param string $description
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feeds
     * @param \NexusDigital/MiratelForce\StructType\User $guestUser
     * @param string $guestUserId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $masterLabel
     * @param int $monthlyPageViewsEntitlement
     * @param string $name
     * @param bool $optionsAllowGuestSupportApi
     * @param bool $optionsAllowHomePage
     * @param bool $optionsAllowStandardAnswersPages
     * @param bool $optionsAllowStandardIdeasPages
     * @param bool $optionsAllowStandardLookups
     * @param bool $optionsAllowStandardPortalPages
     * @param bool $optionsAllowStandardSearch
     * @param bool $optionsBrowserXssProtection
     * @param bool $optionsContentSniffingProtection
     * @param bool $optionsCspUpgradeInsecureRequests
     * @param bool $optionsEnableFeeds
     * @param bool $optionsReferrerPolicyOriginWhenCrossOrigin
     * @param bool $optionsRequireHttps
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $siteDomainPaths
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $siteIframeWhiteListUrls
     * @param string $siteType
     * @param string $status
     * @param string $subdomain
     * @param string $systemModstamp
     * @param string $urlPathPrefix
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\User $admin = null, $adminId = null, $analyticsTrackingCode = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null, $clickjackProtectionLevel = null, \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null, \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $dailyBandwidthLimit = null, $dailyBandwidthUsed = null, $dailyRequestTimeLimit = null, $dailyRequestTimeUsed = null, $description = null, \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity = null, \NexusDigital/MiratelForce\StructType\QueryResult $feeds = null, \NexusDigital/MiratelForce\StructType\User $guestUser = null, $guestUserId = null, \NexusDigital/MiratelForce\StructType\QueryResult $histories = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $masterLabel = null, $monthlyPageViewsEntitlement = null, $name = null, $optionsAllowGuestSupportApi = null, $optionsAllowHomePage = null, $optionsAllowStandardAnswersPages = null, $optionsAllowStandardIdeasPages = null, $optionsAllowStandardLookups = null, $optionsAllowStandardPortalPages = null, $optionsAllowStandardSearch = null, $optionsBrowserXssProtection = null, $optionsContentSniffingProtection = null, $optionsCspUpgradeInsecureRequests = null, $optionsEnableFeeds = null, $optionsReferrerPolicyOriginWhenCrossOrigin = null, $optionsRequireHttps = null, \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities = null, \NexusDigital/MiratelForce\StructType\QueryResult $siteDomainPaths = null, \NexusDigital/MiratelForce\StructType\QueryResult $siteIframeWhiteListUrls = null, $siteType = null, $status = null, $subdomain = null, $systemModstamp = null, $urlPathPrefix = null)
    {
        $this
            ->setAdmin($admin)
            ->setAdminId($adminId)
            ->setAnalyticsTrackingCode($analyticsTrackingCode)
            ->setAttachedContentDocuments($attachedContentDocuments)
            ->setAttachedContentNotes($attachedContentNotes)
            ->setClickjackProtectionLevel($clickjackProtectionLevel)
            ->setCombinedAttachments($combinedAttachments)
            ->setContentDocumentLinks($contentDocumentLinks)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDailyBandwidthLimit($dailyBandwidthLimit)
            ->setDailyBandwidthUsed($dailyBandwidthUsed)
            ->setDailyRequestTimeLimit($dailyRequestTimeLimit)
            ->setDailyRequestTimeUsed($dailyRequestTimeUsed)
            ->setDescription($description)
            ->setFeedSubscriptionsForEntity($feedSubscriptionsForEntity)
            ->setFeeds($feeds)
            ->setGuestUser($guestUser)
            ->setGuestUserId($guestUserId)
            ->setHistories($histories)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setMasterLabel($masterLabel)
            ->setMonthlyPageViewsEntitlement($monthlyPageViewsEntitlement)
            ->setName($name)
            ->setOptionsAllowGuestSupportApi($optionsAllowGuestSupportApi)
            ->setOptionsAllowHomePage($optionsAllowHomePage)
            ->setOptionsAllowStandardAnswersPages($optionsAllowStandardAnswersPages)
            ->setOptionsAllowStandardIdeasPages($optionsAllowStandardIdeasPages)
            ->setOptionsAllowStandardLookups($optionsAllowStandardLookups)
            ->setOptionsAllowStandardPortalPages($optionsAllowStandardPortalPages)
            ->setOptionsAllowStandardSearch($optionsAllowStandardSearch)
            ->setOptionsBrowserXssProtection($optionsBrowserXssProtection)
            ->setOptionsContentSniffingProtection($optionsContentSniffingProtection)
            ->setOptionsCspUpgradeInsecureRequests($optionsCspUpgradeInsecureRequests)
            ->setOptionsEnableFeeds($optionsEnableFeeds)
            ->setOptionsReferrerPolicyOriginWhenCrossOrigin($optionsReferrerPolicyOriginWhenCrossOrigin)
            ->setOptionsRequireHttps($optionsRequireHttps)
            ->setParentEntities($parentEntities)
            ->setSiteDomainPaths($siteDomainPaths)
            ->setSiteIframeWhiteListUrls($siteIframeWhiteListUrls)
            ->setSiteType($siteType)
            ->setStatus($status)
            ->setSubdomain($subdomain)
            ->setSystemModstamp($systemModstamp)
            ->setUrlPathPrefix($urlPathPrefix);
    }
    /**
     * Get Admin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getAdmin()
    {
        return isset($this->Admin) ? $this->Admin : null;
    }
    /**
     * Set Admin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $admin
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setAdmin(\NexusDigital/MiratelForce\StructType\User $admin = null)
    {
        if (is_null($admin) || (is_array($admin) && empty($admin))) {
            unset($this->Admin);
        } else {
            $this->Admin = $admin;
        }
        return $this;
    }
    /**
     * Get AdminId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdminId()
    {
        return isset($this->AdminId) ? $this->AdminId : null;
    }
    /**
     * Set AdminId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adminId
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setAdminId($adminId = null)
    {
        // validation for constraint: string
        if (!is_null($adminId) && !is_string($adminId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adminId, true), gettype($adminId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($adminId) && mb_strlen($adminId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($adminId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($adminId) && !preg_match('/[a-zA-Z0-9]{18}/', $adminId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($adminId, true)), __LINE__);
        }
        if (is_null($adminId) || (is_array($adminId) && empty($adminId))) {
            unset($this->AdminId);
        } else {
            $this->AdminId = $adminId;
        }
        return $this;
    }
    /**
     * Get AnalyticsTrackingCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnalyticsTrackingCode()
    {
        return isset($this->AnalyticsTrackingCode) ? $this->AnalyticsTrackingCode : null;
    }
    /**
     * Set AnalyticsTrackingCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $analyticsTrackingCode
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setAnalyticsTrackingCode($analyticsTrackingCode = null)
    {
        // validation for constraint: string
        if (!is_null($analyticsTrackingCode) && !is_string($analyticsTrackingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($analyticsTrackingCode, true), gettype($analyticsTrackingCode)), __LINE__);
        }
        if (is_null($analyticsTrackingCode) || (is_array($analyticsTrackingCode) && empty($analyticsTrackingCode))) {
            unset($this->AnalyticsTrackingCode);
        } else {
            $this->AnalyticsTrackingCode = $analyticsTrackingCode;
        }
        return $this;
    }
    /**
     * Get AttachedContentDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentDocuments()
    {
        return isset($this->AttachedContentDocuments) ? $this->AttachedContentDocuments : null;
    }
    /**
     * Set AttachedContentDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setAttachedContentDocuments(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null)
    {
        if (is_null($attachedContentDocuments) || (is_array($attachedContentDocuments) && empty($attachedContentDocuments))) {
            unset($this->AttachedContentDocuments);
        } else {
            $this->AttachedContentDocuments = $attachedContentDocuments;
        }
        return $this;
    }
    /**
     * Get AttachedContentNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentNotes()
    {
        return isset($this->AttachedContentNotes) ? $this->AttachedContentNotes : null;
    }
    /**
     * Set AttachedContentNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setAttachedContentNotes(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null)
    {
        if (is_null($attachedContentNotes) || (is_array($attachedContentNotes) && empty($attachedContentNotes))) {
            unset($this->AttachedContentNotes);
        } else {
            $this->AttachedContentNotes = $attachedContentNotes;
        }
        return $this;
    }
    /**
     * Get ClickjackProtectionLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClickjackProtectionLevel()
    {
        return isset($this->ClickjackProtectionLevel) ? $this->ClickjackProtectionLevel : null;
    }
    /**
     * Set ClickjackProtectionLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clickjackProtectionLevel
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setClickjackProtectionLevel($clickjackProtectionLevel = null)
    {
        // validation for constraint: string
        if (!is_null($clickjackProtectionLevel) && !is_string($clickjackProtectionLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clickjackProtectionLevel, true), gettype($clickjackProtectionLevel)), __LINE__);
        }
        if (is_null($clickjackProtectionLevel) || (is_array($clickjackProtectionLevel) && empty($clickjackProtectionLevel))) {
            unset($this->ClickjackProtectionLevel);
        } else {
            $this->ClickjackProtectionLevel = $clickjackProtectionLevel;
        }
        return $this;
    }
    /**
     * Get CombinedAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCombinedAttachments()
    {
        return isset($this->CombinedAttachments) ? $this->CombinedAttachments : null;
    }
    /**
     * Set CombinedAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setCombinedAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null)
    {
        if (is_null($combinedAttachments) || (is_array($combinedAttachments) && empty($combinedAttachments))) {
            unset($this->CombinedAttachments);
        } else {
            $this->CombinedAttachments = $combinedAttachments;
        }
        return $this;
    }
    /**
     * Get ContentDocumentLinks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContentDocumentLinks()
    {
        return isset($this->ContentDocumentLinks) ? $this->ContentDocumentLinks : null;
    }
    /**
     * Set ContentDocumentLinks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setContentDocumentLinks(\NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null)
    {
        if (is_null($contentDocumentLinks) || (is_array($contentDocumentLinks) && empty($contentDocumentLinks))) {
            unset($this->ContentDocumentLinks);
        } else {
            $this->ContentDocumentLinks = $contentDocumentLinks;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DailyBandwidthLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDailyBandwidthLimit()
    {
        return isset($this->DailyBandwidthLimit) ? $this->DailyBandwidthLimit : null;
    }
    /**
     * Set DailyBandwidthLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dailyBandwidthLimit
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setDailyBandwidthLimit($dailyBandwidthLimit = null)
    {
        // validation for constraint: int
        if (!is_null($dailyBandwidthLimit) && !(is_int($dailyBandwidthLimit) || ctype_digit($dailyBandwidthLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dailyBandwidthLimit, true), gettype($dailyBandwidthLimit)), __LINE__);
        }
        if (is_null($dailyBandwidthLimit) || (is_array($dailyBandwidthLimit) && empty($dailyBandwidthLimit))) {
            unset($this->DailyBandwidthLimit);
        } else {
            $this->DailyBandwidthLimit = $dailyBandwidthLimit;
        }
        return $this;
    }
    /**
     * Get DailyBandwidthUsed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDailyBandwidthUsed()
    {
        return isset($this->DailyBandwidthUsed) ? $this->DailyBandwidthUsed : null;
    }
    /**
     * Set DailyBandwidthUsed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dailyBandwidthUsed
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setDailyBandwidthUsed($dailyBandwidthUsed = null)
    {
        // validation for constraint: int
        if (!is_null($dailyBandwidthUsed) && !(is_int($dailyBandwidthUsed) || ctype_digit($dailyBandwidthUsed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dailyBandwidthUsed, true), gettype($dailyBandwidthUsed)), __LINE__);
        }
        if (is_null($dailyBandwidthUsed) || (is_array($dailyBandwidthUsed) && empty($dailyBandwidthUsed))) {
            unset($this->DailyBandwidthUsed);
        } else {
            $this->DailyBandwidthUsed = $dailyBandwidthUsed;
        }
        return $this;
    }
    /**
     * Get DailyRequestTimeLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDailyRequestTimeLimit()
    {
        return isset($this->DailyRequestTimeLimit) ? $this->DailyRequestTimeLimit : null;
    }
    /**
     * Set DailyRequestTimeLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dailyRequestTimeLimit
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setDailyRequestTimeLimit($dailyRequestTimeLimit = null)
    {
        // validation for constraint: int
        if (!is_null($dailyRequestTimeLimit) && !(is_int($dailyRequestTimeLimit) || ctype_digit($dailyRequestTimeLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dailyRequestTimeLimit, true), gettype($dailyRequestTimeLimit)), __LINE__);
        }
        if (is_null($dailyRequestTimeLimit) || (is_array($dailyRequestTimeLimit) && empty($dailyRequestTimeLimit))) {
            unset($this->DailyRequestTimeLimit);
        } else {
            $this->DailyRequestTimeLimit = $dailyRequestTimeLimit;
        }
        return $this;
    }
    /**
     * Get DailyRequestTimeUsed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDailyRequestTimeUsed()
    {
        return isset($this->DailyRequestTimeUsed) ? $this->DailyRequestTimeUsed : null;
    }
    /**
     * Set DailyRequestTimeUsed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dailyRequestTimeUsed
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setDailyRequestTimeUsed($dailyRequestTimeUsed = null)
    {
        // validation for constraint: int
        if (!is_null($dailyRequestTimeUsed) && !(is_int($dailyRequestTimeUsed) || ctype_digit($dailyRequestTimeUsed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dailyRequestTimeUsed, true), gettype($dailyRequestTimeUsed)), __LINE__);
        }
        if (is_null($dailyRequestTimeUsed) || (is_array($dailyRequestTimeUsed) && empty($dailyRequestTimeUsed))) {
            unset($this->DailyRequestTimeUsed);
        } else {
            $this->DailyRequestTimeUsed = $dailyRequestTimeUsed;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get FeedSubscriptionsForEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeedSubscriptionsForEntity()
    {
        return isset($this->FeedSubscriptionsForEntity) ? $this->FeedSubscriptionsForEntity : null;
    }
    /**
     * Set FeedSubscriptionsForEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setFeedSubscriptionsForEntity(\NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity = null)
    {
        if (is_null($feedSubscriptionsForEntity) || (is_array($feedSubscriptionsForEntity) && empty($feedSubscriptionsForEntity))) {
            unset($this->FeedSubscriptionsForEntity);
        } else {
            $this->FeedSubscriptionsForEntity = $feedSubscriptionsForEntity;
        }
        return $this;
    }
    /**
     * Get Feeds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeeds()
    {
        return isset($this->Feeds) ? $this->Feeds : null;
    }
    /**
     * Set Feeds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feeds
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setFeeds(\NexusDigital/MiratelForce\StructType\QueryResult $feeds = null)
    {
        if (is_null($feeds) || (is_array($feeds) && empty($feeds))) {
            unset($this->Feeds);
        } else {
            $this->Feeds = $feeds;
        }
        return $this;
    }
    /**
     * Get GuestUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getGuestUser()
    {
        return isset($this->GuestUser) ? $this->GuestUser : null;
    }
    /**
     * Set GuestUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $guestUser
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setGuestUser(\NexusDigital/MiratelForce\StructType\User $guestUser = null)
    {
        if (is_null($guestUser) || (is_array($guestUser) && empty($guestUser))) {
            unset($this->GuestUser);
        } else {
            $this->GuestUser = $guestUser;
        }
        return $this;
    }
    /**
     * Get GuestUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuestUserId()
    {
        return isset($this->GuestUserId) ? $this->GuestUserId : null;
    }
    /**
     * Set GuestUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guestUserId
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setGuestUserId($guestUserId = null)
    {
        // validation for constraint: string
        if (!is_null($guestUserId) && !is_string($guestUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestUserId, true), gettype($guestUserId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($guestUserId) && mb_strlen($guestUserId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($guestUserId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($guestUserId) && !preg_match('/[a-zA-Z0-9]{18}/', $guestUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($guestUserId, true)), __LINE__);
        }
        if (is_null($guestUserId) || (is_array($guestUserId) && empty($guestUserId))) {
            unset($this->GuestUserId);
        } else {
            $this->GuestUserId = $guestUserId;
        }
        return $this;
    }
    /**
     * Get Histories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getHistories()
    {
        return isset($this->Histories) ? $this->Histories : null;
    }
    /**
     * Set Histories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setHistories(\NexusDigital/MiratelForce\StructType\QueryResult $histories = null)
    {
        if (is_null($histories) || (is_array($histories) && empty($histories))) {
            unset($this->Histories);
        } else {
            $this->Histories = $histories;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get MasterLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterLabel()
    {
        return isset($this->MasterLabel) ? $this->MasterLabel : null;
    }
    /**
     * Set MasterLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterLabel
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setMasterLabel($masterLabel = null)
    {
        // validation for constraint: string
        if (!is_null($masterLabel) && !is_string($masterLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterLabel, true), gettype($masterLabel)), __LINE__);
        }
        if (is_null($masterLabel) || (is_array($masterLabel) && empty($masterLabel))) {
            unset($this->MasterLabel);
        } else {
            $this->MasterLabel = $masterLabel;
        }
        return $this;
    }
    /**
     * Get MonthlyPageViewsEntitlement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMonthlyPageViewsEntitlement()
    {
        return isset($this->MonthlyPageViewsEntitlement) ? $this->MonthlyPageViewsEntitlement : null;
    }
    /**
     * Set MonthlyPageViewsEntitlement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $monthlyPageViewsEntitlement
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setMonthlyPageViewsEntitlement($monthlyPageViewsEntitlement = null)
    {
        // validation for constraint: int
        if (!is_null($monthlyPageViewsEntitlement) && !(is_int($monthlyPageViewsEntitlement) || ctype_digit($monthlyPageViewsEntitlement))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($monthlyPageViewsEntitlement, true), gettype($monthlyPageViewsEntitlement)), __LINE__);
        }
        if (is_null($monthlyPageViewsEntitlement) || (is_array($monthlyPageViewsEntitlement) && empty($monthlyPageViewsEntitlement))) {
            unset($this->MonthlyPageViewsEntitlement);
        } else {
            $this->MonthlyPageViewsEntitlement = $monthlyPageViewsEntitlement;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OptionsAllowGuestSupportApi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsAllowGuestSupportApi()
    {
        return isset($this->OptionsAllowGuestSupportApi) ? $this->OptionsAllowGuestSupportApi : null;
    }
    /**
     * Set OptionsAllowGuestSupportApi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsAllowGuestSupportApi
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setOptionsAllowGuestSupportApi($optionsAllowGuestSupportApi = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsAllowGuestSupportApi) && !is_bool($optionsAllowGuestSupportApi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsAllowGuestSupportApi, true), gettype($optionsAllowGuestSupportApi)), __LINE__);
        }
        if (is_null($optionsAllowGuestSupportApi) || (is_array($optionsAllowGuestSupportApi) && empty($optionsAllowGuestSupportApi))) {
            unset($this->OptionsAllowGuestSupportApi);
        } else {
            $this->OptionsAllowGuestSupportApi = $optionsAllowGuestSupportApi;
        }
        return $this;
    }
    /**
     * Get OptionsAllowHomePage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsAllowHomePage()
    {
        return isset($this->OptionsAllowHomePage) ? $this->OptionsAllowHomePage : null;
    }
    /**
     * Set OptionsAllowHomePage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsAllowHomePage
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setOptionsAllowHomePage($optionsAllowHomePage = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsAllowHomePage) && !is_bool($optionsAllowHomePage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsAllowHomePage, true), gettype($optionsAllowHomePage)), __LINE__);
        }
        if (is_null($optionsAllowHomePage) || (is_array($optionsAllowHomePage) && empty($optionsAllowHomePage))) {
            unset($this->OptionsAllowHomePage);
        } else {
            $this->OptionsAllowHomePage = $optionsAllowHomePage;
        }
        return $this;
    }
    /**
     * Get OptionsAllowStandardAnswersPages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsAllowStandardAnswersPages()
    {
        return isset($this->OptionsAllowStandardAnswersPages) ? $this->OptionsAllowStandardAnswersPages : null;
    }
    /**
     * Set OptionsAllowStandardAnswersPages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsAllowStandardAnswersPages
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setOptionsAllowStandardAnswersPages($optionsAllowStandardAnswersPages = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsAllowStandardAnswersPages) && !is_bool($optionsAllowStandardAnswersPages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsAllowStandardAnswersPages, true), gettype($optionsAllowStandardAnswersPages)), __LINE__);
        }
        if (is_null($optionsAllowStandardAnswersPages) || (is_array($optionsAllowStandardAnswersPages) && empty($optionsAllowStandardAnswersPages))) {
            unset($this->OptionsAllowStandardAnswersPages);
        } else {
            $this->OptionsAllowStandardAnswersPages = $optionsAllowStandardAnswersPages;
        }
        return $this;
    }
    /**
     * Get OptionsAllowStandardIdeasPages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsAllowStandardIdeasPages()
    {
        return isset($this->OptionsAllowStandardIdeasPages) ? $this->OptionsAllowStandardIdeasPages : null;
    }
    /**
     * Set OptionsAllowStandardIdeasPages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsAllowStandardIdeasPages
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setOptionsAllowStandardIdeasPages($optionsAllowStandardIdeasPages = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsAllowStandardIdeasPages) && !is_bool($optionsAllowStandardIdeasPages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsAllowStandardIdeasPages, true), gettype($optionsAllowStandardIdeasPages)), __LINE__);
        }
        if (is_null($optionsAllowStandardIdeasPages) || (is_array($optionsAllowStandardIdeasPages) && empty($optionsAllowStandardIdeasPages))) {
            unset($this->OptionsAllowStandardIdeasPages);
        } else {
            $this->OptionsAllowStandardIdeasPages = $optionsAllowStandardIdeasPages;
        }
        return $this;
    }
    /**
     * Get OptionsAllowStandardLookups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsAllowStandardLookups()
    {
        return isset($this->OptionsAllowStandardLookups) ? $this->OptionsAllowStandardLookups : null;
    }
    /**
     * Set OptionsAllowStandardLookups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsAllowStandardLookups
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setOptionsAllowStandardLookups($optionsAllowStandardLookups = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsAllowStandardLookups) && !is_bool($optionsAllowStandardLookups)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsAllowStandardLookups, true), gettype($optionsAllowStandardLookups)), __LINE__);
        }
        if (is_null($optionsAllowStandardLookups) || (is_array($optionsAllowStandardLookups) && empty($optionsAllowStandardLookups))) {
            unset($this->OptionsAllowStandardLookups);
        } else {
            $this->OptionsAllowStandardLookups = $optionsAllowStandardLookups;
        }
        return $this;
    }
    /**
     * Get OptionsAllowStandardPortalPages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsAllowStandardPortalPages()
    {
        return isset($this->OptionsAllowStandardPortalPages) ? $this->OptionsAllowStandardPortalPages : null;
    }
    /**
     * Set OptionsAllowStandardPortalPages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsAllowStandardPortalPages
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setOptionsAllowStandardPortalPages($optionsAllowStandardPortalPages = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsAllowStandardPortalPages) && !is_bool($optionsAllowStandardPortalPages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsAllowStandardPortalPages, true), gettype($optionsAllowStandardPortalPages)), __LINE__);
        }
        if (is_null($optionsAllowStandardPortalPages) || (is_array($optionsAllowStandardPortalPages) && empty($optionsAllowStandardPortalPages))) {
            unset($this->OptionsAllowStandardPortalPages);
        } else {
            $this->OptionsAllowStandardPortalPages = $optionsAllowStandardPortalPages;
        }
        return $this;
    }
    /**
     * Get OptionsAllowStandardSearch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsAllowStandardSearch()
    {
        return isset($this->OptionsAllowStandardSearch) ? $this->OptionsAllowStandardSearch : null;
    }
    /**
     * Set OptionsAllowStandardSearch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsAllowStandardSearch
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setOptionsAllowStandardSearch($optionsAllowStandardSearch = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsAllowStandardSearch) && !is_bool($optionsAllowStandardSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsAllowStandardSearch, true), gettype($optionsAllowStandardSearch)), __LINE__);
        }
        if (is_null($optionsAllowStandardSearch) || (is_array($optionsAllowStandardSearch) && empty($optionsAllowStandardSearch))) {
            unset($this->OptionsAllowStandardSearch);
        } else {
            $this->OptionsAllowStandardSearch = $optionsAllowStandardSearch;
        }
        return $this;
    }
    /**
     * Get OptionsBrowserXssProtection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsBrowserXssProtection()
    {
        return isset($this->OptionsBrowserXssProtection) ? $this->OptionsBrowserXssProtection : null;
    }
    /**
     * Set OptionsBrowserXssProtection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsBrowserXssProtection
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setOptionsBrowserXssProtection($optionsBrowserXssProtection = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsBrowserXssProtection) && !is_bool($optionsBrowserXssProtection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsBrowserXssProtection, true), gettype($optionsBrowserXssProtection)), __LINE__);
        }
        if (is_null($optionsBrowserXssProtection) || (is_array($optionsBrowserXssProtection) && empty($optionsBrowserXssProtection))) {
            unset($this->OptionsBrowserXssProtection);
        } else {
            $this->OptionsBrowserXssProtection = $optionsBrowserXssProtection;
        }
        return $this;
    }
    /**
     * Get OptionsContentSniffingProtection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsContentSniffingProtection()
    {
        return isset($this->OptionsContentSniffingProtection) ? $this->OptionsContentSniffingProtection : null;
    }
    /**
     * Set OptionsContentSniffingProtection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsContentSniffingProtection
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setOptionsContentSniffingProtection($optionsContentSniffingProtection = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsContentSniffingProtection) && !is_bool($optionsContentSniffingProtection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsContentSniffingProtection, true), gettype($optionsContentSniffingProtection)), __LINE__);
        }
        if (is_null($optionsContentSniffingProtection) || (is_array($optionsContentSniffingProtection) && empty($optionsContentSniffingProtection))) {
            unset($this->OptionsContentSniffingProtection);
        } else {
            $this->OptionsContentSniffingProtection = $optionsContentSniffingProtection;
        }
        return $this;
    }
    /**
     * Get OptionsCspUpgradeInsecureRequests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsCspUpgradeInsecureRequests()
    {
        return isset($this->OptionsCspUpgradeInsecureRequests) ? $this->OptionsCspUpgradeInsecureRequests : null;
    }
    /**
     * Set OptionsCspUpgradeInsecureRequests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsCspUpgradeInsecureRequests
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setOptionsCspUpgradeInsecureRequests($optionsCspUpgradeInsecureRequests = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsCspUpgradeInsecureRequests) && !is_bool($optionsCspUpgradeInsecureRequests)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsCspUpgradeInsecureRequests, true), gettype($optionsCspUpgradeInsecureRequests)), __LINE__);
        }
        if (is_null($optionsCspUpgradeInsecureRequests) || (is_array($optionsCspUpgradeInsecureRequests) && empty($optionsCspUpgradeInsecureRequests))) {
            unset($this->OptionsCspUpgradeInsecureRequests);
        } else {
            $this->OptionsCspUpgradeInsecureRequests = $optionsCspUpgradeInsecureRequests;
        }
        return $this;
    }
    /**
     * Get OptionsEnableFeeds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsEnableFeeds()
    {
        return isset($this->OptionsEnableFeeds) ? $this->OptionsEnableFeeds : null;
    }
    /**
     * Set OptionsEnableFeeds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsEnableFeeds
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setOptionsEnableFeeds($optionsEnableFeeds = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsEnableFeeds) && !is_bool($optionsEnableFeeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsEnableFeeds, true), gettype($optionsEnableFeeds)), __LINE__);
        }
        if (is_null($optionsEnableFeeds) || (is_array($optionsEnableFeeds) && empty($optionsEnableFeeds))) {
            unset($this->OptionsEnableFeeds);
        } else {
            $this->OptionsEnableFeeds = $optionsEnableFeeds;
        }
        return $this;
    }
    /**
     * Get OptionsReferrerPolicyOriginWhenCrossOrigin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsReferrerPolicyOriginWhenCrossOrigin()
    {
        return isset($this->OptionsReferrerPolicyOriginWhenCrossOrigin) ? $this->OptionsReferrerPolicyOriginWhenCrossOrigin : null;
    }
    /**
     * Set OptionsReferrerPolicyOriginWhenCrossOrigin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsReferrerPolicyOriginWhenCrossOrigin
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setOptionsReferrerPolicyOriginWhenCrossOrigin($optionsReferrerPolicyOriginWhenCrossOrigin = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsReferrerPolicyOriginWhenCrossOrigin) && !is_bool($optionsReferrerPolicyOriginWhenCrossOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsReferrerPolicyOriginWhenCrossOrigin, true), gettype($optionsReferrerPolicyOriginWhenCrossOrigin)), __LINE__);
        }
        if (is_null($optionsReferrerPolicyOriginWhenCrossOrigin) || (is_array($optionsReferrerPolicyOriginWhenCrossOrigin) && empty($optionsReferrerPolicyOriginWhenCrossOrigin))) {
            unset($this->OptionsReferrerPolicyOriginWhenCrossOrigin);
        } else {
            $this->OptionsReferrerPolicyOriginWhenCrossOrigin = $optionsReferrerPolicyOriginWhenCrossOrigin;
        }
        return $this;
    }
    /**
     * Get OptionsRequireHttps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsRequireHttps()
    {
        return isset($this->OptionsRequireHttps) ? $this->OptionsRequireHttps : null;
    }
    /**
     * Set OptionsRequireHttps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsRequireHttps
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setOptionsRequireHttps($optionsRequireHttps = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsRequireHttps) && !is_bool($optionsRequireHttps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsRequireHttps, true), gettype($optionsRequireHttps)), __LINE__);
        }
        if (is_null($optionsRequireHttps) || (is_array($optionsRequireHttps) && empty($optionsRequireHttps))) {
            unset($this->OptionsRequireHttps);
        } else {
            $this->OptionsRequireHttps = $optionsRequireHttps;
        }
        return $this;
    }
    /**
     * Get ParentEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getParentEntities()
    {
        return isset($this->ParentEntities) ? $this->ParentEntities : null;
    }
    /**
     * Set ParentEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setParentEntities(\NexusDigital/MiratelForce\StructType\QueryResult $parentEntities = null)
    {
        if (is_null($parentEntities) || (is_array($parentEntities) && empty($parentEntities))) {
            unset($this->ParentEntities);
        } else {
            $this->ParentEntities = $parentEntities;
        }
        return $this;
    }
    /**
     * Get SiteDomainPaths value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getSiteDomainPaths()
    {
        return isset($this->SiteDomainPaths) ? $this->SiteDomainPaths : null;
    }
    /**
     * Set SiteDomainPaths value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $siteDomainPaths
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setSiteDomainPaths(\NexusDigital/MiratelForce\StructType\QueryResult $siteDomainPaths = null)
    {
        if (is_null($siteDomainPaths) || (is_array($siteDomainPaths) && empty($siteDomainPaths))) {
            unset($this->SiteDomainPaths);
        } else {
            $this->SiteDomainPaths = $siteDomainPaths;
        }
        return $this;
    }
    /**
     * Get SiteIframeWhiteListUrls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getSiteIframeWhiteListUrls()
    {
        return isset($this->SiteIframeWhiteListUrls) ? $this->SiteIframeWhiteListUrls : null;
    }
    /**
     * Set SiteIframeWhiteListUrls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $siteIframeWhiteListUrls
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setSiteIframeWhiteListUrls(\NexusDigital/MiratelForce\StructType\QueryResult $siteIframeWhiteListUrls = null)
    {
        if (is_null($siteIframeWhiteListUrls) || (is_array($siteIframeWhiteListUrls) && empty($siteIframeWhiteListUrls))) {
            unset($this->SiteIframeWhiteListUrls);
        } else {
            $this->SiteIframeWhiteListUrls = $siteIframeWhiteListUrls;
        }
        return $this;
    }
    /**
     * Get SiteType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteType()
    {
        return isset($this->SiteType) ? $this->SiteType : null;
    }
    /**
     * Set SiteType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteType
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setSiteType($siteType = null)
    {
        // validation for constraint: string
        if (!is_null($siteType) && !is_string($siteType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteType, true), gettype($siteType)), __LINE__);
        }
        if (is_null($siteType) || (is_array($siteType) && empty($siteType))) {
            unset($this->SiteType);
        } else {
            $this->SiteType = $siteType;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Subdomain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubdomain()
    {
        return isset($this->Subdomain) ? $this->Subdomain : null;
    }
    /**
     * Set Subdomain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subdomain
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setSubdomain($subdomain = null)
    {
        // validation for constraint: string
        if (!is_null($subdomain) && !is_string($subdomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subdomain, true), gettype($subdomain)), __LINE__);
        }
        if (is_null($subdomain) || (is_array($subdomain) && empty($subdomain))) {
            unset($this->Subdomain);
        } else {
            $this->Subdomain = $subdomain;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get UrlPathPrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrlPathPrefix()
    {
        return isset($this->UrlPathPrefix) ? $this->UrlPathPrefix : null;
    }
    /**
     * Set UrlPathPrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $urlPathPrefix
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public function setUrlPathPrefix($urlPathPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($urlPathPrefix) && !is_string($urlPathPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlPathPrefix, true), gettype($urlPathPrefix)), __LINE__);
        }
        if (is_null($urlPathPrefix) || (is_array($urlPathPrefix) && empty($urlPathPrefix))) {
            unset($this->UrlPathPrefix);
        } else {
            $this->UrlPathPrefix = $urlPathPrefix;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\Site
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
