<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchRecord StructType
 * @subpackage Structs
 */
class SearchRecord extends AbstractStructBase
{
    /**
     * The record
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $record;
    /**
     * The searchRecordMetadata
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \NexusDigital/MiratelForce\StructType\SearchRecordMetadata
     */
    public $searchRecordMetadata;
    /**
     * The snippet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SearchSnippet
     */
    public $snippet;
    /**
     * Constructor method for SearchRecord
     * @uses SearchRecord::setRecord()
     * @uses SearchRecord::setSearchRecordMetadata()
     * @uses SearchRecord::setSnippet()
     * @param \NexusDigital/MiratelForce\StructType\SObject $record
     * @param \NexusDigital/MiratelForce\StructType\SearchRecordMetadata $searchRecordMetadata
     * @param \NexusDigital/MiratelForce\StructType\SearchSnippet $snippet
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\SObject $record = null, \NexusDigital/MiratelForce\StructType\SearchRecordMetadata $searchRecordMetadata = null, \NexusDigital/MiratelForce\StructType\SearchSnippet $snippet = null)
    {
        $this
            ->setRecord($record)
            ->setSearchRecordMetadata($searchRecordMetadata)
            ->setSnippet($snippet);
    }
    /**
     * Get record value
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getRecord()
    {
        return $this->record;
    }
    /**
     * Set record value
     * @param \NexusDigital/MiratelForce\StructType\SObject $record
     * @return \NexusDigital/MiratelForce\StructType\SearchRecord
     */
    public function setRecord(\NexusDigital/MiratelForce\StructType\SObject $record = null)
    {
        $this->record = $record;
        return $this;
    }
    /**
     * Get searchRecordMetadata value
     * @return \NexusDigital/MiratelForce\StructType\SearchRecordMetadata|null
     */
    public function getSearchRecordMetadata()
    {
        return $this->searchRecordMetadata;
    }
    /**
     * Set searchRecordMetadata value
     * @param \NexusDigital/MiratelForce\StructType\SearchRecordMetadata $searchRecordMetadata
     * @return \NexusDigital/MiratelForce\StructType\SearchRecord
     */
    public function setSearchRecordMetadata(\NexusDigital/MiratelForce\StructType\SearchRecordMetadata $searchRecordMetadata = null)
    {
        $this->searchRecordMetadata = $searchRecordMetadata;
        return $this;
    }
    /**
     * Get snippet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SearchSnippet|null
     */
    public function getSnippet()
    {
        return isset($this->snippet) ? $this->snippet : null;
    }
    /**
     * Set snippet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SearchSnippet $snippet
     * @return \NexusDigital/MiratelForce\StructType\SearchRecord
     */
    public function setSnippet(\NexusDigital/MiratelForce\StructType\SearchSnippet $snippet = null)
    {
        if (is_null($snippet) || (is_array($snippet) && empty($snippet))) {
            unset($this->snippet);
        } else {
            $this->snippet = $snippet;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\SearchRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
